// third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-params-data.h"
#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/loader/resource_load_info_notifier.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_NOTIFIER_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_RESOURCE_LOAD_INFO_NOTIFIER_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
const char ResourceLoadInfoNotifier::Name_[] = "blink.mojom.ResourceLoadInfoNotifier";

ResourceLoadInfoNotifierProxy::ResourceLoadInfoNotifierProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void ResourceLoadInfoNotifierProxy::NotifyResourceRedirectReceived(
    const ::net::RedirectInfo& in_redirect_info, ::network::mojom::URLResponseHeadPtr in_redirect_response) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ResourceLoadInfoNotifier::NotifyResourceRedirectReceived", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("redirect_info", base::trace_event::ValueToString(in_redirect_info, "<value of type const ::net::RedirectInfo&>"));
      if (in_redirect_response.is_null()) {
        raw_value->SetString("redirect_response", "nullptr");
      } else {
        raw_value->BeginDictionary("redirect_response");
        in_redirect_response->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->redirect_info)::BaseType::BufferWriter
      redirect_info_writer;
  mojo::internal::Serialize<::network::mojom::URLRequestRedirectInfoDataView>(
      in_redirect_info, buffer, &redirect_info_writer, &serialization_context);
  params->redirect_info.Set(
      redirect_info_writer.is_null() ? nullptr : redirect_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->redirect_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null redirect_info in ResourceLoadInfoNotifier.NotifyResourceRedirectReceived request");
  typename decltype(params->redirect_response)::BaseType::BufferWriter
      redirect_response_writer;
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_redirect_response, buffer, &redirect_response_writer, &serialization_context);
  params->redirect_response.Set(
      redirect_response_writer.is_null() ? nullptr : redirect_response_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->redirect_response.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null redirect_response in ResourceLoadInfoNotifier.NotifyResourceRedirectReceived request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceRedirectReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResourceLoadInfoNotifierProxy::NotifyResourceResponseReceived(
    ::blink::mojom::ResourceLoadInfoPtr in_resource_load_info, ::network::mojom::URLResponseHeadPtr in_head, int32_t in_previews_state) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ResourceLoadInfoNotifier::NotifyResourceResponseReceived", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_resource_load_info.is_null()) {
        raw_value->SetString("resource_load_info", "nullptr");
      } else {
        raw_value->BeginDictionary("resource_load_info");
        in_resource_load_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      if (in_head.is_null()) {
        raw_value->SetString("head", "nullptr");
      } else {
        raw_value->BeginDictionary("head");
        in_head->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetInteger("previews_state", in_previews_state);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kResourceLoadInfoNotifier_NotifyResourceResponseReceived_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->resource_load_info)::BaseType::BufferWriter
      resource_load_info_writer;
  mojo::internal::Serialize<::blink::mojom::ResourceLoadInfoDataView>(
      in_resource_load_info, buffer, &resource_load_info_writer, &serialization_context);
  params->resource_load_info.Set(
      resource_load_info_writer.is_null() ? nullptr : resource_load_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resource_load_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resource_load_info in ResourceLoadInfoNotifier.NotifyResourceResponseReceived request");
  typename decltype(params->head)::BaseType::BufferWriter
      head_writer;
  mojo::internal::Serialize<::network::mojom::URLResponseHeadDataView>(
      in_head, buffer, &head_writer, &serialization_context);
  params->head.Set(
      head_writer.is_null() ? nullptr : head_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->head.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null head in ResourceLoadInfoNotifier.NotifyResourceResponseReceived request");
  params->previews_state = in_previews_state;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceResponseReceived");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResourceLoadInfoNotifierProxy::NotifyResourceTransferSizeUpdated(
    int32_t in_request_id, int32_t in_transfer_size_diff) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ResourceLoadInfoNotifier::NotifyResourceTransferSizeUpdated", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("request_id", in_request_id);
      raw_value->SetInteger("transfer_size_diff", in_transfer_size_diff);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->request_id = in_request_id;
  params->transfer_size_diff = in_transfer_size_diff;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceTransferSizeUpdated");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResourceLoadInfoNotifierProxy::NotifyResourceLoadCompleted(
    ::blink::mojom::ResourceLoadInfoPtr in_resource_load_info, const ::network::URLLoaderCompletionStatus& in_status) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCompleted", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      if (in_resource_load_info.is_null()) {
        raw_value->SetString("resource_load_info", "nullptr");
      } else {
        raw_value->BeginDictionary("resource_load_info");
        in_resource_load_info->AsValueInto(raw_value);
        raw_value->EndDictionary();
      }
      raw_value->SetString("status", base::trace_event::ValueToString(in_status, "<value of type const ::network::URLLoaderCompletionStatus&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->resource_load_info)::BaseType::BufferWriter
      resource_load_info_writer;
  mojo::internal::Serialize<::blink::mojom::ResourceLoadInfoDataView>(
      in_resource_load_info, buffer, &resource_load_info_writer, &serialization_context);
  params->resource_load_info.Set(
      resource_load_info_writer.is_null() ? nullptr : resource_load_info_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->resource_load_info.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null resource_load_info in ResourceLoadInfoNotifier.NotifyResourceLoadCompleted request");
  typename decltype(params->status)::BaseType::BufferWriter
      status_writer;
  mojo::internal::Serialize<::network::mojom::URLLoaderCompletionStatusDataView>(
      in_status, buffer, &status_writer, &serialization_context);
  params->status.Set(
      status_writer.is_null() ? nullptr : status_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->status.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null status in ResourceLoadInfoNotifier.NotifyResourceLoadCompleted request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceLoadCompleted");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResourceLoadInfoNotifierProxy::NotifyResourceLoadCanceled(
    int32_t in_request_id) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCanceled", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetInteger("request_id", in_request_id);
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  params->request_id = in_request_id;
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("NotifyResourceLoadCanceled");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void ResourceLoadInfoNotifierProxy::Clone(
    ::mojo::PendingReceiver<ResourceLoadInfoNotifier> in_pending_resource_load_info_notifier) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::ResourceLoadInfoNotifier::Clone", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("pending_resource_load_info_notifier", in_pending_resource_load_info_notifier.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kResourceLoadInfoNotifier_Clone_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::ResourceLoadInfoNotifier_Clone_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::blink::mojom::ResourceLoadInfoNotifierInterfaceBase>>(
      in_pending_resource_load_info_notifier, &params->pending_resource_load_info_notifier, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->pending_resource_load_info_notifier),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid pending_resource_load_info_notifier in ResourceLoadInfoNotifier.Clone request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(ResourceLoadInfoNotifier::Name_);
  message.set_method_name("Clone");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool ResourceLoadInfoNotifierStubDispatch::Accept(
    ResourceLoadInfoNotifier* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceRedirectReceived",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceRedirectReceived");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::net::RedirectInfo p_redirect_info{};
      ::network::mojom::URLResponseHeadPtr p_redirect_response{};
      ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadRedirectInfo(&p_redirect_info))
        success = false;
      if (success && !input_data_view.ReadRedirectResponse(&p_redirect_response))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceRedirectReceived(
std::move(p_redirect_info), 
std::move(p_redirect_response));
      return true;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceResponseReceived_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceResponseReceived",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceResponseReceived");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ResourceLoadInfoPtr p_resource_load_info{};
      ::network::mojom::URLResponseHeadPtr p_head{};
      int32_t p_previews_state{};
      ResourceLoadInfoNotifier_NotifyResourceResponseReceived_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadResourceLoadInfo(&p_resource_load_info))
        success = false;
      if (success && !input_data_view.ReadHead(&p_head))
        success = false;
      if (success)
        p_previews_state = input_data_view.previews_state();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceResponseReceived(
std::move(p_resource_load_info), 
std::move(p_head), 
std::move(p_previews_state));
      return true;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceTransferSizeUpdated",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceTransferSizeUpdated");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_request_id{};
      int32_t p_transfer_size_diff{};
      ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (success)
        p_transfer_size_diff = input_data_view.transfer_size_diff();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 2, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceTransferSizeUpdated(
std::move(p_request_id), 
std::move(p_transfer_size_diff));
      return true;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCompleted",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCompleted");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::blink::mojom::ResourceLoadInfoPtr p_resource_load_info{};
      ::network::URLLoaderCompletionStatus p_status{};
      ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadResourceLoadInfo(&p_resource_load_info))
        success = false;
      if (success && !input_data_view.ReadStatus(&p_status))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 3, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceLoadCompleted(
std::move(p_resource_load_info), 
std::move(p_status));
      return true;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCanceled",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ResourceLoadInfoNotifier::NotifyResourceLoadCanceled");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      int32_t p_request_id{};
      ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success)
        p_request_id = input_data_view.request_id();
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 4, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->NotifyResourceLoadCanceled(
std::move(p_request_id));
      return true;
    }
    case internal::kResourceLoadInfoNotifier_Clone_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::ResourceLoadInfoNotifier::Clone",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::ResourceLoadInfoNotifier::Clone");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::ResourceLoadInfoNotifier_Clone_Params_Data* params =
          reinterpret_cast<internal::ResourceLoadInfoNotifier_Clone_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<ResourceLoadInfoNotifier> p_pending_resource_load_info_notifier{};
      ResourceLoadInfoNotifier_Clone_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_pending_resource_load_info_notifier =
            input_data_view.TakePendingResourceLoadInfoNotifier<decltype(p_pending_resource_load_info_notifier)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            ResourceLoadInfoNotifier::Name_, 5, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->Clone(
std::move(p_pending_resource_load_info_notifier));
      return true;
    }
  }
  return false;
}

// static
bool ResourceLoadInfoNotifierStubDispatch::AcceptWithResponder(
    ResourceLoadInfoNotifier* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Name: {
      break;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceResponseReceived_Name: {
      break;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Name: {
      break;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Name: {
      break;
    }
    case internal::kResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Name: {
      break;
    }
    case internal::kResourceLoadInfoNotifier_Clone_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kResourceLoadInfoNotifierValidationInfo[] = {
    {&internal::ResourceLoadInfoNotifier_NotifyResourceRedirectReceived_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ResourceLoadInfoNotifier_NotifyResourceResponseReceived_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ResourceLoadInfoNotifier_NotifyResourceTransferSizeUpdated_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ResourceLoadInfoNotifier_NotifyResourceLoadCompleted_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ResourceLoadInfoNotifier_NotifyResourceLoadCanceled_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::ResourceLoadInfoNotifier_Clone_Params_Data::Validate,
     nullptr /* no response */},
};

bool ResourceLoadInfoNotifierRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::ResourceLoadInfoNotifier::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kResourceLoadInfoNotifierValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif