// third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_CLIENT_SETTINGS_OBJECT_MOJOM_SHARED_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_CLIENT_SETTINGS_OBJECT_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "third_party/blink/public/mojom/loader/fetch_client_settings_object.mojom-shared-internal.h"
#include "url/mojom/url.mojom-shared.h"
#include "services/network/public/mojom/referrer_policy.mojom-shared.h"



#include "base/component_export.h"




namespace blink {
namespace mojom {
class FetchClientSettingsObjectDataView;



}  // namespace mojom
}  // namespace blink

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::blink::mojom::FetchClientSettingsObjectDataView> {
  using Data = ::blink::mojom::internal::FetchClientSettingsObject_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace blink {
namespace mojom {


enum class InsecureRequestsPolicy : int32_t {
  
  kDoNotUpgrade = 0,
  
  kUpgrade = 1,
  kMinValue = 0,
  kMaxValue = 1,
};

COMPONENT_EXPORT(MOJOM_SHARED_BLINK_COMMON_EXPORT) std::ostream& operator<<(std::ostream& os, InsecureRequestsPolicy value);
inline bool IsKnownEnumValue(InsecureRequestsPolicy value) {
  return internal::InsecureRequestsPolicy_Data::IsKnownValue(
      static_cast<int32_t>(value));
}


class FetchClientSettingsObjectDataView {
 public:
  FetchClientSettingsObjectDataView() {}

  FetchClientSettingsObjectDataView(
      internal::FetchClientSettingsObject_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadReferrerPolicy(UserType* output) const {
    auto data_value = data_->referrer_policy;
    return mojo::internal::Deserialize<::network::mojom::ReferrerPolicy>(
        data_value, output);
  }

  ::network::mojom::ReferrerPolicy referrer_policy() const {
    return static_cast<::network::mojom::ReferrerPolicy>(data_->referrer_policy);
  }
  inline void GetOutgoingReferrerDataView(
      ::url::mojom::UrlDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadOutgoingReferrer(UserType* output) {
    
    auto* pointer = data_->outgoing_referrer.Get();
    return mojo::internal::Deserialize<::url::mojom::UrlDataView>(
        pointer, output, context_);
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadInsecureRequestsPolicy(UserType* output) const {
    auto data_value = data_->insecure_requests_policy;
    return mojo::internal::Deserialize<::blink::mojom::InsecureRequestsPolicy>(
        data_value, output);
  }

  InsecureRequestsPolicy insecure_requests_policy() const {
    return static_cast<InsecureRequestsPolicy>(data_->insecure_requests_policy);
  }
 private:
  internal::FetchClientSettingsObject_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace blink

namespace std {

template <>
struct hash<::blink::mojom::InsecureRequestsPolicy>
    : public mojo::internal::EnumHashImpl<::blink::mojom::InsecureRequestsPolicy> {};

}  // namespace std

namespace mojo {


template <>
struct EnumTraits<::blink::mojom::InsecureRequestsPolicy, ::blink::mojom::InsecureRequestsPolicy> {
  static ::blink::mojom::InsecureRequestsPolicy ToMojom(::blink::mojom::InsecureRequestsPolicy input) { return input; }
  static bool FromMojom(::blink::mojom::InsecureRequestsPolicy input, ::blink::mojom::InsecureRequestsPolicy* output) {
    *output = input;
    return true;
  }
};

namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::InsecureRequestsPolicy, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = EnumTraits<::blink::mojom::InsecureRequestsPolicy, UserType>;

  static void Serialize(UserType input, int32_t* output) {
    *output = static_cast<int32_t>(Traits::ToMojom(input));
  }

  static bool Deserialize(int32_t input, UserType* output) {
    return Traits::FromMojom(static_cast<::blink::mojom::InsecureRequestsPolicy>(input), output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::blink::mojom::FetchClientSettingsObjectDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::blink::mojom::FetchClientSettingsObjectDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::blink::mojom::internal::FetchClientSettingsObject_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    mojo::internal::Serialize<::network::mojom::ReferrerPolicy>(
        Traits::referrer_policy(input), &(*output)->referrer_policy);
    decltype(Traits::outgoing_referrer(input)) in_outgoing_referrer = Traits::outgoing_referrer(input);
    typename decltype((*output)->outgoing_referrer)::BaseType::BufferWriter
        outgoing_referrer_writer;
    mojo::internal::Serialize<::url::mojom::UrlDataView>(
        in_outgoing_referrer, buffer, &outgoing_referrer_writer, context);
    (*output)->outgoing_referrer.Set(
        outgoing_referrer_writer.is_null() ? nullptr : outgoing_referrer_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->outgoing_referrer.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null outgoing_referrer in FetchClientSettingsObject struct");
    mojo::internal::Serialize<::blink::mojom::InsecureRequestsPolicy>(
        Traits::insecure_requests_policy(input), &(*output)->insecure_requests_policy);
  }

  static bool Deserialize(::blink::mojom::internal::FetchClientSettingsObject_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::blink::mojom::FetchClientSettingsObjectDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace blink {
namespace mojom {

inline void FetchClientSettingsObjectDataView::GetOutgoingReferrerDataView(
    ::url::mojom::UrlDataView* output) {
  auto pointer = data_->outgoing_referrer.Get();
  *output = ::url::mojom::UrlDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace blink

#endif  // THIRD_PARTY_BLINK_PUBLIC_MOJOM_LOADER_FETCH_CLIENT_SETTINGS_OBJECT_MOJOM_SHARED_H_