// third_party/blink/public/mojom/badging/badging.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "third_party/blink/public/mojom/badging/badging.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "third_party/blink/public/mojom/badging/badging.mojom-params-data.h"
#include "third_party/blink/public/mojom/badging/badging.mojom-shared-message-ids.h"

#include "third_party/blink/public/mojom/badging/badging.mojom-import-headers.h"


#ifndef THIRD_PARTY_BLINK_PUBLIC_MOJOM_BADGING_BADGING_MOJOM_JUMBO_H_
#define THIRD_PARTY_BLINK_PUBLIC_MOJOM_BADGING_BADGING_MOJOM_JUMBO_H_
#endif
namespace blink {
namespace mojom {
BadgeValue::BadgeValue() : tag_(Tag::FLAG) {
  data_.flag = uint8_t();
}

BadgeValue::~BadgeValue() {
  DestroyActive();
}


void BadgeValue::set_flag(
    uint8_t flag) {
  if (tag_ != Tag::FLAG) {
    DestroyActive();
    tag_ = Tag::FLAG;
  }
  data_.flag = flag;
}
void BadgeValue::set_number(
    uint64_t number) {
  if (tag_ != Tag::NUMBER) {
    DestroyActive();
    tag_ = Tag::NUMBER;
  }
  data_.number = number;
}

void BadgeValue::DestroyActive() {
  switch (tag_) {

    case Tag::FLAG:

      break;
    case Tag::NUMBER:

      break;
  }
}
size_t BadgeValue::Hash(size_t seed) const {
  seed = mojo::internal::HashCombine(seed, static_cast<uint32_t>(tag_));
  switch (tag_) {

    case Tag::FLAG:
      return mojo::internal::Hash(seed, data_.flag);
    case Tag::NUMBER:
      return mojo::internal::Hash(seed, data_.number);
    default:
      NOTREACHED();
      return seed;
  }
}

bool BadgeValue::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  return Data_::Validate(data, validation_context, false);
}
const char BadgeService::Name_[] = "blink.mojom.BadgeService";

BadgeServiceProxy::BadgeServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void BadgeServiceProxy::SetBadge(
    BadgeValuePtr in_value) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "blink::mojom::BadgeService::SetBadge", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("value", base::trace_event::ValueToString(in_value, "<value of type BadgeValuePtr>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBadgeService_SetBadge_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::BadgeService_SetBadge_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->value)::BufferWriter value_writer;
  value_writer.AllocateInline(buffer, &params->value);
  mojo::internal::Serialize<::blink::mojom::BadgeValueDataView>(
      in_value, buffer, &value_writer, true, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->value.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null value in BadgeService.SetBadge request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BadgeService::Name_);
  message.set_method_name("SetBadge");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void BadgeServiceProxy::ClearBadge(
    ) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT0("mojom", "blink::mojom::BadgeService::ClearBadge");
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kBadgeService_ClearBadge_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::blink::mojom::internal::BadgeService_ClearBadge_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(BadgeService::Name_);
  message.set_method_name("ClearBadge");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool BadgeServiceStubDispatch::Accept(
    BadgeService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kBadgeService_SetBadge_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BadgeService::SetBadge",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BadgeService::SetBadge");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BadgeService_SetBadge_Params_Data* params =
          reinterpret_cast<internal::BadgeService_SetBadge_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      BadgeValuePtr p_value{};
      BadgeService_SetBadge_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadValue(&p_value))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BadgeService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->SetBadge(
std::move(p_value));
      return true;
    }
    case internal::kBadgeService_ClearBadge_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)blink::mojom::BadgeService::ClearBadge",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)blink::mojom::BadgeService::ClearBadge");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::BadgeService_ClearBadge_Params_Data* params =
          reinterpret_cast<internal::BadgeService_ClearBadge_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      BadgeService_ClearBadge_ParamsDataView input_data_view(params, &serialization_context);
      
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            BadgeService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->ClearBadge();
      return true;
    }
  }
  return false;
}

// static
bool BadgeServiceStubDispatch::AcceptWithResponder(
    BadgeService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kBadgeService_SetBadge_Name: {
      break;
    }
    case internal::kBadgeService_ClearBadge_Name: {
      break;
    }
  }
  return false;
}


static const mojo::internal::GenericValidationInfo kBadgeServiceValidationInfo[] = {
    {&internal::BadgeService_SetBadge_Params_Data::Validate,
     nullptr /* no response */},
    {&internal::BadgeService_ClearBadge_Params_Data::Validate,
     nullptr /* no response */},
};

bool BadgeServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::blink::mojom::BadgeService::Name_;
  return mojo::internal::ValidateRequestGenericPacked(message, name, kBadgeServiceValidationInfo);
}

}  // namespace mojom
}  // namespace blink

namespace mojo {

// static
bool UnionTraits<::blink::mojom::BadgeValue::DataView, ::blink::mojom::BadgeValuePtr>::Read(
    ::blink::mojom::BadgeValue::DataView input,
    ::blink::mojom::BadgeValuePtr* output) {
  using UnionType = ::blink::mojom::BadgeValue;
  using Tag = UnionType::Tag;

  switch (input.tag()) {
    case Tag::FLAG: {
      *output = UnionType::NewFlag(input.flag());
      break;
    }
    case Tag::NUMBER: {
      *output = UnionType::NewNumber(input.number());
      break;
    }
    default:
      return false;
  }
  return true;
}

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif