// services/network/public/mojom/cross_origin_opener_policy.mojom-blink.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_BLINK_H_
#define SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_BLINK_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-shared.h"
#include "services/network/public/mojom/cross_origin_opener_policy.mojom-blink-forward.h"
#include "url/mojom/url.mojom-blink-forward.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-blink-forward.h"
#include "services/network/public/mojom/source_location.mojom-blink.h"

#include "mojo/public/cpp/bindings/lib/wtf_clone_equals_util.h"
#include "mojo/public/cpp/bindings/lib/wtf_hash_util.h"
#include "third_party/blink/renderer/platform/wtf/hash_functions.h"
#include "third_party/blink/renderer/platform/wtf/text/wtf_string.h"

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "services/network/public/cpp/cross_origin_opener_policy_mojom_traits.h"
#include "third_party/blink/public/platform/web_common.h"




namespace WTF {
struct network_mojom_internal_CoopAccessReportType_DataHashFn {
  static unsigned GetHash(const ::network::mojom::CoopAccessReportType& value) {
    using utype = std::underlying_type<::network::mojom::CoopAccessReportType>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::network::mojom::CoopAccessReportType& left, const ::network::mojom::CoopAccessReportType& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::network::mojom::CoopAccessReportType>
    : public GenericHashTraits<::network::mojom::CoopAccessReportType> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::network::mojom::CoopAccessReportType& value) {
    return value == static_cast<::network::mojom::CoopAccessReportType>(-1000000);
  }
  static void ConstructDeletedValue(::network::mojom::CoopAccessReportType& slot, bool) {
    slot = static_cast<::network::mojom::CoopAccessReportType>(-1000001);
  }
  static bool IsDeletedValue(const ::network::mojom::CoopAccessReportType& value) {
    return value == static_cast<::network::mojom::CoopAccessReportType>(-1000001);
  }
};
}  // namespace WTF


namespace WTF {
struct network_mojom_internal_CrossOriginOpenerPolicyValue_DataHashFn {
  static unsigned GetHash(const ::network::mojom::CrossOriginOpenerPolicyValue& value) {
    using utype = std::underlying_type<::network::mojom::CrossOriginOpenerPolicyValue>::type;
    return DefaultHash<utype>::Hash().GetHash(static_cast<utype>(value));
  }
  static bool Equal(const ::network::mojom::CrossOriginOpenerPolicyValue& left, const ::network::mojom::CrossOriginOpenerPolicyValue& right) {
    return left == right;
  }
  static const bool safe_to_compare_to_empty_or_deleted = true;
};

template <>
struct HashTraits<::network::mojom::CrossOriginOpenerPolicyValue>
    : public GenericHashTraits<::network::mojom::CrossOriginOpenerPolicyValue> {
  static_assert(true,
                "-1000000 is a reserved enum value");
  static_assert(true,
                "-1000001 is a reserved enum value");
  static const bool hasIsEmptyValueFunction = true;
  static bool IsEmptyValue(const ::network::mojom::CrossOriginOpenerPolicyValue& value) {
    return value == static_cast<::network::mojom::CrossOriginOpenerPolicyValue>(-1000000);
  }
  static void ConstructDeletedValue(::network::mojom::CrossOriginOpenerPolicyValue& slot, bool) {
    slot = static_cast<::network::mojom::CrossOriginOpenerPolicyValue>(-1000001);
  }
  static bool IsDeletedValue(const ::network::mojom::CrossOriginOpenerPolicyValue& value) {
    return value == static_cast<::network::mojom::CrossOriginOpenerPolicyValue>(-1000001);
  }
};
}  // namespace WTF

// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace network {
namespace mojom {
namespace blink {

class CrossOriginOpenerPolicyReporterProxy;

template <typename ImplRefTraits>
class CrossOriginOpenerPolicyReporterStub;

class CrossOriginOpenerPolicyReporterRequestValidator;


class BLINK_PLATFORM_EXPORT CrossOriginOpenerPolicyReporter
    : public CrossOriginOpenerPolicyReporterInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = CrossOriginOpenerPolicyReporterInterfaceBase;
  using Proxy_ = CrossOriginOpenerPolicyReporterProxy;

  template <typename ImplRefTraits>
  using Stub_ = CrossOriginOpenerPolicyReporterStub<ImplRefTraits>;

  using RequestValidator_ = CrossOriginOpenerPolicyReporterRequestValidator;
  using ResponseValidator_ = mojo::PassThroughFilter;
  enum MethodMinVersions : uint32_t {
    kQueueAccessReportMinVersion = 0,
  };
  virtual ~CrossOriginOpenerPolicyReporter() {}

  
  virtual void QueueAccessReport(CoopAccessReportType report_type, const WTF::String& property, ::network::mojom::blink::SourceLocationPtr source_location, const WTF::String& reported_window_url) = 0;
};



class BLINK_PLATFORM_EXPORT CrossOriginOpenerPolicyReporterProxy
    : public CrossOriginOpenerPolicyReporter {
 public:
  using InterfaceType = CrossOriginOpenerPolicyReporter;

  explicit CrossOriginOpenerPolicyReporterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void QueueAccessReport(CoopAccessReportType report_type, const WTF::String& property, ::network::mojom::blink::SourceLocationPtr source_location, const WTF::String& reported_window_url) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class BLINK_PLATFORM_EXPORT CrossOriginOpenerPolicyReporterStubDispatch {
 public:
  static bool Accept(CrossOriginOpenerPolicyReporter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      CrossOriginOpenerPolicyReporter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<CrossOriginOpenerPolicyReporter>>
class CrossOriginOpenerPolicyReporterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  CrossOriginOpenerPolicyReporterStub() {}
  ~CrossOriginOpenerPolicyReporterStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CrossOriginOpenerPolicyReporterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return CrossOriginOpenerPolicyReporterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class BLINK_PLATFORM_EXPORT CrossOriginOpenerPolicyReporterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





class BLINK_PLATFORM_EXPORT CrossOriginOpenerPolicy {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<CrossOriginOpenerPolicy, T>::value>;
  using DataView = CrossOriginOpenerPolicyDataView;
  using Data_ = internal::CrossOriginOpenerPolicy_Data;

  template <typename... Args>
  static CrossOriginOpenerPolicyPtr New(Args&&... args) {
    return CrossOriginOpenerPolicyPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static CrossOriginOpenerPolicyPtr From(const U& u) {
    return mojo::TypeConverter<CrossOriginOpenerPolicyPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, CrossOriginOpenerPolicy>::Convert(*this);
  }


  CrossOriginOpenerPolicy();

  CrossOriginOpenerPolicy(
      CrossOriginOpenerPolicyValue value,
      const WTF::String& reporting_endpoint,
      CrossOriginOpenerPolicyValue report_only_value,
      const WTF::String& report_only_reporting_endpoint);

  ~CrossOriginOpenerPolicy();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = CrossOriginOpenerPolicyPtr>
  CrossOriginOpenerPolicyPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static WTF::Vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        CrossOriginOpenerPolicy::DataView, WTF::Vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        CrossOriginOpenerPolicy::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::CrossOriginOpenerPolicy_UnserializedMessageContext<
            UserType, CrossOriginOpenerPolicy::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<CrossOriginOpenerPolicy::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const WTF::Vector<uint8_t>& input,
                          UserType* output) {
    return CrossOriginOpenerPolicy::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::CrossOriginOpenerPolicy_UnserializedMessageContext<
            UserType, CrossOriginOpenerPolicy::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<CrossOriginOpenerPolicy::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  CrossOriginOpenerPolicyValue value;
  
  WTF::String reporting_endpoint;
  
  CrossOriginOpenerPolicyValue report_only_value;
  
  WTF::String report_only_reporting_endpoint;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}




template <typename StructPtrType>
CrossOriginOpenerPolicyPtr CrossOriginOpenerPolicy::Clone() const {
  return New(
      mojo::Clone(value),
      mojo::Clone(reporting_endpoint),
      mojo::Clone(report_only_value),
      mojo::Clone(report_only_reporting_endpoint)
  );
}

template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>*>
bool CrossOriginOpenerPolicy::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->value, other_struct.value))
    return false;
  if (!mojo::Equals(this->reporting_endpoint, other_struct.reporting_endpoint))
    return false;
  if (!mojo::Equals(this->report_only_value, other_struct.report_only_value))
    return false;
  if (!mojo::Equals(this->report_only_reporting_endpoint, other_struct.report_only_reporting_endpoint))
    return false;
  return true;
}

template <typename T, CrossOriginOpenerPolicy::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.value, rhs.value))
    return true;
  if (std::less<>{}(rhs.value, lhs.value))
    return false;
  if (std::less<>{}(lhs.reporting_endpoint, rhs.reporting_endpoint))
    return true;
  if (std::less<>{}(rhs.reporting_endpoint, lhs.reporting_endpoint))
    return false;
  if (std::less<>{}(lhs.report_only_value, rhs.report_only_value))
    return true;
  if (std::less<>{}(rhs.report_only_value, lhs.report_only_value))
    return false;
  if (std::less<>{}(lhs.report_only_reporting_endpoint, rhs.report_only_reporting_endpoint))
    return true;
  if (std::less<>{}(rhs.report_only_reporting_endpoint, lhs.report_only_reporting_endpoint))
    return false;
  return false;
}


}  // namespace blink
}  // namespace mojom
}  // namespace network

namespace mojo {


template <>
struct BLINK_PLATFORM_EXPORT StructTraits<::network::mojom::blink::CrossOriginOpenerPolicy::DataView,
                                         ::network::mojom::blink::CrossOriginOpenerPolicyPtr> {
  static bool IsNull(const ::network::mojom::blink::CrossOriginOpenerPolicyPtr& input) { return !input; }
  static void SetToNull(::network::mojom::blink::CrossOriginOpenerPolicyPtr* output) { output->reset(); }

  static decltype(::network::mojom::blink::CrossOriginOpenerPolicy::value) value(
      const ::network::mojom::blink::CrossOriginOpenerPolicyPtr& input) {
    return input->value;
  }

  static const decltype(::network::mojom::blink::CrossOriginOpenerPolicy::reporting_endpoint)& reporting_endpoint(
      const ::network::mojom::blink::CrossOriginOpenerPolicyPtr& input) {
    return input->reporting_endpoint;
  }

  static decltype(::network::mojom::blink::CrossOriginOpenerPolicy::report_only_value) report_only_value(
      const ::network::mojom::blink::CrossOriginOpenerPolicyPtr& input) {
    return input->report_only_value;
  }

  static const decltype(::network::mojom::blink::CrossOriginOpenerPolicy::report_only_reporting_endpoint)& report_only_reporting_endpoint(
      const ::network::mojom::blink::CrossOriginOpenerPolicyPtr& input) {
    return input->report_only_reporting_endpoint;
  }

  static bool Read(::network::mojom::blink::CrossOriginOpenerPolicy::DataView input, ::network::mojom::blink::CrossOriginOpenerPolicyPtr* output);
};

}  // namespace mojo

#endif  // SERVICES_NETWORK_PUBLIC_MOJOM_CROSS_ORIGIN_OPENER_POLICY_MOJOM_BLINK_H_