// services/data_decoder/public/mojom/web_bundler.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef SERVICES_DATA_DECODER_PUBLIC_MOJOM_WEB_BUNDLER_MOJOM_PARAMS_DATA_H_
#define SERVICES_DATA_DECODER_PUBLIC_MOJOM_WEB_BUNDLER_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace data_decoder {
namespace mojom {
namespace internal {
class  WebBundler_Generate_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebBundler_Generate_Params_Data));
      new (data()) WebBundler_Generate_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebBundler_Generate_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebBundler_Generate_Params_Data>(index_);
    }
    WebBundler_Generate_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Interface_Data>> snapshots;
  mojo::internal::Pointer<::mojo_base::mojom::internal::File_Data> file;

 private:
  WebBundler_Generate_Params_Data();
  ~WebBundler_Generate_Params_Data() = delete;
};
static_assert(sizeof(WebBundler_Generate_Params_Data) == 24,
              "Bad sizeof(WebBundler_Generate_Params_Data)");
class  WebBundler_Generate_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(WebBundler_Generate_ResponseParams_Data));
      new (data()) WebBundler_Generate_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    WebBundler_Generate_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<WebBundler_Generate_ResponseParams_Data>(index_);
    }
    WebBundler_Generate_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  uint64_t file_size;
  int32_t error;
  uint8_t padfinal_[4];

 private:
  WebBundler_Generate_ResponseParams_Data();
  ~WebBundler_Generate_ResponseParams_Data() = delete;
};
static_assert(sizeof(WebBundler_Generate_ResponseParams_Data) == 24,
              "Bad sizeof(WebBundler_Generate_ResponseParams_Data)");

}  // namespace internal


class WebBundler_Generate_ParamsDataView {
 public:
  WebBundler_Generate_ParamsDataView() {}

  WebBundler_Generate_ParamsDataView(
      internal::WebBundler_Generate_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetSnapshotsDataView(
      mojo::ArrayDataView<mojo::InterfacePtrDataView<::data_decoder::mojom::ResourceSnapshotForWebBundleInterfaceBase>>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadSnapshots(UserType* output) {
    
    auto* pointer = data_->snapshots.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::InterfacePtrDataView<::data_decoder::mojom::ResourceSnapshotForWebBundleInterfaceBase>>>(
        pointer, output, context_);
  }
  inline void GetFileDataView(
      ::mojo_base::mojom::FileDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFile(UserType* output) {
    
    auto* pointer = data_->file.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::FileDataView>(
        pointer, output, context_);
  }
 private:
  internal::WebBundler_Generate_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class WebBundler_Generate_ResponseParamsDataView {
 public:
  WebBundler_Generate_ResponseParamsDataView() {}

  WebBundler_Generate_ResponseParamsDataView(
      internal::WebBundler_Generate_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint64_t file_size() const {
    return data_->file_size;
  }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadError(UserType* output) const {
    auto data_value = data_->error;
    return mojo::internal::Deserialize<::data_decoder::mojom::WebBundlerError>(
        data_value, output);
  }

  WebBundlerError error() const {
    return static_cast<WebBundlerError>(data_->error);
  }
 private:
  internal::WebBundler_Generate_ResponseParams_Data* data_ = nullptr;
};


inline void WebBundler_Generate_ParamsDataView::GetSnapshotsDataView(
    mojo::ArrayDataView<mojo::InterfacePtrDataView<::data_decoder::mojom::ResourceSnapshotForWebBundleInterfaceBase>>* output) {
  auto pointer = data_->snapshots.Get();
  *output = mojo::ArrayDataView<mojo::InterfacePtrDataView<::data_decoder::mojom::ResourceSnapshotForWebBundleInterfaceBase>>(pointer, context_);
}
inline void WebBundler_Generate_ParamsDataView::GetFileDataView(
    ::mojo_base::mojom::FileDataView* output) {
  auto pointer = data_->file.Get();
  *output = ::mojo_base::mojom::FileDataView(pointer, context_);
}



}  // namespace mojom
}  // namespace data_decoder

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // SERVICES_DATA_DECODER_PUBLIC_MOJOM_WEB_BUNDLER_MOJOM_PARAMS_DATA_H_