// media/mojo/mojom/video_encoder_info.mojom-shared.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_SHARED_H_
#define MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_SHARED_H_

#include <stdint.h>

#include <functional>
#include <ostream>
#include <type_traits>
#include <utility>

#include "base/compiler_specific.h"
#include "base/containers/flat_map.h"
#include "mojo/public/cpp/bindings/array_data_view.h"
#include "mojo/public/cpp/bindings/enum_traits.h"
#include "mojo/public/cpp/bindings/interface_data_view.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/map_data_view.h"
#include "mojo/public/cpp/bindings/string_data_view.h"
#include "media/mojo/mojom/video_encoder_info.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared.h"







namespace media {
namespace mojom {
class ScalingSettingsDataView;

class ResolutionBitrateLimitDataView;

class VideoEncoderInfoDataView;



}  // namespace mojom
}  // namespace media

namespace mojo {
namespace internal {

template <>
struct MojomTypeTraits<::media::mojom::ScalingSettingsDataView> {
  using Data = ::media::mojom::internal::ScalingSettings_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::ResolutionBitrateLimitDataView> {
  using Data = ::media::mojom::internal::ResolutionBitrateLimit_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

template <>
struct MojomTypeTraits<::media::mojom::VideoEncoderInfoDataView> {
  using Data = ::media::mojom::internal::VideoEncoderInfo_Data;
  using DataAsArrayElement = Pointer<Data>;
  static constexpr MojomTypeCategory category = MojomTypeCategory::kStruct;
};

}  // namespace internal
}  // namespace mojo


namespace media {
namespace mojom {


class ScalingSettingsDataView {
 public:
  ScalingSettingsDataView() {}

  ScalingSettingsDataView(
      internal::ScalingSettings_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data) {}

  bool is_null() const { return !data_; }
  uint8_t min_qp() const {
    return data_->min_qp;
  }
  uint8_t max_qp() const {
    return data_->max_qp;
  }
 private:
  internal::ScalingSettings_Data* data_ = nullptr;
};



class ResolutionBitrateLimitDataView {
 public:
  ResolutionBitrateLimitDataView() {}

  ResolutionBitrateLimitDataView(
      internal::ResolutionBitrateLimit_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetFrameSizeDataView(
      ::gfx::mojom::SizeDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFrameSize(UserType* output) {
    
    auto* pointer = data_->frame_size.Get();
    return mojo::internal::Deserialize<::gfx::mojom::SizeDataView>(
        pointer, output, context_);
  }
  int32_t min_start_bitrate_bps() const {
    return data_->min_start_bitrate_bps;
  }
  int32_t min_bitrate_bps() const {
    return data_->min_bitrate_bps;
  }
  int32_t max_bitrate_bps() const {
    return data_->max_bitrate_bps;
  }
 private:
  internal::ResolutionBitrateLimit_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class VideoEncoderInfoDataView {
 public:
  VideoEncoderInfoDataView() {}

  VideoEncoderInfoDataView(
      internal::VideoEncoderInfo_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetImplementationNameDataView(
      mojo::StringDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadImplementationName(UserType* output) {
    
    auto* pointer = data_->implementation_name.Get();
    return mojo::internal::Deserialize<mojo::StringDataView>(
        pointer, output, context_);
  }
  bool supports_native_handle() const {
    return data_->supports_native_handle;
  }
  bool has_trusted_rate_controller() const {
    return data_->has_trusted_rate_controller;
  }
  bool is_hardware_accelerated() const {
    return data_->is_hardware_accelerated;
  }
  bool supports_simulcast() const {
    return data_->supports_simulcast;
  }
  inline void GetScalingSettingsDataView(
      ScalingSettingsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadScalingSettings(UserType* output) {
    
static_assert(
    mojo::internal::IsValidUserTypeForOptionalValue<
        ::media::mojom::ScalingSettingsDataView, UserType>(),
    "Attempting to read the optional `scaling_settings` field into a type which "
    "cannot represent a null value. Either wrap the destination object "
    "with base::Optional, ensure that any corresponding "
    "{Struct/Union/Array/String}Traits define the necessary IsNull and "
    "SetToNull methods, or use `MaybeReadScalingSettings` instead "
    "of `ReadScalingSettings if you're fine with null values being "
    "silently ignored in this case.");
    auto* pointer = data_->scaling_settings.Get();
    return mojo::internal::Deserialize<::media::mojom::ScalingSettingsDataView>(
        pointer, output, context_);
  }
  inline void GetFpsAllocationDataView(
      mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadFpsAllocation(UserType* output) {
    
    auto* pointer = data_->fps_allocation.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        pointer, output, context_);
  }
  inline void GetResolutionBitrateLimitsDataView(
      mojo::ArrayDataView<ResolutionBitrateLimitDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadResolutionBitrateLimits(UserType* output) {
    
    auto* pointer = data_->resolution_bitrate_limits.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<::media::mojom::ResolutionBitrateLimitDataView>>(
        pointer, output, context_);
  }
 private:
  internal::VideoEncoderInfo_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



}  // namespace mojom
}  // namespace media

namespace std {

}  // namespace std

namespace mojo {


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::ScalingSettingsDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::ScalingSettingsDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::mojom::internal::ScalingSettings_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    (*output)->min_qp = Traits::min_qp(input);
    (*output)->max_qp = Traits::max_qp(input);
  }

  static bool Deserialize(::media::mojom::internal::ScalingSettings_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::ScalingSettingsDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::ResolutionBitrateLimitDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::ResolutionBitrateLimitDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::mojom::internal::ResolutionBitrateLimit_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::frame_size(input)) in_frame_size = Traits::frame_size(input);
    typename decltype((*output)->frame_size)::BaseType::BufferWriter
        frame_size_writer;
    mojo::internal::Serialize<::gfx::mojom::SizeDataView>(
        in_frame_size, buffer, &frame_size_writer, context);
    (*output)->frame_size.Set(
        frame_size_writer.is_null() ? nullptr : frame_size_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->frame_size.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null frame_size in ResolutionBitrateLimit struct");
    (*output)->min_start_bitrate_bps = Traits::min_start_bitrate_bps(input);
    (*output)->min_bitrate_bps = Traits::min_bitrate_bps(input);
    (*output)->max_bitrate_bps = Traits::max_bitrate_bps(input);
  }

  static bool Deserialize(::media::mojom::internal::ResolutionBitrateLimit_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::ResolutionBitrateLimitDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal


namespace internal {

template <typename MaybeConstUserType>
struct Serializer<::media::mojom::VideoEncoderInfoDataView, MaybeConstUserType> {
  using UserType = typename std::remove_const<MaybeConstUserType>::type;
  using Traits = StructTraits<::media::mojom::VideoEncoderInfoDataView, UserType>;

  static void Serialize(MaybeConstUserType& input,
                        Buffer* buffer,
                        ::media::mojom::internal::VideoEncoderInfo_Data::BufferWriter* output,
                        SerializationContext* context) {
    if (CallIsNullIfExists<Traits>(input))
      return;
    (*output).Allocate(buffer);
    decltype(Traits::implementation_name(input)) in_implementation_name = Traits::implementation_name(input);
    typename decltype((*output)->implementation_name)::BaseType::BufferWriter
        implementation_name_writer;
    mojo::internal::Serialize<mojo::StringDataView>(
        in_implementation_name, buffer, &implementation_name_writer, context);
    (*output)->implementation_name.Set(
        implementation_name_writer.is_null() ? nullptr : implementation_name_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->implementation_name.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null implementation_name in VideoEncoderInfo struct");
    (*output)->supports_native_handle = Traits::supports_native_handle(input);
    (*output)->has_trusted_rate_controller = Traits::has_trusted_rate_controller(input);
    (*output)->is_hardware_accelerated = Traits::is_hardware_accelerated(input);
    (*output)->supports_simulcast = Traits::supports_simulcast(input);
    decltype(Traits::scaling_settings(input)) in_scaling_settings = Traits::scaling_settings(input);
    typename decltype((*output)->scaling_settings)::BaseType::BufferWriter
        scaling_settings_writer;
    mojo::internal::Serialize<::media::mojom::ScalingSettingsDataView>(
        in_scaling_settings, buffer, &scaling_settings_writer, context);
    (*output)->scaling_settings.Set(
        scaling_settings_writer.is_null() ? nullptr : scaling_settings_writer.data());
    decltype(Traits::fps_allocation(input)) in_fps_allocation = Traits::fps_allocation(input);
    typename decltype((*output)->fps_allocation)::BaseType::BufferWriter
        fps_allocation_writer;
    const mojo::internal::ContainerValidateParams fps_allocation_validate_params(
        5, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
    mojo::internal::Serialize<mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>>(
        in_fps_allocation, buffer, &fps_allocation_writer, &fps_allocation_validate_params,
        context);
    (*output)->fps_allocation.Set(
        fps_allocation_writer.is_null() ? nullptr : fps_allocation_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->fps_allocation.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null fps_allocation in VideoEncoderInfo struct");
    decltype(Traits::resolution_bitrate_limits(input)) in_resolution_bitrate_limits = Traits::resolution_bitrate_limits(input);
    typename decltype((*output)->resolution_bitrate_limits)::BaseType::BufferWriter
        resolution_bitrate_limits_writer;
    const mojo::internal::ContainerValidateParams resolution_bitrate_limits_validate_params(
        0, false, nullptr);
    mojo::internal::Serialize<mojo::ArrayDataView<::media::mojom::ResolutionBitrateLimitDataView>>(
        in_resolution_bitrate_limits, buffer, &resolution_bitrate_limits_writer, &resolution_bitrate_limits_validate_params,
        context);
    (*output)->resolution_bitrate_limits.Set(
        resolution_bitrate_limits_writer.is_null() ? nullptr : resolution_bitrate_limits_writer.data());
    MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
        (*output)->resolution_bitrate_limits.is_null(),
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
        "null resolution_bitrate_limits in VideoEncoderInfo struct");
  }

  static bool Deserialize(::media::mojom::internal::VideoEncoderInfo_Data* input,
                          UserType* output,
                          SerializationContext* context) {
    if (!input)
      return CallSetToNullIfExists<Traits>(output);

    ::media::mojom::VideoEncoderInfoDataView data_view(input, context);
    return Traits::Read(data_view, output);
  }
};

}  // namespace internal

}  // namespace mojo


namespace media {
namespace mojom {



inline void ResolutionBitrateLimitDataView::GetFrameSizeDataView(
    ::gfx::mojom::SizeDataView* output) {
  auto pointer = data_->frame_size.Get();
  *output = ::gfx::mojom::SizeDataView(pointer, context_);
}


inline void VideoEncoderInfoDataView::GetImplementationNameDataView(
    mojo::StringDataView* output) {
  auto pointer = data_->implementation_name.Get();
  *output = mojo::StringDataView(pointer, context_);
}
inline void VideoEncoderInfoDataView::GetScalingSettingsDataView(
    ScalingSettingsDataView* output) {
  auto pointer = data_->scaling_settings.Get();
  *output = ScalingSettingsDataView(pointer, context_);
}
inline void VideoEncoderInfoDataView::GetFpsAllocationDataView(
    mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>* output) {
  auto pointer = data_->fps_allocation.Get();
  *output = mojo::ArrayDataView<mojo::ArrayDataView<uint8_t>>(pointer, context_);
}
inline void VideoEncoderInfoDataView::GetResolutionBitrateLimitsDataView(
    mojo::ArrayDataView<ResolutionBitrateLimitDataView>* output) {
  auto pointer = data_->resolution_bitrate_limits.Get();
  *output = mojo::ArrayDataView<ResolutionBitrateLimitDataView>(pointer, context_);
}



}  // namespace mojom
}  // namespace media

#endif  // MEDIA_MOJO_MOJOM_VIDEO_ENCODER_INFO_MOJOM_SHARED_H_