// media/mojo/mojom/cdm_service.mojom.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif

#include "media/mojo/mojom/cdm_service.mojom.h"

#include <math.h>
#include <stdint.h>
#include <utility>

#include "base/hash/md5_constexpr.h"
#include "base/run_loop.h"
#include "base/strings/string_number_conversions.h"
#include "base/task/common/task_annotator.h"
#include "base/trace_event/trace_conversion_helper.h"
#include "base/trace_event/traced_value.h"
#include "mojo/public/cpp/bindings/lib/generated_code_util.h"
#include "mojo/public/cpp/bindings/lib/message_internal.h"
#include "mojo/public/cpp/bindings/lib/serialization_util.h"
#include "mojo/public/cpp/bindings/lib/unserialized_message_context.h"
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/interfaces/bindings/interface_control_messages.mojom.h"

#include "media/mojo/mojom/cdm_service.mojom-params-data.h"
#include "media/mojo/mojom/cdm_service.mojom-shared-message-ids.h"

#include "media/mojo/mojom/cdm_service.mojom-import-headers.h"


#ifndef MEDIA_MOJO_MOJOM_CDM_SERVICE_MOJOM_JUMBO_H_
#define MEDIA_MOJO_MOJOM_CDM_SERVICE_MOJOM_JUMBO_H_
#endif
namespace media {
namespace mojom {
const char CdmService::Name_[] = "media.mojom.CdmService";

CdmServiceProxy::CdmServiceProxy(mojo::MessageReceiverWithResponder* receiver)
    : receiver_(receiver) {
}

void CdmServiceProxy::LoadCdm(
    const ::base::FilePath& in_cdm_path) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::CdmService::LoadCdm", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetString("cdm_path", base::trace_event::ValueToString(in_cdm_path, "<value of type const ::base::FilePath&>"));
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCdmService_LoadCdm_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::CdmService_LoadCdm_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  typename decltype(params->cdm_path)::BaseType::BufferWriter
      cdm_path_writer;
  mojo::internal::Serialize<::mojo_base::mojom::FilePathDataView>(
      in_cdm_path, buffer, &cdm_path_writer, &serialization_context);
  params->cdm_path.Set(
      cdm_path_writer.is_null() ? nullptr : cdm_path_writer.data());
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      params->cdm_path.is_null(),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_NULL_POINTER,
      "null cdm_path in CdmService.LoadCdm request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmService::Name_);
  message.set_method_name("LoadCdm");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

void CdmServiceProxy::CreateCdmFactory(
    ::mojo::PendingReceiver<::media::mojom::CdmFactory> in_factory, ::mojo::PendingRemote<::media::mojom::FrameInterfaceFactory> in_frame_interfaces) {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
  TRACE_EVENT1(
    "mojom", "media::mojom::CdmService::CreateCdmFactory", "input_parameters",
    [&](){
      auto value = std::make_unique<base::trace_event::TracedValue>();
      base::trace_event::TracedValue* raw_value = value.get();
      raw_value->SetBoolean("factory", in_factory.is_valid());
      raw_value->SetBoolean("frame_interfaces", in_frame_interfaces.is_valid());
      return value;
    }());
#endif
  const bool kExpectsResponse = false;
  const bool kIsSync = false;
  
  const uint32_t kFlags =
      ((kExpectsResponse) ? mojo::Message::kFlagExpectsResponse : 0) |
      ((kIsSync) ? mojo::Message::kFlagIsSync : 0);
  
  mojo::Message message(
      internal::kCdmService_CreateCdmFactory_Name, kFlags, 0, 0, nullptr);
  auto* buffer = message.payload_buffer();
  ::media::mojom::internal::CdmService_CreateCdmFactory_Params_Data::BufferWriter
      params;
  mojo::internal::SerializationContext serialization_context;
  params.Allocate(buffer);
  mojo::internal::Serialize<mojo::InterfaceRequestDataView<::media::mojom::CdmFactoryInterfaceBase>>(
      in_factory, &params->factory, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->factory),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid factory in CdmService.CreateCdmFactory request");
  mojo::internal::Serialize<mojo::InterfacePtrDataView<::media::mojom::FrameInterfaceFactoryInterfaceBase>>(
      in_frame_interfaces, &params->frame_interfaces, &serialization_context);
  MOJO_INTERNAL_DLOG_SERIALIZATION_WARNING(
      !mojo::internal::IsHandleOrInterfaceValid(params->frame_interfaces),
      mojo::internal::VALIDATION_ERROR_UNEXPECTED_INVALID_HANDLE,
      "invalid frame_interfaces in CdmService.CreateCdmFactory request");
  message.AttachHandlesFromSerializationContext(
      &serialization_context);

#if defined(ENABLE_IPC_FUZZER)
  message.set_interface_name(CdmService::Name_);
  message.set_method_name("CreateCdmFactory");
#endif
  // This return value may be ignored as false implies the Connector has
  // encountered an error, which will be visible through other means.
  ignore_result(receiver_->Accept(&message));
}

// static
bool CdmServiceStubDispatch::Accept(
    CdmService* impl,
    mojo::Message* message) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  switch (message->header()->name) {
    case internal::kCdmService_LoadCdm_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::CdmService::LoadCdm",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::CdmService::LoadCdm");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CdmService_LoadCdm_Params_Data* params =
          reinterpret_cast<internal::CdmService_LoadCdm_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::base::FilePath p_cdm_path{};
      CdmService_LoadCdm_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success && !input_data_view.ReadCdmPath(&p_cdm_path))
        success = false;
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmService::Name_, 0, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->LoadCdm(
std::move(p_cdm_path));
      return true;
    }
    case internal::kCdmService_CreateCdmFactory_Name: {
#if BUILDFLAG(MOJO_TRACE_ENABLED)
      TRACE_EVENT1(
          "mojom",
          "(Impl)media::mojom::CdmService::CreateCdmFactory",
          "message", message->name());
#endif
      static constexpr uint32_t kMessageHash = base::MD5Hash32Constexpr(
              "(Impl)media::mojom::CdmService::CreateCdmFactory");
      base::TaskAnnotator::ScopedSetIpcHash scoped_ipc_hash(kMessageHash);

      DCHECK(message->is_serialized());
      internal::CdmService_CreateCdmFactory_Params_Data* params =
          reinterpret_cast<internal::CdmService_CreateCdmFactory_Params_Data*>(
              message->mutable_payload());
      
      bool success = true;
      ::mojo::PendingReceiver<::media::mojom::CdmFactory> p_factory{};
      ::mojo::PendingRemote<::media::mojom::FrameInterfaceFactory> p_frame_interfaces{};
      CdmService_CreateCdmFactory_ParamsDataView input_data_view(params, &serialization_context);
      
      if (success) {
        p_factory =
            input_data_view.TakeFactory<decltype(p_factory)>();
      }
      if (success) {
        p_frame_interfaces =
            input_data_view.TakeFrameInterfaces<decltype(p_frame_interfaces)>();
      }
      if (!success) {
        ReportValidationErrorForMessage(
            message,
            mojo::internal::VALIDATION_ERROR_DESERIALIZATION_FAILED,
            CdmService::Name_, 1, false);
        return false;
      }
      // A null |impl| means no implementation was bound.
      DCHECK(impl);
      impl->CreateCdmFactory(
std::move(p_factory), 
std::move(p_frame_interfaces));
      return true;
    }
  }
  return false;
}

// static
bool CdmServiceStubDispatch::AcceptWithResponder(
    CdmService* impl,
    mojo::Message* message,
    std::unique_ptr<mojo::MessageReceiverWithStatus> responder) {
  mojo::internal::MessageDispatchContext dispatch_context(message);
  mojo::internal::SerializationContext serialization_context;
  serialization_context.TakeHandlesFromMessage(message);
  const bool message_is_sync = message->has_flag(mojo::Message::kFlagIsSync);
  const uint64_t request_id = message->request_id();
  ALLOW_UNUSED_LOCAL(message_is_sync);
  ALLOW_UNUSED_LOCAL(request_id);
  switch (message->header()->name) {
    case internal::kCdmService_LoadCdm_Name: {
      break;
    }
    case internal::kCdmService_CreateCdmFactory_Name: {
      break;
    }
  }
  return false;
}


static const std::pair<uint32_t, mojo::internal::GenericValidationInfo> kCdmServiceValidationInfo[] = {
    {internal::kCdmService_LoadCdm_Name,
     {&internal::CdmService_LoadCdm_Params_Data::Validate,
      nullptr /* no response */}},
    {internal::kCdmService_CreateCdmFactory_Name,
     {&internal::CdmService_CreateCdmFactory_Params_Data::Validate,
      nullptr /* no response */}},
};

bool CdmServiceRequestValidator::Accept(mojo::Message* message) {
  const char* name = ::media::mojom::CdmService::Name_;
  return mojo::internal::ValidateRequestGeneric(message, name, kCdmServiceValidationInfo);
}

}  // namespace mojom
}  // namespace media

namespace mojo {

}  // namespace mojo

#if defined(__clang__)
#pragma clang diagnostic pop
#endif