// device/vr/public/mojom/vr_service.mojom-shared.cc is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "device/vr/public/mojom/vr_service.mojom-shared.h"

#include <utility>

#include "base/stl_util.h"  // for base::size()
#include "mojo/public/cpp/bindings/lib/validate_params.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"
#include "mojo/public/cpp/bindings/lib/validation_errors.h"
#include "mojo/public/cpp/bindings/lib/validation_util.h"

#include "device/vr/public/mojom/vr_service.mojom-params-data.h"
namespace device {
namespace mojom {

std::ostream& operator<<(std::ostream& os, XRDeviceId value) {
  switch(value) {
    case XRDeviceId::WEB_TEST_DEVICE_ID:
      return os << "XRDeviceId::WEB_TEST_DEVICE_ID";
    case XRDeviceId::FAKE_DEVICE_ID:
      return os << "XRDeviceId::FAKE_DEVICE_ID";
    case XRDeviceId::ORIENTATION_DEVICE_ID:
      return os << "XRDeviceId::ORIENTATION_DEVICE_ID";
    case XRDeviceId::GVR_DEVICE_ID:
      return os << "XRDeviceId::GVR_DEVICE_ID";
    case XRDeviceId::ARCORE_DEVICE_ID:
      return os << "XRDeviceId::ARCORE_DEVICE_ID";
    default:
      return os << "Unknown XRDeviceId value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, XRHandedness value) {
  switch(value) {
    case XRHandedness::NONE:
      return os << "XRHandedness::NONE";
    case XRHandedness::LEFT:
      return os << "XRHandedness::LEFT";
    case XRHandedness::RIGHT:
      return os << "XRHandedness::RIGHT";
    default:
      return os << "Unknown XRHandedness value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, XRTargetRayMode value) {
  switch(value) {
    case XRTargetRayMode::GAZING:
      return os << "XRTargetRayMode::GAZING";
    case XRTargetRayMode::POINTING:
      return os << "XRTargetRayMode::POINTING";
    case XRTargetRayMode::TAPPING:
      return os << "XRTargetRayMode::TAPPING";
    default:
      return os << "Unknown XRTargetRayMode value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, XRSessionFeature value) {
  switch(value) {
    case XRSessionFeature::REF_SPACE_VIEWER:
      return os << "XRSessionFeature::REF_SPACE_VIEWER";
    case XRSessionFeature::REF_SPACE_LOCAL:
      return os << "XRSessionFeature::REF_SPACE_LOCAL";
    case XRSessionFeature::REF_SPACE_LOCAL_FLOOR:
      return os << "XRSessionFeature::REF_SPACE_LOCAL_FLOOR";
    case XRSessionFeature::REF_SPACE_BOUNDED_FLOOR:
      return os << "XRSessionFeature::REF_SPACE_BOUNDED_FLOOR";
    case XRSessionFeature::REF_SPACE_UNBOUNDED:
      return os << "XRSessionFeature::REF_SPACE_UNBOUNDED";
    case XRSessionFeature::DOM_OVERLAY:
      return os << "XRSessionFeature::DOM_OVERLAY";
    case XRSessionFeature::HIT_TEST:
      return os << "XRSessionFeature::HIT_TEST";
    case XRSessionFeature::LIGHT_ESTIMATION:
      return os << "XRSessionFeature::LIGHT_ESTIMATION";
    case XRSessionFeature::ANCHORS:
      return os << "XRSessionFeature::ANCHORS";
    case XRSessionFeature::CAMERA_ACCESS:
      return os << "XRSessionFeature::CAMERA_ACCESS";
    case XRSessionFeature::PLANE_DETECTION:
      return os << "XRSessionFeature::PLANE_DETECTION";
    case XRSessionFeature::DEPTH:
      return os << "XRSessionFeature::DEPTH";
    default:
      return os << "Unknown XRSessionFeature value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, XRSessionFeatureRequestStatus value) {
  switch(value) {
    case XRSessionFeatureRequestStatus::kNotRequested:
      return os << "XRSessionFeatureRequestStatus::kNotRequested";
    case XRSessionFeatureRequestStatus::kRequired:
      return os << "XRSessionFeatureRequestStatus::kRequired";
    case XRSessionFeatureRequestStatus::kOptionalAccepted:
      return os << "XRSessionFeatureRequestStatus::kOptionalAccepted";
    case XRSessionFeatureRequestStatus::kOptionalRejected:
      return os << "XRSessionFeatureRequestStatus::kOptionalRejected";
    default:
      return os << "Unknown XRSessionFeatureRequestStatus value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, XRSessionMode value) {
  switch(value) {
    case XRSessionMode::kInline:
      return os << "XRSessionMode::kInline";
    case XRSessionMode::kImmersiveVr:
      return os << "XRSessionMode::kImmersiveVr";
    case XRSessionMode::kImmersiveAr:
      return os << "XRSessionMode::kImmersiveAr";
    default:
      return os << "Unknown XRSessionMode value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, XRPresentationTransportMethod value) {
  switch(value) {
    case XRPresentationTransportMethod::NONE:
      return os << "XRPresentationTransportMethod::NONE";
    case XRPresentationTransportMethod::SUBMIT_AS_TEXTURE_HANDLE:
      return os << "XRPresentationTransportMethod::SUBMIT_AS_TEXTURE_HANDLE";
    case XRPresentationTransportMethod::SUBMIT_AS_MAILBOX_HOLDER:
      return os << "XRPresentationTransportMethod::SUBMIT_AS_MAILBOX_HOLDER";
    case XRPresentationTransportMethod::DRAW_INTO_TEXTURE_MAILBOX:
      return os << "XRPresentationTransportMethod::DRAW_INTO_TEXTURE_MAILBOX";
    default:
      return os << "Unknown XRPresentationTransportMethod value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, XRReferenceSpaceType value) {
  switch(value) {
    case XRReferenceSpaceType::kViewer:
      return os << "XRReferenceSpaceType::kViewer";
    case XRReferenceSpaceType::kLocal:
      return os << "XRReferenceSpaceType::kLocal";
    case XRReferenceSpaceType::kLocalFloor:
      return os << "XRReferenceSpaceType::kLocalFloor";
    case XRReferenceSpaceType::kBoundedFloor:
      return os << "XRReferenceSpaceType::kBoundedFloor";
    case XRReferenceSpaceType::kUnbounded:
      return os << "XRReferenceSpaceType::kUnbounded";
    default:
      return os << "Unknown XRReferenceSpaceType value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, XRPlaneOrientation value) {
  switch(value) {
    case XRPlaneOrientation::UNKNOWN:
      return os << "XRPlaneOrientation::UNKNOWN";
    case XRPlaneOrientation::HORIZONTAL:
      return os << "XRPlaneOrientation::HORIZONTAL";
    case XRPlaneOrientation::VERTICAL:
      return os << "XRPlaneOrientation::VERTICAL";
    default:
      return os << "Unknown XRPlaneOrientation value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, RequestSessionError value) {
  switch(value) {
    case RequestSessionError::EXISTING_IMMERSIVE_SESSION:
      return os << "RequestSessionError::EXISTING_IMMERSIVE_SESSION";
    case RequestSessionError::INVALID_CLIENT:
      return os << "RequestSessionError::INVALID_CLIENT";
    case RequestSessionError::USER_DENIED_CONSENT:
      return os << "RequestSessionError::USER_DENIED_CONSENT";
    case RequestSessionError::NO_RUNTIME_FOUND:
      return os << "RequestSessionError::NO_RUNTIME_FOUND";
    case RequestSessionError::UNKNOWN_RUNTIME_ERROR:
      return os << "RequestSessionError::UNKNOWN_RUNTIME_ERROR";
    case RequestSessionError::RUNTIME_INSTALL_FAILURE:
      return os << "RequestSessionError::RUNTIME_INSTALL_FAILURE";
    case RequestSessionError::RUNTIMES_CHANGED:
      return os << "RequestSessionError::RUNTIMES_CHANGED";
    case RequestSessionError::FULLSCREEN_ERROR:
      return os << "RequestSessionError::FULLSCREEN_ERROR";
    case RequestSessionError::UNKNOWN_FAILURE:
      return os << "RequestSessionError::UNKNOWN_FAILURE";
    default:
      return os << "Unknown RequestSessionError value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, XrCompatibleResult value) {
  switch(value) {
    case XrCompatibleResult::kAlreadyCompatible:
      return os << "XrCompatibleResult::kAlreadyCompatible";
    case XrCompatibleResult::kNoDeviceAvailable:
      return os << "XrCompatibleResult::kNoDeviceAvailable";
    case XrCompatibleResult::kWebXrFeaturePolicyBlocked:
      return os << "XrCompatibleResult::kWebXrFeaturePolicyBlocked";
    case XrCompatibleResult::kCompatibleAfterRestart:
      return os << "XrCompatibleResult::kCompatibleAfterRestart";
    case XrCompatibleResult::kNotCompatibleAfterRestart:
      return os << "XrCompatibleResult::kNotCompatibleAfterRestart";
    default:
      return os << "Unknown XrCompatibleResult value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, CreateAnchorResult value) {
  switch(value) {
    case CreateAnchorResult::SUCCESS:
      return os << "CreateAnchorResult::SUCCESS";
    case CreateAnchorResult::FAILURE:
      return os << "CreateAnchorResult::FAILURE";
    default:
      return os << "Unknown CreateAnchorResult value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, SubscribeToHitTestResult value) {
  switch(value) {
    case SubscribeToHitTestResult::SUCCESS:
      return os << "SubscribeToHitTestResult::SUCCESS";
    case SubscribeToHitTestResult::FAILURE_GENERIC:
      return os << "SubscribeToHitTestResult::FAILURE_GENERIC";
    default:
      return os << "Unknown SubscribeToHitTestResult value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, EntityTypeForHitTest value) {
  switch(value) {
    case EntityTypeForHitTest::POINT:
      return os << "EntityTypeForHitTest::POINT";
    case EntityTypeForHitTest::PLANE:
      return os << "EntityTypeForHitTest::PLANE";
    default:
      return os << "Unknown EntityTypeForHitTest value: " << static_cast<int32_t>(value);
  }
}

std::ostream& operator<<(std::ostream& os, XRVisibilityState value) {
  switch(value) {
    case XRVisibilityState::VISIBLE:
      return os << "XRVisibilityState::VISIBLE";
    case XRVisibilityState::VISIBLE_BLURRED:
      return os << "XRVisibilityState::VISIBLE_BLURRED";
    case XRVisibilityState::HIDDEN:
      return os << "XRVisibilityState::HIDDEN";
    default:
      return os << "Unknown XRVisibilityState value: " << static_cast<int32_t>(value);
  }
}

namespace internal {
// static
bool XRNativeOriginInformation_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const XRNativeOriginInformation_Data* object = static_cast<const XRNativeOriginInformation_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case XRNativeOriginInformation_Tag::INPUT_SOURCE_ID: {

      return true;
    }
    case XRNativeOriginInformation_Tag::PLANE_ID: {

      return true;
    }
    case XRNativeOriginInformation_Tag::ANCHOR_ID: {

      return true;
    }
    case XRNativeOriginInformation_Tag::REFERENCE_SPACE_TYPE: {


      if (!::device::mojom::internal::XRReferenceSpaceType_Data
            ::Validate(object->data.f_reference_space_type, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in XRNativeOriginInformation");
      return false;
    }
  }
}
// static
bool XRDepthData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const XRDepthData_Data* object = static_cast<const XRDepthData_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case XRDepthData_Tag::DATA_STILL_VALID: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_data_still_valid, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_data_still_valid, validation_context))
        return false;
      return true;
    }
    case XRDepthData_Tag::UPDATED_DEPTH_DATA: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_updated_depth_data, 2, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_updated_depth_data, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in XRDepthData");
      return false;
    }
  }
}
// static
bool RequestSessionResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context,
    bool inlined) {
  if (!data) {
    DCHECK(!inlined);
    return true;
  }

  // If it is inlined, the alignment is already enforced by its enclosing
  // object. We don't have to validate that.
  DCHECK(!inlined || mojo::internal::IsAligned(data));

  if (!inlined &&
      !mojo::internal::ValidateNonInlinedUnionHeaderAndClaimMemory(
          data, validation_context)) {
    return false;
  }

  const RequestSessionResult_Data* object = static_cast<const RequestSessionResult_Data*>(data);
  ALLOW_UNUSED_LOCAL(object);

  if (inlined && object->is_null())
    return true;

  switch (object->tag) {

    case RequestSessionResult_Tag::SUCCESS: {

      if (!mojo::internal::ValidatePointerNonNullable(
              object->data.f_success, 1, validation_context)) {
        return false;
      }
      if (!mojo::internal::ValidateStruct(object->data.f_success, validation_context))
        return false;
      return true;
    }
    case RequestSessionResult_Tag::FAILURE_REASON: {


      if (!::device::mojom::internal::RequestSessionError_Data
            ::Validate(object->data.f_failure_reason, validation_context))
        return false;
      return true;
    }
    default: {
      ReportValidationError(
          validation_context,
          mojo::internal::VALIDATION_ERROR_UNKNOWN_UNION_TAG,
          "unknown tag in RequestSessionResult");
      return false;
    }
  }
}


// static
bool XRSessionOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSessionOptions_Data* object = static_cast<const XRSessionOptions_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::device::mojom::internal::XRSessionMode_Data
        ::Validate(object->mode, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->required_features, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams required_features_validate_params(
      0, ::device::mojom::internal::XRSessionFeature_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->required_features, validation_context,
                                         &required_features_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->optional_features, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams optional_features_validate_params(
      0, ::device::mojom::internal::XRSessionFeature_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->optional_features, validation_context,
                                         &optional_features_validate_params)) {
    return false;
  }

  return true;
}

XRSessionOptions_Data::XRSessionOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSession_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSession_Data* object = static_cast<const XRSession_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 56 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->data_provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->data_provider,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->client_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display_info, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->display_info, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->submit_frame_sink, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->enabled_features, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams enabled_features_validate_params(
      0, ::device::mojom::internal::XRSessionFeature_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->enabled_features, validation_context,
                                         &enabled_features_validate_params)) {
    return false;
  }

  return true;
}

XRSession_Data::XRSession_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationConnection_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationConnection_Data* object = static_cast<const XRPresentationConnection_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->provider,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client_receiver, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client_receiver,
                                                 validation_context)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transport_options, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->transport_options, validation_context))
    return false;

  return true;
}

XRPresentationConnection_Data::XRPresentationConnection_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRInputSourceDescription_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRInputSourceDescription_Data* object = static_cast<const XRInputSourceDescription_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::device::mojom::internal::XRTargetRayMode_Data
        ::Validate(object->target_ray_mode, validation_context))
    return false;


  if (!::device::mojom::internal::XRHandedness_Data
        ::Validate(object->handedness, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->input_from_pointer, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profiles, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams profiles_validate_params(
      0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr));
  if (!mojo::internal::ValidateContainer(object->profiles, validation_context,
                                         &profiles_validate_params)) {
    return false;
  }

  return true;
}

XRInputSourceDescription_Data::XRInputSourceDescription_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRInputSourceState_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRInputSourceState_Data* object = static_cast<const XRInputSourceState_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 48 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->description, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mojo_from_input, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->gamepad, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->overlay_pointer_position, validation_context))
    return false;

  return true;
}

XRInputSourceState_Data::XRInputSourceState_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRFieldOfView_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRFieldOfView_Data* object = static_cast<const VRFieldOfView_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

VRFieldOfView_Data::VRFieldOfView_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRPose_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRPose_Data* object = static_cast<const VRPose_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->orientation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

VRPose_Data::VRPose_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool Pose_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const Pose_Data* object = static_cast<const Pose_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->orientation, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->orientation, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->position, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->position, validation_context))
    return false;

  return true;
}

Pose_Data::Pose_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRRay_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRRay_Data* object = static_cast<const XRRay_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->origin, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->origin, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->direction, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->direction, validation_context))
    return false;

  return true;
}

XRRay_Data::XRRay_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHitResult_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRHitResult_Data* object = static_cast<const XRHitResult_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mojo_from_result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mojo_from_result, validation_context))
    return false;

  return true;
}

XRHitResult_Data::XRHitResult_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VREyeParameters_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VREyeParameters_Data* object = static_cast<const VREyeParameters_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->field_of_view, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->field_of_view, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->head_from_eye, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->head_from_eye, validation_context))
    return false;

  return true;
}

VREyeParameters_Data::VREyeParameters_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRStageParameters_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRStageParameters_Data* object = static_cast<const VRStageParameters_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mojo_from_floor, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mojo_from_floor, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams bounds_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->bounds, validation_context,
                                         &bounds_validate_params)) {
    return false;
  }

  return true;
}

VRStageParameters_Data::VRStageParameters_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRDisplayInfo_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRDisplayInfo_Data* object = static_cast<const VRDisplayInfo_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->stage_parameters, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->left_eye, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->right_eye, validation_context))
    return false;

  return true;
}

VRDisplayInfo_Data::VRDisplayInfo_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationTransportOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationTransportOptions_Data* object = static_cast<const XRPresentationTransportOptions_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::device::mojom::internal::XRPresentationTransportMethod_Data
        ::Validate(object->transport_method, validation_context))
    return false;

  return true;
}

XRPresentationTransportOptions_Data::XRPresentationTransportOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPlanePointData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPlanePointData_Data* object = static_cast<const XRPlanePointData_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

XRPlanePointData_Data::XRPlanePointData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPlaneData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPlaneData_Data* object = static_cast<const XRPlaneData_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::device::mojom::internal::XRPlaneOrientation_Data
        ::Validate(object->orientation, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->mojo_from_plane, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->polygon, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams polygon_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->polygon, validation_context,
                                         &polygon_validate_params)) {
    return false;
  }

  return true;
}

XRPlaneData_Data::XRPlaneData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPlaneDetectionData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPlaneDetectionData_Data* object = static_cast<const XRPlaneDetectionData_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->all_planes_ids, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams all_planes_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->all_planes_ids, validation_context,
                                         &all_planes_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->updated_planes_data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams updated_planes_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->updated_planes_data, validation_context,
                                         &updated_planes_data_validate_params)) {
    return false;
  }

  return true;
}

XRPlaneDetectionData_Data::XRPlaneDetectionData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRAnchorData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRAnchorData_Data* object = static_cast<const XRAnchorData_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->mojo_from_anchor, validation_context))
    return false;

  return true;
}

XRAnchorData_Data::XRAnchorData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRAnchorsData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRAnchorsData_Data* object = static_cast<const XRAnchorsData_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->all_anchors_ids, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams all_anchors_ids_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->all_anchors_ids, validation_context,
                                         &all_anchors_ids_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->updated_anchors_data, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams updated_anchors_data_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->updated_anchors_data, validation_context,
                                         &updated_anchors_data_validate_params)) {
    return false;
  }

  return true;
}

XRAnchorsData_Data::XRAnchorsData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHitTestSubscriptionResultData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRHitTestSubscriptionResultData_Data* object = static_cast<const XRHitTestSubscriptionResultData_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->hit_test_results, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams hit_test_results_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->hit_test_results, validation_context,
                                         &hit_test_results_validate_params)) {
    return false;
  }

  return true;
}

XRHitTestSubscriptionResultData_Data::XRHitTestSubscriptionResultData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHitTestTransientInputSubscriptionResultData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRHitTestTransientInputSubscriptionResultData_Data* object = static_cast<const XRHitTestTransientInputSubscriptionResultData_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_source_id_to_hit_test_results, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams input_source_id_to_hit_test_results_validate_params(
      new mojo::internal::ContainerValidateParams(0, false, nullptr), new mojo::internal::ContainerValidateParams(0, false, new mojo::internal::ContainerValidateParams(0, false, nullptr)));
  if (!mojo::internal::ValidateContainer(object->input_source_id_to_hit_test_results, validation_context,
                                         &input_source_id_to_hit_test_results_validate_params)) {
    return false;
  }

  return true;
}

XRHitTestTransientInputSubscriptionResultData_Data::XRHitTestTransientInputSubscriptionResultData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRHitTestSubscriptionResultsData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRHitTestSubscriptionResultsData_Data* object = static_cast<const XRHitTestSubscriptionResultsData_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->results, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams results_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->results, validation_context,
                                         &results_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->transient_input_results, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams transient_input_results_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->transient_input_results, validation_context,
                                         &transient_input_results_validate_params)) {
    return false;
  }

  return true;
}

XRHitTestSubscriptionResultsData_Data::XRHitTestSubscriptionResultsData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RgbTupleF32_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RgbTupleF32_Data* object = static_cast<const RgbTupleF32_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

RgbTupleF32_Data::RgbTupleF32_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSphericalHarmonics_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSphericalHarmonics_Data* object = static_cast<const XRSphericalHarmonics_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->coefficients, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams coefficients_validate_params(
      9, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->coefficients, validation_context,
                                         &coefficients_validate_params)) {
    return false;
  }

  return true;
}

XRSphericalHarmonics_Data::XRSphericalHarmonics_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RgbaTupleF16_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RgbaTupleF16_Data* object = static_cast<const RgbaTupleF16_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

RgbaTupleF16_Data::RgbaTupleF16_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRCubeMap_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRCubeMap_Data* object = static_cast<const XRCubeMap_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 64 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->positive_x, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams positive_x_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->positive_x, validation_context,
                                         &positive_x_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->negative_x, 3, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams negative_x_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->negative_x, validation_context,
                                         &negative_x_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->positive_y, 4, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams positive_y_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->positive_y, validation_context,
                                         &positive_y_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->negative_y, 5, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams negative_y_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->negative_y, validation_context,
                                         &negative_y_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->positive_z, 6, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams positive_z_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->positive_z, validation_context,
                                         &positive_z_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->negative_z, 7, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams negative_z_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->negative_z, validation_context,
                                         &negative_z_validate_params)) {
    return false;
  }

  return true;
}

XRCubeMap_Data::XRCubeMap_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRLightProbe_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRLightProbe_Data* object = static_cast<const XRLightProbe_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->spherical_harmonics, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->spherical_harmonics, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_light_direction, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_light_direction, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->main_light_intensity, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->main_light_intensity, validation_context))
    return false;

  return true;
}

XRLightProbe_Data::XRLightProbe_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRReflectionProbe_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRReflectionProbe_Data* object = static_cast<const XRReflectionProbe_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->cube_map, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->cube_map, validation_context))
    return false;

  return true;
}

XRReflectionProbe_Data::XRReflectionProbe_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRLightEstimationData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRLightEstimationData_Data* object = static_cast<const XRLightEstimationData_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->light_probe, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->reflection_probe, validation_context))
    return false;

  return true;
}

XRLightEstimationData_Data::XRLightEstimationData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRDepthDataStillValid_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRDepthDataStillValid_Data* object = static_cast<const XRDepthDataStillValid_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 8 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

XRDepthDataStillValid_Data::XRDepthDataStillValid_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRDepthDataUpdated_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRDepthDataUpdated_Data* object = static_cast<const XRDepthDataUpdated_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 48 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_delta, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_delta, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->pixel_data, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->pixel_data, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->norm_texture_from_norm_view, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->norm_texture_from_norm_view, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->size, validation_context))
    return false;

  return true;
}

XRDepthDataUpdated_Data::XRDepthDataUpdated_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameData_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRFrameData_Data* object = static_cast<const XRFrameData_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 128 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->pose, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_delta, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_delta, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->buffer_holder, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->camera_image_buffer_holder, validation_context))
    return false;

  if (!mojo::internal::ValidateInlinedUnion(object->depth_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->left_eye, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->right_eye, validation_context))
    return false;

  const mojo::internal::ContainerValidateParams input_state_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->input_state, validation_context,
                                         &input_state_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->stage_parameters, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->detected_planes_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->anchors_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->light_estimation_data, validation_context))
    return false;

  if (!mojo::internal::ValidateStruct(object->hit_test_subscription_results, validation_context))
    return false;

  return true;
}

XRFrameData_Data::XRFrameData_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool RequestSessionSuccess_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const RequestSessionSuccess_Data* object = static_cast<const RequestSessionSuccess_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->session, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->session, validation_context))
    return false;

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->metrics_recorder, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->metrics_recorder,
                                                 validation_context)) {
    return false;
  }

  return true;
}

RequestSessionSuccess_Data::RequestSessionSuccess_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataRequestOptions_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRFrameDataRequestOptions_Data* object = static_cast<const XRFrameDataRequestOptions_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

XRFrameDataRequestOptions_Data::XRFrameDataRequestOptions_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_SetClient_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_SetClient_Params_Data* object = static_cast<const VRService_SetClient_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->client, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->client,
                                                 validation_context)) {
    return false;
  }

  return true;
}

VRService_SetClient_Params_Data::VRService_SetClient_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_RequestSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_RequestSession_Params_Data* object = static_cast<const VRService_RequestSession_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

VRService_RequestSession_Params_Data::VRService_RequestSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_RequestSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_RequestSession_ResponseParams_Data* object = static_cast<const VRService_RequestSession_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->result, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->result, validation_context))
    return false;

  return true;
}

VRService_RequestSession_ResponseParams_Data::VRService_RequestSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_SupportsSession_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_SupportsSession_Params_Data* object = static_cast<const VRService_SupportsSession_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->options, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

VRService_SupportsSession_Params_Data::VRService_SupportsSession_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_SupportsSession_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_SupportsSession_ResponseParams_Data* object = static_cast<const VRService_SupportsSession_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

VRService_SupportsSession_ResponseParams_Data::VRService_SupportsSession_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_ExitPresent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_ExitPresent_Params_Data* object = static_cast<const VRService_ExitPresent_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 8 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

VRService_ExitPresent_Params_Data::VRService_ExitPresent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_ExitPresent_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_ExitPresent_ResponseParams_Data* object = static_cast<const VRService_ExitPresent_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 8 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

VRService_ExitPresent_ResponseParams_Data::VRService_ExitPresent_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_SetFramesThrottled_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_SetFramesThrottled_Params_Data* object = static_cast<const VRService_SetFramesThrottled_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

VRService_SetFramesThrottled_Params_Data::VRService_SetFramesThrottled_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_MakeXrCompatible_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_MakeXrCompatible_Params_Data* object = static_cast<const VRService_MakeXrCompatible_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 8 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

VRService_MakeXrCompatible_Params_Data::VRService_MakeXrCompatible_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRService_MakeXrCompatible_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRService_MakeXrCompatible_ResponseParams_Data* object = static_cast<const VRService_MakeXrCompatible_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::device::mojom::internal::XrCompatibleResult_Data
        ::Validate(object->xr_compatible_result, validation_context))
    return false;

  return true;
}

VRService_MakeXrCompatible_ResponseParams_Data::VRService_MakeXrCompatible_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data* object = static_cast<const XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::device::mojom::internal::XRSessionFeature_Data
        ::Validate(object->feature, validation_context))
    return false;

  return true;
}

XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data::XRSessionMetricsRecorder_ReportFeatureUsed_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool VRServiceClient_OnDeviceChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const VRServiceClient_OnDeviceChanged_Params_Data* object = static_cast<const VRServiceClient_OnDeviceChanged_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 8 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

VRServiceClient_OnDeviceChanged_Params_Data::VRServiceClient_OnDeviceChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data* object = static_cast<const XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->native_origin_information, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->native_origin_information, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entity_types, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams entity_types_validate_params(
      0, ::device::mojom::internal::EntityTypeForHitTest_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->entity_types, validation_context,
                                         &entity_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ray, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ray, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data::XREnvironmentIntegrationProvider_SubscribeToHitTest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data* object = static_cast<const XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::device::mojom::internal::SubscribeToHitTestResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data::XREnvironmentIntegrationProvider_SubscribeToHitTest_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data* object = static_cast<const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->profile_name, 1, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams profile_name_validate_params(
      0, false, nullptr);
  if (!mojo::internal::ValidateContainer(object->profile_name, validation_context,
                                         &profile_name_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->entity_types, 2, validation_context)) {
    return false;
  }
  const mojo::internal::ContainerValidateParams entity_types_validate_params(
      0, ::device::mojom::internal::EntityTypeForHitTest_Data::Validate);
  if (!mojo::internal::ValidateContainer(object->entity_types, validation_context,
                                         &entity_types_validate_params)) {
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->ray, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->ray, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data* object = static_cast<const XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::device::mojom::internal::SubscribeToHitTestResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data::XREnvironmentIntegrationProvider_SubscribeToHitTestForTransientInput_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data* object = static_cast<const XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data::XREnvironmentIntegrationProvider_UnsubscribeFromHitTest_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_CreateAnchor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_CreateAnchor_Params_Data* object = static_cast<const XREnvironmentIntegrationProvider_CreateAnchor_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->native_origin_information, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->native_origin_information, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->native_origin_from_anchor, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->native_origin_from_anchor, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_CreateAnchor_Params_Data::XREnvironmentIntegrationProvider_CreateAnchor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data* object = static_cast<const XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::device::mojom::internal::CreateAnchorResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data::XREnvironmentIntegrationProvider_CreateAnchor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data* object = static_cast<const XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateInlinedUnionNonNullable(
          object->native_origin_information, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateInlinedUnion(object->native_origin_information, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->native_origin_from_anchor, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->native_origin_from_anchor, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data::XREnvironmentIntegrationProvider_CreatePlaneAnchor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data* object = static_cast<const XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::device::mojom::internal::CreateAnchorResult_Data
        ::Validate(object->result, validation_context))
    return false;

  return true;
}

XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data::XREnvironmentIntegrationProvider_CreatePlaneAnchor_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XREnvironmentIntegrationProvider_DetachAnchor_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XREnvironmentIntegrationProvider_DetachAnchor_Params_Data* object = static_cast<const XREnvironmentIntegrationProvider_DetachAnchor_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

XREnvironmentIntegrationProvider_DetachAnchor_Params_Data::XREnvironmentIntegrationProvider_DetachAnchor_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRInputSourceButtonListener_OnButtonEvent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRInputSourceButtonListener_OnButtonEvent_Params_Data* object = static_cast<const XRInputSourceButtonListener_OnButtonEvent_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->input_source, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->input_source, validation_context))
    return false;

  return true;
}

XRInputSourceButtonListener_OnButtonEvent_Params_Data::XRInputSourceButtonListener_OnButtonEvent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataProvider_GetFrameData_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRFrameDataProvider_GetFrameData_Params_Data* object = static_cast<const XRFrameDataProvider_GetFrameData_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->options, validation_context))
    return false;

  return true;
}

XRFrameDataProvider_GetFrameData_Params_Data::XRFrameDataProvider_GetFrameData_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataProvider_GetFrameData_ResponseParams_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRFrameDataProvider_GetFrameData_ResponseParams_Data* object = static_cast<const XRFrameDataProvider_GetFrameData_ResponseParams_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateStruct(object->frame_data, validation_context))
    return false;

  return true;
}

XRFrameDataProvider_GetFrameData_ResponseParams_Data::XRFrameDataProvider_GetFrameData_ResponseParams_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data* object = static_cast<const XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->environment_provider, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->environment_provider,
                                                 validation_context)) {
    return false;
  }

  return true;
}

XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data::XRFrameDataProvider_GetEnvironmentIntegrationProvider_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRFrameDataProvider_SetInputSourceButtonListener_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRFrameDataProvider_SetInputSourceButtonListener_Params_Data* object = static_cast<const XRFrameDataProvider_SetInputSourceButtonListener_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterface(object->event_listener,
                                                 validation_context)) {
    return false;
  }

  return true;
}

XRFrameDataProvider_SetInputSourceButtonListener_Params_Data::XRFrameDataProvider_SetInputSourceButtonListener_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_UpdateLayerBounds_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationProvider_UpdateLayerBounds_Params_Data* object = static_cast<const XRPresentationProvider_UpdateLayerBounds_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 40 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->left_bounds, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->left_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->right_bounds, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->right_bounds, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->source_size, 4, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->source_size, validation_context))
    return false;

  return true;
}

XRPresentationProvider_UpdateLayerBounds_Params_Data::XRPresentationProvider_UpdateLayerBounds_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_SubmitFrameMissing_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationProvider_SubmitFrameMissing_Params_Data* object = static_cast<const XRPresentationProvider_SubmitFrameMissing_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 24 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  return true;
}

XRPresentationProvider_SubmitFrameMissing_Params_Data::XRPresentationProvider_SubmitFrameMissing_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_SubmitFrame_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationProvider_SubmitFrame_Params_Data* object = static_cast<const XRPresentationProvider_SubmitFrame_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->mailbox_holder, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->mailbox_holder, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_waited, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_waited, validation_context))
    return false;

  return true;
}

XRPresentationProvider_SubmitFrame_Params_Data::XRPresentationProvider_SubmitFrame_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data* object = static_cast<const XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidateHandleOrInterfaceNonNullable(
          object->texture, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateHandleOrInterface(object->texture,
                                                 validation_context)) {
    return false;
  }

  return true;
}

XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data::XRPresentationProvider_SubmitFrameWithTextureHandle_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data* object = static_cast<const XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 32 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->sync_token, 2, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->sync_token, validation_context))
    return false;

  if (!mojo::internal::ValidatePointerNonNullable(
          object->time_waited, 3, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->time_waited, validation_context))
    return false;

  return true;
}

XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data::XRPresentationProvider_SubmitFrameDrawnIntoTexture_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationClient_OnSubmitFrameTransferred_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationClient_OnSubmitFrameTransferred_Params_Data* object = static_cast<const XRPresentationClient_OnSubmitFrameTransferred_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

XRPresentationClient_OnSubmitFrameTransferred_Params_Data::XRPresentationClient_OnSubmitFrameTransferred_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationClient_OnSubmitFrameRendered_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationClient_OnSubmitFrameRendered_Params_Data* object = static_cast<const XRPresentationClient_OnSubmitFrameRendered_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 8 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

XRPresentationClient_OnSubmitFrameRendered_Params_Data::XRPresentationClient_OnSubmitFrameRendered_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRPresentationClient_OnSubmitFrameGpuFence_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRPresentationClient_OnSubmitFrameGpuFence_Params_Data* object = static_cast<const XRPresentationClient_OnSubmitFrameGpuFence_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->gpu_fence_handle, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->gpu_fence_handle, validation_context))
    return false;

  return true;
}

XRPresentationClient_OnSubmitFrameGpuFence_Params_Data::XRPresentationClient_OnSubmitFrameGpuFence_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionClient_OnChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSessionClient_OnChanged_Params_Data* object = static_cast<const XRSessionClient_OnChanged_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  if (!mojo::internal::ValidatePointerNonNullable(
          object->display, 1, validation_context)) {
    return false;
  }
  if (!mojo::internal::ValidateStruct(object->display, validation_context))
    return false;

  return true;
}

XRSessionClient_OnChanged_Params_Data::XRSessionClient_OnChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionClient_OnExitPresent_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSessionClient_OnExitPresent_Params_Data* object = static_cast<const XRSessionClient_OnExitPresent_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 8 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }

  return true;
}

XRSessionClient_OnExitPresent_Params_Data::XRSessionClient_OnExitPresent_Params_Data()
    : header_({sizeof(*this), 0}) {}


// static
bool XRSessionClient_OnVisibilityStateChanged_Params_Data::Validate(
    const void* data,
    mojo::internal::ValidationContext* validation_context) {
  if (!data)
    return true;

  if (!ValidateStructHeaderAndClaimMemory(data, validation_context))
    return false;

  // NOTE: The memory backing |object| may be smaller than |sizeof(*object)| if
  // the message comes from an older version.
  const XRSessionClient_OnVisibilityStateChanged_Params_Data* object = static_cast<const XRSessionClient_OnVisibilityStateChanged_Params_Data*>(data);

  static constexpr struct {
    uint32_t version;
    uint32_t num_bytes;
  } kVersionSizes[] = {{ 0, 16 }};

  if (object->header_.version <=
          kVersionSizes[base::size(kVersionSizes) - 1].version) {
    // Scan in reverse order to optimize for more recent versions.
    for (int i = base::size(kVersionSizes) - 1; i >= 0; --i) {
      if (object->header_.version >= kVersionSizes[i].version) {
        if (object->header_.num_bytes == kVersionSizes[i].num_bytes)
          break;

        ReportValidationError(
            validation_context,
            mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
        return false;
      }
    }
  } else if (object->header_.num_bytes <
                 kVersionSizes[base::size(kVersionSizes) - 1].num_bytes) {
    ReportValidationError(
        validation_context,
        mojo::internal::VALIDATION_ERROR_UNEXPECTED_STRUCT_HEADER);
    return false;
  }


  if (!::device::mojom::internal::XRVisibilityState_Data
        ::Validate(object->visibility_state, validation_context))
    return false;

  return true;
}

XRSessionClient_OnVisibilityStateChanged_Params_Data::XRSessionClient_OnVisibilityStateChanged_Params_Data()
    : header_({sizeof(*this), 0}) {}

}  // namespace internal
}  // namespace mojom
}  // namespace device