// content/common/render_message_filter.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_H_
#define CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/render_message_filter.mojom-shared.h"
#include "content/common/render_message_filter.mojom-forward.h"
#include "mojo/public/mojom/base/thread_priority.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class RenderMessageFilterProxy;

template <typename ImplRefTraits>
class RenderMessageFilterStub;

class RenderMessageFilterRequestValidator;
class RenderMessageFilterResponseValidator;


class CONTENT_EXPORT RenderMessageFilter
    : public RenderMessageFilterInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = RenderMessageFilterInterfaceBase;
  using Proxy_ = RenderMessageFilterProxy;

  template <typename ImplRefTraits>
  using Stub_ = RenderMessageFilterStub<ImplRefTraits>;

  using RequestValidator_ = RenderMessageFilterRequestValidator;
  using ResponseValidator_ = RenderMessageFilterResponseValidator;
  enum MethodMinVersions : uint32_t {
    kGenerateRoutingIDMinVersion = 0,
    kHasGpuProcessMinVersion = 0,
    kSetThreadPriorityMinVersion = 0,
  };
  virtual ~RenderMessageFilter() {}

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GenerateRoutingID(int32_t* out_routing_id);

  using GenerateRoutingIDCallback = base::OnceCallback<void(int32_t)>;
  
  virtual void GenerateRoutingID(GenerateRoutingIDCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool HasGpuProcess(bool* out_has_gpu_process);

  using HasGpuProcessCallback = base::OnceCallback<void(bool)>;
  
  virtual void HasGpuProcess(HasGpuProcessCallback callback) = 0;

  
  virtual void SetThreadPriority(int32_t platform_thread_id, ::base::ThreadPriority thread_priority) = 0;
};



class CONTENT_EXPORT RenderMessageFilterProxy
    : public RenderMessageFilter {
 public:
  using InterfaceType = RenderMessageFilter;

  explicit RenderMessageFilterProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool GenerateRoutingID(int32_t* out_routing_id) final;
  
  void GenerateRoutingID(GenerateRoutingIDCallback callback) final;
  
  bool HasGpuProcess(bool* out_has_gpu_process) final;
  
  void HasGpuProcess(HasGpuProcessCallback callback) final;
  
  void SetThreadPriority(int32_t platform_thread_id, ::base::ThreadPriority thread_priority) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT RenderMessageFilterStubDispatch {
 public:
  static bool Accept(RenderMessageFilter* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RenderMessageFilter* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RenderMessageFilter>>
class RenderMessageFilterStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RenderMessageFilterStub() {}
  ~RenderMessageFilterStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderMessageFilterStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderMessageFilterStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT RenderMessageFilterRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT RenderMessageFilterResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace content

namespace mojo {

}  // namespace mojo

#endif  // CONTENT_COMMON_RENDER_MESSAGE_FILTER_MOJOM_H_