// content/common/render_accessibility.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_H_
#define CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "content/common/render_accessibility.mojom-shared.h"
#include "content/common/render_accessibility.mojom-forward.h"
#include "ui/accessibility/ax_enums.mojom-forward.h"
#include "ui/accessibility/mojom/ax_action_data.mojom.h"
#include "ui/accessibility/mojom/ax_event.mojom.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom.h"
#include "ui/gfx/geometry/mojom/geometry.mojom.h"
#include "mojo/public/mojom/base/unguessable_token.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "content/common/content_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace content {
namespace mojom {

class RenderAccessibilityHostProxy;

template <typename ImplRefTraits>
class RenderAccessibilityHostStub;

class RenderAccessibilityHostRequestValidator;
class RenderAccessibilityHostResponseValidator;


class CONTENT_EXPORT RenderAccessibilityHost
    : public RenderAccessibilityHostInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RenderAccessibilityHostInterfaceBase;
  using Proxy_ = RenderAccessibilityHostProxy;

  template <typename ImplRefTraits>
  using Stub_ = RenderAccessibilityHostStub<ImplRefTraits>;

  using RequestValidator_ = RenderAccessibilityHostRequestValidator;
  using ResponseValidator_ = RenderAccessibilityHostResponseValidator;
  enum MethodMinVersions : uint32_t {
    kHandleAXEventsMinVersion = 0,
    kHandleAXLocationChangesMinVersion = 0,
  };
  virtual ~RenderAccessibilityHost() {}


  using HandleAXEventsCallback = base::OnceCallback<void()>;
  
  virtual void HandleAXEvents(const std::vector<::ui::AXTreeUpdate>& updates, const std::vector<::ui::AXEvent>& events, int32_t reset_token, HandleAXEventsCallback callback) = 0;

  
  virtual void HandleAXLocationChanges(std::vector<LocationChangesPtr> changes) = 0;
};

class RenderAccessibilityProxy;

template <typename ImplRefTraits>
class RenderAccessibilityStub;

class RenderAccessibilityRequestValidator;
class RenderAccessibilityResponseValidator;


class CONTENT_EXPORT RenderAccessibility
    : public RenderAccessibilityInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = RenderAccessibilityInterfaceBase;
  using Proxy_ = RenderAccessibilityProxy;

  template <typename ImplRefTraits>
  using Stub_ = RenderAccessibilityStub<ImplRefTraits>;

  using RequestValidator_ = RenderAccessibilityRequestValidator;
  using ResponseValidator_ = RenderAccessibilityResponseValidator;
  enum MethodMinVersions : uint32_t {
    kSetModeMinVersion = 0,
    kFatalErrorMinVersion = 0,
    kHitTestMinVersion = 0,
    kPerformActionMinVersion = 0,
    kResetMinVersion = 0,
  };
  virtual ~RenderAccessibility() {}

  
  virtual void SetMode(uint32_t ax_mode) = 0;

  
  virtual void FatalError() = 0;


  using HitTestCallback = base::OnceCallback<void(HitTestResponsePtr)>;
  
  virtual void HitTest(const ::gfx::Point& point, ::ax::mojom::Event event_to_fire, int32_t request_id, HitTestCallback callback) = 0;

  
  virtual void PerformAction(const ::ui::AXActionData& action_data) = 0;

  
  virtual void Reset(int32_t reset_token) = 0;
};



class CONTENT_EXPORT RenderAccessibilityHostProxy
    : public RenderAccessibilityHost {
 public:
  using InterfaceType = RenderAccessibilityHost;

  explicit RenderAccessibilityHostProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void HandleAXEvents(const std::vector<::ui::AXTreeUpdate>& updates, const std::vector<::ui::AXEvent>& events, int32_t reset_token, HandleAXEventsCallback callback) final;
  
  void HandleAXLocationChanges(std::vector<LocationChangesPtr> changes) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class CONTENT_EXPORT RenderAccessibilityProxy
    : public RenderAccessibility {
 public:
  using InterfaceType = RenderAccessibility;

  explicit RenderAccessibilityProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void SetMode(uint32_t ax_mode) final;
  
  void FatalError() final;
  
  void HitTest(const ::gfx::Point& point, ::ax::mojom::Event event_to_fire, int32_t request_id, HitTestCallback callback) final;
  
  void PerformAction(const ::ui::AXActionData& action_data) final;
  
  void Reset(int32_t reset_token) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class CONTENT_EXPORT RenderAccessibilityHostStubDispatch {
 public:
  static bool Accept(RenderAccessibilityHost* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RenderAccessibilityHost* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RenderAccessibilityHost>>
class RenderAccessibilityHostStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RenderAccessibilityHostStub() {}
  ~RenderAccessibilityHostStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderAccessibilityHostStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderAccessibilityHostStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT RenderAccessibilityStubDispatch {
 public:
  static bool Accept(RenderAccessibility* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      RenderAccessibility* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<RenderAccessibility>>
class RenderAccessibilityStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  RenderAccessibilityStub() {}
  ~RenderAccessibilityStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderAccessibilityStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return RenderAccessibilityStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class CONTENT_EXPORT RenderAccessibilityHostRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT RenderAccessibilityRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT RenderAccessibilityHostResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class CONTENT_EXPORT RenderAccessibilityResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};









class CONTENT_EXPORT LocationChanges {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<LocationChanges, T>::value>;
  using DataView = LocationChangesDataView;
  using Data_ = internal::LocationChanges_Data;

  template <typename... Args>
  static LocationChangesPtr New(Args&&... args) {
    return LocationChangesPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static LocationChangesPtr From(const U& u) {
    return mojo::TypeConverter<LocationChangesPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, LocationChanges>::Convert(*this);
  }


  LocationChanges();

  LocationChanges(
      int32_t id,
      const ::ui::AXRelativeBounds& new_location);

  ~LocationChanges();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = LocationChangesPtr>
  LocationChangesPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, LocationChanges::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        LocationChanges::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        LocationChanges::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::LocationChanges_UnserializedMessageContext<
            UserType, LocationChanges::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<LocationChanges::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return LocationChanges::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::LocationChanges_UnserializedMessageContext<
            UserType, LocationChanges::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<LocationChanges::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  int32_t id;
  
  ::ui::AXRelativeBounds new_location;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, LocationChanges::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, LocationChanges::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, LocationChanges::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, LocationChanges::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}





class CONTENT_EXPORT HitTestResponse {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<HitTestResponse, T>::value>;
  using DataView = HitTestResponseDataView;
  using Data_ = internal::HitTestResponse_Data;

  template <typename... Args>
  static HitTestResponsePtr New(Args&&... args) {
    return HitTestResponsePtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static HitTestResponsePtr From(const U& u) {
    return mojo::TypeConverter<HitTestResponsePtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, HitTestResponse>::Convert(*this);
  }


  HitTestResponse();

  HitTestResponse(
      const ::base::UnguessableToken& hit_frame_token,
      const ::gfx::Point& hit_frame_transformed_point,
      int32_t hit_node_id);

  ~HitTestResponse();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = HitTestResponsePtr>
  HitTestResponsePtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, HitTestResponse::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        HitTestResponse::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        HitTestResponse::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::HitTestResponse_UnserializedMessageContext<
            UserType, HitTestResponse::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<HitTestResponse::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return HitTestResponse::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::HitTestResponse_UnserializedMessageContext<
            UserType, HitTestResponse::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<HitTestResponse::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::UnguessableToken hit_frame_token;
  
  ::gfx::Point hit_frame_transformed_point;
  
  int32_t hit_node_id;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, HitTestResponse::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, HitTestResponse::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, HitTestResponse::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, HitTestResponse::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}

template <typename StructPtrType>
LocationChangesPtr LocationChanges::Clone() const {
  return New(
      mojo::Clone(id),
      mojo::Clone(new_location)
  );
}

template <typename T, LocationChanges::EnableIfSame<T>*>
bool LocationChanges::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->id, other_struct.id))
    return false;
  if (!mojo::Equals(this->new_location, other_struct.new_location))
    return false;
  return true;
}

template <typename T, LocationChanges::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.id, rhs.id))
    return true;
  if (std::less<>{}(rhs.id, lhs.id))
    return false;
  if (std::less<>{}(lhs.new_location, rhs.new_location))
    return true;
  if (std::less<>{}(rhs.new_location, lhs.new_location))
    return false;
  return false;
}
template <typename StructPtrType>
HitTestResponsePtr HitTestResponse::Clone() const {
  return New(
      mojo::Clone(hit_frame_token),
      mojo::Clone(hit_frame_transformed_point),
      mojo::Clone(hit_node_id)
  );
}

template <typename T, HitTestResponse::EnableIfSame<T>*>
bool HitTestResponse::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->hit_frame_token, other_struct.hit_frame_token))
    return false;
  if (!mojo::Equals(this->hit_frame_transformed_point, other_struct.hit_frame_transformed_point))
    return false;
  if (!mojo::Equals(this->hit_node_id, other_struct.hit_node_id))
    return false;
  return true;
}

template <typename T, HitTestResponse::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.hit_frame_token, rhs.hit_frame_token))
    return true;
  if (std::less<>{}(rhs.hit_frame_token, lhs.hit_frame_token))
    return false;
  if (std::less<>{}(lhs.hit_frame_transformed_point, rhs.hit_frame_transformed_point))
    return true;
  if (std::less<>{}(rhs.hit_frame_transformed_point, lhs.hit_frame_transformed_point))
    return false;
  if (std::less<>{}(lhs.hit_node_id, rhs.hit_node_id))
    return true;
  if (std::less<>{}(rhs.hit_node_id, lhs.hit_node_id))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace content

namespace mojo {


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::LocationChanges::DataView,
                                         ::content::mojom::LocationChangesPtr> {
  static bool IsNull(const ::content::mojom::LocationChangesPtr& input) { return !input; }
  static void SetToNull(::content::mojom::LocationChangesPtr* output) { output->reset(); }

  static decltype(::content::mojom::LocationChanges::id) id(
      const ::content::mojom::LocationChangesPtr& input) {
    return input->id;
  }

  static const decltype(::content::mojom::LocationChanges::new_location)& new_location(
      const ::content::mojom::LocationChangesPtr& input) {
    return input->new_location;
  }

  static bool Read(::content::mojom::LocationChanges::DataView input, ::content::mojom::LocationChangesPtr* output);
};


template <>
struct CONTENT_EXPORT StructTraits<::content::mojom::HitTestResponse::DataView,
                                         ::content::mojom::HitTestResponsePtr> {
  static bool IsNull(const ::content::mojom::HitTestResponsePtr& input) { return !input; }
  static void SetToNull(::content::mojom::HitTestResponsePtr* output) { output->reset(); }

  static const decltype(::content::mojom::HitTestResponse::hit_frame_token)& hit_frame_token(
      const ::content::mojom::HitTestResponsePtr& input) {
    return input->hit_frame_token;
  }

  static const decltype(::content::mojom::HitTestResponse::hit_frame_transformed_point)& hit_frame_transformed_point(
      const ::content::mojom::HitTestResponsePtr& input) {
    return input->hit_frame_transformed_point;
  }

  static decltype(::content::mojom::HitTestResponse::hit_node_id) hit_node_id(
      const ::content::mojom::HitTestResponsePtr& input) {
    return input->hit_node_id;
  }

  static bool Read(::content::mojom::HitTestResponse::DataView input, ::content::mojom::HitTestResponsePtr* output);
};

}  // namespace mojo

#endif  // CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_H_