// content/common/render_accessibility.mojom-shared-internal.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_SHARED_INTERNAL_H_
#define CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_SHARED_INTERNAL_H_

#include "mojo/public/cpp/bindings/lib/array_internal.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/map_data_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "ui/accessibility/ax_enums.mojom-shared-internal.h"
#include "ui/accessibility/mojom/ax_action_data.mojom-shared-internal.h"
#include "ui/accessibility/mojom/ax_event.mojom-shared-internal.h"
#include "ui/accessibility/mojom/ax_relative_bounds.mojom-shared-internal.h"
#include "ui/accessibility/mojom/ax_tree_update.mojom-shared-internal.h"
#include "ui/gfx/geometry/mojom/geometry.mojom-shared-internal.h"
#include "mojo/public/mojom/base/unguessable_token.mojom-shared-internal.h"
#include "mojo/public/cpp/bindings/lib/native_enum_data.h"
#include "mojo/public/interfaces/bindings/native_struct.mojom-shared-internal.h"
#include "base/component_export.h"



namespace mojo {
namespace internal {
class ValidationContext;
}
}
namespace content {
namespace mojom {
namespace internal {
class LocationChanges_Data;
class HitTestResponse_Data;

#pragma pack(push, 1)
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) LocationChanges_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(LocationChanges_Data));
      new (data()) LocationChanges_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    LocationChanges_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<LocationChanges_Data>(index_);
    }
    LocationChanges_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t id;
  uint8_t pad0_[4];
  mojo::internal::Pointer<::ax::mojom::internal::AXRelativeBounds_Data> new_location;

 private:
  LocationChanges_Data();
  ~LocationChanges_Data() = delete;
};
static_assert(sizeof(LocationChanges_Data) == 24,
              "Bad sizeof(LocationChanges_Data)");
// Used by LocationChanges::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct LocationChanges_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  LocationChanges_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~LocationChanges_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    LocationChanges_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    LocationChanges_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) HitTestResponse_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(HitTestResponse_Data));
      new (data()) HitTestResponse_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    HitTestResponse_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<HitTestResponse_Data>(index_);
    }
    HitTestResponse_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<::mojo_base::mojom::internal::UnguessableToken_Data> hit_frame_token;
  mojo::internal::Pointer<::gfx::mojom::internal::Point_Data> hit_frame_transformed_point;
  int32_t hit_node_id;
  uint8_t padfinal_[4];

 private:
  HitTestResponse_Data();
  ~HitTestResponse_Data() = delete;
};
static_assert(sizeof(HitTestResponse_Data) == 32,
              "Bad sizeof(HitTestResponse_Data)");
// Used by HitTestResponse::WrapAsMessage to lazily serialize the struct.
template <typename UserType, typename DataView>
struct HitTestResponse_UnserializedMessageContext
    : public mojo::internal::UnserializedMessageContext {
 public:
  static const mojo::internal::UnserializedMessageContext::Tag kMessageTag;

  HitTestResponse_UnserializedMessageContext(
    uint32_t message_name,
    uint32_t message_flags,
    UserType input)
      : mojo::internal::UnserializedMessageContext(&kMessageTag, message_name, message_flags)
      , user_data_(std::move(input)) {}
  ~HitTestResponse_UnserializedMessageContext() override = default;

  UserType TakeData() {
    return std::move(user_data_);
  }

 private:
  // mojo::internal::UnserializedMessageContext:
  void Serialize(mojo::internal::SerializationContext* context,
                 mojo::internal::Buffer* buffer) override {
    HitTestResponse_Data::BufferWriter writer;
    mojo::internal::Serialize<DataView>(user_data_, buffer, &writer, context);
  }

  UserType user_data_;
};

template <typename UserType, typename DataView>
const mojo::internal::UnserializedMessageContext::Tag
    HitTestResponse_UnserializedMessageContext<UserType, DataView>::kMessageTag = {};

#pragma pack(pop)

}  // namespace internal
}  // namespace mojom
}  // namespace content

#endif  // CONTENT_COMMON_RENDER_ACCESSIBILITY_MOJOM_SHARED_INTERNAL_H_