// content/common/download/mhtml_file_writer.mojom-params-data.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2019 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_PARAMS_DATA_H_
#define CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_PARAMS_DATA_H_

#include "base/macros.h"
#include "mojo/public/cpp/bindings/lib/bindings_internal.h"
#include "mojo/public/cpp/bindings/lib/buffer.h"
#include "mojo/public/cpp/bindings/lib/validation_context.h"

#if defined(__clang__)
#pragma clang diagnostic push
#pragma clang diagnostic ignored "-Wunused-private-field"
#endif
namespace content {
namespace mojom {
namespace internal {
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) MhtmlFileWriter_SerializeAsMHTML_Params_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MhtmlFileWriter_SerializeAsMHTML_Params_Data));
      new (data()) MhtmlFileWriter_SerializeAsMHTML_Params_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MhtmlFileWriter_SerializeAsMHTML_Params_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MhtmlFileWriter_SerializeAsMHTML_Params_Data>(index_);
    }
    MhtmlFileWriter_SerializeAsMHTML_Params_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  mojo::internal::Pointer<internal::SerializeAsMHTMLParams_Data> params;

 private:
  MhtmlFileWriter_SerializeAsMHTML_Params_Data();
  ~MhtmlFileWriter_SerializeAsMHTML_Params_Data() = delete;
};
static_assert(sizeof(MhtmlFileWriter_SerializeAsMHTML_Params_Data) == 16,
              "Bad sizeof(MhtmlFileWriter_SerializeAsMHTML_Params_Data)");
class COMPONENT_EXPORT(MOJOM_SHARED_CONTENT_EXPORT) MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data {
 public:
  class BufferWriter {
   public:
    BufferWriter() = default;

    void Allocate(mojo::internal::Buffer* serialization_buffer) {
      serialization_buffer_ = serialization_buffer;
      index_ = serialization_buffer_->Allocate(sizeof(MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data));
      new (data()) MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data();
    }

    bool is_null() const { return !serialization_buffer_; }
    MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data* data() {
      DCHECK(!is_null());
      return serialization_buffer_->Get<MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data>(index_);
    }
    MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data* operator->() { return data(); }

   private:
    mojo::internal::Buffer* serialization_buffer_ = nullptr;
    size_t index_ = 0;

    DISALLOW_COPY_AND_ASSIGN(BufferWriter);
  };

  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);

  mojo::internal::StructHeader header_;
  int32_t status;
  uint8_t pad0_[4];
  mojo::internal::Pointer<mojo::internal::Array_Data<mojo::internal::Pointer<mojo::internal::String_Data>>> digests_of_uris_to_skip;
  mojo::internal::Pointer<::mojo_base::mojom::internal::TimeDelta_Data> renderer_main_thread_time;

 private:
  MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data();
  ~MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data() = delete;
};
static_assert(sizeof(MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data) == 32,
              "Bad sizeof(MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data)");

}  // namespace internal


class MhtmlFileWriter_SerializeAsMHTML_ParamsDataView {
 public:
  MhtmlFileWriter_SerializeAsMHTML_ParamsDataView() {}

  MhtmlFileWriter_SerializeAsMHTML_ParamsDataView(
      internal::MhtmlFileWriter_SerializeAsMHTML_Params_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  inline void GetParamsDataView(
      SerializeAsMHTMLParamsDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadParams(UserType* output) {
    
    auto* pointer = data_->params.Get();
    return mojo::internal::Deserialize<::content::mojom::SerializeAsMHTMLParamsDataView>(
        pointer, output, context_);
  }
 private:
  internal::MhtmlFileWriter_SerializeAsMHTML_Params_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};



class MhtmlFileWriter_SerializeAsMHTML_ResponseParamsDataView {
 public:
  MhtmlFileWriter_SerializeAsMHTML_ResponseParamsDataView() {}

  MhtmlFileWriter_SerializeAsMHTML_ResponseParamsDataView(
      internal::MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data* data,
      mojo::internal::SerializationContext* context)
      : data_(data), context_(context) {}

  bool is_null() const { return !data_; }
  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadStatus(UserType* output) const {
    auto data_value = data_->status;
    return mojo::internal::Deserialize<::content::mojom::MhtmlSaveStatus>(
        data_value, output);
  }

  MhtmlSaveStatus status() const {
    return static_cast<MhtmlSaveStatus>(data_->status);
  }
  inline void GetDigestsOfUrisToSkipDataView(
      mojo::ArrayDataView<mojo::StringDataView>* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadDigestsOfUrisToSkip(UserType* output) {
    
    auto* pointer = data_->digests_of_uris_to_skip.Get();
    return mojo::internal::Deserialize<mojo::ArrayDataView<mojo::StringDataView>>(
        pointer, output, context_);
  }
  inline void GetRendererMainThreadTimeDataView(
      ::mojo_base::mojom::TimeDeltaDataView* output);

  template <typename UserType>
  WARN_UNUSED_RESULT bool ReadRendererMainThreadTime(UserType* output) {
    
    auto* pointer = data_->renderer_main_thread_time.Get();
    return mojo::internal::Deserialize<::mojo_base::mojom::TimeDeltaDataView>(
        pointer, output, context_);
  }
 private:
  internal::MhtmlFileWriter_SerializeAsMHTML_ResponseParams_Data* data_ = nullptr;
  mojo::internal::SerializationContext* context_ = nullptr;
};


inline void MhtmlFileWriter_SerializeAsMHTML_ParamsDataView::GetParamsDataView(
    SerializeAsMHTMLParamsDataView* output) {
  auto pointer = data_->params.Get();
  *output = SerializeAsMHTMLParamsDataView(pointer, context_);
}


inline void MhtmlFileWriter_SerializeAsMHTML_ResponseParamsDataView::GetDigestsOfUrisToSkipDataView(
    mojo::ArrayDataView<mojo::StringDataView>* output) {
  auto pointer = data_->digests_of_uris_to_skip.Get();
  *output = mojo::ArrayDataView<mojo::StringDataView>(pointer, context_);
}
inline void MhtmlFileWriter_SerializeAsMHTML_ResponseParamsDataView::GetRendererMainThreadTimeDataView(
    ::mojo_base::mojom::TimeDeltaDataView* output) {
  auto pointer = data_->renderer_main_thread_time.Get();
  *output = ::mojo_base::mojom::TimeDeltaDataView(pointer, context_);
}

}  // namespace mojom
}  // namespace content

#if defined(__clang__)
#pragma clang diagnostic pop
#endif

#endif  // CONTENT_COMMON_DOWNLOAD_MHTML_FILE_WRITER_MOJOM_PARAMS_DATA_H_