// This file is generated by TypeBuilder_h.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef content_protocol_Target_h
#define content_protocol_Target_h

#include "content/common/content_export.h"
#include "content/browser/devtools/protocol/protocol.h"
// For each imported domain we generate a ValueConversions struct instead of a full domain definition
// and include Domain::API version from there.

namespace content {
namespace protocol {
namespace Target {
using TargetID = String;
using SessionID = String;
class TargetInfo;
class RemoteLocation;

// ------------- Forward and enum declarations.

// ------------- Type and builder declarations.

class CONTENT_EXPORT TargetInfo : public ::crdtp::ProtocolObject<TargetInfo> {
public:
    ~TargetInfo() override { }

    String GetTargetId() { return m_targetId; }
    void SetTargetId(const String& value) { m_targetId = value; }

    String GetType() { return m_type; }
    void SetType(const String& value) { m_type = value; }

    String GetTitle() { return m_title; }
    void SetTitle(const String& value) { m_title = value; }

    String GetUrl() { return m_url; }
    void SetUrl(const String& value) { m_url = value; }

    bool GetAttached() { return m_attached; }
    void SetAttached(bool value) { m_attached = value; }

    bool HasOpenerId() { return m_openerId.isJust(); }
    String GetOpenerId(const String& defaultValue) { return m_openerId.isJust() ? m_openerId.fromJust() : defaultValue; }
    void SetOpenerId(const String& value) { m_openerId = value; }

    bool GetCanAccessOpener() { return m_canAccessOpener; }
    void SetCanAccessOpener(bool value) { m_canAccessOpener = value; }

    bool HasOpenerFrameId() { return m_openerFrameId.isJust(); }
    String GetOpenerFrameId(const String& defaultValue) { return m_openerFrameId.isJust() ? m_openerFrameId.fromJust() : defaultValue; }
    void SetOpenerFrameId(const String& value) { m_openerFrameId = value; }

    bool HasBrowserContextId() { return m_browserContextId.isJust(); }
    String GetBrowserContextId(const String& defaultValue) { return m_browserContextId.isJust() ? m_browserContextId.fromJust() : defaultValue; }
    void SetBrowserContextId(const String& value) { m_browserContextId = value; }

    template<int STATE>
    class TargetInfoBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            TargetIdSet = 1 << 1,
            TypeSet = 1 << 2,
            TitleSet = 1 << 3,
            UrlSet = 1 << 4,
            AttachedSet = 1 << 5,
            CanAccessOpenerSet = 1 << 6,
            AllFieldsSet = (TargetIdSet | TypeSet | TitleSet | UrlSet | AttachedSet | CanAccessOpenerSet | 0)};


        TargetInfoBuilder<STATE | TargetIdSet>& SetTargetId(const String& value)
        {
            static_assert(!(STATE & TargetIdSet), "property targetId should not be set yet");
            m_result->SetTargetId(value);
            return castState<TargetIdSet>();
        }

        TargetInfoBuilder<STATE | TypeSet>& SetType(const String& value)
        {
            static_assert(!(STATE & TypeSet), "property type should not be set yet");
            m_result->SetType(value);
            return castState<TypeSet>();
        }

        TargetInfoBuilder<STATE | TitleSet>& SetTitle(const String& value)
        {
            static_assert(!(STATE & TitleSet), "property title should not be set yet");
            m_result->SetTitle(value);
            return castState<TitleSet>();
        }

        TargetInfoBuilder<STATE | UrlSet>& SetUrl(const String& value)
        {
            static_assert(!(STATE & UrlSet), "property url should not be set yet");
            m_result->SetUrl(value);
            return castState<UrlSet>();
        }

        TargetInfoBuilder<STATE | AttachedSet>& SetAttached(bool value)
        {
            static_assert(!(STATE & AttachedSet), "property attached should not be set yet");
            m_result->SetAttached(value);
            return castState<AttachedSet>();
        }

        TargetInfoBuilder<STATE>& SetOpenerId(const String& value)
        {
            m_result->SetOpenerId(value);
            return *this;
        }

        TargetInfoBuilder<STATE | CanAccessOpenerSet>& SetCanAccessOpener(bool value)
        {
            static_assert(!(STATE & CanAccessOpenerSet), "property canAccessOpener should not be set yet");
            m_result->SetCanAccessOpener(value);
            return castState<CanAccessOpenerSet>();
        }

        TargetInfoBuilder<STATE>& SetOpenerFrameId(const String& value)
        {
            m_result->SetOpenerFrameId(value);
            return *this;
        }

        TargetInfoBuilder<STATE>& SetBrowserContextId(const String& value)
        {
            m_result->SetBrowserContextId(value);
            return *this;
        }

        std::unique_ptr<TargetInfo> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class TargetInfo;
        TargetInfoBuilder() : m_result(new TargetInfo()) { }

        template<int STEP> TargetInfoBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<TargetInfoBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Target::TargetInfo> m_result;
    };

    static TargetInfoBuilder<0> Create()
    {
        return TargetInfoBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    TargetInfo()
    {
          m_attached = false;
          m_canAccessOpener = false;
    }

    String m_targetId;
    String m_type;
    String m_title;
    String m_url;
    bool m_attached;
    Maybe<String> m_openerId;
    bool m_canAccessOpener;
    Maybe<String> m_openerFrameId;
    Maybe<String> m_browserContextId;
};


class CONTENT_EXPORT RemoteLocation : public ::crdtp::ProtocolObject<RemoteLocation> {
public:
    ~RemoteLocation() override { }

    String GetHost() { return m_host; }
    void SetHost(const String& value) { m_host = value; }

    int GetPort() { return m_port; }
    void SetPort(int value) { m_port = value; }

    template<int STATE>
    class RemoteLocationBuilder {
    public:
        enum {
            NoFieldsSet = 0,
            HostSet = 1 << 1,
            PortSet = 1 << 2,
            AllFieldsSet = (HostSet | PortSet | 0)};


        RemoteLocationBuilder<STATE | HostSet>& SetHost(const String& value)
        {
            static_assert(!(STATE & HostSet), "property host should not be set yet");
            m_result->SetHost(value);
            return castState<HostSet>();
        }

        RemoteLocationBuilder<STATE | PortSet>& SetPort(int value)
        {
            static_assert(!(STATE & PortSet), "property port should not be set yet");
            m_result->SetPort(value);
            return castState<PortSet>();
        }

        std::unique_ptr<RemoteLocation> Build()
        {
            static_assert(STATE == AllFieldsSet, "state should be AllFieldsSet");
            return std::move(m_result);
        }

    private:
        friend class RemoteLocation;
        RemoteLocationBuilder() : m_result(new RemoteLocation()) { }

        template<int STEP> RemoteLocationBuilder<STATE | STEP>& castState()
        {
            return *reinterpret_cast<RemoteLocationBuilder<STATE | STEP>*>(this);
        }

        std::unique_ptr<protocol::Target::RemoteLocation> m_result;
    };

    static RemoteLocationBuilder<0> Create()
    {
        return RemoteLocationBuilder<0>();
    }

private:
    DECLARE_SERIALIZATION_SUPPORT();

    RemoteLocation()
    {
          m_port = 0;
    }

    String m_host;
    int m_port;
};


// ------------- Backend interface.

class CONTENT_EXPORT Backend {
public:
    virtual ~Backend() { }

    virtual DispatchResponse ActivateTarget(const String& in_targetId) = 0;
    virtual DispatchResponse AttachToTarget(const String& in_targetId, Maybe<bool> in_flatten, String* out_sessionId) = 0;
    virtual DispatchResponse AttachToBrowserTarget(String* out_sessionId) = 0;
    virtual DispatchResponse CloseTarget(const String& in_targetId, bool* out_success) = 0;
    virtual DispatchResponse ExposeDevToolsProtocol(const String& in_targetId, Maybe<String> in_bindingName) = 0;
    class CONTENT_EXPORT CreateBrowserContextCallback {
    public:
        virtual void sendSuccess(const String& browserContextId) = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~CreateBrowserContextCallback() { }
    };
    virtual void CreateBrowserContext(Maybe<bool> in_disposeOnDetach, Maybe<String> in_proxyServer, Maybe<String> in_proxyBypassList, std::unique_ptr<CreateBrowserContextCallback> callback) = 0;
    virtual DispatchResponse GetBrowserContexts(std::unique_ptr<protocol::Array<String>>* out_browserContextIds) = 0;
    virtual DispatchResponse CreateTarget(const String& in_url, Maybe<int> in_width, Maybe<int> in_height, Maybe<String> in_browserContextId, Maybe<bool> in_enableBeginFrameControl, Maybe<bool> in_newWindow, Maybe<bool> in_background, String* out_targetId) = 0;
    virtual DispatchResponse DetachFromTarget(Maybe<String> in_sessionId, Maybe<String> in_targetId) = 0;
    class CONTENT_EXPORT DisposeBrowserContextCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~DisposeBrowserContextCallback() { }
    };
    virtual void DisposeBrowserContext(const String& in_browserContextId, std::unique_ptr<DisposeBrowserContextCallback> callback) = 0;
    virtual DispatchResponse GetTargetInfo(Maybe<String> in_targetId, std::unique_ptr<protocol::Target::TargetInfo>* out_targetInfo) = 0;
    virtual DispatchResponse GetTargets(std::unique_ptr<protocol::Array<protocol::Target::TargetInfo>>* out_targetInfos) = 0;
    virtual DispatchResponse SendMessageToTarget(const String& in_message, Maybe<String> in_sessionId, Maybe<String> in_targetId) = 0;
    class CONTENT_EXPORT SetAutoAttachCallback {
    public:
        virtual void sendSuccess() = 0;
        virtual void sendFailure(const DispatchResponse&) = 0;
        virtual void fallThrough() = 0;
        virtual ~SetAutoAttachCallback() { }
    };
    virtual void SetAutoAttach(bool in_autoAttach, bool in_waitForDebuggerOnStart, Maybe<bool> in_flatten, std::unique_ptr<SetAutoAttachCallback> callback) = 0;
    virtual DispatchResponse SetDiscoverTargets(bool in_discover) = 0;
    virtual DispatchResponse SetRemoteLocations(std::unique_ptr<protocol::Array<protocol::Target::RemoteLocation>> in_locations) = 0;

    virtual DispatchResponse Disable()
    {
        return DispatchResponse::Success();
    }
};

// ------------- Frontend interface.

class CONTENT_EXPORT Frontend {
public:
  explicit Frontend(FrontendChannel* frontend_channel) : frontend_channel_(frontend_channel) {}
    void AttachedToTarget(const String& sessionId, std::unique_ptr<protocol::Target::TargetInfo> targetInfo, bool waitingForDebugger);
    void DetachedFromTarget(const String& sessionId, Maybe<String> targetId = Maybe<String>());
    void ReceivedMessageFromTarget(const String& sessionId, const String& message, Maybe<String> targetId = Maybe<String>());
    void TargetCreated(std::unique_ptr<protocol::Target::TargetInfo> targetInfo);
    void TargetDestroyed(const String& targetId);
    void TargetCrashed(const String& targetId, const String& status, int errorCode);
    void TargetInfoChanged(std::unique_ptr<protocol::Target::TargetInfo> targetInfo);

  void flush();
  void sendRawNotification(std::unique_ptr<Serializable>);
 private:
  FrontendChannel* frontend_channel_;
};

// ------------- Dispatcher.

class CONTENT_EXPORT Dispatcher {
public:
    static void wire(UberDispatcher*, Backend*);

private:
    Dispatcher() { }
};

// ------------- Metainfo.

class CONTENT_EXPORT Metainfo {
public:
    using BackendClass = Backend;
    using FrontendClass = Frontend;
    using DispatcherClass = Dispatcher;
    static const char domainName[];
    static const char commandPrefix[];
    static const char version[];
};

} // namespace Target
} // namespace content
} // namespace protocol

#endif // !defined(content_protocol_Target_h)
