// This file is generated by TypeBuilder_cpp.template.

// Copyright (c) 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#include "content/browser/devtools/protocol/background_service.h"

#include "content/browser/devtools/protocol/protocol.h"

#include "third_party/inspector_protocol/crdtp/cbor.h"
#include "third_party/inspector_protocol/crdtp/find_by_first.h"
#include "third_party/inspector_protocol/crdtp/span.h"

namespace content {
namespace protocol {
namespace BackgroundService {

using crdtp::DeserializerState;
using crdtp::ProtocolTypeTraits;

// ------------- Enum values from types.

const char Metainfo::domainName[] = "BackgroundService";
const char Metainfo::commandPrefix[] = "BackgroundService.";
const char Metainfo::version[] = "1.3";

namespace ServiceNameEnum {
const char BackgroundFetch[] = "backgroundFetch";
const char BackgroundSync[] = "backgroundSync";
const char PushMessaging[] = "pushMessaging";
const char Notifications[] = "notifications";
const char PaymentHandler[] = "paymentHandler";
const char PeriodicBackgroundSync[] = "periodicBackgroundSync";
} // namespace ServiceNameEnum


CRDTP_BEGIN_DESERIALIZER(EventMetadata)
    CRDTP_DESERIALIZE_FIELD("key", m_key),
    CRDTP_DESERIALIZE_FIELD("value", m_value),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(EventMetadata)
    CRDTP_SERIALIZE_FIELD("key", m_key);
    CRDTP_SERIALIZE_FIELD("value", m_value);
CRDTP_END_SERIALIZER();


CRDTP_BEGIN_DESERIALIZER(BackgroundServiceEvent)
    CRDTP_DESERIALIZE_FIELD("eventMetadata", m_eventMetadata),
    CRDTP_DESERIALIZE_FIELD("eventName", m_eventName),
    CRDTP_DESERIALIZE_FIELD("instanceId", m_instanceId),
    CRDTP_DESERIALIZE_FIELD("origin", m_origin),
    CRDTP_DESERIALIZE_FIELD("service", m_service),
    CRDTP_DESERIALIZE_FIELD("serviceWorkerRegistrationId", m_serviceWorkerRegistrationId),
    CRDTP_DESERIALIZE_FIELD("timestamp", m_timestamp),
CRDTP_END_DESERIALIZER()

CRDTP_BEGIN_SERIALIZER(BackgroundServiceEvent)
    CRDTP_SERIALIZE_FIELD("timestamp", m_timestamp);
    CRDTP_SERIALIZE_FIELD("origin", m_origin);
    CRDTP_SERIALIZE_FIELD("serviceWorkerRegistrationId", m_serviceWorkerRegistrationId);
    CRDTP_SERIALIZE_FIELD("service", m_service);
    CRDTP_SERIALIZE_FIELD("eventName", m_eventName);
    CRDTP_SERIALIZE_FIELD("instanceId", m_instanceId);
    CRDTP_SERIALIZE_FIELD("eventMetadata", m_eventMetadata);
CRDTP_END_SERIALIZER();


// ------------- Enum values from params.


// ------------- Frontend notifications.

void Frontend::RecordingStateChanged(bool isRecording, const String& service)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("isRecording"), isRecording);
    serializer.AddField(crdtp::MakeSpan("service"), service);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("BackgroundService.recordingStateChanged", serializer.Finish()));
}

void Frontend::BackgroundServiceEventReceived(std::unique_ptr<protocol::BackgroundService::BackgroundServiceEvent> backgroundServiceEvent)
{
    if (!frontend_channel_)
        return;
    crdtp::ObjectSerializer serializer;
    serializer.AddField(crdtp::MakeSpan("backgroundServiceEvent"), backgroundServiceEvent);
    frontend_channel_->SendProtocolNotification(crdtp::CreateNotification("BackgroundService.backgroundServiceEventReceived", serializer.Finish()));
}

void Frontend::flush()
{
    frontend_channel_->FlushProtocolNotifications();
}

void Frontend::sendRawNotification(std::unique_ptr<Serializable> notification)
{
    frontend_channel_->SendProtocolNotification(std::move(notification));
}

// --------------------- Dispatcher.

class DomainDispatcherImpl : public protocol::DomainDispatcher {
public:
    DomainDispatcherImpl(FrontendChannel* frontendChannel, Backend* backend)
        : DomainDispatcher(frontendChannel)
        , m_backend(backend) {}
    ~DomainDispatcherImpl() override { }

    using CallHandler = void (DomainDispatcherImpl::*)(const crdtp::Dispatchable& dispatchable);

    std::function<void(const crdtp::Dispatchable&)> Dispatch(crdtp::span<uint8_t> command_name) override;

    void startObserving(const crdtp::Dispatchable& dispatchable);
    void stopObserving(const crdtp::Dispatchable& dispatchable);
    void setRecording(const crdtp::Dispatchable& dispatchable);
    void clearEvents(const crdtp::Dispatchable& dispatchable);
 protected:
    Backend* m_backend;
};

namespace {
// This helper method with a static map of command methods (instance methods
// of DomainDispatcherImpl declared just above) by their name is used immediately below,
// in the DomainDispatcherImpl::Dispatch method.
DomainDispatcherImpl::CallHandler CommandByName(crdtp::span<uint8_t> command_name) {
  static auto* commands = [](){
    auto* commands = new std::vector<std::pair<crdtp::span<uint8_t>,
                              DomainDispatcherImpl::CallHandler>>{
    {
          crdtp::SpanFrom("clearEvents"),
          &DomainDispatcherImpl::clearEvents
    },
    {
          crdtp::SpanFrom("setRecording"),
          &DomainDispatcherImpl::setRecording
    },
    {
          crdtp::SpanFrom("startObserving"),
          &DomainDispatcherImpl::startObserving
    },
    {
          crdtp::SpanFrom("stopObserving"),
          &DomainDispatcherImpl::stopObserving
    },
    };
    return commands;
  }();
  return crdtp::FindByFirst<DomainDispatcherImpl::CallHandler>(*commands, command_name, nullptr);
}
}  // namespace

std::function<void(const crdtp::Dispatchable&)> DomainDispatcherImpl::Dispatch(crdtp::span<uint8_t> command_name) {
  CallHandler handler = CommandByName(command_name);
  if (!handler) return nullptr;

  return [this, handler](const crdtp::Dispatchable& dispatchable) {
    (this->*handler)(dispatchable);
  };
}


class StartObservingCallbackImpl : public Backend::StartObservingCallback, public DomainDispatcher::Callback {
public:
    StartObservingCallbackImpl(std::unique_ptr<DomainDispatcher::WeakPtr> backendImpl, int callId, crdtp::span<uint8_t> message)
        : DomainDispatcher::Callback(std::move(backendImpl), callId,
crdtp::SpanFrom("BackgroundService.startObserving"), message) { }

    void sendSuccess() override
    {
        crdtp::ObjectSerializer serializer;
        sendIfActive(serializer.Finish(), DispatchResponse::Success());
    }

    void fallThrough() override
    {
        fallThroughIfActive();
    }

    void sendFailure(const DispatchResponse& response) override
    {
        DCHECK(response.IsError());
        sendIfActive(nullptr, response);
    }
};

namespace {

struct startObservingParams : public crdtp::DeserializableProtocolObject<startObservingParams> {
    String service;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(startObservingParams)
    CRDTP_DESERIALIZE_FIELD("service", service),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::startObserving(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    startObservingParams params;
    startObservingParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    m_backend->StartObserving(params.service, std::make_unique<StartObservingCallbackImpl>(weakPtr(), dispatchable.CallId(), dispatchable.Serialized()));
}

namespace {

struct stopObservingParams : public crdtp::DeserializableProtocolObject<stopObservingParams> {
    String service;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(stopObservingParams)
    CRDTP_DESERIALIZE_FIELD("service", service),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::stopObserving(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    stopObservingParams params;
    stopObservingParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->StopObserving(params.service);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("BackgroundService.stopObserving"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct setRecordingParams : public crdtp::DeserializableProtocolObject<setRecordingParams> {
    bool shouldRecord;
    String service;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(setRecordingParams)
    CRDTP_DESERIALIZE_FIELD("service", service),
    CRDTP_DESERIALIZE_FIELD("shouldRecord", shouldRecord),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::setRecording(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    setRecordingParams params;
    setRecordingParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->SetRecording(params.shouldRecord, params.service);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("BackgroundService.setRecording"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {

struct clearEventsParams : public crdtp::DeserializableProtocolObject<clearEventsParams> {
    String service;
    DECLARE_DESERIALIZATION_SUPPORT();
};

CRDTP_BEGIN_DESERIALIZER(clearEventsParams)
    CRDTP_DESERIALIZE_FIELD("service", service),
CRDTP_END_DESERIALIZER()

}  // namespace

void DomainDispatcherImpl::clearEvents(const crdtp::Dispatchable& dispatchable)
{
    // Prepare input parameters.
    auto deserializer = crdtp::DeferredMessage::FromSpan(dispatchable.Params())->MakeDeserializer();
    clearEventsParams params;
    clearEventsParams::Deserialize(&deserializer, &params);
    if (MaybeReportInvalidParams(dispatchable, deserializer))
      return;


    std::unique_ptr<DomainDispatcher::WeakPtr> weak = weakPtr();
    DispatchResponse response = m_backend->ClearEvents(params.service);
    if (response.IsFallThrough()) {
        channel()->FallThrough(dispatchable.CallId(), crdtp::SpanFrom("BackgroundService.clearEvents"), dispatchable.Serialized());
        return;
    }
    if (weak->get())
        weak->get()->sendResponse(dispatchable.CallId(), response);
    return;
}

namespace {
// This helper method (with a static map of redirects) is used from Dispatcher::wire
// immediately below.
const std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>& SortedRedirects() {
  static auto* redirects = [](){
    auto* redirects = new std::vector<std::pair<crdtp::span<uint8_t>, crdtp::span<uint8_t>>>{
    };
    return redirects;
  }();
  return *redirects;
}
}  // namespace

// static
void Dispatcher::wire(UberDispatcher* uber, Backend* backend)
{
    auto dispatcher = std::make_unique<DomainDispatcherImpl>(uber->channel(), backend);
    uber->WireBackend(crdtp::SpanFrom("BackgroundService"), SortedRedirects(), std::move(dispatcher));
}

} // BackgroundService
} // namespace content
} // namespace protocol
