// components/services/storage/public/mojom/filesystem/directory.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_H_
#define COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/services/storage/public/mojom/filesystem/directory.mojom-shared.h"
#include "components/services/storage/public/mojom/filesystem/directory.mojom-forward.h"
#include "mojo/public/mojom/base/big_string.mojom.h"
#include "mojo/public/mojom/base/file.mojom.h"
#include "mojo/public/mojom/base/file_error.mojom.h"
#include "mojo/public/mojom/base/file_info.mojom.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"


#include "components/services/storage/public/cpp/filesystem/strict_relative_path_mojom_traits.h"
#include "base/component_export.h"



// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace storage {
namespace mojom {

class FileLockProxy;

template <typename ImplRefTraits>
class FileLockStub;

class FileLockRequestValidator;
class FileLockResponseValidator;


class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) FileLock
    : public FileLockInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = FileLockInterfaceBase;
  using Proxy_ = FileLockProxy;

  template <typename ImplRefTraits>
  using Stub_ = FileLockStub<ImplRefTraits>;

  using RequestValidator_ = FileLockRequestValidator;
  using ResponseValidator_ = FileLockResponseValidator;
  enum MethodMinVersions : uint32_t {
    kReleaseMinVersion = 0,
  };
  virtual ~FileLock() {}

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool Release(::base::File::Error* out_error);

  using ReleaseCallback = base::OnceCallback<void(::base::File::Error)>;
  
  virtual void Release(ReleaseCallback callback) = 0;
};

class DirectoryProxy;

template <typename ImplRefTraits>
class DirectoryStub;

class DirectoryRequestValidator;
class DirectoryResponseValidator;


class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) Directory
    : public DirectoryInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = true;

  using Base_ = DirectoryInterfaceBase;
  using Proxy_ = DirectoryProxy;

  template <typename ImplRefTraits>
  using Stub_ = DirectoryStub<ImplRefTraits>;

  using RequestValidator_ = DirectoryRequestValidator;
  using ResponseValidator_ = DirectoryResponseValidator;
  enum MethodMinVersions : uint32_t {
    kCloneMinVersion = 0,
    kPathExistsMinVersion = 0,
    kGetEntriesMinVersion = 0,
    kOpenFileMinVersion = 0,
    kWriteFileAtomicallyMinVersion = 0,
    kCreateDirectoryMinVersion = 0,
    kDeleteFileMinVersion = 0,
    kDeletePathRecursivelyMinVersion = 0,
    kGetFileInfoMinVersion = 0,
    kGetPathAccessMinVersion = 0,
    kGetMaximumPathComponentLengthMinVersion = 0,
    kRenameFileMinVersion = 0,
    kLockFileMinVersion = 0,
    kSetOpenedFileLengthMinVersion = 0,
  };
  virtual ~Directory() {}

  
  virtual void Clone(::mojo::PendingReceiver<Directory> receiver) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool PathExists(const ::base::FilePath& path, bool* out_exists);

  using PathExistsCallback = base::OnceCallback<void(bool)>;
  
  virtual void PathExists(const ::base::FilePath& path, PathExistsCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetEntries(const ::base::FilePath& path, GetEntriesMode mode, ::base::File::Error* out_error, std::vector<::base::FilePath>* out_entries);

  using GetEntriesCallback = base::OnceCallback<void(::base::File::Error, const std::vector<::base::FilePath>&)>;
  
  virtual void GetEntries(const ::base::FilePath& path, GetEntriesMode mode, GetEntriesCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool OpenFile(const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, ::base::File::Error* out_error, ::base::File* out_file);

  using OpenFileCallback = base::OnceCallback<void(::base::File::Error, ::base::File)>;
  
  virtual void OpenFile(const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, OpenFileCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool WriteFileAtomically(const ::base::FilePath& path, const ::std::string& contents, bool* out_success);

  using WriteFileAtomicallyCallback = base::OnceCallback<void(bool)>;
  
  virtual void WriteFileAtomically(const ::base::FilePath& path, const ::std::string& contents, WriteFileAtomicallyCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool CreateDirectory(const ::base::FilePath& path, ::base::File::Error* out_error);

  using CreateDirectoryCallback = base::OnceCallback<void(::base::File::Error)>;
  
  virtual void CreateDirectory(const ::base::FilePath& path, CreateDirectoryCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DeleteFile(const ::base::FilePath& path, bool* out_success);

  using DeleteFileCallback = base::OnceCallback<void(bool)>;
  
  virtual void DeleteFile(const ::base::FilePath& path, DeleteFileCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool DeletePathRecursively(const ::base::FilePath& path, bool* out_success);

  using DeletePathRecursivelyCallback = base::OnceCallback<void(bool)>;
  
  virtual void DeletePathRecursively(const ::base::FilePath& path, DeletePathRecursivelyCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetFileInfo(const ::base::FilePath& path, base::Optional<::base::File::Info>* out_info);

  using GetFileInfoCallback = base::OnceCallback<void(const base::Optional<::base::File::Info>&)>;
  
  virtual void GetFileInfo(const ::base::FilePath& path, GetFileInfoCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetPathAccess(const ::base::FilePath& path, PathAccessInfoPtr* out_info);

  using GetPathAccessCallback = base::OnceCallback<void(PathAccessInfoPtr)>;
  
  virtual void GetPathAccess(const ::base::FilePath& path, GetPathAccessCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool GetMaximumPathComponentLength(const ::base::FilePath& path, bool* out_success, int32_t* out_length);

  using GetMaximumPathComponentLengthCallback = base::OnceCallback<void(bool, int32_t)>;
  
  virtual void GetMaximumPathComponentLength(const ::base::FilePath& path, GetMaximumPathComponentLengthCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool RenameFile(const ::base::FilePath& old_path, const ::base::FilePath& new_path, ::base::File::Error* out_error);

  using RenameFileCallback = base::OnceCallback<void(::base::File::Error)>;
  
  virtual void RenameFile(const ::base::FilePath& old_path, const ::base::FilePath& new_path, RenameFileCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool LockFile(const ::base::FilePath& path, ::base::File::Error* out_error, ::mojo::PendingRemote<FileLock>* out_lock);

  using LockFileCallback = base::OnceCallback<void(::base::File::Error, ::mojo::PendingRemote<FileLock>)>;
  
  virtual void LockFile(const ::base::FilePath& path, LockFileCallback callback) = 0;

  // Sync method. This signature is used by the client side; the service side
  // should implement the signature with callback below.
  
  virtual bool SetOpenedFileLength(::base::File file, uint64_t size, bool* out_success, ::base::File* out_file);

  using SetOpenedFileLengthCallback = base::OnceCallback<void(bool, ::base::File)>;
  
  virtual void SetOpenedFileLength(::base::File file, uint64_t size, SetOpenedFileLengthCallback callback) = 0;
};



class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) FileLockProxy
    : public FileLock {
 public:
  using InterfaceType = FileLock;

  explicit FileLockProxy(mojo::MessageReceiverWithResponder* receiver);
  
  bool Release(::base::File::Error* out_error) final;
  
  void Release(ReleaseCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};



class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) DirectoryProxy
    : public Directory {
 public:
  using InterfaceType = Directory;

  explicit DirectoryProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void Clone(::mojo::PendingReceiver<Directory> receiver) final;
  
  bool PathExists(const ::base::FilePath& path, bool* out_exists) final;
  
  void PathExists(const ::base::FilePath& path, PathExistsCallback callback) final;
  
  bool GetEntries(const ::base::FilePath& path, GetEntriesMode mode, ::base::File::Error* out_error, std::vector<::base::FilePath>* out_entries) final;
  
  void GetEntries(const ::base::FilePath& path, GetEntriesMode mode, GetEntriesCallback callback) final;
  
  bool OpenFile(const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, ::base::File::Error* out_error, ::base::File* out_file) final;
  
  void OpenFile(const ::base::FilePath& path, FileOpenMode mode, FileReadAccess read_access, FileWriteAccess write_access, OpenFileCallback callback) final;
  
  bool WriteFileAtomically(const ::base::FilePath& path, const ::std::string& contents, bool* out_success) final;
  
  void WriteFileAtomically(const ::base::FilePath& path, const ::std::string& contents, WriteFileAtomicallyCallback callback) final;
  
  bool CreateDirectory(const ::base::FilePath& path, ::base::File::Error* out_error) final;
  
  void CreateDirectory(const ::base::FilePath& path, CreateDirectoryCallback callback) final;
  
  bool DeleteFile(const ::base::FilePath& path, bool* out_success) final;
  
  void DeleteFile(const ::base::FilePath& path, DeleteFileCallback callback) final;
  
  bool DeletePathRecursively(const ::base::FilePath& path, bool* out_success) final;
  
  void DeletePathRecursively(const ::base::FilePath& path, DeletePathRecursivelyCallback callback) final;
  
  bool GetFileInfo(const ::base::FilePath& path, base::Optional<::base::File::Info>* out_info) final;
  
  void GetFileInfo(const ::base::FilePath& path, GetFileInfoCallback callback) final;
  
  bool GetPathAccess(const ::base::FilePath& path, PathAccessInfoPtr* out_info) final;
  
  void GetPathAccess(const ::base::FilePath& path, GetPathAccessCallback callback) final;
  
  bool GetMaximumPathComponentLength(const ::base::FilePath& path, bool* out_success, int32_t* out_length) final;
  
  void GetMaximumPathComponentLength(const ::base::FilePath& path, GetMaximumPathComponentLengthCallback callback) final;
  
  bool RenameFile(const ::base::FilePath& old_path, const ::base::FilePath& new_path, ::base::File::Error* out_error) final;
  
  void RenameFile(const ::base::FilePath& old_path, const ::base::FilePath& new_path, RenameFileCallback callback) final;
  
  bool LockFile(const ::base::FilePath& path, ::base::File::Error* out_error, ::mojo::PendingRemote<FileLock>* out_lock) final;
  
  void LockFile(const ::base::FilePath& path, LockFileCallback callback) final;
  
  bool SetOpenedFileLength(::base::File file, uint64_t size, bool* out_success, ::base::File* out_file) final;
  
  void SetOpenedFileLength(::base::File file, uint64_t size, SetOpenedFileLengthCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) FileLockStubDispatch {
 public:
  static bool Accept(FileLock* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      FileLock* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<FileLock>>
class FileLockStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  FileLockStub() {}
  ~FileLockStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileLockStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return FileLockStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) DirectoryStubDispatch {
 public:
  static bool Accept(Directory* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Directory* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Directory>>
class DirectoryStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  DirectoryStub() {}
  ~DirectoryStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DirectoryStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return DirectoryStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) FileLockRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) DirectoryRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) FileLockResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) DirectoryResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};






class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) PathAccessInfo {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<PathAccessInfo, T>::value>;
  using DataView = PathAccessInfoDataView;
  using Data_ = internal::PathAccessInfo_Data;

  template <typename... Args>
  static PathAccessInfoPtr New(Args&&... args) {
    return PathAccessInfoPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static PathAccessInfoPtr From(const U& u) {
    return mojo::TypeConverter<PathAccessInfoPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, PathAccessInfo>::Convert(*this);
  }


  PathAccessInfo();

  PathAccessInfo(
      bool can_read,
      bool can_write);

  ~PathAccessInfo();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = PathAccessInfoPtr>
  PathAccessInfoPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, PathAccessInfo::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;
  size_t Hash(size_t seed) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        PathAccessInfo::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        PathAccessInfo::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::PathAccessInfo_UnserializedMessageContext<
            UserType, PathAccessInfo::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<PathAccessInfo::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return PathAccessInfo::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::PathAccessInfo_UnserializedMessageContext<
            UserType, PathAccessInfo::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<PathAccessInfo::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  bool can_read;
  
  bool can_write;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, PathAccessInfo::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, PathAccessInfo::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, PathAccessInfo::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, PathAccessInfo::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}







class COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) StrictRelativePath {
 public:
  template <typename T>
  using EnableIfSame = std::enable_if_t<std::is_same<StrictRelativePath, T>::value>;
  using DataView = StrictRelativePathDataView;
  using Data_ = internal::StrictRelativePath_Data;

  template <typename... Args>
  static StrictRelativePathPtr New(Args&&... args) {
    return StrictRelativePathPtr(
        base::in_place, std::forward<Args>(args)...);
  }

  template <typename U>
  static StrictRelativePathPtr From(const U& u) {
    return mojo::TypeConverter<StrictRelativePathPtr, U>::Convert(u);
  }

  template <typename U>
  U To() const {
    return mojo::TypeConverter<U, StrictRelativePath>::Convert(*this);
  }


  StrictRelativePath();

  explicit StrictRelativePath(
      const ::base::FilePath& path);

  ~StrictRelativePath();

  // Clone() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Clone() or copy
  // constructor/assignment are available for members.
  template <typename StructPtrType = StrictRelativePathPtr>
  StrictRelativePathPtr Clone() const;

  // Equals() is a template so it is only instantiated if it is used. Thus, the
  // bindings generator does not need to know whether Equals() or == operator
  // are available for members.
  template <typename T, StrictRelativePath::EnableIfSame<T>* = nullptr>
  bool Equals(const T& other) const;

  template <typename UserType>
  static std::vector<uint8_t> Serialize(UserType* input) {
    return mojo::internal::SerializeImpl<
        StrictRelativePath::DataView, std::vector<uint8_t>>(input);
  }

  template <typename UserType>
  static mojo::Message SerializeAsMessage(UserType* input) {
    return mojo::internal::SerializeAsMessageImpl<
        StrictRelativePath::DataView>(input);
  }

  // The returned Message is serialized only if the message is moved
  // cross-process or cross-language. Otherwise if the message is Deserialized
  // as the same UserType |input| will just be moved to |output| in
  // DeserializeFromMessage.
  template <typename UserType>
  static mojo::Message WrapAsMessage(UserType input) {
    return mojo::Message(std::make_unique<
        internal::StrictRelativePath_UnserializedMessageContext<
            UserType, StrictRelativePath::DataView>>(0, 0, std::move(input)),
        MOJO_CREATE_MESSAGE_FLAG_NONE);
  }

  template <typename UserType>
  static bool Deserialize(const void* data,
                          size_t data_num_bytes,
                          UserType* output) {
    return mojo::internal::DeserializeImpl<StrictRelativePath::DataView>(
        data, data_num_bytes, std::vector<mojo::ScopedHandle>(), output, Validate);
  }

  template <typename UserType>
  static bool Deserialize(const std::vector<uint8_t>& input,
                          UserType* output) {
    return StrictRelativePath::Deserialize(
        input.size() == 0 ? nullptr : &input.front(), input.size(), output);
  }

  template <typename UserType>
  static bool DeserializeFromMessage(mojo::Message input,
                                     UserType* output) {
    auto context = input.TakeUnserializedContext<
        internal::StrictRelativePath_UnserializedMessageContext<
            UserType, StrictRelativePath::DataView>>();
    if (context) {
      *output = std::move(context->TakeData());
      return true;
    }
    input.SerializeIfNecessary();
    return mojo::internal::DeserializeImpl<StrictRelativePath::DataView>(
        input.payload(), input.payload_num_bytes(),
        std::move(*input.mutable_handles()), output, Validate);
  }

  
  ::base::FilePath path;

  // Write this structure into |value|. The members are represented as a
  // dictionary |member name|: |member value|. This method does not deal with
  // the dictionary name. The caller is responsible for not calling
  // |AsValueInto| when |value| expects array items (see Array/Dictionary
  // methods of |base::trace_event::TracedValue|).
  //
  // |value| The TracedValue to be written into.
  //
  // Example uses:
  //
  //   // |my_var1, my_var2| are variables with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   value->BeginDictionary("my_var1");
  //   my_var1.AsValueInto(value.get());
  //   value->EndDictionary();
  //   value->BeginDictionary("my_var2");
  //   my_var2.AsValueInto(value.get());
  //   value->EndDictionary();
  //
  //   // |my_var| is a variable with defined |AsValueInto| method.
  //   auto value = std::make_unique<base::trace_event::TracedValue>();
  //   my_var.AsValueInto(value.get());
  //   TRACE_EVENT1("test", "test", "my_var", std::move(value));
  //
  // Calling |AsValueInto| on two objects without opening and closing a
  // dictionary for each object is theoretically possible, but strongly
  // discouraged due to potential name collisions:
  //
  //   struct A {
  //     int foo;
  //   };
  //   struct B {
  //     int bar;
  //   };
  //   struct C {
  //     int foo;
  //     int bar;
  //   };
  //   auto value1 = std::make_unique<base::trace_event::TracedValue>();
  //   auto value2 = std::make_unique<base::trace_event::TracedValue>();
  //   A a;
  //   B b;
  //   C c;
  //   // value1 and value2 will be filled with the same information:
  //   a.AsValueInto(value1);
  //   b.AsValueInto(value1);
  //   c.AsValueInto(value2);
  void AsValueInto(base::trace_event::TracedValue* value) const;

 private:
  static bool Validate(const void* data,
                       mojo::internal::ValidationContext* validation_context);
};

// The comparison operators are templates, so they are only instantiated if they
// are used. Thus, the bindings generator does not need to know whether
// comparison operators are available for members.
template <typename T, StrictRelativePath::EnableIfSame<T>* = nullptr>
bool operator<(const T& lhs, const T& rhs);

template <typename T, StrictRelativePath::EnableIfSame<T>* = nullptr>
bool operator<=(const T& lhs, const T& rhs) {
  return !(rhs < lhs);
}

template <typename T, StrictRelativePath::EnableIfSame<T>* = nullptr>
bool operator>(const T& lhs, const T& rhs) {
  return rhs < lhs;
}

template <typename T, StrictRelativePath::EnableIfSame<T>* = nullptr>
bool operator>=(const T& lhs, const T& rhs) {
  return !(lhs < rhs);
}


template <typename StructPtrType>
StrictRelativePathPtr StrictRelativePath::Clone() const {
  return New(
      mojo::Clone(path)
  );
}

template <typename T, StrictRelativePath::EnableIfSame<T>*>
bool StrictRelativePath::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->path, other_struct.path))
    return false;
  return true;
}

template <typename T, StrictRelativePath::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.path, rhs.path))
    return true;
  if (std::less<>{}(rhs.path, lhs.path))
    return false;
  return false;
}
template <typename StructPtrType>
PathAccessInfoPtr PathAccessInfo::Clone() const {
  return New(
      mojo::Clone(can_read),
      mojo::Clone(can_write)
  );
}

template <typename T, PathAccessInfo::EnableIfSame<T>*>
bool PathAccessInfo::Equals(const T& other_struct) const {
  if (!mojo::Equals(this->can_read, other_struct.can_read))
    return false;
  if (!mojo::Equals(this->can_write, other_struct.can_write))
    return false;
  return true;
}

template <typename T, PathAccessInfo::EnableIfSame<T>*>
bool operator<(const T& lhs, const T& rhs) {
  if (std::less<>{}(lhs.can_read, rhs.can_read))
    return true;
  if (std::less<>{}(rhs.can_read, lhs.can_read))
    return false;
  if (std::less<>{}(lhs.can_write, rhs.can_write))
    return true;
  if (std::less<>{}(rhs.can_write, lhs.can_write))
    return false;
  return false;
}


}  // namespace mojom
}  // namespace storage

namespace mojo {


template <>
struct COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) StructTraits<::storage::mojom::StrictRelativePath::DataView,
                                         ::storage::mojom::StrictRelativePathPtr> {
  static bool IsNull(const ::storage::mojom::StrictRelativePathPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::StrictRelativePathPtr* output) { output->reset(); }

  static const decltype(::storage::mojom::StrictRelativePath::path)& path(
      const ::storage::mojom::StrictRelativePathPtr& input) {
    return input->path;
  }

  static bool Read(::storage::mojom::StrictRelativePath::DataView input, ::storage::mojom::StrictRelativePathPtr* output);
};


template <>
struct COMPONENT_EXPORT(STORAGE_SERVICE_FILESYSTEM_MOJOM) StructTraits<::storage::mojom::PathAccessInfo::DataView,
                                         ::storage::mojom::PathAccessInfoPtr> {
  static bool IsNull(const ::storage::mojom::PathAccessInfoPtr& input) { return !input; }
  static void SetToNull(::storage::mojom::PathAccessInfoPtr* output) { output->reset(); }

  static decltype(::storage::mojom::PathAccessInfo::can_read) can_read(
      const ::storage::mojom::PathAccessInfoPtr& input) {
    return input->can_read;
  }

  static decltype(::storage::mojom::PathAccessInfo::can_write) can_write(
      const ::storage::mojom::PathAccessInfoPtr& input) {
    return input->can_write;
  }

  static bool Read(::storage::mojom::PathAccessInfo::DataView input, ::storage::mojom::PathAccessInfoPtr* output);
};

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_STORAGE_PUBLIC_MOJOM_FILESYSTEM_DIRECTORY_MOJOM_H_