// components/services/quarantine/public/mojom/quarantine.mojom.h is auto generated by mojom_bindings_generator.py, do not edit

// Copyright 2013 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef COMPONENTS_SERVICES_QUARANTINE_PUBLIC_MOJOM_QUARANTINE_MOJOM_H_
#define COMPONENTS_SERVICES_QUARANTINE_PUBLIC_MOJOM_QUARANTINE_MOJOM_H_

#include <stdint.h>

#include <limits>
#include <type_traits>
#include <utility>

#include "base/callback.h"
#include "base/macros.h"
#include "base/optional.h"

#include "mojo/public/cpp/bindings/mojo_buildflags.h"
#if BUILDFLAG(MOJO_TRACE_ENABLED)
#include "base/trace_event/trace_event.h"
#endif  // BUILDFLAG(MOJO_TRACE_ENABLED)
#include "mojo/public/cpp/bindings/clone_traits.h"
#include "mojo/public/cpp/bindings/equals_traits.h"
#include "mojo/public/cpp/bindings/lib/serialization.h"
#include "mojo/public/cpp/bindings/struct_ptr.h"
#include "mojo/public/cpp/bindings/struct_traits.h"
#include "mojo/public/cpp/bindings/union_traits.h"
#include "components/services/quarantine/public/mojom/quarantine.mojom-shared.h"
#include "components/services/quarantine/public/mojom/quarantine.mojom-forward.h"
#include "mojo/public/mojom/base/file_path.mojom.h"
#include "url/mojom/url.mojom.h"
#include <string>
#include <vector>

#include "mojo/public/cpp/bindings/associated_interface_ptr.h"
#include "mojo/public/cpp/bindings/associated_interface_ptr_info.h"
#include "mojo/public/cpp/bindings/associated_interface_request.h"
#include "mojo/public/cpp/bindings/interface_ptr.h"
#include "mojo/public/cpp/bindings/interface_request.h"
#include "mojo/public/cpp/bindings/lib/control_message_handler.h"
#include "mojo/public/cpp/bindings/raw_ptr_impl_ref_traits.h"
#include "mojo/public/cpp/bindings/thread_safe_interface_ptr.h"





// Forward-declare for |AsValueInto| so that we do not have to import the
// corresponding header.
namespace base {
namespace trace_event {
class TracedValue;
}  // namespace trace_event
}  // namespace base


namespace quarantine {
namespace mojom {

class QuarantineProxy;

template <typename ImplRefTraits>
class QuarantineStub;

class QuarantineRequestValidator;
class QuarantineResponseValidator;


class  Quarantine
    : public QuarantineInterfaceBase {
 public:
  static const char Name_[];
  static constexpr uint32_t Version_ = 0;
  static constexpr bool PassesAssociatedKinds_ = false;
  static constexpr bool HasSyncMethods_ = false;

  using Base_ = QuarantineInterfaceBase;
  using Proxy_ = QuarantineProxy;

  template <typename ImplRefTraits>
  using Stub_ = QuarantineStub<ImplRefTraits>;

  using RequestValidator_ = QuarantineRequestValidator;
  using ResponseValidator_ = QuarantineResponseValidator;
  enum MethodMinVersions : uint32_t {
    kQuarantineFileMinVersion = 0,
  };
  virtual ~Quarantine() {}


  using QuarantineFileCallback = base::OnceCallback<void(QuarantineFileResult)>;
  
  virtual void QuarantineFile(const ::base::FilePath& full_path, const ::GURL& source_url, const ::GURL& referrer_url, const std::string& client_guid, QuarantineFileCallback callback) = 0;
};



class  QuarantineProxy
    : public Quarantine {
 public:
  using InterfaceType = Quarantine;

  explicit QuarantineProxy(mojo::MessageReceiverWithResponder* receiver);
  
  void QuarantineFile(const ::base::FilePath& full_path, const ::GURL& source_url, const ::GURL& referrer_url, const std::string& client_guid, QuarantineFileCallback callback) final;

 private:
  mojo::MessageReceiverWithResponder* receiver_;
};
class  QuarantineStubDispatch {
 public:
  static bool Accept(Quarantine* impl, mojo::Message* message);
  static bool AcceptWithResponder(
      Quarantine* impl,
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder);
};

template <typename ImplRefTraits =
              mojo::RawPtrImplRefTraits<Quarantine>>
class QuarantineStub
    : public mojo::MessageReceiverWithResponderStatus {
 public:
  using ImplPointerType = typename ImplRefTraits::PointerType;

  QuarantineStub() {}
  ~QuarantineStub() override {}

  void set_sink(ImplPointerType sink) { sink_ = std::move(sink); }
  ImplPointerType& sink() { return sink_; }

  bool Accept(mojo::Message* message) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuarantineStubDispatch::Accept(
        ImplRefTraits::GetRawPointer(&sink_), message);
  }

  bool AcceptWithResponder(
      mojo::Message* message,
      std::unique_ptr<mojo::MessageReceiverWithStatus> responder) override {
    if (ImplRefTraits::IsNull(sink_))
      return false;
    return QuarantineStubDispatch::AcceptWithResponder(
        ImplRefTraits::GetRawPointer(&sink_), message, std::move(responder));
  }

 private:
  ImplPointerType sink_;
};
class  QuarantineRequestValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};
class  QuarantineResponseValidator : public mojo::MessageReceiver {
 public:
  bool Accept(mojo::Message* message) override;
};





}  // namespace mojom
}  // namespace quarantine

namespace mojo {

}  // namespace mojo

#endif  // COMPONENTS_SERVICES_QUARANTINE_PUBLIC_MOJOM_QUARANTINE_MOJOM_H_