/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir.ts.an;

import com.googlecode.dex2jar.ir.IrMethod;
import com.googlecode.dex2jar.ir.expr.Local;
import com.googlecode.dex2jar.ir.expr.Value;
import com.googlecode.dex2jar.ir.stmt.Stmt;
import com.googlecode.dex2jar.ir.ts.UniqueQueue;
import com.googlecode.dex2jar.ir.ts.an.BaseAnalyze;
import com.googlecode.dex2jar.ir.ts.an.SimpleLiveValue;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SimpleLiveAnalyze
extends BaseAnalyze<SimpleLiveValue> {
    protected Set<SimpleLiveValue> markUsed() {
        HashSet<SimpleLiveValue> used = new HashSet<SimpleLiveValue>(this.aValues.size() / 2);
        UniqueQueue q = new UniqueQueue();
        for (SimpleLiveValue sv : this.aValues) {
            if (!sv.used) continue;
            q.add(sv);
            while (!q.isEmpty()) {
                SimpleLiveValue v = (SimpleLiveValue)q.poll();
                if (!v.used || used.contains(v)) continue;
                used.add(v);
                SimpleLiveValue p2 = v.parent;
                if (p2 != null && !p2.used) {
                    p2.used = true;
                    q.add(p2);
                }
                if (v.otherParents == null) continue;
                for (SimpleLiveValue p2 : v.otherParents) {
                    if (p2.used) continue;
                    p2.used = true;
                    q.add(p2);
                }
                v.otherParents = null;
            }
        }
        return used;
    }

    @Override
    protected void analyzeValue() {
        this.markUsed();
    }

    public int getLocalSize() {
        return this.localSize;
    }

    public SimpleLiveAnalyze(IrMethod method, boolean reindexLocal) {
        super(method, reindexLocal);
    }

    @Override
    protected SimpleLiveValue onAssignLocal(Local local, Value value) {
        SimpleLiveValue v = (SimpleLiveValue)super.onAssignLocal(local, value);
        v.used = true;
        return v;
    }

    @Override
    protected void onUseLocal(SimpleLiveValue aValue, Local local) {
        aValue.used = true;
        super.onUseLocal(aValue, local);
    }

    @Override
    public SimpleLiveValue[] merge(SimpleLiveValue[] srcFrame, SimpleLiveValue[] distFrame, Stmt src, Stmt dist) {
        if (distFrame == null) {
            distFrame = new SimpleLiveValue[this.localSize];
            int i = 0;
            while (i < srcFrame.length) {
                SimpleLiveValue sV = srcFrame[i];
                if (sV != null) {
                    SimpleLiveValue dV = new SimpleLiveValue();
                    this.aValues.add(dV);
                    dV.parent = sV;
                    distFrame[i] = dV;
                }
                ++i;
            }
        } else {
            int i = 0;
            while (i < srcFrame.length) {
                SimpleLiveValue sV = srcFrame[i];
                SimpleLiveValue dV = distFrame[i];
                if (sV != null && dV != null) {
                    List<SimpleLiveValue> ps = dV.otherParents;
                    if (ps == null) {
                        dV.otherParents = ps = new ArrayList<SimpleLiveValue>(3);
                    }
                    ps.add(sV);
                }
                ++i;
            }
        }
        return distFrame;
    }

    protected SimpleLiveValue[] newFrame(int size) {
        return new SimpleLiveValue[size];
    }

    @Override
    protected SimpleLiveValue newValue() {
        return new SimpleLiveValue();
    }
}

