/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.ir;

public enum TypeClass {
    BOOLEAN("Z", true),
    INT("I", true),
    FLOAT("F", true),
    DOUBLE("D", true),
    LONG("J", true),
    OBJECT("L", true),
    VOID("V", true),
    UNKNOWN("?"),
    ZIL("s"),
    ZIFL("z"),
    ZIF("m"),
    ZI("n"),
    IF("i"),
    JD("w");

    public String name;
    public boolean fixed;

    private TypeClass(String use, boolean fixed) {
        this.name = use;
        this.fixed = fixed;
    }

    private TypeClass(String use) {
        this.name = use;
        this.fixed = false;
    }

    public static TypeClass clzOf(String desc) {
        switch (desc.charAt(0)) {
            case 'Z': {
                return BOOLEAN;
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': {
                return INT;
            }
            case 'F': {
                return FLOAT;
            }
            case 'D': {
                return DOUBLE;
            }
            case 'J': {
                return LONG;
            }
            case 'L': 
            case '[': {
                return OBJECT;
            }
            case 'V': {
                return VOID;
            }
            case 'z': {
                return ZIFL;
            }
            case 's': {
                return ZIL;
            }
            case 'i': {
                return IF;
            }
            case 'm': {
                return ZIF;
            }
            case 'n': {
                return ZI;
            }
            case 'w': {
                return JD;
            }
        }
        return UNKNOWN;
    }

    public static TypeClass merge(TypeClass thizCls, TypeClass clz) {
        if (thizCls == clz) {
            return thizCls;
        }
        if (thizCls == UNKNOWN) {
            return clz;
        }
        if (clz == UNKNOWN) {
            return thizCls;
        }
        if (thizCls.fixed) {
            if (clz.fixed) {
                throw new RuntimeException("can not merge " + (Object)((Object)thizCls) + " and " + (Object)((Object)clz));
            }
            return thizCls;
        }
        if (clz.fixed) {
            return clz;
        }
        switch (thizCls) {
            case ZIL: {
                switch (clz) {
                    case ZIFL: {
                        return thizCls;
                    }
                    case IF: {
                        return INT;
                    }
                    case ZIF: 
                    case ZI: {
                        return ZI;
                    }
                    case JD: {
                        throw new RuntimeException();
                    }
                }
            }
            case ZIFL: {
                switch (clz) {
                    case ZIL: 
                    case ZIF: 
                    case ZI: 
                    case IF: {
                        return clz;
                    }
                    case JD: {
                        throw new RuntimeException();
                    }
                }
            }
            case IF: {
                switch (clz) {
                    case ZIL: 
                    case ZI: {
                        return INT;
                    }
                    case ZIFL: 
                    case ZIF: {
                        return thizCls;
                    }
                    case JD: {
                        throw new RuntimeException();
                    }
                }
            }
            case ZIF: {
                switch (clz) {
                    case IF: {
                        return clz;
                    }
                    case ZIL: 
                    case ZI: {
                        return ZI;
                    }
                    case ZIFL: {
                        return thizCls;
                    }
                    case JD: {
                        throw new RuntimeException();
                    }
                }
            }
            case ZI: {
                switch (clz) {
                    case IF: {
                        return INT;
                    }
                    case ZIL: 
                    case ZIFL: 
                    case ZIF: {
                        return thizCls;
                    }
                    case JD: {
                        throw new RuntimeException();
                    }
                }
            }
            case JD: {
                throw new RuntimeException();
            }
        }
        throw new RuntimeException();
    }

    public String toString() {
        return this.name;
    }
}

