/*
 * Decompiled with CFR 0.152.
 */
package com.strobel.decompiler;

import com.beust.jcommander.JCommander;
import com.strobel.Procyon;
import com.strobel.assembler.InputTypeLoader;
import com.strobel.assembler.metadata.CompositeTypeLoader;
import com.strobel.assembler.metadata.DeobfuscationUtilities;
import com.strobel.assembler.metadata.IMetadataResolver;
import com.strobel.assembler.metadata.ITypeLoader;
import com.strobel.assembler.metadata.JarTypeLoader;
import com.strobel.assembler.metadata.MetadataParser;
import com.strobel.assembler.metadata.MetadataSystem;
import com.strobel.assembler.metadata.TypeDefinition;
import com.strobel.assembler.metadata.TypeReference;
import com.strobel.core.ExceptionUtilities;
import com.strobel.core.StringUtilities;
import com.strobel.decompiler.AnsiTextOutput;
import com.strobel.decompiler.BriefLogFormatter;
import com.strobel.decompiler.CommandLineOptions;
import com.strobel.decompiler.DecompilationOptions;
import com.strobel.decompiler.DecompilerSettings;
import com.strobel.decompiler.FileOutputWriter;
import com.strobel.decompiler.LineNumberFormatter;
import com.strobel.decompiler.NoRetryMetadataSystem;
import com.strobel.decompiler.PlainTextOutput;
import com.strobel.decompiler.languages.BytecodeLanguage;
import com.strobel.decompiler.languages.BytecodeOutputOptions;
import com.strobel.decompiler.languages.Languages;
import com.strobel.decompiler.languages.LineNumberPosition;
import com.strobel.decompiler.languages.TypeDecompilationResults;
import com.strobel.decompiler.languages.java.JavaFormattingOptions;
import com.strobel.io.PathHelper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DecompilerDriver {
    public static void main(String[] args) {
        boolean decompileJar;
        List<String> typeNames;
        JCommander jCommander;
        CommandLineOptions options = new CommandLineOptions();
        try {
            jCommander = new JCommander(options);
            jCommander.setAllowAbbreviatedOptions(false);
            jCommander.parse(args);
            typeNames = options.getInputs();
        }
        catch (Throwable t) {
            System.err.println(ExceptionUtilities.getMessage(t));
            System.exit(-1);
            return;
        }
        DecompilerDriver.configureLogging(options);
        String jarFile = options.getJarFile();
        boolean bl = decompileJar = !StringUtilities.isNullOrWhitespace(jarFile);
        if (options.getPrintVersion()) {
            JCommander.getConsole().println(Procyon.version());
            if (options.getPrintUsage()) {
                jCommander.usage();
            }
            return;
        }
        if (options.getPrintUsage() || typeNames.isEmpty() && !decompileJar) {
            jCommander.usage();
            return;
        }
        DecompilerSettings settings = new DecompilerSettings();
        settings.setFlattenSwitchBlocks(options.getFlattenSwitchBlocks());
        settings.setForceExplicitImports(!options.getCollapseImports());
        settings.setForceExplicitTypeArguments(options.getForceExplicitTypeArguments());
        settings.setRetainRedundantCasts(options.getRetainRedundantCasts());
        settings.setShowSyntheticMembers(options.getShowSyntheticMembers());
        settings.setExcludeNestedTypes(options.getExcludeNestedTypes());
        settings.setOutputDirectory(options.getOutputDirectory());
        settings.setIncludeLineNumbersInBytecode(options.getIncludeLineNumbers());
        settings.setRetainPointlessSwitches(options.getRetainPointlessSwitches());
        settings.setUnicodeOutputEnabled(options.isUnicodeOutputEnabled());
        settings.setMergeVariables(options.getMergeVariables());
        settings.setShowDebugLineNumbers(options.getShowDebugLineNumbers());
        settings.setSimplifyMemberReferences(options.getSimplifyMemberReferences());
        settings.setForceFullyQualifiedReferences(options.getForceFullyQualifiedReferences());
        settings.setDisableForEachTransforms(options.getDisableForEachTransforms());
        settings.setTypeLoader(new InputTypeLoader());
        if (!options.getSuppressBanner()) {
            settings.setOutputFileHeaderText("\nDecompiled by Procyon v" + Procyon.version() + "\n");
        }
        if (options.isRawBytecode()) {
            settings.setLanguage(Languages.bytecode());
            settings.setBytecodeOutputOptions(DecompilerDriver.createBytecodeFormattingOptions(options));
        } else if (options.isBytecodeAst()) {
            settings.setLanguage(options.isUnoptimized() ? Languages.bytecodeAstUnoptimized() : Languages.bytecodeAst());
        }
        DecompilationOptions decompilationOptions = new DecompilationOptions();
        decompilationOptions.setSettings(settings);
        decompilationOptions.setFullDecompilation(true);
        if (settings.getJavaFormattingOptions() == null) {
            settings.setJavaFormattingOptions(JavaFormattingOptions.createDefault());
        }
        if (decompileJar) {
            try {
                DecompilerDriver.decompileJar(jarFile, options, decompilationOptions);
            }
            catch (Throwable t) {
                System.err.println(ExceptionUtilities.getMessage(t));
                System.exit(-1);
            }
        } else {
            NoRetryMetadataSystem metadataSystem = new NoRetryMetadataSystem(settings.getTypeLoader());
            metadataSystem.setEagerMethodLoadingEnabled(options.isEagerMethodLoadingEnabled());
            for (String typeName : typeNames) {
                try {
                    if (typeName.endsWith(".jar")) {
                        DecompilerDriver.decompileJar(typeName, options, decompilationOptions);
                        continue;
                    }
                    DecompilerDriver.decompileType(metadataSystem, typeName, options, decompilationOptions, true);
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
    }

    private static BytecodeOutputOptions createBytecodeFormattingOptions(CommandLineOptions options) {
        if (options.isVerbose()) {
            return BytecodeOutputOptions.createVerbose();
        }
        BytecodeOutputOptions bytecodeOptions = BytecodeOutputOptions.createDefault();
        bytecodeOptions.showTypeAttributes = options.getShowTypeAttributes();
        bytecodeOptions.showConstantPool = options.getShowConstantPool();
        bytecodeOptions.showLineNumbers = options.getIncludeLineNumbers();
        bytecodeOptions.showLocalVariableTables = options.getShowLocalVariableDetails();
        bytecodeOptions.showMethodsStack = options.getShowLocalVariableDetails();
        return bytecodeOptions;
    }

    private static void configureLogging(CommandLineOptions options) {
        Level verboseLevel;
        Logger globalLogger = Logger.getGlobal();
        Logger rootLogger = Logger.getAnonymousLogger().getParent();
        for (Handler handler : globalLogger.getHandlers()) {
            globalLogger.removeHandler(handler);
        }
        for (Handler handler : rootLogger.getHandlers()) {
            rootLogger.removeHandler(handler);
        }
        switch (options.getLogLevel()) {
            case 0: {
                verboseLevel = Level.SEVERE;
                break;
            }
            case 1: {
                verboseLevel = Level.FINE;
                break;
            }
            case 2: {
                verboseLevel = Level.FINER;
                break;
            }
            default: {
                verboseLevel = Level.FINEST;
            }
        }
        globalLogger.setLevel(verboseLevel);
        rootLogger.setLevel(verboseLevel);
        ConsoleHandler handler = new ConsoleHandler();
        handler.setLevel(verboseLevel);
        handler.setFormatter(new BriefLogFormatter());
        globalLogger.addHandler(handler);
        rootLogger.addHandler(handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void decompileJar(String jarFilePath, CommandLineOptions options, DecompilationOptions decompilationOptions) throws IOException {
        File jarFile = new File(jarFilePath);
        if (!jarFile.exists()) {
            throw new FileNotFoundException("File not found: " + jarFilePath);
        }
        DecompilerSettings settings = decompilationOptions.getSettings();
        JarFile jar = new JarFile(jarFile);
        Enumeration<JarEntry> entries = jar.entries();
        boolean oldShowSyntheticMembers = settings.getShowSyntheticMembers();
        ITypeLoader oldTypeLoader = settings.getTypeLoader();
        settings.setShowSyntheticMembers(false);
        settings.setTypeLoader(new CompositeTypeLoader(new JarTypeLoader(jar), oldTypeLoader));
        try {
            NoRetryMetadataSystem metadataSystem = new NoRetryMetadataSystem(settings.getTypeLoader());
            metadataSystem.setEagerMethodLoadingEnabled(options.isEagerMethodLoadingEnabled());
            int classesDecompiled = 0;
            while (entries.hasMoreElements()) {
                JarEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.endsWith(".class")) continue;
                String internalName = StringUtilities.removeRight(name, ".class");
                try {
                    DecompilerDriver.decompileType(metadataSystem, internalName, options, decompilationOptions, false);
                    if (++classesDecompiled % 100 != 0) continue;
                    metadataSystem = new NoRetryMetadataSystem(settings.getTypeLoader());
                }
                catch (Throwable t) {
                    t.printStackTrace();
                }
            }
        }
        finally {
            settings.setShowSyntheticMembers(oldShowSyntheticMembers);
            settings.setTypeLoader(oldTypeLoader);
        }
    }

    private static void decompileType(MetadataSystem metadataSystem, String typeName, CommandLineOptions commandLineOptions, DecompilationOptions options, boolean includeNested) throws IOException {
        TypeDefinition resolvedType;
        TypeReference type;
        DecompilerSettings settings = options.getSettings();
        if (typeName.length() == 1) {
            MetadataParser parser = new MetadataParser(IMetadataResolver.EMPTY);
            TypeReference reference = parser.parseTypeDescriptor(typeName);
            type = metadataSystem.resolve(reference);
        } else {
            type = metadataSystem.lookupType(typeName);
        }
        if (type == null || (resolvedType = type.resolve()) == null) {
            System.err.printf("!!! ERROR: Failed to load class %s.\n", typeName);
            return;
        }
        DeobfuscationUtilities.processType(resolvedType);
        if (!includeNested && (resolvedType.isNested() || resolvedType.isAnonymous() || resolvedType.isSynthetic())) {
            return;
        }
        Writer writer = DecompilerDriver.createWriter(resolvedType, settings);
        boolean writeToFile = writer instanceof FileOutputWriter;
        PlainTextOutput output = writeToFile ? new PlainTextOutput(writer) : new AnsiTextOutput(writer, commandLineOptions.getUseLightColorScheme() ? AnsiTextOutput.ColorScheme.LIGHT : AnsiTextOutput.ColorScheme.DARK);
        output.setUnicodeOutputEnabled(settings.isUnicodeOutputEnabled());
        if (settings.getLanguage() instanceof BytecodeLanguage) {
            output.setIndentToken("  ");
        }
        if (writeToFile) {
            System.out.printf("Decompiling %s...\n", typeName);
        }
        TypeDecompilationResults results = settings.getLanguage().decompileType(resolvedType, output, options);
        writer.flush();
        if (writeToFile) {
            writer.close();
        }
        List<LineNumberPosition> lineNumberPositions = results.getLineNumberPositions();
        if ((commandLineOptions.getIncludeLineNumbers() || commandLineOptions.getStretchLines()) && writer instanceof FileOutputWriter) {
            EnumSet<LineNumberFormatter.LineNumberOption> lineNumberOptions = EnumSet.noneOf(LineNumberFormatter.LineNumberOption.class);
            if (commandLineOptions.getIncludeLineNumbers()) {
                lineNumberOptions.add(LineNumberFormatter.LineNumberOption.LEADING_COMMENTS);
            }
            if (commandLineOptions.getStretchLines()) {
                lineNumberOptions.add(LineNumberFormatter.LineNumberOption.STRETCHED);
            }
            LineNumberFormatter lineFormatter = new LineNumberFormatter(((FileOutputWriter)writer).getFile(), lineNumberPositions, lineNumberOptions);
            lineFormatter.reformatFile();
        }
    }

    private static Writer createWriter(TypeDefinition type, DecompilerSettings settings) throws IOException {
        String outputDirectory = settings.getOutputDirectory();
        if (StringUtilities.isNullOrWhitespace(outputDirectory)) {
            return new OutputStreamWriter((OutputStream)System.out, settings.isUnicodeOutputEnabled() ? Charset.forName("UTF-8") : Charset.defaultCharset());
        }
        String fileName = type.getName() + settings.getLanguage().getFileExtension();
        String packageName = type.getPackageName();
        String outputPath = StringUtilities.isNullOrWhitespace(packageName) ? PathHelper.combine(outputDirectory, fileName) : PathHelper.combine(outputDirectory, packageName.replace('.', PathHelper.DirectorySeparator), fileName);
        File outputFile = new File(outputPath);
        File parentFile = outputFile.getParentFile();
        if (parentFile != null && !parentFile.exists() && !parentFile.mkdirs()) {
            throw new IllegalStateException(String.format("Could not create output directory for file \"%s\".", outputPath));
        }
        if (!outputFile.exists() && !outputFile.createNewFile()) {
            throw new IllegalStateException(String.format("Could not create output file \"%s\".", outputPath));
        }
        return new FileOutputWriter(outputFile, settings);
    }
}

