/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.dex2jar.tools;

import com.googlecode.d2j.util.zip.AutoSTOREDZipOutputStream;
import com.googlecode.d2j.util.zip.ZipEntry;
import com.googlecode.d2j.util.zip.ZipFile;
import com.googlecode.dex2jar.tools.BaseCmd;
import java.io.File;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;

@BaseCmd.Syntax(cmd="d2j-std-zip", syntax="[options] <zip>", desc="clean up apk to standard zip")
public class StdApkCmd
extends BaseCmd {
    @BaseCmd.Opt(opt="o", longOpt="output", description="The output file", argName="out", required=true)
    private Path output;

    public static void main(String ... args) {
        new StdApkCmd().doMain(args);
    }

    protected void doCommandLine() throws Exception {
        if (this.remainingArgs.length < 1) {
            System.err.println("ERROR: no file to process");
            return;
        }
        System.err.printf("fix %s -> %s\n", this.remainingArgs[0], this.output);
        byte[] buffer = new byte[1000];
        Throwable throwable = null;
        Object var3_4 = null;
        try (AutoSTOREDZipOutputStream zos = new AutoSTOREDZipOutputStream(Files.newOutputStream(this.output, new OpenOption[0]));){
            byte[] data = Files.readAllBytes(new File(this.remainingArgs[0]).toPath());
            Throwable throwable2 = null;
            Object var7_10 = null;
            try (ZipFile zipFile = new ZipFile(data);){
                for (ZipEntry e : zipFile.entries()) {
                    java.util.zip.ZipEntry nEntry = new java.util.zip.ZipEntry(e.getName());
                    nEntry.setMethod(e.getMethod() == 0 ? 0 : 8);
                    zos.putNextEntry(nEntry);
                    if (!nEntry.isDirectory()) {
                        Throwable throwable3 = null;
                        Object var13_18 = null;
                        try (InputStream is = zipFile.getInputStream(e);){
                            int c;
                            while ((c = is.read(buffer)) >= 0) {
                                zos.write(buffer, 0, c);
                            }
                        }
                        catch (Throwable throwable4) {
                            if (throwable3 == null) {
                                throwable3 = throwable4;
                            } else if (throwable3 != throwable4) {
                                throwable3.addSuppressed(throwable4);
                            }
                            throw throwable3;
                        }
                    }
                    zos.closeEntry();
                }
            }
            catch (Throwable throwable5) {
                if (throwable2 == null) {
                    throwable2 = throwable5;
                } else if (throwable2 != throwable5) {
                    throwable2.addSuppressed(throwable5);
                }
                throw throwable2;
            }
            zos.finish();
        }
        catch (Throwable throwable6) {
            if (throwable == null) {
                throwable = throwable6;
            } else if (throwable != throwable6) {
                throwable.addSuppressed(throwable6);
            }
            throw throwable;
        }
    }
}

