/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.io;

import com.android.dx.io.DexBuffer;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.zip.Adler32;

public final class DexHasher {
    private static final int CHECKSUM_OFFSET = 8;
    private static final int CHECKSUM_SIZE = 4;
    private static final int SIGNATURE_OFFSET = 12;
    private static final int SIGNATURE_SIZE = 20;

    public byte[] computeSignature(DexBuffer dex) throws IOException {
        MessageDigest digest;
        try {
            digest = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            throw new AssertionError();
        }
        int offset = 32;
        byte[] bytes = dex.getBytes();
        digest.update(bytes, offset, bytes.length - offset);
        return digest.digest();
    }

    public int computeChecksum(DexBuffer dex) throws IOException {
        Adler32 adler32 = new Adler32();
        int offset = 12;
        byte[] bytes = dex.getBytes();
        adler32.update(bytes, offset, bytes.length - offset);
        return (int)adler32.getValue();
    }

    public void writeHashes(DexBuffer dex) throws IOException {
        byte[] signature = this.computeSignature(dex);
        dex.open(12).write(signature);
        int checksum = this.computeChecksum(dex);
        dex.open(8).writeInt(checksum);
    }
}

