/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.java.decompiler.struct.gen;

import java.util.ArrayList;
import java.util.Arrays;
import org.jetbrains.java.decompiler.struct.gen.NewClassNameBuilder;
import org.jetbrains.java.decompiler.struct.gen.VarType;

public class MethodDescriptor {
    public final VarType[] params;
    public final VarType ret;

    private MethodDescriptor(VarType[] params, VarType ret) {
        this.params = params;
        this.ret = ret;
    }

    public static MethodDescriptor parseDescriptor(String descriptor) {
        VarType[] params;
        int parenth = descriptor.lastIndexOf(41);
        if (descriptor.length() < 2 || parenth < 0 || descriptor.charAt(0) != '(') {
            throw new IllegalArgumentException("Invalid descriptor: " + descriptor);
        }
        if (parenth > 1) {
            String parameters = descriptor.substring(1, parenth);
            ArrayList<String> lst = new ArrayList<String>();
            int indexFrom = -1;
            int len = parameters.length();
            block4: for (int index = 0; index < len; ++index) {
                switch (parameters.charAt(index)) {
                    case '[': {
                        if (indexFrom >= 0) continue block4;
                        indexFrom = index;
                        continue block4;
                    }
                    case 'L': {
                        int ind = parameters.indexOf(";", index);
                        lst.add(parameters.substring(indexFrom < 0 ? index : indexFrom, ind + 1));
                        index = ind;
                        indexFrom = -1;
                        continue block4;
                    }
                    default: {
                        lst.add(parameters.substring(indexFrom < 0 ? index : indexFrom, index + 1));
                        indexFrom = -1;
                    }
                }
            }
            params = new VarType[lst.size()];
            for (int i = 0; i < lst.size(); ++i) {
                params[i] = new VarType((String)lst.get(i));
            }
        } else {
            params = VarType.EMPTY_ARRAY;
        }
        VarType ret = new VarType(descriptor.substring(parenth + 1));
        return new MethodDescriptor(params, ret);
    }

    public String buildNewDescriptor(NewClassNameBuilder builder) {
        VarType substitute;
        VarType[] newParams;
        boolean updated = false;
        if (this.params.length > 0) {
            newParams = new VarType[this.params.length];
            System.arraycopy(this.params, 0, newParams, 0, this.params.length);
            for (int i = 0; i < this.params.length; ++i) {
                substitute = MethodDescriptor.buildNewType(this.params[i], builder);
                if (substitute == null) continue;
                newParams[i] = substitute;
                updated = true;
            }
        } else {
            newParams = VarType.EMPTY_ARRAY;
        }
        VarType newRet = this.ret;
        substitute = MethodDescriptor.buildNewType(this.ret, builder);
        if (substitute != null) {
            newRet = substitute;
            updated = true;
        }
        if (updated) {
            StringBuilder res = new StringBuilder("(");
            for (VarType param : newParams) {
                res.append(param);
            }
            res.append(")").append(newRet.toString());
            return res.toString();
        }
        return null;
    }

    private static VarType buildNewType(VarType type, NewClassNameBuilder builder) {
        String newClassName;
        if (type.type == 8 && (newClassName = builder.buildNewClassname(type.value)) != null) {
            return new VarType(type.type, type.arrayDim, newClassName);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MethodDescriptor)) {
            return false;
        }
        MethodDescriptor md = (MethodDescriptor)o;
        return this.ret.equals(md.ret) && Arrays.equals(this.params, md.params);
    }

    public int hashCode() {
        int result = this.ret.hashCode();
        result = 31 * result + this.params.length;
        return result;
    }
}

