# encoding: utf-8

"""
Exceptions used with python-docx.

The base exception class is PythonDocxError.
"""


class PythonDocxError(Exception):
    """
    Generic error class.
    """


class InvalidSpanError(PythonDocxError):
    """
    Raised when an invalid merge region is specified in a request to merge
    table cells.
    """


class InvalidXmlError(PythonDocxError):
    """
    Raised when invalid XML is encountered, such as on attempt to access a
    missing required child element
    """
