from typing import Any, ClassVar, Iterable, Iterator, Optional, Union

from typing import overload
import io
import lief # type: ignore
import lief.ELF # type: ignore
import lief.ELF.AArch64Feature # type: ignore
import lief.ELF.Binary # type: ignore
import lief.ELF.Builder # type: ignore
import lief.ELF.CoreAuxv # type: ignore
import lief.ELF.CoreFile # type: ignore
import lief.ELF.CorePrPsInfo # type: ignore
import lief.ELF.CorePrStatus # type: ignore
import lief.ELF.CorePrStatus.Registers # type: ignore
import lief.ELF.DynamicEntry # type: ignore
import lief.ELF.DynamicEntryFlags # type: ignore
import lief.ELF.Header # type: ignore
import lief.ELF.Note # type: ignore
import lief.ELF.NoteAbi # type: ignore
import lief.ELF.NoteGnuProperty # type: ignore
import lief.ELF.NoteGnuProperty.Property # type: ignore
import lief.ELF.ParserConfig # type: ignore
import lief.ELF.Relocation # type: ignore
import lief.ELF.Section # type: ignore
import lief.ELF.Segment # type: ignore
import lief.ELF.Symbol # type: ignore
import lief.ELF.SymbolVersionDefinition # type: ignore
import lief.ELF.SymbolVersionRequirement # type: ignore
import lief.ELF.X86Features # type: ignore
import lief.ELF.X86ISA # type: ignore
import os

class AArch64Feature(NoteGnuProperty.Property):
    class FEATURE:
        BTI: ClassVar[AArch64Feature.FEATURE] = ...
        PAC: ClassVar[AArch64Feature.FEATURE] = ...
        UNKNOWN: ClassVar[AArch64Feature.FEATURE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.AArch64Feature.FEATURE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def features(self) -> list[lief.ELF.AArch64Feature.FEATURE]: ...

class ARCH:
    AARCH64: ClassVar[ARCH] = ...
    ALPHA: ClassVar[ARCH] = ...
    ALTERA_NIOS2: ClassVar[ARCH] = ...
    AMDGPU: ClassVar[ARCH] = ...
    ARC: ClassVar[ARCH] = ...
    ARCA: ClassVar[ARCH] = ...
    ARC_COMPACT: ClassVar[ARCH] = ...
    ARC_COMPACT2: ClassVar[ARCH] = ...
    ARM: ClassVar[ARCH] = ...
    AVR: ClassVar[ARCH] = ...
    AVR32: ClassVar[ARCH] = ...
    BA1: ClassVar[ARCH] = ...
    BA2: ClassVar[ARCH] = ...
    BLACKFIN: ClassVar[ARCH] = ...
    BPF: ClassVar[ARCH] = ...
    C166: ClassVar[ARCH] = ...
    CDP: ClassVar[ARCH] = ...
    CE: ClassVar[ARCH] = ...
    CLOUDSHIELD: ClassVar[ARCH] = ...
    COGE: ClassVar[ARCH] = ...
    COLDFIRE: ClassVar[ARCH] = ...
    COOL: ClassVar[ARCH] = ...
    COREA_1ST: ClassVar[ARCH] = ...
    COREA_2ND: ClassVar[ARCH] = ...
    CR: ClassVar[ARCH] = ...
    CR16: ClassVar[ARCH] = ...
    CRAYNV2: ClassVar[ARCH] = ...
    CRIS: ClassVar[ARCH] = ...
    CRX: ClassVar[ARCH] = ...
    CSR_KALIMBA: ClassVar[ARCH] = ...
    CUDA: ClassVar[ARCH] = ...
    CYPRESS_M8C: ClassVar[ARCH] = ...
    D10V: ClassVar[ARCH] = ...
    D30V: ClassVar[ARCH] = ...
    DSP24: ClassVar[ARCH] = ...
    DSPIC30F: ClassVar[ARCH] = ...
    DXP: ClassVar[ARCH] = ...
    ECOG16: ClassVar[ARCH] = ...
    ECOG1X: ClassVar[ARCH] = ...
    ECOG2: ClassVar[ARCH] = ...
    ETPU: ClassVar[ARCH] = ...
    EXCESS: ClassVar[ARCH] = ...
    F2MC16: ClassVar[ARCH] = ...
    FIREPATH: ClassVar[ARCH] = ...
    FR20: ClassVar[ARCH] = ...
    FR30: ClassVar[ARCH] = ...
    FX66: ClassVar[ARCH] = ...
    H8S: ClassVar[ARCH] = ...
    H8_300: ClassVar[ARCH] = ...
    H8_300H: ClassVar[ARCH] = ...
    H8_500: ClassVar[ARCH] = ...
    HEXAGON: ClassVar[ARCH] = ...
    HUANY: ClassVar[ARCH] = ...
    I386: ClassVar[ARCH] = ...
    I60: ClassVar[ARCH] = ...
    I860: ClassVar[ARCH] = ...
    IAMCU: ClassVar[ARCH] = ...
    IA_64: ClassVar[ARCH] = ...
    INTEL205: ClassVar[ARCH] = ...
    INTEL206: ClassVar[ARCH] = ...
    INTEL207: ClassVar[ARCH] = ...
    INTEL208: ClassVar[ARCH] = ...
    INTEL209: ClassVar[ARCH] = ...
    IP2K: ClassVar[ARCH] = ...
    JAVELIN: ClassVar[ARCH] = ...
    K10M: ClassVar[ARCH] = ...
    KM32: ClassVar[ARCH] = ...
    KMX16: ClassVar[ARCH] = ...
    KMX32: ClassVar[ARCH] = ...
    KMX8: ClassVar[ARCH] = ...
    KVARC: ClassVar[ARCH] = ...
    L10M: ClassVar[ARCH] = ...
    LATTICEMICO32: ClassVar[ARCH] = ...
    LOONGARCH: ClassVar[ARCH] = ...
    M16C: ClassVar[ARCH] = ...
    M32: ClassVar[ARCH] = ...
    M32C: ClassVar[ARCH] = ...
    M32R: ClassVar[ARCH] = ...
    M56800EX: ClassVar[ARCH] = ...
    M68HC05: ClassVar[ARCH] = ...
    M68HC08: ClassVar[ARCH] = ...
    M68HC11: ClassVar[ARCH] = ...
    M68HC12: ClassVar[ARCH] = ...
    M68HC16: ClassVar[ARCH] = ...
    M68K: ClassVar[ARCH] = ...
    M78KOR: ClassVar[ARCH] = ...
    M8051: ClassVar[ARCH] = ...
    M88K: ClassVar[ARCH] = ...
    MANIK: ClassVar[ARCH] = ...
    MAX: ClassVar[ARCH] = ...
    MAXQ30: ClassVar[ARCH] = ...
    MCHP_PIC: ClassVar[ARCH] = ...
    MCST_ELBRUS: ClassVar[ARCH] = ...
    ME16: ClassVar[ARCH] = ...
    METAG: ClassVar[ARCH] = ...
    MIPS: ClassVar[ARCH] = ...
    MIPS_RS3_LE: ClassVar[ARCH] = ...
    MIPS_X: ClassVar[ARCH] = ...
    MMA: ClassVar[ARCH] = ...
    MMDSP_PLUS: ClassVar[ARCH] = ...
    MMIX: ClassVar[ARCH] = ...
    MN10200: ClassVar[ARCH] = ...
    MN10300: ClassVar[ARCH] = ...
    MSP430: ClassVar[ARCH] = ...
    NCPU: ClassVar[ARCH] = ...
    NDR1: ClassVar[ARCH] = ...
    NDS32: ClassVar[ARCH] = ...
    NONE: ClassVar[ARCH] = ...
    NORC: ClassVar[ARCH] = ...
    NS32K: ClassVar[ARCH] = ...
    OPEN8: ClassVar[ARCH] = ...
    OPENRISC: ClassVar[ARCH] = ...
    PARISC: ClassVar[ARCH] = ...
    PCP: ClassVar[ARCH] = ...
    PDP10: ClassVar[ARCH] = ...
    PDP11: ClassVar[ARCH] = ...
    PDSP: ClassVar[ARCH] = ...
    PJ: ClassVar[ARCH] = ...
    PPC: ClassVar[ARCH] = ...
    PPC64: ClassVar[ARCH] = ...
    PRISM: ClassVar[ARCH] = ...
    R32C: ClassVar[ARCH] = ...
    RCE: ClassVar[ARCH] = ...
    RH32: ClassVar[ARCH] = ...
    RISCV: ClassVar[ARCH] = ...
    RL78: ClassVar[ARCH] = ...
    RS08: ClassVar[ARCH] = ...
    RX: ClassVar[ARCH] = ...
    S370: ClassVar[ARCH] = ...
    S390: ClassVar[ARCH] = ...
    SCORE7: ClassVar[ARCH] = ...
    SEP: ClassVar[ARCH] = ...
    SE_C17: ClassVar[ARCH] = ...
    SE_C33: ClassVar[ARCH] = ...
    SH: ClassVar[ARCH] = ...
    SHARC: ClassVar[ARCH] = ...
    SLE9X: ClassVar[ARCH] = ...
    SNP1K: ClassVar[ARCH] = ...
    SPARC: ClassVar[ARCH] = ...
    SPARC32PLUS: ClassVar[ARCH] = ...
    SPARCV9: ClassVar[ARCH] = ...
    SPU: ClassVar[ARCH] = ...
    ST100: ClassVar[ARCH] = ...
    ST19: ClassVar[ARCH] = ...
    ST200: ClassVar[ARCH] = ...
    ST7: ClassVar[ARCH] = ...
    ST9PLUS: ClassVar[ARCH] = ...
    STARCORE: ClassVar[ARCH] = ...
    STM8: ClassVar[ARCH] = ...
    STXP7X: ClassVar[ARCH] = ...
    SVX: ClassVar[ARCH] = ...
    TILE64: ClassVar[ARCH] = ...
    TILEGX: ClassVar[ARCH] = ...
    TILEPRO: ClassVar[ARCH] = ...
    TINYJ: ClassVar[ARCH] = ...
    TI_C2000: ClassVar[ARCH] = ...
    TI_C5500: ClassVar[ARCH] = ...
    TI_C6000: ClassVar[ARCH] = ...
    TMM_GPP: ClassVar[ARCH] = ...
    TPC: ClassVar[ARCH] = ...
    TRICORE: ClassVar[ARCH] = ...
    TRIMEDIA: ClassVar[ARCH] = ...
    TSK3000: ClassVar[ARCH] = ...
    UNICORE: ClassVar[ARCH] = ...
    V800: ClassVar[ARCH] = ...
    V850: ClassVar[ARCH] = ...
    VAX: ClassVar[ARCH] = ...
    VIDEOCORE: ClassVar[ARCH] = ...
    VIDEOCORE3: ClassVar[ARCH] = ...
    VIDEOCORE5: ClassVar[ARCH] = ...
    VPP500: ClassVar[ARCH] = ...
    X86_64: ClassVar[ARCH] = ...
    XCORE: ClassVar[ARCH] = ...
    XGATE: ClassVar[ARCH] = ...
    XIMO16: ClassVar[ARCH] = ...
    XTENSA: ClassVar[ARCH] = ...
    ZSP: ClassVar[ARCH] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.ELF.ARCH: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class AndroidIdent(Note):
    ndk_build_number: str
    ndk_version: str
    sdk_version: int
    def __init__(self, *args, **kwargs) -> None: ...

class Binary(lief.Binary):
    class PHDR_RELOC:
        AUTO: ClassVar[Binary.PHDR_RELOC] = ...
        BSS_END: ClassVar[Binary.PHDR_RELOC] = ...
        FILE_END: ClassVar[Binary.PHDR_RELOC] = ...
        PIE_SHIFT: ClassVar[Binary.PHDR_RELOC] = ...
        SEGMENT_GAP: ClassVar[Binary.PHDR_RELOC] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...

    class it_dyn_symtab_symbols:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.Symbol: ...
        def __iter__(self) -> lief.ELF.Binary.it_dyn_symtab_symbols: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Symbol: ...

    class it_dynamic_entries:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.DynamicEntry: ...
        def __iter__(self) -> lief.ELF.Binary.it_dynamic_entries: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.DynamicEntry: ...

    class it_filter_relocation:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.Relocation: ...
        def __iter__(self) -> lief.ELF.Binary.it_filter_relocation: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Relocation: ...

    class it_filter_symbols:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.Symbol: ...
        def __iter__(self) -> lief.ELF.Binary.it_filter_symbols: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Symbol: ...

    class it_notes:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.Note: ...
        def __iter__(self) -> lief.ELF.Binary.it_notes: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Note: ...

    class it_relocations:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.Relocation: ...
        def __iter__(self) -> lief.ELF.Binary.it_relocations: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Relocation: ...

    class it_sections:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.Section: ...
        def __iter__(self) -> lief.ELF.Binary.it_sections: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Section: ...

    class it_segments:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.Segment: ...
        def __iter__(self) -> lief.ELF.Binary.it_segments: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Segment: ...

    class it_symbols:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.Symbol: ...
        def __iter__(self) -> lief.ELF.Binary.it_symbols: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Symbol: ...

    class it_symbols_version:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.SymbolVersion: ...
        def __iter__(self) -> lief.ELF.Binary.it_symbols_version: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.SymbolVersion: ...

    class it_symbols_version_definition:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.SymbolVersionDefinition: ...
        def __iter__(self) -> lief.ELF.Binary.it_symbols_version_definition: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.SymbolVersionDefinition: ...

    class it_symbols_version_requirement:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.SymbolVersionRequirement: ...
        def __iter__(self) -> lief.ELF.Binary.it_symbols_version_requirement: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.SymbolVersionRequirement: ...
    interpreter: str
    overlay: memoryview
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def add(self, arg: lief.ELF.DynamicEntry, /) -> lief.ELF.DynamicEntry: ...
    @overload
    def add(self, section: lief.ELF.Section, loaded: bool = ...) -> lief.ELF.Section: ...
    @overload
    def add(self, segment: lief.ELF.Segment, base: int = ...) -> lief.ELF.Segment: ...
    @overload
    def add(self, note: lief.ELF.Note) -> lief.ELF.Note: ...
    def add_dynamic_relocation(self, relocation: lief.ELF.Relocation) -> lief.ELF.Relocation: ...
    def add_dynamic_symbol(self, symbol: lief.ELF.Symbol, symbol_version: Optional[lief.ELF.SymbolVersion] = ...) -> lief.ELF.Symbol: ...
    def add_exported_function(self, address: int, name: str = ...) -> lief.ELF.Symbol: ...
    def add_library(self, library_name: str) -> lief.ELF.DynamicEntryLibrary: ...
    def add_object_relocation(self, relocation: lief.ELF.Relocation, section: lief.ELF.Section) -> lief.ELF.Relocation: ...
    def add_pltgot_relocation(self, relocation: lief.ELF.Relocation) -> lief.ELF.Relocation: ...
    def add_symtab_symbol(self, symbol: lief.ELF.Symbol) -> lief.ELF.Symbol: ...
    @overload
    def dynsym_idx(self, name: str) -> int: ...
    @overload
    def dynsym_idx(self, symbol: lief.ELF.Symbol) -> int: ...
    @overload
    def export_symbol(self, symbol: lief.ELF.Symbol) -> lief.ELF.Symbol: ...
    @overload
    def export_symbol(self, symbol_name: str, value: int = ...) -> lief.ELF.Symbol: ...
    @overload
    def extend(self, segment: lief.ELF.Segment, size: int) -> lief.ELF.Segment: ...
    @overload
    def extend(self, segment: lief.ELF.Section, size: int) -> lief.ELF.Section: ...
    @overload
    def get(self, tag: lief.ELF.DynamicEntry.TAG) -> lief.ELF.DynamicEntry: ...
    @overload
    def get(self, type: lief.ELF.Segment.TYPE) -> lief.ELF.Segment: ...
    @overload
    def get(self, type: lief.ELF.Note.TYPE) -> lief.ELF.Note: ...
    @overload
    def get(self, type: lief.ELF.Section.TYPE) -> lief.ELF.Section: ...
    def get_dynamic_symbol(self, symbol_name: str) -> lief.ELF.Symbol: ...
    def get_library(self, library_name: str) -> lief.ELF.DynamicEntryLibrary: ...
    def get_relocated_dynamic_array(self, array_tag: lief.ELF.DynamicEntry.TAG) -> list[int]: ...
    @overload
    def get_relocation(self, symbol_name: str) -> lief.ELF.Relocation: ...
    @overload
    def get_relocation(self, symbol: lief.ELF.Symbol) -> lief.ELF.Relocation: ...
    @overload
    def get_relocation(self, address: int) -> lief.ELF.Relocation: ...
    def get_section(self, section_name: str) -> lief.ELF.Section: ...
    def get_strings(self, min_size: int = ...) -> list[str]: ...
    def get_symtab_symbol(self, symbol_name: str) -> lief.ELF.Symbol: ...
    @overload
    def has(self, tag: lief.ELF.DynamicEntry.TAG) -> bool: ...
    @overload
    def has(self, type: lief.ELF.Segment.TYPE) -> bool: ...
    @overload
    def has(self, type: lief.ELF.Note.TYPE) -> bool: ...
    @overload
    def has(self, type: lief.ELF.Section.TYPE) -> bool: ...
    def has_dynamic_symbol(self, symbol_name: str) -> bool: ...
    def has_library(self, library_name: str) -> bool: ...
    def has_section(self, section_name: str) -> bool: ...
    def has_section_with_offset(self, offset: int) -> bool: ...
    def has_section_with_va(self, virtual_address: int) -> bool: ...
    def has_symtab_symbol(self, symbol_name: str) -> bool: ...
    @overload
    def patch_pltgot(self, symbol_name: str, address: int) -> None: ...
    @overload
    def patch_pltgot(self, symbol: lief.ELF.Symbol, address: int) -> None: ...
    def permute_dynamic_symbols(self, permutation: list[int]) -> None: ...
    def relocate_phdr_table(self, type: lief.ELF.Binary.PHDR_RELOC = ...) -> int: ...
    @overload
    def remove(self, dynamic_entry: lief.ELF.DynamicEntry) -> None: ...
    @overload
    def remove(self, tag: lief.ELF.DynamicEntry.TAG) -> None: ...
    @overload
    def remove(self, section: lief.ELF.Section, clear: bool = ...) -> None: ...
    @overload
    def remove(self, note: lief.ELF.Note) -> None: ...
    @overload
    def remove(self, type: lief.ELF.Note.TYPE) -> None: ...
    @overload
    def remove_dynamic_symbol(self, arg: lief.ELF.Symbol, /) -> None: ...
    @overload
    def remove_dynamic_symbol(self, arg: str, /) -> None: ...
    def remove_library(self, library_name: str) -> None: ...
    def remove_symtab_symbol(self, arg: lief.ELF.Symbol, /) -> None: ...
    def replace(self, new_segment: lief.ELF.Segment, original_segment: lief.ELF.Segment, base: int = ...) -> lief.ELF.Segment: ...
    def section_from_offset(self, offset: int, skip_nobits: bool = ...) -> lief.ELF.Section: ...
    def section_from_virtual_address(self, address: int, skip_nobits: bool = ...) -> lief.ELF.Section: ...
    def segment_from_offset(self, offset: int) -> lief.ELF.Segment: ...
    def segment_from_virtual_address(self, address: int) -> lief.ELF.Segment: ...
    def strip(self) -> None: ...
    @overload
    def symtab_idx(self, name: str) -> int: ...
    @overload
    def symtab_idx(self, symbol: lief.ELF.Symbol) -> int: ...
    def virtual_address_to_offset(self, virtual_address: int) -> Union[int,lief.lief_errors]: ...
    @overload
    def write(self, output: str) -> None: ...
    @overload
    def write(self, output: str, config: lief.ELF.Builder.config_t) -> None: ...
    @overload
    def __contains__(self, arg: lief.ELF.Segment.TYPE, /) -> bool: ...
    @overload
    def __contains__(self, arg: lief.ELF.DynamicEntry.TAG, /) -> bool: ...
    @overload
    def __contains__(self, arg: lief.ELF.Note.TYPE, /) -> bool: ...
    @overload
    def __contains__(self, arg: lief.ELF.Section.TYPE, /) -> bool: ...
    @overload
    def __getitem__(self, arg: lief.ELF.Segment.TYPE, /) -> lief.ELF.Segment: ...
    @overload
    def __getitem__(self, arg: lief.ELF.Note.TYPE, /) -> lief.ELF.Note: ...
    @overload
    def __getitem__(self, arg: lief.ELF.DynamicEntry.TAG, /) -> lief.ELF.DynamicEntry: ...
    @overload
    def __getitem__(self, arg: lief.ELF.Section.TYPE, /) -> lief.ELF.Section: ...
    @overload
    def __iadd__(self, arg: lief.ELF.Segment, /) -> lief.ELF.Binary: ...
    @overload
    def __iadd__(self, arg: lief.ELF.Section, /) -> lief.ELF.Binary: ...
    @overload
    def __iadd__(self, arg: lief.ELF.DynamicEntry, /) -> lief.ELF.Binary: ...
    @overload
    def __iadd__(self, arg: lief.ELF.Note, /) -> lief.ELF.Binary: ...
    @overload
    def __isub__(self, arg: lief.ELF.DynamicEntry, /) -> lief.ELF.Binary: ...
    @overload
    def __isub__(self, arg: lief.ELF.DynamicEntry.TAG, /) -> lief.ELF.Binary: ...
    @overload
    def __isub__(self, arg: lief.ELF.Note, /) -> lief.ELF.Binary: ...
    @overload
    def __isub__(self, arg: lief.ELF.Note.TYPE, /) -> lief.ELF.Binary: ...
    @property
    def dtor_functions(self) -> list[lief.Function]: ...
    @property
    def dynamic_entries(self) -> lief.ELF.Binary.it_dynamic_entries: ...
    @property
    def dynamic_relocations(self) -> lief.ELF.Binary.it_filter_relocation: ...
    @property
    def dynamic_symbols(self) -> lief.ELF.Binary.it_symbols: ...
    @property
    def eof_offset(self) -> int: ...
    @property
    def exported_symbols(self) -> lief.ELF.Binary.it_filter_symbols: ...
    @property
    def functions(self) -> list[lief.Function]: ...
    @property
    def gnu_hash(self) -> lief.ELF.GnuHash: ...
    @property
    def has_interpreter(self) -> bool: ...
    @property
    def has_notes(self) -> bool: ...
    @property
    def has_overlay(self) -> bool: ...
    @property
    def header(self) -> lief.ELF.Header: ...  # type: ignore
    @property
    def imagebase(self) -> int: ...
    @property
    def imported_symbols(self) -> lief.ELF.Binary.it_filter_symbols: ...
    @property
    def is_pie(self) -> bool: ...
    @property
    def last_offset_section(self) -> int: ...
    @property
    def last_offset_segment(self) -> int: ...
    @property
    def next_virtual_address(self) -> int: ...
    @property
    def notes(self) -> lief.ELF.Binary.it_notes: ...
    @property
    def object_relocations(self) -> lief.ELF.Binary.it_filter_relocation: ...
    @property
    def pltgot_relocations(self) -> lief.ELF.Binary.it_filter_relocation: ...
    @property
    def relocations(self) -> lief.ELF.Binary.it_relocations: ...  # type: ignore
    @property
    def sections(self) -> lief.ELF.Binary.it_sections: ...  # type: ignore
    @property
    def segments(self) -> lief.ELF.Binary.it_segments: ...
    @property
    def strings(self) -> list[Union[str,bytes]]: ...
    @property
    def symbols(self) -> lief.ELF.Binary.it_dyn_symtab_symbols: ...  # type: ignore
    @property
    def symbols_version(self) -> lief.ELF.Binary.it_symbols_version: ...
    @property
    def symbols_version_definition(self) -> lief.ELF.Binary.it_symbols_version_definition: ...
    @property
    def symbols_version_requirement(self) -> lief.ELF.Binary.it_symbols_version_requirement: ...
    @property
    def symtab_symbols(self) -> lief.ELF.Binary.it_symbols: ...
    @property
    def sysv_hash(self) -> lief.ELF.SysvHash: ...
    @property
    def type(self) -> lief.ELF.Header.CLASS: ...
    @property
    def use_gnu_hash(self) -> bool: ...
    @property
    def use_sysv_hash(self) -> bool: ...
    @property
    def virtual_size(self) -> int: ...

class Builder:
    class config_t:
        android_rela: bool
        coredump_notes: bool
        dt_hash: bool
        dyn_str: bool
        dynamic_section: bool
        fini_array: bool
        force_relocate: bool
        init_array: bool
        interpreter: bool
        jmprel: bool
        notes: bool
        preinit_array: bool
        rela: bool
        relr: bool
        static_symtab: bool
        sym_verdef: bool
        sym_verneed: bool
        sym_versym: bool
        symtab: bool
        def __init__(self) -> None: ...
    config: lief.ELF.Builder.config_t
    def __init__(self, elf_binary: lief.ELF.Binary) -> None: ...
    def build(self) -> None: ...
    def get_build(self) -> list[int]: ...
    def write(self, output: str) -> None: ...

class CoreAuxv(Note):
    class TYPE:
        BASE: ClassVar[CoreAuxv.TYPE] = ...
        BASE_PLATFORM: ClassVar[CoreAuxv.TYPE] = ...
        CLKTCK: ClassVar[CoreAuxv.TYPE] = ...
        DCACHEBSIZE: ClassVar[CoreAuxv.TYPE] = ...
        EGID: ClassVar[CoreAuxv.TYPE] = ...
        END: ClassVar[CoreAuxv.TYPE] = ...
        ENTRY: ClassVar[CoreAuxv.TYPE] = ...
        EUID: ClassVar[CoreAuxv.TYPE] = ...
        EXECFD: ClassVar[CoreAuxv.TYPE] = ...
        EXECFN: ClassVar[CoreAuxv.TYPE] = ...
        FLAGS: ClassVar[CoreAuxv.TYPE] = ...
        FPUCW: ClassVar[CoreAuxv.TYPE] = ...
        GID: ClassVar[CoreAuxv.TYPE] = ...
        HWCAP: ClassVar[CoreAuxv.TYPE] = ...
        HWCAP2: ClassVar[CoreAuxv.TYPE] = ...
        ICACHEBSIZE: ClassVar[CoreAuxv.TYPE] = ...
        IGNORE: ClassVar[CoreAuxv.TYPE] = ...
        IGNOREPPC: ClassVar[CoreAuxv.TYPE] = ...
        NOTELF: ClassVar[CoreAuxv.TYPE] = ...
        PAGESZ: ClassVar[CoreAuxv.TYPE] = ...
        PHDR: ClassVar[CoreAuxv.TYPE] = ...
        PHENT: ClassVar[CoreAuxv.TYPE] = ...
        PHNUM: ClassVar[CoreAuxv.TYPE] = ...
        RANDOM: ClassVar[CoreAuxv.TYPE] = ...
        SECURE: ClassVar[CoreAuxv.TYPE] = ...
        SYSINFO: ClassVar[CoreAuxv.TYPE] = ...
        SYSINFO_EHDR: ClassVar[CoreAuxv.TYPE] = ...
        TGT_PLATFORM: ClassVar[CoreAuxv.TYPE] = ...
        UCACHEBSIZE: ClassVar[CoreAuxv.TYPE] = ...
        UID: ClassVar[CoreAuxv.TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.CoreAuxv.TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def get(self, type: lief.ELF.CoreAuxv.TYPE) -> Optional[int]: ...
    @overload
    def set(self, type: lief.ELF.CoreAuxv.TYPE, value: int) -> bool: ...
    @overload
    def set(self, arg: dict[lief.ELF.CoreAuxv.TYPE,int], /) -> bool: ...
    def __getitem__(self, arg: lief.ELF.CoreAuxv.TYPE, /) -> Optional[int]: ...
    @overload
    def __setitem__(self, arg0: lief.ELF.CoreAuxv.TYPE, arg1: int, /) -> bool: ...
    @overload
    def __setitem__(self, arg: dict[lief.ELF.CoreAuxv.TYPE,int], /) -> bool: ...
    @property
    def values(self) -> dict[lief.ELF.CoreAuxv.TYPE,int]: ...

class CoreFile(Note):
    class entry_t:
        end: int
        file_ofs: int
        path: str
        start: int
        def __init__(self, *args, **kwargs) -> None: ...

    class files_t:
        @overload
        def __init__(self) -> None: ...
        @overload
        def __init__(self, arg: lief.ELF.CoreFile.files_t) -> None: ...
        @overload
        def __init__(self, arg: Iterable[lief.ELF.CoreFile.entry_t], /) -> None: ...
        def append(self, arg: lief.ELF.CoreFile.entry_t, /) -> None: ...
        def clear(self) -> None: ...
        def extend(self, arg: lief.ELF.CoreFile.files_t, /) -> None: ...
        def insert(self, arg0: int, arg1: lief.ELF.CoreFile.entry_t, /) -> None: ...
        def pop(self, index: int = ...) -> lief.ELF.CoreFile.entry_t: ...
        def __bool__(self) -> bool: ...
        @overload
        def __delitem__(self, arg: int, /) -> None: ...
        @overload
        def __delitem__(self, arg: slice, /) -> None: ...
        @overload
        def __getitem__(self, arg: int, /) -> lief.ELF.CoreFile.entry_t: ...
        @overload
        def __getitem__(self, arg: slice, /) -> lief.ELF.CoreFile.files_t: ...
        def __iter__(self) -> Iterator[lief.ELF.CoreFile.entry_t]: ...
        def __len__(self) -> int: ...
        @overload
        def __setitem__(self, arg0: int, arg1: lief.ELF.CoreFile.entry_t, /) -> None: ...
        @overload
        def __setitem__(self, arg0: slice, arg1: lief.ELF.CoreFile.files_t, /) -> None: ...
    files: lief.ELF.CoreFile.files_t
    def __init__(self, *args, **kwargs) -> None: ...
    def __iter__(self) -> Iterator[lief.ELF.CoreFile.entry_t]: ...
    def __len__(self) -> int: ...

class CorePrPsInfo(Note):
    class info_t:
        args: str
        filename: str
        flag: int
        gid: int
        nice: int
        pgrp: int
        pid: int
        ppid: int
        sid: int
        sname: str
        state: int
        uid: int
        zombie: bool
        def __init__(self, *args, **kwargs) -> None: ...
        @property
        def args_stripped(self) -> str: ...
        @property
        def filename_stripped(self) -> str: ...
    info: Optional[lief.ELF.CorePrPsInfo.info_t]
    def __init__(self, *args, **kwargs) -> None: ...

class CorePrStatus(Note):
    class Registers:
        class AARCH64:
            PC: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            PSTATE: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X0: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X1: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X10: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X11: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X12: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X13: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X14: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X15: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X16: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X17: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X18: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X19: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X2: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X20: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X21: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X22: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X23: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X24: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X25: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X26: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X27: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X28: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X29: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X3: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X30: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X31: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X4: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X5: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X6: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X7: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X8: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            X9: ClassVar[CorePrStatus.Registers.AARCH64] = ...
            __name__: str
            def __init__(self, *args, **kwargs) -> None: ...
            @staticmethod
            def from_value(arg: int, /) -> lief.ELF.CorePrStatus.Registers.AARCH64: ...
            def __ge__(self, other) -> bool: ...
            def __gt__(self, other) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other) -> bool: ...
            def __lt__(self, other) -> bool: ...
            @property
            def value(self) -> int: ...
    
        class ARM:
            CPSR: ClassVar[CorePrStatus.Registers.ARM] = ...
            R0: ClassVar[CorePrStatus.Registers.ARM] = ...
            R1: ClassVar[CorePrStatus.Registers.ARM] = ...
            R10: ClassVar[CorePrStatus.Registers.ARM] = ...
            R11: ClassVar[CorePrStatus.Registers.ARM] = ...
            R12: ClassVar[CorePrStatus.Registers.ARM] = ...
            R13: ClassVar[CorePrStatus.Registers.ARM] = ...
            R14: ClassVar[CorePrStatus.Registers.ARM] = ...
            R15: ClassVar[CorePrStatus.Registers.ARM] = ...
            R2: ClassVar[CorePrStatus.Registers.ARM] = ...
            R3: ClassVar[CorePrStatus.Registers.ARM] = ...
            R4: ClassVar[CorePrStatus.Registers.ARM] = ...
            R5: ClassVar[CorePrStatus.Registers.ARM] = ...
            R6: ClassVar[CorePrStatus.Registers.ARM] = ...
            R7: ClassVar[CorePrStatus.Registers.ARM] = ...
            R8: ClassVar[CorePrStatus.Registers.ARM] = ...
            R9: ClassVar[CorePrStatus.Registers.ARM] = ...
            __name__: str
            def __init__(self, *args, **kwargs) -> None: ...
            @staticmethod
            def from_value(arg: int, /) -> lief.ELF.CorePrStatus.Registers.ARM: ...
            def __ge__(self, other) -> bool: ...
            def __gt__(self, other) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other) -> bool: ...
            def __lt__(self, other) -> bool: ...
            @property
            def value(self) -> int: ...
    
        class X86:
            CS: ClassVar[CorePrStatus.Registers.X86] = ...
            DS: ClassVar[CorePrStatus.Registers.X86] = ...
            EAX: ClassVar[CorePrStatus.Registers.X86] = ...
            EBP: ClassVar[CorePrStatus.Registers.X86] = ...
            EBX: ClassVar[CorePrStatus.Registers.X86] = ...
            ECX: ClassVar[CorePrStatus.Registers.X86] = ...
            EDI: ClassVar[CorePrStatus.Registers.X86] = ...
            EDX: ClassVar[CorePrStatus.Registers.X86] = ...
            EFLAGS: ClassVar[CorePrStatus.Registers.X86] = ...
            EIP: ClassVar[CorePrStatus.Registers.X86] = ...
            ES: ClassVar[CorePrStatus.Registers.X86] = ...
            ESI: ClassVar[CorePrStatus.Registers.X86] = ...
            ESP: ClassVar[CorePrStatus.Registers.X86] = ...
            FS: ClassVar[CorePrStatus.Registers.X86] = ...
            GS: ClassVar[CorePrStatus.Registers.X86] = ...
            ORIG_EAX: ClassVar[CorePrStatus.Registers.X86] = ...
            SS: ClassVar[CorePrStatus.Registers.X86] = ...
            __name__: str
            def __init__(self, *args, **kwargs) -> None: ...
            @staticmethod
            def from_value(arg: int, /) -> lief.ELF.CorePrStatus.Registers.X86: ...
            def __ge__(self, other) -> bool: ...
            def __gt__(self, other) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other) -> bool: ...
            def __lt__(self, other) -> bool: ...
            @property
            def value(self) -> int: ...
    
        class X86_64:
            CS: ClassVar[CorePrStatus.Registers.X86_64] = ...
            EFLAGS: ClassVar[CorePrStatus.Registers.X86_64] = ...
            ORIG_RAX: ClassVar[CorePrStatus.Registers.X86_64] = ...
            R10: ClassVar[CorePrStatus.Registers.X86_64] = ...
            R11: ClassVar[CorePrStatus.Registers.X86_64] = ...
            R12: ClassVar[CorePrStatus.Registers.X86_64] = ...
            R13: ClassVar[CorePrStatus.Registers.X86_64] = ...
            R14: ClassVar[CorePrStatus.Registers.X86_64] = ...
            R15: ClassVar[CorePrStatus.Registers.X86_64] = ...
            R8: ClassVar[CorePrStatus.Registers.X86_64] = ...
            R9: ClassVar[CorePrStatus.Registers.X86_64] = ...
            RAX: ClassVar[CorePrStatus.Registers.X86_64] = ...
            RBP: ClassVar[CorePrStatus.Registers.X86_64] = ...
            RBX: ClassVar[CorePrStatus.Registers.X86_64] = ...
            RCX: ClassVar[CorePrStatus.Registers.X86_64] = ...
            RDI: ClassVar[CorePrStatus.Registers.X86_64] = ...
            RDX: ClassVar[CorePrStatus.Registers.X86_64] = ...
            RIP: ClassVar[CorePrStatus.Registers.X86_64] = ...
            RSI: ClassVar[CorePrStatus.Registers.X86_64] = ...
            RSP: ClassVar[CorePrStatus.Registers.X86_64] = ...
            SS: ClassVar[CorePrStatus.Registers.X86_64] = ...
            __name__: str
            def __init__(self, *args, **kwargs) -> None: ...
            @staticmethod
            def from_value(arg: int, /) -> lief.ELF.CorePrStatus.Registers.X86_64: ...
            def __ge__(self, other) -> bool: ...
            def __gt__(self, other) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other) -> bool: ...
            def __lt__(self, other) -> bool: ...
            @property
            def value(self) -> int: ...
        def __init__(self, *args, **kwargs) -> None: ...

    class pr_status_t:
        cstime: lief.ELF.CorePrStatus.timeval_t  # type: ignore
        cursig: int
        cutime: lief.ELF.CorePrStatus.timeval_t  # type: ignore
        info: lief.ELF.CorePrStatus.siginfo_t  # type: ignore
        pgrp: int
        pid: int
        ppid: int
        reserved: int
        sid: int
        sighold: int
        sigpend: int
        stime: lief.ELF.CorePrStatus.timeval_t  # type: ignore
        utime: lief.ELF.CorePrStatus.timeval_t  # type: ignore
        def __init__(self, *args, **kwargs) -> None: ...

    class siginfo_t:
        errno: int
        sicode: int
        signo: int
        def __init__(self, *args, **kwargs) -> None: ...

    class timeval_t:
        sec: int
        usec: int
        def __init__(self, *args, **kwargs) -> None: ...
    status: lief.ELF.CorePrStatus.pr_status_t
    def __init__(self, *args, **kwargs) -> None: ...
    @overload
    def get(self, reg: lief.ELF.CorePrStatus.Registers.X86) -> Optional[int]: ...
    @overload
    def get(self, reg: lief.ELF.CorePrStatus.Registers.X86_64) -> Optional[int]: ...
    @overload
    def get(self, reg: lief.ELF.CorePrStatus.Registers.ARM) -> Optional[int]: ...
    @overload
    def get(self, reg: lief.ELF.CorePrStatus.Registers.AARCH64) -> Optional[int]: ...
    @overload
    def set(self, reg: lief.ELF.CorePrStatus.Registers.X86, value: int) -> lief.ok_error_t: ...
    @overload
    def set(self, reg: lief.ELF.CorePrStatus.Registers.X86_64, value: int) -> lief.ok_error_t: ...
    @overload
    def set(self, reg: lief.ELF.CorePrStatus.Registers.ARM, value: int) -> lief.ok_error_t: ...
    @overload
    def set(self, reg: lief.ELF.CorePrStatus.Registers.AARCH64, value: int) -> lief.ok_error_t: ...
    @overload
    def __getitem__(self, arg: lief.ELF.CorePrStatus.Registers.X86, /) -> Optional[int]: ...
    @overload
    def __getitem__(self, arg: lief.ELF.CorePrStatus.Registers.X86_64, /) -> Optional[int]: ...
    @overload
    def __getitem__(self, arg: lief.ELF.CorePrStatus.Registers.ARM, /) -> Optional[int]: ...
    @overload
    def __getitem__(self, arg: lief.ELF.CorePrStatus.Registers.AARCH64, /) -> Optional[int]: ...
    @overload
    def __setitem__(self, arg0: lief.ELF.CorePrStatus.Registers.X86, arg1: int, /) -> lief.ok_error_t: ...
    @overload
    def __setitem__(self, arg0: lief.ELF.CorePrStatus.Registers.X86_64, arg1: int, /) -> lief.ok_error_t: ...
    @overload
    def __setitem__(self, arg0: lief.ELF.CorePrStatus.Registers.ARM, arg1: int, /) -> lief.ok_error_t: ...
    @overload
    def __setitem__(self, arg0: lief.ELF.CorePrStatus.Registers.AARCH64, arg1: int, /) -> lief.ok_error_t: ...
    @property
    def architecture(self) -> lief.ELF.ARCH: ...
    @property
    def pc(self) -> Optional[int]: ...
    @property
    def register_values(self) -> list[int]: ...
    @property
    def return_value(self) -> Optional[int]: ...
    @property
    def sp(self) -> Optional[int]: ...

class CoreSigInfo(Note):
    sigcode: Optional[int]
    sigerrno: Optional[int]
    signo: Optional[int]
    def __init__(self, *args, **kwargs) -> None: ...

class DynamicEntry(lief.Object):
    class TAG:
        AARCH64_BTI_PLT: ClassVar[DynamicEntry.TAG] = ...
        AARCH64_MEMTAG_GLOBALS: ClassVar[DynamicEntry.TAG] = ...
        AARCH64_MEMTAG_GLOBALSSZ: ClassVar[DynamicEntry.TAG] = ...
        AARCH64_MEMTAG_HEAP: ClassVar[DynamicEntry.TAG] = ...
        AARCH64_MEMTAG_MODE: ClassVar[DynamicEntry.TAG] = ...
        AARCH64_MEMTAG_STACK: ClassVar[DynamicEntry.TAG] = ...
        AARCH64_PAC_PLT: ClassVar[DynamicEntry.TAG] = ...
        AARCH64_VARIANT_PCS: ClassVar[DynamicEntry.TAG] = ...
        ANDROID_REL: ClassVar[DynamicEntry.TAG] = ...
        ANDROID_RELA: ClassVar[DynamicEntry.TAG] = ...
        ANDROID_RELASZ: ClassVar[DynamicEntry.TAG] = ...
        ANDROID_RELR: ClassVar[DynamicEntry.TAG] = ...
        ANDROID_RELRCOUNT: ClassVar[DynamicEntry.TAG] = ...
        ANDROID_RELRENT: ClassVar[DynamicEntry.TAG] = ...
        ANDROID_RELRSZ: ClassVar[DynamicEntry.TAG] = ...
        ANDROID_RELSZ: ClassVar[DynamicEntry.TAG] = ...
        ANDROID_REL_OFFSET: ClassVar[DynamicEntry.TAG] = ...
        ANDROID_REL_SIZE: ClassVar[DynamicEntry.TAG] = ...
        BIND_NOW: ClassVar[DynamicEntry.TAG] = ...
        DEBUG_TAG: ClassVar[DynamicEntry.TAG] = ...
        FINI: ClassVar[DynamicEntry.TAG] = ...
        FINI_ARRAY: ClassVar[DynamicEntry.TAG] = ...
        FINI_ARRAYSZ: ClassVar[DynamicEntry.TAG] = ...
        FLAGS: ClassVar[DynamicEntry.TAG] = ...
        FLAGS_1: ClassVar[DynamicEntry.TAG] = ...
        GNU_HASH: ClassVar[DynamicEntry.TAG] = ...
        HASH: ClassVar[DynamicEntry.TAG] = ...
        HEXAGON_PLT: ClassVar[DynamicEntry.TAG] = ...
        HEXAGON_SYMSZ: ClassVar[DynamicEntry.TAG] = ...
        HEXAGON_VER: ClassVar[DynamicEntry.TAG] = ...
        INIT: ClassVar[DynamicEntry.TAG] = ...
        INIT_ARRAY: ClassVar[DynamicEntry.TAG] = ...
        INIT_ARRAYSZ: ClassVar[DynamicEntry.TAG] = ...
        JMPREL: ClassVar[DynamicEntry.TAG] = ...
        MIPS_AUX_DYNAMIC: ClassVar[DynamicEntry.TAG] = ...
        MIPS_BASE_ADDRESS: ClassVar[DynamicEntry.TAG] = ...
        MIPS_COMPACT_SIZE: ClassVar[DynamicEntry.TAG] = ...
        MIPS_CONFLICT: ClassVar[DynamicEntry.TAG] = ...
        MIPS_CONFLICTNO: ClassVar[DynamicEntry.TAG] = ...
        MIPS_CXX_FLAGS: ClassVar[DynamicEntry.TAG] = ...
        MIPS_DELTA_CLASS: ClassVar[DynamicEntry.TAG] = ...
        MIPS_DELTA_CLASSSYM: ClassVar[DynamicEntry.TAG] = ...
        MIPS_DELTA_CLASSSYM_NO: ClassVar[DynamicEntry.TAG] = ...
        MIPS_DELTA_CLASS_NO: ClassVar[DynamicEntry.TAG] = ...
        MIPS_DELTA_INSTANCE: ClassVar[DynamicEntry.TAG] = ...
        MIPS_DELTA_INSTANCE_NO: ClassVar[DynamicEntry.TAG] = ...
        MIPS_DELTA_RELOC: ClassVar[DynamicEntry.TAG] = ...
        MIPS_DELTA_RELOC_NO: ClassVar[DynamicEntry.TAG] = ...
        MIPS_DELTA_SYM: ClassVar[DynamicEntry.TAG] = ...
        MIPS_DELTA_SYM_NO: ClassVar[DynamicEntry.TAG] = ...
        MIPS_DYNSTR_ALIGN: ClassVar[DynamicEntry.TAG] = ...
        MIPS_FLAGS: ClassVar[DynamicEntry.TAG] = ...
        MIPS_GOTSYM: ClassVar[DynamicEntry.TAG] = ...
        MIPS_GP_VALUE: ClassVar[DynamicEntry.TAG] = ...
        MIPS_HIDDEN_GOTIDX: ClassVar[DynamicEntry.TAG] = ...
        MIPS_HIPAGENO: ClassVar[DynamicEntry.TAG] = ...
        MIPS_ICHECKSUM: ClassVar[DynamicEntry.TAG] = ...
        MIPS_INTERFACE: ClassVar[DynamicEntry.TAG] = ...
        MIPS_INTERFACE_SIZE: ClassVar[DynamicEntry.TAG] = ...
        MIPS_IVERSION: ClassVar[DynamicEntry.TAG] = ...
        MIPS_LIBLIST: ClassVar[DynamicEntry.TAG] = ...
        MIPS_LIBLISTNO: ClassVar[DynamicEntry.TAG] = ...
        MIPS_LOCALPAGE_GOTIDX: ClassVar[DynamicEntry.TAG] = ...
        MIPS_LOCAL_GOTIDX: ClassVar[DynamicEntry.TAG] = ...
        MIPS_LOCAL_GOTNO: ClassVar[DynamicEntry.TAG] = ...
        MIPS_MSYM: ClassVar[DynamicEntry.TAG] = ...
        MIPS_OPTIONS: ClassVar[DynamicEntry.TAG] = ...
        MIPS_PERF_SUFFIX: ClassVar[DynamicEntry.TAG] = ...
        MIPS_PIXIE_INIT: ClassVar[DynamicEntry.TAG] = ...
        MIPS_PLTGOT: ClassVar[DynamicEntry.TAG] = ...
        MIPS_PROTECTED_GOTIDX: ClassVar[DynamicEntry.TAG] = ...
        MIPS_RLD_MAP: ClassVar[DynamicEntry.TAG] = ...
        MIPS_RLD_MAP_REL: ClassVar[DynamicEntry.TAG] = ...
        MIPS_RLD_TEXT_RESOLVE_ADDR: ClassVar[DynamicEntry.TAG] = ...
        MIPS_RLD_VERSION: ClassVar[DynamicEntry.TAG] = ...
        MIPS_RWPLT: ClassVar[DynamicEntry.TAG] = ...
        MIPS_SYMBOL_LIB: ClassVar[DynamicEntry.TAG] = ...
        MIPS_SYMTABNO: ClassVar[DynamicEntry.TAG] = ...
        MIPS_TIME_STAMP: ClassVar[DynamicEntry.TAG] = ...
        MIPS_UNREFEXTNO: ClassVar[DynamicEntry.TAG] = ...
        MIPS_XHASH: ClassVar[DynamicEntry.TAG] = ...
        NEEDED: ClassVar[DynamicEntry.TAG] = ...
        NULL: ClassVar[DynamicEntry.TAG] = ...
        PLTGOT: ClassVar[DynamicEntry.TAG] = ...
        PLTREL: ClassVar[DynamicEntry.TAG] = ...
        PLTRELSZ: ClassVar[DynamicEntry.TAG] = ...
        PPC64_GLINK: ClassVar[DynamicEntry.TAG] = ...
        PPC64_OPT: ClassVar[DynamicEntry.TAG] = ...
        PPC_GOT: ClassVar[DynamicEntry.TAG] = ...
        PPC_OPT: ClassVar[DynamicEntry.TAG] = ...
        PREINIT_ARRAY: ClassVar[DynamicEntry.TAG] = ...
        PREINIT_ARRAYSZ: ClassVar[DynamicEntry.TAG] = ...
        REL: ClassVar[DynamicEntry.TAG] = ...
        RELA: ClassVar[DynamicEntry.TAG] = ...
        RELACOUNT: ClassVar[DynamicEntry.TAG] = ...
        RELAENT: ClassVar[DynamicEntry.TAG] = ...
        RELASZ: ClassVar[DynamicEntry.TAG] = ...
        RELCOUNT: ClassVar[DynamicEntry.TAG] = ...
        RELENT: ClassVar[DynamicEntry.TAG] = ...
        RELR: ClassVar[DynamicEntry.TAG] = ...
        RELRENT: ClassVar[DynamicEntry.TAG] = ...
        RELRSZ: ClassVar[DynamicEntry.TAG] = ...
        RELSZ: ClassVar[DynamicEntry.TAG] = ...
        RISCV_VARIANT_CC: ClassVar[DynamicEntry.TAG] = ...
        RPATH: ClassVar[DynamicEntry.TAG] = ...
        RUNPATH: ClassVar[DynamicEntry.TAG] = ...
        SONAME: ClassVar[DynamicEntry.TAG] = ...
        STRSZ: ClassVar[DynamicEntry.TAG] = ...
        STRTAB: ClassVar[DynamicEntry.TAG] = ...
        SYMBOLIC: ClassVar[DynamicEntry.TAG] = ...
        SYMENT: ClassVar[DynamicEntry.TAG] = ...
        SYMTAB: ClassVar[DynamicEntry.TAG] = ...
        SYMTAB_SHNDX: ClassVar[DynamicEntry.TAG] = ...
        TEXTREL: ClassVar[DynamicEntry.TAG] = ...
        UNKNOWN: ClassVar[DynamicEntry.TAG] = ...
        VERDEF: ClassVar[DynamicEntry.TAG] = ...
        VERDEFNUM: ClassVar[DynamicEntry.TAG] = ...
        VERNEED: ClassVar[DynamicEntry.TAG] = ...
        VERNEEDNUM: ClassVar[DynamicEntry.TAG] = ...
        VERSYM: ClassVar[DynamicEntry.TAG] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.DynamicEntry.TAG: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    tag: lief.ELF.DynamicEntry.TAG
    value: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, tag: lief.ELF.DynamicEntry.TAG, value: int) -> None: ...

class DynamicEntryArray(DynamicEntry):
    array: list[int]
    def __init__(self, tag: lief.ELF.DynamicEntry.TAG, array: list[int]) -> None: ...
    def append(self, function: int) -> lief.ELF.DynamicEntryArray: ...
    def insert(self, pos: int, function: int) -> lief.ELF.DynamicEntryArray: ...
    def remove(self, function: int) -> lief.ELF.DynamicEntryArray: ...
    def __getitem__(self, arg: int, /) -> int: ...
    def __iadd__(self, arg: int, /) -> lief.ELF.DynamicEntryArray: ...
    def __isub__(self, arg: int, /) -> lief.ELF.DynamicEntryArray: ...
    def __len__(self) -> int: ...

class DynamicEntryFlags(DynamicEntry):
    class FLAG:
        BIND_NOW: ClassVar[DynamicEntryFlags.FLAG] = ...
        CONFALT: ClassVar[DynamicEntryFlags.FLAG] = ...
        DIRECT: ClassVar[DynamicEntryFlags.FLAG] = ...
        DISPRELDNE: ClassVar[DynamicEntryFlags.FLAG] = ...
        DISPRELPND: ClassVar[DynamicEntryFlags.FLAG] = ...
        EDITED: ClassVar[DynamicEntryFlags.FLAG] = ...
        ENDFILTEE: ClassVar[DynamicEntryFlags.FLAG] = ...
        GLOBAL: ClassVar[DynamicEntryFlags.FLAG] = ...
        GLOBAUDIT: ClassVar[DynamicEntryFlags.FLAG] = ...
        GROUP: ClassVar[DynamicEntryFlags.FLAG] = ...
        HANDLE_ORIGIN: ClassVar[DynamicEntryFlags.FLAG] = ...
        IGNMULDEF: ClassVar[DynamicEntryFlags.FLAG] = ...
        INITFIRST: ClassVar[DynamicEntryFlags.FLAG] = ...
        INTERPOSE: ClassVar[DynamicEntryFlags.FLAG] = ...
        KMOD: ClassVar[DynamicEntryFlags.FLAG] = ...
        LOADFLTR: ClassVar[DynamicEntryFlags.FLAG] = ...
        NOCOMMON: ClassVar[DynamicEntryFlags.FLAG] = ...
        NODEFLIB: ClassVar[DynamicEntryFlags.FLAG] = ...
        NODELETE: ClassVar[DynamicEntryFlags.FLAG] = ...
        NODIRECT: ClassVar[DynamicEntryFlags.FLAG] = ...
        NODUMP: ClassVar[DynamicEntryFlags.FLAG] = ...
        NOHDR: ClassVar[DynamicEntryFlags.FLAG] = ...
        NOKSYMS: ClassVar[DynamicEntryFlags.FLAG] = ...
        NOOPEN: ClassVar[DynamicEntryFlags.FLAG] = ...
        NORELOC: ClassVar[DynamicEntryFlags.FLAG] = ...
        NOW: ClassVar[DynamicEntryFlags.FLAG] = ...
        ORIGIN: ClassVar[DynamicEntryFlags.FLAG] = ...
        PIE: ClassVar[DynamicEntryFlags.FLAG] = ...
        SINGLETON: ClassVar[DynamicEntryFlags.FLAG] = ...
        STATIC_TLS: ClassVar[DynamicEntryFlags.FLAG] = ...
        SYMBOLIC: ClassVar[DynamicEntryFlags.FLAG] = ...
        SYMINTPOSE: ClassVar[DynamicEntryFlags.FLAG] = ...
        TEXTREL: ClassVar[DynamicEntryFlags.FLAG] = ...
        TRANS: ClassVar[DynamicEntryFlags.FLAG] = ...
        WEAKFILTER: ClassVar[DynamicEntryFlags.FLAG] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.DynamicEntryFlags.FLAG: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def add(self, flag: lief.ELF.DynamicEntryFlags.FLAG) -> None: ...
    def has(self, flag: lief.ELF.DynamicEntryFlags.FLAG) -> bool: ...
    def remove(self, flag: lief.ELF.DynamicEntryFlags.FLAG) -> None: ...
    def __contains__(self, arg: lief.ELF.DynamicEntryFlags.FLAG, /) -> bool: ...
    def __iadd__(self, arg: lief.ELF.DynamicEntryFlags.FLAG, /) -> lief.ELF.DynamicEntryFlags: ...
    def __isub__(self, arg: lief.ELF.DynamicEntryFlags.FLAG, /) -> lief.ELF.DynamicEntryFlags: ...
    @property
    def flags(self) -> list[lief.ELF.DynamicEntryFlags.FLAG]: ...

class DynamicEntryLibrary(DynamicEntry):
    name: Union[str,bytes]
    def __init__(self, library_name: str) -> None: ...

class DynamicEntryRpath(DynamicEntry):
    paths: list[str]
    rpath: Union[str,bytes]
    @overload
    def __init__(self, path: str = ...) -> None: ...
    @overload
    def __init__(self, paths: list[str]) -> None: ...
    def append(self, path: str) -> lief.ELF.DynamicEntryRpath: ...
    def insert(self, position: int, path: str) -> lief.ELF.DynamicEntryRpath: ...
    def remove(self, path: str) -> lief.ELF.DynamicEntryRpath: ...
    def __iadd__(self, arg: str, /) -> lief.ELF.DynamicEntryRpath: ...
    def __isub__(self, arg: str, /) -> lief.ELF.DynamicEntryRpath: ...

class DynamicEntryRunPath(DynamicEntry):
    paths: list[str]
    runpath: Union[str,bytes]
    @overload
    def __init__(self, path: str = ...) -> None: ...
    @overload
    def __init__(self, paths: list[str]) -> None: ...
    def append(self, path: str) -> lief.ELF.DynamicEntryRunPath: ...
    def insert(self, position: int, path: str) -> lief.ELF.DynamicEntryRunPath: ...
    def remove(self, path: str) -> lief.ELF.DynamicEntryRunPath: ...
    def __iadd__(self, arg: str, /) -> lief.ELF.DynamicEntryRunPath: ...
    def __isub__(self, arg: str, /) -> lief.ELF.DynamicEntryRunPath: ...

class DynamicSharedObject(DynamicEntry):
    name: Union[str,bytes]
    def __init__(self, library_name: str) -> None: ...

class Generic(NoteGnuProperty.Property):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def raw_type(self) -> int: ...

class GnuHash(lief.Object):
    def __init__(self) -> None: ...
    @overload
    def check(self, symbol_name: str) -> bool: ...
    @overload
    def check(self, hash_value: int) -> bool: ...
    def check_bloom_filter(self, hash: int) -> bool: ...
    def check_bucket(self, hash: int) -> bool: ...
    @property
    def bloom_filters(self) -> list[int]: ...
    @property
    def buckets(self) -> list[int]: ...
    @property
    def hash_values(self) -> list[int]: ...
    @property
    def nb_buckets(self) -> int: ...
    @property
    def shift2(self) -> int: ...
    @property
    def symbol_index(self) -> int: ...

class Header(lief.Object):
    class CLASS:
        ELF32: ClassVar[Header.CLASS] = ...
        ELF64: ClassVar[Header.CLASS] = ...
        NONE: ClassVar[Header.CLASS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Header.CLASS: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class ELF_DATA:
        LSB: ClassVar[Header.ELF_DATA] = ...
        MSB: ClassVar[Header.ELF_DATA] = ...
        NONE: ClassVar[Header.ELF_DATA] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Header.ELF_DATA: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class FILE_TYPE:
        CORE: ClassVar[Header.FILE_TYPE] = ...
        DYN: ClassVar[Header.FILE_TYPE] = ...
        EXEC: ClassVar[Header.FILE_TYPE] = ...
        NONE: ClassVar[Header.FILE_TYPE] = ...
        REL: ClassVar[Header.FILE_TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Header.FILE_TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class OS_ABI:
        AIX: ClassVar[Header.OS_ABI] = ...
        AMDGPU_HSA: ClassVar[Header.OS_ABI] = ...
        ARM: ClassVar[Header.OS_ABI] = ...
        AROS: ClassVar[Header.OS_ABI] = ...
        C6000_LINUX: ClassVar[Header.OS_ABI] = ...
        CLOUDABI: ClassVar[Header.OS_ABI] = ...
        FENIXOS: ClassVar[Header.OS_ABI] = ...
        FREEBSD: ClassVar[Header.OS_ABI] = ...
        HPUX: ClassVar[Header.OS_ABI] = ...
        HURD: ClassVar[Header.OS_ABI] = ...
        IRIX: ClassVar[Header.OS_ABI] = ...
        LINUX: ClassVar[Header.OS_ABI] = ...
        MODESTO: ClassVar[Header.OS_ABI] = ...
        NETBSD: ClassVar[Header.OS_ABI] = ...
        NSK: ClassVar[Header.OS_ABI] = ...
        OPENBSD: ClassVar[Header.OS_ABI] = ...
        OPENVMS: ClassVar[Header.OS_ABI] = ...
        SOLARIS: ClassVar[Header.OS_ABI] = ...
        STANDALONE: ClassVar[Header.OS_ABI] = ...
        SYSTEMV: ClassVar[Header.OS_ABI] = ...
        TRU64: ClassVar[Header.OS_ABI] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Header.OS_ABI: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class VERSION:
        CURRENT: ClassVar[Header.VERSION] = ...
        NONE: ClassVar[Header.VERSION] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Header.VERSION: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    entrypoint: int
    file_type: lief.ELF.Header.FILE_TYPE
    header_size: int
    identity: list[int]
    identity_abi_version: int
    identity_class: lief.ELF.Header.CLASS
    identity_data: lief.ELF.Header.ELF_DATA
    identity_os_abi: lief.ELF.Header.OS_ABI
    identity_version: lief.ELF.Header.VERSION
    machine_type: lief.ELF.ARCH
    numberof_sections: int
    numberof_segments: int
    object_file_version: lief.ELF.Header.VERSION
    processor_flag: int
    program_header_offset: int
    program_header_size: int
    section_header_offset: int
    section_header_size: int
    section_name_table_idx: int
    def __init__(self) -> None: ...
    def has(self, arg: lief.ELF.PROCESSOR_FLAGS, /) -> bool: ...
    @property
    def flags_list(self) -> list[lief.ELF.PROCESSOR_FLAGS]: ...

class Note(lief.Object):
    class TYPE:
        ANDROID_IDENT: ClassVar[Note.TYPE] = ...
        ANDROID_KUSER: ClassVar[Note.TYPE] = ...
        ANDROID_MEMTAG: ClassVar[Note.TYPE] = ...
        CORE_ARM_HW_BREAK: ClassVar[Note.TYPE] = ...
        CORE_ARM_HW_WATCH: ClassVar[Note.TYPE] = ...
        CORE_ARM_PACA_KEYS: ClassVar[Note.TYPE] = ...
        CORE_ARM_PACG_KEYS: ClassVar[Note.TYPE] = ...
        CORE_ARM_PAC_MASK: ClassVar[Note.TYPE] = ...
        CORE_ARM_SVE: ClassVar[Note.TYPE] = ...
        CORE_ARM_SYSTEM_CALL: ClassVar[Note.TYPE] = ...
        CORE_ARM_TLS: ClassVar[Note.TYPE] = ...
        CORE_ARM_VFP: ClassVar[Note.TYPE] = ...
        CORE_AUXV: ClassVar[Note.TYPE] = ...
        CORE_FILE: ClassVar[Note.TYPE] = ...
        CORE_FPREGS: ClassVar[Note.TYPE] = ...
        CORE_FPREGSET: ClassVar[Note.TYPE] = ...
        CORE_LWPSINFO: ClassVar[Note.TYPE] = ...
        CORE_LWPSTATUS: ClassVar[Note.TYPE] = ...
        CORE_PAC_ENABLED_KEYS: ClassVar[Note.TYPE] = ...
        CORE_PRPSINFO: ClassVar[Note.TYPE] = ...
        CORE_PRSTATUS: ClassVar[Note.TYPE] = ...
        CORE_PRXFPREG: ClassVar[Note.TYPE] = ...
        CORE_PSINFO: ClassVar[Note.TYPE] = ...
        CORE_PSTATUS: ClassVar[Note.TYPE] = ...
        CORE_SIGINFO: ClassVar[Note.TYPE] = ...
        CORE_TAGGED_ADDR_CTRL: ClassVar[Note.TYPE] = ...
        CORE_TASKSTRUCT: ClassVar[Note.TYPE] = ...
        CORE_WIN32PSTATUS: ClassVar[Note.TYPE] = ...
        CORE_X86_CET: ClassVar[Note.TYPE] = ...
        CORE_X86_IOPERM: ClassVar[Note.TYPE] = ...
        CORE_X86_TLS: ClassVar[Note.TYPE] = ...
        CORE_X86_XSTATE: ClassVar[Note.TYPE] = ...
        CRASHPAD: ClassVar[Note.TYPE] = ...
        GNU_ABI_TAG: ClassVar[Note.TYPE] = ...
        GNU_BUILD_ATTRIBUTE_FUNC: ClassVar[Note.TYPE] = ...
        GNU_BUILD_ATTRIBUTE_OPEN: ClassVar[Note.TYPE] = ...
        GNU_BUILD_ID: ClassVar[Note.TYPE] = ...
        GNU_GOLD_VERSION: ClassVar[Note.TYPE] = ...
        GNU_HWCAP: ClassVar[Note.TYPE] = ...
        GNU_PROPERTY_TYPE_0: ClassVar[Note.TYPE] = ...
        GO_BUILDID: ClassVar[Note.TYPE] = ...
        QNX_STACK: ClassVar[Note.TYPE] = ...
        STAPSDT: ClassVar[Note.TYPE] = ...
        UNKNOWN: ClassVar[Note.TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Note.TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    description: memoryview
    name: str
    def __init__(self, *args, **kwargs) -> None: ...
    def copy(self) -> Optional[lief.ELF.Note]: ...
    @overload
    @staticmethod
    def create(name: str, original_type: int, description: list[int], section_name: str, file_type: lief.ELF.Header.FILE_TYPE = ..., arch: lief.ELF.ARCH = ..., cls: lief.ELF.Header.CLASS = ...) -> Optional[lief.ELF.Note]: ...
    @overload
    @staticmethod
    def create(raw: bytes, section_name: str = ..., file_type: lief.ELF.Header.FILE_TYPE = ..., arch: lief.ELF.ARCH = ..., cls: lief.ELF.Header.CLASS = ...) -> Optional[lief.ELF.Note]: ...
    @overload
    @staticmethod
    def create(name: str, type: lief.ELF.Note.TYPE, description: list[int], section_name: str, arch: lief.ELF.ARCH = ..., cls: lief.ELF.Header.CLASS = ...) -> Optional[lief.ELF.Note]: ...
    @property
    def original_type(self) -> int: ...
    @property
    def size(self) -> int: ...
    @property
    def type(self) -> lief.ELF.Note.TYPE: ...

class NoteAbi(Note):
    class ABI:
        FREEBSD: ClassVar[NoteAbi.ABI] = ...
        GNU: ClassVar[NoteAbi.ABI] = ...
        LINUX: ClassVar[NoteAbi.ABI] = ...
        NACL: ClassVar[NoteAbi.ABI] = ...
        NETBSD: ClassVar[NoteAbi.ABI] = ...
        SOLARIS2: ClassVar[NoteAbi.ABI] = ...
        SYLLABLE: ClassVar[NoteAbi.ABI] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.NoteAbi.ABI: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def abi(self) -> Optional[lief.ELF.NoteAbi.ABI]: ...
    @property
    def version(self) -> Optional[list[int]]: ...

class NoteGnuProperty(Note):
    class Property:
        class TYPE:
            AARCH64_FEATURES: ClassVar[NoteGnuProperty.Property.TYPE] = ...
            GENERIC: ClassVar[NoteGnuProperty.Property.TYPE] = ...
            NEEDED: ClassVar[NoteGnuProperty.Property.TYPE] = ...
            NO_COPY_ON_PROTECTED: ClassVar[NoteGnuProperty.Property.TYPE] = ...
            STACK_SIZE: ClassVar[NoteGnuProperty.Property.TYPE] = ...
            UNKNOWN: ClassVar[NoteGnuProperty.Property.TYPE] = ...
            X86_FEATURE: ClassVar[NoteGnuProperty.Property.TYPE] = ...
            X86_ISA: ClassVar[NoteGnuProperty.Property.TYPE] = ...
            __name__: str
            def __init__(self, *args, **kwargs) -> None: ...
            @staticmethod
            def from_value(arg: int, /) -> lief.ELF.NoteGnuProperty.Property.TYPE: ...
            def __ge__(self, other) -> bool: ...
            def __gt__(self, other) -> bool: ...
            def __hash__(self) -> int: ...
            def __index__(self) -> Any: ...
            def __int__(self) -> int: ...
            def __le__(self, other) -> bool: ...
            def __lt__(self, other) -> bool: ...
            @property
            def value(self) -> int: ...
        def __init__(self, *args, **kwargs) -> None: ...
        @property
        def type(self) -> lief.ELF.NoteGnuProperty.Property.TYPE: ...
    def __init__(self, *args, **kwargs) -> None: ...
    def find(self, arg: lief.ELF.NoteGnuProperty.Property.TYPE, /) -> Optional[lief.ELF.NoteGnuProperty.Property]: ...
    @property
    def properties(self) -> list[Optional[lief.ELF.NoteGnuProperty.Property]]: ...

class NoteNoCopyOnProtected(NoteGnuProperty.Property):
    def __init__(self, *args, **kwargs) -> None: ...

class PROCESSOR_FLAGS:
    ARM_EABI_UNKNOWN: ClassVar[PROCESSOR_FLAGS] = ...
    ARM_EABI_VER1: ClassVar[PROCESSOR_FLAGS] = ...
    ARM_EABI_VER2: ClassVar[PROCESSOR_FLAGS] = ...
    ARM_EABI_VER3: ClassVar[PROCESSOR_FLAGS] = ...
    ARM_EABI_VER4: ClassVar[PROCESSOR_FLAGS] = ...
    ARM_EABI_VER5: ClassVar[PROCESSOR_FLAGS] = ...
    ARM_SOFT_FLOAT: ClassVar[PROCESSOR_FLAGS] = ...
    ARM_VFP_FLOAT: ClassVar[PROCESSOR_FLAGS] = ...
    HEXAGON_ISA_V2: ClassVar[PROCESSOR_FLAGS] = ...
    HEXAGON_ISA_V3: ClassVar[PROCESSOR_FLAGS] = ...
    HEXAGON_ISA_V4: ClassVar[PROCESSOR_FLAGS] = ...
    HEXAGON_ISA_V5: ClassVar[PROCESSOR_FLAGS] = ...
    HEXAGON_MACH_V2: ClassVar[PROCESSOR_FLAGS] = ...
    HEXAGON_MACH_V3: ClassVar[PROCESSOR_FLAGS] = ...
    HEXAGON_MACH_V4: ClassVar[PROCESSOR_FLAGS] = ...
    HEXAGON_MACH_V5: ClassVar[PROCESSOR_FLAGS] = ...
    LOONGARCH_ABI_DOUBLE_FLOAT: ClassVar[PROCESSOR_FLAGS] = ...
    LOONGARCH_ABI_SINGLE_FLOAT: ClassVar[PROCESSOR_FLAGS] = ...
    LOONGARCH_ABI_SOFT_FLOAT: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_32BITMODE: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ABI2: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ABI_EABI32: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ABI_EABI64: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ABI_O32: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ABI_O64: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ARCH_1: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ARCH_2: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ARCH_3: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ARCH_32: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ARCH_32R2: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ARCH_32R6: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ARCH_4: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ARCH_5: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ARCH_64: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ARCH_64R2: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ARCH_64R6: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ARCH_ASE_M16: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_ARCH_ASE_MDMX: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_CPIC: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_FP64: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_3900: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_4010: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_4100: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_4111: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_4120: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_4650: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_5400: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_5500: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_5900: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_9000: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_LS2E: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_LS2F: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_LS3A: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_OCTEON: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_OCTEON2: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_OCTEON3: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_SB1: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MACH_XLR: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_MICROMIPS: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_NAN2008: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_NOREORDER: ClassVar[PROCESSOR_FLAGS] = ...
    MIPS_PIC: ClassVar[PROCESSOR_FLAGS] = ...
    __name__: str
    def __init__(self, *args, **kwargs) -> None: ...
    @staticmethod
    def from_value(arg: int, /) -> lief.ELF.PROCESSOR_FLAGS: ...
    def __ge__(self, other) -> bool: ...
    def __gt__(self, other) -> bool: ...
    def __hash__(self) -> int: ...
    def __index__(self) -> Any: ...
    def __int__(self) -> int: ...
    def __le__(self, other) -> bool: ...
    def __lt__(self, other) -> bool: ...
    @property
    def value(self) -> int: ...

class ParserConfig:
    class DYNSYM_COUNT:
        AUTO: ClassVar[ParserConfig.DYNSYM_COUNT] = ...
        HASH: ClassVar[ParserConfig.DYNSYM_COUNT] = ...
        RELOCATIONS: ClassVar[ParserConfig.DYNSYM_COUNT] = ...
        SECTION: ClassVar[ParserConfig.DYNSYM_COUNT] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.ParserConfig.DYNSYM_COUNT: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    count_mtd: lief.ELF.ParserConfig.DYNSYM_COUNT
    parse_dyn_symbols: bool
    parse_notes: bool
    parse_overlay: bool
    parse_relocations: bool
    parse_symbol_versions: bool
    parse_symtab_symbols: bool
    def __init__(self) -> None: ...
    @property
    def all(self) -> lief.ELF.ParserConfig: ...

class QNXStack(Note):
    is_executable: bool
    stack_allocated: int
    stack_size: int
    def __init__(self, *args, **kwargs) -> None: ...

class Relocation(lief.Relocation):
    class ENCODING:
        ANDROID_SLEB: ClassVar[Relocation.ENCODING] = ...
        REL: ClassVar[Relocation.ENCODING] = ...
        RELA: ClassVar[Relocation.ENCODING] = ...
        RELR: ClassVar[Relocation.ENCODING] = ...
        UNKNOWN: ClassVar[Relocation.ENCODING] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Relocation.ENCODING: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class PURPOSE:
        DYNAMIC: ClassVar[Relocation.PURPOSE] = ...
        NONE: ClassVar[Relocation.PURPOSE] = ...
        OBJECT: ClassVar[Relocation.PURPOSE] = ...
        PLTGOT: ClassVar[Relocation.PURPOSE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Relocation.PURPOSE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class TYPE:
        AARCH64_ABS16: ClassVar[Relocation.TYPE] = ...
        AARCH64_ABS32: ClassVar[Relocation.TYPE] = ...
        AARCH64_ABS64: ClassVar[Relocation.TYPE] = ...
        AARCH64_ADD_ABS_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_ADR_GOT_PAGE: ClassVar[Relocation.TYPE] = ...
        AARCH64_ADR_PREL_LO21: ClassVar[Relocation.TYPE] = ...
        AARCH64_ADR_PREL_PG_HI21: ClassVar[Relocation.TYPE] = ...
        AARCH64_ADR_PREL_PG_HI21_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_CALL26: ClassVar[Relocation.TYPE] = ...
        AARCH64_CONDBR19: ClassVar[Relocation.TYPE] = ...
        AARCH64_COPY: ClassVar[Relocation.TYPE] = ...
        AARCH64_GLOB_DAT: ClassVar[Relocation.TYPE] = ...
        AARCH64_GOTREL32: ClassVar[Relocation.TYPE] = ...
        AARCH64_GOTREL64: ClassVar[Relocation.TYPE] = ...
        AARCH64_GOT_LD_PREL19: ClassVar[Relocation.TYPE] = ...
        AARCH64_IRELATIVE: ClassVar[Relocation.TYPE] = ...
        AARCH64_JUMP26: ClassVar[Relocation.TYPE] = ...
        AARCH64_JUMP_SLOT: ClassVar[Relocation.TYPE] = ...
        AARCH64_LD64_GOTOFF_LO15: ClassVar[Relocation.TYPE] = ...
        AARCH64_LD64_GOTPAGE_LO15: ClassVar[Relocation.TYPE] = ...
        AARCH64_LD64_GOT_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_LDST128_ABS_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_LDST16_ABS_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_LDST32_ABS_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_LDST64_ABS_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_LDST8_ABS_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_LD_PREL_LO19: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_GOTOFF_G0: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_GOTOFF_G0_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_GOTOFF_G1: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_GOTOFF_G1_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_GOTOFF_G2: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_GOTOFF_G2_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_GOTOFF_G3: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_PREL_G0: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_PREL_G0_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_PREL_G1: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_PREL_G1_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_PREL_G2: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_PREL_G2_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_PREL_G3: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_SABS_G0: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_SABS_G1: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_SABS_G2: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_UABS_G0: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_UABS_G0_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_UABS_G1: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_UABS_G1_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_UABS_G2: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_UABS_G2_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_MOVW_UABS_G3: ClassVar[Relocation.TYPE] = ...
        AARCH64_NONE: ClassVar[Relocation.TYPE] = ...
        AARCH64_PREL16: ClassVar[Relocation.TYPE] = ...
        AARCH64_PREL32: ClassVar[Relocation.TYPE] = ...
        AARCH64_PREL64: ClassVar[Relocation.TYPE] = ...
        AARCH64_RELATIVE: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSDESC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSDESC_ADD: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSDESC_ADD_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSDESC_ADR_PAGE21: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSDESC_ADR_PREL21: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSDESC_CALL: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSDESC_LD64_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSDESC_LDR: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSDESC_LD_PREL19: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSDESC_OFF_G0_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSDESC_OFF_G1: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSGD_ADD_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSGD_ADR_PAGE21: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSGD_ADR_PREL21: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSGD_MOVW_G0_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSGD_MOVW_G1: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSIE_ADR_GOTTPREL_PAGE21: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSIE_LD64_GOTTPREL_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSIE_LD_GOTTPREL_PREL19: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSIE_MOVW_GOTTPREL_G0_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSIE_MOVW_GOTTPREL_G1: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_ADD_DTPREL_HI12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_ADD_DTPREL_LO12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_ADD_DTPREL_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_ADD_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_ADR_PAGE21: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_ADR_PREL21: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_LDST128_DTPREL_LO12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_LDST128_DTPREL_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_LDST16_DTPREL_LO12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_LDST16_DTPREL_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_LDST32_DTPREL_LO12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_LDST32_DTPREL_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_LDST64_DTPREL_LO12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_LDST64_DTPREL_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_LDST8_DTPREL_LO12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_LDST8_DTPREL_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_LD_PREL19: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_MOVW_DTPREL_G0: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_MOVW_DTPREL_G0_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_MOVW_DTPREL_G1: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_MOVW_DTPREL_G1_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_MOVW_DTPREL_G2: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_MOVW_G0_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLD_MOVW_G1: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_ADD_TPREL_HI12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_ADD_TPREL_LO12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_ADD_TPREL_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_LDST128_TPREL_LO12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_LDST128_TPREL_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_LDST16_TPREL_LO12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_LDST16_TPREL_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_LDST32_TPREL_LO12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_LDST32_TPREL_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_LDST64_TPREL_LO12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_LDST64_TPREL_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_LDST8_TPREL_LO12: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_LDST8_TPREL_LO12_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_MOVW_TPREL_G0: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_MOVW_TPREL_G0_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_MOVW_TPREL_G1: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_MOVW_TPREL_G1_NC: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLSLE_MOVW_TPREL_G2: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLS_DTPMOD64: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLS_DTPREL64: ClassVar[Relocation.TYPE] = ...
        AARCH64_TLS_TPREL64: ClassVar[Relocation.TYPE] = ...
        AARCH64_TSTBR14: ClassVar[Relocation.TYPE] = ...
        ARM_ABS12: ClassVar[Relocation.TYPE] = ...
        ARM_ABS16: ClassVar[Relocation.TYPE] = ...
        ARM_ABS32: ClassVar[Relocation.TYPE] = ...
        ARM_ABS32_NOI: ClassVar[Relocation.TYPE] = ...
        ARM_ABS8: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_PCREL_15_8: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_PCREL_23_15: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_PCREL_7_0: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_PC_G0: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_PC_G0_NC: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_PC_G1: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_PC_G1_NC: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_PC_G2: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_SBREL_19_12_NC: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_SBREL_27_20_CK: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_SB_G0: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_SB_G0_NC: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_SB_G1: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_SB_G1_NC: ClassVar[Relocation.TYPE] = ...
        ARM_ALU_SB_G2: ClassVar[Relocation.TYPE] = ...
        ARM_BASE_ABS: ClassVar[Relocation.TYPE] = ...
        ARM_BASE_PREL: ClassVar[Relocation.TYPE] = ...
        ARM_BREL_ADJ: ClassVar[Relocation.TYPE] = ...
        ARM_CALL: ClassVar[Relocation.TYPE] = ...
        ARM_COPY: ClassVar[Relocation.TYPE] = ...
        ARM_GLOB_DAT: ClassVar[Relocation.TYPE] = ...
        ARM_GNU_VTENTRY: ClassVar[Relocation.TYPE] = ...
        ARM_GNU_VTINHERIT: ClassVar[Relocation.TYPE] = ...
        ARM_GOTOFF12: ClassVar[Relocation.TYPE] = ...
        ARM_GOTOFF32: ClassVar[Relocation.TYPE] = ...
        ARM_GOTRELAX: ClassVar[Relocation.TYPE] = ...
        ARM_GOT_ABS: ClassVar[Relocation.TYPE] = ...
        ARM_GOT_BREL: ClassVar[Relocation.TYPE] = ...
        ARM_GOT_BREL12: ClassVar[Relocation.TYPE] = ...
        ARM_GOT_PREL: ClassVar[Relocation.TYPE] = ...
        ARM_IRELATIVE: ClassVar[Relocation.TYPE] = ...
        ARM_JUMP24: ClassVar[Relocation.TYPE] = ...
        ARM_JUMP_SLOT: ClassVar[Relocation.TYPE] = ...
        ARM_LDC_PC_G0: ClassVar[Relocation.TYPE] = ...
        ARM_LDC_PC_G1: ClassVar[Relocation.TYPE] = ...
        ARM_LDC_PC_G2: ClassVar[Relocation.TYPE] = ...
        ARM_LDC_SB_G0: ClassVar[Relocation.TYPE] = ...
        ARM_LDC_SB_G1: ClassVar[Relocation.TYPE] = ...
        ARM_LDC_SB_G2: ClassVar[Relocation.TYPE] = ...
        ARM_LDRS_PC_G0: ClassVar[Relocation.TYPE] = ...
        ARM_LDRS_PC_G1: ClassVar[Relocation.TYPE] = ...
        ARM_LDRS_PC_G2: ClassVar[Relocation.TYPE] = ...
        ARM_LDRS_SB_G0: ClassVar[Relocation.TYPE] = ...
        ARM_LDRS_SB_G1: ClassVar[Relocation.TYPE] = ...
        ARM_LDRS_SB_G2: ClassVar[Relocation.TYPE] = ...
        ARM_LDR_PC_G0: ClassVar[Relocation.TYPE] = ...
        ARM_LDR_PC_G1: ClassVar[Relocation.TYPE] = ...
        ARM_LDR_PC_G2: ClassVar[Relocation.TYPE] = ...
        ARM_LDR_SBREL_11_0_NC: ClassVar[Relocation.TYPE] = ...
        ARM_LDR_SB_G0: ClassVar[Relocation.TYPE] = ...
        ARM_LDR_SB_G1: ClassVar[Relocation.TYPE] = ...
        ARM_LDR_SB_G2: ClassVar[Relocation.TYPE] = ...
        ARM_ME_TOO: ClassVar[Relocation.TYPE] = ...
        ARM_MOVT_ABS: ClassVar[Relocation.TYPE] = ...
        ARM_MOVT_BREL: ClassVar[Relocation.TYPE] = ...
        ARM_MOVT_PREL: ClassVar[Relocation.TYPE] = ...
        ARM_MOVW_ABS_NC: ClassVar[Relocation.TYPE] = ...
        ARM_MOVW_BREL: ClassVar[Relocation.TYPE] = ...
        ARM_MOVW_BREL_NC: ClassVar[Relocation.TYPE] = ...
        ARM_MOVW_PREL_NC: ClassVar[Relocation.TYPE] = ...
        ARM_NONE: ClassVar[Relocation.TYPE] = ...
        ARM_PC24: ClassVar[Relocation.TYPE] = ...
        ARM_PLT32: ClassVar[Relocation.TYPE] = ...
        ARM_PLT32_ABS: ClassVar[Relocation.TYPE] = ...
        ARM_PREL31: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_0: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_1: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_10: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_11: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_12: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_13: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_14: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_15: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_2: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_3: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_4: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_5: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_6: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_7: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_8: ClassVar[Relocation.TYPE] = ...
        ARM_PRIVATE_9: ClassVar[Relocation.TYPE] = ...
        ARM_RBASE: ClassVar[Relocation.TYPE] = ...
        ARM_REL32: ClassVar[Relocation.TYPE] = ...
        ARM_REL32_NOI: ClassVar[Relocation.TYPE] = ...
        ARM_RELATIVE: ClassVar[Relocation.TYPE] = ...
        ARM_RPC24: ClassVar[Relocation.TYPE] = ...
        ARM_RREL32: ClassVar[Relocation.TYPE] = ...
        ARM_RSBREL32: ClassVar[Relocation.TYPE] = ...
        ARM_RXPC25: ClassVar[Relocation.TYPE] = ...
        ARM_SBREL31: ClassVar[Relocation.TYPE] = ...
        ARM_SBREL32: ClassVar[Relocation.TYPE] = ...
        ARM_TARGET1: ClassVar[Relocation.TYPE] = ...
        ARM_TARGET2: ClassVar[Relocation.TYPE] = ...
        ARM_THM_ABS5: ClassVar[Relocation.TYPE] = ...
        ARM_THM_ALU_PREL_11_0: ClassVar[Relocation.TYPE] = ...
        ARM_THM_CALL: ClassVar[Relocation.TYPE] = ...
        ARM_THM_JUMP11: ClassVar[Relocation.TYPE] = ...
        ARM_THM_JUMP19: ClassVar[Relocation.TYPE] = ...
        ARM_THM_JUMP24: ClassVar[Relocation.TYPE] = ...
        ARM_THM_JUMP6: ClassVar[Relocation.TYPE] = ...
        ARM_THM_JUMP8: ClassVar[Relocation.TYPE] = ...
        ARM_THM_MOVT_ABS: ClassVar[Relocation.TYPE] = ...
        ARM_THM_MOVT_BREL: ClassVar[Relocation.TYPE] = ...
        ARM_THM_MOVT_PREL: ClassVar[Relocation.TYPE] = ...
        ARM_THM_MOVW_ABS_NC: ClassVar[Relocation.TYPE] = ...
        ARM_THM_MOVW_BREL: ClassVar[Relocation.TYPE] = ...
        ARM_THM_MOVW_BREL_NC: ClassVar[Relocation.TYPE] = ...
        ARM_THM_MOVW_PREL_NC: ClassVar[Relocation.TYPE] = ...
        ARM_THM_PC12: ClassVar[Relocation.TYPE] = ...
        ARM_THM_PC8: ClassVar[Relocation.TYPE] = ...
        ARM_THM_RPC22: ClassVar[Relocation.TYPE] = ...
        ARM_THM_SWI8: ClassVar[Relocation.TYPE] = ...
        ARM_THM_TLS_CALL: ClassVar[Relocation.TYPE] = ...
        ARM_THM_TLS_DESCSEQ16: ClassVar[Relocation.TYPE] = ...
        ARM_THM_TLS_DESCSEQ32: ClassVar[Relocation.TYPE] = ...
        ARM_THM_XPC22: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_CALL: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_DESC: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_DESCSEQ: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_DTPMOD32: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_DTPOFF32: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_GD32: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_GOTDESC: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_IE12GP: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_IE32: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_LDM32: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_LDO12: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_LDO32: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_LE12: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_LE32: ClassVar[Relocation.TYPE] = ...
        ARM_TLS_TPOFF32: ClassVar[Relocation.TYPE] = ...
        ARM_V4BX: ClassVar[Relocation.TYPE] = ...
        ARM_XPC25: ClassVar[Relocation.TYPE] = ...
        HEX_10_X: ClassVar[Relocation.TYPE] = ...
        HEX_11_X: ClassVar[Relocation.TYPE] = ...
        HEX_12_X: ClassVar[Relocation.TYPE] = ...
        HEX_16: ClassVar[Relocation.TYPE] = ...
        HEX_16_X: ClassVar[Relocation.TYPE] = ...
        HEX_32: ClassVar[Relocation.TYPE] = ...
        HEX_32_6_X: ClassVar[Relocation.TYPE] = ...
        HEX_32_PCREL: ClassVar[Relocation.TYPE] = ...
        HEX_6_PCREL_X: ClassVar[Relocation.TYPE] = ...
        HEX_6_X: ClassVar[Relocation.TYPE] = ...
        HEX_7_X: ClassVar[Relocation.TYPE] = ...
        HEX_8: ClassVar[Relocation.TYPE] = ...
        HEX_8_X: ClassVar[Relocation.TYPE] = ...
        HEX_9_X: ClassVar[Relocation.TYPE] = ...
        HEX_B13_PCREL: ClassVar[Relocation.TYPE] = ...
        HEX_B13_PCREL_X: ClassVar[Relocation.TYPE] = ...
        HEX_B15_PCREL: ClassVar[Relocation.TYPE] = ...
        HEX_B15_PCREL_X: ClassVar[Relocation.TYPE] = ...
        HEX_B22_PCREL: ClassVar[Relocation.TYPE] = ...
        HEX_B22_PCREL_X: ClassVar[Relocation.TYPE] = ...
        HEX_B32_PCREL_X: ClassVar[Relocation.TYPE] = ...
        HEX_B7_PCREL: ClassVar[Relocation.TYPE] = ...
        HEX_B7_PCREL_X: ClassVar[Relocation.TYPE] = ...
        HEX_B9_PCREL: ClassVar[Relocation.TYPE] = ...
        HEX_B9_PCREL_X: ClassVar[Relocation.TYPE] = ...
        HEX_COPY: ClassVar[Relocation.TYPE] = ...
        HEX_DTPMOD_32: ClassVar[Relocation.TYPE] = ...
        HEX_DTPREL_11_X: ClassVar[Relocation.TYPE] = ...
        HEX_DTPREL_16: ClassVar[Relocation.TYPE] = ...
        HEX_DTPREL_16_X: ClassVar[Relocation.TYPE] = ...
        HEX_DTPREL_32: ClassVar[Relocation.TYPE] = ...
        HEX_DTPREL_32_6_X: ClassVar[Relocation.TYPE] = ...
        HEX_DTPREL_HI16: ClassVar[Relocation.TYPE] = ...
        HEX_DTPREL_LO16: ClassVar[Relocation.TYPE] = ...
        HEX_GD_GOT_11_X: ClassVar[Relocation.TYPE] = ...
        HEX_GD_GOT_16: ClassVar[Relocation.TYPE] = ...
        HEX_GD_GOT_16_X: ClassVar[Relocation.TYPE] = ...
        HEX_GD_GOT_32: ClassVar[Relocation.TYPE] = ...
        HEX_GD_GOT_32_6_X: ClassVar[Relocation.TYPE] = ...
        HEX_GD_GOT_HI16: ClassVar[Relocation.TYPE] = ...
        HEX_GD_GOT_LO16: ClassVar[Relocation.TYPE] = ...
        HEX_GD_PLT_B22_PCREL: ClassVar[Relocation.TYPE] = ...
        HEX_GLOB_DAT: ClassVar[Relocation.TYPE] = ...
        HEX_GOTREL_11_X: ClassVar[Relocation.TYPE] = ...
        HEX_GOTREL_16_X: ClassVar[Relocation.TYPE] = ...
        HEX_GOTREL_32: ClassVar[Relocation.TYPE] = ...
        HEX_GOTREL_32_6_X: ClassVar[Relocation.TYPE] = ...
        HEX_GOTREL_HI16: ClassVar[Relocation.TYPE] = ...
        HEX_GOTREL_LO16: ClassVar[Relocation.TYPE] = ...
        HEX_GOT_11_X: ClassVar[Relocation.TYPE] = ...
        HEX_GOT_16: ClassVar[Relocation.TYPE] = ...
        HEX_GOT_16_X: ClassVar[Relocation.TYPE] = ...
        HEX_GOT_32: ClassVar[Relocation.TYPE] = ...
        HEX_GOT_32_6_X: ClassVar[Relocation.TYPE] = ...
        HEX_GOT_HI16: ClassVar[Relocation.TYPE] = ...
        HEX_GOT_LO16: ClassVar[Relocation.TYPE] = ...
        HEX_GPREL16_0: ClassVar[Relocation.TYPE] = ...
        HEX_GPREL16_1: ClassVar[Relocation.TYPE] = ...
        HEX_GPREL16_2: ClassVar[Relocation.TYPE] = ...
        HEX_GPREL16_3: ClassVar[Relocation.TYPE] = ...
        HEX_HI16: ClassVar[Relocation.TYPE] = ...
        HEX_HL16: ClassVar[Relocation.TYPE] = ...
        HEX_IE_16_X: ClassVar[Relocation.TYPE] = ...
        HEX_IE_32: ClassVar[Relocation.TYPE] = ...
        HEX_IE_32_6_X: ClassVar[Relocation.TYPE] = ...
        HEX_IE_GOT_11_X: ClassVar[Relocation.TYPE] = ...
        HEX_IE_GOT_16: ClassVar[Relocation.TYPE] = ...
        HEX_IE_GOT_16_X: ClassVar[Relocation.TYPE] = ...
        HEX_IE_GOT_32: ClassVar[Relocation.TYPE] = ...
        HEX_IE_GOT_32_6_X: ClassVar[Relocation.TYPE] = ...
        HEX_IE_GOT_HI16: ClassVar[Relocation.TYPE] = ...
        HEX_IE_GOT_LO16: ClassVar[Relocation.TYPE] = ...
        HEX_IE_HI16: ClassVar[Relocation.TYPE] = ...
        HEX_IE_LO16: ClassVar[Relocation.TYPE] = ...
        HEX_JMP_SLOT: ClassVar[Relocation.TYPE] = ...
        HEX_LD_GOT_11_X: ClassVar[Relocation.TYPE] = ...
        HEX_LD_GOT_16: ClassVar[Relocation.TYPE] = ...
        HEX_LD_GOT_16_X: ClassVar[Relocation.TYPE] = ...
        HEX_LD_GOT_32: ClassVar[Relocation.TYPE] = ...
        HEX_LD_GOT_32_6_X: ClassVar[Relocation.TYPE] = ...
        HEX_LD_GOT_HI16: ClassVar[Relocation.TYPE] = ...
        HEX_LD_GOT_LO16: ClassVar[Relocation.TYPE] = ...
        HEX_LD_PLT_B22_PCREL: ClassVar[Relocation.TYPE] = ...
        HEX_LO16: ClassVar[Relocation.TYPE] = ...
        HEX_NONE: ClassVar[Relocation.TYPE] = ...
        HEX_PLT_B22_PCREL: ClassVar[Relocation.TYPE] = ...
        HEX_RELATIVE: ClassVar[Relocation.TYPE] = ...
        HEX_TPREL_11_X: ClassVar[Relocation.TYPE] = ...
        HEX_TPREL_16: ClassVar[Relocation.TYPE] = ...
        HEX_TPREL_16_X: ClassVar[Relocation.TYPE] = ...
        HEX_TPREL_32: ClassVar[Relocation.TYPE] = ...
        HEX_TPREL_32_6_X: ClassVar[Relocation.TYPE] = ...
        HEX_TPREL_HI16: ClassVar[Relocation.TYPE] = ...
        HEX_TPREL_LO16: ClassVar[Relocation.TYPE] = ...
        LARCH_32: ClassVar[Relocation.TYPE] = ...
        LARCH_32_PCREL: ClassVar[Relocation.TYPE] = ...
        LARCH_64: ClassVar[Relocation.TYPE] = ...
        LARCH_ABS64_HI12: ClassVar[Relocation.TYPE] = ...
        LARCH_ABS64_LO20: ClassVar[Relocation.TYPE] = ...
        LARCH_ABS_HI20: ClassVar[Relocation.TYPE] = ...
        LARCH_ABS_LO12: ClassVar[Relocation.TYPE] = ...
        LARCH_ADD16: ClassVar[Relocation.TYPE] = ...
        LARCH_ADD24: ClassVar[Relocation.TYPE] = ...
        LARCH_ADD32: ClassVar[Relocation.TYPE] = ...
        LARCH_ADD64: ClassVar[Relocation.TYPE] = ...
        LARCH_ADD8: ClassVar[Relocation.TYPE] = ...
        LARCH_B16: ClassVar[Relocation.TYPE] = ...
        LARCH_B21: ClassVar[Relocation.TYPE] = ...
        LARCH_B26: ClassVar[Relocation.TYPE] = ...
        LARCH_COPY: ClassVar[Relocation.TYPE] = ...
        LARCH_GNU_VTENTRY: ClassVar[Relocation.TYPE] = ...
        LARCH_GNU_VTINHERIT: ClassVar[Relocation.TYPE] = ...
        LARCH_GOT64_HI12: ClassVar[Relocation.TYPE] = ...
        LARCH_GOT64_LO20: ClassVar[Relocation.TYPE] = ...
        LARCH_GOT64_PC_HI12: ClassVar[Relocation.TYPE] = ...
        LARCH_GOT64_PC_LO20: ClassVar[Relocation.TYPE] = ...
        LARCH_GOT_HI20: ClassVar[Relocation.TYPE] = ...
        LARCH_GOT_LO12: ClassVar[Relocation.TYPE] = ...
        LARCH_GOT_PC_HI20: ClassVar[Relocation.TYPE] = ...
        LARCH_GOT_PC_LO12: ClassVar[Relocation.TYPE] = ...
        LARCH_IRELATIVE: ClassVar[Relocation.TYPE] = ...
        LARCH_JUMP_SLOT: ClassVar[Relocation.TYPE] = ...
        LARCH_MARK_LA: ClassVar[Relocation.TYPE] = ...
        LARCH_MARK_PCREL: ClassVar[Relocation.TYPE] = ...
        LARCH_NONE: ClassVar[Relocation.TYPE] = ...
        LARCH_PCALA64_HI12: ClassVar[Relocation.TYPE] = ...
        LARCH_PCALA64_LO20: ClassVar[Relocation.TYPE] = ...
        LARCH_PCALA_HI20: ClassVar[Relocation.TYPE] = ...
        LARCH_PCALA_LO12: ClassVar[Relocation.TYPE] = ...
        LARCH_RELATIVE: ClassVar[Relocation.TYPE] = ...
        LARCH_RELAX: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_ADD: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_AND: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_ASSERT: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_IF_ELSE: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_NOT: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_POP_32_S_0_10_10_16_S2: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_POP_32_S_0_5_10_16_S2: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_POP_32_S_10_12: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_POP_32_S_10_16: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_POP_32_S_10_16_S2: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_POP_32_S_10_5: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_POP_32_S_5_20: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_POP_32_U: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_POP_32_U_10_12: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_PUSH_ABSOLUTE: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_PUSH_DUP: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_PUSH_GPREL: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_PUSH_PCREL: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_PUSH_PLT_PCREL: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_PUSH_TLS_GD: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_PUSH_TLS_GOT: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_PUSH_TLS_TPREL: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_SL: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_SR: ClassVar[Relocation.TYPE] = ...
        LARCH_SOP_SUB: ClassVar[Relocation.TYPE] = ...
        LARCH_SUB16: ClassVar[Relocation.TYPE] = ...
        LARCH_SUB24: ClassVar[Relocation.TYPE] = ...
        LARCH_SUB32: ClassVar[Relocation.TYPE] = ...
        LARCH_SUB64: ClassVar[Relocation.TYPE] = ...
        LARCH_SUB8: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_DTPMOD32: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_DTPMOD64: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_DTPREL32: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_DTPREL64: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_GD_HI20: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_GD_PC_HI20: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_IE64_HI12: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_IE64_LO20: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_IE64_PC_HI12: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_IE64_PC_LO20: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_IE_HI20: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_IE_LO12: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_IE_PC_HI20: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_IE_PC_LO12: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_LD_HI20: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_LD_PC_HI20: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_LE64_HI12: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_LE64_LO20: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_LE_HI20: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_LE_LO12: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_TPREL32: ClassVar[Relocation.TYPE] = ...
        LARCH_TLS_TPREL64: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_26_S1: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_CALL16: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_CALL_HI16: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_CALL_LO16: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_GOT16: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_GOT_DISP: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_GOT_HI16: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_GOT_LO16: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_GOT_OFST: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_GOT_PAGE: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_GPREL16: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_GPREL7_S2: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_HI0_LO16: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_HI16: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_HIGHER: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_HIGHEST: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_JALR: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_LITERAL: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_LO16: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_PC10_S1: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_PC16_S1: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_PC18_S3: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_PC19_S2: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_PC21_S2: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_PC23_S2: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_PC26_S2: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_PC7_S1: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_SCN_DISP: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_SUB: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_TLS_DTPREL_HI16: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_TLS_DTPREL_LO16: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_TLS_GD: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_TLS_GOTTPREL: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_TLS_LDM: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_TLS_TPREL_HI16: ClassVar[Relocation.TYPE] = ...
        MICROMIPS_TLS_TPREL_LO16: ClassVar[Relocation.TYPE] = ...
        MIPS16_26: ClassVar[Relocation.TYPE] = ...
        MIPS16_CALL16: ClassVar[Relocation.TYPE] = ...
        MIPS16_GOT16: ClassVar[Relocation.TYPE] = ...
        MIPS16_GPREL: ClassVar[Relocation.TYPE] = ...
        MIPS16_HI16: ClassVar[Relocation.TYPE] = ...
        MIPS16_LO16: ClassVar[Relocation.TYPE] = ...
        MIPS16_TLS_DTPREL_HI16: ClassVar[Relocation.TYPE] = ...
        MIPS16_TLS_DTPREL_LO16: ClassVar[Relocation.TYPE] = ...
        MIPS16_TLS_GD: ClassVar[Relocation.TYPE] = ...
        MIPS16_TLS_GOTTPREL: ClassVar[Relocation.TYPE] = ...
        MIPS16_TLS_LDM: ClassVar[Relocation.TYPE] = ...
        MIPS16_TLS_TPREL_HI16: ClassVar[Relocation.TYPE] = ...
        MIPS16_TLS_TPREL_LO16: ClassVar[Relocation.TYPE] = ...
        MIPS_16: ClassVar[Relocation.TYPE] = ...
        MIPS_26: ClassVar[Relocation.TYPE] = ...
        MIPS_32: ClassVar[Relocation.TYPE] = ...
        MIPS_64: ClassVar[Relocation.TYPE] = ...
        MIPS_ADD_IMMEDIATE: ClassVar[Relocation.TYPE] = ...
        MIPS_CALL16: ClassVar[Relocation.TYPE] = ...
        MIPS_CALL_HI16: ClassVar[Relocation.TYPE] = ...
        MIPS_CALL_LO16: ClassVar[Relocation.TYPE] = ...
        MIPS_COPY: ClassVar[Relocation.TYPE] = ...
        MIPS_DELETE: ClassVar[Relocation.TYPE] = ...
        MIPS_EH: ClassVar[Relocation.TYPE] = ...
        MIPS_GLOB_DAT: ClassVar[Relocation.TYPE] = ...
        MIPS_GOT16: ClassVar[Relocation.TYPE] = ...
        MIPS_GOT_DISP: ClassVar[Relocation.TYPE] = ...
        MIPS_GOT_HI16: ClassVar[Relocation.TYPE] = ...
        MIPS_GOT_LO16: ClassVar[Relocation.TYPE] = ...
        MIPS_GOT_OFST: ClassVar[Relocation.TYPE] = ...
        MIPS_GOT_PAGE: ClassVar[Relocation.TYPE] = ...
        MIPS_GPREL16: ClassVar[Relocation.TYPE] = ...
        MIPS_GPREL32: ClassVar[Relocation.TYPE] = ...
        MIPS_HI16: ClassVar[Relocation.TYPE] = ...
        MIPS_HIGHER: ClassVar[Relocation.TYPE] = ...
        MIPS_HIGHEST: ClassVar[Relocation.TYPE] = ...
        MIPS_INSERT_A: ClassVar[Relocation.TYPE] = ...
        MIPS_INSERT_B: ClassVar[Relocation.TYPE] = ...
        MIPS_JALR: ClassVar[Relocation.TYPE] = ...
        MIPS_JUMP_SLOT: ClassVar[Relocation.TYPE] = ...
        MIPS_LITERAL: ClassVar[Relocation.TYPE] = ...
        MIPS_LO16: ClassVar[Relocation.TYPE] = ...
        MIPS_NONE: ClassVar[Relocation.TYPE] = ...
        MIPS_NUM: ClassVar[Relocation.TYPE] = ...
        MIPS_PC16: ClassVar[Relocation.TYPE] = ...
        MIPS_PC18_S3: ClassVar[Relocation.TYPE] = ...
        MIPS_PC19_S2: ClassVar[Relocation.TYPE] = ...
        MIPS_PC21_S2: ClassVar[Relocation.TYPE] = ...
        MIPS_PC26_S2: ClassVar[Relocation.TYPE] = ...
        MIPS_PC32: ClassVar[Relocation.TYPE] = ...
        MIPS_PCHI16: ClassVar[Relocation.TYPE] = ...
        MIPS_PCLO16: ClassVar[Relocation.TYPE] = ...
        MIPS_PJUMP: ClassVar[Relocation.TYPE] = ...
        MIPS_REL16: ClassVar[Relocation.TYPE] = ...
        MIPS_REL32: ClassVar[Relocation.TYPE] = ...
        MIPS_RELGOT: ClassVar[Relocation.TYPE] = ...
        MIPS_SCN_DISP: ClassVar[Relocation.TYPE] = ...
        MIPS_SHIFT5: ClassVar[Relocation.TYPE] = ...
        MIPS_SHIFT6: ClassVar[Relocation.TYPE] = ...
        MIPS_SUB: ClassVar[Relocation.TYPE] = ...
        MIPS_TLS_DTPMOD32: ClassVar[Relocation.TYPE] = ...
        MIPS_TLS_DTPMOD64: ClassVar[Relocation.TYPE] = ...
        MIPS_TLS_DTPREL32: ClassVar[Relocation.TYPE] = ...
        MIPS_TLS_DTPREL64: ClassVar[Relocation.TYPE] = ...
        MIPS_TLS_DTPREL_HI16: ClassVar[Relocation.TYPE] = ...
        MIPS_TLS_DTPREL_LO16: ClassVar[Relocation.TYPE] = ...
        MIPS_TLS_GD: ClassVar[Relocation.TYPE] = ...
        MIPS_TLS_GOTTPREL: ClassVar[Relocation.TYPE] = ...
        MIPS_TLS_LDM: ClassVar[Relocation.TYPE] = ...
        MIPS_TLS_TPREL32: ClassVar[Relocation.TYPE] = ...
        MIPS_TLS_TPREL64: ClassVar[Relocation.TYPE] = ...
        MIPS_TLS_TPREL_HI16: ClassVar[Relocation.TYPE] = ...
        MIPS_TLS_TPREL_LO16: ClassVar[Relocation.TYPE] = ...
        MIPS_UNUSED1: ClassVar[Relocation.TYPE] = ...
        MIPS_UNUSED2: ClassVar[Relocation.TYPE] = ...
        MIPS_UNUSED3: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR14: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR14_BRNTAKEN: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR14_BRTAKEN: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR16: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR16_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR16_HA: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR16_HI: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR16_HIGHER: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR16_HIGHERA: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR16_HIGHEST: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR16_HIGHESTA: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR16_LO: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR16_LO_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR24: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR32: ClassVar[Relocation.TYPE] = ...
        PPC64_ADDR64: ClassVar[Relocation.TYPE] = ...
        PPC64_DTPMOD64: ClassVar[Relocation.TYPE] = ...
        PPC64_DTPREL16: ClassVar[Relocation.TYPE] = ...
        PPC64_DTPREL16_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_DTPREL16_HA: ClassVar[Relocation.TYPE] = ...
        PPC64_DTPREL16_HI: ClassVar[Relocation.TYPE] = ...
        PPC64_DTPREL16_HIGHER: ClassVar[Relocation.TYPE] = ...
        PPC64_DTPREL16_HIGHERA: ClassVar[Relocation.TYPE] = ...
        PPC64_DTPREL16_HIGHEST: ClassVar[Relocation.TYPE] = ...
        PPC64_DTPREL16_HIGHESTA: ClassVar[Relocation.TYPE] = ...
        PPC64_DTPREL16_LO: ClassVar[Relocation.TYPE] = ...
        PPC64_DTPREL16_LO_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_DTPREL64: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT16: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT16_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT16_HA: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT16_HI: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT16_LO: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT16_LO_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_DTPREL16_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_DTPREL16_HA: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_DTPREL16_HI: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_DTPREL16_LO_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_TLSGD16: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_TLSGD16_HA: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_TLSGD16_HI: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_TLSGD16_LO: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_TLSLD16: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_TLSLD16_HA: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_TLSLD16_HI: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_TLSLD16_LO: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_TPREL16_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_TPREL16_HA: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_TPREL16_HI: ClassVar[Relocation.TYPE] = ...
        PPC64_GOT_TPREL16_LO_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_JMP_SLOT: ClassVar[Relocation.TYPE] = ...
        PPC64_NONE: ClassVar[Relocation.TYPE] = ...
        PPC64_REL14: ClassVar[Relocation.TYPE] = ...
        PPC64_REL14_BRNTAKEN: ClassVar[Relocation.TYPE] = ...
        PPC64_REL14_BRTAKEN: ClassVar[Relocation.TYPE] = ...
        PPC64_REL16: ClassVar[Relocation.TYPE] = ...
        PPC64_REL16_HA: ClassVar[Relocation.TYPE] = ...
        PPC64_REL16_HI: ClassVar[Relocation.TYPE] = ...
        PPC64_REL16_LO: ClassVar[Relocation.TYPE] = ...
        PPC64_REL24: ClassVar[Relocation.TYPE] = ...
        PPC64_REL32: ClassVar[Relocation.TYPE] = ...
        PPC64_REL64: ClassVar[Relocation.TYPE] = ...
        PPC64_RELATIVE: ClassVar[Relocation.TYPE] = ...
        PPC64_TLS: ClassVar[Relocation.TYPE] = ...
        PPC64_TLSGD: ClassVar[Relocation.TYPE] = ...
        PPC64_TLSLD: ClassVar[Relocation.TYPE] = ...
        PPC64_TOC: ClassVar[Relocation.TYPE] = ...
        PPC64_TOC16: ClassVar[Relocation.TYPE] = ...
        PPC64_TOC16_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_TOC16_HA: ClassVar[Relocation.TYPE] = ...
        PPC64_TOC16_HI: ClassVar[Relocation.TYPE] = ...
        PPC64_TOC16_LO: ClassVar[Relocation.TYPE] = ...
        PPC64_TOC16_LO_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_TPREL16: ClassVar[Relocation.TYPE] = ...
        PPC64_TPREL16_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_TPREL16_HA: ClassVar[Relocation.TYPE] = ...
        PPC64_TPREL16_HI: ClassVar[Relocation.TYPE] = ...
        PPC64_TPREL16_HIGHER: ClassVar[Relocation.TYPE] = ...
        PPC64_TPREL16_HIGHERA: ClassVar[Relocation.TYPE] = ...
        PPC64_TPREL16_HIGHEST: ClassVar[Relocation.TYPE] = ...
        PPC64_TPREL16_HIGHESTA: ClassVar[Relocation.TYPE] = ...
        PPC64_TPREL16_LO: ClassVar[Relocation.TYPE] = ...
        PPC64_TPREL16_LO_DS: ClassVar[Relocation.TYPE] = ...
        PPC64_TPREL64: ClassVar[Relocation.TYPE] = ...
        PPC_ADDR14: ClassVar[Relocation.TYPE] = ...
        PPC_ADDR14_BRNTAKEN: ClassVar[Relocation.TYPE] = ...
        PPC_ADDR14_BRTAKEN: ClassVar[Relocation.TYPE] = ...
        PPC_ADDR16: ClassVar[Relocation.TYPE] = ...
        PPC_ADDR16_HA: ClassVar[Relocation.TYPE] = ...
        PPC_ADDR16_HI: ClassVar[Relocation.TYPE] = ...
        PPC_ADDR16_LO: ClassVar[Relocation.TYPE] = ...
        PPC_ADDR24: ClassVar[Relocation.TYPE] = ...
        PPC_ADDR32: ClassVar[Relocation.TYPE] = ...
        PPC_DTPMOD32: ClassVar[Relocation.TYPE] = ...
        PPC_DTPREL16: ClassVar[Relocation.TYPE] = ...
        PPC_DTPREL16_HA: ClassVar[Relocation.TYPE] = ...
        PPC_DTPREL16_HI: ClassVar[Relocation.TYPE] = ...
        PPC_DTPREL16_LO: ClassVar[Relocation.TYPE] = ...
        PPC_DTPREL32: ClassVar[Relocation.TYPE] = ...
        PPC_GOT16: ClassVar[Relocation.TYPE] = ...
        PPC_GOT16_HA: ClassVar[Relocation.TYPE] = ...
        PPC_GOT16_HI: ClassVar[Relocation.TYPE] = ...
        PPC_GOT16_LO: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_DTPREL16: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_DTPREL16_HA: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_DTPREL16_HI: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_DTPREL16_LO: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_TLSGD16: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_TLSGD16_HA: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_TLSGD16_HI: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_TLSGD16_LO: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_TLSLD16: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_TLSLD16_HA: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_TLSLD16_HI: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_TLSLD16_LO: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_TPREL16: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_TPREL16_HA: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_TPREL16_HI: ClassVar[Relocation.TYPE] = ...
        PPC_GOT_TPREL16_LO: ClassVar[Relocation.TYPE] = ...
        PPC_JMP_SLOT: ClassVar[Relocation.TYPE] = ...
        PPC_LOCAL24PC: ClassVar[Relocation.TYPE] = ...
        PPC_NONE: ClassVar[Relocation.TYPE] = ...
        PPC_PLTREL24: ClassVar[Relocation.TYPE] = ...
        PPC_REL14: ClassVar[Relocation.TYPE] = ...
        PPC_REL14_BRNTAKEN: ClassVar[Relocation.TYPE] = ...
        PPC_REL14_BRTAKEN: ClassVar[Relocation.TYPE] = ...
        PPC_REL16: ClassVar[Relocation.TYPE] = ...
        PPC_REL16_HA: ClassVar[Relocation.TYPE] = ...
        PPC_REL16_HI: ClassVar[Relocation.TYPE] = ...
        PPC_REL16_LO: ClassVar[Relocation.TYPE] = ...
        PPC_REL24: ClassVar[Relocation.TYPE] = ...
        PPC_REL32: ClassVar[Relocation.TYPE] = ...
        PPC_RELATIVE: ClassVar[Relocation.TYPE] = ...
        PPC_TLS: ClassVar[Relocation.TYPE] = ...
        PPC_TLSGD: ClassVar[Relocation.TYPE] = ...
        PPC_TLSLD: ClassVar[Relocation.TYPE] = ...
        PPC_TPREL16: ClassVar[Relocation.TYPE] = ...
        PPC_TPREL16_HA: ClassVar[Relocation.TYPE] = ...
        PPC_TPREL16_HI: ClassVar[Relocation.TYPE] = ...
        PPC_TPREL16_LO: ClassVar[Relocation.TYPE] = ...
        PPC_TPREL32: ClassVar[Relocation.TYPE] = ...
        SPARC_10: ClassVar[Relocation.TYPE] = ...
        SPARC_11: ClassVar[Relocation.TYPE] = ...
        SPARC_13: ClassVar[Relocation.TYPE] = ...
        SPARC_16: ClassVar[Relocation.TYPE] = ...
        SPARC_22: ClassVar[Relocation.TYPE] = ...
        SPARC_32: ClassVar[Relocation.TYPE] = ...
        SPARC_5: ClassVar[Relocation.TYPE] = ...
        SPARC_6: ClassVar[Relocation.TYPE] = ...
        SPARC_64: ClassVar[Relocation.TYPE] = ...
        SPARC_7: ClassVar[Relocation.TYPE] = ...
        SPARC_8: ClassVar[Relocation.TYPE] = ...
        SPARC_COPY: ClassVar[Relocation.TYPE] = ...
        SPARC_DISP16: ClassVar[Relocation.TYPE] = ...
        SPARC_DISP32: ClassVar[Relocation.TYPE] = ...
        SPARC_DISP64: ClassVar[Relocation.TYPE] = ...
        SPARC_DISP8: ClassVar[Relocation.TYPE] = ...
        SPARC_GLOB_DAT: ClassVar[Relocation.TYPE] = ...
        SPARC_GOT10: ClassVar[Relocation.TYPE] = ...
        SPARC_GOT13: ClassVar[Relocation.TYPE] = ...
        SPARC_GOT22: ClassVar[Relocation.TYPE] = ...
        SPARC_GOTDATA_HIX22: ClassVar[Relocation.TYPE] = ...
        SPARC_GOTDATA_LOX10: ClassVar[Relocation.TYPE] = ...
        SPARC_GOTDATA_OP: ClassVar[Relocation.TYPE] = ...
        SPARC_GOTDATA_OP_HIX22: ClassVar[Relocation.TYPE] = ...
        SPARC_GOTDATA_OP_LOX10: ClassVar[Relocation.TYPE] = ...
        SPARC_H44: ClassVar[Relocation.TYPE] = ...
        SPARC_HH22: ClassVar[Relocation.TYPE] = ...
        SPARC_HI22: ClassVar[Relocation.TYPE] = ...
        SPARC_HIPLT22: ClassVar[Relocation.TYPE] = ...
        SPARC_HIX22: ClassVar[Relocation.TYPE] = ...
        SPARC_HM10: ClassVar[Relocation.TYPE] = ...
        SPARC_JMP_SLOT: ClassVar[Relocation.TYPE] = ...
        SPARC_L44: ClassVar[Relocation.TYPE] = ...
        SPARC_LM22: ClassVar[Relocation.TYPE] = ...
        SPARC_LO10: ClassVar[Relocation.TYPE] = ...
        SPARC_LOPLT10: ClassVar[Relocation.TYPE] = ...
        SPARC_LOX10: ClassVar[Relocation.TYPE] = ...
        SPARC_M44: ClassVar[Relocation.TYPE] = ...
        SPARC_NONE: ClassVar[Relocation.TYPE] = ...
        SPARC_OLO10: ClassVar[Relocation.TYPE] = ...
        SPARC_PC10: ClassVar[Relocation.TYPE] = ...
        SPARC_PC22: ClassVar[Relocation.TYPE] = ...
        SPARC_PCPLT10: ClassVar[Relocation.TYPE] = ...
        SPARC_PCPLT22: ClassVar[Relocation.TYPE] = ...
        SPARC_PCPLT32: ClassVar[Relocation.TYPE] = ...
        SPARC_PC_HH22: ClassVar[Relocation.TYPE] = ...
        SPARC_PC_HM10: ClassVar[Relocation.TYPE] = ...
        SPARC_PC_LM22: ClassVar[Relocation.TYPE] = ...
        SPARC_PLT32: ClassVar[Relocation.TYPE] = ...
        SPARC_PLT64: ClassVar[Relocation.TYPE] = ...
        SPARC_REGISTER: ClassVar[Relocation.TYPE] = ...
        SPARC_RELATIVE: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_DTPMOD32: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_DTPMOD64: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_DTPOFF32: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_DTPOFF64: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_GD_ADD: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_GD_CALL: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_GD_HI22: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_GD_LO10: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_IE_ADD: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_IE_HI22: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_IE_LD: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_IE_LDX: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_IE_LO10: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_LDM_ADD: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_LDM_CALL: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_LDM_HI22: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_LDM_LO10: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_LDO_ADD: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_LDO_HIX22: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_LDO_LOX10: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_LE_HIX22: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_LE_LOX10: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_TPOFF32: ClassVar[Relocation.TYPE] = ...
        SPARC_TLS_TPOFF64: ClassVar[Relocation.TYPE] = ...
        SPARC_UA16: ClassVar[Relocation.TYPE] = ...
        SPARC_UA32: ClassVar[Relocation.TYPE] = ...
        SPARC_UA64: ClassVar[Relocation.TYPE] = ...
        SPARC_WDISP16: ClassVar[Relocation.TYPE] = ...
        SPARC_WDISP19: ClassVar[Relocation.TYPE] = ...
        SPARC_WDISP22: ClassVar[Relocation.TYPE] = ...
        SPARC_WDISP30: ClassVar[Relocation.TYPE] = ...
        SPARC_WPLT30: ClassVar[Relocation.TYPE] = ...
        SYSZ_12: ClassVar[Relocation.TYPE] = ...
        SYSZ_16: ClassVar[Relocation.TYPE] = ...
        SYSZ_20: ClassVar[Relocation.TYPE] = ...
        SYSZ_32: ClassVar[Relocation.TYPE] = ...
        SYSZ_64: ClassVar[Relocation.TYPE] = ...
        SYSZ_8: ClassVar[Relocation.TYPE] = ...
        SYSZ_COPY: ClassVar[Relocation.TYPE] = ...
        SYSZ_GLOB_DAT: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOT12: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOT16: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOT20: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOT32: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOT64: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOTENT: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOTOFF: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOTOFF16: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOTOFF64: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOTPC: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOTPCDBL: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOTPLT12: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOTPLT16: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOTPLT20: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOTPLT32: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOTPLT64: ClassVar[Relocation.TYPE] = ...
        SYSZ_GOTPLTENT: ClassVar[Relocation.TYPE] = ...
        SYSZ_IRELATIVE: ClassVar[Relocation.TYPE] = ...
        SYSZ_JMP_SLOT: ClassVar[Relocation.TYPE] = ...
        SYSZ_NONE: ClassVar[Relocation.TYPE] = ...
        SYSZ_PC16: ClassVar[Relocation.TYPE] = ...
        SYSZ_PC16DBL: ClassVar[Relocation.TYPE] = ...
        SYSZ_PC32: ClassVar[Relocation.TYPE] = ...
        SYSZ_PC32DBL: ClassVar[Relocation.TYPE] = ...
        SYSZ_PC64: ClassVar[Relocation.TYPE] = ...
        SYSZ_PLT16DBL: ClassVar[Relocation.TYPE] = ...
        SYSZ_PLT32: ClassVar[Relocation.TYPE] = ...
        SYSZ_PLT32DBL: ClassVar[Relocation.TYPE] = ...
        SYSZ_PLT64: ClassVar[Relocation.TYPE] = ...
        SYSZ_PLTOFF16: ClassVar[Relocation.TYPE] = ...
        SYSZ_PLTOFF32: ClassVar[Relocation.TYPE] = ...
        SYSZ_PLTOFF64: ClassVar[Relocation.TYPE] = ...
        SYSZ_RELATIVE: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_DTPMOD: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_DTPOFF: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_GD32: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_GD64: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_GDCALL: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_GOTIE12: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_GOTIE20: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_GOTIE32: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_GOTIE64: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_IE32: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_IE64: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_IEENT: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_LDCALL: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_LDM32: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_LDM64: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_LDO32: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_LDO64: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_LE32: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_LE64: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_LOAD: ClassVar[Relocation.TYPE] = ...
        SYSZ_TLS_TPOFF: ClassVar[Relocation.TYPE] = ...
        X86_16: ClassVar[Relocation.TYPE] = ...
        X86_32: ClassVar[Relocation.TYPE] = ...
        X86_32PLT: ClassVar[Relocation.TYPE] = ...
        X86_64_16: ClassVar[Relocation.TYPE] = ...
        X86_64_32: ClassVar[Relocation.TYPE] = ...
        X86_64_32S: ClassVar[Relocation.TYPE] = ...
        X86_64_64: ClassVar[Relocation.TYPE] = ...
        X86_64_8: ClassVar[Relocation.TYPE] = ...
        X86_64_COPY: ClassVar[Relocation.TYPE] = ...
        X86_64_DTPMOD64: ClassVar[Relocation.TYPE] = ...
        X86_64_DTPOFF32: ClassVar[Relocation.TYPE] = ...
        X86_64_DTPOFF64: ClassVar[Relocation.TYPE] = ...
        X86_64_GLOB_DAT: ClassVar[Relocation.TYPE] = ...
        X86_64_GOT32: ClassVar[Relocation.TYPE] = ...
        X86_64_GOT64: ClassVar[Relocation.TYPE] = ...
        X86_64_GOTOFF64: ClassVar[Relocation.TYPE] = ...
        X86_64_GOTPC32: ClassVar[Relocation.TYPE] = ...
        X86_64_GOTPC32_TLSDESC: ClassVar[Relocation.TYPE] = ...
        X86_64_GOTPC64: ClassVar[Relocation.TYPE] = ...
        X86_64_GOTPCREL: ClassVar[Relocation.TYPE] = ...
        X86_64_GOTPCREL64: ClassVar[Relocation.TYPE] = ...
        X86_64_GOTPCRELX: ClassVar[Relocation.TYPE] = ...
        X86_64_GOTPLT64: ClassVar[Relocation.TYPE] = ...
        X86_64_GOTTPOFF: ClassVar[Relocation.TYPE] = ...
        X86_64_IRELATIVE: ClassVar[Relocation.TYPE] = ...
        X86_64_JUMP_SLOT: ClassVar[Relocation.TYPE] = ...
        X86_64_NONE: ClassVar[Relocation.TYPE] = ...
        X86_64_PC16: ClassVar[Relocation.TYPE] = ...
        X86_64_PC32: ClassVar[Relocation.TYPE] = ...
        X86_64_PC32_BND: ClassVar[Relocation.TYPE] = ...
        X86_64_PC64: ClassVar[Relocation.TYPE] = ...
        X86_64_PC8: ClassVar[Relocation.TYPE] = ...
        X86_64_PLT32: ClassVar[Relocation.TYPE] = ...
        X86_64_PLT32_BND: ClassVar[Relocation.TYPE] = ...
        X86_64_PLTOFF64: ClassVar[Relocation.TYPE] = ...
        X86_64_RELATIVE: ClassVar[Relocation.TYPE] = ...
        X86_64_RELATIVE64: ClassVar[Relocation.TYPE] = ...
        X86_64_REX_GOTPCRELX: ClassVar[Relocation.TYPE] = ...
        X86_64_SIZE32: ClassVar[Relocation.TYPE] = ...
        X86_64_SIZE64: ClassVar[Relocation.TYPE] = ...
        X86_64_TLSDESC: ClassVar[Relocation.TYPE] = ...
        X86_64_TLSDESC_CALL: ClassVar[Relocation.TYPE] = ...
        X86_64_TLSGD: ClassVar[Relocation.TYPE] = ...
        X86_64_TLSLD: ClassVar[Relocation.TYPE] = ...
        X86_64_TPOFF32: ClassVar[Relocation.TYPE] = ...
        X86_64_TPOFF64: ClassVar[Relocation.TYPE] = ...
        X86_8: ClassVar[Relocation.TYPE] = ...
        X86_COPY: ClassVar[Relocation.TYPE] = ...
        X86_GLOB_DAT: ClassVar[Relocation.TYPE] = ...
        X86_GOT32: ClassVar[Relocation.TYPE] = ...
        X86_GOTOFF: ClassVar[Relocation.TYPE] = ...
        X86_GOTPC: ClassVar[Relocation.TYPE] = ...
        X86_IRELATIVE: ClassVar[Relocation.TYPE] = ...
        X86_JUMP_SLOT: ClassVar[Relocation.TYPE] = ...
        X86_NONE: ClassVar[Relocation.TYPE] = ...
        X86_PC16: ClassVar[Relocation.TYPE] = ...
        X86_PC32: ClassVar[Relocation.TYPE] = ...
        X86_PC8: ClassVar[Relocation.TYPE] = ...
        X86_PLT32: ClassVar[Relocation.TYPE] = ...
        X86_RELATIVE: ClassVar[Relocation.TYPE] = ...
        X86_TLS_DESC: ClassVar[Relocation.TYPE] = ...
        X86_TLS_DESC_CALL: ClassVar[Relocation.TYPE] = ...
        X86_TLS_DTPMOD32: ClassVar[Relocation.TYPE] = ...
        X86_TLS_DTPOFF32: ClassVar[Relocation.TYPE] = ...
        X86_TLS_GD: ClassVar[Relocation.TYPE] = ...
        X86_TLS_GD_32: ClassVar[Relocation.TYPE] = ...
        X86_TLS_GD_CALL: ClassVar[Relocation.TYPE] = ...
        X86_TLS_GD_POP: ClassVar[Relocation.TYPE] = ...
        X86_TLS_GD_PUSH: ClassVar[Relocation.TYPE] = ...
        X86_TLS_GOTDESC: ClassVar[Relocation.TYPE] = ...
        X86_TLS_GOTIE: ClassVar[Relocation.TYPE] = ...
        X86_TLS_IE: ClassVar[Relocation.TYPE] = ...
        X86_TLS_IE_32: ClassVar[Relocation.TYPE] = ...
        X86_TLS_LDM: ClassVar[Relocation.TYPE] = ...
        X86_TLS_LDM_32: ClassVar[Relocation.TYPE] = ...
        X86_TLS_LDM_CALL: ClassVar[Relocation.TYPE] = ...
        X86_TLS_LDM_POP: ClassVar[Relocation.TYPE] = ...
        X86_TLS_LDM_PUSH: ClassVar[Relocation.TYPE] = ...
        X86_TLS_LDO_32: ClassVar[Relocation.TYPE] = ...
        X86_TLS_LE: ClassVar[Relocation.TYPE] = ...
        X86_TLS_LE_32: ClassVar[Relocation.TYPE] = ...
        X86_TLS_TPOFF: ClassVar[Relocation.TYPE] = ...
        X86_TLS_TPOFF32: ClassVar[Relocation.TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Relocation.TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    addend: int
    info: int
    purpose: lief.ELF.Relocation.PURPOSE
    symbol: lief.ELF.Symbol
    type: lief.ELF.Relocation.TYPE
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arch: lief.ELF.ARCH) -> None: ...
    @overload
    def __init__(self, address: int, type: lief.ELF.Relocation.TYPE, encoding: lief.ELF.Relocation.ENCODING) -> None: ...
    def r_info(self, clazz: lief.ELF.Header.CLASS) -> int: ...
    @property
    def encoding(self) -> lief.ELF.Relocation.ENCODING: ...
    @property
    def has_section(self) -> bool: ...
    @property
    def has_symbol(self) -> bool: ...
    @property
    def is_android_packed(self) -> bool: ...
    @property
    def is_rel(self) -> bool: ...
    @property
    def is_rela(self) -> bool: ...
    @property
    def is_relatively_encoded(self) -> bool: ...
    @property
    def section(self) -> lief.ELF.Section: ...
    @property
    def symbol_table(self) -> lief.ELF.Section: ...

class Section(lief.Section):
    class FLAGS:
        ALLOC: ClassVar[Section.FLAGS] = ...
        ARM_PURECODE: ClassVar[Section.FLAGS] = ...
        COMPRESSED: ClassVar[Section.FLAGS] = ...
        EXCLUDE: ClassVar[Section.FLAGS] = ...
        EXECINSTR: ClassVar[Section.FLAGS] = ...
        GNU_RETAIN: ClassVar[Section.FLAGS] = ...
        GROUP: ClassVar[Section.FLAGS] = ...
        HEX_GPREL: ClassVar[Section.FLAGS] = ...
        INFO_LINK: ClassVar[Section.FLAGS] = ...
        LINK_ORDER: ClassVar[Section.FLAGS] = ...
        MERGE: ClassVar[Section.FLAGS] = ...
        MIPS_ADDR: ClassVar[Section.FLAGS] = ...
        MIPS_GPREL: ClassVar[Section.FLAGS] = ...
        MIPS_LOCAL: ClassVar[Section.FLAGS] = ...
        MIPS_MERGE: ClassVar[Section.FLAGS] = ...
        MIPS_NAMES: ClassVar[Section.FLAGS] = ...
        MIPS_NODUPES: ClassVar[Section.FLAGS] = ...
        MIPS_NOSTRIP: ClassVar[Section.FLAGS] = ...
        MIPS_STRING: ClassVar[Section.FLAGS] = ...
        NONE: ClassVar[Section.FLAGS] = ...
        OS_NONCONFORMING: ClassVar[Section.FLAGS] = ...
        STRINGS: ClassVar[Section.FLAGS] = ...
        TLS: ClassVar[Section.FLAGS] = ...
        WRITE: ClassVar[Section.FLAGS] = ...
        X86_64_LARGE: ClassVar[Section.FLAGS] = ...
        XCORE_SHF_CP_SECTION: ClassVar[Section.FLAGS] = ...
        XCORE_SHF_DP_SECTION: ClassVar[Section.FLAGS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Section.FLAGS: ...
        def __abs__(self) -> Any: ...
        def __add__(self, other) -> Any: ...
        @overload
        def __and__(self, arg: int, /) -> int: ...
        @overload
        def __and__(self, arg: lief.ELF.Section.FLAGS, /) -> int: ...
        def __floordiv__(self, other) -> Any: ...
        def __ge__(self, arg: int, /) -> bool: ...
        def __gt__(self, arg: int, /) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> int: ...
        def __le__(self, arg: int, /) -> bool: ...
        def __lshift__(self, other) -> Any: ...
        def __lt__(self, arg: int, /) -> bool: ...
        def __mul__(self, other) -> Any: ...
        def __neg__(self) -> Any: ...
        @overload
        def __or__(self, arg: int, /) -> int: ...
        @overload
        def __or__(self, arg: lief.ELF.Section.FLAGS, /) -> lief.ELF.Section.FLAGS: ...
        def __radd__(self, other) -> Any: ...
        def __rand__(self, arg: int, /) -> int: ...
        def __rfloordiv__(self, other) -> Any: ...
        def __rlshift__(self, other) -> Any: ...
        def __rmul__(self, other) -> Any: ...
        def __ror__(self, arg: int, /) -> int: ...
        def __rrshift__(self, other) -> Any: ...
        def __rshift__(self, other) -> Any: ...
        def __rsub__(self, other) -> Any: ...
        def __rxor__(self, arg: int, /) -> int: ...
        def __sub__(self, other) -> Any: ...
        @overload
        def __xor__(self, arg: int, /) -> int: ...
        @overload
        def __xor__(self, arg: lief.ELF.Section.FLAGS, /) -> int: ...
        @property
        def value(self) -> int: ...

    class TYPE:
        ANDROID_REL: ClassVar[Section.TYPE] = ...
        ANDROID_RELA: ClassVar[Section.TYPE] = ...
        ANDROID_RELR: ClassVar[Section.TYPE] = ...
        ARM_ATTRIBUTES: ClassVar[Section.TYPE] = ...
        ARM_DEBUGOVERLAY: ClassVar[Section.TYPE] = ...
        ARM_EXIDX: ClassVar[Section.TYPE] = ...
        ARM_OVERLAYSECTION: ClassVar[Section.TYPE] = ...
        ARM_PREEMPTMAP: ClassVar[Section.TYPE] = ...
        DYNAMIC: ClassVar[Section.TYPE] = ...
        DYNSYM: ClassVar[Section.TYPE] = ...
        FINI_ARRAY: ClassVar[Section.TYPE] = ...
        GNU_ATTRIBUTES: ClassVar[Section.TYPE] = ...
        GNU_HASH: ClassVar[Section.TYPE] = ...
        GNU_VERDEF: ClassVar[Section.TYPE] = ...
        GNU_VERNEED: ClassVar[Section.TYPE] = ...
        GNU_VERSYM: ClassVar[Section.TYPE] = ...
        GROUP: ClassVar[Section.TYPE] = ...
        HASH: ClassVar[Section.TYPE] = ...
        HEX_ORDERED: ClassVar[Section.TYPE] = ...
        INIT_ARRAY: ClassVar[Section.TYPE] = ...
        LLVM_ADDRSIG: ClassVar[Section.TYPE] = ...
        MIPS_ABIFLAGS: ClassVar[Section.TYPE] = ...
        MIPS_OPTIONS: ClassVar[Section.TYPE] = ...
        MIPS_REGINFO: ClassVar[Section.TYPE] = ...
        NOBITS: ClassVar[Section.TYPE] = ...
        NOTE: ClassVar[Section.TYPE] = ...
        PREINIT_ARRAY: ClassVar[Section.TYPE] = ...
        PROGBITS: ClassVar[Section.TYPE] = ...
        REL: ClassVar[Section.TYPE] = ...
        RELA: ClassVar[Section.TYPE] = ...
        RELR: ClassVar[Section.TYPE] = ...
        SHLIB: ClassVar[Section.TYPE] = ...
        SHT_NULL: ClassVar[Section.TYPE] = ...
        STRTAB: ClassVar[Section.TYPE] = ...
        SYMTAB: ClassVar[Section.TYPE] = ...
        SYMTAB_SHNDX: ClassVar[Section.TYPE] = ...
        X86_64_UNWIND: ClassVar[Section.TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Section.TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class it_segments:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.Segment: ...
        def __iter__(self) -> lief.ELF.Section.it_segments: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Segment: ...
    alignment: int
    entry_size: int
    file_offset: int
    flags: int
    information: int
    link: int
    type: lief.ELF.Section.TYPE
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, name: str, type: lief.ELF.Section.TYPE = ...) -> None: ...
    def add(self, flag: lief.ELF.Section.FLAGS) -> None: ...
    def as_frame(self) -> lief.ELF.Section: ...
    def clear(self, value: int = ...) -> lief.ELF.Section: ...
    @overload
    def has(self, flag: lief.ELF.Section.FLAGS) -> bool: ...
    @overload
    def has(self, segment: lief.ELF.Segment) -> bool: ...
    def remove(self, flag: lief.ELF.Section.FLAGS) -> None: ...
    @overload
    def __contains__(self, arg: lief.ELF.Section.FLAGS, /) -> bool: ...
    @overload
    def __contains__(self, arg: lief.ELF.Segment, /) -> bool: ...
    def __iadd__(self, arg: lief.ELF.Section.FLAGS, /) -> lief.ELF.Section: ...
    def __isub__(self, arg: lief.ELF.Section.FLAGS, /) -> lief.ELF.Section: ...
    @property
    def flags_list(self) -> list[lief.ELF.Section.FLAGS]: ...
    @property
    def is_frame(self) -> bool: ...
    @property
    def original_size(self) -> int: ...
    @property
    def segments(self) -> lief.ELF.Section.it_segments: ...

class Segment(lief.Object):
    class FLAGS:
        NONE: ClassVar[Segment.FLAGS] = ...
        R: ClassVar[Segment.FLAGS] = ...
        W: ClassVar[Segment.FLAGS] = ...
        X: ClassVar[Segment.FLAGS] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Segment.FLAGS: ...
        def __abs__(self) -> Any: ...
        def __add__(self, other) -> Any: ...
        @overload
        def __and__(self, arg: int, /) -> int: ...
        @overload
        def __and__(self, arg: lief.ELF.Segment.FLAGS, /) -> int: ...
        def __floordiv__(self, other) -> Any: ...
        def __ge__(self, arg: int, /) -> bool: ...
        def __gt__(self, arg: int, /) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __invert__(self) -> int: ...
        def __le__(self, arg: int, /) -> bool: ...
        def __lshift__(self, other) -> Any: ...
        def __lt__(self, arg: int, /) -> bool: ...
        def __mul__(self, other) -> Any: ...
        def __neg__(self) -> Any: ...
        @overload
        def __or__(self, arg: int, /) -> int: ...
        @overload
        def __or__(self, arg: lief.ELF.Segment.FLAGS, /) -> lief.ELF.Segment.FLAGS: ...
        def __radd__(self, other) -> Any: ...
        def __rand__(self, arg: int, /) -> int: ...
        def __rfloordiv__(self, other) -> Any: ...
        def __rlshift__(self, other) -> Any: ...
        def __rmul__(self, other) -> Any: ...
        def __ror__(self, arg: int, /) -> int: ...
        def __rrshift__(self, other) -> Any: ...
        def __rshift__(self, other) -> Any: ...
        def __rsub__(self, other) -> Any: ...
        def __rxor__(self, arg: int, /) -> int: ...
        def __sub__(self, other) -> Any: ...
        @overload
        def __xor__(self, arg: int, /) -> int: ...
        @overload
        def __xor__(self, arg: lief.ELF.Segment.FLAGS, /) -> int: ...
        @property
        def value(self) -> int: ...

    class TYPE:
        AARCH64_MEMTAG_MTE: ClassVar[Segment.TYPE] = ...
        ARM_ARCHEXT: ClassVar[Segment.TYPE] = ...
        ARM_EXIDX: ClassVar[Segment.TYPE] = ...
        DYNAMIC: ClassVar[Segment.TYPE] = ...
        GNU_EH_FRAME: ClassVar[Segment.TYPE] = ...
        GNU_PROPERTY: ClassVar[Segment.TYPE] = ...
        GNU_RELRO: ClassVar[Segment.TYPE] = ...
        GNU_STACK: ClassVar[Segment.TYPE] = ...
        INTERP: ClassVar[Segment.TYPE] = ...
        LOAD: ClassVar[Segment.TYPE] = ...
        MIPS_ABIFLAGS: ClassVar[Segment.TYPE] = ...
        MIPS_OPTIONS: ClassVar[Segment.TYPE] = ...
        MIPS_REGINFO: ClassVar[Segment.TYPE] = ...
        MIPS_RTPROC: ClassVar[Segment.TYPE] = ...
        NOTE: ClassVar[Segment.TYPE] = ...
        PHDR: ClassVar[Segment.TYPE] = ...
        PT_NULL: ClassVar[Segment.TYPE] = ...
        RISCV_ATTRIBUTES: ClassVar[Segment.TYPE] = ...
        SHLIB: ClassVar[Segment.TYPE] = ...
        TLS: ClassVar[Segment.TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Segment.TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class it_sections:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.Section: ...
        def __iter__(self) -> lief.ELF.Segment.it_sections: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.Section: ...
    alignment: int
    content: memoryview
    file_offset: int
    flags: lief.ELF.Segment.FLAGS
    physical_address: int
    physical_size: int
    type: lief.ELF.Segment.TYPE
    virtual_address: int
    virtual_size: int
    def __init__(self) -> None: ...
    def add(self, flag: lief.ELF.Segment.FLAGS) -> None: ...
    @staticmethod
    def from_raw(arg: bytes, /) -> Union[lief.ELF.Segment,lief.lief_errors]: ...
    @overload
    def has(self, flag: lief.ELF.Segment.FLAGS) -> bool: ...
    @overload
    def has(self, section: lief.ELF.Section) -> bool: ...
    @overload
    def has(self, section_name: str) -> bool: ...
    def remove(self, flag: lief.ELF.Segment.FLAGS) -> None: ...
    @overload
    def __contains__(self, arg: lief.ELF.Segment.FLAGS, /) -> bool: ...
    @overload
    def __contains__(self, arg: lief.ELF.Section, /) -> bool: ...
    @overload
    def __contains__(self, arg: str, /) -> bool: ...
    def __iadd__(self, arg: lief.ELF.Segment.FLAGS, /) -> lief.ELF.Segment: ...
    def __isub__(self, arg: lief.ELF.Segment.FLAGS, /) -> lief.ELF.Segment: ...
    @property
    def sections(self) -> lief.ELF.Segment.it_sections: ...

class StackSize(NoteGnuProperty.Property):
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def stack_size(self) -> int: ...

class Symbol(lief.Symbol):
    class BINDING:
        GLOBAL: ClassVar[Symbol.BINDING] = ...
        GNU_UNIQUE: ClassVar[Symbol.BINDING] = ...
        LOCAL: ClassVar[Symbol.BINDING] = ...
        WEAK: ClassVar[Symbol.BINDING] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Symbol.BINDING: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class TYPE:
        COMMON: ClassVar[Symbol.TYPE] = ...
        FILE: ClassVar[Symbol.TYPE] = ...
        FUNC: ClassVar[Symbol.TYPE] = ...
        GNU_IFUNC: ClassVar[Symbol.TYPE] = ...
        NOTYPE: ClassVar[Symbol.TYPE] = ...
        OBJECT: ClassVar[Symbol.TYPE] = ...
        SECTION: ClassVar[Symbol.TYPE] = ...
        TLS: ClassVar[Symbol.TYPE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Symbol.TYPE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class VISIBILITY:
        DEFAULT: ClassVar[Symbol.VISIBILITY] = ...
        HIDDEN: ClassVar[Symbol.VISIBILITY] = ...
        INTERNAL: ClassVar[Symbol.VISIBILITY] = ...
        PROTECTED: ClassVar[Symbol.VISIBILITY] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.Symbol.VISIBILITY: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    binding: lief.ELF.Symbol.BINDING
    exported: bool
    imported: bool
    information: int
    other: int
    shndx: int
    size: int
    type: lief.ELF.Symbol.TYPE
    value: int
    visibility: lief.ELF.Symbol.VISIBILITY
    def __init__(self) -> None: ...
    @property
    def demangled_name(self) -> str: ...
    @property
    def has_version(self) -> bool: ...
    @property
    def is_function(self) -> bool: ...
    @property
    def is_static(self) -> bool: ...
    @property
    def is_variable(self) -> bool: ...
    @property
    def section(self) -> lief.ELF.Section: ...
    @property
    def symbol_version(self) -> lief.ELF.SymbolVersion: ...

class SymbolVersion(lief.Object):
    symbol_version_auxiliary: lief.ELF.SymbolVersionAux
    value: int
    @overload
    def __init__(self) -> None: ...
    @overload
    def __init__(self, arg: int, /) -> None: ...
    @property
    def global_(self) -> lief.ELF.SymbolVersion: ...
    @property
    def has_auxiliary_version(self) -> bool: ...
    @property
    def local(self) -> lief.ELF.SymbolVersion: ...

class SymbolVersionAux(lief.Object):
    name: Union[str,bytes]
    def __init__(self, *args, **kwargs) -> None: ...

class SymbolVersionAuxRequirement(SymbolVersionAux):
    flags: int
    hash: int
    other: int
    def __init__(self) -> None: ...

class SymbolVersionDefinition(lief.Object):
    class it_version_aux:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.SymbolVersionAux: ...
        def __iter__(self) -> lief.ELF.SymbolVersionDefinition.it_version_aux: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.SymbolVersionAux: ...
    flags: int
    hash: int
    version: int
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def auxiliary_symbols(self) -> lief.ELF.SymbolVersionDefinition.it_version_aux: ...
    @property
    def ndx(self) -> int: ...

class SymbolVersionRequirement(lief.Object):
    class it_aux_requirement:
        def __init__(self, *args, **kwargs) -> None: ...
        def __getitem__(self, arg: int, /) -> lief.ELF.SymbolVersionAuxRequirement: ...
        def __iter__(self) -> lief.ELF.SymbolVersionRequirement.it_aux_requirement: ...
        def __len__(self) -> int: ...
        def __next__(self) -> lief.ELF.SymbolVersionAuxRequirement: ...
    name: str
    version: int
    def __init__(self, *args, **kwargs) -> None: ...
    def add_auxiliary_requirement(self, arg: lief.ELF.SymbolVersionAuxRequirement, /) -> lief.ELF.SymbolVersionAuxRequirement: ...
    def get_auxiliary_symbols(self) -> lief.ELF.SymbolVersionRequirement.it_aux_requirement: ...

class SysvHash(lief.Object):
    nchain: int
    def __init__(self) -> None: ...
    @property
    def buckets(self) -> list[int]: ...
    @property
    def chains(self) -> list[int]: ...
    @property
    def nbucket(self) -> int: ...

class X86Features(NoteGnuProperty.Property):
    class FEATURE:
        FXSR: ClassVar[X86Features.FEATURE] = ...
        IBT: ClassVar[X86Features.FEATURE] = ...
        LAM_U48: ClassVar[X86Features.FEATURE] = ...
        LAM_U57: ClassVar[X86Features.FEATURE] = ...
        MASK: ClassVar[X86Features.FEATURE] = ...
        MMX: ClassVar[X86Features.FEATURE] = ...
        SHSTK: ClassVar[X86Features.FEATURE] = ...
        TMM: ClassVar[X86Features.FEATURE] = ...
        UNKNOWN: ClassVar[X86Features.FEATURE] = ...
        X86: ClassVar[X86Features.FEATURE] = ...
        X87: ClassVar[X86Features.FEATURE] = ...
        XMM: ClassVar[X86Features.FEATURE] = ...
        XSAVE: ClassVar[X86Features.FEATURE] = ...
        XSAVEC: ClassVar[X86Features.FEATURE] = ...
        XSAVEOPT: ClassVar[X86Features.FEATURE] = ...
        YMM: ClassVar[X86Features.FEATURE] = ...
        ZMM: ClassVar[X86Features.FEATURE] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.X86Features.FEATURE: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class FLAG:
        NEEDED: ClassVar[X86Features.FLAG] = ...
        NONE: ClassVar[X86Features.FLAG] = ...
        USED: ClassVar[X86Features.FLAG] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.X86Features.FLAG: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def features(self) -> list[tuple[lief.ELF.X86Features.FLAG,lief.ELF.X86Features.FEATURE]]: ...

class X86ISA(NoteGnuProperty.Property):
    class FLAG:
        NEEDED: ClassVar[X86ISA.FLAG] = ...
        NONE: ClassVar[X86ISA.FLAG] = ...
        USED: ClassVar[X86ISA.FLAG] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.X86ISA.FLAG: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...

    class ISA:
        AVX: ClassVar[X86ISA.ISA] = ...
        AVX2: ClassVar[X86ISA.ISA] = ...
        AVX512BW: ClassVar[X86ISA.ISA] = ...
        AVX512CD: ClassVar[X86ISA.ISA] = ...
        AVX512DQ: ClassVar[X86ISA.ISA] = ...
        AVX512ER: ClassVar[X86ISA.ISA] = ...
        AVX512F: ClassVar[X86ISA.ISA] = ...
        AVX512PF: ClassVar[X86ISA.ISA] = ...
        AVX512VL: ClassVar[X86ISA.ISA] = ...
        AVX512_4FMAPS: ClassVar[X86ISA.ISA] = ...
        AVX512_4VNNIW: ClassVar[X86ISA.ISA] = ...
        AVX512_BF16: ClassVar[X86ISA.ISA] = ...
        AVX512_BITALG: ClassVar[X86ISA.ISA] = ...
        AVX512_IFMA: ClassVar[X86ISA.ISA] = ...
        AVX512_VBMI: ClassVar[X86ISA.ISA] = ...
        AVX512_VBMI2: ClassVar[X86ISA.ISA] = ...
        AVX512_VNNI: ClassVar[X86ISA.ISA] = ...
        BASELINE: ClassVar[X86ISA.ISA] = ...
        CMOV: ClassVar[X86ISA.ISA] = ...
        FMA: ClassVar[X86ISA.ISA] = ...
        I486: ClassVar[X86ISA.ISA] = ...
        I586: ClassVar[X86ISA.ISA] = ...
        I686: ClassVar[X86ISA.ISA] = ...
        SSE: ClassVar[X86ISA.ISA] = ...
        SSE2: ClassVar[X86ISA.ISA] = ...
        SSE3: ClassVar[X86ISA.ISA] = ...
        SSE4_1: ClassVar[X86ISA.ISA] = ...
        SSE4_2: ClassVar[X86ISA.ISA] = ...
        SSSE3: ClassVar[X86ISA.ISA] = ...
        UNKNOWN: ClassVar[X86ISA.ISA] = ...
        V2: ClassVar[X86ISA.ISA] = ...
        V3: ClassVar[X86ISA.ISA] = ...
        V4: ClassVar[X86ISA.ISA] = ...
        __name__: str
        def __init__(self, *args, **kwargs) -> None: ...
        @staticmethod
        def from_value(arg: int, /) -> lief.ELF.X86ISA.ISA: ...
        def __ge__(self, other) -> bool: ...
        def __gt__(self, other) -> bool: ...
        def __hash__(self) -> int: ...
        def __index__(self) -> Any: ...
        def __int__(self) -> int: ...
        def __le__(self, other) -> bool: ...
        def __lt__(self, other) -> bool: ...
        @property
        def value(self) -> int: ...
    def __init__(self, *args, **kwargs) -> None: ...
    @property
    def values(self) -> list[tuple[lief.ELF.X86ISA.FLAG,lief.ELF.X86ISA.ISA]]: ...

@overload
def parse(filename: str, config: lief.ELF.ParserConfig = ...) -> Optional[lief.ELF.Binary]: ...
@overload
def parse(raw: list[int], config: lief.ELF.ParserConfig = ...) -> Optional[lief.ELF.Binary]: ...
@overload
def parse(obj: Union[io.IOBase|os.PathLike], config: lief.ELF.ParserConfig = ...) -> Optional[lief.ELF.Binary]: ...
