/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxmlpatterns_python.h"

// main header
#include "qxmlquery_wrapper.h"

// inner classes

// Extra includes
#include <QtXmlPatterns/qabstractmessagehandler.h>
#include <QtXmlPatterns/qabstracturiresolver.h>
#include <QtXmlPatterns/qabstractxmlnodemodel.h>
#include <QtXmlPatterns/qabstractxmlreceiver.h>
#include <QtXmlPatterns/qxmlname.h>
#include <QtXmlPatterns/qxmlnamepool.h>
#include <QtXmlPatterns/qxmlquery.h>
#include <QtXmlPatterns/qxmlresultitems.h>
#include <qiodevice.h>
#include <qurl.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QXmlQuery_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QXmlQuery >()))
        return -1;

    ::QXmlQuery *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QXmlQuery_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QXmlQuery", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QXmlQuery::QXmlQuery()
    // 1: QXmlQuery::QXmlQuery(QXmlQuery::QueryLanguage,QXmlNamePool)
    // 2: QXmlQuery::QXmlQuery(QXmlNamePool)
    // 3: QXmlQuery::QXmlQuery(QXmlQuery)
    if (numArgs == 0) {
        overloadId = 0; // QXmlQuery()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAMEPOOL_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QXmlQuery(QXmlNamePool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QXmlQuery(QXmlQuery::QueryLanguage,QXmlNamePool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAMEPOOL_IDX]), (pyArgs[1])))) {
            overloadId = 1; // QXmlQuery(QXmlQuery::QueryLanguage,QXmlNamePool)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX]), (pyArgs[0])))) {
        overloadId = 3; // QXmlQuery(QXmlQuery)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlQuery_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QXmlQuery()
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QXmlQuery_Init_TypeError;
            }

            if (!PyErr_Occurred()) {
                // QXmlQuery()
                cptr = new ::QXmlQuery();
            }
            break;
        }
        case 1: // QXmlQuery(QXmlQuery::QueryLanguage queryLanguage, const QXmlNamePool & np)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_np = Shiboken::String::createStaticString("np");
                if (PyDict_Contains(kwds, key_np)) {
                    value = PyDict_GetItem(kwds, key_np);
                    if (value && pyArgs[1]) {
                        errInfo = key_np;
                        Py_INCREF(errInfo);
                        goto Sbk_QXmlQuery_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAMEPOOL_IDX]), (pyArgs[1]))))
                            goto Sbk_QXmlQuery_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_np);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QXmlQuery_Init_TypeError;
                }
            }
            ::QXmlQuery::QueryLanguage cppArg0 = static_cast< ::QXmlQuery::QueryLanguage>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return -1;
            ::QXmlNamePool cppArg1_local = QXmlNamePool();
            ::QXmlNamePool *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAMEPOOL_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // QXmlQuery(QXmlQuery::QueryLanguage,QXmlNamePool)
                cptr = new ::QXmlQuery(cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // QXmlQuery(const QXmlNamePool & np)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QXmlQuery_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QXmlNamePool cppArg0_local;
            ::QXmlNamePool *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAMEPOOL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QXmlQuery(QXmlNamePool)
                cptr = new ::QXmlQuery(*cppArg0);
            }
            break;
        }
        case 3: // QXmlQuery(const QXmlQuery & other)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QXmlQuery_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QXmlQuery cppArg0_local;
            ::QXmlQuery *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QXmlQuery(QXmlQuery)
                cptr = new ::QXmlQuery(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QXmlQuery >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QXmlQuery_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QXmlQuery_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QXmlQueryFunc_bindVariable(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.bindVariable";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "bindVariable", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlQuery::bindVariable(QString,QIODevice*)
    // 1: QXmlQuery::bindVariable(QString,QXmlItem)
    // 2: QXmlQuery::bindVariable(QString,QXmlQuery)
    // 3: QXmlQuery::bindVariable(QXmlName,QIODevice*)
    // 4: QXmlQuery::bindVariable(QXmlName,QXmlItem)
    // 5: QXmlQuery::bindVariable(QXmlName,QXmlQuery)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX]), (pyArgs[1])))) {
            overloadId = 5; // bindVariable(QXmlName,QXmlQuery)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX]), (pyArgs[1])))) {
            overloadId = 4; // bindVariable(QXmlName,QXmlItem)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[1])))) {
            overloadId = 3; // bindVariable(QXmlName,QIODevice*)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX]), (pyArgs[1])))) {
            overloadId = 2; // bindVariable(QString,QXmlQuery)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX]), (pyArgs[1])))) {
            overloadId = 1; // bindVariable(QString,QXmlItem)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[1])))) {
            overloadId = 0; // bindVariable(QString,QIODevice*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlQueryFunc_bindVariable_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // bindVariable(const QString & localName, QIODevice * arg__2)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QIODevice *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bindVariable(QString,QIODevice*)
                cppSelf->bindVariable(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // bindVariable(const QString & localName, const QXmlItem & value)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QXmlItem cppArg1_local;
            ::QXmlItem *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // bindVariable(QString,QXmlItem)
                cppSelf->bindVariable(cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // bindVariable(const QString & localName, const QXmlQuery & query)
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QXmlQuery cppArg1_local;
            ::QXmlQuery *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // bindVariable(QString,QXmlQuery)
                cppSelf->bindVariable(cppArg0, *cppArg1);
            }
            break;
        }
        case 3: // bindVariable(const QXmlName & name, QIODevice * arg__2)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QXmlName cppArg0_local;
            ::QXmlName *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QIODevice *cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // bindVariable(QXmlName,QIODevice*)
                cppSelf->bindVariable(*cppArg0, cppArg1);
            }
            break;
        }
        case 4: // bindVariable(const QXmlName & name, const QXmlItem & value)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QXmlName cppArg0_local;
            ::QXmlName *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QXmlItem cppArg1_local;
            ::QXmlItem *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // bindVariable(QXmlName,QXmlItem)
                cppSelf->bindVariable(*cppArg0, *cppArg1);
            }
            break;
        }
        case 5: // bindVariable(const QXmlName & name, const QXmlQuery & query)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QXmlName cppArg0_local;
            ::QXmlName *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QXmlQuery cppArg1_local;
            ::QXmlQuery *cppArg1 = &cppArg1_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);


            if (!PyErr_Occurred()) {
                // bindVariable(QXmlName,QXmlQuery)
                cppSelf->bindVariable(*cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlQueryFunc_bindVariable_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlQueryFunc_evaluateTo(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.evaluateTo";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlQuery::evaluateTo(QAbstractXmlReceiver*)const
    // 1: QXmlQuery::evaluateTo(QIODevice*)const
    // 2: QXmlQuery::evaluateTo(QXmlResultItems*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLRESULTITEMS_IDX]), (pyArg)))) {
        overloadId = 2; // evaluateTo(QXmlResultItems*)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 1; // evaluateTo(QIODevice*)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTXMLRECEIVER_IDX]), (pyArg)))) {
        overloadId = 0; // evaluateTo(QAbstractXmlReceiver*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlQueryFunc_evaluateTo_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // evaluateTo(QAbstractXmlReceiver * callback) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QAbstractXmlReceiver *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // evaluateTo(QAbstractXmlReceiver*)const
                bool cppResult = const_cast<const ::QXmlQuery *>(cppSelf)->evaluateTo(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // evaluateTo(QIODevice * target) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // evaluateTo(QIODevice*)const
                bool cppResult = const_cast<const ::QXmlQuery *>(cppSelf)->evaluateTo(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // evaluateTo(QXmlResultItems * result) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QXmlResultItems *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // evaluateTo(QXmlResultItems*)const
                const_cast<const ::QXmlQuery *>(cppSelf)->evaluateTo(cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlQueryFunc_evaluateTo_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlQueryFunc_initialTemplateName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.initialTemplateName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // initialTemplateName()const
            QXmlName cppResult = const_cast<const ::QXmlQuery *>(cppSelf)->initialTemplateName();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlQueryFunc_isValid(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.isValid";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isValid()const
            bool cppResult = const_cast<const ::QXmlQuery *>(cppSelf)->isValid();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlQueryFunc_messageHandler(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.messageHandler";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // messageHandler()const
            QAbstractMessageHandler * cppResult = const_cast<const ::QXmlQuery *>(cppSelf)->messageHandler();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTMESSAGEHANDLER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlQueryFunc_namePool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.namePool";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // namePool()const
            QXmlNamePool cppResult = const_cast<const ::QXmlQuery *>(cppSelf)->namePool();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAMEPOOL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlQueryFunc_queryLanguage(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.queryLanguage";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // queryLanguage()const
            QXmlQuery::QueryLanguage cppResult = const_cast<const ::QXmlQuery *>(cppSelf)->queryLanguage();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlQueryFunc_setFocus(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.setFocus";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlQuery::setFocus(QIODevice*)
    // 1: QXmlQuery::setFocus(QString)
    // 2: QXmlQuery::setFocus(QUrl)
    // 3: QXmlQuery::setFocus(QXmlItem)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX]), (pyArg)))) {
        overloadId = 3; // setFocus(QXmlItem)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArg)))) {
        overloadId = 0; // setFocus(QIODevice*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // setFocus(QString)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 2; // setFocus(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlQueryFunc_setFocus_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setFocus(QIODevice * document)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setFocus(QIODevice*)
                bool cppResult = cppSelf->setFocus(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 1: // setFocus(const QString & focus)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setFocus(QString)
                bool cppResult = cppSelf->setFocus(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // setFocus(const QUrl & documentURI)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setFocus(QUrl)
                bool cppResult = cppSelf->setFocus(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 3: // setFocus(const QXmlItem & item)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QXmlItem cppArg0_local;
            ::QXmlItem *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLITEM_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setFocus(QXmlItem)
                cppSelf->setFocus(*cppArg0);
                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlQueryFunc_setFocus_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlQueryFunc_setInitialTemplateName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.setInitialTemplateName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlQuery::setInitialTemplateName(QString)
    // 1: QXmlQuery::setInitialTemplateName(QXmlName)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), (pyArg)))) {
        overloadId = 1; // setInitialTemplateName(QXmlName)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setInitialTemplateName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlQueryFunc_setInitialTemplateName_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setInitialTemplateName(const QString & name)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setInitialTemplateName(QString)
                cppSelf->setInitialTemplateName(cppArg0);
            }
            break;
        }
        case 1: // setInitialTemplateName(const QXmlName & name)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QXmlName cppArg0_local;
            ::QXmlName *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAME_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setInitialTemplateName(QXmlName)
                cppSelf->setInitialTemplateName(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlQueryFunc_setInitialTemplateName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlQueryFunc_setMessageHandler(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.setMessageHandler";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlQuery::setMessageHandler(QAbstractMessageHandler*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTMESSAGEHANDLER_IDX]), (pyArg)))) {
        overloadId = 0; // setMessageHandler(QAbstractMessageHandler*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlQueryFunc_setMessageHandler_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractMessageHandler *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMessageHandler(QAbstractMessageHandler*)
            cppSelf->setMessageHandler(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlQueryFunc_setMessageHandler_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlQueryFunc_setQuery(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.setQuery";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QXmlQueryFunc_setQuery_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QXmlQueryFunc_setQuery_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setQuery", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlQuery::setQuery(QIODevice*,QUrl)
    // 1: QXmlQuery::setQuery(QString,QUrl)
    // 2: QXmlQuery::setQuery(QUrl,QUrl)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QIODEVICE_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setQuery(QIODevice*,QUrl)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
            overloadId = 0; // setQuery(QIODevice*,QUrl)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // setQuery(QString,QUrl)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
            overloadId = 1; // setQuery(QString,QUrl)
        }
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 2; // setQuery(QUrl,QUrl)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1])))) {
            overloadId = 2; // setQuery(QUrl,QUrl)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlQueryFunc_setQuery_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setQuery(QIODevice * sourceCode, const QUrl & documentURI)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_documentURI = Shiboken::String::createStaticString("documentURI");
                if (PyDict_Contains(kwds, key_documentURI)) {
                    value = PyDict_GetItem(kwds, key_documentURI);
                    if (value && pyArgs[1]) {
                        errInfo = key_documentURI;
                        Py_INCREF(errInfo);
                        goto Sbk_QXmlQueryFunc_setQuery_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1]))))
                            goto Sbk_QXmlQueryFunc_setQuery_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_documentURI);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QXmlQueryFunc_setQuery_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QIODevice *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local = QUrl();
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // setQuery(QIODevice*,QUrl)
                cppSelf->setQuery(cppArg0, *cppArg1);
            }
            break;
        }
        case 1: // setQuery(const QString & sourceCode, const QUrl & documentURI)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_documentURI = Shiboken::String::createStaticString("documentURI");
                if (PyDict_Contains(kwds, key_documentURI)) {
                    value = PyDict_GetItem(kwds, key_documentURI);
                    if (value && pyArgs[1]) {
                        errInfo = key_documentURI;
                        Py_INCREF(errInfo);
                        goto Sbk_QXmlQueryFunc_setQuery_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1]))))
                            goto Sbk_QXmlQueryFunc_setQuery_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_documentURI);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QXmlQueryFunc_setQuery_TypeError;
                }
            }
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local = QUrl();
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // setQuery(QString,QUrl)
                cppSelf->setQuery(cppArg0, *cppArg1);
            }
            break;
        }
        case 2: // setQuery(const QUrl & queryURI, const QUrl & baseURI)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_baseURI = Shiboken::String::createStaticString("baseURI");
                if (PyDict_Contains(kwds, key_baseURI)) {
                    value = PyDict_GetItem(kwds, key_baseURI);
                    if (value && pyArgs[1]) {
                        errInfo = key_baseURI;
                        Py_INCREF(errInfo);
                        goto Sbk_QXmlQueryFunc_setQuery_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[1]))))
                            goto Sbk_QXmlQueryFunc_setQuery_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_baseURI);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QXmlQueryFunc_setQuery_TypeError;
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QUrl cppArg0_local;
            ::QUrl *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!Shiboken::Object::isValid(pyArgs[1]))
                return {};
            ::QUrl cppArg1_local = QUrl();
            ::QUrl *cppArg1 = &cppArg1_local;
            if (pythonToCpp[1]) {
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[1]))
                pythonToCpp[1](pyArgs[1], &cppArg1_local);
            else
                pythonToCpp[1](pyArgs[1], &cppArg1);
            }

            if (!PyErr_Occurred()) {
                // setQuery(QUrl,QUrl)
                cppSelf->setQuery(*cppArg0, *cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlQueryFunc_setQuery_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlQueryFunc_setUriResolver(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.setUriResolver";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlQuery::setUriResolver(const QAbstractUriResolver*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTURIRESOLVER_IDX]), (pyArg)))) {
        overloadId = 0; // setUriResolver(const QAbstractUriResolver*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlQueryFunc_setUriResolver_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractUriResolver *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUriResolver(const QAbstractUriResolver*)
            cppSelf->setUriResolver(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlQueryFunc_setUriResolver_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlQueryFunc_uriResolver(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXmlPatterns.QXmlQuery.uriResolver";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // uriResolver()const
            const QAbstractUriResolver * cppResult = const_cast<const ::QXmlQuery *>(cppSelf)->uriResolver();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QABSTRACTURIRESOLVER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlQuery___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QXmlQuery_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QXmlQuery_methods[] = {
    {"bindVariable", reinterpret_cast<PyCFunction>(Sbk_QXmlQueryFunc_bindVariable), METH_VARARGS},
    {"evaluateTo", reinterpret_cast<PyCFunction>(Sbk_QXmlQueryFunc_evaluateTo), METH_O},
    {"initialTemplateName", reinterpret_cast<PyCFunction>(Sbk_QXmlQueryFunc_initialTemplateName), METH_NOARGS},
    {"isValid", reinterpret_cast<PyCFunction>(Sbk_QXmlQueryFunc_isValid), METH_NOARGS},
    {"messageHandler", reinterpret_cast<PyCFunction>(Sbk_QXmlQueryFunc_messageHandler), METH_NOARGS},
    {"namePool", reinterpret_cast<PyCFunction>(Sbk_QXmlQueryFunc_namePool), METH_NOARGS},
    {"queryLanguage", reinterpret_cast<PyCFunction>(Sbk_QXmlQueryFunc_queryLanguage), METH_NOARGS},
    {"setFocus", reinterpret_cast<PyCFunction>(Sbk_QXmlQueryFunc_setFocus), METH_O},
    {"setInitialTemplateName", reinterpret_cast<PyCFunction>(Sbk_QXmlQueryFunc_setInitialTemplateName), METH_O},
    {"setMessageHandler", reinterpret_cast<PyCFunction>(Sbk_QXmlQueryFunc_setMessageHandler), METH_O},
    {"setQuery", reinterpret_cast<PyCFunction>(Sbk_QXmlQueryFunc_setQuery), METH_VARARGS|METH_KEYWORDS},
    {"setUriResolver", reinterpret_cast<PyCFunction>(Sbk_QXmlQueryFunc_setUriResolver), METH_O},
    {"uriResolver", reinterpret_cast<PyCFunction>(Sbk_QXmlQueryFunc_uriResolver), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QXmlQuery___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QXmlQuery_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QXmlQuery_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QXmlQuery_Type = nullptr;
static SbkObjectType *Sbk_QXmlQuery_TypeF(void)
{
    return _Sbk_QXmlQuery_Type;
}

static PyType_Slot Sbk_QXmlQuery_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QXmlQuery_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QXmlQuery_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QXmlQuery_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QXmlQuery_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QXmlQuery_spec = {
    "2:PySide2.QtXmlPatterns.QXmlQuery",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QXmlQuery_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QXmlQuery_QueryLanguage_PythonToCpp_QXmlQuery_QueryLanguage(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlQuery::QueryLanguage *>(cppOut) =
        static_cast<::QXmlQuery::QueryLanguage>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QXmlQuery_QueryLanguage_PythonToCpp_QXmlQuery_QueryLanguage_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX]))
        return QXmlQuery_QueryLanguage_PythonToCpp_QXmlQuery_QueryLanguage;
    return {};
}
static PyObject *QXmlQuery_QueryLanguage_CppToPython_QXmlQuery_QueryLanguage(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QXmlQuery::QueryLanguage *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QXmlQuery_PythonToCpp_QXmlQuery_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QXmlQuery_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QXmlQuery_PythonToCpp_QXmlQuery_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlQuery_TypeF())))
        return QXmlQuery_PythonToCpp_QXmlQuery_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QXmlQuery_PTR_CppToPython_QXmlQuery(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QXmlQuery *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QXmlQuery_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QXmlQuery_COPY_CppToPython_QXmlQuery(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QXmlQuery_TypeF(), new ::QXmlQuery(*reinterpret_cast<const ::QXmlQuery *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QXmlQuery_PythonToCpp_QXmlQuery_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlQuery *>(cppOut) = *reinterpret_cast< ::QXmlQuery *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QXmlQuery_PythonToCpp_QXmlQuery_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlQuery_TypeF())))
        return QXmlQuery_PythonToCpp_QXmlQuery_COPY;
    return {};
}

// Implicit conversions.
static void QXmlQuery_QueryLanguage_PythonToCpp_QXmlQuery(PyObject *pyIn, void *cppOut) {
    ::QXmlQuery::QueryLanguage cppIn = static_cast< ::QXmlQuery::QueryLanguage>(0);
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QXmlQuery *>(cppOut) = ::QXmlQuery(cppIn);
}
static PythonToCppFunc is_QXmlQuery_QueryLanguage_PythonToCpp_QXmlQuery_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX], pyIn))
        return QXmlQuery_QueryLanguage_PythonToCpp_QXmlQuery;
    return {};
}

static void constQXmlNamePoolREF_PythonToCpp_QXmlQuery(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlQuery *>(cppOut) = ::QXmlQuery( *reinterpret_cast< ::QXmlNamePool *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAMEPOOL_IDX], reinterpret_cast<SbkObject *>(pyIn))));
}
static PythonToCppFunc is_constQXmlNamePoolREF_PythonToCpp_QXmlQuery_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLNAMEPOOL_IDX], pyIn))
        return constQXmlNamePoolREF_PythonToCpp_QXmlQuery;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QXmlQuery_SignatureStrings[] = {
    "3:PySide2.QtXmlPatterns.QXmlQuery(self)",
    "2:PySide2.QtXmlPatterns.QXmlQuery(self,queryLanguage:PySide2.QtXmlPatterns.QXmlQuery.QueryLanguage,np:PySide2.QtXmlPatterns.QXmlNamePool=QXmlNamePool())",
    "1:PySide2.QtXmlPatterns.QXmlQuery(self,np:PySide2.QtXmlPatterns.QXmlNamePool)",
    "0:PySide2.QtXmlPatterns.QXmlQuery(self,other:PySide2.QtXmlPatterns.QXmlQuery)",
    "5:PySide2.QtXmlPatterns.QXmlQuery.bindVariable(self,localName:QString,arg__2:PySide2.QtCore.QIODevice)",
    "4:PySide2.QtXmlPatterns.QXmlQuery.bindVariable(self,localName:QString,value:PySide2.QtXmlPatterns.QXmlItem)",
    "3:PySide2.QtXmlPatterns.QXmlQuery.bindVariable(self,localName:QString,query:PySide2.QtXmlPatterns.QXmlQuery)",
    "2:PySide2.QtXmlPatterns.QXmlQuery.bindVariable(self,name:PySide2.QtXmlPatterns.QXmlName,arg__2:PySide2.QtCore.QIODevice)",
    "1:PySide2.QtXmlPatterns.QXmlQuery.bindVariable(self,name:PySide2.QtXmlPatterns.QXmlName,value:PySide2.QtXmlPatterns.QXmlItem)",
    "0:PySide2.QtXmlPatterns.QXmlQuery.bindVariable(self,name:PySide2.QtXmlPatterns.QXmlName,query:PySide2.QtXmlPatterns.QXmlQuery)",
    "2:PySide2.QtXmlPatterns.QXmlQuery.evaluateTo(self,callback:PySide2.QtXmlPatterns.QAbstractXmlReceiver)->bool",
    "1:PySide2.QtXmlPatterns.QXmlQuery.evaluateTo(self,target:PySide2.QtCore.QIODevice)->bool",
    "0:PySide2.QtXmlPatterns.QXmlQuery.evaluateTo(self,result:PySide2.QtXmlPatterns.QXmlResultItems)",
    "PySide2.QtXmlPatterns.QXmlQuery.initialTemplateName(self)->PySide2.QtXmlPatterns.QXmlName",
    "PySide2.QtXmlPatterns.QXmlQuery.isValid(self)->bool",
    "PySide2.QtXmlPatterns.QXmlQuery.messageHandler(self)->PySide2.QtXmlPatterns.QAbstractMessageHandler",
    "PySide2.QtXmlPatterns.QXmlQuery.namePool(self)->PySide2.QtXmlPatterns.QXmlNamePool",
    "PySide2.QtXmlPatterns.QXmlQuery.queryLanguage(self)->PySide2.QtXmlPatterns.QXmlQuery.QueryLanguage",
    "3:PySide2.QtXmlPatterns.QXmlQuery.setFocus(self,document:PySide2.QtCore.QIODevice)->bool",
    "2:PySide2.QtXmlPatterns.QXmlQuery.setFocus(self,focus:QString)->bool",
    "1:PySide2.QtXmlPatterns.QXmlQuery.setFocus(self,documentURI:PySide2.QtCore.QUrl)->bool",
    "0:PySide2.QtXmlPatterns.QXmlQuery.setFocus(self,item:PySide2.QtXmlPatterns.QXmlItem)",
    "1:PySide2.QtXmlPatterns.QXmlQuery.setInitialTemplateName(self,name:QString)",
    "0:PySide2.QtXmlPatterns.QXmlQuery.setInitialTemplateName(self,name:PySide2.QtXmlPatterns.QXmlName)",
    "PySide2.QtXmlPatterns.QXmlQuery.setMessageHandler(self,messageHandler:PySide2.QtXmlPatterns.QAbstractMessageHandler)",
    "2:PySide2.QtXmlPatterns.QXmlQuery.setQuery(self,sourceCode:PySide2.QtCore.QIODevice,documentURI:PySide2.QtCore.QUrl=QUrl())",
    "1:PySide2.QtXmlPatterns.QXmlQuery.setQuery(self,sourceCode:QString,documentURI:PySide2.QtCore.QUrl=QUrl())",
    "0:PySide2.QtXmlPatterns.QXmlQuery.setQuery(self,queryURI:PySide2.QtCore.QUrl,baseURI:PySide2.QtCore.QUrl=QUrl())",
    "PySide2.QtXmlPatterns.QXmlQuery.setUriResolver(self,resolver:PySide2.QtXmlPatterns.QAbstractUriResolver)",
    "PySide2.QtXmlPatterns.QXmlQuery.uriResolver(self)->PySide2.QtXmlPatterns.QAbstractUriResolver",
    "PySide2.QtXmlPatterns.QXmlQuery.__copy__()",
    nullptr}; // Sentinel

void init_QXmlQuery(PyObject *module)
{
    _Sbk_QXmlQuery_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QXmlQuery",
        "QXmlQuery",
        &Sbk_QXmlQuery_spec,
        &Shiboken::callCppDestructor< ::QXmlQuery >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QXmlQuery_Type);
    InitSignatureStrings(pyType, QXmlQuery_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QXmlQuery_Type), Sbk_QXmlQuery_PropertyStrings);
    SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QXmlQuery_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QXmlQuery_TypeF(),
        QXmlQuery_PythonToCpp_QXmlQuery_PTR,
        is_QXmlQuery_PythonToCpp_QXmlQuery_PTR_Convertible,
        QXmlQuery_PTR_CppToPython_QXmlQuery,
        QXmlQuery_COPY_CppToPython_QXmlQuery);

    Shiboken::Conversions::registerConverterName(converter, "QXmlQuery");
    Shiboken::Conversions::registerConverterName(converter, "QXmlQuery*");
    Shiboken::Conversions::registerConverterName(converter, "QXmlQuery&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QXmlQuery).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QXmlQuery_PythonToCpp_QXmlQuery_COPY,
        is_QXmlQuery_PythonToCpp_QXmlQuery_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QXmlQuery_QueryLanguage_PythonToCpp_QXmlQuery,
        is_QXmlQuery_QueryLanguage_PythonToCpp_QXmlQuery_Convertible);
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        constQXmlNamePoolREF_PythonToCpp_QXmlQuery,
        is_constQXmlNamePoolREF_PythonToCpp_QXmlQuery_Convertible);

    // Initialization of enums.

    // Initialization of enum 'QueryLanguage'.
    SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QXmlQuery_TypeF(),
        "QueryLanguage",
        "2:PySide2.QtXmlPatterns.QXmlQuery.QueryLanguage",
        "QXmlQuery::QueryLanguage");
    if (!SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX],
        Sbk_QXmlQuery_TypeF(), "XQuery10", (long) QXmlQuery::QueryLanguage::XQuery10))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX],
        Sbk_QXmlQuery_TypeF(), "XSLT20", (long) QXmlQuery::QueryLanguage::XSLT20))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX],
        Sbk_QXmlQuery_TypeF(), "XmlSchema11IdentityConstraintSelector", (long) QXmlQuery::QueryLanguage::XmlSchema11IdentityConstraintSelector))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX],
        Sbk_QXmlQuery_TypeF(), "XmlSchema11IdentityConstraintField", (long) QXmlQuery::QueryLanguage::XmlSchema11IdentityConstraintField))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX],
        Sbk_QXmlQuery_TypeF(), "XPath20", (long) QXmlQuery::QueryLanguage::XPath20))
        return;
    // Register converter for enum 'QXmlQuery::QueryLanguage'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX],
            QXmlQuery_QueryLanguage_CppToPython_QXmlQuery_QueryLanguage);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QXmlQuery_QueryLanguage_PythonToCpp_QXmlQuery_QueryLanguage,
            is_QXmlQuery_QueryLanguage_PythonToCpp_QXmlQuery_QueryLanguage_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtXmlPatternsTypes[SBK_QXMLQUERY_QUERYLANGUAGE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QXmlQuery::QueryLanguage");
        Shiboken::Conversions::registerConverterName(converter, "QueryLanguage");
    }
    // End of 'QueryLanguage' enum.

    qRegisterMetaType< ::QXmlQuery >("QXmlQuery");
    qRegisterMetaType< ::QXmlQuery::QueryLanguage >("QXmlQuery::QueryLanguage");
}
