/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtxml_python.h"

// main header
#include "qxmlattributes_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QXmlAttributesWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QXmlAttributesWrapper::QXmlAttributesWrapper() : QXmlAttributes()
{
    resetPyMethodCache();
    // ... middle
}

QXmlAttributesWrapper::~QXmlAttributesWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QXmlAttributes_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QXmlAttributes >()))
        return -1;

    ::QXmlAttributesWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QXmlAttributes.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QXmlAttributes", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QXmlAttributes::QXmlAttributes()
    // 1: QXmlAttributes::QXmlAttributes(QXmlAttributes)
    if (numArgs == 0) {
        overloadId = 0; // QXmlAttributes()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QXmlAttributes(QXmlAttributes)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlAttributes_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QXmlAttributes()
        {

            if (!PyErr_Occurred()) {
                // QXmlAttributes()
                cptr = new ::QXmlAttributesWrapper();
            }
            PyErr_WarnEx(PyExc_DeprecationWarning, "QXmlAttributes.QXmlAttributes() is deprecated", 1);
            break;
        }
        case 1: // QXmlAttributes(const QXmlAttributes & arg__1)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QXmlAttributes cppArg0_local;
            ::QXmlAttributes *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QXmlAttributes(QXmlAttributes)
                cptr = new ::QXmlAttributesWrapper(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QXmlAttributes >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QXmlAttributes_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QXmlAttributes_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QXmlAttributesFunc_append(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QXmlAttributes.append";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "append", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QXmlAttributes::append(QString,QString,QString,QString)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
        overloadId = 0; // append(QString,QString,QString,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlAttributesFunc_append_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // append(QString,QString,QString,QString)
            cppSelf->append(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlAttributesFunc_append_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlAttributesFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QXmlAttributes.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QXmlAttributesFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QXmlAttributes.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            int cppResult = const_cast<const ::QXmlAttributes *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlAttributesFunc_index(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QXmlAttributes.index";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "index", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlAttributes::index(QString)const
    // 1: QXmlAttributes::index(QString,QString)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // index(QString)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // index(QString,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlAttributesFunc_index_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // index(const QString & qName) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // index(QString)const
                int cppResult = const_cast<const ::QXmlAttributes *>(cppSelf)->index(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // index(const QString & uri, const QString & localPart) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // index(QString,QString)const
                int cppResult = const_cast<const ::QXmlAttributes *>(cppSelf)->index(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlAttributesFunc_index_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlAttributesFunc_length(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QXmlAttributes.length";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // length()const
            int cppResult = const_cast<const ::QXmlAttributes *>(cppSelf)->length();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QXmlAttributesFunc_localName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QXmlAttributes.localName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlAttributes::localName(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // localName(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlAttributesFunc_localName_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // localName(int)const
            QString cppResult = const_cast<const ::QXmlAttributes *>(cppSelf)->localName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlAttributesFunc_localName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlAttributesFunc_qName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QXmlAttributes.qName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlAttributes::qName(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // qName(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlAttributesFunc_qName_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // qName(int)const
            QString cppResult = const_cast<const ::QXmlAttributes *>(cppSelf)->qName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlAttributesFunc_qName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlAttributesFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QXmlAttributes.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlAttributes::swap(QXmlAttributes&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QXmlAttributes&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlAttributesFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QXmlAttributes cppArg0_local;
        ::QXmlAttributes *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QXmlAttributes&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QXmlAttributesFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlAttributesFunc_type(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QXmlAttributes.type";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "type", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlAttributes::type(QString)const
    // 1: QXmlAttributes::type(QString,QString)const
    // 2: QXmlAttributes::type(int)const
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // type(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // type(QString)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // type(QString,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlAttributesFunc_type_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // type(const QString & qName) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // type(QString)const
                QString cppResult = const_cast<const ::QXmlAttributes *>(cppSelf)->type(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // type(const QString & uri, const QString & localName) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // type(QString,QString)const
                QString cppResult = const_cast<const ::QXmlAttributes *>(cppSelf)->type(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 2: // type(int index) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // type(int)const
                QString cppResult = const_cast<const ::QXmlAttributes *>(cppSelf)->type(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlAttributesFunc_type_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlAttributesFunc_uri(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QXmlAttributes.uri";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QXmlAttributes::uri(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // uri(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlAttributesFunc_uri_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // uri(int)const
            QString cppResult = const_cast<const ::QXmlAttributes *>(cppSelf)->uri(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlAttributesFunc_uri_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlAttributesFunc_value(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtXml.QXmlAttributes.value";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "value", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QXmlAttributes::value(QString)const
    // 1: QXmlAttributes::value(QString,QString)const
    // 2: QXmlAttributes::value(int)const
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // value(int)const
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // value(QString)const
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 1; // value(QString,QString)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QXmlAttributesFunc_value_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // value(const QString & qName) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // value(QString)const
                QString cppResult = const_cast<const ::QXmlAttributes *>(cppSelf)->value(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 1: // value(const QString & uri, const QString & localName) const
        {
            ::QString cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // value(QString,QString)const
                QString cppResult = const_cast<const ::QXmlAttributes *>(cppSelf)->value(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
        case 2: // value(int index) const
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // value(int)const
                QString cppResult = const_cast<const ::QXmlAttributes *>(cppSelf)->value(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QXmlAttributesFunc_value_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QXmlAttributes___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QXmlAttributes_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QXmlAttributes_methods[] = {
    {"append", reinterpret_cast<PyCFunction>(Sbk_QXmlAttributesFunc_append), METH_VARARGS},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QXmlAttributesFunc_clear), METH_NOARGS},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QXmlAttributesFunc_count), METH_NOARGS},
    {"index", reinterpret_cast<PyCFunction>(Sbk_QXmlAttributesFunc_index), METH_VARARGS},
    {"length", reinterpret_cast<PyCFunction>(Sbk_QXmlAttributesFunc_length), METH_NOARGS},
    {"localName", reinterpret_cast<PyCFunction>(Sbk_QXmlAttributesFunc_localName), METH_O},
    {"qName", reinterpret_cast<PyCFunction>(Sbk_QXmlAttributesFunc_qName), METH_O},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QXmlAttributesFunc_swap), METH_O},
    {"type", reinterpret_cast<PyCFunction>(Sbk_QXmlAttributesFunc_type), METH_VARARGS},
    {"uri", reinterpret_cast<PyCFunction>(Sbk_QXmlAttributesFunc_uri), METH_O},
    {"value", reinterpret_cast<PyCFunction>(Sbk_QXmlAttributesFunc_value), METH_VARARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QXmlAttributes___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QXmlAttributes_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QXmlAttributesWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QXmlAttributes_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QXmlAttributes_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QXmlAttributes_Type = nullptr;
static SbkObjectType *Sbk_QXmlAttributes_TypeF(void)
{
    return _Sbk_QXmlAttributes_Type;
}

static PyType_Slot Sbk_QXmlAttributes_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QXmlAttributes_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QXmlAttributes_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QXmlAttributes_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QXmlAttributes_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QXmlAttributes_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QXmlAttributes_spec = {
    "2:PySide2.QtXml.QXmlAttributes",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QXmlAttributes_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QXmlAttributes_PythonToCpp_QXmlAttributes_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QXmlAttributes_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QXmlAttributes_PythonToCpp_QXmlAttributes_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlAttributes_TypeF())))
        return QXmlAttributes_PythonToCpp_QXmlAttributes_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QXmlAttributes_PTR_CppToPython_QXmlAttributes(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QXmlAttributes *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QXmlAttributes_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QXmlAttributes_COPY_CppToPython_QXmlAttributes(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QXmlAttributes_TypeF(), new ::QXmlAttributesWrapper(*reinterpret_cast<const ::QXmlAttributes *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QXmlAttributes_PythonToCpp_QXmlAttributes_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QXmlAttributes *>(cppOut) = *reinterpret_cast< ::QXmlAttributes *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QXmlAttributes_PythonToCpp_QXmlAttributes_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QXmlAttributes_TypeF())))
        return QXmlAttributes_PythonToCpp_QXmlAttributes_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QXmlAttributes_SignatureStrings[] = {
    "1:PySide2.QtXml.QXmlAttributes(self)",
    "0:PySide2.QtXml.QXmlAttributes(self,arg__1:PySide2.QtXml.QXmlAttributes)",
    "PySide2.QtXml.QXmlAttributes.append(self,qName:QString,uri:QString,localPart:QString,value:QString)",
    "PySide2.QtXml.QXmlAttributes.clear(self)",
    "PySide2.QtXml.QXmlAttributes.count(self)->int",
    "1:PySide2.QtXml.QXmlAttributes.index(self,qName:QString)->int",
    "0:PySide2.QtXml.QXmlAttributes.index(self,uri:QString,localPart:QString)->int",
    "PySide2.QtXml.QXmlAttributes.length(self)->int",
    "PySide2.QtXml.QXmlAttributes.localName(self,index:int)->QString",
    "PySide2.QtXml.QXmlAttributes.qName(self,index:int)->QString",
    "PySide2.QtXml.QXmlAttributes.swap(self,other:PySide2.QtXml.QXmlAttributes)",
    "2:PySide2.QtXml.QXmlAttributes.type(self,qName:QString)->QString",
    "1:PySide2.QtXml.QXmlAttributes.type(self,uri:QString,localName:QString)->QString",
    "0:PySide2.QtXml.QXmlAttributes.type(self,index:int)->QString",
    "PySide2.QtXml.QXmlAttributes.uri(self,index:int)->QString",
    "2:PySide2.QtXml.QXmlAttributes.value(self,qName:QString)->QString",
    "1:PySide2.QtXml.QXmlAttributes.value(self,uri:QString,localName:QString)->QString",
    "0:PySide2.QtXml.QXmlAttributes.value(self,index:int)->QString",
    "PySide2.QtXml.QXmlAttributes.__copy__()",
    nullptr}; // Sentinel

void init_QXmlAttributes(PyObject *module)
{
    _Sbk_QXmlAttributes_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QXmlAttributes",
        "QXmlAttributes",
        &Sbk_QXmlAttributes_spec,
        &Shiboken::callCppDestructor< ::QXmlAttributesWrapper >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QXmlAttributes_Type);
    InitSignatureStrings(pyType, QXmlAttributes_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QXmlAttributes_Type), Sbk_QXmlAttributes_PropertyStrings);
    SbkPySide2_QtXmlTypes[SBK_QXMLATTRIBUTES_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QXmlAttributes_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QXmlAttributes_TypeF(),
        QXmlAttributes_PythonToCpp_QXmlAttributes_PTR,
        is_QXmlAttributes_PythonToCpp_QXmlAttributes_PTR_Convertible,
        QXmlAttributes_PTR_CppToPython_QXmlAttributes,
        QXmlAttributes_COPY_CppToPython_QXmlAttributes);

    Shiboken::Conversions::registerConverterName(converter, "QXmlAttributes");
    Shiboken::Conversions::registerConverterName(converter, "QXmlAttributes*");
    Shiboken::Conversions::registerConverterName(converter, "QXmlAttributes&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QXmlAttributes).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QXmlAttributesWrapper).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QXmlAttributes_PythonToCpp_QXmlAttributes_COPY,
        is_QXmlAttributes_PythonToCpp_QXmlAttributes_COPY_Convertible);

    qRegisterMetaType< ::QXmlAttributes >("QXmlAttributes");
}
