/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qtilerules_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTileRules_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTileRules >()))
        return -1;

    ::QTileRules *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTileRules.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QTileRules_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QTileRules", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QTileRules::QTileRules(Qt::TileRule,Qt::TileRule)
    // 1: QTileRules::QTileRules(Qt::TileRule)
    // 2: QTileRules::QTileRules(QTileRules)
    if (numArgs == 0) {
        overloadId = 1; // QTileRules(Qt::TileRule)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QTileRules(Qt::TileRule)
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // QTileRules(Qt::TileRule,Qt::TileRule)
        }
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTILERULES_IDX]), (pyArgs[0])))) {
        overloadId = 2; // QTileRules(QTileRules)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTileRules_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QTileRules(Qt::TileRule horizontalRule, Qt::TileRule verticalRule)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTileRules_Init_TypeError;
            }
            ::Qt::TileRule cppArg0{Qt::StretchTile};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::Qt::TileRule cppArg1{Qt::StretchTile};
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QTileRules(Qt::TileRule,Qt::TileRule)
                cptr = new ::QTileRules(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // QTileRules(Qt::TileRule rule)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_rule = Shiboken::String::createStaticString("rule");
                if (PyDict_Contains(kwds, key_rule)) {
                    value = PyDict_GetItem(kwds, key_rule);
                    if (value && pyArgs[0]) {
                        errInfo = key_rule;
                        Py_INCREF(errInfo);
                        goto Sbk_QTileRules_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX])->converter, (pyArgs[0]))))
                            goto Sbk_QTileRules_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_rule);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QTileRules_Init_TypeError;
                }
            }
            ::Qt::TileRule cppArg0 = Qt::StretchTile;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QTileRules(Qt::TileRule)
                cptr = new ::QTileRules(cppArg0);
            }
            break;
        }
        case 2: // QTileRules(const QTileRules & QTileRules)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QTileRules_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTileRules cppArg0_local;
            ::QTileRules *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTILERULES_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QTileRules(QTileRules)
                cptr = new ::QTileRules(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTileRules >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTileRules_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTileRules_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTileRules___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTileRules *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTILERULES_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTILERULES_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTileRules_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTileRules_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTileRules___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QTileRules_get_horizontal(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTileRules *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTILERULES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::Qt::TileRule cppOut_local = cppSelf->horizontal;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QTileRules_set_horizontal(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTileRules *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTILERULES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'horizontal' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'horizontal', 'TileRule' or convertible type expected");
        return -1;
    }

    ::Qt::TileRule cppOut_local = cppSelf->horizontal;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->horizontal = cppOut_local;

    return 0;
}

static PyObject *Sbk_QTileRules_get_vertical(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTileRules *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTILERULES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::Qt::TileRule cppOut_local = cppSelf->vertical;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QTileRules_set_vertical(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTileRules *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTILERULES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'vertical' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'vertical', 'TileRule' or convertible type expected");
        return -1;
    }

    ::Qt::TileRule cppOut_local = cppSelf->vertical;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->vertical = cppOut_local;

    return 0;
}

// Getters and Setters for QTileRules
static PyGetSetDef Sbk_QTileRules_getsetlist[] = {
    {const_cast<char *>("horizontal"), Sbk_QTileRules_get_horizontal, Sbk_QTileRules_set_horizontal},
    {const_cast<char *>("vertical"), Sbk_QTileRules_get_vertical, Sbk_QTileRules_set_vertical},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTileRules_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTileRules_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTileRules_Type = nullptr;
static SbkObjectType *Sbk_QTileRules_TypeF(void)
{
    return _Sbk_QTileRules_Type;
}

static PyType_Slot Sbk_QTileRules_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTileRules_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTileRules_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTileRules_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QTileRules_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTileRules_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTileRules_spec = {
    "2:PySide2.QtWidgets.QTileRules",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTileRules_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QTileRules_PythonToCpp_QTileRules_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTileRules_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QTileRules_PythonToCpp_QTileRules_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTileRules_TypeF())))
        return QTileRules_PythonToCpp_QTileRules_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QTileRules_PTR_CppToPython_QTileRules(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTileRules *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTileRules_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QTileRules_COPY_CppToPython_QTileRules(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTileRules_TypeF(), new ::QTileRules(*reinterpret_cast<const ::QTileRules *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QTileRules_PythonToCpp_QTileRules_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTileRules *>(cppOut) = *reinterpret_cast< ::QTileRules *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTILERULES_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QTileRules_PythonToCpp_QTileRules_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTileRules_TypeF())))
        return QTileRules_PythonToCpp_QTileRules_COPY;
    return {};
}

// Implicit conversions.
static void PySide2_QtCore_Qt_TileRule_PythonToCpp_QTileRules(PyObject *pyIn, void *cppOut) {
    ::Qt::TileRule cppIn{Qt::StretchTile};
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX])->converter, pyIn, &cppIn);
    *reinterpret_cast<::QTileRules *>(cppOut) = ::QTileRules(cppIn);
}
static PythonToCppFunc is_PySide2_QtCore_Qt_TileRule_PythonToCpp_QTileRules_Convertible(PyObject *pyIn) {
    if (SbkObject_TypeCheck(SbkPySide2_QtCoreTypes[SBK_QT_TILERULE_IDX], pyIn))
        return PySide2_QtCore_Qt_TileRule_PythonToCpp_QTileRules;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTileRules_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QTileRules(self,horizontalRule:PySide2.QtCore.Qt.TileRule,verticalRule:PySide2.QtCore.Qt.TileRule)",
    "1:PySide2.QtWidgets.QTileRules(self,rule:PySide2.QtCore.Qt.TileRule=Qt.StretchTile)",
    "0:PySide2.QtWidgets.QTileRules(self,QTileRules:PySide2.QtWidgets.QTileRules)",
    "PySide2.QtWidgets.QTileRules.__copy__()",
    nullptr}; // Sentinel

void init_QTileRules(PyObject *module)
{
    _Sbk_QTileRules_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QTileRules",
        "QTileRules",
        &Sbk_QTileRules_spec,
        &Shiboken::callCppDestructor< ::QTileRules >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTileRules_Type);
    InitSignatureStrings(pyType, QTileRules_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTileRules_Type), Sbk_QTileRules_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QTILERULES_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTileRules_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTileRules_TypeF(),
        QTileRules_PythonToCpp_QTileRules_PTR,
        is_QTileRules_PythonToCpp_QTileRules_PTR_Convertible,
        QTileRules_PTR_CppToPython_QTileRules,
        QTileRules_COPY_CppToPython_QTileRules);

    Shiboken::Conversions::registerConverterName(converter, "QTileRules");
    Shiboken::Conversions::registerConverterName(converter, "QTileRules*");
    Shiboken::Conversions::registerConverterName(converter, "QTileRules&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTileRules).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QTileRules_PythonToCpp_QTileRules_COPY,
        is_QTileRules_PythonToCpp_QTileRules_COPY_Convertible);
    // Add implicit conversions to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        PySide2_QtCore_Qt_TileRule_PythonToCpp_QTileRules,
        is_PySide2_QtCore_Qt_TileRule_PythonToCpp_QTileRules_Convertible);

}
