/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qtextedit_extraselection_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QTextEdit_ExtraSelection_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QTextEdit::ExtraSelection >()))
        return -1;

    ::QTextEdit::ExtraSelection *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QTextEdit.ExtraSelection.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "ExtraSelection", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: ExtraSelection::ExtraSelection()
    // 1: ExtraSelection::ExtraSelection(QTextEdit::ExtraSelection)
    if (numArgs == 0) {
        overloadId = 0; // ExtraSelection()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX]), (pyArgs[0])))) {
        overloadId = 1; // ExtraSelection(QTextEdit::ExtraSelection)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QTextEdit_ExtraSelection_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // ExtraSelection()
        {

            if (!PyErr_Occurred()) {
                // ExtraSelection()
                cptr = new ::QTextEdit::ExtraSelection();
            }
            break;
        }
        case 1: // ExtraSelection(const QTextEdit::ExtraSelection & ExtraSelection)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QTextEdit::ExtraSelection cppArg0_local;
            ::QTextEdit::ExtraSelection *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // ExtraSelection(QTextEdit::ExtraSelection)
                cptr = new ::QTextEdit::ExtraSelection(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QTextEdit::ExtraSelection >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QTextEdit_ExtraSelection_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QTextEdit_ExtraSelection_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QTextEdit_ExtraSelection___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QTextEdit::ExtraSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QTextEdit_ExtraSelection_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QTextEdit_ExtraSelection_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QTextEdit_ExtraSelection___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QTextEdit_ExtraSelection_get_cursor(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTextEdit::ExtraSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->cursor)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->cursor))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->cursor)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), &(cppSelf->cursor), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QTextEdit_ExtraSelection_set_cursor(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTextEdit::ExtraSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'cursor' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCURSOR_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'cursor', 'QTextCursor' or convertible type expected");
        return -1;
    }

    ::QTextCursor& cppOut_ptr = cppSelf->cursor;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QTextEdit_ExtraSelection_get_format(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QTextEdit::ExtraSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->format)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->format))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->format)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), &(cppSelf->format), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QTextEdit_ExtraSelection_set_format(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QTextEdit::ExtraSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'format' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTEXTCHARFORMAT_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'format', 'QTextCharFormat' or convertible type expected");
        return -1;
    }

    ::QTextCharFormat& cppOut_ptr = cppSelf->format;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for ExtraSelection
static PyGetSetDef Sbk_QTextEdit_ExtraSelection_getsetlist[] = {
    {const_cast<char *>("cursor"), Sbk_QTextEdit_ExtraSelection_get_cursor, Sbk_QTextEdit_ExtraSelection_set_cursor},
    {const_cast<char *>("format"), Sbk_QTextEdit_ExtraSelection_get_format, Sbk_QTextEdit_ExtraSelection_set_format},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QTextEdit_ExtraSelection_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QTextEdit_ExtraSelection_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QTextEdit_ExtraSelection_Type = nullptr;
static SbkObjectType *Sbk_QTextEdit_ExtraSelection_TypeF(void)
{
    return _Sbk_QTextEdit_ExtraSelection_Type;
}

static PyType_Slot Sbk_QTextEdit_ExtraSelection_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QTextEdit_ExtraSelection_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QTextEdit_ExtraSelection_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QTextEdit_ExtraSelection_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QTextEdit_ExtraSelection_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QTextEdit_ExtraSelection_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QTextEdit_ExtraSelection_spec = {
    "2:PySide2.QtWidgets.QTextEdit.ExtraSelection",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QTextEdit_ExtraSelection_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void ExtraSelection_PythonToCpp_ExtraSelection_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QTextEdit_ExtraSelection_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_ExtraSelection_PythonToCpp_ExtraSelection_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextEdit_ExtraSelection_TypeF())))
        return ExtraSelection_PythonToCpp_ExtraSelection_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *ExtraSelection_PTR_CppToPython_ExtraSelection(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QTextEdit::ExtraSelection *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QTextEdit_ExtraSelection_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *ExtraSelection_COPY_CppToPython_ExtraSelection(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QTextEdit_ExtraSelection_TypeF(), new ::QTextEdit::ExtraSelection(*reinterpret_cast<const ::QTextEdit::ExtraSelection *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void ExtraSelection_PythonToCpp_ExtraSelection_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QTextEdit::ExtraSelection *>(cppOut) = *reinterpret_cast< ::QTextEdit::ExtraSelection *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_ExtraSelection_PythonToCpp_ExtraSelection_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QTextEdit_ExtraSelection_TypeF())))
        return ExtraSelection_PythonToCpp_ExtraSelection_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QTextEdit_ExtraSelection_SignatureStrings[] = {
    "1:PySide2.QtWidgets.QTextEdit.ExtraSelection(self)",
    "0:PySide2.QtWidgets.QTextEdit.ExtraSelection(self,ExtraSelection:PySide2.QtWidgets.QTextEdit.ExtraSelection)",
    "PySide2.QtWidgets.QTextEdit.ExtraSelection.__copy__()",
    nullptr}; // Sentinel

void init_QTextEdit_ExtraSelection(PyObject *enclosingClass)
{
    _Sbk_QTextEdit_ExtraSelection_Type = Shiboken::ObjectType::introduceWrapperType(
        enclosingClass,
        "ExtraSelection",
        "QTextEdit::ExtraSelection",
        &Sbk_QTextEdit_ExtraSelection_spec,
        &Shiboken::callCppDestructor< ::QTextEdit::ExtraSelection >,
        0,
        0,
        Shiboken::ObjectType::WrapperFlags::InnerClass    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QTextEdit_ExtraSelection_Type);
    InitSignatureStrings(pyType, QTextEdit_ExtraSelection_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QTextEdit_ExtraSelection_Type), Sbk_QTextEdit_ExtraSelection_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QTEXTEDIT_EXTRASELECTION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QTextEdit_ExtraSelection_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QTextEdit_ExtraSelection_TypeF(),
        ExtraSelection_PythonToCpp_ExtraSelection_PTR,
        is_ExtraSelection_PythonToCpp_ExtraSelection_PTR_Convertible,
        ExtraSelection_PTR_CppToPython_ExtraSelection,
        ExtraSelection_COPY_CppToPython_ExtraSelection);

    Shiboken::Conversions::registerConverterName(converter, "QTextEdit::ExtraSelection");
    Shiboken::Conversions::registerConverterName(converter, "QTextEdit::ExtraSelection*");
    Shiboken::Conversions::registerConverterName(converter, "QTextEdit::ExtraSelection&");
    Shiboken::Conversions::registerConverterName(converter, "ExtraSelection");
    Shiboken::Conversions::registerConverterName(converter, "ExtraSelection*");
    Shiboken::Conversions::registerConverterName(converter, "ExtraSelection&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QTextEdit::ExtraSelection).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        ExtraSelection_PythonToCpp_ExtraSelection_COPY,
        is_ExtraSelection_PythonToCpp_ExtraSelection_COPY_Convertible);

    qRegisterMetaType< ::QTextEdit::ExtraSelection >("ExtraSelection");
    qRegisterMetaType< ::QTextEdit::ExtraSelection >("QTextEdit::ExtraSelection");
}
