/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstyleoptionviewitem_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qstyleoption.h>
#include <QtWidgets/qwidget.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleOptionViewItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleOptionViewItem >()))
        return -1;

    ::QStyleOptionViewItem *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleOptionViewItem.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStyleOptionViewItem", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStyleOptionViewItem::QStyleOptionViewItem()
    // 1: QStyleOptionViewItem::QStyleOptionViewItem(QStyleOptionViewItem)
    // 2: QStyleOptionViewItem::QStyleOptionViewItem(int)
    if (numArgs == 0) {
        overloadId = 0; // QStyleOptionViewItem()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // QStyleOptionViewItem(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStyleOptionViewItem(QStyleOptionViewItem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleOptionViewItem_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStyleOptionViewItem()
        {

            if (!PyErr_Occurred()) {
                // QStyleOptionViewItem()
                cptr = new ::QStyleOptionViewItem();
            }
            break;
        }
        case 1: // QStyleOptionViewItem(const QStyleOptionViewItem & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStyleOptionViewItem cppArg0_local;
            ::QStyleOptionViewItem *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QStyleOptionViewItem(QStyleOptionViewItem)
                cptr = new ::QStyleOptionViewItem(*cppArg0);
            }
            break;
        }
        case 2: // QStyleOptionViewItem(int version)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionViewItem(int)
                cptr = new ::QStyleOptionViewItem(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleOptionViewItem >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStyleOptionViewItem_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStyleOptionViewItem_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QStyleOptionViewItem___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QStyleOptionViewItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleOptionViewItem_methods[] = {

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QStyleOptionViewItem___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleOptionViewItem_get_displayAlignment(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppSelf->displayAlignment);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_displayAlignment(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'displayAlignment' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'displayAlignment', 'Alignment' or convertible type expected");
        return -1;
    }

    ::QFlags<Qt::AlignmentFlag> cppOut_local = cppSelf->displayAlignment;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->displayAlignment = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_decorationAlignment(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppSelf->decorationAlignment);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_decorationAlignment(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'decorationAlignment' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'decorationAlignment', 'Alignment' or convertible type expected");
        return -1;
    }

    ::QFlags<Qt::AlignmentFlag> cppOut_local = cppSelf->decorationAlignment;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->decorationAlignment = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_textElideMode(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::Qt::TextElideMode cppOut_local = cppSelf->textElideMode;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_textElideMode(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'textElideMode' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TEXTELIDEMODE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'textElideMode', 'TextElideMode' or convertible type expected");
        return -1;
    }

    ::Qt::TextElideMode cppOut_local = cppSelf->textElideMode;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->textElideMode = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_decorationPosition(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QStyleOptionViewItem::Position cppOut_local = cppSelf->decorationPosition;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_decorationPosition(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'decorationPosition' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'decorationPosition', 'Position' or convertible type expected");
        return -1;
    }

    ::QStyleOptionViewItem::Position cppOut_local = cppSelf->decorationPosition;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->decorationPosition = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_decorationSize(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->decorationSize)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->decorationSize))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->decorationSize)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &(cppSelf->decorationSize), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_decorationSize(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'decorationSize' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'decorationSize', 'QSize' or convertible type expected");
        return -1;
    }

    ::QSize& cppOut_ptr = cppSelf->decorationSize;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_font(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->font)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->font))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->font)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &(cppSelf->font), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_font(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'font' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'font', 'QFont' or convertible type expected");
        return -1;
    }

    ::QFont& cppOut_ptr = cppSelf->font;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_showDecorationSelected(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->showDecorationSelected;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_showDecorationSelected(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'showDecorationSelected' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'showDecorationSelected', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->showDecorationSelected;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->showDecorationSelected = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_features(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX])->converter, &cppSelf->features);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_features(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'features' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'features', 'ViewItemFeatures' or convertible type expected");
        return -1;
    }

    ::QFlags<QStyleOptionViewItem::ViewItemFeature> cppOut_local = cppSelf->features;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->features = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_locale(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->locale)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->locale))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->locale)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), &(cppSelf->locale), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_locale(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'locale' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QLOCALE_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'locale', 'QLocale' or convertible type expected");
        return -1;
    }

    ::QLocale& cppOut_ptr = cppSelf->locale;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_widget(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppSelf->widget);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_widget(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'widget' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'widget', 'QWidget' or convertible type expected");
        return -1;
    }

    const ::QWidget *& cppOut_ptr = cppSelf->widget;
    pythonToCpp(pyIn, &cppOut_ptr);

    Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "widget", pyIn);
    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_index(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->index)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->index))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->index)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), &(cppSelf->index), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_index(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'index' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMODELINDEX_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'index', 'QModelIndex' or convertible type expected");
        return -1;
    }

    ::QModelIndex& cppOut_ptr = cppSelf->index;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_checkState(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::Qt::CheckState cppOut_local = cppSelf->checkState;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CHECKSTATE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_checkState(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'checkState' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_CHECKSTATE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'checkState', 'CheckState' or convertible type expected");
        return -1;
    }

    ::Qt::CheckState cppOut_local = cppSelf->checkState;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->checkState = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_icon(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->icon)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->icon))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->icon)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &(cppSelf->icon), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_icon(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'icon' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'icon', 'QIcon' or convertible type expected");
        return -1;
    }

    ::QIcon& cppOut_ptr = cppSelf->icon;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_text(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->text);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_text(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'text' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'text', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->text;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_viewItemPosition(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QStyleOptionViewItem::ViewItemPosition cppOut_local = cppSelf->viewItemPosition;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMPOSITION_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_viewItemPosition(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'viewItemPosition' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMPOSITION_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'viewItemPosition', 'ViewItemPosition' or convertible type expected");
        return -1;
    }

    ::QStyleOptionViewItem::ViewItemPosition cppOut_local = cppSelf->viewItemPosition;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->viewItemPosition = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionViewItem_get_backgroundBrush(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->backgroundBrush)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->backgroundBrush))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->backgroundBrush)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), &(cppSelf->backgroundBrush), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionViewItem_set_backgroundBrush(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'backgroundBrush' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QBRUSH_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'backgroundBrush', 'QBrush' or convertible type expected");
        return -1;
    }

    ::QBrush& cppOut_ptr = cppSelf->backgroundBrush;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for QStyleOptionViewItem
static PyGetSetDef Sbk_QStyleOptionViewItem_getsetlist[] = {
    {const_cast<char *>("displayAlignment"), Sbk_QStyleOptionViewItem_get_displayAlignment, Sbk_QStyleOptionViewItem_set_displayAlignment},
    {const_cast<char *>("decorationAlignment"), Sbk_QStyleOptionViewItem_get_decorationAlignment, Sbk_QStyleOptionViewItem_set_decorationAlignment},
    {const_cast<char *>("textElideMode"), Sbk_QStyleOptionViewItem_get_textElideMode, Sbk_QStyleOptionViewItem_set_textElideMode},
    {const_cast<char *>("decorationPosition"), Sbk_QStyleOptionViewItem_get_decorationPosition, Sbk_QStyleOptionViewItem_set_decorationPosition},
    {const_cast<char *>("decorationSize"), Sbk_QStyleOptionViewItem_get_decorationSize, Sbk_QStyleOptionViewItem_set_decorationSize},
    {const_cast<char *>("font"), Sbk_QStyleOptionViewItem_get_font, Sbk_QStyleOptionViewItem_set_font},
    {const_cast<char *>("showDecorationSelected"), Sbk_QStyleOptionViewItem_get_showDecorationSelected, Sbk_QStyleOptionViewItem_set_showDecorationSelected},
    {const_cast<char *>("features"), Sbk_QStyleOptionViewItem_get_features, Sbk_QStyleOptionViewItem_set_features},
    {const_cast<char *>("locale"), Sbk_QStyleOptionViewItem_get_locale, Sbk_QStyleOptionViewItem_set_locale},
    {const_cast<char *>("widget"), Sbk_QStyleOptionViewItem_get_widget, Sbk_QStyleOptionViewItem_set_widget},
    {const_cast<char *>("index"), Sbk_QStyleOptionViewItem_get_index, Sbk_QStyleOptionViewItem_set_index},
    {const_cast<char *>("checkState"), Sbk_QStyleOptionViewItem_get_checkState, Sbk_QStyleOptionViewItem_set_checkState},
    {const_cast<char *>("icon"), Sbk_QStyleOptionViewItem_get_icon, Sbk_QStyleOptionViewItem_set_icon},
    {const_cast<char *>("text"), Sbk_QStyleOptionViewItem_get_text, Sbk_QStyleOptionViewItem_set_text},
    {const_cast<char *>("viewItemPosition"), Sbk_QStyleOptionViewItem_get_viewItemPosition, Sbk_QStyleOptionViewItem_set_viewItemPosition},
    {const_cast<char *>("backgroundBrush"), Sbk_QStyleOptionViewItem_get_backgroundBrush, Sbk_QStyleOptionViewItem_set_backgroundBrush},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleOptionViewItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleOptionViewItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleOptionViewItem_Type = nullptr;
static SbkObjectType *Sbk_QStyleOptionViewItem_TypeF(void)
{
    return _Sbk_QStyleOptionViewItem_Type;
}

static PyType_Slot Sbk_QStyleOptionViewItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleOptionViewItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleOptionViewItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleOptionViewItem_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleOptionViewItem_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleOptionViewItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleOptionViewItem_spec = {
    "2:PySide2.QtWidgets.QStyleOptionViewItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleOptionViewItem_slots
};

} //extern "C"

PyObject *SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature___and__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionViewItem::ViewItemFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionViewItem::ViewItemFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionViewItem::ViewItemFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionViewItem::ViewItemFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionViewItem::ViewItemFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature___or__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionViewItem::ViewItemFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionViewItem::ViewItemFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionViewItem::ViewItemFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionViewItem::ViewItemFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionViewItem::ViewItemFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionViewItem::ViewItemFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionViewItem::ViewItemFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionViewItem::ViewItemFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionViewItem::ViewItemFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionViewItem::ViewItemFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionViewItem::ViewItemFeatures cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX])->converter, self, &cppSelf);
    ::QStyleOptionViewItem::ViewItemFeatures cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleOptionViewItem_StyleOptionType_PythonToCpp_QStyleOptionViewItem_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionViewItem::StyleOptionType *>(cppOut) =
        static_cast<::QStyleOptionViewItem::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionViewItem_StyleOptionType_PythonToCpp_QStyleOptionViewItem_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONTYPE_IDX]))
        return QStyleOptionViewItem_StyleOptionType_PythonToCpp_QStyleOptionViewItem_StyleOptionType;
    return {};
}
static PyObject *QStyleOptionViewItem_StyleOptionType_CppToPython_QStyleOptionViewItem_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionViewItem::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleOptionViewItem_StyleOptionVersion_PythonToCpp_QStyleOptionViewItem_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionViewItem::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleOptionViewItem::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionViewItem_StyleOptionVersion_PythonToCpp_QStyleOptionViewItem_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONVERSION_IDX]))
        return QStyleOptionViewItem_StyleOptionVersion_PythonToCpp_QStyleOptionViewItem_StyleOptionVersion;
    return {};
}
static PyObject *QStyleOptionViewItem_StyleOptionVersion_CppToPython_QStyleOptionViewItem_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionViewItem::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONVERSION_IDX], castCppIn);

}

static void QStyleOptionViewItem_Position_PythonToCpp_QStyleOptionViewItem_Position(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionViewItem::Position *>(cppOut) =
        static_cast<::QStyleOptionViewItem::Position>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionViewItem_Position_PythonToCpp_QStyleOptionViewItem_Position_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX]))
        return QStyleOptionViewItem_Position_PythonToCpp_QStyleOptionViewItem_Position;
    return {};
}
static PyObject *QStyleOptionViewItem_Position_CppToPython_QStyleOptionViewItem_Position(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionViewItem::Position *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX], castCppIn);

}

static void QStyleOptionViewItem_ViewItemFeature_PythonToCpp_QStyleOptionViewItem_ViewItemFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionViewItem::ViewItemFeature *>(cppOut) =
        static_cast<::QStyleOptionViewItem::ViewItemFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionViewItem_ViewItemFeature_PythonToCpp_QStyleOptionViewItem_ViewItemFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX]))
        return QStyleOptionViewItem_ViewItemFeature_PythonToCpp_QStyleOptionViewItem_ViewItemFeature;
    return {};
}
static PyObject *QStyleOptionViewItem_ViewItemFeature_CppToPython_QStyleOptionViewItem_ViewItemFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionViewItem::ViewItemFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX], castCppIn);

}

static void QFlags_QStyleOptionViewItem_ViewItemFeature__PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyleOptionViewItem::ViewItemFeature> *>(cppOut) =
        ::QFlags<QStyleOptionViewItem::ViewItemFeature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QStyleOptionViewItem_ViewItemFeature__PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX]))
        return QFlags_QStyleOptionViewItem_ViewItemFeature__PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature_;
    return {};
}
static PyObject *QFlags_QStyleOptionViewItem_ViewItemFeature__CppToPython_QFlags_QStyleOptionViewItem_ViewItemFeature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QStyleOptionViewItem::ViewItemFeature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX]));

}

static void QStyleOptionViewItem_ViewItemFeature_PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyleOptionViewItem::ViewItemFeature> *>(cppOut) =
        ::QFlags<QStyleOptionViewItem::ViewItemFeature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QStyleOptionViewItem_ViewItemFeature_PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX]))
        return QStyleOptionViewItem_ViewItemFeature_PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature_;
    return {};
}
static void number_PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QStyleOptionViewItem::ViewItemFeature> *>(cppOut) =
        ::QFlags<QStyleOptionViewItem::ViewItemFeature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX]))
        return number_PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature_;
    return {};
}
static void QStyleOptionViewItem_ViewItemPosition_PythonToCpp_QStyleOptionViewItem_ViewItemPosition(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionViewItem::ViewItemPosition *>(cppOut) =
        static_cast<::QStyleOptionViewItem::ViewItemPosition>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionViewItem_ViewItemPosition_PythonToCpp_QStyleOptionViewItem_ViewItemPosition_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMPOSITION_IDX]))
        return QStyleOptionViewItem_ViewItemPosition_PythonToCpp_QStyleOptionViewItem_ViewItemPosition;
    return {};
}
static PyObject *QStyleOptionViewItem_ViewItemPosition_CppToPython_QStyleOptionViewItem_ViewItemPosition(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionViewItem::ViewItemPosition *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMPOSITION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleOptionViewItem_PythonToCpp_QStyleOptionViewItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleOptionViewItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleOptionViewItem_PythonToCpp_QStyleOptionViewItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionViewItem_TypeF())))
        return QStyleOptionViewItem_PythonToCpp_QStyleOptionViewItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleOptionViewItem_PTR_CppToPython_QStyleOptionViewItem(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleOptionViewItem *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleOptionViewItem_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QStyleOptionViewItem_COPY_CppToPython_QStyleOptionViewItem(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QStyleOptionViewItem_TypeF(), new ::QStyleOptionViewItem(*reinterpret_cast<const ::QStyleOptionViewItem *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QStyleOptionViewItem_PythonToCpp_QStyleOptionViewItem_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionViewItem *>(cppOut) = *reinterpret_cast< ::QStyleOptionViewItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QStyleOptionViewItem_PythonToCpp_QStyleOptionViewItem_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionViewItem_TypeF())))
        return QStyleOptionViewItem_PythonToCpp_QStyleOptionViewItem_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleOptionViewItem_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QStyleOptionViewItem(self)",
    "1:PySide2.QtWidgets.QStyleOptionViewItem(self,other:PySide2.QtWidgets.QStyleOptionViewItem)",
    "0:PySide2.QtWidgets.QStyleOptionViewItem(self,version:int)",
    "PySide2.QtWidgets.QStyleOptionViewItem.__copy__()",
    nullptr}; // Sentinel

void init_QStyleOptionViewItem(PyObject *module)
{
    _Sbk_QStyleOptionViewItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleOptionViewItem",
        "QStyleOptionViewItem",
        &Sbk_QStyleOptionViewItem_spec,
        &Shiboken::callCppDestructor< ::QStyleOptionViewItem >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionViewItem_Type);
    InitSignatureStrings(pyType, QStyleOptionViewItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionViewItem_Type), Sbk_QStyleOptionViewItem_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionViewItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleOptionViewItem_TypeF(),
        QStyleOptionViewItem_PythonToCpp_QStyleOptionViewItem_PTR,
        is_QStyleOptionViewItem_PythonToCpp_QStyleOptionViewItem_PTR_Convertible,
        QStyleOptionViewItem_PTR_CppToPython_QStyleOptionViewItem,
        QStyleOptionViewItem_COPY_CppToPython_QStyleOptionViewItem);

    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionViewItem");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionViewItem*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionViewItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleOptionViewItem).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QStyleOptionViewItem_PythonToCpp_QStyleOptionViewItem_COPY,
        is_QStyleOptionViewItem_PythonToCpp_QStyleOptionViewItem_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionViewItem_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleOptionViewItem.StyleOptionType",
        "QStyleOptionViewItem::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "Type", (long) QStyleOptionViewItem::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleOptionViewItem::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONTYPE_IDX],
            QStyleOptionViewItem_StyleOptionType_CppToPython_QStyleOptionViewItem_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionViewItem_StyleOptionType_PythonToCpp_QStyleOptionViewItem_StyleOptionType,
            is_QStyleOptionViewItem_StyleOptionType_PythonToCpp_QStyleOptionViewItem_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionViewItem::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionViewItem_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleOptionViewItem.StyleOptionVersion",
        "QStyleOptionViewItem::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "Version", (long) QStyleOptionViewItem::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleOptionViewItem::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONVERSION_IDX],
            QStyleOptionViewItem_StyleOptionVersion_CppToPython_QStyleOptionViewItem_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionViewItem_StyleOptionVersion_PythonToCpp_QStyleOptionViewItem_StyleOptionVersion,
            is_QStyleOptionViewItem_StyleOptionVersion_PythonToCpp_QStyleOptionViewItem_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionViewItem::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    // Initialization of enum 'Position'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionViewItem_TypeF(),
        "Position",
        "2:PySide2.QtWidgets.QStyleOptionViewItem.Position",
        "QStyleOptionViewItem::Position");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "Left", (long) QStyleOptionViewItem::Position::Left))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "Right", (long) QStyleOptionViewItem::Position::Right))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "Top", (long) QStyleOptionViewItem::Position::Top))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "Bottom", (long) QStyleOptionViewItem::Position::Bottom))
        return;
    // Register converter for enum 'QStyleOptionViewItem::Position'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX],
            QStyleOptionViewItem_Position_CppToPython_QStyleOptionViewItem_Position);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionViewItem_Position_PythonToCpp_QStyleOptionViewItem_Position,
            is_QStyleOptionViewItem_Position_PythonToCpp_QStyleOptionViewItem_Position_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_POSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionViewItem::Position");
        Shiboken::Conversions::registerConverterName(converter, "Position");
    }
    // End of 'Position' enum.

    // Initialization of enum 'ViewItemFeature'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QStyleOptionViewItem.ViewItemFeatures", SbkPySide2_QtWidgets_QStyleOptionViewItem_ViewItemFeature_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionViewItem_TypeF(),
        "ViewItemFeature",
        "2:PySide2.QtWidgets.QStyleOptionViewItem.ViewItemFeature",
        "QStyleOptionViewItem::ViewItemFeature",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "None_", (long) QStyleOptionViewItem::ViewItemFeature::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "WrapText", (long) QStyleOptionViewItem::ViewItemFeature::WrapText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "Alternate", (long) QStyleOptionViewItem::ViewItemFeature::Alternate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "HasCheckIndicator", (long) QStyleOptionViewItem::ViewItemFeature::HasCheckIndicator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "HasDisplay", (long) QStyleOptionViewItem::ViewItemFeature::HasDisplay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "HasDecoration", (long) QStyleOptionViewItem::ViewItemFeature::HasDecoration))
        return;
    // Register converter for enum 'QStyleOptionViewItem::ViewItemFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX],
            QStyleOptionViewItem_ViewItemFeature_CppToPython_QStyleOptionViewItem_ViewItemFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionViewItem_ViewItemFeature_PythonToCpp_QStyleOptionViewItem_ViewItemFeature,
            is_QStyleOptionViewItem_ViewItemFeature_PythonToCpp_QStyleOptionViewItem_ViewItemFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionViewItem::ViewItemFeature");
        Shiboken::Conversions::registerConverterName(converter, "ViewItemFeature");
    }
    // Register converter for flag 'QFlags<QStyleOptionViewItem::ViewItemFeature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX],
            QFlags_QStyleOptionViewItem_ViewItemFeature__CppToPython_QFlags_QStyleOptionViewItem_ViewItemFeature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionViewItem_ViewItemFeature_PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature_,
            is_QStyleOptionViewItem_ViewItemFeature_PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QStyleOptionViewItem_ViewItemFeature__PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature_,
            is_QFlags_QStyleOptionViewItem_ViewItemFeature__PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature_,
            is_number_PythonToCpp_QFlags_QStyleOptionViewItem_ViewItemFeature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONVIEWITEM_VIEWITEMFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionViewItem::ViewItemFeatures");
        Shiboken::Conversions::registerConverterName(converter, "ViewItemFeatures");
    }
    // End of 'ViewItemFeature' enum/flags.

    // Initialization of enum 'ViewItemPosition'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMPOSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionViewItem_TypeF(),
        "ViewItemPosition",
        "2:PySide2.QtWidgets.QStyleOptionViewItem.ViewItemPosition",
        "QStyleOptionViewItem::ViewItemPosition");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMPOSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMPOSITION_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "Invalid", (long) QStyleOptionViewItem::ViewItemPosition::Invalid))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMPOSITION_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "Beginning", (long) QStyleOptionViewItem::ViewItemPosition::Beginning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMPOSITION_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "Middle", (long) QStyleOptionViewItem::ViewItemPosition::Middle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMPOSITION_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "End", (long) QStyleOptionViewItem::ViewItemPosition::End))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMPOSITION_IDX],
        Sbk_QStyleOptionViewItem_TypeF(), "OnlyOne", (long) QStyleOptionViewItem::ViewItemPosition::OnlyOne))
        return;
    // Register converter for enum 'QStyleOptionViewItem::ViewItemPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMPOSITION_IDX],
            QStyleOptionViewItem_ViewItemPosition_CppToPython_QStyleOptionViewItem_ViewItemPosition);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionViewItem_ViewItemPosition_PythonToCpp_QStyleOptionViewItem_ViewItemPosition,
            is_QStyleOptionViewItem_ViewItemPosition_PythonToCpp_QStyleOptionViewItem_ViewItemPosition_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONVIEWITEM_VIEWITEMPOSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionViewItem::ViewItemPosition");
        Shiboken::Conversions::registerConverterName(converter, "ViewItemPosition");
    }
    // End of 'ViewItemPosition' enum.

    qRegisterMetaType< ::QStyleOptionViewItem >("QStyleOptionViewItem");
    qRegisterMetaType< ::QStyleOptionViewItem::StyleOptionType >("QStyleOptionViewItem::StyleOptionType");
    qRegisterMetaType< ::QStyleOptionViewItem::StyleOptionVersion >("QStyleOptionViewItem::StyleOptionVersion");
    qRegisterMetaType< ::QStyleOptionViewItem::Position >("QStyleOptionViewItem::Position");
    qRegisterMetaType< ::QStyleOptionViewItem::ViewItemFeature >("QStyleOptionViewItem::ViewItemFeature");
    qRegisterMetaType< ::QStyleOptionViewItem::ViewItemFeatures >("QStyleOptionViewItem::ViewItemFeatures");
    qRegisterMetaType< ::QStyleOptionViewItem::ViewItemPosition >("QStyleOptionViewItem::ViewItemPosition");
}
