/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstyleoptiontoolbutton_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qstyleoption.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleOptionToolButton_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleOptionToolButton >()))
        return -1;

    ::QStyleOptionToolButton *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleOptionToolButton.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStyleOptionToolButton", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStyleOptionToolButton::QStyleOptionToolButton()
    // 1: QStyleOptionToolButton::QStyleOptionToolButton(QStyleOptionToolButton)
    // 2: QStyleOptionToolButton::QStyleOptionToolButton(int)
    if (numArgs == 0) {
        overloadId = 0; // QStyleOptionToolButton()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // QStyleOptionToolButton(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStyleOptionToolButton(QStyleOptionToolButton)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleOptionToolButton_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStyleOptionToolButton()
        {

            if (!PyErr_Occurred()) {
                // QStyleOptionToolButton()
                cptr = new ::QStyleOptionToolButton();
            }
            break;
        }
        case 1: // QStyleOptionToolButton(const QStyleOptionToolButton & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStyleOptionToolButton *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionToolButton(QStyleOptionToolButton)
                cptr = new ::QStyleOptionToolButton(*cppArg0);
            }
            break;
        }
        case 2: // QStyleOptionToolButton(int version)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionToolButton(int)
                cptr = new ::QStyleOptionToolButton(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleOptionToolButton >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStyleOptionToolButton_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStyleOptionToolButton_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QStyleOptionToolButton_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleOptionToolButton_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleOptionToolButton_get_features(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX])->converter, &cppSelf->features);
    return pyOut;
}
static int Sbk_QStyleOptionToolButton_set_features(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'features' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'features', 'ToolButtonFeatures' or convertible type expected");
        return -1;
    }

    ::QFlags<QStyleOptionToolButton::ToolButtonFeature> cppOut_local = cppSelf->features;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->features = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionToolButton_get_icon(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->icon)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->icon))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->icon)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &(cppSelf->icon), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionToolButton_set_icon(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'icon' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'icon', 'QIcon' or convertible type expected");
        return -1;
    }

    ::QIcon& cppOut_ptr = cppSelf->icon;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionToolButton_get_iconSize(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->iconSize)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->iconSize))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->iconSize)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &(cppSelf->iconSize), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionToolButton_set_iconSize(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'iconSize' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'iconSize', 'QSize' or convertible type expected");
        return -1;
    }

    ::QSize& cppOut_ptr = cppSelf->iconSize;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionToolButton_get_text(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->text);
    return pyOut;
}
static int Sbk_QStyleOptionToolButton_set_text(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'text' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'text', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->text;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionToolButton_get_arrowType(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::Qt::ArrowType cppOut_local = cppSelf->arrowType;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ARROWTYPE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionToolButton_set_arrowType(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'arrowType' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ARROWTYPE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'arrowType', 'ArrowType' or convertible type expected");
        return -1;
    }

    ::Qt::ArrowType cppOut_local = cppSelf->arrowType;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->arrowType = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionToolButton_get_toolButtonStyle(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::Qt::ToolButtonStyle cppOut_local = cppSelf->toolButtonStyle;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionToolButton_set_toolButtonStyle(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'toolButtonStyle' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBUTTONSTYLE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'toolButtonStyle', 'ToolButtonStyle' or convertible type expected");
        return -1;
    }

    ::Qt::ToolButtonStyle cppOut_local = cppSelf->toolButtonStyle;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->toolButtonStyle = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionToolButton_get_pos(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->pos)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->pos))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->pos)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &(cppSelf->pos), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionToolButton_set_pos(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'pos' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'pos', 'QPoint' or convertible type expected");
        return -1;
    }

    ::QPoint& cppOut_ptr = cppSelf->pos;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionToolButton_get_font(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->font)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->font))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->font)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &(cppSelf->font), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionToolButton_set_font(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolButton *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'font' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'font', 'QFont' or convertible type expected");
        return -1;
    }

    ::QFont& cppOut_ptr = cppSelf->font;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for QStyleOptionToolButton
static PyGetSetDef Sbk_QStyleOptionToolButton_getsetlist[] = {
    {const_cast<char *>("features"), Sbk_QStyleOptionToolButton_get_features, Sbk_QStyleOptionToolButton_set_features},
    {const_cast<char *>("icon"), Sbk_QStyleOptionToolButton_get_icon, Sbk_QStyleOptionToolButton_set_icon},
    {const_cast<char *>("iconSize"), Sbk_QStyleOptionToolButton_get_iconSize, Sbk_QStyleOptionToolButton_set_iconSize},
    {const_cast<char *>("text"), Sbk_QStyleOptionToolButton_get_text, Sbk_QStyleOptionToolButton_set_text},
    {const_cast<char *>("arrowType"), Sbk_QStyleOptionToolButton_get_arrowType, Sbk_QStyleOptionToolButton_set_arrowType},
    {const_cast<char *>("toolButtonStyle"), Sbk_QStyleOptionToolButton_get_toolButtonStyle, Sbk_QStyleOptionToolButton_set_toolButtonStyle},
    {const_cast<char *>("pos"), Sbk_QStyleOptionToolButton_get_pos, Sbk_QStyleOptionToolButton_set_pos},
    {const_cast<char *>("font"), Sbk_QStyleOptionToolButton_get_font, Sbk_QStyleOptionToolButton_set_font},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleOptionToolButton_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleOptionToolButton_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleOptionToolButton_Type = nullptr;
static SbkObjectType *Sbk_QStyleOptionToolButton_TypeF(void)
{
    return _Sbk_QStyleOptionToolButton_Type;
}

static PyType_Slot Sbk_QStyleOptionToolButton_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleOptionToolButton_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleOptionToolButton_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleOptionToolButton_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleOptionToolButton_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleOptionToolButton_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleOptionToolButton_spec = {
    "2:PySide2.QtWidgets.QStyleOptionToolButton",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleOptionToolButton_slots
};

} //extern "C"

PyObject *SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature___and__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionToolButton::ToolButtonFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionToolButton::ToolButtonFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionToolButton::ToolButtonFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionToolButton::ToolButtonFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionToolButton::ToolButtonFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature___or__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionToolButton::ToolButtonFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionToolButton::ToolButtonFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionToolButton::ToolButtonFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionToolButton::ToolButtonFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionToolButton::ToolButtonFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionToolButton::ToolButtonFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionToolButton::ToolButtonFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionToolButton::ToolButtonFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionToolButton::ToolButtonFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionToolButton::ToolButtonFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionToolButton::ToolButtonFeatures cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX])->converter, self, &cppSelf);
    ::QStyleOptionToolButton::ToolButtonFeatures cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleOptionToolButton_StyleOptionType_PythonToCpp_QStyleOptionToolButton_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionToolButton::StyleOptionType *>(cppOut) =
        static_cast<::QStyleOptionToolButton::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionToolButton_StyleOptionType_PythonToCpp_QStyleOptionToolButton_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONTYPE_IDX]))
        return QStyleOptionToolButton_StyleOptionType_PythonToCpp_QStyleOptionToolButton_StyleOptionType;
    return {};
}
static PyObject *QStyleOptionToolButton_StyleOptionType_CppToPython_QStyleOptionToolButton_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionToolButton::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleOptionToolButton_StyleOptionVersion_PythonToCpp_QStyleOptionToolButton_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionToolButton::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleOptionToolButton::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionToolButton_StyleOptionVersion_PythonToCpp_QStyleOptionToolButton_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONVERSION_IDX]))
        return QStyleOptionToolButton_StyleOptionVersion_PythonToCpp_QStyleOptionToolButton_StyleOptionVersion;
    return {};
}
static PyObject *QStyleOptionToolButton_StyleOptionVersion_CppToPython_QStyleOptionToolButton_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionToolButton::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONVERSION_IDX], castCppIn);

}

static void QStyleOptionToolButton_ToolButtonFeature_PythonToCpp_QStyleOptionToolButton_ToolButtonFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionToolButton::ToolButtonFeature *>(cppOut) =
        static_cast<::QStyleOptionToolButton::ToolButtonFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionToolButton_ToolButtonFeature_PythonToCpp_QStyleOptionToolButton_ToolButtonFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX]))
        return QStyleOptionToolButton_ToolButtonFeature_PythonToCpp_QStyleOptionToolButton_ToolButtonFeature;
    return {};
}
static PyObject *QStyleOptionToolButton_ToolButtonFeature_CppToPython_QStyleOptionToolButton_ToolButtonFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionToolButton::ToolButtonFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX], castCppIn);

}

static void QFlags_QStyleOptionToolButton_ToolButtonFeature__PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyleOptionToolButton::ToolButtonFeature> *>(cppOut) =
        ::QFlags<QStyleOptionToolButton::ToolButtonFeature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QStyleOptionToolButton_ToolButtonFeature__PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX]))
        return QFlags_QStyleOptionToolButton_ToolButtonFeature__PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature_;
    return {};
}
static PyObject *QFlags_QStyleOptionToolButton_ToolButtonFeature__CppToPython_QFlags_QStyleOptionToolButton_ToolButtonFeature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QStyleOptionToolButton::ToolButtonFeature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX]));

}

static void QStyleOptionToolButton_ToolButtonFeature_PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyleOptionToolButton::ToolButtonFeature> *>(cppOut) =
        ::QFlags<QStyleOptionToolButton::ToolButtonFeature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QStyleOptionToolButton_ToolButtonFeature_PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX]))
        return QStyleOptionToolButton_ToolButtonFeature_PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature_;
    return {};
}
static void number_PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QStyleOptionToolButton::ToolButtonFeature> *>(cppOut) =
        ::QFlags<QStyleOptionToolButton::ToolButtonFeature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX]))
        return number_PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleOptionToolButton_PythonToCpp_QStyleOptionToolButton_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleOptionToolButton_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleOptionToolButton_PythonToCpp_QStyleOptionToolButton_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionToolButton_TypeF())))
        return QStyleOptionToolButton_PythonToCpp_QStyleOptionToolButton_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleOptionToolButton_PTR_CppToPython_QStyleOptionToolButton(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleOptionToolButton *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleOptionToolButton_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleOptionToolButton_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QStyleOptionToolButton(self)",
    "1:PySide2.QtWidgets.QStyleOptionToolButton(self,other:PySide2.QtWidgets.QStyleOptionToolButton)",
    "0:PySide2.QtWidgets.QStyleOptionToolButton(self,version:int)",
    nullptr}; // Sentinel

void init_QStyleOptionToolButton(PyObject *module)
{
    _Sbk_QStyleOptionToolButton_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleOptionToolButton",
        "QStyleOptionToolButton*",
        &Sbk_QStyleOptionToolButton_spec,
        &Shiboken::callCppDestructor< ::QStyleOptionToolButton >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionToolButton_Type);
    InitSignatureStrings(pyType, QStyleOptionToolButton_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionToolButton_Type), Sbk_QStyleOptionToolButton_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionToolButton_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleOptionToolButton_TypeF(),
        QStyleOptionToolButton_PythonToCpp_QStyleOptionToolButton_PTR,
        is_QStyleOptionToolButton_PythonToCpp_QStyleOptionToolButton_PTR_Convertible,
        QStyleOptionToolButton_PTR_CppToPython_QStyleOptionToolButton);

    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolButton");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolButton*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolButton&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleOptionToolButton).name());


    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionToolButton_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleOptionToolButton.StyleOptionType",
        "QStyleOptionToolButton::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleOptionToolButton_TypeF(), "Type", (long) QStyleOptionToolButton::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleOptionToolButton::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONTYPE_IDX],
            QStyleOptionToolButton_StyleOptionType_CppToPython_QStyleOptionToolButton_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionToolButton_StyleOptionType_PythonToCpp_QStyleOptionToolButton_StyleOptionType,
            is_QStyleOptionToolButton_StyleOptionType_PythonToCpp_QStyleOptionToolButton_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolButton::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionToolButton_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleOptionToolButton.StyleOptionVersion",
        "QStyleOptionToolButton::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleOptionToolButton_TypeF(), "Version", (long) QStyleOptionToolButton::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleOptionToolButton::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONVERSION_IDX],
            QStyleOptionToolButton_StyleOptionVersion_CppToPython_QStyleOptionToolButton_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionToolButton_StyleOptionVersion_PythonToCpp_QStyleOptionToolButton_StyleOptionVersion,
            is_QStyleOptionToolButton_StyleOptionVersion_PythonToCpp_QStyleOptionToolButton_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolButton::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    // Initialization of enum 'ToolButtonFeature'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QStyleOptionToolButton.ToolButtonFeatures", SbkPySide2_QtWidgets_QStyleOptionToolButton_ToolButtonFeature_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionToolButton_TypeF(),
        "ToolButtonFeature",
        "2:PySide2.QtWidgets.QStyleOptionToolButton.ToolButtonFeature",
        "QStyleOptionToolButton::ToolButtonFeature",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX],
        Sbk_QStyleOptionToolButton_TypeF(), "None_", (long) QStyleOptionToolButton::ToolButtonFeature::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX],
        Sbk_QStyleOptionToolButton_TypeF(), "Arrow", (long) QStyleOptionToolButton::ToolButtonFeature::Arrow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX],
        Sbk_QStyleOptionToolButton_TypeF(), "Menu", (long) QStyleOptionToolButton::ToolButtonFeature::Menu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX],
        Sbk_QStyleOptionToolButton_TypeF(), "MenuButtonPopup", (long) QStyleOptionToolButton::ToolButtonFeature::MenuButtonPopup))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX],
        Sbk_QStyleOptionToolButton_TypeF(), "PopupDelay", (long) QStyleOptionToolButton::ToolButtonFeature::PopupDelay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX],
        Sbk_QStyleOptionToolButton_TypeF(), "HasMenu", (long) QStyleOptionToolButton::ToolButtonFeature::HasMenu))
        return;
    // Register converter for enum 'QStyleOptionToolButton::ToolButtonFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX],
            QStyleOptionToolButton_ToolButtonFeature_CppToPython_QStyleOptionToolButton_ToolButtonFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionToolButton_ToolButtonFeature_PythonToCpp_QStyleOptionToolButton_ToolButtonFeature,
            is_QStyleOptionToolButton_ToolButtonFeature_PythonToCpp_QStyleOptionToolButton_ToolButtonFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolButton::ToolButtonFeature");
        Shiboken::Conversions::registerConverterName(converter, "ToolButtonFeature");
    }
    // Register converter for flag 'QFlags<QStyleOptionToolButton::ToolButtonFeature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX],
            QFlags_QStyleOptionToolButton_ToolButtonFeature__CppToPython_QFlags_QStyleOptionToolButton_ToolButtonFeature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionToolButton_ToolButtonFeature_PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature_,
            is_QStyleOptionToolButton_ToolButtonFeature_PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QStyleOptionToolButton_ToolButtonFeature__PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature_,
            is_QFlags_QStyleOptionToolButton_ToolButtonFeature__PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature_,
            is_number_PythonToCpp_QFlags_QStyleOptionToolButton_ToolButtonFeature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBUTTON_TOOLBUTTONFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolButton::ToolButtonFeatures");
        Shiboken::Conversions::registerConverterName(converter, "ToolButtonFeatures");
    }
    // End of 'ToolButtonFeature' enum/flags.

    qRegisterMetaType< ::QStyleOptionToolButton::StyleOptionType >("QStyleOptionToolButton::StyleOptionType");
    qRegisterMetaType< ::QStyleOptionToolButton::StyleOptionVersion >("QStyleOptionToolButton::StyleOptionVersion");
    qRegisterMetaType< ::QStyleOptionToolButton::ToolButtonFeature >("QStyleOptionToolButton::ToolButtonFeature");
    qRegisterMetaType< ::QStyleOptionToolButton::ToolButtonFeatures >("QStyleOptionToolButton::ToolButtonFeatures");
}
