/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstyleoptiontoolbox_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qstyleoption.h>
#include <QtWidgets/qwidget.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleOptionToolBox_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleOptionToolBox >()))
        return -1;

    ::QStyleOptionToolBox *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleOptionToolBox.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStyleOptionToolBox", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStyleOptionToolBox::QStyleOptionToolBox()
    // 1: QStyleOptionToolBox::QStyleOptionToolBox(QStyleOptionToolBox)
    // 2: QStyleOptionToolBox::QStyleOptionToolBox(int)
    if (numArgs == 0) {
        overloadId = 0; // QStyleOptionToolBox()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // QStyleOptionToolBox(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStyleOptionToolBox(QStyleOptionToolBox)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleOptionToolBox_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStyleOptionToolBox()
        {

            if (!PyErr_Occurred()) {
                // QStyleOptionToolBox()
                cptr = new ::QStyleOptionToolBox();
            }
            break;
        }
        case 1: // QStyleOptionToolBox(const QStyleOptionToolBox & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStyleOptionToolBox *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionToolBox(QStyleOptionToolBox)
                cptr = new ::QStyleOptionToolBox(*cppArg0);
            }
            break;
        }
        case 2: // QStyleOptionToolBox(int version)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionToolBox(int)
                cptr = new ::QStyleOptionToolBox(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleOptionToolBox >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStyleOptionToolBox_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStyleOptionToolBox_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QStyleOptionToolBox_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleOptionToolBox_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleOptionToolBox_get_text(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->text);
    return pyOut;
}
static int Sbk_QStyleOptionToolBox_set_text(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'text' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'text', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->text;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionToolBox_get_icon(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->icon)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->icon))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->icon)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &(cppSelf->icon), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionToolBox_set_icon(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'icon' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'icon', 'QIcon' or convertible type expected");
        return -1;
    }

    ::QIcon& cppOut_ptr = cppSelf->icon;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionToolBox_get_position(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QStyleOptionToolBox::TabPosition cppOut_local = cppSelf->position;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_TABPOSITION_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionToolBox_set_position(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'position' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_TABPOSITION_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'position', 'TabPosition' or convertible type expected");
        return -1;
    }

    ::QStyleOptionToolBox::TabPosition cppOut_local = cppSelf->position;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->position = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionToolBox_get_selectedPosition(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QStyleOptionToolBox::SelectedPosition cppOut_local = cppSelf->selectedPosition;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_SELECTEDPOSITION_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionToolBox_set_selectedPosition(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBox *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'selectedPosition' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_SELECTEDPOSITION_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'selectedPosition', 'SelectedPosition' or convertible type expected");
        return -1;
    }

    ::QStyleOptionToolBox::SelectedPosition cppOut_local = cppSelf->selectedPosition;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->selectedPosition = cppOut_local;

    return 0;
}

// Getters and Setters for QStyleOptionToolBox
static PyGetSetDef Sbk_QStyleOptionToolBox_getsetlist[] = {
    {const_cast<char *>("text"), Sbk_QStyleOptionToolBox_get_text, Sbk_QStyleOptionToolBox_set_text},
    {const_cast<char *>("icon"), Sbk_QStyleOptionToolBox_get_icon, Sbk_QStyleOptionToolBox_set_icon},
    {const_cast<char *>("position"), Sbk_QStyleOptionToolBox_get_position, Sbk_QStyleOptionToolBox_set_position},
    {const_cast<char *>("selectedPosition"), Sbk_QStyleOptionToolBox_get_selectedPosition, Sbk_QStyleOptionToolBox_set_selectedPosition},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleOptionToolBox_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleOptionToolBox_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleOptionToolBox_Type = nullptr;
static SbkObjectType *Sbk_QStyleOptionToolBox_TypeF(void)
{
    return _Sbk_QStyleOptionToolBox_Type;
}

static PyType_Slot Sbk_QStyleOptionToolBox_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleOptionToolBox_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleOptionToolBox_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleOptionToolBox_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleOptionToolBox_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleOptionToolBox_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleOptionToolBox_spec = {
    "2:PySide2.QtWidgets.QStyleOptionToolBox",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleOptionToolBox_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleOptionToolBox_StyleOptionType_PythonToCpp_QStyleOptionToolBox_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionToolBox::StyleOptionType *>(cppOut) =
        static_cast<::QStyleOptionToolBox::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionToolBox_StyleOptionType_PythonToCpp_QStyleOptionToolBox_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONTYPE_IDX]))
        return QStyleOptionToolBox_StyleOptionType_PythonToCpp_QStyleOptionToolBox_StyleOptionType;
    return {};
}
static PyObject *QStyleOptionToolBox_StyleOptionType_CppToPython_QStyleOptionToolBox_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionToolBox::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleOptionToolBox_StyleOptionVersion_PythonToCpp_QStyleOptionToolBox_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionToolBox::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleOptionToolBox::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionToolBox_StyleOptionVersion_PythonToCpp_QStyleOptionToolBox_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONVERSION_IDX]))
        return QStyleOptionToolBox_StyleOptionVersion_PythonToCpp_QStyleOptionToolBox_StyleOptionVersion;
    return {};
}
static PyObject *QStyleOptionToolBox_StyleOptionVersion_CppToPython_QStyleOptionToolBox_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionToolBox::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONVERSION_IDX], castCppIn);

}

static void QStyleOptionToolBox_TabPosition_PythonToCpp_QStyleOptionToolBox_TabPosition(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionToolBox::TabPosition *>(cppOut) =
        static_cast<::QStyleOptionToolBox::TabPosition>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionToolBox_TabPosition_PythonToCpp_QStyleOptionToolBox_TabPosition_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_TABPOSITION_IDX]))
        return QStyleOptionToolBox_TabPosition_PythonToCpp_QStyleOptionToolBox_TabPosition;
    return {};
}
static PyObject *QStyleOptionToolBox_TabPosition_CppToPython_QStyleOptionToolBox_TabPosition(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionToolBox::TabPosition *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_TABPOSITION_IDX], castCppIn);

}

static void QStyleOptionToolBox_SelectedPosition_PythonToCpp_QStyleOptionToolBox_SelectedPosition(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionToolBox::SelectedPosition *>(cppOut) =
        static_cast<::QStyleOptionToolBox::SelectedPosition>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionToolBox_SelectedPosition_PythonToCpp_QStyleOptionToolBox_SelectedPosition_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_SELECTEDPOSITION_IDX]))
        return QStyleOptionToolBox_SelectedPosition_PythonToCpp_QStyleOptionToolBox_SelectedPosition;
    return {};
}
static PyObject *QStyleOptionToolBox_SelectedPosition_CppToPython_QStyleOptionToolBox_SelectedPosition(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionToolBox::SelectedPosition *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_SELECTEDPOSITION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleOptionToolBox_PythonToCpp_QStyleOptionToolBox_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleOptionToolBox_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleOptionToolBox_PythonToCpp_QStyleOptionToolBox_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionToolBox_TypeF())))
        return QStyleOptionToolBox_PythonToCpp_QStyleOptionToolBox_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleOptionToolBox_PTR_CppToPython_QStyleOptionToolBox(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleOptionToolBox *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleOptionToolBox_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleOptionToolBox_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QStyleOptionToolBox(self)",
    "1:PySide2.QtWidgets.QStyleOptionToolBox(self,other:PySide2.QtWidgets.QStyleOptionToolBox)",
    "0:PySide2.QtWidgets.QStyleOptionToolBox(self,version:int)",
    nullptr}; // Sentinel

void init_QStyleOptionToolBox(PyObject *module)
{
    _Sbk_QStyleOptionToolBox_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleOptionToolBox",
        "QStyleOptionToolBox*",
        &Sbk_QStyleOptionToolBox_spec,
        &Shiboken::callCppDestructor< ::QStyleOptionToolBox >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionToolBox_Type);
    InitSignatureStrings(pyType, QStyleOptionToolBox_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionToolBox_Type), Sbk_QStyleOptionToolBox_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionToolBox_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleOptionToolBox_TypeF(),
        QStyleOptionToolBox_PythonToCpp_QStyleOptionToolBox_PTR,
        is_QStyleOptionToolBox_PythonToCpp_QStyleOptionToolBox_PTR_Convertible,
        QStyleOptionToolBox_PTR_CppToPython_QStyleOptionToolBox);

    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBox");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBox*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBox&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleOptionToolBox).name());


    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionToolBox_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleOptionToolBox.StyleOptionType",
        "QStyleOptionToolBox::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleOptionToolBox_TypeF(), "Type", (long) QStyleOptionToolBox::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleOptionToolBox::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONTYPE_IDX],
            QStyleOptionToolBox_StyleOptionType_CppToPython_QStyleOptionToolBox_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionToolBox_StyleOptionType_PythonToCpp_QStyleOptionToolBox_StyleOptionType,
            is_QStyleOptionToolBox_StyleOptionType_PythonToCpp_QStyleOptionToolBox_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBox::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionToolBox_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleOptionToolBox.StyleOptionVersion",
        "QStyleOptionToolBox::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleOptionToolBox_TypeF(), "Version", (long) QStyleOptionToolBox::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleOptionToolBox::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONVERSION_IDX],
            QStyleOptionToolBox_StyleOptionVersion_CppToPython_QStyleOptionToolBox_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionToolBox_StyleOptionVersion_PythonToCpp_QStyleOptionToolBox_StyleOptionVersion,
            is_QStyleOptionToolBox_StyleOptionVersion_PythonToCpp_QStyleOptionToolBox_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBox::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    // Initialization of enum 'TabPosition'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_TABPOSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionToolBox_TypeF(),
        "TabPosition",
        "2:PySide2.QtWidgets.QStyleOptionToolBox.TabPosition",
        "QStyleOptionToolBox::TabPosition");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_TABPOSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_TABPOSITION_IDX],
        Sbk_QStyleOptionToolBox_TypeF(), "Beginning", (long) QStyleOptionToolBox::TabPosition::Beginning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_TABPOSITION_IDX],
        Sbk_QStyleOptionToolBox_TypeF(), "Middle", (long) QStyleOptionToolBox::TabPosition::Middle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_TABPOSITION_IDX],
        Sbk_QStyleOptionToolBox_TypeF(), "End", (long) QStyleOptionToolBox::TabPosition::End))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_TABPOSITION_IDX],
        Sbk_QStyleOptionToolBox_TypeF(), "OnlyOneTab", (long) QStyleOptionToolBox::TabPosition::OnlyOneTab))
        return;
    // Register converter for enum 'QStyleOptionToolBox::TabPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_TABPOSITION_IDX],
            QStyleOptionToolBox_TabPosition_CppToPython_QStyleOptionToolBox_TabPosition);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionToolBox_TabPosition_PythonToCpp_QStyleOptionToolBox_TabPosition,
            is_QStyleOptionToolBox_TabPosition_PythonToCpp_QStyleOptionToolBox_TabPosition_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_TABPOSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBox::TabPosition");
        Shiboken::Conversions::registerConverterName(converter, "TabPosition");
    }
    // End of 'TabPosition' enum.

    // Initialization of enum 'SelectedPosition'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_SELECTEDPOSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionToolBox_TypeF(),
        "SelectedPosition",
        "2:PySide2.QtWidgets.QStyleOptionToolBox.SelectedPosition",
        "QStyleOptionToolBox::SelectedPosition");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_SELECTEDPOSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_SELECTEDPOSITION_IDX],
        Sbk_QStyleOptionToolBox_TypeF(), "NotAdjacent", (long) QStyleOptionToolBox::SelectedPosition::NotAdjacent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_SELECTEDPOSITION_IDX],
        Sbk_QStyleOptionToolBox_TypeF(), "NextIsSelected", (long) QStyleOptionToolBox::SelectedPosition::NextIsSelected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_SELECTEDPOSITION_IDX],
        Sbk_QStyleOptionToolBox_TypeF(), "PreviousIsSelected", (long) QStyleOptionToolBox::SelectedPosition::PreviousIsSelected))
        return;
    // Register converter for enum 'QStyleOptionToolBox::SelectedPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_SELECTEDPOSITION_IDX],
            QStyleOptionToolBox_SelectedPosition_CppToPython_QStyleOptionToolBox_SelectedPosition);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionToolBox_SelectedPosition_PythonToCpp_QStyleOptionToolBox_SelectedPosition,
            is_QStyleOptionToolBox_SelectedPosition_PythonToCpp_QStyleOptionToolBox_SelectedPosition_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBOX_SELECTEDPOSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBox::SelectedPosition");
        Shiboken::Conversions::registerConverterName(converter, "SelectedPosition");
    }
    // End of 'SelectedPosition' enum.

    qRegisterMetaType< ::QStyleOptionToolBox::StyleOptionType >("QStyleOptionToolBox::StyleOptionType");
    qRegisterMetaType< ::QStyleOptionToolBox::StyleOptionVersion >("QStyleOptionToolBox::StyleOptionVersion");
    qRegisterMetaType< ::QStyleOptionToolBox::TabPosition >("QStyleOptionToolBox::TabPosition");
    qRegisterMetaType< ::QStyleOptionToolBox::SelectedPosition >("QStyleOptionToolBox::SelectedPosition");
}
