/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstyleoptiontoolbar_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qstyleoption.h>
#include <QtWidgets/qwidget.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleOptionToolBar_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleOptionToolBar >()))
        return -1;

    ::QStyleOptionToolBar *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleOptionToolBar.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStyleOptionToolBar", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStyleOptionToolBar::QStyleOptionToolBar()
    // 1: QStyleOptionToolBar::QStyleOptionToolBar(QStyleOptionToolBar)
    // 2: QStyleOptionToolBar::QStyleOptionToolBar(int)
    if (numArgs == 0) {
        overloadId = 0; // QStyleOptionToolBar()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // QStyleOptionToolBar(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStyleOptionToolBar(QStyleOptionToolBar)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleOptionToolBar_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStyleOptionToolBar()
        {

            if (!PyErr_Occurred()) {
                // QStyleOptionToolBar()
                cptr = new ::QStyleOptionToolBar();
            }
            break;
        }
        case 1: // QStyleOptionToolBar(const QStyleOptionToolBar & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStyleOptionToolBar *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionToolBar(QStyleOptionToolBar)
                cptr = new ::QStyleOptionToolBar(*cppArg0);
            }
            break;
        }
        case 2: // QStyleOptionToolBar(int version)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionToolBar(int)
                cptr = new ::QStyleOptionToolBar(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleOptionToolBar >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStyleOptionToolBar_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStyleOptionToolBar_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QStyleOptionToolBar_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleOptionToolBar_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleOptionToolBar_get_positionOfLine(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QStyleOptionToolBar::ToolBarPosition cppOut_local = cppSelf->positionOfLine;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionToolBar_set_positionOfLine(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'positionOfLine' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'positionOfLine', 'ToolBarPosition' or convertible type expected");
        return -1;
    }

    ::QStyleOptionToolBar::ToolBarPosition cppOut_local = cppSelf->positionOfLine;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->positionOfLine = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionToolBar_get_positionWithinLine(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QStyleOptionToolBar::ToolBarPosition cppOut_local = cppSelf->positionWithinLine;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionToolBar_set_positionWithinLine(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'positionWithinLine' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'positionWithinLine', 'ToolBarPosition' or convertible type expected");
        return -1;
    }

    ::QStyleOptionToolBar::ToolBarPosition cppOut_local = cppSelf->positionWithinLine;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->positionWithinLine = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionToolBar_get_toolBarArea(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::Qt::ToolBarArea cppOut_local = cppSelf->toolBarArea;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionToolBar_set_toolBarArea(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'toolBarArea' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_TOOLBARAREA_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'toolBarArea', 'ToolBarArea' or convertible type expected");
        return -1;
    }

    ::Qt::ToolBarArea cppOut_local = cppSelf->toolBarArea;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->toolBarArea = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionToolBar_get_features(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX])->converter, &cppSelf->features);
    return pyOut;
}
static int Sbk_QStyleOptionToolBar_set_features(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'features' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'features', 'ToolBarFeatures' or convertible type expected");
        return -1;
    }

    ::QFlags<QStyleOptionToolBar::ToolBarFeature> cppOut_local = cppSelf->features;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->features = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionToolBar_get_lineWidth(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->lineWidth;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionToolBar_set_lineWidth(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'lineWidth' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'lineWidth', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->lineWidth;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->lineWidth = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionToolBar_get_midLineWidth(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->midLineWidth;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionToolBar_set_midLineWidth(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionToolBar *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'midLineWidth' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'midLineWidth', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->midLineWidth;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->midLineWidth = cppOut_local;

    return 0;
}

// Getters and Setters for QStyleOptionToolBar
static PyGetSetDef Sbk_QStyleOptionToolBar_getsetlist[] = {
    {const_cast<char *>("positionOfLine"), Sbk_QStyleOptionToolBar_get_positionOfLine, Sbk_QStyleOptionToolBar_set_positionOfLine},
    {const_cast<char *>("positionWithinLine"), Sbk_QStyleOptionToolBar_get_positionWithinLine, Sbk_QStyleOptionToolBar_set_positionWithinLine},
    {const_cast<char *>("toolBarArea"), Sbk_QStyleOptionToolBar_get_toolBarArea, Sbk_QStyleOptionToolBar_set_toolBarArea},
    {const_cast<char *>("features"), Sbk_QStyleOptionToolBar_get_features, Sbk_QStyleOptionToolBar_set_features},
    {const_cast<char *>("lineWidth"), Sbk_QStyleOptionToolBar_get_lineWidth, Sbk_QStyleOptionToolBar_set_lineWidth},
    {const_cast<char *>("midLineWidth"), Sbk_QStyleOptionToolBar_get_midLineWidth, Sbk_QStyleOptionToolBar_set_midLineWidth},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleOptionToolBar_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleOptionToolBar_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleOptionToolBar_Type = nullptr;
static SbkObjectType *Sbk_QStyleOptionToolBar_TypeF(void)
{
    return _Sbk_QStyleOptionToolBar_Type;
}

static PyType_Slot Sbk_QStyleOptionToolBar_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleOptionToolBar_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleOptionToolBar_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleOptionToolBar_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleOptionToolBar_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleOptionToolBar_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleOptionToolBar_spec = {
    "2:PySide2.QtWidgets.QStyleOptionToolBar",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleOptionToolBar_slots
};

} //extern "C"

PyObject *SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature___and__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionToolBar::ToolBarFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionToolBar::ToolBarFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionToolBar::ToolBarFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionToolBar::ToolBarFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionToolBar::ToolBarFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature___or__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionToolBar::ToolBarFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionToolBar::ToolBarFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionToolBar::ToolBarFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionToolBar::ToolBarFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionToolBar::ToolBarFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature___xor__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionToolBar::ToolBarFeatures cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyleOptionToolBar::ToolBarFeatures>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyleOptionToolBar::ToolBarFeatures>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyleOptionToolBar::ToolBarFeatures>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyleOptionToolBar::ToolBarFeatures>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature___invert__(PyObject *self, PyObject *pyArg)
{
    ::QStyleOptionToolBar::ToolBarFeatures cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX])->converter, self, &cppSelf);
    ::QStyleOptionToolBar::ToolBarFeatures cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleOptionToolBar_StyleOptionType_PythonToCpp_QStyleOptionToolBar_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionToolBar::StyleOptionType *>(cppOut) =
        static_cast<::QStyleOptionToolBar::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionToolBar_StyleOptionType_PythonToCpp_QStyleOptionToolBar_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONTYPE_IDX]))
        return QStyleOptionToolBar_StyleOptionType_PythonToCpp_QStyleOptionToolBar_StyleOptionType;
    return {};
}
static PyObject *QStyleOptionToolBar_StyleOptionType_CppToPython_QStyleOptionToolBar_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionToolBar::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleOptionToolBar_StyleOptionVersion_PythonToCpp_QStyleOptionToolBar_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionToolBar::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleOptionToolBar::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionToolBar_StyleOptionVersion_PythonToCpp_QStyleOptionToolBar_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONVERSION_IDX]))
        return QStyleOptionToolBar_StyleOptionVersion_PythonToCpp_QStyleOptionToolBar_StyleOptionVersion;
    return {};
}
static PyObject *QStyleOptionToolBar_StyleOptionVersion_CppToPython_QStyleOptionToolBar_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionToolBar::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONVERSION_IDX], castCppIn);

}

static void QStyleOptionToolBar_ToolBarPosition_PythonToCpp_QStyleOptionToolBar_ToolBarPosition(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionToolBar::ToolBarPosition *>(cppOut) =
        static_cast<::QStyleOptionToolBar::ToolBarPosition>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionToolBar_ToolBarPosition_PythonToCpp_QStyleOptionToolBar_ToolBarPosition_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX]))
        return QStyleOptionToolBar_ToolBarPosition_PythonToCpp_QStyleOptionToolBar_ToolBarPosition;
    return {};
}
static PyObject *QStyleOptionToolBar_ToolBarPosition_CppToPython_QStyleOptionToolBar_ToolBarPosition(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionToolBar::ToolBarPosition *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX], castCppIn);

}

static void QStyleOptionToolBar_ToolBarFeature_PythonToCpp_QStyleOptionToolBar_ToolBarFeature(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionToolBar::ToolBarFeature *>(cppOut) =
        static_cast<::QStyleOptionToolBar::ToolBarFeature>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionToolBar_ToolBarFeature_PythonToCpp_QStyleOptionToolBar_ToolBarFeature_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX]))
        return QStyleOptionToolBar_ToolBarFeature_PythonToCpp_QStyleOptionToolBar_ToolBarFeature;
    return {};
}
static PyObject *QStyleOptionToolBar_ToolBarFeature_CppToPython_QStyleOptionToolBar_ToolBarFeature(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionToolBar::ToolBarFeature *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX], castCppIn);

}

static void QFlags_QStyleOptionToolBar_ToolBarFeature__PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyleOptionToolBar::ToolBarFeature> *>(cppOut) =
        ::QFlags<QStyleOptionToolBar::ToolBarFeature>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QStyleOptionToolBar_ToolBarFeature__PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX]))
        return QFlags_QStyleOptionToolBar_ToolBarFeature__PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature_;
    return {};
}
static PyObject *QFlags_QStyleOptionToolBar_ToolBarFeature__CppToPython_QFlags_QStyleOptionToolBar_ToolBarFeature_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QStyleOptionToolBar::ToolBarFeature> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX]));

}

static void QStyleOptionToolBar_ToolBarFeature_PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyleOptionToolBar::ToolBarFeature> *>(cppOut) =
        ::QFlags<QStyleOptionToolBar::ToolBarFeature>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QStyleOptionToolBar_ToolBarFeature_PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX]))
        return QStyleOptionToolBar_ToolBarFeature_PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature_;
    return {};
}
static void number_PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QStyleOptionToolBar::ToolBarFeature> *>(cppOut) =
        ::QFlags<QStyleOptionToolBar::ToolBarFeature>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX]))
        return number_PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleOptionToolBar_PythonToCpp_QStyleOptionToolBar_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleOptionToolBar_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleOptionToolBar_PythonToCpp_QStyleOptionToolBar_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionToolBar_TypeF())))
        return QStyleOptionToolBar_PythonToCpp_QStyleOptionToolBar_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleOptionToolBar_PTR_CppToPython_QStyleOptionToolBar(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleOptionToolBar *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleOptionToolBar_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleOptionToolBar_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QStyleOptionToolBar(self)",
    "1:PySide2.QtWidgets.QStyleOptionToolBar(self,other:PySide2.QtWidgets.QStyleOptionToolBar)",
    "0:PySide2.QtWidgets.QStyleOptionToolBar(self,version:int)",
    nullptr}; // Sentinel

void init_QStyleOptionToolBar(PyObject *module)
{
    _Sbk_QStyleOptionToolBar_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleOptionToolBar",
        "QStyleOptionToolBar*",
        &Sbk_QStyleOptionToolBar_spec,
        &Shiboken::callCppDestructor< ::QStyleOptionToolBar >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionToolBar_Type);
    InitSignatureStrings(pyType, QStyleOptionToolBar_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionToolBar_Type), Sbk_QStyleOptionToolBar_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionToolBar_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleOptionToolBar_TypeF(),
        QStyleOptionToolBar_PythonToCpp_QStyleOptionToolBar_PTR,
        is_QStyleOptionToolBar_PythonToCpp_QStyleOptionToolBar_PTR_Convertible,
        QStyleOptionToolBar_PTR_CppToPython_QStyleOptionToolBar);

    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBar");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBar*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBar&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleOptionToolBar).name());


    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionToolBar_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleOptionToolBar.StyleOptionType",
        "QStyleOptionToolBar::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleOptionToolBar_TypeF(), "Type", (long) QStyleOptionToolBar::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleOptionToolBar::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONTYPE_IDX],
            QStyleOptionToolBar_StyleOptionType_CppToPython_QStyleOptionToolBar_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionToolBar_StyleOptionType_PythonToCpp_QStyleOptionToolBar_StyleOptionType,
            is_QStyleOptionToolBar_StyleOptionType_PythonToCpp_QStyleOptionToolBar_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBar::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionToolBar_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleOptionToolBar.StyleOptionVersion",
        "QStyleOptionToolBar::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleOptionToolBar_TypeF(), "Version", (long) QStyleOptionToolBar::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleOptionToolBar::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONVERSION_IDX],
            QStyleOptionToolBar_StyleOptionVersion_CppToPython_QStyleOptionToolBar_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionToolBar_StyleOptionVersion_PythonToCpp_QStyleOptionToolBar_StyleOptionVersion,
            is_QStyleOptionToolBar_StyleOptionVersion_PythonToCpp_QStyleOptionToolBar_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBar::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    // Initialization of enum 'ToolBarPosition'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionToolBar_TypeF(),
        "ToolBarPosition",
        "2:PySide2.QtWidgets.QStyleOptionToolBar.ToolBarPosition",
        "QStyleOptionToolBar::ToolBarPosition");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX],
        Sbk_QStyleOptionToolBar_TypeF(), "Beginning", (long) QStyleOptionToolBar::ToolBarPosition::Beginning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX],
        Sbk_QStyleOptionToolBar_TypeF(), "Middle", (long) QStyleOptionToolBar::ToolBarPosition::Middle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX],
        Sbk_QStyleOptionToolBar_TypeF(), "End", (long) QStyleOptionToolBar::ToolBarPosition::End))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX],
        Sbk_QStyleOptionToolBar_TypeF(), "OnlyOne", (long) QStyleOptionToolBar::ToolBarPosition::OnlyOne))
        return;
    // Register converter for enum 'QStyleOptionToolBar::ToolBarPosition'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX],
            QStyleOptionToolBar_ToolBarPosition_CppToPython_QStyleOptionToolBar_ToolBarPosition);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionToolBar_ToolBarPosition_PythonToCpp_QStyleOptionToolBar_ToolBarPosition,
            is_QStyleOptionToolBar_ToolBarPosition_PythonToCpp_QStyleOptionToolBar_ToolBarPosition_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARPOSITION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBar::ToolBarPosition");
        Shiboken::Conversions::registerConverterName(converter, "ToolBarPosition");
    }
    // End of 'ToolBarPosition' enum.

    // Initialization of enum 'ToolBarFeature'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QStyleOptionToolBar.ToolBarFeatures", SbkPySide2_QtWidgets_QStyleOptionToolBar_ToolBarFeature_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionToolBar_TypeF(),
        "ToolBarFeature",
        "2:PySide2.QtWidgets.QStyleOptionToolBar.ToolBarFeature",
        "QStyleOptionToolBar::ToolBarFeature",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX],
        Sbk_QStyleOptionToolBar_TypeF(), "None_", (long) QStyleOptionToolBar::ToolBarFeature::None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX],
        Sbk_QStyleOptionToolBar_TypeF(), "Movable", (long) QStyleOptionToolBar::ToolBarFeature::Movable))
        return;
    // Register converter for enum 'QStyleOptionToolBar::ToolBarFeature'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX],
            QStyleOptionToolBar_ToolBarFeature_CppToPython_QStyleOptionToolBar_ToolBarFeature);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionToolBar_ToolBarFeature_PythonToCpp_QStyleOptionToolBar_ToolBarFeature,
            is_QStyleOptionToolBar_ToolBarFeature_PythonToCpp_QStyleOptionToolBar_ToolBarFeature_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBar::ToolBarFeature");
        Shiboken::Conversions::registerConverterName(converter, "ToolBarFeature");
    }
    // Register converter for flag 'QFlags<QStyleOptionToolBar::ToolBarFeature>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX],
            QFlags_QStyleOptionToolBar_ToolBarFeature__CppToPython_QFlags_QStyleOptionToolBar_ToolBarFeature_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionToolBar_ToolBarFeature_PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature_,
            is_QStyleOptionToolBar_ToolBarFeature_PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QStyleOptionToolBar_ToolBarFeature__PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature_,
            is_QFlags_QStyleOptionToolBar_ToolBarFeature__PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature_,
            is_number_PythonToCpp_QFlags_QStyleOptionToolBar_ToolBarFeature__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLEOPTIONTOOLBAR_TOOLBARFEATURE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionToolBar::ToolBarFeatures");
        Shiboken::Conversions::registerConverterName(converter, "ToolBarFeatures");
    }
    // End of 'ToolBarFeature' enum/flags.

    qRegisterMetaType< ::QStyleOptionToolBar::StyleOptionType >("QStyleOptionToolBar::StyleOptionType");
    qRegisterMetaType< ::QStyleOptionToolBar::StyleOptionVersion >("QStyleOptionToolBar::StyleOptionVersion");
    qRegisterMetaType< ::QStyleOptionToolBar::ToolBarPosition >("QStyleOptionToolBar::ToolBarPosition");
    qRegisterMetaType< ::QStyleOptionToolBar::ToolBarFeature >("QStyleOptionToolBar::ToolBarFeature");
    qRegisterMetaType< ::QStyleOptionToolBar::ToolBarFeatures >("QStyleOptionToolBar::ToolBarFeatures");
}
