/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstyleoptionmenuitem_wrapper.h"

// inner classes

// Extra includes
#include <QtWidgets/qstyleoption.h>
#include <QtWidgets/qwidget.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleOptionMenuItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleOptionMenuItem >()))
        return -1;

    ::QStyleOptionMenuItem *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleOptionMenuItem.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QStyleOptionMenuItem", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QStyleOptionMenuItem::QStyleOptionMenuItem()
    // 1: QStyleOptionMenuItem::QStyleOptionMenuItem(QStyleOptionMenuItem)
    // 2: QStyleOptionMenuItem::QStyleOptionMenuItem(int)
    if (numArgs == 0) {
        overloadId = 0; // QStyleOptionMenuItem()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        overloadId = 2; // QStyleOptionMenuItem(int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QStyleOptionMenuItem(QStyleOptionMenuItem)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleOptionMenuItem_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QStyleOptionMenuItem()
        {

            if (!PyErr_Occurred()) {
                // QStyleOptionMenuItem()
                cptr = new ::QStyleOptionMenuItem();
            }
            break;
        }
        case 1: // QStyleOptionMenuItem(const QStyleOptionMenuItem & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QStyleOptionMenuItem *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionMenuItem(QStyleOptionMenuItem)
                cptr = new ::QStyleOptionMenuItem(*cppArg0);
            }
            break;
        }
        case 2: // QStyleOptionMenuItem(int version)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QStyleOptionMenuItem(int)
                cptr = new ::QStyleOptionMenuItem(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleOptionMenuItem >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStyleOptionMenuItem_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStyleOptionMenuItem_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QStyleOptionMenuItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleOptionMenuItem_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleOptionMenuItem_get_menuItemType(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QStyleOptionMenuItem::MenuItemType cppOut_local = cppSelf->menuItemType;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionMenuItem_set_menuItemType(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'menuItemType' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'menuItemType', 'MenuItemType' or convertible type expected");
        return -1;
    }

    ::QStyleOptionMenuItem::MenuItemType cppOut_local = cppSelf->menuItemType;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->menuItemType = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionMenuItem_get_checkType(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    ::QStyleOptionMenuItem::CheckType cppOut_local = cppSelf->checkType;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX])->converter, &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionMenuItem_set_checkType(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'checkType' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'checkType', 'CheckType' or convertible type expected");
        return -1;
    }

    ::QStyleOptionMenuItem::CheckType cppOut_local = cppSelf->checkType;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->checkType = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionMenuItem_get_checked(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->checked;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionMenuItem_set_checked(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'checked' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'checked', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->checked;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->checked = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionMenuItem_get_menuHasCheckableItems(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    bool cppOut_local = cppSelf->menuHasCheckableItems;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionMenuItem_set_menuHasCheckableItems(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'menuHasCheckableItems' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'menuHasCheckableItems', 'bool' or convertible type expected");
        return -1;
    }

    bool cppOut_local = cppSelf->menuHasCheckableItems;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->menuHasCheckableItems = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionMenuItem_get_menuRect(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->menuRect)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->menuRect))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->menuRect)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &(cppSelf->menuRect), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionMenuItem_set_menuRect(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'menuRect' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'menuRect', 'QRect' or convertible type expected");
        return -1;
    }

    ::QRect& cppOut_ptr = cppSelf->menuRect;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionMenuItem_get_text(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppSelf->text);
    return pyOut;
}
static int Sbk_QStyleOptionMenuItem_set_text(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'text' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'text', 'QString' or convertible type expected");
        return -1;
    }

    ::QString& cppOut_ptr = cppSelf->text;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionMenuItem_get_icon(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->icon)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->icon))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->icon)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &(cppSelf->icon), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionMenuItem_set_icon(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'icon' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'icon', 'QIcon' or convertible type expected");
        return -1;
    }

    ::QIcon& cppOut_ptr = cppSelf->icon;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

static PyObject *Sbk_QStyleOptionMenuItem_get_maxIconWidth(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->maxIconWidth;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionMenuItem_set_maxIconWidth(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'maxIconWidth' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'maxIconWidth', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->maxIconWidth;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->maxIconWidth = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionMenuItem_get_tabWidth(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->tabWidth;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleOptionMenuItem_set_tabWidth(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'tabWidth' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'tabWidth', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->tabWidth;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->tabWidth = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleOptionMenuItem_get_font(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    if (reinterpret_cast<void *>(&(cppSelf->font)) == reinterpret_cast<void *>(cppSelf)) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::Object::findColocatedChild(reinterpret_cast<SbkObject *>(self), reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX])));
        if (pyOut) {
            Py_IncRef(pyOut);
            return pyOut;
        }
    } else if (Shiboken::BindingManager::instance().hasWrapper(&(cppSelf->font))) {
        pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(&(cppSelf->font)));
        Py_IncRef(pyOut);
        return pyOut;
    }
    pyOut = Shiboken::Object::newObject(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), &(cppSelf->font), false, true);
    Shiboken::Object::setParent(self, pyOut);
    return pyOut;
}
static int Sbk_QStyleOptionMenuItem_set_font(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleOptionMenuItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'font' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONT_IDX]), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'font', 'QFont' or convertible type expected");
        return -1;
    }

    ::QFont& cppOut_ptr = cppSelf->font;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for QStyleOptionMenuItem
static PyGetSetDef Sbk_QStyleOptionMenuItem_getsetlist[] = {
    {const_cast<char *>("menuItemType"), Sbk_QStyleOptionMenuItem_get_menuItemType, Sbk_QStyleOptionMenuItem_set_menuItemType},
    {const_cast<char *>("checkType"), Sbk_QStyleOptionMenuItem_get_checkType, Sbk_QStyleOptionMenuItem_set_checkType},
    {const_cast<char *>("checked"), Sbk_QStyleOptionMenuItem_get_checked, Sbk_QStyleOptionMenuItem_set_checked},
    {const_cast<char *>("menuHasCheckableItems"), Sbk_QStyleOptionMenuItem_get_menuHasCheckableItems, Sbk_QStyleOptionMenuItem_set_menuHasCheckableItems},
    {const_cast<char *>("menuRect"), Sbk_QStyleOptionMenuItem_get_menuRect, Sbk_QStyleOptionMenuItem_set_menuRect},
    {const_cast<char *>("text"), Sbk_QStyleOptionMenuItem_get_text, Sbk_QStyleOptionMenuItem_set_text},
    {const_cast<char *>("icon"), Sbk_QStyleOptionMenuItem_get_icon, Sbk_QStyleOptionMenuItem_set_icon},
    {const_cast<char *>("maxIconWidth"), Sbk_QStyleOptionMenuItem_get_maxIconWidth, Sbk_QStyleOptionMenuItem_set_maxIconWidth},
    {const_cast<char *>("tabWidth"), Sbk_QStyleOptionMenuItem_get_tabWidth, Sbk_QStyleOptionMenuItem_set_tabWidth},
    {const_cast<char *>("font"), Sbk_QStyleOptionMenuItem_get_font, Sbk_QStyleOptionMenuItem_set_font},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleOptionMenuItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleOptionMenuItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleOptionMenuItem_Type = nullptr;
static SbkObjectType *Sbk_QStyleOptionMenuItem_TypeF(void)
{
    return _Sbk_QStyleOptionMenuItem_Type;
}

static PyType_Slot Sbk_QStyleOptionMenuItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleOptionMenuItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleOptionMenuItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleOptionMenuItem_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleOptionMenuItem_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleOptionMenuItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleOptionMenuItem_spec = {
    "2:PySide2.QtWidgets.QStyleOptionMenuItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleOptionMenuItem_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleOptionMenuItem_StyleOptionType_PythonToCpp_QStyleOptionMenuItem_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionMenuItem::StyleOptionType *>(cppOut) =
        static_cast<::QStyleOptionMenuItem::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionMenuItem_StyleOptionType_PythonToCpp_QStyleOptionMenuItem_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONTYPE_IDX]))
        return QStyleOptionMenuItem_StyleOptionType_PythonToCpp_QStyleOptionMenuItem_StyleOptionType;
    return {};
}
static PyObject *QStyleOptionMenuItem_StyleOptionType_CppToPython_QStyleOptionMenuItem_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionMenuItem::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleOptionMenuItem_StyleOptionVersion_PythonToCpp_QStyleOptionMenuItem_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionMenuItem::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleOptionMenuItem::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionMenuItem_StyleOptionVersion_PythonToCpp_QStyleOptionMenuItem_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONVERSION_IDX]))
        return QStyleOptionMenuItem_StyleOptionVersion_PythonToCpp_QStyleOptionMenuItem_StyleOptionVersion;
    return {};
}
static PyObject *QStyleOptionMenuItem_StyleOptionVersion_CppToPython_QStyleOptionMenuItem_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionMenuItem::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONVERSION_IDX], castCppIn);

}

static void QStyleOptionMenuItem_MenuItemType_PythonToCpp_QStyleOptionMenuItem_MenuItemType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionMenuItem::MenuItemType *>(cppOut) =
        static_cast<::QStyleOptionMenuItem::MenuItemType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionMenuItem_MenuItemType_PythonToCpp_QStyleOptionMenuItem_MenuItemType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX]))
        return QStyleOptionMenuItem_MenuItemType_PythonToCpp_QStyleOptionMenuItem_MenuItemType;
    return {};
}
static PyObject *QStyleOptionMenuItem_MenuItemType_CppToPython_QStyleOptionMenuItem_MenuItemType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionMenuItem::MenuItemType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX], castCppIn);

}

static void QStyleOptionMenuItem_CheckType_PythonToCpp_QStyleOptionMenuItem_CheckType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleOptionMenuItem::CheckType *>(cppOut) =
        static_cast<::QStyleOptionMenuItem::CheckType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleOptionMenuItem_CheckType_PythonToCpp_QStyleOptionMenuItem_CheckType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX]))
        return QStyleOptionMenuItem_CheckType_PythonToCpp_QStyleOptionMenuItem_CheckType;
    return {};
}
static PyObject *QStyleOptionMenuItem_CheckType_CppToPython_QStyleOptionMenuItem_CheckType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleOptionMenuItem::CheckType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleOptionMenuItem_PythonToCpp_QStyleOptionMenuItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleOptionMenuItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleOptionMenuItem_PythonToCpp_QStyleOptionMenuItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionMenuItem_TypeF())))
        return QStyleOptionMenuItem_PythonToCpp_QStyleOptionMenuItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleOptionMenuItem_PTR_CppToPython_QStyleOptionMenuItem(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleOptionMenuItem *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleOptionMenuItem_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleOptionMenuItem_SignatureStrings[] = {
    "2:PySide2.QtWidgets.QStyleOptionMenuItem(self)",
    "1:PySide2.QtWidgets.QStyleOptionMenuItem(self,other:PySide2.QtWidgets.QStyleOptionMenuItem)",
    "0:PySide2.QtWidgets.QStyleOptionMenuItem(self,version:int)",
    nullptr}; // Sentinel

void init_QStyleOptionMenuItem(PyObject *module)
{
    _Sbk_QStyleOptionMenuItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleOptionMenuItem",
        "QStyleOptionMenuItem*",
        &Sbk_QStyleOptionMenuItem_spec,
        &Shiboken::callCppDestructor< ::QStyleOptionMenuItem >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionMenuItem_Type);
    InitSignatureStrings(pyType, QStyleOptionMenuItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleOptionMenuItem_Type), Sbk_QStyleOptionMenuItem_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleOptionMenuItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleOptionMenuItem_TypeF(),
        QStyleOptionMenuItem_PythonToCpp_QStyleOptionMenuItem_PTR,
        is_QStyleOptionMenuItem_PythonToCpp_QStyleOptionMenuItem_PTR_Convertible,
        QStyleOptionMenuItem_PTR_CppToPython_QStyleOptionMenuItem);

    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionMenuItem");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionMenuItem*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleOptionMenuItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleOptionMenuItem).name());


    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionMenuItem_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleOptionMenuItem.StyleOptionType",
        "QStyleOptionMenuItem::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleOptionMenuItem_TypeF(), "Type", (long) QStyleOptionMenuItem::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleOptionMenuItem::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONTYPE_IDX],
            QStyleOptionMenuItem_StyleOptionType_CppToPython_QStyleOptionMenuItem_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionMenuItem_StyleOptionType_PythonToCpp_QStyleOptionMenuItem_StyleOptionType,
            is_QStyleOptionMenuItem_StyleOptionType_PythonToCpp_QStyleOptionMenuItem_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionMenuItem::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionMenuItem_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleOptionMenuItem.StyleOptionVersion",
        "QStyleOptionMenuItem::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleOptionMenuItem_TypeF(), "Version", (long) QStyleOptionMenuItem::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleOptionMenuItem::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONVERSION_IDX],
            QStyleOptionMenuItem_StyleOptionVersion_CppToPython_QStyleOptionMenuItem_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionMenuItem_StyleOptionVersion_PythonToCpp_QStyleOptionMenuItem_StyleOptionVersion,
            is_QStyleOptionMenuItem_StyleOptionVersion_PythonToCpp_QStyleOptionMenuItem_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionMenuItem::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    // Initialization of enum 'MenuItemType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionMenuItem_TypeF(),
        "MenuItemType",
        "2:PySide2.QtWidgets.QStyleOptionMenuItem.MenuItemType",
        "QStyleOptionMenuItem::MenuItemType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX],
        Sbk_QStyleOptionMenuItem_TypeF(), "Normal", (long) QStyleOptionMenuItem::MenuItemType::Normal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX],
        Sbk_QStyleOptionMenuItem_TypeF(), "DefaultItem", (long) QStyleOptionMenuItem::MenuItemType::DefaultItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX],
        Sbk_QStyleOptionMenuItem_TypeF(), "Separator", (long) QStyleOptionMenuItem::MenuItemType::Separator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX],
        Sbk_QStyleOptionMenuItem_TypeF(), "SubMenu", (long) QStyleOptionMenuItem::MenuItemType::SubMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX],
        Sbk_QStyleOptionMenuItem_TypeF(), "Scroller", (long) QStyleOptionMenuItem::MenuItemType::Scroller))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX],
        Sbk_QStyleOptionMenuItem_TypeF(), "TearOff", (long) QStyleOptionMenuItem::MenuItemType::TearOff))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX],
        Sbk_QStyleOptionMenuItem_TypeF(), "Margin", (long) QStyleOptionMenuItem::MenuItemType::Margin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX],
        Sbk_QStyleOptionMenuItem_TypeF(), "EmptyArea", (long) QStyleOptionMenuItem::MenuItemType::EmptyArea))
        return;
    // Register converter for enum 'QStyleOptionMenuItem::MenuItemType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX],
            QStyleOptionMenuItem_MenuItemType_CppToPython_QStyleOptionMenuItem_MenuItemType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionMenuItem_MenuItemType_PythonToCpp_QStyleOptionMenuItem_MenuItemType,
            is_QStyleOptionMenuItem_MenuItemType_PythonToCpp_QStyleOptionMenuItem_MenuItemType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_MENUITEMTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionMenuItem::MenuItemType");
        Shiboken::Conversions::registerConverterName(converter, "MenuItemType");
    }
    // End of 'MenuItemType' enum.

    // Initialization of enum 'CheckType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleOptionMenuItem_TypeF(),
        "CheckType",
        "2:PySide2.QtWidgets.QStyleOptionMenuItem.CheckType",
        "QStyleOptionMenuItem::CheckType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX],
        Sbk_QStyleOptionMenuItem_TypeF(), "NotCheckable", (long) QStyleOptionMenuItem::CheckType::NotCheckable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX],
        Sbk_QStyleOptionMenuItem_TypeF(), "Exclusive", (long) QStyleOptionMenuItem::CheckType::Exclusive))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX],
        Sbk_QStyleOptionMenuItem_TypeF(), "NonExclusive", (long) QStyleOptionMenuItem::CheckType::NonExclusive))
        return;
    // Register converter for enum 'QStyleOptionMenuItem::CheckType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX],
            QStyleOptionMenuItem_CheckType_CppToPython_QStyleOptionMenuItem_CheckType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleOptionMenuItem_CheckType_PythonToCpp_QStyleOptionMenuItem_CheckType,
            is_QStyleOptionMenuItem_CheckType_PythonToCpp_QStyleOptionMenuItem_CheckType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONMENUITEM_CHECKTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleOptionMenuItem::CheckType");
        Shiboken::Conversions::registerConverterName(converter, "CheckType");
    }
    // End of 'CheckType' enum.

    qRegisterMetaType< ::QStyleOptionMenuItem::StyleOptionType >("QStyleOptionMenuItem::StyleOptionType");
    qRegisterMetaType< ::QStyleOptionMenuItem::StyleOptionVersion >("QStyleOptionMenuItem::StyleOptionVersion");
    qRegisterMetaType< ::QStyleOptionMenuItem::MenuItemType >("QStyleOptionMenuItem::MenuItemType");
    qRegisterMetaType< ::QStyleOptionMenuItem::CheckType >("QStyleOptionMenuItem::CheckType");
}
