/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstylehintreturnvariant_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleHintReturnVariant_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleHintReturnVariant >()))
        return -1;

    ::QStyleHintReturnVariant *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleHintReturnVariant.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QStyleHintReturnVariant()
            cptr = new ::QStyleHintReturnVariant();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleHintReturnVariant >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}


static const char *Sbk_QStyleHintReturnVariant_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleHintReturnVariant_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleHintReturnVariant_get_variant(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleHintReturnVariant *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppSelf->variant);
    return pyOut;
}
static int Sbk_QStyleHintReturnVariant_set_variant(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleHintReturnVariant *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'variant' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'variant', 'QVariant' or convertible type expected");
        return -1;
    }

    ::QVariant& cppOut_ptr = cppSelf->variant;
    pythonToCpp(pyIn, &cppOut_ptr);

    return 0;
}

// Getters and Setters for QStyleHintReturnVariant
static PyGetSetDef Sbk_QStyleHintReturnVariant_getsetlist[] = {
    {const_cast<char *>("variant"), Sbk_QStyleHintReturnVariant_get_variant, Sbk_QStyleHintReturnVariant_set_variant},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleHintReturnVariant_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleHintReturnVariant_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleHintReturnVariant_Type = nullptr;
static SbkObjectType *Sbk_QStyleHintReturnVariant_TypeF(void)
{
    return _Sbk_QStyleHintReturnVariant_Type;
}

static PyType_Slot Sbk_QStyleHintReturnVariant_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleHintReturnVariant_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleHintReturnVariant_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleHintReturnVariant_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleHintReturnVariant_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleHintReturnVariant_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleHintReturnVariant_spec = {
    "2:PySide2.QtWidgets.QStyleHintReturnVariant",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleHintReturnVariant_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleHintReturnVariant_StyleOptionType_PythonToCpp_QStyleHintReturnVariant_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleHintReturnVariant::StyleOptionType *>(cppOut) =
        static_cast<::QStyleHintReturnVariant::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleHintReturnVariant_StyleOptionType_PythonToCpp_QStyleHintReturnVariant_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONTYPE_IDX]))
        return QStyleHintReturnVariant_StyleOptionType_PythonToCpp_QStyleHintReturnVariant_StyleOptionType;
    return {};
}
static PyObject *QStyleHintReturnVariant_StyleOptionType_CppToPython_QStyleHintReturnVariant_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleHintReturnVariant::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleHintReturnVariant_StyleOptionVersion_PythonToCpp_QStyleHintReturnVariant_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleHintReturnVariant::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleHintReturnVariant::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleHintReturnVariant_StyleOptionVersion_PythonToCpp_QStyleHintReturnVariant_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONVERSION_IDX]))
        return QStyleHintReturnVariant_StyleOptionVersion_PythonToCpp_QStyleHintReturnVariant_StyleOptionVersion;
    return {};
}
static PyObject *QStyleHintReturnVariant_StyleOptionVersion_CppToPython_QStyleHintReturnVariant_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleHintReturnVariant::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONVERSION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleHintReturnVariant_PythonToCpp_QStyleHintReturnVariant_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleHintReturnVariant_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleHintReturnVariant_PythonToCpp_QStyleHintReturnVariant_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleHintReturnVariant_TypeF())))
        return QStyleHintReturnVariant_PythonToCpp_QStyleHintReturnVariant_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleHintReturnVariant_PTR_CppToPython_QStyleHintReturnVariant(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleHintReturnVariant *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleHintReturnVariant_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleHintReturnVariant_SignatureStrings[] = {
    "PySide2.QtWidgets.QStyleHintReturnVariant(self)",
    nullptr}; // Sentinel

void init_QStyleHintReturnVariant(PyObject *module)
{
    _Sbk_QStyleHintReturnVariant_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleHintReturnVariant",
        "QStyleHintReturnVariant*",
        &Sbk_QStyleHintReturnVariant_spec,
        &Shiboken::callCppDestructor< ::QStyleHintReturnVariant >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleHintReturnVariant_Type);
    InitSignatureStrings(pyType, QStyleHintReturnVariant_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleHintReturnVariant_Type), Sbk_QStyleHintReturnVariant_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleHintReturnVariant_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleHintReturnVariant_TypeF(),
        QStyleHintReturnVariant_PythonToCpp_QStyleHintReturnVariant_PTR,
        is_QStyleHintReturnVariant_PythonToCpp_QStyleHintReturnVariant_PTR_Convertible,
        QStyleHintReturnVariant_PTR_CppToPython_QStyleHintReturnVariant);

    Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturnVariant");
    Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturnVariant*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturnVariant&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleHintReturnVariant).name());


    // Initialization of enums.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleHintReturnVariant_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleHintReturnVariant.StyleOptionType",
        "QStyleHintReturnVariant::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleHintReturnVariant_TypeF(), "Type", (long) QStyleHintReturnVariant::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleHintReturnVariant::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONTYPE_IDX],
            QStyleHintReturnVariant_StyleOptionType_CppToPython_QStyleHintReturnVariant_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleHintReturnVariant_StyleOptionType_PythonToCpp_QStyleHintReturnVariant_StyleOptionType,
            is_QStyleHintReturnVariant_StyleOptionType_PythonToCpp_QStyleHintReturnVariant_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturnVariant::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleHintReturnVariant_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleHintReturnVariant.StyleOptionVersion",
        "QStyleHintReturnVariant::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleHintReturnVariant_TypeF(), "Version", (long) QStyleHintReturnVariant::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleHintReturnVariant::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONVERSION_IDX],
            QStyleHintReturnVariant_StyleOptionVersion_CppToPython_QStyleHintReturnVariant_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleHintReturnVariant_StyleOptionVersion_PythonToCpp_QStyleHintReturnVariant_StyleOptionVersion,
            is_QStyleHintReturnVariant_StyleOptionVersion_PythonToCpp_QStyleHintReturnVariant_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURNVARIANT_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturnVariant::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    qRegisterMetaType< ::QStyleHintReturnVariant::StyleOptionType >("QStyleHintReturnVariant::StyleOptionType");
    qRegisterMetaType< ::QStyleHintReturnVariant::StyleOptionVersion >("QStyleHintReturnVariant::StyleOptionVersion");
}
