/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstylehintreturn_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyleHintReturn_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyleHintReturn >()))
        return -1;

    ::QStyleHintReturn *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyleHintReturn.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleHintReturn_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QStyleHintReturn", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QStyleHintReturn::QStyleHintReturn(int,int)
    if (numArgs == 0) {
        overloadId = 0; // QStyleHintReturn(int,int)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QStyleHintReturn(int,int)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
            overloadId = 0; // QStyleHintReturn(int,int)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleHintReturn_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_version = Shiboken::String::createStaticString("version");
            if (PyDict_Contains(kwds, key_version)) {
                value = PyDict_GetItem(kwds, key_version);
                if (value && pyArgs[0]) {
                    errInfo = key_version;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleHintReturn_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0]))))
                        goto Sbk_QStyleHintReturn_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_version);
            }
            static PyObject *const key_type = Shiboken::String::createStaticString("type");
            if (PyDict_Contains(kwds, key_type)) {
                value = PyDict_GetItem(kwds, key_type);
                if (value && pyArgs[1]) {
                    errInfo = key_type;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleHintReturn_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1]))))
                        goto Sbk_QStyleHintReturn_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_type);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleHintReturn_Init_TypeError;
            }
        }
        int cppArg0 = QStyleOption::Version;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1 = QStyleHintReturn::SH_Default;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QStyleHintReturn(int,int)
            cptr = new ::QStyleHintReturn(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyleHintReturn >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QStyleHintReturn_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QStyleHintReturn_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}


static const char *Sbk_QStyleHintReturn_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyleHintReturn_methods[] = {

    {nullptr, nullptr} // Sentinel
};

static PyObject *Sbk_QStyleHintReturn_get_version(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleHintReturn *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->version;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleHintReturn_set_version(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleHintReturn *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'version' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'version', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->version;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->version = cppOut_local;

    return 0;
}

static PyObject *Sbk_QStyleHintReturn_get_type(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QStyleHintReturn *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    int cppOut_local = cppSelf->type;
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppOut_local);
    return pyOut;
}
static int Sbk_QStyleHintReturn_set_type(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QStyleHintReturn *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'type' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'type', 'int' or convertible type expected");
        return -1;
    }

    int cppOut_local = cppSelf->type;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->type = cppOut_local;

    return 0;
}

// Getters and Setters for QStyleHintReturn
static PyGetSetDef Sbk_QStyleHintReturn_getsetlist[] = {
    {const_cast<char *>("version"), Sbk_QStyleHintReturn_get_version, Sbk_QStyleHintReturn_set_version},
    {const_cast<char *>("type"), Sbk_QStyleHintReturn_get_type, Sbk_QStyleHintReturn_set_type},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QStyleHintReturn_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyleHintReturn_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyleHintReturn_Type = nullptr;
static SbkObjectType *Sbk_QStyleHintReturn_TypeF(void)
{
    return _Sbk_QStyleHintReturn_Type;
}

static PyType_Slot Sbk_QStyleHintReturn_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyleHintReturn_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyleHintReturn_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyleHintReturn_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QStyleHintReturn_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyleHintReturn_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyleHintReturn_spec = {
    "2:PySide2.QtWidgets.QStyleHintReturn",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyleHintReturn_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QStyleHintReturn_HintReturnType_PythonToCpp_QStyleHintReturn_HintReturnType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleHintReturn::HintReturnType *>(cppOut) =
        static_cast<::QStyleHintReturn::HintReturnType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleHintReturn_HintReturnType_PythonToCpp_QStyleHintReturn_HintReturnType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_HINTRETURNTYPE_IDX]))
        return QStyleHintReturn_HintReturnType_PythonToCpp_QStyleHintReturn_HintReturnType;
    return {};
}
static PyObject *QStyleHintReturn_HintReturnType_CppToPython_QStyleHintReturn_HintReturnType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleHintReturn::HintReturnType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_HINTRETURNTYPE_IDX], castCppIn);

}

static void QStyleHintReturn_StyleOptionType_PythonToCpp_QStyleHintReturn_StyleOptionType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleHintReturn::StyleOptionType *>(cppOut) =
        static_cast<::QStyleHintReturn::StyleOptionType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleHintReturn_StyleOptionType_PythonToCpp_QStyleHintReturn_StyleOptionType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONTYPE_IDX]))
        return QStyleHintReturn_StyleOptionType_PythonToCpp_QStyleHintReturn_StyleOptionType;
    return {};
}
static PyObject *QStyleHintReturn_StyleOptionType_CppToPython_QStyleHintReturn_StyleOptionType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleHintReturn::StyleOptionType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONTYPE_IDX], castCppIn);

}

static void QStyleHintReturn_StyleOptionVersion_PythonToCpp_QStyleHintReturn_StyleOptionVersion(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyleHintReturn::StyleOptionVersion *>(cppOut) =
        static_cast<::QStyleHintReturn::StyleOptionVersion>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyleHintReturn_StyleOptionVersion_PythonToCpp_QStyleHintReturn_StyleOptionVersion_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONVERSION_IDX]))
        return QStyleHintReturn_StyleOptionVersion_PythonToCpp_QStyleHintReturn_StyleOptionVersion;
    return {};
}
static PyObject *QStyleHintReturn_StyleOptionVersion_CppToPython_QStyleHintReturn_StyleOptionVersion(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyleHintReturn::StyleOptionVersion *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONVERSION_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyleHintReturn_PythonToCpp_QStyleHintReturn_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyleHintReturn_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyleHintReturn_PythonToCpp_QStyleHintReturn_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyleHintReturn_TypeF())))
        return QStyleHintReturn_PythonToCpp_QStyleHintReturn_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyleHintReturn_PTR_CppToPython_QStyleHintReturn(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QStyleHintReturn *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QStyleHintReturn_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyleHintReturn_SignatureStrings[] = {
    "PySide2.QtWidgets.QStyleHintReturn(self,version:int=QStyleOption.Version,type:int=SH_Default)",
    nullptr}; // Sentinel

void init_QStyleHintReturn(PyObject *module)
{
    _Sbk_QStyleHintReturn_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyleHintReturn",
        "QStyleHintReturn*",
        &Sbk_QStyleHintReturn_spec,
        &Shiboken::callCppDestructor< ::QStyleHintReturn >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyleHintReturn_Type);
    InitSignatureStrings(pyType, QStyleHintReturn_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyleHintReturn_Type), Sbk_QStyleHintReturn_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyleHintReturn_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyleHintReturn_TypeF(),
        QStyleHintReturn_PythonToCpp_QStyleHintReturn_PTR,
        is_QStyleHintReturn_PythonToCpp_QStyleHintReturn_PTR_Convertible,
        QStyleHintReturn_PTR_CppToPython_QStyleHintReturn);

    Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturn");
    Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturn*");
    Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturn&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleHintReturn).name());


    // Initialization of enums.

    // Initialization of enum 'HintReturnType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_HINTRETURNTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleHintReturn_TypeF(),
        "HintReturnType",
        "2:PySide2.QtWidgets.QStyleHintReturn.HintReturnType",
        "QStyleHintReturn::HintReturnType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_HINTRETURNTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_HINTRETURNTYPE_IDX],
        Sbk_QStyleHintReturn_TypeF(), "SH_Default", (long) QStyleHintReturn::HintReturnType::SH_Default))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_HINTRETURNTYPE_IDX],
        Sbk_QStyleHintReturn_TypeF(), "SH_Mask", (long) QStyleHintReturn::HintReturnType::SH_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_HINTRETURNTYPE_IDX],
        Sbk_QStyleHintReturn_TypeF(), "SH_Variant", (long) QStyleHintReturn::HintReturnType::SH_Variant))
        return;
    // Register converter for enum 'QStyleHintReturn::HintReturnType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_HINTRETURNTYPE_IDX],
            QStyleHintReturn_HintReturnType_CppToPython_QStyleHintReturn_HintReturnType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleHintReturn_HintReturnType_PythonToCpp_QStyleHintReturn_HintReturnType,
            is_QStyleHintReturn_HintReturnType_PythonToCpp_QStyleHintReturn_HintReturnType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_HINTRETURNTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturn::HintReturnType");
        Shiboken::Conversions::registerConverterName(converter, "HintReturnType");
    }
    // End of 'HintReturnType' enum.

    // Initialization of enum 'StyleOptionType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleHintReturn_TypeF(),
        "StyleOptionType",
        "2:PySide2.QtWidgets.QStyleHintReturn.StyleOptionType",
        "QStyleHintReturn::StyleOptionType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONTYPE_IDX],
        Sbk_QStyleHintReturn_TypeF(), "Type", (long) QStyleHintReturn::StyleOptionType::Type))
        return;
    // Register converter for enum 'QStyleHintReturn::StyleOptionType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONTYPE_IDX],
            QStyleHintReturn_StyleOptionType_CppToPython_QStyleHintReturn_StyleOptionType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleHintReturn_StyleOptionType_PythonToCpp_QStyleHintReturn_StyleOptionType,
            is_QStyleHintReturn_StyleOptionType_PythonToCpp_QStyleHintReturn_StyleOptionType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturn::StyleOptionType");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionType");
    }
    // End of 'StyleOptionType' enum.

    // Initialization of enum 'StyleOptionVersion'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONVERSION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyleHintReturn_TypeF(),
        "StyleOptionVersion",
        "2:PySide2.QtWidgets.QStyleHintReturn.StyleOptionVersion",
        "QStyleHintReturn::StyleOptionVersion");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONVERSION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONVERSION_IDX],
        Sbk_QStyleHintReturn_TypeF(), "Version", (long) QStyleHintReturn::StyleOptionVersion::Version))
        return;
    // Register converter for enum 'QStyleHintReturn::StyleOptionVersion'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONVERSION_IDX],
            QStyleHintReturn_StyleOptionVersion_CppToPython_QStyleHintReturn_StyleOptionVersion);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyleHintReturn_StyleOptionVersion_PythonToCpp_QStyleHintReturn_StyleOptionVersion,
            is_QStyleHintReturn_StyleOptionVersion_PythonToCpp_QStyleHintReturn_StyleOptionVersion_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_STYLEOPTIONVERSION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyleHintReturn::StyleOptionVersion");
        Shiboken::Conversions::registerConverterName(converter, "StyleOptionVersion");
    }
    // End of 'StyleOptionVersion' enum.

    qRegisterMetaType< ::QStyleHintReturn::HintReturnType >("QStyleHintReturn::HintReturnType");
    qRegisterMetaType< ::QStyleHintReturn::StyleOptionType >("QStyleHintReturn::StyleOptionType");
    qRegisterMetaType< ::QStyleHintReturn::StyleOptionVersion >("QStyleHintReturn::StyleOptionVersion");
}
