/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qstyle_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QStyleWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QStyleWrapper::QStyleWrapper() : QStyle()
{
    resetPyMethodCache();
    // ... middle
}

void QStyleWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStyleWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStyleWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStyleWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStyleWrapper::drawComplexControl(::QStyle::ComplexControl cc, const ::QStyleOptionComplex * opt, ::QPainter * p, const ::QWidget * widget) const
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawComplexControl()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawComplexControl";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawComplexControl()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX])->converter, &cc),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX]), opt),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), p),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));
    bool invalidateArg3 = PyTuple_GET_ITEM(pyArgs, 2)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg3)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 2));
}

void QStyleWrapper::drawControl(::QStyle::ControlElement element, const ::QStyleOption * opt, ::QPainter * p, const ::QWidget * widget) const
{
    if (m_PyMethodCache[5]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawControl()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawControl";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawControl()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX])->converter, &element),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), opt),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), p),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));
    bool invalidateArg3 = PyTuple_GET_ITEM(pyArgs, 2)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg3)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 2));
}

void QStyleWrapper::drawItemPixmap(::QPainter * painter, const ::QRect & rect, int alignment, const ::QPixmap & pixmap) const
{
    if (m_PyMethodCache[6]) {
        return this->::QStyle::drawItemPixmap(painter, rect, alignment, pixmap);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawItemPixmap";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QStyle::drawItemPixmap(painter, rect, alignment, pixmap);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNiN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &rect),
    alignment,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &pixmap)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStyleWrapper::drawItemText(::QPainter * painter, const ::QRect & rect, int flags, const ::QPalette & pal, bool enabled, const ::QString & text, ::QPalette::ColorRole textRole) const
{
    if (m_PyMethodCache[7]) {
        return this->::QStyle::drawItemText(painter, rect, flags, pal, enabled, text, textRole);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawItemText";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QStyle::drawItemText(painter, rect, flags, pal, enabled, text, textRole);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNiNNNN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &rect),
    flags,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), &pal),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &enabled),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &text),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])->converter, &textRole)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStyleWrapper::drawPrimitive(::QStyle::PrimitiveElement pe, const ::QStyleOption * opt, ::QPainter * p, const ::QWidget * widget) const
{
    if (m_PyMethodCache[8]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawPrimitive()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "drawPrimitive";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawPrimitive()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX])->converter, &pe),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), opt),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), p),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));
    bool invalidateArg3 = PyTuple_GET_ITEM(pyArgs, 2)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg3)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 2));
}

bool QStyleWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[9])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QStyleWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[10])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QPixmap QStyleWrapper::generatedIconPixmap(::QIcon::Mode iconMode, const ::QPixmap & pixmap, const ::QStyleOption * opt) const
{
    if (m_PyMethodCache[11]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.generatedIconPixmap()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "generatedIconPixmap";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.generatedIconPixmap()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, &iconMode),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &pixmap),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), opt)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.generatedIconPixmap", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPixmap >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QPixmap cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QStyle::SubControl QStyleWrapper::hitTestComplexControl(::QStyle::ComplexControl cc, const ::QStyleOptionComplex * opt, const ::QPoint & pt, const ::QWidget * widget) const
{
    if (m_PyMethodCache[12]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.hitTestComplexControl()' not implemented.");
        return QStyle::SC_None;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QStyle::SC_None;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hitTestComplexControl";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.hitTestComplexControl()' not implemented.");
        return QStyle::SC_None;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX])->converter, &cc),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX]), opt),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &pt),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QStyle::SC_None;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.hitTestComplexControl", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QStyle::SubControl >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QStyle::SC_None;
    }
    ::QStyle::SubControl cppResult{QStyle::SC_None};
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QRect QStyleWrapper::itemPixmapRect(const ::QRect & r, int flags, const ::QPixmap & pixmap) const
{
    if (m_PyMethodCache[13])
        return this->::QStyle::itemPixmapRect(r, flags, pixmap);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "itemPixmapRect";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QStyle::itemPixmapRect(r, flags, pixmap);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NiN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &r),
    flags,
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &pixmap)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.itemPixmapRect", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRect >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRect cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QRect QStyleWrapper::itemTextRect(const ::QFontMetrics & fm, const ::QRect & r, int flags, bool enabled, const ::QString & text) const
{
    if (m_PyMethodCache[14])
        return this->::QStyle::itemTextRect(fm, r, flags, enabled, text);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "itemTextRect";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QStyle::itemTextRect(fm, r, flags, enabled, text);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNiNN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), &fm),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &r),
    flags,
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &enabled),
    Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &text)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.itemTextRect", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRect >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRect cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QStyleWrapper::layoutSpacing(::QSizePolicy::ControlType control1, ::QSizePolicy::ControlType control2, ::Qt::Orientation orientation, const ::QStyleOption * option, const ::QWidget * widget) const
{
    if (m_PyMethodCache[15]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.layoutSpacing()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "layoutSpacing";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.layoutSpacing()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, &control1),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, &control2),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, &orientation),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), option),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.layoutSpacing", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QStyleWrapper::pixelMetric(::QStyle::PixelMetric metric, const ::QStyleOption * option, const ::QWidget * widget) const
{
    if (m_PyMethodCache[17]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.pixelMetric()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "pixelMetric";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.pixelMetric()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX])->converter, &metric),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), option),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.pixelMetric", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QStyleWrapper::polish(::QApplication * application)
{
    if (m_PyMethodCache[18]) {
        return this->::QStyle::polish(application);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "polish";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QStyle::polish(application);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_IDX]), application)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStyleWrapper::polish(::QPalette & palette)
{
    if (m_PyMethodCache[19]) {
        return this->::QStyle::polish(palette);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "polish";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QStyle::polish(palette);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::referenceToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), &palette)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStyleWrapper::polish(::QWidget * widget)
{
    if (m_PyMethodCache[20]) {
        return this->::QStyle::polish(widget);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "polish";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QStyle::polish(widget);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSize QStyleWrapper::sizeFromContents(::QStyle::ContentsType ct, const ::QStyleOption * opt, const ::QSize & contentsSize, const ::QWidget * w) const
{
    if (m_PyMethodCache[21]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.sizeFromContents()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sizeFromContents";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.sizeFromContents()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX])->converter, &ct),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), opt),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &contentsSize),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), w)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.sizeFromContents", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QIcon QStyleWrapper::standardIcon(::QStyle::StandardPixmap standardIcon, const ::QStyleOption * option, const ::QWidget * widget) const
{
    if (m_PyMethodCache[22]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.standardIcon()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "standardIcon";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.standardIcon()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX])->converter, &standardIcon),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), option),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.standardIcon", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QIcon >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QIcon cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPalette QStyleWrapper::standardPalette() const
{
    if (m_PyMethodCache[23])
        return this->::QStyle::standardPalette();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "standardPalette";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QStyle::standardPalette();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.standardPalette", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPalette >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QPalette cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QPixmap QStyleWrapper::standardPixmap(::QStyle::StandardPixmap standardPixmap, const ::QStyleOption * opt, const ::QWidget * widget) const
{
    if (m_PyMethodCache[24]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.standardPixmap()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "standardPixmap";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.standardPixmap()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX])->converter, &standardPixmap),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), opt),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.standardPixmap", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPixmap >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QPixmap cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QStyleWrapper::styleHint(::QStyle::StyleHint stylehint, const ::QStyleOption * opt, const ::QWidget * widget, ::QStyleHintReturn * returnData) const
{
    if (m_PyMethodCache[25]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.styleHint()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "styleHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.styleHint()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX])->converter, &stylehint),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), opt),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_IDX]), returnData)
    ));
    bool invalidateArg4 = PyTuple_GET_ITEM(pyArgs, 3)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.styleHint", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg4)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 3));
    return cppResult;
}

::QRect QStyleWrapper::subControlRect(::QStyle::ComplexControl cc, const ::QStyleOptionComplex * opt, ::QStyle::SubControl sc, const ::QWidget * widget) const
{
    if (m_PyMethodCache[26]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.subControlRect()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "subControlRect";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.subControlRect()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX])->converter, &cc),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX]), opt),
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX])->converter, &sc),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.subControlRect", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRect >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRect cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QRect QStyleWrapper::subElementRect(::QStyle::SubElement subElement, const ::QStyleOption * option, const ::QWidget * widget) const
{
    if (m_PyMethodCache[27]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.subElementRect()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "subElementRect";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.subElementRect()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NNN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX])->converter, &subElement),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), option),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QStyle.subElementRect", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRect >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRect cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QStyleWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[28]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QStyleWrapper::unpolish(::QApplication * application)
{
    if (m_PyMethodCache[29]) {
        return this->::QStyle::unpolish(application);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "unpolish";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        return this->::QStyle::unpolish(application);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_IDX]), application)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QStyleWrapper::unpolish(::QWidget * widget)
{
    if (m_PyMethodCache[30]) {
        return this->::QStyle::unpolish(widget);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "unpolish";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[30] = true;
        return this->::QStyle::unpolish(widget);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

const QMetaObject *QStyleWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QStyle::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QStyleWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QStyle::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QStyleWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QStyleWrapper *>(this));
        return QStyle::qt_metacast(_clname);
}

QStyleWrapper::~QStyleWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QStyle_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QStyle' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QStyle >()))
        return -1;

    ::QStyleWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QStyle()
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QStyleWrapper();
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QStyleWrapper();
            }

        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QStyle >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QStyle_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QStyle_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QStyleFunc_alignedRect(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.alignedRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "alignedRect", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QStyle::alignedRect(Qt::LayoutDirection,QFlags<Qt::AlignmentFlag>,QSize,QRect)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[3])))) {
        overloadId = 0; // alignedRect(Qt::LayoutDirection,QFlags<Qt::AlignmentFlag>,QSize,QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_alignedRect_TypeError;

    // Call function/method
    {
        ::Qt::LayoutDirection cppArg0{Qt::LeftToRight};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<Qt::AlignmentFlag> cppArg1 = QFlags<Qt::AlignmentFlag>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QSize cppArg2_local;
        ::QSize *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QRect cppArg3_local;
        ::QRect *cppArg3 = &cppArg3_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[3]))
            pythonToCpp[3](pyArgs[3], &cppArg3_local);
        else
            pythonToCpp[3](pyArgs[3], &cppArg3);


        if (!PyErr_Occurred()) {
            // alignedRect(Qt::LayoutDirection,QFlags<Qt::AlignmentFlag>,QSize,QRect)
            QRect cppResult = ::QStyle::alignedRect(cppArg0, cppArg1, *cppArg2, *cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_alignedRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_combinedLayoutSpacing(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.combinedLayoutSpacing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_combinedLayoutSpacing_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_combinedLayoutSpacing_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:combinedLayoutSpacing", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::combinedLayoutSpacing(QFlags<QSizePolicy::ControlType>,QFlags<QSizePolicy::ControlType>,Qt::Orientation,QStyleOption*,QWidget*)const
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // combinedLayoutSpacing(QFlags<QSizePolicy::ControlType>,QFlags<QSizePolicy::ControlType>,Qt::Orientation,QStyleOption*,QWidget*)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 0; // combinedLayoutSpacing(QFlags<QSizePolicy::ControlType>,QFlags<QSizePolicy::ControlType>,Qt::Orientation,QStyleOption*,QWidget*)const
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[4])))) {
                overloadId = 0; // combinedLayoutSpacing(QFlags<QSizePolicy::ControlType>,QFlags<QSizePolicy::ControlType>,Qt::Orientation,QStyleOption*,QWidget*)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_combinedLayoutSpacing_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_option = Shiboken::String::createStaticString("option");
            if (PyDict_Contains(kwds, key_option)) {
                value = PyDict_GetItem(kwds, key_option);
                if (value && pyArgs[3]) {
                    errInfo = key_option;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_combinedLayoutSpacing_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[3]))))
                        goto Sbk_QStyleFunc_combinedLayoutSpacing_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_option);
            }
            static PyObject *const key_widget = Shiboken::String::createStaticString("widget");
            if (PyDict_Contains(kwds, key_widget)) {
                value = PyDict_GetItem(kwds, key_widget);
                if (value && pyArgs[4]) {
                    errInfo = key_widget;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_combinedLayoutSpacing_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[4]))))
                        goto Sbk_QStyleFunc_combinedLayoutSpacing_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_widget);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_combinedLayoutSpacing_TypeError;
            }
        }
        ::QFlags<QSizePolicy::ControlType> cppArg0 = QFlags<QSizePolicy::ControlType>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<QSizePolicy::ControlType> cppArg1 = QFlags<QSizePolicy::ControlType>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::Qt::Orientation cppArg2 = static_cast< ::Qt::Orientation>(0);
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QStyleOption *cppArg3 = nullptr;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::QWidget *cppArg4 = nullptr;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // combinedLayoutSpacing(QFlags<QSizePolicy::ControlType>,QFlags<QSizePolicy::ControlType>,Qt::Orientation,QStyleOption*,QWidget*)const
            int cppResult = const_cast<const ::QStyle *>(cppSelf)->combinedLayoutSpacing(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_combinedLayoutSpacing_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_drawComplexControl(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.drawComplexControl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_drawComplexControl_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_drawComplexControl_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:drawComplexControl", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::drawComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPainter*,const QWidget*)const
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // drawComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPainter*,const QWidget*)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[3])))) {
            overloadId = 0; // drawComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPainter*,const QWidget*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_drawComplexControl_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_widget = Shiboken::String::createStaticString("widget");
            if (PyDict_Contains(kwds, key_widget)) {
                value = PyDict_GetItem(kwds, key_widget);
                if (value && pyArgs[3]) {
                    errInfo = key_widget;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_drawComplexControl_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[3]))))
                        goto Sbk_QStyleFunc_drawComplexControl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_widget);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_drawComplexControl_TypeError;
            }
        }
        ::QStyle::ComplexControl cppArg0{QStyle::CC_SpinBox};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QStyleOptionComplex *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QPainter *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QWidget *cppArg3 = 0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // drawComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPainter*,const QWidget*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawComplexControl()' not implemented.");
                return {};
            }
            const_cast<const ::QStyle *>(cppSelf)->drawComplexControl(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleFunc_drawComplexControl_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_drawControl(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.drawControl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_drawControl_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_drawControl_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:drawControl", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::drawControl(QStyle::ControlElement,const QStyleOption*,QPainter*,const QWidget*)const
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // drawControl(QStyle::ControlElement,const QStyleOption*,QPainter*,const QWidget*)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[3])))) {
            overloadId = 0; // drawControl(QStyle::ControlElement,const QStyleOption*,QPainter*,const QWidget*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_drawControl_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_widget = Shiboken::String::createStaticString("widget");
            if (PyDict_Contains(kwds, key_widget)) {
                value = PyDict_GetItem(kwds, key_widget);
                if (value && pyArgs[3]) {
                    errInfo = key_widget;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_drawControl_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[3]))))
                        goto Sbk_QStyleFunc_drawControl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_widget);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_drawControl_TypeError;
            }
        }
        ::QStyle::ControlElement cppArg0{QStyle::CE_PushButton};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QStyleOption *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QPainter *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QWidget *cppArg3 = 0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // drawControl(QStyle::ControlElement,const QStyleOption*,QPainter*,const QWidget*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawControl()' not implemented.");
                return {};
            }
            const_cast<const ::QStyle *>(cppSelf)->drawControl(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleFunc_drawControl_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_drawItemPixmap(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.drawItemPixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "drawItemPixmap", 4, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::drawItemPixmap(QPainter*,QRect,int,QPixmap)const
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[3])))) {
        overloadId = 0; // drawItemPixmap(QPainter*,QRect,int,QPixmap)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_drawItemPixmap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRect cppArg1_local;
        ::QRect *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QPixmap cppArg3_local;
        ::QPixmap *cppArg3 = &cppArg3_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[3]))
            pythonToCpp[3](pyArgs[3], &cppArg3_local);
        else
            pythonToCpp[3](pyArgs[3], &cppArg3);


        if (!PyErr_Occurred()) {
            // drawItemPixmap(QPainter*,QRect,int,QPixmap)const
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QStyle *>(cppSelf)->::QStyle::drawItemPixmap(cppArg0, *cppArg1, cppArg2, *cppArg3)
                : const_cast<const ::QStyle *>(cppSelf)->drawItemPixmap(cppArg0, *cppArg1, cppArg2, *cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleFunc_drawItemPixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_drawItemText(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.drawItemText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_drawItemText_TypeError;
    } else if (numArgs < 6) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_drawItemText_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOO:drawItemText", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::drawItemText(QPainter*,QRect,int,QPalette,bool,QString,QPalette::ColorRole)const
    if (numArgs >= 6
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[4])))
        && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[5])))) {
        if (numArgs == 6) {
            overloadId = 0; // drawItemText(QPainter*,QRect,int,QPalette,bool,QString,QPalette::ColorRole)const
        } else if (numArgs >= 7
            && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])->converter, (pyArgs[6])))) {
            overloadId = 0; // drawItemText(QPainter*,QRect,int,QPalette,bool,QString,QPalette::ColorRole)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_drawItemText_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_textRole = Shiboken::String::createStaticString("textRole");
            if (PyDict_Contains(kwds, key_textRole)) {
                value = PyDict_GetItem(kwds, key_textRole);
                if (value && pyArgs[6]) {
                    errInfo = key_textRole;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_drawItemText_TypeError;
                }
                if (value) {
                    pyArgs[6] = value;
                    if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPALETTE_COLORROLE_IDX])->converter, (pyArgs[6]))))
                        goto Sbk_QStyleFunc_drawItemText_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_textRole);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_drawItemText_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QPainter *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRect cppArg1_local;
        ::QRect *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QPalette cppArg3_local;
        ::QPalette *cppArg3 = &cppArg3_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), pythonToCpp[3]))
            pythonToCpp[3](pyArgs[3], &cppArg3_local);
        else
            pythonToCpp[3](pyArgs[3], &cppArg3);

        bool cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QString cppArg5;
        pythonToCpp[5](pyArgs[5], &cppArg5);
        ::QPalette::ColorRole cppArg6 = QPalette::NoRole;
        if (pythonToCpp[6]) pythonToCpp[6](pyArgs[6], &cppArg6);

        if (!PyErr_Occurred()) {
            // drawItemText(QPainter*,QRect,int,QPalette,bool,QString,QPalette::ColorRole)const
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QStyle *>(cppSelf)->::QStyle::drawItemText(cppArg0, *cppArg1, cppArg2, *cppArg3, cppArg4, cppArg5, cppArg6)
                : const_cast<const ::QStyle *>(cppSelf)->drawItemText(cppArg0, *cppArg1, cppArg2, *cppArg3, cppArg4, cppArg5, cppArg6);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleFunc_drawItemText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_drawPrimitive(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.drawPrimitive";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_drawPrimitive_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_drawPrimitive_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:drawPrimitive", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::drawPrimitive(QStyle::PrimitiveElement,const QStyleOption*,QPainter*,const QWidget*)const
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // drawPrimitive(QStyle::PrimitiveElement,const QStyleOption*,QPainter*,const QWidget*)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[3])))) {
            overloadId = 0; // drawPrimitive(QStyle::PrimitiveElement,const QStyleOption*,QPainter*,const QWidget*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_drawPrimitive_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_widget = Shiboken::String::createStaticString("widget");
            if (PyDict_Contains(kwds, key_widget)) {
                value = PyDict_GetItem(kwds, key_widget);
                if (value && pyArgs[3]) {
                    errInfo = key_widget;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_drawPrimitive_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[3]))))
                        goto Sbk_QStyleFunc_drawPrimitive_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_widget);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_drawPrimitive_TypeError;
            }
        }
        ::QStyle::PrimitiveElement cppArg0{QStyle::PE_Frame};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QStyleOption *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QPainter *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QWidget *cppArg3 = 0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // drawPrimitive(QStyle::PrimitiveElement,const QStyleOption*,QPainter*,const QWidget*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.drawPrimitive()' not implemented.");
                return {};
            }
            const_cast<const ::QStyle *>(cppSelf)->drawPrimitive(cppArg0, cppArg1, cppArg2, cppArg3);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleFunc_drawPrimitive_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_generatedIconPixmap(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.generatedIconPixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "generatedIconPixmap", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::generatedIconPixmap(QIcon::Mode,QPixmap,const QStyleOption*)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QICON_MODE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[2])))) {
        overloadId = 0; // generatedIconPixmap(QIcon::Mode,QPixmap,const QStyleOption*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_generatedIconPixmap_TypeError;

    // Call function/method
    {
        ::QIcon::Mode cppArg0{QIcon::Normal};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPixmap cppArg1_local;
        ::QPixmap *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QStyleOption *cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // generatedIconPixmap(QIcon::Mode,QPixmap,const QStyleOption*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.generatedIconPixmap()' not implemented.");
                return {};
            }
            QPixmap cppResult = const_cast<const ::QStyle *>(cppSelf)->generatedIconPixmap(cppArg0, *cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_generatedIconPixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_hitTestComplexControl(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.hitTestComplexControl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_hitTestComplexControl_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_hitTestComplexControl_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:hitTestComplexControl", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::hitTestComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPoint,const QWidget*)const
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // hitTestComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPoint,const QWidget*)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[3])))) {
            overloadId = 0; // hitTestComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPoint,const QWidget*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_hitTestComplexControl_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_widget = Shiboken::String::createStaticString("widget");
            if (PyDict_Contains(kwds, key_widget)) {
                value = PyDict_GetItem(kwds, key_widget);
                if (value && pyArgs[3]) {
                    errInfo = key_widget;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_hitTestComplexControl_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[3]))))
                        goto Sbk_QStyleFunc_hitTestComplexControl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_widget);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_hitTestComplexControl_TypeError;
            }
        }
        ::QStyle::ComplexControl cppArg0{QStyle::CC_SpinBox};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QStyleOptionComplex *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QPoint cppArg2_local;
        ::QPoint *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QWidget *cppArg3 = 0;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // hitTestComplexControl(QStyle::ComplexControl,const QStyleOptionComplex*,QPoint,const QWidget*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.hitTestComplexControl()' not implemented.");
                return {};
            }
            QStyle::SubControl cppResult = const_cast<const ::QStyle *>(cppSelf)->hitTestComplexControl(cppArg0, cppArg1, *cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_hitTestComplexControl_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_itemPixmapRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.itemPixmapRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "itemPixmapRect", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::itemPixmapRect(QRect,int,QPixmap)const
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), (pyArgs[2])))) {
        overloadId = 0; // itemPixmapRect(QRect,int,QPixmap)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_itemPixmapRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QPixmap cppArg2_local;
        ::QPixmap *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // itemPixmapRect(QRect,int,QPixmap)const
            QRect cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QStyle *>(cppSelf)->::QStyle::itemPixmapRect(*cppArg0, cppArg1, *cppArg2)
                : const_cast<const ::QStyle *>(cppSelf)->itemPixmapRect(*cppArg0, cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_itemPixmapRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_itemTextRect(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.itemTextRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "itemTextRect", 5, 5, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::itemTextRect(QFontMetrics,QRect,int,bool,QString)const
    if (numArgs == 5
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[3])))
        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))) {
        overloadId = 0; // itemTextRect(QFontMetrics,QRect,int,bool,QString)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_itemTextRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QFontMetrics cppArg0_local = ::QFontMetrics(::QFont());
        ::QFontMetrics *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFONTMETRICS_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRect cppArg1_local;
        ::QRect *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        bool cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4;
        pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // itemTextRect(QFontMetrics,QRect,int,bool,QString)const
            QRect cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QStyle *>(cppSelf)->::QStyle::itemTextRect(*cppArg0, *cppArg1, cppArg2, cppArg3, cppArg4)
                : const_cast<const ::QStyle *>(cppSelf)->itemTextRect(*cppArg0, *cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_itemTextRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_layoutSpacing(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.layoutSpacing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_layoutSpacing_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_layoutSpacing_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:layoutSpacing", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::layoutSpacing(QSizePolicy::ControlType,QSizePolicy::ControlType,Qt::Orientation,const QStyleOption*,const QWidget*)const
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_ORIENTATION_IDX])->converter, (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // layoutSpacing(QSizePolicy::ControlType,QSizePolicy::ControlType,Qt::Orientation,const QStyleOption*,const QWidget*)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[3])))) {
            if (numArgs == 4) {
                overloadId = 0; // layoutSpacing(QSizePolicy::ControlType,QSizePolicy::ControlType,Qt::Orientation,const QStyleOption*,const QWidget*)const
            } else if (numArgs >= 5
                && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[4])))) {
                overloadId = 0; // layoutSpacing(QSizePolicy::ControlType,QSizePolicy::ControlType,Qt::Orientation,const QStyleOption*,const QWidget*)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_layoutSpacing_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_option = Shiboken::String::createStaticString("option");
            if (PyDict_Contains(kwds, key_option)) {
                value = PyDict_GetItem(kwds, key_option);
                if (value && pyArgs[3]) {
                    errInfo = key_option;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_layoutSpacing_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[3]))))
                        goto Sbk_QStyleFunc_layoutSpacing_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_option);
            }
            static PyObject *const key_widget = Shiboken::String::createStaticString("widget");
            if (PyDict_Contains(kwds, key_widget)) {
                value = PyDict_GetItem(kwds, key_widget);
                if (value && pyArgs[4]) {
                    errInfo = key_widget;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_layoutSpacing_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[4]))))
                        goto Sbk_QStyleFunc_layoutSpacing_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_widget);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_layoutSpacing_TypeError;
            }
        }
        ::QSizePolicy::ControlType cppArg0 = static_cast< ::QSizePolicy::ControlType>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QSizePolicy::ControlType cppArg1 = static_cast< ::QSizePolicy::ControlType>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::Qt::Orientation cppArg2 = static_cast< ::Qt::Orientation>(0);
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QStyleOption *cppArg3 = nullptr;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        if (!Shiboken::Object::isValid(pyArgs[4]))
            return {};
        ::QWidget *cppArg4 = nullptr;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // layoutSpacing(QSizePolicy::ControlType,QSizePolicy::ControlType,Qt::Orientation,const QStyleOption*,const QWidget*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.layoutSpacing()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QStyle *>(cppSelf)->layoutSpacing(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_layoutSpacing_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_pixelMetric(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.pixelMetric";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_pixelMetric_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_pixelMetric_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:pixelMetric", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2])))) {
                overloadId = 0; // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_pixelMetric_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_option = Shiboken::String::createStaticString("option");
            if (PyDict_Contains(kwds, key_option)) {
                value = PyDict_GetItem(kwds, key_option);
                if (value && pyArgs[1]) {
                    errInfo = key_option;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_pixelMetric_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[1]))))
                        goto Sbk_QStyleFunc_pixelMetric_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_option);
            }
            static PyObject *const key_widget = Shiboken::String::createStaticString("widget");
            if (PyDict_Contains(kwds, key_widget)) {
                value = PyDict_GetItem(kwds, key_widget);
                if (value && pyArgs[2]) {
                    errInfo = key_widget;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_pixelMetric_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2]))))
                        goto Sbk_QStyleFunc_pixelMetric_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_widget);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_pixelMetric_TypeError;
            }
        }
        ::QStyle::PixelMetric cppArg0{QStyle::PM_ButtonMargin};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QStyleOption *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWidget *cppArg2 = nullptr;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // pixelMetric(QStyle::PixelMetric,const QStyleOption*,const QWidget*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.pixelMetric()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QStyle *>(cppSelf)->pixelMetric(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_pixelMetric_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_polish(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.polish";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStyle::polish(QWidget*)
    // 1: QStyle::polish(QPalette&)
    // 2: QStyle::polish(QApplication*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_IDX]), (pyArg)))) {
        overloadId = 2; // polish(QApplication*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), (pyArg)))) {
        overloadId = 1; // polish(QPalette&)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // polish(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_polish_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // polish(QWidget * widget)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // polish(QWidget*)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QStyle::polish(cppArg0)
                    : cppSelf->polish(cppArg0);
            }
            break;
        }
        case 1: // polish(QPalette & palette)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QPalette cppArg0_local;
            ::QPalette *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // polish(QPalette&)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QStyle::polish(*cppArg0)
                    : cppSelf->polish(*cppArg0);
            }
            break;
        }
        case 2: // polish(QApplication * application)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QApplication *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // polish(QApplication*)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QStyle::polish(cppArg0)
                    : cppSelf->polish(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleFunc_polish_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_proxy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.proxy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // proxy()const
            const QStyle * cppResult = const_cast<const ::QStyle *>(cppSelf)->proxy();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleFunc_sizeFromContents(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.sizeFromContents";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_sizeFromContents_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_sizeFromContents_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:sizeFromContents", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::sizeFromContents(QStyle::ContentsType,const QStyleOption*,QSize,const QWidget*)const
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // sizeFromContents(QStyle::ContentsType,const QStyleOption*,QSize,const QWidget*)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[3])))) {
            overloadId = 0; // sizeFromContents(QStyle::ContentsType,const QStyleOption*,QSize,const QWidget*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_sizeFromContents_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_w = Shiboken::String::createStaticString("w");
            if (PyDict_Contains(kwds, key_w)) {
                value = PyDict_GetItem(kwds, key_w);
                if (value && pyArgs[3]) {
                    errInfo = key_w;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_sizeFromContents_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[3]))))
                        goto Sbk_QStyleFunc_sizeFromContents_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_w);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_sizeFromContents_TypeError;
            }
        }
        ::QStyle::ContentsType cppArg0{QStyle::CT_PushButton};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QStyleOption *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QSize cppArg2_local;
        ::QSize *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QWidget *cppArg3 = nullptr;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // sizeFromContents(QStyle::ContentsType,const QStyleOption*,QSize,const QWidget*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.sizeFromContents()' not implemented.");
                return {};
            }
            QSize cppResult = const_cast<const ::QStyle *>(cppSelf)->sizeFromContents(cppArg0, cppArg1, *cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_sizeFromContents_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_sliderPositionFromValue(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.sliderPositionFromValue";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_sliderPositionFromValue_TypeError;
    } else if (numArgs < 4) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_sliderPositionFromValue_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:sliderPositionFromValue", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QStyle::sliderPositionFromValue(int,int,int,int,bool)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // sliderPositionFromValue(int,int,int,int,bool)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[4])))) {
            overloadId = 0; // sliderPositionFromValue(int,int,int,int,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_sliderPositionFromValue_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_upsideDown = Shiboken::String::createStaticString("upsideDown");
            if (PyDict_Contains(kwds, key_upsideDown)) {
                value = PyDict_GetItem(kwds, key_upsideDown);
                if (value && pyArgs[4]) {
                    errInfo = key_upsideDown;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_sliderPositionFromValue_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[4]))))
                        goto Sbk_QStyleFunc_sliderPositionFromValue_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_upsideDown);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_sliderPositionFromValue_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        bool cppArg4 = false;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // sliderPositionFromValue(int,int,int,int,bool)
            int cppResult = ::QStyle::sliderPositionFromValue(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_sliderPositionFromValue_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_sliderValueFromPosition(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.sliderValueFromPosition";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_sliderValueFromPosition_TypeError;
    } else if (numArgs < 4) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_sliderValueFromPosition_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:sliderValueFromPosition", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QStyle::sliderValueFromPosition(int,int,int,int,bool)
    if (numArgs >= 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        if (numArgs == 4) {
            overloadId = 0; // sliderValueFromPosition(int,int,int,int,bool)
        } else if (numArgs >= 5
            && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[4])))) {
            overloadId = 0; // sliderValueFromPosition(int,int,int,int,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_sliderValueFromPosition_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_upsideDown = Shiboken::String::createStaticString("upsideDown");
            if (PyDict_Contains(kwds, key_upsideDown)) {
                value = PyDict_GetItem(kwds, key_upsideDown);
                if (value && pyArgs[4]) {
                    errInfo = key_upsideDown;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_sliderValueFromPosition_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[4]))))
                        goto Sbk_QStyleFunc_sliderValueFromPosition_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_upsideDown);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_sliderValueFromPosition_TypeError;
            }
        }
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        int cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);
        int cppArg3;
        pythonToCpp[3](pyArgs[3], &cppArg3);
        bool cppArg4 = false;
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // sliderValueFromPosition(int,int,int,int,bool)
            int cppResult = ::QStyle::sliderValueFromPosition(cppArg0, cppArg1, cppArg2, cppArg3, cppArg4);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_sliderValueFromPosition_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_standardIcon(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.standardIcon";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_standardIcon_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_standardIcon_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:standardIcon", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::standardIcon(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // standardIcon(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // standardIcon(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2])))) {
                overloadId = 0; // standardIcon(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_standardIcon_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_option = Shiboken::String::createStaticString("option");
            if (PyDict_Contains(kwds, key_option)) {
                value = PyDict_GetItem(kwds, key_option);
                if (value && pyArgs[1]) {
                    errInfo = key_option;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_standardIcon_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[1]))))
                        goto Sbk_QStyleFunc_standardIcon_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_option);
            }
            static PyObject *const key_widget = Shiboken::String::createStaticString("widget");
            if (PyDict_Contains(kwds, key_widget)) {
                value = PyDict_GetItem(kwds, key_widget);
                if (value && pyArgs[2]) {
                    errInfo = key_widget;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_standardIcon_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2]))))
                        goto Sbk_QStyleFunc_standardIcon_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_widget);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_standardIcon_TypeError;
            }
        }
        ::QStyle::StandardPixmap cppArg0{QStyle::SP_TitleBarMenuButton};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QStyleOption *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWidget *cppArg2 = nullptr;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // standardIcon(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.standardIcon()' not implemented.");
                return {};
            }
            QIcon cppResult = const_cast<const ::QStyle *>(cppSelf)->standardIcon(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QICON_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_standardIcon_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_standardPalette(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.standardPalette";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // standardPalette()const
            QPalette cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QStyle *>(cppSelf)->::QStyle::standardPalette()
                : const_cast<const ::QStyle *>(cppSelf)->standardPalette();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPALETTE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QStyleFunc_standardPixmap(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.standardPixmap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_standardPixmap_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_standardPixmap_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:standardPixmap", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::standardPixmap(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // standardPixmap(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // standardPixmap(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2])))) {
                overloadId = 0; // standardPixmap(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_standardPixmap_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_opt = Shiboken::String::createStaticString("opt");
            if (PyDict_Contains(kwds, key_opt)) {
                value = PyDict_GetItem(kwds, key_opt);
                if (value && pyArgs[1]) {
                    errInfo = key_opt;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_standardPixmap_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[1]))))
                        goto Sbk_QStyleFunc_standardPixmap_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_opt);
            }
            static PyObject *const key_widget = Shiboken::String::createStaticString("widget");
            if (PyDict_Contains(kwds, key_widget)) {
                value = PyDict_GetItem(kwds, key_widget);
                if (value && pyArgs[2]) {
                    errInfo = key_widget;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_standardPixmap_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2]))))
                        goto Sbk_QStyleFunc_standardPixmap_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_widget);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_standardPixmap_TypeError;
            }
        }
        ::QStyle::StandardPixmap cppArg0{QStyle::SP_TitleBarMenuButton};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QStyleOption *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWidget *cppArg2 = nullptr;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // standardPixmap(QStyle::StandardPixmap,const QStyleOption*,const QWidget*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.standardPixmap()' not implemented.");
                return {};
            }
            QPixmap cppResult = const_cast<const ::QStyle *>(cppSelf)->standardPixmap(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPIXMAP_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_standardPixmap_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_styleHint(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.styleHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_styleHint_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_styleHint_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:styleHint", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_IDX]), (pyArgs[3])))) {
                    overloadId = 0; // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_styleHint_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_opt = Shiboken::String::createStaticString("opt");
            if (PyDict_Contains(kwds, key_opt)) {
                value = PyDict_GetItem(kwds, key_opt);
                if (value && pyArgs[1]) {
                    errInfo = key_opt;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_styleHint_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[1]))))
                        goto Sbk_QStyleFunc_styleHint_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_opt);
            }
            static PyObject *const key_widget = Shiboken::String::createStaticString("widget");
            if (PyDict_Contains(kwds, key_widget)) {
                value = PyDict_GetItem(kwds, key_widget);
                if (value && pyArgs[2]) {
                    errInfo = key_widget;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_styleHint_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2]))))
                        goto Sbk_QStyleFunc_styleHint_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_widget);
            }
            static PyObject *const key_returnData = Shiboken::String::createStaticString("returnData");
            if (PyDict_Contains(kwds, key_returnData)) {
                value = PyDict_GetItem(kwds, key_returnData);
                if (value && pyArgs[3]) {
                    errInfo = key_returnData;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_styleHint_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEHINTRETURN_IDX]), (pyArgs[3]))))
                        goto Sbk_QStyleFunc_styleHint_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_returnData);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_styleHint_TypeError;
            }
        }
        ::QStyle::StyleHint cppArg0{QStyle::SH_EtchDisabledText};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QStyleOption *cppArg1 = nullptr;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWidget *cppArg2 = nullptr;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QStyleHintReturn *cppArg3 = nullptr;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // styleHint(QStyle::StyleHint,const QStyleOption*,const QWidget*,QStyleHintReturn*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.styleHint()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QStyle *>(cppSelf)->styleHint(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_styleHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_subControlRect(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.subControlRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_subControlRect_TypeError;
    } else if (numArgs < 3) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_subControlRect_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:subControlRect", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::subControlRect(QStyle::ComplexControl,const QStyleOptionComplex*,QStyle::SubControl,const QWidget*)const
    if (numArgs >= 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTIONCOMPLEX_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX])->converter, (pyArgs[2])))) {
        if (numArgs == 3) {
            overloadId = 0; // subControlRect(QStyle::ComplexControl,const QStyleOptionComplex*,QStyle::SubControl,const QWidget*)const
        } else if (numArgs >= 4
            && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[3])))) {
            overloadId = 0; // subControlRect(QStyle::ComplexControl,const QStyleOptionComplex*,QStyle::SubControl,const QWidget*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_subControlRect_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_widget = Shiboken::String::createStaticString("widget");
            if (PyDict_Contains(kwds, key_widget)) {
                value = PyDict_GetItem(kwds, key_widget);
                if (value && pyArgs[3]) {
                    errInfo = key_widget;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_subControlRect_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[3]))))
                        goto Sbk_QStyleFunc_subControlRect_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_widget);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_subControlRect_TypeError;
            }
        }
        ::QStyle::ComplexControl cppArg0{QStyle::CC_SpinBox};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QStyleOptionComplex *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QStyle::SubControl cppArg2{QStyle::SC_None};
        pythonToCpp[2](pyArgs[2], &cppArg2);
        if (!Shiboken::Object::isValid(pyArgs[3]))
            return {};
        ::QWidget *cppArg3 = nullptr;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // subControlRect(QStyle::ComplexControl,const QStyleOptionComplex*,QStyle::SubControl,const QWidget*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.subControlRect()' not implemented.");
                return {};
            }
            QRect cppResult = const_cast<const ::QStyle *>(cppSelf)->subControlRect(cppArg0, cppArg1, cppArg2, cppArg3);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_subControlRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_subElementRect(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.subElementRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_subElementRect_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QStyleFunc_subElementRect_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:subElementRect", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QStyle::subElementRect(QStyle::SubElement,const QStyleOption*,const QWidget*)const
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSTYLEOPTION_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // subElementRect(QStyle::SubElement,const QStyleOption*,const QWidget*)const
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2])))) {
            overloadId = 0; // subElementRect(QStyle::SubElement,const QStyleOption*,const QWidget*)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_subElementRect_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_widget = Shiboken::String::createStaticString("widget");
            if (PyDict_Contains(kwds, key_widget)) {
                value = PyDict_GetItem(kwds, key_widget);
                if (value && pyArgs[2]) {
                    errInfo = key_widget;
                    Py_INCREF(errInfo);
                    goto Sbk_QStyleFunc_subElementRect_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[2]))))
                        goto Sbk_QStyleFunc_subElementRect_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_widget);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QStyleFunc_subElementRect_TypeError;
            }
        }
        ::QStyle::SubElement cppArg0{QStyle::SE_PushButtonContents};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QStyleOption *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QWidget *cppArg2 = nullptr;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // subElementRect(QStyle::SubElement,const QStyleOption*,const QWidget*)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QStyle.subElementRect()' not implemented.");
                return {};
            }
            QRect cppResult = const_cast<const ::QStyle *>(cppSelf)->subElementRect(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_subElementRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_unpolish(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.unpolish";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QStyle::unpolish(QWidget*)
    // 1: QStyle::unpolish(QApplication*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QAPPLICATION_IDX]), (pyArg)))) {
        overloadId = 1; // unpolish(QApplication*)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // unpolish(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_unpolish_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // unpolish(QWidget * widget)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // unpolish(QWidget*)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QStyle::unpolish(cppArg0)
                    : cppSelf->unpolish(cppArg0);
            }
            break;
        }
        case 1: // unpolish(QApplication * application)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QApplication *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // unpolish(QApplication*)
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? cppSelf->::QStyle::unpolish(cppArg0)
                    : cppSelf->unpolish(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QStyleFunc_unpolish_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_visualAlignment(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.visualAlignment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "visualAlignment", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QStyle::visualAlignment(Qt::LayoutDirection,QFlags<Qt::AlignmentFlag>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[1])))) {
        overloadId = 0; // visualAlignment(Qt::LayoutDirection,QFlags<Qt::AlignmentFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_visualAlignment_TypeError;

    // Call function/method
    {
        ::Qt::LayoutDirection cppArg0{Qt::LeftToRight};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QFlags<Qt::AlignmentFlag> cppArg1 = QFlags<Qt::AlignmentFlag>(0);
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // visualAlignment(Qt::LayoutDirection,QFlags<Qt::AlignmentFlag>)
            QFlags<Qt::AlignmentFlag> cppResult = ::QStyle::visualAlignment(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_visualAlignment_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_visualPos(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.visualPos";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "visualPos", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QStyle::visualPos(Qt::LayoutDirection,QRect,QPoint)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // visualPos(Qt::LayoutDirection,QRect,QPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_visualPos_TypeError;

    // Call function/method
    {
        ::Qt::LayoutDirection cppArg0{Qt::LeftToRight};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRect cppArg1_local;
        ::QRect *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QPoint cppArg2_local;
        ::QPoint *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // visualPos(Qt::LayoutDirection,QRect,QPoint)
            QPoint cppResult = ::QStyle::visualPos(cppArg0, *cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_visualPos_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QStyleFunc_visualRect(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QStyle.visualRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "visualRect", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: static QStyle::visualRect(Qt::LayoutDirection,QRect,QRect)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_LAYOUTDIRECTION_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArgs[2])))) {
        overloadId = 0; // visualRect(Qt::LayoutDirection,QRect,QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QStyleFunc_visualRect_TypeError;

    // Call function/method
    {
        ::Qt::LayoutDirection cppArg0{Qt::LeftToRight};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QRect cppArg1_local;
        ::QRect *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QRect cppArg2_local;
        ::QRect *cppArg2 = &cppArg2_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);


        if (!PyErr_Occurred()) {
            // visualRect(Qt::LayoutDirection,QRect,QRect)
            QRect cppResult = ::QStyle::visualRect(cppArg0, *cppArg1, *cppArg2);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QStyleFunc_visualRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QStyle_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QStyle_methods[] = {
    {"alignedRect", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_alignedRect), METH_VARARGS|METH_STATIC},
    {"combinedLayoutSpacing", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_combinedLayoutSpacing), METH_VARARGS|METH_KEYWORDS},
    {"drawComplexControl", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_drawComplexControl), METH_VARARGS|METH_KEYWORDS},
    {"drawControl", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_drawControl), METH_VARARGS|METH_KEYWORDS},
    {"drawItemPixmap", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_drawItemPixmap), METH_VARARGS},
    {"drawItemText", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_drawItemText), METH_VARARGS|METH_KEYWORDS},
    {"drawPrimitive", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_drawPrimitive), METH_VARARGS|METH_KEYWORDS},
    {"generatedIconPixmap", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_generatedIconPixmap), METH_VARARGS},
    {"hitTestComplexControl", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_hitTestComplexControl), METH_VARARGS|METH_KEYWORDS},
    {"itemPixmapRect", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_itemPixmapRect), METH_VARARGS},
    {"itemTextRect", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_itemTextRect), METH_VARARGS},
    {"layoutSpacing", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_layoutSpacing), METH_VARARGS|METH_KEYWORDS},
    {"pixelMetric", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_pixelMetric), METH_VARARGS|METH_KEYWORDS},
    {"polish", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_polish), METH_O},
    {"proxy", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_proxy), METH_NOARGS},
    {"sizeFromContents", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_sizeFromContents), METH_VARARGS|METH_KEYWORDS},
    {"sliderPositionFromValue", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_sliderPositionFromValue), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"sliderValueFromPosition", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_sliderValueFromPosition), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"standardIcon", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_standardIcon), METH_VARARGS|METH_KEYWORDS},
    {"standardPalette", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_standardPalette), METH_NOARGS},
    {"standardPixmap", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_standardPixmap), METH_VARARGS|METH_KEYWORDS},
    {"styleHint", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_styleHint), METH_VARARGS|METH_KEYWORDS},
    {"subControlRect", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_subControlRect), METH_VARARGS|METH_KEYWORDS},
    {"subElementRect", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_subElementRect), METH_VARARGS|METH_KEYWORDS},
    {"unpolish", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_unpolish), METH_O},
    {"visualAlignment", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_visualAlignment), METH_VARARGS|METH_STATIC},
    {"visualPos", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_visualPos), METH_VARARGS|METH_STATIC},
    {"visualRect", reinterpret_cast<PyCFunction>(Sbk_QStyleFunc_visualRect), METH_VARARGS|METH_STATIC},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QStyle_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QStyle *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QStyleWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QStyle_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QStyle_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QStyle_Type = nullptr;
static SbkObjectType *Sbk_QStyle_TypeF(void)
{
    return _Sbk_QStyle_Type;
}

static PyType_Slot Sbk_QStyle_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QStyle_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QStyle_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QStyle_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QStyle_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QStyle_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QStyle_spec = {
    "2:PySide2.QtWidgets.QStyle",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QStyle_slots
};

} //extern "C"

static void *Sbk_QStyle_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QStyle *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtWidgets_QStyle_StateFlag___and__(PyObject *self, PyObject *pyArg)
{
    ::QStyle::State cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyle::State>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyle::State>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyle::State>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyle::State>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_STATEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyle_StateFlag___or__(PyObject *self, PyObject *pyArg)
{
    ::QStyle::State cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyle::State>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyle::State>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyle::State>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyle::State>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_STATEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyle_StateFlag___xor__(PyObject *self, PyObject *pyArg)
{
    ::QStyle::State cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyle::State>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyle::State>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyle::State>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyle::State>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_STATEFLAG_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyle_StateFlag___invert__(PyObject *self, PyObject *pyArg)
{
    ::QStyle::State cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_STATEFLAG_IDX])->converter, self, &cppSelf);
    ::QStyle::State cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_STATEFLAG_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QStyle_StateFlag_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_STATEFLAG_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QStyle_StateFlag__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_STATEFLAG_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QStyle_StateFlag_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_StateFlag__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_StateFlag__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_StateFlag_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_StateFlag___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_StateFlag___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_StateFlag___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_StateFlag___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_StateFlag_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_StateFlag_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_StateFlag_long)},
#endif
    {0, nullptr} // sentinel
};


PyObject *SbkPySide2_QtWidgets_QStyle_SubControl___and__(PyObject *self, PyObject *pyArg)
{
    ::QStyle::SubControls cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyle::SubControls>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyle::SubControls>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyle::SubControls>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyle::SubControls>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyle_SubControl___or__(PyObject *self, PyObject *pyArg)
{
    ::QStyle::SubControls cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyle::SubControls>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyle::SubControls>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyle::SubControls>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyle::SubControls>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyle_SubControl___xor__(PyObject *self, PyObject *pyArg)
{
    ::QStyle::SubControls cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QStyle::SubControls>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QStyle::SubControls>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QStyle::SubControls>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QStyle::SubControls>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QStyle_SubControl___invert__(PyObject *self, PyObject *pyArg)
{
    ::QStyle::SubControls cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL_IDX])->converter, self, &cppSelf);
    ::QStyle::SubControls cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QStyle_SubControl_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QStyle_SubControl__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QStyle_SubControl_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_SubControl__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_SubControl__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_SubControl_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_SubControl___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_SubControl___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_SubControl___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_SubControl___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_SubControl_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_SubControl_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QStyle_SubControl_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QStyle_StateFlag_PythonToCpp_QStyle_StateFlag(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyle::StateFlag *>(cppOut) =
        static_cast<::QStyle::StateFlag>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyle_StateFlag_PythonToCpp_QStyle_StateFlag_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX]))
        return QStyle_StateFlag_PythonToCpp_QStyle_StateFlag;
    return {};
}
static PyObject *QStyle_StateFlag_CppToPython_QStyle_StateFlag(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyle::StateFlag *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX], castCppIn);

}

static void QFlags_QStyle_StateFlag__PythonToCpp_QFlags_QStyle_StateFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyle::StateFlag> *>(cppOut) =
        ::QFlags<QStyle::StateFlag>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QStyle_StateFlag__PythonToCpp_QFlags_QStyle_StateFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_STATEFLAG_IDX]))
        return QFlags_QStyle_StateFlag__PythonToCpp_QFlags_QStyle_StateFlag_;
    return {};
}
static PyObject *QFlags_QStyle_StateFlag__CppToPython_QFlags_QStyle_StateFlag_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QStyle::StateFlag> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_STATEFLAG_IDX]));

}

static void QStyle_StateFlag_PythonToCpp_QFlags_QStyle_StateFlag_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyle::StateFlag> *>(cppOut) =
        ::QFlags<QStyle::StateFlag>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QStyle_StateFlag_PythonToCpp_QFlags_QStyle_StateFlag__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX]))
        return QStyle_StateFlag_PythonToCpp_QFlags_QStyle_StateFlag_;
    return {};
}
static void number_PythonToCpp_QFlags_QStyle_StateFlag_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QStyle::StateFlag> *>(cppOut) =
        ::QFlags<QStyle::StateFlag>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QStyle_StateFlag__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX]))
        return number_PythonToCpp_QFlags_QStyle_StateFlag_;
    return {};
}
static void QStyle_PrimitiveElement_PythonToCpp_QStyle_PrimitiveElement(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyle::PrimitiveElement *>(cppOut) =
        static_cast<::QStyle::PrimitiveElement>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyle_PrimitiveElement_PythonToCpp_QStyle_PrimitiveElement_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX]))
        return QStyle_PrimitiveElement_PythonToCpp_QStyle_PrimitiveElement;
    return {};
}
static PyObject *QStyle_PrimitiveElement_CppToPython_QStyle_PrimitiveElement(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyle::PrimitiveElement *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX], castCppIn);

}

static void QStyle_ControlElement_PythonToCpp_QStyle_ControlElement(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyle::ControlElement *>(cppOut) =
        static_cast<::QStyle::ControlElement>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyle_ControlElement_PythonToCpp_QStyle_ControlElement_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX]))
        return QStyle_ControlElement_PythonToCpp_QStyle_ControlElement;
    return {};
}
static PyObject *QStyle_ControlElement_CppToPython_QStyle_ControlElement(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyle::ControlElement *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX], castCppIn);

}

static void QStyle_SubElement_PythonToCpp_QStyle_SubElement(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyle::SubElement *>(cppOut) =
        static_cast<::QStyle::SubElement>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyle_SubElement_PythonToCpp_QStyle_SubElement_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX]))
        return QStyle_SubElement_PythonToCpp_QStyle_SubElement;
    return {};
}
static PyObject *QStyle_SubElement_CppToPython_QStyle_SubElement(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyle::SubElement *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX], castCppIn);

}

static void QStyle_ComplexControl_PythonToCpp_QStyle_ComplexControl(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyle::ComplexControl *>(cppOut) =
        static_cast<::QStyle::ComplexControl>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyle_ComplexControl_PythonToCpp_QStyle_ComplexControl_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX]))
        return QStyle_ComplexControl_PythonToCpp_QStyle_ComplexControl;
    return {};
}
static PyObject *QStyle_ComplexControl_CppToPython_QStyle_ComplexControl(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyle::ComplexControl *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX], castCppIn);

}

static void QStyle_SubControl_PythonToCpp_QStyle_SubControl(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyle::SubControl *>(cppOut) =
        static_cast<::QStyle::SubControl>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyle_SubControl_PythonToCpp_QStyle_SubControl_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX]))
        return QStyle_SubControl_PythonToCpp_QStyle_SubControl;
    return {};
}
static PyObject *QStyle_SubControl_CppToPython_QStyle_SubControl(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyle::SubControl *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX], castCppIn);

}

static void QFlags_QStyle_SubControl__PythonToCpp_QFlags_QStyle_SubControl_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyle::SubControl> *>(cppOut) =
        ::QFlags<QStyle::SubControl>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QStyle_SubControl__PythonToCpp_QFlags_QStyle_SubControl__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL_IDX]))
        return QFlags_QStyle_SubControl__PythonToCpp_QFlags_QStyle_SubControl_;
    return {};
}
static PyObject *QFlags_QStyle_SubControl__CppToPython_QFlags_QStyle_SubControl_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QStyle::SubControl> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL_IDX]));

}

static void QStyle_SubControl_PythonToCpp_QFlags_QStyle_SubControl_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QStyle::SubControl> *>(cppOut) =
        ::QFlags<QStyle::SubControl>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QStyle_SubControl_PythonToCpp_QFlags_QStyle_SubControl__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX]))
        return QStyle_SubControl_PythonToCpp_QFlags_QStyle_SubControl_;
    return {};
}
static void number_PythonToCpp_QFlags_QStyle_SubControl_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QStyle::SubControl> *>(cppOut) =
        ::QFlags<QStyle::SubControl>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QStyle_SubControl__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX]))
        return number_PythonToCpp_QFlags_QStyle_SubControl_;
    return {};
}
static void QStyle_PixelMetric_PythonToCpp_QStyle_PixelMetric(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyle::PixelMetric *>(cppOut) =
        static_cast<::QStyle::PixelMetric>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyle_PixelMetric_PythonToCpp_QStyle_PixelMetric_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX]))
        return QStyle_PixelMetric_PythonToCpp_QStyle_PixelMetric;
    return {};
}
static PyObject *QStyle_PixelMetric_CppToPython_QStyle_PixelMetric(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyle::PixelMetric *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX], castCppIn);

}

static void QStyle_ContentsType_PythonToCpp_QStyle_ContentsType(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyle::ContentsType *>(cppOut) =
        static_cast<::QStyle::ContentsType>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyle_ContentsType_PythonToCpp_QStyle_ContentsType_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX]))
        return QStyle_ContentsType_PythonToCpp_QStyle_ContentsType;
    return {};
}
static PyObject *QStyle_ContentsType_CppToPython_QStyle_ContentsType(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyle::ContentsType *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX], castCppIn);

}

static void QStyle_RequestSoftwareInputPanel_PythonToCpp_QStyle_RequestSoftwareInputPanel(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyle::RequestSoftwareInputPanel *>(cppOut) =
        static_cast<::QStyle::RequestSoftwareInputPanel>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyle_RequestSoftwareInputPanel_PythonToCpp_QStyle_RequestSoftwareInputPanel_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_REQUESTSOFTWAREINPUTPANEL_IDX]))
        return QStyle_RequestSoftwareInputPanel_PythonToCpp_QStyle_RequestSoftwareInputPanel;
    return {};
}
static PyObject *QStyle_RequestSoftwareInputPanel_CppToPython_QStyle_RequestSoftwareInputPanel(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyle::RequestSoftwareInputPanel *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_REQUESTSOFTWAREINPUTPANEL_IDX], castCppIn);

}

static void QStyle_StyleHint_PythonToCpp_QStyle_StyleHint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyle::StyleHint *>(cppOut) =
        static_cast<::QStyle::StyleHint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyle_StyleHint_PythonToCpp_QStyle_StyleHint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX]))
        return QStyle_StyleHint_PythonToCpp_QStyle_StyleHint;
    return {};
}
static PyObject *QStyle_StyleHint_CppToPython_QStyle_StyleHint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyle::StyleHint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX], castCppIn);

}

static void QStyle_StandardPixmap_PythonToCpp_QStyle_StandardPixmap(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QStyle::StandardPixmap *>(cppOut) =
        static_cast<::QStyle::StandardPixmap>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QStyle_StandardPixmap_PythonToCpp_QStyle_StandardPixmap_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX]))
        return QStyle_StandardPixmap_PythonToCpp_QStyle_StandardPixmap;
    return {};
}
static PyObject *QStyle_StandardPixmap_CppToPython_QStyle_StandardPixmap(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QStyle::StandardPixmap *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QStyle_PythonToCpp_QStyle_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QStyle_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QStyle_PythonToCpp_QStyle_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QStyle_TypeF())))
        return QStyle_PythonToCpp_QStyle_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QStyle_PTR_CppToPython_QStyle(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QStyle *>(const_cast<void *>(cppIn)), Sbk_QStyle_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QStyle_SignatureStrings[] = {
    "PySide2.QtWidgets.QStyle(self)",
    "PySide2.QtWidgets.QStyle.alignedRect(direction:PySide2.QtCore.Qt.LayoutDirection,alignment:PySide2.QtCore.Qt.Alignment,size:PySide2.QtCore.QSize,rectangle:PySide2.QtCore.QRect)->PySide2.QtCore.QRect",
    "PySide2.QtWidgets.QStyle.combinedLayoutSpacing(self,controls1:PySide2.QtWidgets.QSizePolicy.ControlTypes,controls2:PySide2.QtWidgets.QSizePolicy.ControlTypes,orientation:PySide2.QtCore.Qt.Orientation,option:PySide2.QtWidgets.QStyleOption=nullptr,widget:PySide2.QtWidgets.QWidget=nullptr)->int",
    "PySide2.QtWidgets.QStyle.drawComplexControl(self,cc:PySide2.QtWidgets.QStyle.ComplexControl,opt:PySide2.QtWidgets.QStyleOptionComplex,p:PySide2.QtGui.QPainter,widget:PySide2.QtWidgets.QWidget=0)",
    "PySide2.QtWidgets.QStyle.drawControl(self,element:PySide2.QtWidgets.QStyle.ControlElement,opt:PySide2.QtWidgets.QStyleOption,p:PySide2.QtGui.QPainter,widget:PySide2.QtWidgets.QWidget=0)",
    "PySide2.QtWidgets.QStyle.drawItemPixmap(self,painter:PySide2.QtGui.QPainter,rect:PySide2.QtCore.QRect,alignment:int,pixmap:PySide2.QtGui.QPixmap)",
    "PySide2.QtWidgets.QStyle.drawItemText(self,painter:PySide2.QtGui.QPainter,rect:PySide2.QtCore.QRect,flags:int,pal:PySide2.QtGui.QPalette,enabled:bool,text:QString,textRole:PySide2.QtGui.QPalette.ColorRole=QPalette.NoRole)",
    "PySide2.QtWidgets.QStyle.drawPrimitive(self,pe:PySide2.QtWidgets.QStyle.PrimitiveElement,opt:PySide2.QtWidgets.QStyleOption,p:PySide2.QtGui.QPainter,widget:PySide2.QtWidgets.QWidget=0)",
    "PySide2.QtWidgets.QStyle.generatedIconPixmap(self,iconMode:PySide2.QtGui.QIcon.Mode,pixmap:PySide2.QtGui.QPixmap,opt:PySide2.QtWidgets.QStyleOption)->PySide2.QtGui.QPixmap",
    "PySide2.QtWidgets.QStyle.hitTestComplexControl(self,cc:PySide2.QtWidgets.QStyle.ComplexControl,opt:PySide2.QtWidgets.QStyleOptionComplex,pt:PySide2.QtCore.QPoint,widget:PySide2.QtWidgets.QWidget=0)->PySide2.QtWidgets.QStyle.SubControl",
    "PySide2.QtWidgets.QStyle.itemPixmapRect(self,r:PySide2.QtCore.QRect,flags:int,pixmap:PySide2.QtGui.QPixmap)->PySide2.QtCore.QRect",
    "PySide2.QtWidgets.QStyle.itemTextRect(self,fm:PySide2.QtGui.QFontMetrics,r:PySide2.QtCore.QRect,flags:int,enabled:bool,text:QString)->PySide2.QtCore.QRect",
    "PySide2.QtWidgets.QStyle.layoutSpacing(self,control1:PySide2.QtWidgets.QSizePolicy.ControlType,control2:PySide2.QtWidgets.QSizePolicy.ControlType,orientation:PySide2.QtCore.Qt.Orientation,option:PySide2.QtWidgets.QStyleOption=nullptr,widget:PySide2.QtWidgets.QWidget=nullptr)->int",
    "PySide2.QtWidgets.QStyle.pixelMetric(self,metric:PySide2.QtWidgets.QStyle.PixelMetric,option:PySide2.QtWidgets.QStyleOption=nullptr,widget:PySide2.QtWidgets.QWidget=nullptr)->int",
    "2:PySide2.QtWidgets.QStyle.polish(self,widget:PySide2.QtWidgets.QWidget)",
    "1:PySide2.QtWidgets.QStyle.polish(self,palette:PySide2.QtGui.QPalette)",
    "0:PySide2.QtWidgets.QStyle.polish(self,application:PySide2.QtWidgets.QApplication)",
    "PySide2.QtWidgets.QStyle.proxy(self)->PySide2.QtWidgets.QStyle",
    "PySide2.QtWidgets.QStyle.sizeFromContents(self,ct:PySide2.QtWidgets.QStyle.ContentsType,opt:PySide2.QtWidgets.QStyleOption,contentsSize:PySide2.QtCore.QSize,w:PySide2.QtWidgets.QWidget=nullptr)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QStyle.sliderPositionFromValue(min:int,max:int,val:int,space:int,upsideDown:bool=false)->int",
    "PySide2.QtWidgets.QStyle.sliderValueFromPosition(min:int,max:int,pos:int,space:int,upsideDown:bool=false)->int",
    "PySide2.QtWidgets.QStyle.standardIcon(self,standardIcon:PySide2.QtWidgets.QStyle.StandardPixmap,option:PySide2.QtWidgets.QStyleOption=nullptr,widget:PySide2.QtWidgets.QWidget=nullptr)->PySide2.QtGui.QIcon",
    "PySide2.QtWidgets.QStyle.standardPalette(self)->PySide2.QtGui.QPalette",
    "PySide2.QtWidgets.QStyle.standardPixmap(self,standardPixmap:PySide2.QtWidgets.QStyle.StandardPixmap,opt:PySide2.QtWidgets.QStyleOption=nullptr,widget:PySide2.QtWidgets.QWidget=nullptr)->PySide2.QtGui.QPixmap",
    "PySide2.QtWidgets.QStyle.styleHint(self,stylehint:PySide2.QtWidgets.QStyle.StyleHint,opt:PySide2.QtWidgets.QStyleOption=nullptr,widget:PySide2.QtWidgets.QWidget=nullptr,returnData:PySide2.QtWidgets.QStyleHintReturn=nullptr)->int",
    "PySide2.QtWidgets.QStyle.subControlRect(self,cc:PySide2.QtWidgets.QStyle.ComplexControl,opt:PySide2.QtWidgets.QStyleOptionComplex,sc:PySide2.QtWidgets.QStyle.SubControl,widget:PySide2.QtWidgets.QWidget=nullptr)->PySide2.QtCore.QRect",
    "PySide2.QtWidgets.QStyle.subElementRect(self,subElement:PySide2.QtWidgets.QStyle.SubElement,option:PySide2.QtWidgets.QStyleOption,widget:PySide2.QtWidgets.QWidget=nullptr)->PySide2.QtCore.QRect",
    "1:PySide2.QtWidgets.QStyle.unpolish(self,widget:PySide2.QtWidgets.QWidget)",
    "0:PySide2.QtWidgets.QStyle.unpolish(self,application:PySide2.QtWidgets.QApplication)",
    "PySide2.QtWidgets.QStyle.visualAlignment(direction:PySide2.QtCore.Qt.LayoutDirection,alignment:PySide2.QtCore.Qt.Alignment)->PySide2.QtCore.Qt.Alignment",
    "PySide2.QtWidgets.QStyle.visualPos(direction:PySide2.QtCore.Qt.LayoutDirection,boundingRect:PySide2.QtCore.QRect,logicalPos:PySide2.QtCore.QPoint)->PySide2.QtCore.QPoint",
    "PySide2.QtWidgets.QStyle.visualRect(direction:PySide2.QtCore.Qt.LayoutDirection,boundingRect:PySide2.QtCore.QRect,logicalRect:PySide2.QtCore.QRect)->PySide2.QtCore.QRect",
    nullptr}; // Sentinel

void init_QStyle(PyObject *module)
{
    _Sbk_QStyle_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QStyle",
        "QStyle*",
        &Sbk_QStyle_spec,
        &Shiboken::callCppDestructor< ::QStyle >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QStyle_Type);
    InitSignatureStrings(pyType, QStyle_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QStyle_Type), Sbk_QStyle_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QStyle_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QStyle_TypeF(),
        QStyle_PythonToCpp_QStyle_PTR,
        is_QStyle_PythonToCpp_QStyle_PTR_Convertible,
        QStyle_PTR_CppToPython_QStyle);

    Shiboken::Conversions::registerConverterName(converter, "QStyle");
    Shiboken::Conversions::registerConverterName(converter, "QStyle*");
    Shiboken::Conversions::registerConverterName(converter, "QStyle&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyle).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QStyleWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QStyle_TypeF(), &Sbk_QStyle_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'StateFlag'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_STATEFLAG_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QStyle.State", SbkPySide2_QtWidgets_QStyle_StateFlag_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyle_TypeF(),
        "StateFlag",
        "2:PySide2.QtWidgets.QStyle.StateFlag",
        "QStyle::StateFlag",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_STATEFLAG_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_None", (long) QStyle::StateFlag::State_None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Enabled", (long) QStyle::StateFlag::State_Enabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Raised", (long) QStyle::StateFlag::State_Raised))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Sunken", (long) QStyle::StateFlag::State_Sunken))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Off", (long) QStyle::StateFlag::State_Off))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_NoChange", (long) QStyle::StateFlag::State_NoChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_On", (long) QStyle::StateFlag::State_On))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_DownArrow", (long) QStyle::StateFlag::State_DownArrow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Horizontal", (long) QStyle::StateFlag::State_Horizontal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_HasFocus", (long) QStyle::StateFlag::State_HasFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Top", (long) QStyle::StateFlag::State_Top))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Bottom", (long) QStyle::StateFlag::State_Bottom))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_FocusAtBorder", (long) QStyle::StateFlag::State_FocusAtBorder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_AutoRaise", (long) QStyle::StateFlag::State_AutoRaise))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_MouseOver", (long) QStyle::StateFlag::State_MouseOver))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_UpArrow", (long) QStyle::StateFlag::State_UpArrow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Selected", (long) QStyle::StateFlag::State_Selected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Active", (long) QStyle::StateFlag::State_Active))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Window", (long) QStyle::StateFlag::State_Window))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Open", (long) QStyle::StateFlag::State_Open))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Children", (long) QStyle::StateFlag::State_Children))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Item", (long) QStyle::StateFlag::State_Item))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Sibling", (long) QStyle::StateFlag::State_Sibling))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Editing", (long) QStyle::StateFlag::State_Editing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_KeyboardFocusChange", (long) QStyle::StateFlag::State_KeyboardFocusChange))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_ReadOnly", (long) QStyle::StateFlag::State_ReadOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Small", (long) QStyle::StateFlag::State_Small))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
        Sbk_QStyle_TypeF(), "State_Mini", (long) QStyle::StateFlag::State_Mini))
        return;
    // Register converter for enum 'QStyle::StateFlag'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX],
            QStyle_StateFlag_CppToPython_QStyle_StateFlag);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyle_StateFlag_PythonToCpp_QStyle_StateFlag,
            is_QStyle_StateFlag_PythonToCpp_QStyle_StateFlag_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STATEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyle::StateFlag");
        Shiboken::Conversions::registerConverterName(converter, "StateFlag");
    }
    // Register converter for flag 'QFlags<QStyle::StateFlag>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_STATEFLAG_IDX],
            QFlags_QStyle_StateFlag__CppToPython_QFlags_QStyle_StateFlag_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyle_StateFlag_PythonToCpp_QFlags_QStyle_StateFlag_,
            is_QStyle_StateFlag_PythonToCpp_QFlags_QStyle_StateFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QStyle_StateFlag__PythonToCpp_QFlags_QStyle_StateFlag_,
            is_QFlags_QStyle_StateFlag__PythonToCpp_QFlags_QStyle_StateFlag__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QStyle_StateFlag_,
            is_number_PythonToCpp_QFlags_QStyle_StateFlag__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_STATEFLAG_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyle::State");
        Shiboken::Conversions::registerConverterName(converter, "State");
    }
    // End of 'StateFlag' enum/flags.

    // Initialization of enum 'PrimitiveElement'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyle_TypeF(),
        "PrimitiveElement",
        "2:PySide2.QtWidgets.QStyle.PrimitiveElement",
        "QStyle::PrimitiveElement");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_Frame", (long) QStyle::PrimitiveElement::PE_Frame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_FrameDefaultButton", (long) QStyle::PrimitiveElement::PE_FrameDefaultButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_FrameDockWidget", (long) QStyle::PrimitiveElement::PE_FrameDockWidget))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_FrameFocusRect", (long) QStyle::PrimitiveElement::PE_FrameFocusRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_FrameGroupBox", (long) QStyle::PrimitiveElement::PE_FrameGroupBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_FrameLineEdit", (long) QStyle::PrimitiveElement::PE_FrameLineEdit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_FrameMenu", (long) QStyle::PrimitiveElement::PE_FrameMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_FrameStatusBarItem", (long) QStyle::PrimitiveElement::PE_FrameStatusBarItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_FrameStatusBar", (long) QStyle::PrimitiveElement::PE_FrameStatusBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_FrameTabWidget", (long) QStyle::PrimitiveElement::PE_FrameTabWidget))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_FrameWindow", (long) QStyle::PrimitiveElement::PE_FrameWindow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_FrameButtonBevel", (long) QStyle::PrimitiveElement::PE_FrameButtonBevel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_FrameButtonTool", (long) QStyle::PrimitiveElement::PE_FrameButtonTool))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_FrameTabBarBase", (long) QStyle::PrimitiveElement::PE_FrameTabBarBase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_PanelButtonCommand", (long) QStyle::PrimitiveElement::PE_PanelButtonCommand))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_PanelButtonBevel", (long) QStyle::PrimitiveElement::PE_PanelButtonBevel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_PanelButtonTool", (long) QStyle::PrimitiveElement::PE_PanelButtonTool))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_PanelMenuBar", (long) QStyle::PrimitiveElement::PE_PanelMenuBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_PanelToolBar", (long) QStyle::PrimitiveElement::PE_PanelToolBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_PanelLineEdit", (long) QStyle::PrimitiveElement::PE_PanelLineEdit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorArrowDown", (long) QStyle::PrimitiveElement::PE_IndicatorArrowDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorArrowLeft", (long) QStyle::PrimitiveElement::PE_IndicatorArrowLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorArrowRight", (long) QStyle::PrimitiveElement::PE_IndicatorArrowRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorArrowUp", (long) QStyle::PrimitiveElement::PE_IndicatorArrowUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorBranch", (long) QStyle::PrimitiveElement::PE_IndicatorBranch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorButtonDropDown", (long) QStyle::PrimitiveElement::PE_IndicatorButtonDropDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorItemViewItemCheck", (long) QStyle::PrimitiveElement::PE_IndicatorItemViewItemCheck))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorViewItemCheck", (long) QStyle::PrimitiveElement::PE_IndicatorViewItemCheck))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorCheckBox", (long) QStyle::PrimitiveElement::PE_IndicatorCheckBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorDockWidgetResizeHandle", (long) QStyle::PrimitiveElement::PE_IndicatorDockWidgetResizeHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorHeaderArrow", (long) QStyle::PrimitiveElement::PE_IndicatorHeaderArrow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorMenuCheckMark", (long) QStyle::PrimitiveElement::PE_IndicatorMenuCheckMark))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorProgressChunk", (long) QStyle::PrimitiveElement::PE_IndicatorProgressChunk))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorRadioButton", (long) QStyle::PrimitiveElement::PE_IndicatorRadioButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorSpinDown", (long) QStyle::PrimitiveElement::PE_IndicatorSpinDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorSpinMinus", (long) QStyle::PrimitiveElement::PE_IndicatorSpinMinus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorSpinPlus", (long) QStyle::PrimitiveElement::PE_IndicatorSpinPlus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorSpinUp", (long) QStyle::PrimitiveElement::PE_IndicatorSpinUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorToolBarHandle", (long) QStyle::PrimitiveElement::PE_IndicatorToolBarHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorToolBarSeparator", (long) QStyle::PrimitiveElement::PE_IndicatorToolBarSeparator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_PanelTipLabel", (long) QStyle::PrimitiveElement::PE_PanelTipLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorTabTear", (long) QStyle::PrimitiveElement::PE_IndicatorTabTear))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorTabTearLeft", (long) QStyle::PrimitiveElement::PE_IndicatorTabTearLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_PanelScrollAreaCorner", (long) QStyle::PrimitiveElement::PE_PanelScrollAreaCorner))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_Widget", (long) QStyle::PrimitiveElement::PE_Widget))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorColumnViewArrow", (long) QStyle::PrimitiveElement::PE_IndicatorColumnViewArrow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorItemViewItemDrop", (long) QStyle::PrimitiveElement::PE_IndicatorItemViewItemDrop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_PanelItemViewItem", (long) QStyle::PrimitiveElement::PE_PanelItemViewItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_PanelItemViewRow", (long) QStyle::PrimitiveElement::PE_PanelItemViewRow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_PanelStatusBar", (long) QStyle::PrimitiveElement::PE_PanelStatusBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorTabClose", (long) QStyle::PrimitiveElement::PE_IndicatorTabClose))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_PanelMenu", (long) QStyle::PrimitiveElement::PE_PanelMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_IndicatorTabTearRight", (long) QStyle::PrimitiveElement::PE_IndicatorTabTearRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
        Sbk_QStyle_TypeF(), "PE_CustomBase", (long) QStyle::PrimitiveElement::PE_CustomBase))
        return;
    // Register converter for enum 'QStyle::PrimitiveElement'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX],
            QStyle_PrimitiveElement_CppToPython_QStyle_PrimitiveElement);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyle_PrimitiveElement_PythonToCpp_QStyle_PrimitiveElement,
            is_QStyle_PrimitiveElement_PythonToCpp_QStyle_PrimitiveElement_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PRIMITIVEELEMENT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyle::PrimitiveElement");
        Shiboken::Conversions::registerConverterName(converter, "PrimitiveElement");
    }
    // End of 'PrimitiveElement' enum.

    // Initialization of enum 'ControlElement'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyle_TypeF(),
        "ControlElement",
        "2:PySide2.QtWidgets.QStyle.ControlElement",
        "QStyle::ControlElement");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_PushButton", (long) QStyle::ControlElement::CE_PushButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_PushButtonBevel", (long) QStyle::ControlElement::CE_PushButtonBevel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_PushButtonLabel", (long) QStyle::ControlElement::CE_PushButtonLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_CheckBox", (long) QStyle::ControlElement::CE_CheckBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_CheckBoxLabel", (long) QStyle::ControlElement::CE_CheckBoxLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_RadioButton", (long) QStyle::ControlElement::CE_RadioButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_RadioButtonLabel", (long) QStyle::ControlElement::CE_RadioButtonLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_TabBarTab", (long) QStyle::ControlElement::CE_TabBarTab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_TabBarTabShape", (long) QStyle::ControlElement::CE_TabBarTabShape))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_TabBarTabLabel", (long) QStyle::ControlElement::CE_TabBarTabLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ProgressBar", (long) QStyle::ControlElement::CE_ProgressBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ProgressBarGroove", (long) QStyle::ControlElement::CE_ProgressBarGroove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ProgressBarContents", (long) QStyle::ControlElement::CE_ProgressBarContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ProgressBarLabel", (long) QStyle::ControlElement::CE_ProgressBarLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_MenuItem", (long) QStyle::ControlElement::CE_MenuItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_MenuScroller", (long) QStyle::ControlElement::CE_MenuScroller))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_MenuVMargin", (long) QStyle::ControlElement::CE_MenuVMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_MenuHMargin", (long) QStyle::ControlElement::CE_MenuHMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_MenuTearoff", (long) QStyle::ControlElement::CE_MenuTearoff))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_MenuEmptyArea", (long) QStyle::ControlElement::CE_MenuEmptyArea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_MenuBarItem", (long) QStyle::ControlElement::CE_MenuBarItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_MenuBarEmptyArea", (long) QStyle::ControlElement::CE_MenuBarEmptyArea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ToolButtonLabel", (long) QStyle::ControlElement::CE_ToolButtonLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_Header", (long) QStyle::ControlElement::CE_Header))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_HeaderSection", (long) QStyle::ControlElement::CE_HeaderSection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_HeaderLabel", (long) QStyle::ControlElement::CE_HeaderLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ToolBoxTab", (long) QStyle::ControlElement::CE_ToolBoxTab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_SizeGrip", (long) QStyle::ControlElement::CE_SizeGrip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_Splitter", (long) QStyle::ControlElement::CE_Splitter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_RubberBand", (long) QStyle::ControlElement::CE_RubberBand))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_DockWidgetTitle", (long) QStyle::ControlElement::CE_DockWidgetTitle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ScrollBarAddLine", (long) QStyle::ControlElement::CE_ScrollBarAddLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ScrollBarSubLine", (long) QStyle::ControlElement::CE_ScrollBarSubLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ScrollBarAddPage", (long) QStyle::ControlElement::CE_ScrollBarAddPage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ScrollBarSubPage", (long) QStyle::ControlElement::CE_ScrollBarSubPage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ScrollBarSlider", (long) QStyle::ControlElement::CE_ScrollBarSlider))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ScrollBarFirst", (long) QStyle::ControlElement::CE_ScrollBarFirst))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ScrollBarLast", (long) QStyle::ControlElement::CE_ScrollBarLast))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_FocusFrame", (long) QStyle::ControlElement::CE_FocusFrame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ComboBoxLabel", (long) QStyle::ControlElement::CE_ComboBoxLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ToolBar", (long) QStyle::ControlElement::CE_ToolBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ToolBoxTabShape", (long) QStyle::ControlElement::CE_ToolBoxTabShape))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ToolBoxTabLabel", (long) QStyle::ControlElement::CE_ToolBoxTabLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_HeaderEmptyArea", (long) QStyle::ControlElement::CE_HeaderEmptyArea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ColumnViewGrip", (long) QStyle::ControlElement::CE_ColumnViewGrip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ItemViewItem", (long) QStyle::ControlElement::CE_ItemViewItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_ShapedFrame", (long) QStyle::ControlElement::CE_ShapedFrame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
        Sbk_QStyle_TypeF(), "CE_CustomBase", (long) QStyle::ControlElement::CE_CustomBase))
        return;
    // Register converter for enum 'QStyle::ControlElement'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX],
            QStyle_ControlElement_CppToPython_QStyle_ControlElement);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyle_ControlElement_PythonToCpp_QStyle_ControlElement,
            is_QStyle_ControlElement_PythonToCpp_QStyle_ControlElement_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTROLELEMENT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyle::ControlElement");
        Shiboken::Conversions::registerConverterName(converter, "ControlElement");
    }
    // End of 'ControlElement' enum.

    // Initialization of enum 'SubElement'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyle_TypeF(),
        "SubElement",
        "2:PySide2.QtWidgets.QStyle.SubElement",
        "QStyle::SubElement");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_PushButtonContents", (long) QStyle::SubElement::SE_PushButtonContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_PushButtonFocusRect", (long) QStyle::SubElement::SE_PushButtonFocusRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_CheckBoxIndicator", (long) QStyle::SubElement::SE_CheckBoxIndicator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_CheckBoxContents", (long) QStyle::SubElement::SE_CheckBoxContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_CheckBoxFocusRect", (long) QStyle::SubElement::SE_CheckBoxFocusRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_CheckBoxClickRect", (long) QStyle::SubElement::SE_CheckBoxClickRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_RadioButtonIndicator", (long) QStyle::SubElement::SE_RadioButtonIndicator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_RadioButtonContents", (long) QStyle::SubElement::SE_RadioButtonContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_RadioButtonFocusRect", (long) QStyle::SubElement::SE_RadioButtonFocusRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_RadioButtonClickRect", (long) QStyle::SubElement::SE_RadioButtonClickRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ComboBoxFocusRect", (long) QStyle::SubElement::SE_ComboBoxFocusRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_SliderFocusRect", (long) QStyle::SubElement::SE_SliderFocusRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ProgressBarGroove", (long) QStyle::SubElement::SE_ProgressBarGroove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ProgressBarContents", (long) QStyle::SubElement::SE_ProgressBarContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ProgressBarLabel", (long) QStyle::SubElement::SE_ProgressBarLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ToolBoxTabContents", (long) QStyle::SubElement::SE_ToolBoxTabContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_HeaderLabel", (long) QStyle::SubElement::SE_HeaderLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_HeaderArrow", (long) QStyle::SubElement::SE_HeaderArrow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabWidgetTabBar", (long) QStyle::SubElement::SE_TabWidgetTabBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabWidgetTabPane", (long) QStyle::SubElement::SE_TabWidgetTabPane))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabWidgetTabContents", (long) QStyle::SubElement::SE_TabWidgetTabContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabWidgetLeftCorner", (long) QStyle::SubElement::SE_TabWidgetLeftCorner))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabWidgetRightCorner", (long) QStyle::SubElement::SE_TabWidgetRightCorner))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ItemViewItemCheckIndicator", (long) QStyle::SubElement::SE_ItemViewItemCheckIndicator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ViewItemCheckIndicator", (long) QStyle::SubElement::SE_ViewItemCheckIndicator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabBarTearIndicator", (long) QStyle::SubElement::SE_TabBarTearIndicator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabBarTearIndicatorLeft", (long) QStyle::SubElement::SE_TabBarTearIndicatorLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TreeViewDisclosureItem", (long) QStyle::SubElement::SE_TreeViewDisclosureItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_LineEditContents", (long) QStyle::SubElement::SE_LineEditContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_FrameContents", (long) QStyle::SubElement::SE_FrameContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_DockWidgetCloseButton", (long) QStyle::SubElement::SE_DockWidgetCloseButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_DockWidgetFloatButton", (long) QStyle::SubElement::SE_DockWidgetFloatButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_DockWidgetTitleBarText", (long) QStyle::SubElement::SE_DockWidgetTitleBarText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_DockWidgetIcon", (long) QStyle::SubElement::SE_DockWidgetIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_CheckBoxLayoutItem", (long) QStyle::SubElement::SE_CheckBoxLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ComboBoxLayoutItem", (long) QStyle::SubElement::SE_ComboBoxLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_DateTimeEditLayoutItem", (long) QStyle::SubElement::SE_DateTimeEditLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_DialogButtonBoxLayoutItem", (long) QStyle::SubElement::SE_DialogButtonBoxLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_LabelLayoutItem", (long) QStyle::SubElement::SE_LabelLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ProgressBarLayoutItem", (long) QStyle::SubElement::SE_ProgressBarLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_PushButtonLayoutItem", (long) QStyle::SubElement::SE_PushButtonLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_RadioButtonLayoutItem", (long) QStyle::SubElement::SE_RadioButtonLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_SliderLayoutItem", (long) QStyle::SubElement::SE_SliderLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_SpinBoxLayoutItem", (long) QStyle::SubElement::SE_SpinBoxLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ToolButtonLayoutItem", (long) QStyle::SubElement::SE_ToolButtonLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_FrameLayoutItem", (long) QStyle::SubElement::SE_FrameLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_GroupBoxLayoutItem", (long) QStyle::SubElement::SE_GroupBoxLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabWidgetLayoutItem", (long) QStyle::SubElement::SE_TabWidgetLayoutItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ItemViewItemDecoration", (long) QStyle::SubElement::SE_ItemViewItemDecoration))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ItemViewItemText", (long) QStyle::SubElement::SE_ItemViewItemText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ItemViewItemFocusRect", (long) QStyle::SubElement::SE_ItemViewItemFocusRect))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabBarTabLeftButton", (long) QStyle::SubElement::SE_TabBarTabLeftButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabBarTabRightButton", (long) QStyle::SubElement::SE_TabBarTabRightButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabBarTabText", (long) QStyle::SubElement::SE_TabBarTabText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ShapedFrameContents", (long) QStyle::SubElement::SE_ShapedFrameContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_ToolBarHandle", (long) QStyle::SubElement::SE_ToolBarHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabBarScrollLeftButton", (long) QStyle::SubElement::SE_TabBarScrollLeftButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabBarScrollRightButton", (long) QStyle::SubElement::SE_TabBarScrollRightButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_TabBarTearIndicatorRight", (long) QStyle::SubElement::SE_TabBarTearIndicatorRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_PushButtonBevel", (long) QStyle::SubElement::SE_PushButtonBevel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
        Sbk_QStyle_TypeF(), "SE_CustomBase", (long) QStyle::SubElement::SE_CustomBase))
        return;
    // Register converter for enum 'QStyle::SubElement'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX],
            QStyle_SubElement_CppToPython_QStyle_SubElement);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyle_SubElement_PythonToCpp_QStyle_SubElement,
            is_QStyle_SubElement_PythonToCpp_QStyle_SubElement_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBELEMENT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyle::SubElement");
        Shiboken::Conversions::registerConverterName(converter, "SubElement");
    }
    // End of 'SubElement' enum.

    // Initialization of enum 'ComplexControl'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyle_TypeF(),
        "ComplexControl",
        "2:PySide2.QtWidgets.QStyle.ComplexControl",
        "QStyle::ComplexControl");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX],
        Sbk_QStyle_TypeF(), "CC_SpinBox", (long) QStyle::ComplexControl::CC_SpinBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX],
        Sbk_QStyle_TypeF(), "CC_ComboBox", (long) QStyle::ComplexControl::CC_ComboBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX],
        Sbk_QStyle_TypeF(), "CC_ScrollBar", (long) QStyle::ComplexControl::CC_ScrollBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX],
        Sbk_QStyle_TypeF(), "CC_Slider", (long) QStyle::ComplexControl::CC_Slider))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX],
        Sbk_QStyle_TypeF(), "CC_ToolButton", (long) QStyle::ComplexControl::CC_ToolButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX],
        Sbk_QStyle_TypeF(), "CC_TitleBar", (long) QStyle::ComplexControl::CC_TitleBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX],
        Sbk_QStyle_TypeF(), "CC_Dial", (long) QStyle::ComplexControl::CC_Dial))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX],
        Sbk_QStyle_TypeF(), "CC_GroupBox", (long) QStyle::ComplexControl::CC_GroupBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX],
        Sbk_QStyle_TypeF(), "CC_MdiControls", (long) QStyle::ComplexControl::CC_MdiControls))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX],
        Sbk_QStyle_TypeF(), "CC_CustomBase", (long) QStyle::ComplexControl::CC_CustomBase))
        return;
    // Register converter for enum 'QStyle::ComplexControl'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX],
            QStyle_ComplexControl_CppToPython_QStyle_ComplexControl);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyle_ComplexControl_PythonToCpp_QStyle_ComplexControl,
            is_QStyle_ComplexControl_PythonToCpp_QStyle_ComplexControl_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_COMPLEXCONTROL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyle::ComplexControl");
        Shiboken::Conversions::registerConverterName(converter, "ComplexControl");
    }
    // End of 'ComplexControl' enum.

    // Initialization of enum 'SubControl'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QStyle.SubControls", SbkPySide2_QtWidgets_QStyle_SubControl_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyle_TypeF(),
        "SubControl",
        "2:PySide2.QtWidgets.QStyle.SubControl",
        "QStyle::SubControl",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_None", (long) QStyle::SubControl::SC_None))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ScrollBarAddLine", (long) QStyle::SubControl::SC_ScrollBarAddLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ScrollBarSubLine", (long) QStyle::SubControl::SC_ScrollBarSubLine))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ScrollBarAddPage", (long) QStyle::SubControl::SC_ScrollBarAddPage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ScrollBarSubPage", (long) QStyle::SubControl::SC_ScrollBarSubPage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ScrollBarFirst", (long) QStyle::SubControl::SC_ScrollBarFirst))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ScrollBarLast", (long) QStyle::SubControl::SC_ScrollBarLast))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ScrollBarSlider", (long) QStyle::SubControl::SC_ScrollBarSlider))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ScrollBarGroove", (long) QStyle::SubControl::SC_ScrollBarGroove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_SpinBoxUp", (long) QStyle::SubControl::SC_SpinBoxUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_SpinBoxDown", (long) QStyle::SubControl::SC_SpinBoxDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_SpinBoxFrame", (long) QStyle::SubControl::SC_SpinBoxFrame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_SpinBoxEditField", (long) QStyle::SubControl::SC_SpinBoxEditField))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ComboBoxFrame", (long) QStyle::SubControl::SC_ComboBoxFrame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ComboBoxEditField", (long) QStyle::SubControl::SC_ComboBoxEditField))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ComboBoxArrow", (long) QStyle::SubControl::SC_ComboBoxArrow))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ComboBoxListBoxPopup", (long) QStyle::SubControl::SC_ComboBoxListBoxPopup))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_SliderGroove", (long) QStyle::SubControl::SC_SliderGroove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_SliderHandle", (long) QStyle::SubControl::SC_SliderHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_SliderTickmarks", (long) QStyle::SubControl::SC_SliderTickmarks))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ToolButton", (long) QStyle::SubControl::SC_ToolButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_ToolButtonMenu", (long) QStyle::SubControl::SC_ToolButtonMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_TitleBarSysMenu", (long) QStyle::SubControl::SC_TitleBarSysMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_TitleBarMinButton", (long) QStyle::SubControl::SC_TitleBarMinButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_TitleBarMaxButton", (long) QStyle::SubControl::SC_TitleBarMaxButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_TitleBarCloseButton", (long) QStyle::SubControl::SC_TitleBarCloseButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_TitleBarNormalButton", (long) QStyle::SubControl::SC_TitleBarNormalButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_TitleBarShadeButton", (long) QStyle::SubControl::SC_TitleBarShadeButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_TitleBarUnshadeButton", (long) QStyle::SubControl::SC_TitleBarUnshadeButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_TitleBarContextHelpButton", (long) QStyle::SubControl::SC_TitleBarContextHelpButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_TitleBarLabel", (long) QStyle::SubControl::SC_TitleBarLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_DialGroove", (long) QStyle::SubControl::SC_DialGroove))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_DialHandle", (long) QStyle::SubControl::SC_DialHandle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_DialTickmarks", (long) QStyle::SubControl::SC_DialTickmarks))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_GroupBoxCheckBox", (long) QStyle::SubControl::SC_GroupBoxCheckBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_GroupBoxLabel", (long) QStyle::SubControl::SC_GroupBoxLabel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_GroupBoxContents", (long) QStyle::SubControl::SC_GroupBoxContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_GroupBoxFrame", (long) QStyle::SubControl::SC_GroupBoxFrame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_MdiMinButton", (long) QStyle::SubControl::SC_MdiMinButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_MdiNormalButton", (long) QStyle::SubControl::SC_MdiNormalButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_MdiCloseButton", (long) QStyle::SubControl::SC_MdiCloseButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_CustomBase", (long) QStyle::SubControl::SC_CustomBase))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
        Sbk_QStyle_TypeF(), "SC_All", (long) QStyle::SubControl::SC_All))
        return;
    // Register converter for enum 'QStyle::SubControl'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX],
            QStyle_SubControl_CppToPython_QStyle_SubControl);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyle_SubControl_PythonToCpp_QStyle_SubControl,
            is_QStyle_SubControl_PythonToCpp_QStyle_SubControl_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_SUBCONTROL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyle::SubControl");
        Shiboken::Conversions::registerConverterName(converter, "SubControl");
    }
    // Register converter for flag 'QFlags<QStyle::SubControl>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL_IDX],
            QFlags_QStyle_SubControl__CppToPython_QFlags_QStyle_SubControl_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyle_SubControl_PythonToCpp_QFlags_QStyle_SubControl_,
            is_QStyle_SubControl_PythonToCpp_QFlags_QStyle_SubControl__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QStyle_SubControl__PythonToCpp_QFlags_QStyle_SubControl_,
            is_QFlags_QStyle_SubControl__PythonToCpp_QFlags_QStyle_SubControl__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QStyle_SubControl_,
            is_number_PythonToCpp_QFlags_QStyle_SubControl__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSTYLE_SUBCONTROL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyle::SubControls");
        Shiboken::Conversions::registerConverterName(converter, "SubControls");
    }
    // End of 'SubControl' enum/flags.

    // Initialization of enum 'PixelMetric'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyle_TypeF(),
        "PixelMetric",
        "2:PySide2.QtWidgets.QStyle.PixelMetric",
        "QStyle::PixelMetric");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ButtonMargin", (long) QStyle::PixelMetric::PM_ButtonMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ButtonDefaultIndicator", (long) QStyle::PixelMetric::PM_ButtonDefaultIndicator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MenuButtonIndicator", (long) QStyle::PixelMetric::PM_MenuButtonIndicator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ButtonShiftHorizontal", (long) QStyle::PixelMetric::PM_ButtonShiftHorizontal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ButtonShiftVertical", (long) QStyle::PixelMetric::PM_ButtonShiftVertical))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_DefaultFrameWidth", (long) QStyle::PixelMetric::PM_DefaultFrameWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_SpinBoxFrameWidth", (long) QStyle::PixelMetric::PM_SpinBoxFrameWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ComboBoxFrameWidth", (long) QStyle::PixelMetric::PM_ComboBoxFrameWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MaximumDragDistance", (long) QStyle::PixelMetric::PM_MaximumDragDistance))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ScrollBarExtent", (long) QStyle::PixelMetric::PM_ScrollBarExtent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ScrollBarSliderMin", (long) QStyle::PixelMetric::PM_ScrollBarSliderMin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_SliderThickness", (long) QStyle::PixelMetric::PM_SliderThickness))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_SliderControlThickness", (long) QStyle::PixelMetric::PM_SliderControlThickness))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_SliderLength", (long) QStyle::PixelMetric::PM_SliderLength))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_SliderTickmarkOffset", (long) QStyle::PixelMetric::PM_SliderTickmarkOffset))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_SliderSpaceAvailable", (long) QStyle::PixelMetric::PM_SliderSpaceAvailable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_DockWidgetSeparatorExtent", (long) QStyle::PixelMetric::PM_DockWidgetSeparatorExtent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_DockWidgetHandleExtent", (long) QStyle::PixelMetric::PM_DockWidgetHandleExtent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_DockWidgetFrameWidth", (long) QStyle::PixelMetric::PM_DockWidgetFrameWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TabBarTabOverlap", (long) QStyle::PixelMetric::PM_TabBarTabOverlap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TabBarTabHSpace", (long) QStyle::PixelMetric::PM_TabBarTabHSpace))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TabBarTabVSpace", (long) QStyle::PixelMetric::PM_TabBarTabVSpace))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TabBarBaseHeight", (long) QStyle::PixelMetric::PM_TabBarBaseHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TabBarBaseOverlap", (long) QStyle::PixelMetric::PM_TabBarBaseOverlap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ProgressBarChunkWidth", (long) QStyle::PixelMetric::PM_ProgressBarChunkWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_SplitterWidth", (long) QStyle::PixelMetric::PM_SplitterWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TitleBarHeight", (long) QStyle::PixelMetric::PM_TitleBarHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MenuScrollerHeight", (long) QStyle::PixelMetric::PM_MenuScrollerHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MenuHMargin", (long) QStyle::PixelMetric::PM_MenuHMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MenuVMargin", (long) QStyle::PixelMetric::PM_MenuVMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MenuPanelWidth", (long) QStyle::PixelMetric::PM_MenuPanelWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MenuTearoffHeight", (long) QStyle::PixelMetric::PM_MenuTearoffHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MenuDesktopFrameWidth", (long) QStyle::PixelMetric::PM_MenuDesktopFrameWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MenuBarPanelWidth", (long) QStyle::PixelMetric::PM_MenuBarPanelWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MenuBarItemSpacing", (long) QStyle::PixelMetric::PM_MenuBarItemSpacing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MenuBarVMargin", (long) QStyle::PixelMetric::PM_MenuBarVMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MenuBarHMargin", (long) QStyle::PixelMetric::PM_MenuBarHMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_IndicatorWidth", (long) QStyle::PixelMetric::PM_IndicatorWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_IndicatorHeight", (long) QStyle::PixelMetric::PM_IndicatorHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ExclusiveIndicatorWidth", (long) QStyle::PixelMetric::PM_ExclusiveIndicatorWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ExclusiveIndicatorHeight", (long) QStyle::PixelMetric::PM_ExclusiveIndicatorHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_DialogButtonsSeparator", (long) QStyle::PixelMetric::PM_DialogButtonsSeparator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_DialogButtonsButtonWidth", (long) QStyle::PixelMetric::PM_DialogButtonsButtonWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_DialogButtonsButtonHeight", (long) QStyle::PixelMetric::PM_DialogButtonsButtonHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MdiSubWindowFrameWidth", (long) QStyle::PixelMetric::PM_MdiSubWindowFrameWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MdiSubWindowMinimizedWidth", (long) QStyle::PixelMetric::PM_MdiSubWindowMinimizedWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MDIFrameWidth", (long) QStyle::PixelMetric::PM_MDIFrameWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MDIMinimizedWidth", (long) QStyle::PixelMetric::PM_MDIMinimizedWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_HeaderMargin", (long) QStyle::PixelMetric::PM_HeaderMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_HeaderMarkSize", (long) QStyle::PixelMetric::PM_HeaderMarkSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_HeaderGripMargin", (long) QStyle::PixelMetric::PM_HeaderGripMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TabBarTabShiftHorizontal", (long) QStyle::PixelMetric::PM_TabBarTabShiftHorizontal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TabBarTabShiftVertical", (long) QStyle::PixelMetric::PM_TabBarTabShiftVertical))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TabBarScrollButtonWidth", (long) QStyle::PixelMetric::PM_TabBarScrollButtonWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ToolBarFrameWidth", (long) QStyle::PixelMetric::PM_ToolBarFrameWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ToolBarHandleExtent", (long) QStyle::PixelMetric::PM_ToolBarHandleExtent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ToolBarItemSpacing", (long) QStyle::PixelMetric::PM_ToolBarItemSpacing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ToolBarItemMargin", (long) QStyle::PixelMetric::PM_ToolBarItemMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ToolBarSeparatorExtent", (long) QStyle::PixelMetric::PM_ToolBarSeparatorExtent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ToolBarExtensionExtent", (long) QStyle::PixelMetric::PM_ToolBarExtensionExtent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_SpinBoxSliderHeight", (long) QStyle::PixelMetric::PM_SpinBoxSliderHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_DefaultTopLevelMargin", (long) QStyle::PixelMetric::PM_DefaultTopLevelMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_DefaultChildMargin", (long) QStyle::PixelMetric::PM_DefaultChildMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_DefaultLayoutSpacing", (long) QStyle::PixelMetric::PM_DefaultLayoutSpacing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ToolBarIconSize", (long) QStyle::PixelMetric::PM_ToolBarIconSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ListViewIconSize", (long) QStyle::PixelMetric::PM_ListViewIconSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_IconViewIconSize", (long) QStyle::PixelMetric::PM_IconViewIconSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_SmallIconSize", (long) QStyle::PixelMetric::PM_SmallIconSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_LargeIconSize", (long) QStyle::PixelMetric::PM_LargeIconSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_FocusFrameVMargin", (long) QStyle::PixelMetric::PM_FocusFrameVMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_FocusFrameHMargin", (long) QStyle::PixelMetric::PM_FocusFrameHMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ToolTipLabelFrameWidth", (long) QStyle::PixelMetric::PM_ToolTipLabelFrameWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_CheckBoxLabelSpacing", (long) QStyle::PixelMetric::PM_CheckBoxLabelSpacing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TabBarIconSize", (long) QStyle::PixelMetric::PM_TabBarIconSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_SizeGripSize", (long) QStyle::PixelMetric::PM_SizeGripSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_DockWidgetTitleMargin", (long) QStyle::PixelMetric::PM_DockWidgetTitleMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_MessageBoxIconSize", (long) QStyle::PixelMetric::PM_MessageBoxIconSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ButtonIconSize", (long) QStyle::PixelMetric::PM_ButtonIconSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_DockWidgetTitleBarButtonMargin", (long) QStyle::PixelMetric::PM_DockWidgetTitleBarButtonMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_RadioButtonLabelSpacing", (long) QStyle::PixelMetric::PM_RadioButtonLabelSpacing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_LayoutLeftMargin", (long) QStyle::PixelMetric::PM_LayoutLeftMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_LayoutTopMargin", (long) QStyle::PixelMetric::PM_LayoutTopMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_LayoutRightMargin", (long) QStyle::PixelMetric::PM_LayoutRightMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_LayoutBottomMargin", (long) QStyle::PixelMetric::PM_LayoutBottomMargin))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_LayoutHorizontalSpacing", (long) QStyle::PixelMetric::PM_LayoutHorizontalSpacing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_LayoutVerticalSpacing", (long) QStyle::PixelMetric::PM_LayoutVerticalSpacing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TabBar_ScrollButtonOverlap", (long) QStyle::PixelMetric::PM_TabBar_ScrollButtonOverlap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TextCursorWidth", (long) QStyle::PixelMetric::PM_TextCursorWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TabCloseIndicatorWidth", (long) QStyle::PixelMetric::PM_TabCloseIndicatorWidth))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TabCloseIndicatorHeight", (long) QStyle::PixelMetric::PM_TabCloseIndicatorHeight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ScrollView_ScrollBarSpacing", (long) QStyle::PixelMetric::PM_ScrollView_ScrollBarSpacing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_ScrollView_ScrollBarOverlap", (long) QStyle::PixelMetric::PM_ScrollView_ScrollBarOverlap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_SubMenuOverlap", (long) QStyle::PixelMetric::PM_SubMenuOverlap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TreeViewIndentation", (long) QStyle::PixelMetric::PM_TreeViewIndentation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_HeaderDefaultSectionSizeHorizontal", (long) QStyle::PixelMetric::PM_HeaderDefaultSectionSizeHorizontal))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_HeaderDefaultSectionSizeVertical", (long) QStyle::PixelMetric::PM_HeaderDefaultSectionSizeVertical))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TitleBarButtonIconSize", (long) QStyle::PixelMetric::PM_TitleBarButtonIconSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_TitleBarButtonSize", (long) QStyle::PixelMetric::PM_TitleBarButtonSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
        Sbk_QStyle_TypeF(), "PM_CustomBase", (long) QStyle::PixelMetric::PM_CustomBase))
        return;
    // Register converter for enum 'QStyle::PixelMetric'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX],
            QStyle_PixelMetric_CppToPython_QStyle_PixelMetric);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyle_PixelMetric_PythonToCpp_QStyle_PixelMetric,
            is_QStyle_PixelMetric_PythonToCpp_QStyle_PixelMetric_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_PIXELMETRIC_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyle::PixelMetric");
        Shiboken::Conversions::registerConverterName(converter, "PixelMetric");
    }
    // End of 'PixelMetric' enum.

    // Initialization of enum 'ContentsType'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyle_TypeF(),
        "ContentsType",
        "2:PySide2.QtWidgets.QStyle.ContentsType",
        "QStyle::ContentsType");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_PushButton", (long) QStyle::ContentsType::CT_PushButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_CheckBox", (long) QStyle::ContentsType::CT_CheckBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_RadioButton", (long) QStyle::ContentsType::CT_RadioButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_ToolButton", (long) QStyle::ContentsType::CT_ToolButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_ComboBox", (long) QStyle::ContentsType::CT_ComboBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_Splitter", (long) QStyle::ContentsType::CT_Splitter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_ProgressBar", (long) QStyle::ContentsType::CT_ProgressBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_MenuItem", (long) QStyle::ContentsType::CT_MenuItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_MenuBarItem", (long) QStyle::ContentsType::CT_MenuBarItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_MenuBar", (long) QStyle::ContentsType::CT_MenuBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_Menu", (long) QStyle::ContentsType::CT_Menu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_TabBarTab", (long) QStyle::ContentsType::CT_TabBarTab))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_Slider", (long) QStyle::ContentsType::CT_Slider))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_ScrollBar", (long) QStyle::ContentsType::CT_ScrollBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_LineEdit", (long) QStyle::ContentsType::CT_LineEdit))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_SpinBox", (long) QStyle::ContentsType::CT_SpinBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_SizeGrip", (long) QStyle::ContentsType::CT_SizeGrip))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_TabWidget", (long) QStyle::ContentsType::CT_TabWidget))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_DialogButtons", (long) QStyle::ContentsType::CT_DialogButtons))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_HeaderSection", (long) QStyle::ContentsType::CT_HeaderSection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_GroupBox", (long) QStyle::ContentsType::CT_GroupBox))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_MdiControls", (long) QStyle::ContentsType::CT_MdiControls))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_ItemViewItem", (long) QStyle::ContentsType::CT_ItemViewItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
        Sbk_QStyle_TypeF(), "CT_CustomBase", (long) QStyle::ContentsType::CT_CustomBase))
        return;
    // Register converter for enum 'QStyle::ContentsType'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX],
            QStyle_ContentsType_CppToPython_QStyle_ContentsType);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyle_ContentsType_PythonToCpp_QStyle_ContentsType,
            is_QStyle_ContentsType_PythonToCpp_QStyle_ContentsType_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_CONTENTSTYPE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyle::ContentsType");
        Shiboken::Conversions::registerConverterName(converter, "ContentsType");
    }
    // End of 'ContentsType' enum.

    // Initialization of enum 'RequestSoftwareInputPanel'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_REQUESTSOFTWAREINPUTPANEL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyle_TypeF(),
        "RequestSoftwareInputPanel",
        "2:PySide2.QtWidgets.QStyle.RequestSoftwareInputPanel",
        "QStyle::RequestSoftwareInputPanel");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_REQUESTSOFTWAREINPUTPANEL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_REQUESTSOFTWAREINPUTPANEL_IDX],
        Sbk_QStyle_TypeF(), "RSIP_OnMouseClickAndAlreadyFocused", (long) QStyle::RequestSoftwareInputPanel::RSIP_OnMouseClickAndAlreadyFocused))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_REQUESTSOFTWAREINPUTPANEL_IDX],
        Sbk_QStyle_TypeF(), "RSIP_OnMouseClick", (long) QStyle::RequestSoftwareInputPanel::RSIP_OnMouseClick))
        return;
    // Register converter for enum 'QStyle::RequestSoftwareInputPanel'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_REQUESTSOFTWAREINPUTPANEL_IDX],
            QStyle_RequestSoftwareInputPanel_CppToPython_QStyle_RequestSoftwareInputPanel);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyle_RequestSoftwareInputPanel_PythonToCpp_QStyle_RequestSoftwareInputPanel,
            is_QStyle_RequestSoftwareInputPanel_PythonToCpp_QStyle_RequestSoftwareInputPanel_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_REQUESTSOFTWAREINPUTPANEL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyle::RequestSoftwareInputPanel");
        Shiboken::Conversions::registerConverterName(converter, "RequestSoftwareInputPanel");
    }
    // End of 'RequestSoftwareInputPanel' enum.

    // Initialization of enum 'StyleHint'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyle_TypeF(),
        "StyleHint",
        "2:PySide2.QtWidgets.QStyle.StyleHint",
        "QStyle::StyleHint");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_EtchDisabledText", (long) QStyle::StyleHint::SH_EtchDisabledText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_DitherDisabledText", (long) QStyle::StyleHint::SH_DitherDisabledText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ScrollBar_MiddleClickAbsolutePosition", (long) QStyle::StyleHint::SH_ScrollBar_MiddleClickAbsolutePosition))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ScrollBar_ScrollWhenPointerLeavesControl", (long) QStyle::StyleHint::SH_ScrollBar_ScrollWhenPointerLeavesControl))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_TabBar_SelectMouseType", (long) QStyle::StyleHint::SH_TabBar_SelectMouseType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_TabBar_Alignment", (long) QStyle::StyleHint::SH_TabBar_Alignment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Header_ArrowAlignment", (long) QStyle::StyleHint::SH_Header_ArrowAlignment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Slider_SnapToValue", (long) QStyle::StyleHint::SH_Slider_SnapToValue))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Slider_SloppyKeyEvents", (long) QStyle::StyleHint::SH_Slider_SloppyKeyEvents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ProgressDialog_CenterCancelButton", (long) QStyle::StyleHint::SH_ProgressDialog_CenterCancelButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ProgressDialog_TextLabelAlignment", (long) QStyle::StyleHint::SH_ProgressDialog_TextLabelAlignment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_PrintDialog_RightAlignButtons", (long) QStyle::StyleHint::SH_PrintDialog_RightAlignButtons))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_MainWindow_SpaceBelowMenuBar", (long) QStyle::StyleHint::SH_MainWindow_SpaceBelowMenuBar))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_FontDialog_SelectAssociatedText", (long) QStyle::StyleHint::SH_FontDialog_SelectAssociatedText))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_AllowActiveAndDisabled", (long) QStyle::StyleHint::SH_Menu_AllowActiveAndDisabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_SpaceActivatesItem", (long) QStyle::StyleHint::SH_Menu_SpaceActivatesItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_SubMenuPopupDelay", (long) QStyle::StyleHint::SH_Menu_SubMenuPopupDelay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ScrollView_FrameOnlyAroundContents", (long) QStyle::StyleHint::SH_ScrollView_FrameOnlyAroundContents))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_MenuBar_AltKeyNavigation", (long) QStyle::StyleHint::SH_MenuBar_AltKeyNavigation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ComboBox_ListMouseTracking", (long) QStyle::StyleHint::SH_ComboBox_ListMouseTracking))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_MouseTracking", (long) QStyle::StyleHint::SH_Menu_MouseTracking))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_MenuBar_MouseTracking", (long) QStyle::StyleHint::SH_MenuBar_MouseTracking))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ItemView_ChangeHighlightOnFocus", (long) QStyle::StyleHint::SH_ItemView_ChangeHighlightOnFocus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Widget_ShareActivation", (long) QStyle::StyleHint::SH_Widget_ShareActivation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Workspace_FillSpaceOnMaximize", (long) QStyle::StyleHint::SH_Workspace_FillSpaceOnMaximize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ComboBox_Popup", (long) QStyle::StyleHint::SH_ComboBox_Popup))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_TitleBar_NoBorder", (long) QStyle::StyleHint::SH_TitleBar_NoBorder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Slider_StopMouseOverSlider", (long) QStyle::StyleHint::SH_Slider_StopMouseOverSlider))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ScrollBar_StopMouseOverSlider", (long) QStyle::StyleHint::SH_ScrollBar_StopMouseOverSlider))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_BlinkCursorWhenTextSelected", (long) QStyle::StyleHint::SH_BlinkCursorWhenTextSelected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_RichText_FullWidthSelection", (long) QStyle::StyleHint::SH_RichText_FullWidthSelection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_Scrollable", (long) QStyle::StyleHint::SH_Menu_Scrollable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_GroupBox_TextLabelVerticalAlignment", (long) QStyle::StyleHint::SH_GroupBox_TextLabelVerticalAlignment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_GroupBox_TextLabelColor", (long) QStyle::StyleHint::SH_GroupBox_TextLabelColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_SloppySubMenus", (long) QStyle::StyleHint::SH_Menu_SloppySubMenus))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Table_GridLineColor", (long) QStyle::StyleHint::SH_Table_GridLineColor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_LineEdit_PasswordCharacter", (long) QStyle::StyleHint::SH_LineEdit_PasswordCharacter))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_DialogButtons_DefaultButton", (long) QStyle::StyleHint::SH_DialogButtons_DefaultButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ToolBox_SelectedPageTitleBold", (long) QStyle::StyleHint::SH_ToolBox_SelectedPageTitleBold))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_TabBar_PreferNoArrows", (long) QStyle::StyleHint::SH_TabBar_PreferNoArrows))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ScrollBar_LeftClickAbsolutePosition", (long) QStyle::StyleHint::SH_ScrollBar_LeftClickAbsolutePosition))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ListViewExpand_SelectMouseType", (long) QStyle::StyleHint::SH_ListViewExpand_SelectMouseType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_UnderlineShortcut", (long) QStyle::StyleHint::SH_UnderlineShortcut))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_SpinBox_AnimateButton", (long) QStyle::StyleHint::SH_SpinBox_AnimateButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_SpinBox_KeyPressAutoRepeatRate", (long) QStyle::StyleHint::SH_SpinBox_KeyPressAutoRepeatRate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_SpinBox_ClickAutoRepeatRate", (long) QStyle::StyleHint::SH_SpinBox_ClickAutoRepeatRate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_FillScreenWithScroll", (long) QStyle::StyleHint::SH_Menu_FillScreenWithScroll))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ToolTipLabel_Opacity", (long) QStyle::StyleHint::SH_ToolTipLabel_Opacity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_DrawMenuBarSeparator", (long) QStyle::StyleHint::SH_DrawMenuBarSeparator))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_TitleBar_ModifyNotification", (long) QStyle::StyleHint::SH_TitleBar_ModifyNotification))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Button_FocusPolicy", (long) QStyle::StyleHint::SH_Button_FocusPolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_MessageBox_UseBorderForButtonSpacing", (long) QStyle::StyleHint::SH_MessageBox_UseBorderForButtonSpacing))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_TitleBar_AutoRaise", (long) QStyle::StyleHint::SH_TitleBar_AutoRaise))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ToolButton_PopupDelay", (long) QStyle::StyleHint::SH_ToolButton_PopupDelay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_FocusFrame_Mask", (long) QStyle::StyleHint::SH_FocusFrame_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_RubberBand_Mask", (long) QStyle::StyleHint::SH_RubberBand_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_WindowFrame_Mask", (long) QStyle::StyleHint::SH_WindowFrame_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_SpinControls_DisableOnBounds", (long) QStyle::StyleHint::SH_SpinControls_DisableOnBounds))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Dial_BackgroundRole", (long) QStyle::StyleHint::SH_Dial_BackgroundRole))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ComboBox_LayoutDirection", (long) QStyle::StyleHint::SH_ComboBox_LayoutDirection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ItemView_EllipsisLocation", (long) QStyle::StyleHint::SH_ItemView_EllipsisLocation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ItemView_ShowDecorationSelected", (long) QStyle::StyleHint::SH_ItemView_ShowDecorationSelected))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ItemView_ActivateItemOnSingleClick", (long) QStyle::StyleHint::SH_ItemView_ActivateItemOnSingleClick))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ScrollBar_ContextMenu", (long) QStyle::StyleHint::SH_ScrollBar_ContextMenu))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ScrollBar_RollBetweenButtons", (long) QStyle::StyleHint::SH_ScrollBar_RollBetweenButtons))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Slider_AbsoluteSetButtons", (long) QStyle::StyleHint::SH_Slider_AbsoluteSetButtons))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Slider_PageSetButtons", (long) QStyle::StyleHint::SH_Slider_PageSetButtons))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_KeyboardSearch", (long) QStyle::StyleHint::SH_Menu_KeyboardSearch))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_TabBar_ElideMode", (long) QStyle::StyleHint::SH_TabBar_ElideMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_DialogButtonLayout", (long) QStyle::StyleHint::SH_DialogButtonLayout))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ComboBox_PopupFrameStyle", (long) QStyle::StyleHint::SH_ComboBox_PopupFrameStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_MessageBox_TextInteractionFlags", (long) QStyle::StyleHint::SH_MessageBox_TextInteractionFlags))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_DialogButtonBox_ButtonsHaveIcons", (long) QStyle::StyleHint::SH_DialogButtonBox_ButtonsHaveIcons))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_SpellCheckUnderlineStyle", (long) QStyle::StyleHint::SH_SpellCheckUnderlineStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_MessageBox_CenterButtons", (long) QStyle::StyleHint::SH_MessageBox_CenterButtons))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_SelectionWrap", (long) QStyle::StyleHint::SH_Menu_SelectionWrap))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ItemView_MovementWithoutUpdatingSelection", (long) QStyle::StyleHint::SH_ItemView_MovementWithoutUpdatingSelection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ToolTip_Mask", (long) QStyle::StyleHint::SH_ToolTip_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_FocusFrame_AboveWidget", (long) QStyle::StyleHint::SH_FocusFrame_AboveWidget))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_TextControl_FocusIndicatorTextCharFormat", (long) QStyle::StyleHint::SH_TextControl_FocusIndicatorTextCharFormat))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_WizardStyle", (long) QStyle::StyleHint::SH_WizardStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ItemView_ArrowKeysNavigateIntoChildren", (long) QStyle::StyleHint::SH_ItemView_ArrowKeysNavigateIntoChildren))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_Mask", (long) QStyle::StyleHint::SH_Menu_Mask))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_FlashTriggeredItem", (long) QStyle::StyleHint::SH_Menu_FlashTriggeredItem))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_FadeOutOnHide", (long) QStyle::StyleHint::SH_Menu_FadeOutOnHide))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_SpinBox_ClickAutoRepeatThreshold", (long) QStyle::StyleHint::SH_SpinBox_ClickAutoRepeatThreshold))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ItemView_PaintAlternatingRowColorsForEmptyArea", (long) QStyle::StyleHint::SH_ItemView_PaintAlternatingRowColorsForEmptyArea))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_FormLayoutWrapPolicy", (long) QStyle::StyleHint::SH_FormLayoutWrapPolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_TabWidget_DefaultTabPosition", (long) QStyle::StyleHint::SH_TabWidget_DefaultTabPosition))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ToolBar_Movable", (long) QStyle::StyleHint::SH_ToolBar_Movable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_FormLayoutFieldGrowthPolicy", (long) QStyle::StyleHint::SH_FormLayoutFieldGrowthPolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_FormLayoutFormAlignment", (long) QStyle::StyleHint::SH_FormLayoutFormAlignment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_FormLayoutLabelAlignment", (long) QStyle::StyleHint::SH_FormLayoutLabelAlignment))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ItemView_DrawDelegateFrame", (long) QStyle::StyleHint::SH_ItemView_DrawDelegateFrame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_TabBar_CloseButtonPosition", (long) QStyle::StyleHint::SH_TabBar_CloseButtonPosition))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_DockWidget_ButtonsHaveFrame", (long) QStyle::StyleHint::SH_DockWidget_ButtonsHaveFrame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ToolButtonStyle", (long) QStyle::StyleHint::SH_ToolButtonStyle))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_RequestSoftwareInputPanel", (long) QStyle::StyleHint::SH_RequestSoftwareInputPanel))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ScrollBar_Transient", (long) QStyle::StyleHint::SH_ScrollBar_Transient))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_SupportsSections", (long) QStyle::StyleHint::SH_Menu_SupportsSections))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ToolTip_WakeUpDelay", (long) QStyle::StyleHint::SH_ToolTip_WakeUpDelay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ToolTip_FallAsleepDelay", (long) QStyle::StyleHint::SH_ToolTip_FallAsleepDelay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Widget_Animate", (long) QStyle::StyleHint::SH_Widget_Animate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Splitter_OpaqueResize", (long) QStyle::StyleHint::SH_Splitter_OpaqueResize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ComboBox_UseNativePopup", (long) QStyle::StyleHint::SH_ComboBox_UseNativePopup))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_LineEdit_PasswordMaskDelay", (long) QStyle::StyleHint::SH_LineEdit_PasswordMaskDelay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_TabBar_ChangeCurrentDelay", (long) QStyle::StyleHint::SH_TabBar_ChangeCurrentDelay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_SubMenuUniDirection", (long) QStyle::StyleHint::SH_Menu_SubMenuUniDirection))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_SubMenuUniDirectionFailCount", (long) QStyle::StyleHint::SH_Menu_SubMenuUniDirectionFailCount))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_SubMenuSloppySelectOtherActions", (long) QStyle::StyleHint::SH_Menu_SubMenuSloppySelectOtherActions))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_SubMenuSloppyCloseTimeout", (long) QStyle::StyleHint::SH_Menu_SubMenuSloppyCloseTimeout))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_SubMenuResetWhenReenteringParent", (long) QStyle::StyleHint::SH_Menu_SubMenuResetWhenReenteringParent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Menu_SubMenuDontStartSloppyOnLeave", (long) QStyle::StyleHint::SH_Menu_SubMenuDontStartSloppyOnLeave))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ItemView_ScrollMode", (long) QStyle::StyleHint::SH_ItemView_ScrollMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_TitleBar_ShowToolTipsOnButtons", (long) QStyle::StyleHint::SH_TitleBar_ShowToolTipsOnButtons))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_Widget_Animation_Duration", (long) QStyle::StyleHint::SH_Widget_Animation_Duration))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_ComboBox_AllowWheelScrolling", (long) QStyle::StyleHint::SH_ComboBox_AllowWheelScrolling))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_SpinBox_ButtonsInsideFrame", (long) QStyle::StyleHint::SH_SpinBox_ButtonsInsideFrame))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_SpinBox_StepModifier", (long) QStyle::StyleHint::SH_SpinBox_StepModifier))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
        Sbk_QStyle_TypeF(), "SH_CustomBase", (long) QStyle::StyleHint::SH_CustomBase))
        return;
    // Register converter for enum 'QStyle::StyleHint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX],
            QStyle_StyleHint_CppToPython_QStyle_StyleHint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyle_StyleHint_PythonToCpp_QStyle_StyleHint,
            is_QStyle_StyleHint_PythonToCpp_QStyle_StyleHint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STYLEHINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyle::StyleHint");
        Shiboken::Conversions::registerConverterName(converter, "StyleHint");
    }
    // End of 'StyleHint' enum.

    // Initialization of enum 'StandardPixmap'.
    SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QStyle_TypeF(),
        "StandardPixmap",
        "2:PySide2.QtWidgets.QStyle.StandardPixmap",
        "QStyle::StandardPixmap");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_TitleBarMenuButton", (long) QStyle::StandardPixmap::SP_TitleBarMenuButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_TitleBarMinButton", (long) QStyle::StandardPixmap::SP_TitleBarMinButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_TitleBarMaxButton", (long) QStyle::StandardPixmap::SP_TitleBarMaxButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_TitleBarCloseButton", (long) QStyle::StandardPixmap::SP_TitleBarCloseButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_TitleBarNormalButton", (long) QStyle::StandardPixmap::SP_TitleBarNormalButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_TitleBarShadeButton", (long) QStyle::StandardPixmap::SP_TitleBarShadeButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_TitleBarUnshadeButton", (long) QStyle::StandardPixmap::SP_TitleBarUnshadeButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_TitleBarContextHelpButton", (long) QStyle::StandardPixmap::SP_TitleBarContextHelpButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DockWidgetCloseButton", (long) QStyle::StandardPixmap::SP_DockWidgetCloseButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_MessageBoxInformation", (long) QStyle::StandardPixmap::SP_MessageBoxInformation))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_MessageBoxWarning", (long) QStyle::StandardPixmap::SP_MessageBoxWarning))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_MessageBoxCritical", (long) QStyle::StandardPixmap::SP_MessageBoxCritical))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_MessageBoxQuestion", (long) QStyle::StandardPixmap::SP_MessageBoxQuestion))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DesktopIcon", (long) QStyle::StandardPixmap::SP_DesktopIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_TrashIcon", (long) QStyle::StandardPixmap::SP_TrashIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_ComputerIcon", (long) QStyle::StandardPixmap::SP_ComputerIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DriveFDIcon", (long) QStyle::StandardPixmap::SP_DriveFDIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DriveHDIcon", (long) QStyle::StandardPixmap::SP_DriveHDIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DriveCDIcon", (long) QStyle::StandardPixmap::SP_DriveCDIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DriveDVDIcon", (long) QStyle::StandardPixmap::SP_DriveDVDIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DriveNetIcon", (long) QStyle::StandardPixmap::SP_DriveNetIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DirOpenIcon", (long) QStyle::StandardPixmap::SP_DirOpenIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DirClosedIcon", (long) QStyle::StandardPixmap::SP_DirClosedIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DirLinkIcon", (long) QStyle::StandardPixmap::SP_DirLinkIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DirLinkOpenIcon", (long) QStyle::StandardPixmap::SP_DirLinkOpenIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_FileIcon", (long) QStyle::StandardPixmap::SP_FileIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_FileLinkIcon", (long) QStyle::StandardPixmap::SP_FileLinkIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_ToolBarHorizontalExtensionButton", (long) QStyle::StandardPixmap::SP_ToolBarHorizontalExtensionButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_ToolBarVerticalExtensionButton", (long) QStyle::StandardPixmap::SP_ToolBarVerticalExtensionButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_FileDialogStart", (long) QStyle::StandardPixmap::SP_FileDialogStart))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_FileDialogEnd", (long) QStyle::StandardPixmap::SP_FileDialogEnd))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_FileDialogToParent", (long) QStyle::StandardPixmap::SP_FileDialogToParent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_FileDialogNewFolder", (long) QStyle::StandardPixmap::SP_FileDialogNewFolder))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_FileDialogDetailedView", (long) QStyle::StandardPixmap::SP_FileDialogDetailedView))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_FileDialogInfoView", (long) QStyle::StandardPixmap::SP_FileDialogInfoView))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_FileDialogContentsView", (long) QStyle::StandardPixmap::SP_FileDialogContentsView))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_FileDialogListView", (long) QStyle::StandardPixmap::SP_FileDialogListView))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_FileDialogBack", (long) QStyle::StandardPixmap::SP_FileDialogBack))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DirIcon", (long) QStyle::StandardPixmap::SP_DirIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogOkButton", (long) QStyle::StandardPixmap::SP_DialogOkButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogCancelButton", (long) QStyle::StandardPixmap::SP_DialogCancelButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogHelpButton", (long) QStyle::StandardPixmap::SP_DialogHelpButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogOpenButton", (long) QStyle::StandardPixmap::SP_DialogOpenButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogSaveButton", (long) QStyle::StandardPixmap::SP_DialogSaveButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogCloseButton", (long) QStyle::StandardPixmap::SP_DialogCloseButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogApplyButton", (long) QStyle::StandardPixmap::SP_DialogApplyButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogResetButton", (long) QStyle::StandardPixmap::SP_DialogResetButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogDiscardButton", (long) QStyle::StandardPixmap::SP_DialogDiscardButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogYesButton", (long) QStyle::StandardPixmap::SP_DialogYesButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogNoButton", (long) QStyle::StandardPixmap::SP_DialogNoButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_ArrowUp", (long) QStyle::StandardPixmap::SP_ArrowUp))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_ArrowDown", (long) QStyle::StandardPixmap::SP_ArrowDown))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_ArrowLeft", (long) QStyle::StandardPixmap::SP_ArrowLeft))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_ArrowRight", (long) QStyle::StandardPixmap::SP_ArrowRight))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_ArrowBack", (long) QStyle::StandardPixmap::SP_ArrowBack))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_ArrowForward", (long) QStyle::StandardPixmap::SP_ArrowForward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DirHomeIcon", (long) QStyle::StandardPixmap::SP_DirHomeIcon))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_CommandLink", (long) QStyle::StandardPixmap::SP_CommandLink))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_VistaShield", (long) QStyle::StandardPixmap::SP_VistaShield))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_BrowserReload", (long) QStyle::StandardPixmap::SP_BrowserReload))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_BrowserStop", (long) QStyle::StandardPixmap::SP_BrowserStop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_MediaPlay", (long) QStyle::StandardPixmap::SP_MediaPlay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_MediaStop", (long) QStyle::StandardPixmap::SP_MediaStop))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_MediaPause", (long) QStyle::StandardPixmap::SP_MediaPause))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_MediaSkipForward", (long) QStyle::StandardPixmap::SP_MediaSkipForward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_MediaSkipBackward", (long) QStyle::StandardPixmap::SP_MediaSkipBackward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_MediaSeekForward", (long) QStyle::StandardPixmap::SP_MediaSeekForward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_MediaSeekBackward", (long) QStyle::StandardPixmap::SP_MediaSeekBackward))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_MediaVolume", (long) QStyle::StandardPixmap::SP_MediaVolume))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_MediaVolumeMuted", (long) QStyle::StandardPixmap::SP_MediaVolumeMuted))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_LineEditClearButton", (long) QStyle::StandardPixmap::SP_LineEditClearButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogYesToAllButton", (long) QStyle::StandardPixmap::SP_DialogYesToAllButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogNoToAllButton", (long) QStyle::StandardPixmap::SP_DialogNoToAllButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogSaveAllButton", (long) QStyle::StandardPixmap::SP_DialogSaveAllButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogAbortButton", (long) QStyle::StandardPixmap::SP_DialogAbortButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogRetryButton", (long) QStyle::StandardPixmap::SP_DialogRetryButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_DialogIgnoreButton", (long) QStyle::StandardPixmap::SP_DialogIgnoreButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_RestoreDefaultsButton", (long) QStyle::StandardPixmap::SP_RestoreDefaultsButton))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
        Sbk_QStyle_TypeF(), "SP_CustomBase", (long) QStyle::StandardPixmap::SP_CustomBase))
        return;
    // Register converter for enum 'QStyle::StandardPixmap'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX],
            QStyle_StandardPixmap_CppToPython_QStyle_StandardPixmap);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QStyle_StandardPixmap_PythonToCpp_QStyle_StandardPixmap,
            is_QStyle_StandardPixmap_PythonToCpp_QStyle_StandardPixmap_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSTYLE_STANDARDPIXMAP_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QStyle::StandardPixmap");
        Shiboken::Conversions::registerConverterName(converter, "StandardPixmap");
    }
    // End of 'StandardPixmap' enum.

    PySide::Signal::registerSignals(Sbk_QStyle_TypeF(), &::QStyle::staticMetaObject);
    qRegisterMetaType< ::QStyle::StateFlag >("QStyle::StateFlag");
    qRegisterMetaType< ::QStyle::State >("QStyle::State");
    qRegisterMetaType< ::QStyle::PrimitiveElement >("QStyle::PrimitiveElement");
    qRegisterMetaType< ::QStyle::ControlElement >("QStyle::ControlElement");
    qRegisterMetaType< ::QStyle::SubElement >("QStyle::SubElement");
    qRegisterMetaType< ::QStyle::ComplexControl >("QStyle::ComplexControl");
    qRegisterMetaType< ::QStyle::SubControl >("QStyle::SubControl");
    qRegisterMetaType< ::QStyle::SubControls >("QStyle::SubControls");
    qRegisterMetaType< ::QStyle::PixelMetric >("QStyle::PixelMetric");
    qRegisterMetaType< ::QStyle::ContentsType >("QStyle::ContentsType");
    qRegisterMetaType< ::QStyle::RequestSoftwareInputPanel >("QStyle::RequestSoftwareInputPanel");
    qRegisterMetaType< ::QStyle::StyleHint >("QStyle::StyleHint");
    qRegisterMetaType< ::QStyle::StandardPixmap >("QStyle::StandardPixmap");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QStyle_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QStyle_TypeF(), &::QStyle::staticMetaObject, sizeof(QStyleWrapper));
}
