/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qscrollerproperties_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QScrollerPropertiesWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QScrollerPropertiesWrapper::QScrollerPropertiesWrapper() : QScrollerProperties()
{
    resetPyMethodCache();
    // ... middle
}

QScrollerPropertiesWrapper::~QScrollerPropertiesWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QScrollerProperties_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QScrollerProperties >()))
        return -1;

    ::QScrollerPropertiesWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScrollerProperties.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QScrollerProperties", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QScrollerProperties::QScrollerProperties()
    // 1: QScrollerProperties::QScrollerProperties(QScrollerProperties)
    if (numArgs == 0) {
        overloadId = 0; // QScrollerProperties()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QScrollerProperties(QScrollerProperties)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerProperties_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QScrollerProperties()
        {

            if (!PyErr_Occurred()) {
                // QScrollerProperties()
                cptr = new ::QScrollerPropertiesWrapper();
            }
            break;
        }
        case 1: // QScrollerProperties(const QScrollerProperties & sp)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QScrollerProperties cppArg0_local;
            ::QScrollerProperties *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QScrollerProperties(QScrollerProperties)
                cptr = new ::QScrollerPropertiesWrapper(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QScrollerProperties >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QScrollerProperties_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QScrollerProperties_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QScrollerPropertiesFunc_scrollMetric(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScrollerProperties *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScrollerProperties.scrollMetric";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QScrollerProperties::scrollMetric(QScrollerProperties::ScrollMetric)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX])->converter, (pyArg)))) {
        overloadId = 0; // scrollMetric(QScrollerProperties::ScrollMetric)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerPropertiesFunc_scrollMetric_TypeError;

    // Call function/method
    {
        ::QScrollerProperties::ScrollMetric cppArg0{QScrollerProperties::MousePressEventDelay};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // scrollMetric(QScrollerProperties::ScrollMetric)const
            QVariant cppResult = const_cast<const ::QScrollerProperties *>(cppSelf)->scrollMetric(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QScrollerPropertiesFunc_scrollMetric_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerPropertiesFunc_setDefaultScrollerProperties(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScrollerProperties.setDefaultScrollerProperties";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QScrollerProperties::setDefaultScrollerProperties(QScrollerProperties)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX]), (pyArg)))) {
        overloadId = 0; // setDefaultScrollerProperties(QScrollerProperties)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerPropertiesFunc_setDefaultScrollerProperties_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QScrollerProperties cppArg0_local;
        ::QScrollerProperties *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDefaultScrollerProperties(QScrollerProperties)
            ::QScrollerProperties::setDefaultScrollerProperties(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScrollerPropertiesFunc_setDefaultScrollerProperties_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerPropertiesFunc_setScrollMetric(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QScrollerProperties *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScrollerProperties.setScrollMetric";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setScrollMetric", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QScrollerProperties::setScrollMetric(QScrollerProperties::ScrollMetric,QVariant)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], (pyArgs[1])))) {
        overloadId = 0; // setScrollMetric(QScrollerProperties::ScrollMetric,QVariant)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QScrollerPropertiesFunc_setScrollMetric_TypeError;

    // Call function/method
    {
        ::QScrollerProperties::ScrollMetric cppArg0{QScrollerProperties::MousePressEventDelay};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QVariant cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setScrollMetric(QScrollerProperties::ScrollMetric,QVariant)
            cppSelf->setScrollMetric(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QScrollerPropertiesFunc_setScrollMetric_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QScrollerPropertiesFunc_unsetDefaultScrollerProperties(PyObject *self)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QScrollerProperties.unsetDefaultScrollerProperties";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unsetDefaultScrollerProperties()
            ::QScrollerProperties::unsetDefaultScrollerProperties();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QScrollerProperties___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QScrollerProperties *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QScrollerProperties_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QScrollerProperties_methods[] = {
    {"scrollMetric", reinterpret_cast<PyCFunction>(Sbk_QScrollerPropertiesFunc_scrollMetric), METH_O},
    {"setDefaultScrollerProperties", reinterpret_cast<PyCFunction>(Sbk_QScrollerPropertiesFunc_setDefaultScrollerProperties), METH_O|METH_STATIC},
    {"setScrollMetric", reinterpret_cast<PyCFunction>(Sbk_QScrollerPropertiesFunc_setScrollMetric), METH_VARARGS},
    {"unsetDefaultScrollerProperties", reinterpret_cast<PyCFunction>(Sbk_QScrollerPropertiesFunc_unsetDefaultScrollerProperties), METH_NOARGS|METH_STATIC},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QScrollerProperties___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QScrollerProperties_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QScrollerProperties *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QScrollerPropertiesWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

// Rich comparison
static PyObject * Sbk_QScrollerProperties_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QScrollerProperties *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX]), (pyArg)))) {
                // operator!=(const QScrollerProperties & sp) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QScrollerProperties cppArg0_local;
                ::QScrollerProperties *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX]), (pyArg)))) {
                // operator==(const QScrollerProperties & sp) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QScrollerProperties cppArg0_local;
                ::QScrollerProperties *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QScrollerProperties_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QScrollerProperties_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QScrollerProperties_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QScrollerProperties_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QScrollerProperties_Type = nullptr;
static SbkObjectType *Sbk_QScrollerProperties_TypeF(void)
{
    return _Sbk_QScrollerProperties_Type;
}

static PyType_Slot Sbk_QScrollerProperties_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QScrollerProperties_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QScrollerProperties_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QScrollerProperties_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QScrollerProperties_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QScrollerProperties_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QScrollerProperties_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QScrollerProperties_spec = {
    "2:PySide2.QtWidgets.QScrollerProperties",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QScrollerProperties_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QScrollerProperties_OvershootPolicy_PythonToCpp_QScrollerProperties_OvershootPolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScrollerProperties::OvershootPolicy *>(cppOut) =
        static_cast<::QScrollerProperties::OvershootPolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScrollerProperties_OvershootPolicy_PythonToCpp_QScrollerProperties_OvershootPolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_OVERSHOOTPOLICY_IDX]))
        return QScrollerProperties_OvershootPolicy_PythonToCpp_QScrollerProperties_OvershootPolicy;
    return {};
}
static PyObject *QScrollerProperties_OvershootPolicy_CppToPython_QScrollerProperties_OvershootPolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScrollerProperties::OvershootPolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_OVERSHOOTPOLICY_IDX], castCppIn);

}

static void QScrollerProperties_FrameRates_PythonToCpp_QScrollerProperties_FrameRates(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScrollerProperties::FrameRates *>(cppOut) =
        static_cast<::QScrollerProperties::FrameRates>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScrollerProperties_FrameRates_PythonToCpp_QScrollerProperties_FrameRates_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_FRAMERATES_IDX]))
        return QScrollerProperties_FrameRates_PythonToCpp_QScrollerProperties_FrameRates;
    return {};
}
static PyObject *QScrollerProperties_FrameRates_CppToPython_QScrollerProperties_FrameRates(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScrollerProperties::FrameRates *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_FRAMERATES_IDX], castCppIn);

}

static void QScrollerProperties_ScrollMetric_PythonToCpp_QScrollerProperties_ScrollMetric(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScrollerProperties::ScrollMetric *>(cppOut) =
        static_cast<::QScrollerProperties::ScrollMetric>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QScrollerProperties_ScrollMetric_PythonToCpp_QScrollerProperties_ScrollMetric_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX]))
        return QScrollerProperties_ScrollMetric_PythonToCpp_QScrollerProperties_ScrollMetric;
    return {};
}
static PyObject *QScrollerProperties_ScrollMetric_CppToPython_QScrollerProperties_ScrollMetric(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QScrollerProperties::ScrollMetric *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QScrollerProperties_PythonToCpp_QScrollerProperties_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QScrollerProperties_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QScrollerProperties_PythonToCpp_QScrollerProperties_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScrollerProperties_TypeF())))
        return QScrollerProperties_PythonToCpp_QScrollerProperties_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QScrollerProperties_PTR_CppToPython_QScrollerProperties(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QScrollerProperties *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QScrollerProperties_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QScrollerProperties_COPY_CppToPython_QScrollerProperties(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QScrollerProperties_TypeF(), new ::QScrollerPropertiesWrapper(*reinterpret_cast<const ::QScrollerProperties *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QScrollerProperties_PythonToCpp_QScrollerProperties_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QScrollerProperties *>(cppOut) = *reinterpret_cast< ::QScrollerProperties *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QScrollerProperties_PythonToCpp_QScrollerProperties_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QScrollerProperties_TypeF())))
        return QScrollerProperties_PythonToCpp_QScrollerProperties_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QScrollerProperties_SignatureStrings[] = {
    "1:PySide2.QtWidgets.QScrollerProperties(self)",
    "0:PySide2.QtWidgets.QScrollerProperties(self,sp:PySide2.QtWidgets.QScrollerProperties)",
    "PySide2.QtWidgets.QScrollerProperties.scrollMetric(self,metric:PySide2.QtWidgets.QScrollerProperties.ScrollMetric)->QVariant",
    "PySide2.QtWidgets.QScrollerProperties.setDefaultScrollerProperties(sp:PySide2.QtWidgets.QScrollerProperties)",
    "PySide2.QtWidgets.QScrollerProperties.setScrollMetric(self,metric:PySide2.QtWidgets.QScrollerProperties.ScrollMetric,value:QVariant)",
    "PySide2.QtWidgets.QScrollerProperties.unsetDefaultScrollerProperties()",
    "PySide2.QtWidgets.QScrollerProperties.__copy__()",
    nullptr}; // Sentinel

void init_QScrollerProperties(PyObject *module)
{
    _Sbk_QScrollerProperties_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QScrollerProperties",
        "QScrollerProperties",
        &Sbk_QScrollerProperties_spec,
        &Shiboken::callCppDestructor< ::QScrollerPropertiesWrapper >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QScrollerProperties_Type);
    InitSignatureStrings(pyType, QScrollerProperties_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QScrollerProperties_Type), Sbk_QScrollerProperties_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QScrollerProperties_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QScrollerProperties_TypeF(),
        QScrollerProperties_PythonToCpp_QScrollerProperties_PTR,
        is_QScrollerProperties_PythonToCpp_QScrollerProperties_PTR_Convertible,
        QScrollerProperties_PTR_CppToPython_QScrollerProperties,
        QScrollerProperties_COPY_CppToPython_QScrollerProperties);

    Shiboken::Conversions::registerConverterName(converter, "QScrollerProperties");
    Shiboken::Conversions::registerConverterName(converter, "QScrollerProperties*");
    Shiboken::Conversions::registerConverterName(converter, "QScrollerProperties&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScrollerProperties).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QScrollerPropertiesWrapper).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QScrollerProperties_PythonToCpp_QScrollerProperties_COPY,
        is_QScrollerProperties_PythonToCpp_QScrollerProperties_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'OvershootPolicy'.
    SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_OVERSHOOTPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScrollerProperties_TypeF(),
        "OvershootPolicy",
        "2:PySide2.QtWidgets.QScrollerProperties.OvershootPolicy",
        "QScrollerProperties::OvershootPolicy");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_OVERSHOOTPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_OVERSHOOTPOLICY_IDX],
        Sbk_QScrollerProperties_TypeF(), "OvershootWhenScrollable", (long) QScrollerProperties::OvershootPolicy::OvershootWhenScrollable))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_OVERSHOOTPOLICY_IDX],
        Sbk_QScrollerProperties_TypeF(), "OvershootAlwaysOff", (long) QScrollerProperties::OvershootPolicy::OvershootAlwaysOff))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_OVERSHOOTPOLICY_IDX],
        Sbk_QScrollerProperties_TypeF(), "OvershootAlwaysOn", (long) QScrollerProperties::OvershootPolicy::OvershootAlwaysOn))
        return;
    // Register converter for enum 'QScrollerProperties::OvershootPolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_OVERSHOOTPOLICY_IDX],
            QScrollerProperties_OvershootPolicy_CppToPython_QScrollerProperties_OvershootPolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScrollerProperties_OvershootPolicy_PythonToCpp_QScrollerProperties_OvershootPolicy,
            is_QScrollerProperties_OvershootPolicy_PythonToCpp_QScrollerProperties_OvershootPolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_OVERSHOOTPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScrollerProperties::OvershootPolicy");
        Shiboken::Conversions::registerConverterName(converter, "OvershootPolicy");
    }
    // End of 'OvershootPolicy' enum.

    // Initialization of enum 'FrameRates'.
    SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_FRAMERATES_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScrollerProperties_TypeF(),
        "FrameRates",
        "2:PySide2.QtWidgets.QScrollerProperties.FrameRates",
        "QScrollerProperties::FrameRates");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_FRAMERATES_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_FRAMERATES_IDX],
        Sbk_QScrollerProperties_TypeF(), "Standard", (long) QScrollerProperties::FrameRates::Standard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_FRAMERATES_IDX],
        Sbk_QScrollerProperties_TypeF(), "Fps60", (long) QScrollerProperties::FrameRates::Fps60))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_FRAMERATES_IDX],
        Sbk_QScrollerProperties_TypeF(), "Fps30", (long) QScrollerProperties::FrameRates::Fps30))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_FRAMERATES_IDX],
        Sbk_QScrollerProperties_TypeF(), "Fps20", (long) QScrollerProperties::FrameRates::Fps20))
        return;
    // Register converter for enum 'QScrollerProperties::FrameRates'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_FRAMERATES_IDX],
            QScrollerProperties_FrameRates_CppToPython_QScrollerProperties_FrameRates);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScrollerProperties_FrameRates_PythonToCpp_QScrollerProperties_FrameRates,
            is_QScrollerProperties_FrameRates_PythonToCpp_QScrollerProperties_FrameRates_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_FRAMERATES_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScrollerProperties::FrameRates");
        Shiboken::Conversions::registerConverterName(converter, "FrameRates");
    }
    // End of 'FrameRates' enum.

    // Initialization of enum 'ScrollMetric'.
    SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QScrollerProperties_TypeF(),
        "ScrollMetric",
        "2:PySide2.QtWidgets.QScrollerProperties.ScrollMetric",
        "QScrollerProperties::ScrollMetric");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "MousePressEventDelay", (long) QScrollerProperties::ScrollMetric::MousePressEventDelay))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "DragStartDistance", (long) QScrollerProperties::ScrollMetric::DragStartDistance))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "DragVelocitySmoothingFactor", (long) QScrollerProperties::ScrollMetric::DragVelocitySmoothingFactor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "AxisLockThreshold", (long) QScrollerProperties::ScrollMetric::AxisLockThreshold))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "ScrollingCurve", (long) QScrollerProperties::ScrollMetric::ScrollingCurve))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "DecelerationFactor", (long) QScrollerProperties::ScrollMetric::DecelerationFactor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "MinimumVelocity", (long) QScrollerProperties::ScrollMetric::MinimumVelocity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "MaximumVelocity", (long) QScrollerProperties::ScrollMetric::MaximumVelocity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "MaximumClickThroughVelocity", (long) QScrollerProperties::ScrollMetric::MaximumClickThroughVelocity))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "AcceleratingFlickMaximumTime", (long) QScrollerProperties::ScrollMetric::AcceleratingFlickMaximumTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "AcceleratingFlickSpeedupFactor", (long) QScrollerProperties::ScrollMetric::AcceleratingFlickSpeedupFactor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "SnapPositionRatio", (long) QScrollerProperties::ScrollMetric::SnapPositionRatio))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "SnapTime", (long) QScrollerProperties::ScrollMetric::SnapTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "OvershootDragResistanceFactor", (long) QScrollerProperties::ScrollMetric::OvershootDragResistanceFactor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "OvershootDragDistanceFactor", (long) QScrollerProperties::ScrollMetric::OvershootDragDistanceFactor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "OvershootScrollDistanceFactor", (long) QScrollerProperties::ScrollMetric::OvershootScrollDistanceFactor))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "OvershootScrollTime", (long) QScrollerProperties::ScrollMetric::OvershootScrollTime))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "HorizontalOvershootPolicy", (long) QScrollerProperties::ScrollMetric::HorizontalOvershootPolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "VerticalOvershootPolicy", (long) QScrollerProperties::ScrollMetric::VerticalOvershootPolicy))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "FrameRate", (long) QScrollerProperties::ScrollMetric::FrameRate))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
        Sbk_QScrollerProperties_TypeF(), "ScrollMetricCount", (long) QScrollerProperties::ScrollMetric::ScrollMetricCount))
        return;
    // Register converter for enum 'QScrollerProperties::ScrollMetric'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX],
            QScrollerProperties_ScrollMetric_CppToPython_QScrollerProperties_ScrollMetric);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QScrollerProperties_ScrollMetric_PythonToCpp_QScrollerProperties_ScrollMetric,
            is_QScrollerProperties_ScrollMetric_PythonToCpp_QScrollerProperties_ScrollMetric_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QSCROLLERPROPERTIES_SCROLLMETRIC_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QScrollerProperties::ScrollMetric");
        Shiboken::Conversions::registerConverterName(converter, "ScrollMetric");
    }
    // End of 'ScrollMetric' enum.

    qRegisterMetaType< ::QScrollerProperties >("QScrollerProperties");
    qRegisterMetaType< ::QScrollerProperties::OvershootPolicy >("QScrollerProperties::OvershootPolicy");
    qRegisterMetaType< ::QScrollerProperties::FrameRates >("QScrollerProperties::FrameRates");
    qRegisterMetaType< ::QScrollerProperties::ScrollMetric >("QScrollerProperties::ScrollMetric");
}
