/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QMDIAREAWRAPPER_H
#define SBK_QMDIAREAWRAPPER_H

#define protected public

#include <QtWidgets/qmdiarea.h>


// Extra includes
#include <qobject.h>
#include <QtWidgets/qwidget.h>
#include <qsize.h>
#include <QtWidgets/qmdisubwindow.h>
#include <QList>
#include <QtGui/qbrush.h>
#include <qcoreevent.h>
#include <QtGui/qevent.h>
#include <QtWidgets/qscrollbar.h>
#include <qobjectdefs.h>
#include <qbytearray.h>
#include <qmargins.h>
#include <qmetaobject.h>
#include <QtGui/qpaintdevice.h>
#include <qpoint.h>
#include <QtGui/qpaintengine.h>
#include <QtGui/qpainter.h>
namespace PySide { class DynamicQMetaObject; }

class QMdiAreaWrapper : public QMdiArea
{
public:
    QMdiAreaWrapper(::QWidget * parent = nullptr);
    void actionEvent(::QActionEvent * event) override;
    void changeEvent(::QEvent * arg__1) override;
    void childEvent(::QChildEvent * childEvent) override;
    void closeEvent(::QCloseEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    void contextMenuEvent(::QContextMenuEvent * arg__1) override;
    void customEvent(::QEvent * event) override;
    int devType() const override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    void dragEnterEvent(::QDragEnterEvent * arg__1) override;
    void dragLeaveEvent(::QDragLeaveEvent * arg__1) override;
    void dragMoveEvent(::QDragMoveEvent * arg__1) override;
    void dropEvent(::QDropEvent * arg__1) override;
    void enterEvent(::QEvent * event) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * object, ::QEvent * event) override;
    void focusInEvent(::QFocusEvent * event) override;
    bool focusNextPrevChild(bool next) override;
    void focusOutEvent(::QFocusEvent * event) override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int arg__1) const override;
    void hideEvent(::QHideEvent * event) override;
    void initPainter(::QPainter * painter) const override;
    void inputMethodEvent(::QInputMethodEvent * event) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery arg__1) const override;
    void keyPressEvent(::QKeyEvent * arg__1) override;
    void keyReleaseEvent(::QKeyEvent * event) override;
    void leaveEvent(::QEvent * event) override;
    const ::QMetaObject * metaObject() const override;
    int metric(::QPaintDevice::PaintDeviceMetric arg__1) const override;
    ::QSize minimumSizeHint() const override;
    void mouseDoubleClickEvent(::QMouseEvent * arg__1) override;
    void mouseMoveEvent(::QMouseEvent * arg__1) override;
    void mousePressEvent(::QMouseEvent * arg__1) override;
    void mouseReleaseEvent(::QMouseEvent * arg__1) override;
    void moveEvent(::QMoveEvent * event) override;
    bool nativeEvent(const ::QByteArray & eventType, void * message, long * result) override;
    ::QPaintEngine * paintEngine() const override;
    void paintEvent(::QPaintEvent * paintEvent) override;
    ::QPaintDevice * redirected(::QPoint * offset) const override;
    void resizeEvent(::QResizeEvent * resizeEvent) override;
    void scrollContentsBy(int dx, int dy) override;
    void setVisible(bool visible) override;
    void setupViewport(::QWidget * viewport) override;
    ::QPainter * sharedPainter() const override;
    void showEvent(::QShowEvent * showEvent) override;
    ::QSize sizeHint() const override;
    void tabletEvent(::QTabletEvent * event) override;
    void timerEvent(::QTimerEvent * timerEvent) override;
    bool viewportEvent(::QEvent * event) override;
    ::QSize viewportSizeHint() const override;
    void wheelEvent(::QWheelEvent * arg__1) override;
    ~QMdiAreaWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[52];
};

#endif // SBK_QMDIAREAWRAPPER_H

