/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qlayoutitem_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QLayoutItemWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QLayoutItemWrapper::QLayoutItemWrapper(::QFlags<Qt::AlignmentFlag> alignment) : QLayoutItem(alignment)
{
    resetPyMethodCache();
    // ... middle
}

::QFlags<QSizePolicy::ControlType> QLayoutItemWrapper::controlTypes() const
{
    if (m_PyMethodCache[0])
        return this->::QLayoutItem::controlTypes();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QSizePolicy::ControlType>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "controlTypes";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QLayoutItem::controlTypes();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QSizePolicy::ControlType>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayoutItem.controlTypes", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QSizePolicy::ControlType> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QSizePolicy::ControlType>(0);
    }
    ::QFlags<QSizePolicy::ControlType> cppResult = QFlags<QSizePolicy::ControlType>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QFlags<Qt::Orientation> QLayoutItemWrapper::expandingDirections() const
{
    if (m_PyMethodCache[1]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.expandingDirections()' not implemented.");
        return QFlags<Qt::Orientation>(0);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<Qt::Orientation>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "expandingDirections";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.expandingDirections()' not implemented.");
        return QFlags<Qt::Orientation>(0);
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<Qt::Orientation>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayoutItem.expandingDirections", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<Qt::Orientation> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<Qt::Orientation>(0);
    }
    ::QFlags<Qt::Orientation> cppResult = QFlags<Qt::Orientation>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QRect QLayoutItemWrapper::geometry() const
{
    if (m_PyMethodCache[2]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.geometry()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "geometry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.geometry()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayoutItem.geometry", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRect >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRect cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QLayoutItemWrapper::hasHeightForWidth() const
{
    if (m_PyMethodCache[3])
        return this->::QLayoutItem::hasHeightForWidth();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasHeightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QLayoutItem::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayoutItem.hasHeightForWidth", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QLayoutItemWrapper::heightForWidth(int arg__1) const
{
    if (m_PyMethodCache[4])
        return this->::QLayoutItem::heightForWidth(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "heightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QLayoutItem::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayoutItem.heightForWidth", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QLayoutItemWrapper::invalidate()
{
    if (m_PyMethodCache[5]) {
        return this->::QLayoutItem::invalidate();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "invalidate";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QLayoutItem::invalidate();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QLayoutItemWrapper::isEmpty() const
{
    if (m_PyMethodCache[6]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.isEmpty()' not implemented.");
        return false;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isEmpty";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.isEmpty()' not implemented.");
        return false;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayoutItem.isEmpty", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QLayout * QLayoutItemWrapper::layout()
{
    if (m_PyMethodCache[7])
        return this->::QLayoutItem::layout();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "layout";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QLayoutItem::layout();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayoutItem.layout", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QLayout >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QLayout *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSize QLayoutItemWrapper::maximumSize() const
{
    if (m_PyMethodCache[8]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.maximumSize()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "maximumSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.maximumSize()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayoutItem.maximumSize", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QLayoutItemWrapper::minimumHeightForWidth(int arg__1) const
{
    if (m_PyMethodCache[9])
        return this->::QLayoutItem::minimumHeightForWidth(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "minimumHeightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QLayoutItem::minimumHeightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayoutItem.minimumHeightForWidth", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSize QLayoutItemWrapper::minimumSize() const
{
    if (m_PyMethodCache[10]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.minimumSize()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "minimumSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.minimumSize()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayoutItem.minimumSize", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QLayoutItemWrapper::setGeometry(const ::QRect & arg__1)
{
    if (m_PyMethodCache[11]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.setGeometry()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setGeometry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.setGeometry()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSize QLayoutItemWrapper::sizeHint() const
{
    if (m_PyMethodCache[12]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.sizeHint()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.sizeHint()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayoutItem.sizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSpacerItem * QLayoutItemWrapper::spacerItem()
{
    if (m_PyMethodCache[13])
        return this->::QLayoutItem::spacerItem();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "spacerItem";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QLayoutItem::spacerItem();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSPACERITEM_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayoutItem.spacerItem", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSpacerItem >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QSpacerItem *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QWidget * QLayoutItemWrapper::widget()
{
    if (m_PyMethodCache[14])
        return this->::QLayoutItem::widget();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "widget";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QLayoutItem::widget();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayoutItem.widget", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QWidget >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QWidget *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QLayoutItemWrapper::~QLayoutItemWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QLayoutItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QLayoutItem' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QLayoutItem >()))
        return -1;

    ::QLayoutItemWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths
    if (numArgs > 1) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLayoutItem_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|O:QLayoutItem", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QLayoutItem::QLayoutItem(QFlags<Qt::AlignmentFlag>)
    if (numArgs == 0) {
        overloadId = 0; // QLayoutItem(QFlags<Qt::AlignmentFlag>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // QLayoutItem(QFlags<Qt::AlignmentFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutItem_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_alignment = Shiboken::String::createStaticString("alignment");
            if (PyDict_Contains(kwds, key_alignment)) {
                value = PyDict_GetItem(kwds, key_alignment);
                if (value && pyArgs[0]) {
                    errInfo = key_alignment;
                    Py_INCREF(errInfo);
                    goto Sbk_QLayoutItem_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[0]))))
                        goto Sbk_QLayoutItem_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_alignment);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QLayoutItem_Init_TypeError;
            }
        }
        ::QFlags<Qt::AlignmentFlag> cppArg0 = Qt::Alignment();
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QLayoutItem(QFlags<Qt::AlignmentFlag>)
            cptr = new ::QLayoutItemWrapper(cppArg0);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QLayoutItem >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QLayoutItem_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QLayoutItem_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QLayoutItemFunc_alignment(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.alignment";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // alignment()const
            QFlags<Qt::AlignmentFlag> cppResult = const_cast<const ::QLayoutItem *>(cppSelf)->alignment();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutItemFunc_controlTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.controlTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // controlTypes()const
            QFlags<QSizePolicy::ControlType> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QLayoutItem *>(cppSelf)->::QLayoutItem::controlTypes()
                : const_cast<const ::QLayoutItem *>(cppSelf)->controlTypes();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutItemFunc_expandingDirections(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.expandingDirections";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // expandingDirections()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.expandingDirections()' not implemented.");
                return {};
            }
            QFlags<Qt::Orientation> cppResult = const_cast<const ::QLayoutItem *>(cppSelf)->expandingDirections();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutItemFunc_geometry(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.geometry";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // geometry()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.geometry()' not implemented.");
                return {};
            }
            QRect cppResult = const_cast<const ::QLayoutItem *>(cppSelf)->geometry();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutItemFunc_hasHeightForWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.hasHeightForWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasHeightForWidth()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QLayoutItem *>(cppSelf)->::QLayoutItem::hasHeightForWidth()
                : const_cast<const ::QLayoutItem *>(cppSelf)->hasHeightForWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutItemFunc_heightForWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.heightForWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayoutItem::heightForWidth(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // heightForWidth(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutItemFunc_heightForWidth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // heightForWidth(int)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QLayoutItem *>(cppSelf)->::QLayoutItem::heightForWidth(cppArg0)
                : const_cast<const ::QLayoutItem *>(cppSelf)->heightForWidth(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLayoutItemFunc_heightForWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutItemFunc_invalidate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.invalidate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // invalidate()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QLayoutItem::invalidate()
                : cppSelf->invalidate();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QLayoutItemFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.isEmpty()' not implemented.");
                return {};
            }
            bool cppResult = const_cast<const ::QLayoutItem *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutItemFunc_layout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.layout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // layout()
            QLayout * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QLayoutItem::layout()
                : cppSelf->layout();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutItemFunc_maximumSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.maximumSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumSize()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.maximumSize()' not implemented.");
                return {};
            }
            QSize cppResult = const_cast<const ::QLayoutItem *>(cppSelf)->maximumSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutItemFunc_minimumHeightForWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.minimumHeightForWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayoutItem::minimumHeightForWidth(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // minimumHeightForWidth(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutItemFunc_minimumHeightForWidth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // minimumHeightForWidth(int)const
            int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QLayoutItem *>(cppSelf)->::QLayoutItem::minimumHeightForWidth(cppArg0)
                : const_cast<const ::QLayoutItem *>(cppSelf)->minimumHeightForWidth(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLayoutItemFunc_minimumHeightForWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutItemFunc_minimumSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.minimumSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumSize()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.minimumSize()' not implemented.");
                return {};
            }
            QSize cppResult = const_cast<const ::QLayoutItem *>(cppSelf)->minimumSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutItemFunc_setAlignment(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.setAlignment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayoutItem::setAlignment(QFlags<Qt::AlignmentFlag>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAlignment(QFlags<Qt::AlignmentFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutItemFunc_setAlignment_TypeError;

    // Call function/method
    {
        ::QFlags<Qt::AlignmentFlag> cppArg0 = QFlags<Qt::AlignmentFlag>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAlignment(QFlags<Qt::AlignmentFlag>)
            cppSelf->setAlignment(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutItemFunc_setAlignment_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutItemFunc_setGeometry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.setGeometry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayoutItem::setGeometry(QRect)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
        overloadId = 0; // setGeometry(QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutItemFunc_setGeometry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setGeometry(QRect)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.setGeometry()' not implemented.");
                return {};
            }
            cppSelf->setGeometry(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutItemFunc_setGeometry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutItemFunc_sizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.sizeHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sizeHint()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayoutItem.sizeHint()' not implemented.");
                return {};
            }
            QSize cppResult = const_cast<const ::QLayoutItem *>(cppSelf)->sizeHint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutItemFunc_spacerItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.spacerItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // spacerItem()
            QSpacerItem * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QLayoutItem::spacerItem()
                : cppSelf->spacerItem();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSPACERITEM_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutItemFunc_widget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayoutItem.widget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // widget()
            QWidget * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QLayoutItem::widget()
                : cppSelf->widget();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);

            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QLayoutItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QLayoutItem_methods[] = {
    {"alignment", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_alignment), METH_NOARGS},
    {"controlTypes", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_controlTypes), METH_NOARGS},
    {"expandingDirections", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_expandingDirections), METH_NOARGS},
    {"geometry", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_geometry), METH_NOARGS},
    {"hasHeightForWidth", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_hasHeightForWidth), METH_NOARGS},
    {"heightForWidth", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_heightForWidth), METH_O},
    {"invalidate", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_invalidate), METH_NOARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_isEmpty), METH_NOARGS},
    {"layout", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_layout), METH_NOARGS},
    {"maximumSize", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_maximumSize), METH_NOARGS},
    {"minimumHeightForWidth", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_minimumHeightForWidth), METH_O},
    {"minimumSize", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_minimumSize), METH_NOARGS},
    {"setAlignment", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_setAlignment), METH_O},
    {"setGeometry", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_setGeometry), METH_O},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_sizeHint), METH_NOARGS},
    {"spacerItem", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_spacerItem), METH_NOARGS},
    {"widget", reinterpret_cast<PyCFunction>(Sbk_QLayoutItemFunc_widget), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QLayoutItem_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QLayoutItemWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

static PyObject *Sbk_QLayoutItem_get_align(PyObject *self, void *)
{
    if (!Shiboken::Object::isValid(self))
        return nullptr;
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyOut = {};
    pyOut = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, &cppSelf->align);
    return pyOut;
}
static int Sbk_QLayoutItem_set_align(PyObject *self, PyObject *pyIn, void *)
{
    if (!Shiboken::Object::isValid(self))
        return 0;
    auto cppSelf = reinterpret_cast< ::QLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    if (pyIn == nullptr) {
        PyErr_SetString(PyExc_TypeError, "'align' may not be deleted");
        return -1;
    }
    PythonToCppFunc pythonToCpp{nullptr};
    if (!(pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyIn)))) {
        PyErr_SetString(PyExc_TypeError, "wrong type attributed to 'align', 'Alignment' or convertible type expected");
        return -1;
    }

    ::QFlags<Qt::AlignmentFlag> cppOut_local = cppSelf->align;
    pythonToCpp(pyIn, &cppOut_local);
    cppSelf->align = cppOut_local;

    return 0;
}

// Getters and Setters for QLayoutItem
static PyGetSetDef Sbk_QLayoutItem_getsetlist[] = {
    {const_cast<char *>("align"), Sbk_QLayoutItem_get_align, Sbk_QLayoutItem_set_align},
    {nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QLayoutItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QLayoutItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QLayoutItem_Type = nullptr;
static SbkObjectType *Sbk_QLayoutItem_TypeF(void)
{
    return _Sbk_QLayoutItem_Type;
}

static PyType_Slot Sbk_QLayoutItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QLayoutItem_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QLayoutItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QLayoutItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QLayoutItem_methods)},
    {Py_tp_getset,      reinterpret_cast<void *>(Sbk_QLayoutItem_getsetlist)},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QLayoutItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QLayoutItem_spec = {
    "2:PySide2.QtWidgets.QLayoutItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QLayoutItem_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QLayoutItem_PythonToCpp_QLayoutItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QLayoutItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QLayoutItem_PythonToCpp_QLayoutItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QLayoutItem_TypeF())))
        return QLayoutItem_PythonToCpp_QLayoutItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QLayoutItem_PTR_CppToPython_QLayoutItem(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QLayoutItem *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QLayoutItem_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QLayoutItem_SignatureStrings[] = {
    "PySide2.QtWidgets.QLayoutItem(self,alignment:PySide2.QtCore.Qt.Alignment=Qt.Alignment())",
    "PySide2.QtWidgets.QLayoutItem.alignment(self)->PySide2.QtCore.Qt.Alignment",
    "PySide2.QtWidgets.QLayoutItem.controlTypes(self)->PySide2.QtWidgets.QSizePolicy.ControlTypes",
    "PySide2.QtWidgets.QLayoutItem.expandingDirections(self)->PySide2.QtCore.Qt.Orientations",
    "PySide2.QtWidgets.QLayoutItem.geometry(self)->PySide2.QtCore.QRect",
    "PySide2.QtWidgets.QLayoutItem.hasHeightForWidth(self)->bool",
    "PySide2.QtWidgets.QLayoutItem.heightForWidth(self,arg__1:int)->int",
    "PySide2.QtWidgets.QLayoutItem.invalidate(self)",
    "PySide2.QtWidgets.QLayoutItem.isEmpty(self)->bool",
    "PySide2.QtWidgets.QLayoutItem.layout(self)->PySide2.QtWidgets.QLayout",
    "PySide2.QtWidgets.QLayoutItem.maximumSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QLayoutItem.minimumHeightForWidth(self,arg__1:int)->int",
    "PySide2.QtWidgets.QLayoutItem.minimumSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QLayoutItem.setAlignment(self,a:PySide2.QtCore.Qt.Alignment)",
    "PySide2.QtWidgets.QLayoutItem.setGeometry(self,arg__1:PySide2.QtCore.QRect)",
    "PySide2.QtWidgets.QLayoutItem.sizeHint(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QLayoutItem.spacerItem(self)->PySide2.QtWidgets.QSpacerItem",
    "PySide2.QtWidgets.QLayoutItem.widget(self)->PySide2.QtWidgets.QWidget",
    nullptr}; // Sentinel

void init_QLayoutItem(PyObject *module)
{
    _Sbk_QLayoutItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QLayoutItem",
        "QLayoutItem*",
        &Sbk_QLayoutItem_spec,
        &Shiboken::callCppDestructor< ::QLayoutItem >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QLayoutItem_Type);
    InitSignatureStrings(pyType, QLayoutItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QLayoutItem_Type), Sbk_QLayoutItem_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QLayoutItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QLayoutItem_TypeF(),
        QLayoutItem_PythonToCpp_QLayoutItem_PTR,
        is_QLayoutItem_PythonToCpp_QLayoutItem_PTR_Convertible,
        QLayoutItem_PTR_CppToPython_QLayoutItem);

    Shiboken::Conversions::registerConverterName(converter, "QLayoutItem");
    Shiboken::Conversions::registerConverterName(converter, "QLayoutItem*");
    Shiboken::Conversions::registerConverterName(converter, "QLayoutItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QLayoutItem).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QLayoutItemWrapper).name());


}
