/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qlayout_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Begin code injection
// ========================================================================
// START of custom code block [file: ../glue/qtwidgets.cpp (qlayout-help-functions)]
void addLayoutOwnership(QLayout *layout, QLayoutItem *item);
void removeLayoutOwnership(QLayout *layout, QWidget *widget);

inline QByteArray retrieveObjectName(PyObject *obj)
{
    Shiboken::AutoDecRef objName(PyObject_Str(obj));
    return Shiboken::String::toCString(objName);
}

inline void addLayoutOwnership(QLayout *layout, QWidget *widget)
{
    //transfer ownership to parent widget
    QWidget *lw = layout->parentWidget();
    QWidget *pw = widget->parentWidget();

   Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget));

    //Transfer parent to layout widget
    if (pw && lw && pw != lw)
        Shiboken::Object::setParent(0, pyChild);

    if (!lw && !pw) {
        //keep the reference while the layout is orphan
        Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), layout));
        Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(pyParent.object()), retrieveObjectName(pyParent).data(), pyChild, true);
    } else {
        if (!lw)
            lw = pw;
        Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), lw));
        Shiboken::Object::setParent(pyParent, pyChild);
    }
}

inline void addLayoutOwnership(QLayout *layout, QLayout *other)
{
    //transfer all children widgets from other to layout parent widget
    QWidget *parent = layout->parentWidget();
    if (!parent) {
        //keep the reference while the layout is orphan
        Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), layout));
        Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), other));
        Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(pyParent.object()),
                                        retrieveObjectName(pyParent).data(), pyChild, true);
        return;
    }

    for (int i=0, i_max=other->count(); i < i_max; i++) {
        QLayoutItem *item = other->itemAt(i);
        if (PyErr_Occurred() || !item)
            return;
        addLayoutOwnership(layout, item);
    }

    Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), layout));
    Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), other));
    Shiboken::Object::setParent(pyParent, pyChild);
}

inline void addLayoutOwnership(QLayout *layout, QLayoutItem *item)
{
    if (!item)
        return;

    if (QWidget *w = item->widget()) {
        addLayoutOwnership(layout, w);
    } else {
        if (QLayout *l = item->layout())
            addLayoutOwnership(layout, l);
    }

    Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), layout));
    Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), item));
    Shiboken::Object::setParent(pyParent, pyChild);
}

static void removeWidgetFromLayout(QLayout *layout, QWidget *widget)
{
    QWidget *parent = widget->parentWidget();

    if (!parent) {
        //remove reference on layout
        Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), layout));
        Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget));
        Shiboken::Object::removeReference(reinterpret_cast<SbkObject *>(pyParent.object()),
                                          retrieveObjectName(pyParent).data(), pyChild);
    } else {
        //give the ownership to parent
        Shiboken::AutoDecRef pyParent(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), parent));
        Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), widget));
        Shiboken::Object::setParent(pyParent, pyChild);
    }
}

inline void removeLayoutOwnership(QLayout *layout, QLayoutItem *item)
{
    if (QWidget *w = item->widget()) {
        removeWidgetFromLayout(layout, w);
    } else {
        QLayout *l = item->layout();
        if (l && item != l)
            removeLayoutOwnership(layout, l);
    }

    Shiboken::AutoDecRef pyChild(Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), item));
    Shiboken::Object::invalidate(pyChild);
    Shiboken::Object::setParent(0, pyChild);
}

inline void removeLayoutOwnership(QLayout *layout, QWidget *widget)
{
    if (!widget)
        return;

    for (int i=0, i_max=layout->count(); i < i_max; i++) {
        QLayoutItem *item = layout->itemAt(i);
        if (PyErr_Occurred() || !item)
            return;
        if (item->widget() == widget)
            removeLayoutOwnership(layout, item);
    }
}
// END of custom code block [file: ../glue/qtwidgets.cpp (qlayout-help-functions)]
// ========================================================================

// End of code injection


// Native ---------------------------------------------------------

void QLayoutWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QLayoutWrapper::QLayoutWrapper() : QLayout()
{
    resetPyMethodCache();
    // ... middle
}

QLayoutWrapper::QLayoutWrapper(::QWidget * parent) : QLayout(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QLayoutWrapper::addItem(::QLayoutItem * arg__1)
{
    if (m_PyMethodCache[0]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.addItem()' not implemented.");
        return;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "addItem";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.addItem()' not implemented.");
        return;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }

}

void QLayoutWrapper::childEvent(::QChildEvent * e)
{
    if (m_PyMethodCache[1]) {
        return this->::QLayout::childEvent(e);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QLayout::childEvent(e);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), e)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QLayoutWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QFlags<QSizePolicy::ControlType> QLayoutWrapper::controlTypes() const
{
    if (m_PyMethodCache[3])
        return this->::QLayout::controlTypes();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<QSizePolicy::ControlType>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "controlTypes";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QLayout::controlTypes();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<QSizePolicy::ControlType>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.controlTypes", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<QSizePolicy::ControlType> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<QSizePolicy::ControlType>(0);
    }
    ::QFlags<QSizePolicy::ControlType> cppResult = QFlags<QSizePolicy::ControlType>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QLayoutWrapper::count() const
{
    if (m_PyMethodCache[4]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.count()' not implemented.");
        return 0;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "count";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.count()' not implemented.");
        return 0;
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.count", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QLayoutWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QLayoutWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[6]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QLayoutWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[7])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QLayoutWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[8])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QFlags<Qt::Orientation> QLayoutWrapper::expandingDirections() const
{
    if (m_PyMethodCache[9])
        return this->::QLayout::expandingDirections();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return QFlags<Qt::Orientation>(0);
    static PyObject *nameCache[2] = {};
    static const char *funcName = "expandingDirections";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QLayout::expandingDirections();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return QFlags<Qt::Orientation>(0);
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.expandingDirections", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QFlags<Qt::Orientation> >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return QFlags<Qt::Orientation>(0);
    }
    ::QFlags<Qt::Orientation> cppResult = QFlags<Qt::Orientation>(0);
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QRect QLayoutWrapper::geometry() const
{
    if (m_PyMethodCache[10])
        return this->::QLayout::geometry();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "geometry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QLayout::geometry();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.geometry", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QRect >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QRect cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

bool QLayoutWrapper::hasHeightForWidth() const
{
    if (m_PyMethodCache[11])
        return this->::QLayoutItem::hasHeightForWidth();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasHeightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QLayoutItem::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.hasHeightForWidth", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QLayoutWrapper::heightForWidth(int arg__1) const
{
    if (m_PyMethodCache[12])
        return this->::QLayoutItem::heightForWidth(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "heightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QLayoutItem::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.heightForWidth", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QLayoutWrapper::indexOf(::QWidget * arg__1) const
{
    if (m_PyMethodCache[13])
        return this->::QLayout::indexOf(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "indexOf";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QLayout::indexOf(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.indexOf", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QLayoutWrapper::invalidate()
{
    if (m_PyMethodCache[14]) {
        return this->::QLayout::invalidate();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "invalidate";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QLayout::invalidate();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QLayoutWrapper::isEmpty() const
{
    if (m_PyMethodCache[15])
        return this->::QLayout::isEmpty();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "isEmpty";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QLayout::isEmpty();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.isEmpty", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QLayoutItem * QLayoutWrapper::itemAt(int index) const
{
    if (m_PyMethodCache[16]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.itemAt()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "itemAt";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.itemAt()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    index
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.itemAt", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QLayoutItem >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QLayoutItem *cppResult;
    pythonToCpp(pyResult, &cppResult);

    return cppResult;
}

::QLayout * QLayoutWrapper::layout()
{
    if (m_PyMethodCache[17])
        return this->::QLayout::layout();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "layout";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QLayout::layout();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.layout", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QLayout >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QLayout *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSize QLayoutWrapper::maximumSize() const
{
    if (m_PyMethodCache[18])
        return this->::QLayout::maximumSize();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "maximumSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QLayout::maximumSize();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.maximumSize", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QLayoutWrapper::minimumHeightForWidth(int arg__1) const
{
    if (m_PyMethodCache[20])
        return this->::QLayoutItem::minimumHeightForWidth(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "minimumHeightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QLayoutItem::minimumHeightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.minimumHeightForWidth", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSize QLayoutWrapper::minimumSize() const
{
    if (m_PyMethodCache[21])
        return this->::QLayout::minimumSize();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "minimumSize";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QLayout::minimumSize();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.minimumSize", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QLayoutWrapper::setGeometry(const ::QRect & arg__1)
{
    if (m_PyMethodCache[22]) {
        return this->::QLayout::setGeometry(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setGeometry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QLayout::setGeometry(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSize QLayoutWrapper::sizeHint() const
{
    if (m_PyMethodCache[23]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.sizeHint()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.sizeHint()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.sizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSpacerItem * QLayoutWrapper::spacerItem()
{
    if (m_PyMethodCache[24])
        return this->::QLayoutItem::spacerItem();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "spacerItem";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QLayoutItem::spacerItem();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSPACERITEM_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.spacerItem", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSpacerItem >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QSpacerItem *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QLayoutItem * QLayoutWrapper::takeAt(int index)
{
    if (m_PyMethodCache[25]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.takeAt()' not implemented.");
        return nullptr;
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "takeAt";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.takeAt()' not implemented.");
        return nullptr;
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    index
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.takeAt", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QLayoutItem >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QLayoutItem *cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (Shiboken::Object::checkType(pyResult))
        Shiboken::Object::releaseOwnership(pyResult);
    return cppResult;
}

void QLayoutWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[26]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QWidget * QLayoutWrapper::widget()
{
    if (m_PyMethodCache[27])
        return this->::QLayoutItem::widget();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "widget";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QLayoutItem::widget();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QLayout.widget", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QWidget >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QWidget *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

const QMetaObject *QLayoutWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QLayout::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QLayoutWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QLayout::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QLayoutWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QLayoutWrapper *>(this));
        return QLayout::qt_metacast(_clname);
}

QLayoutWrapper::~QLayoutWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QLayout_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QLayout' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

    Shiboken::ObjectType::copyMultipleInheritance(type, myType);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QLayout >()))
        return -1;

    ::QLayoutWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QLayout", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QLayout::QLayout()
    // 1: QLayout::QLayout(QWidget*)
    if (numArgs == 0) {
        overloadId = 0; // QLayout()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QLayout(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayout_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QLayout()
        {

            if (!PyErr_Occurred()) {
                // QLayout()
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QLayoutWrapper();
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QLayoutWrapper();
                }

            }
            break;
        }
        case 1: // QLayout(QWidget * parent)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);

            if (!PyErr_Occurred()) {
                // QLayout(QWidget*)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QLayoutWrapper(cppArg0);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QLayoutWrapper(cppArg0);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QLayout >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QLayout_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QLayout_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QLayout_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QLayoutFunc_activate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.activate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // activate()
            bool cppResult = cppSelf->activate();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_addChildLayout(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.addChildLayout";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::addChildLayout(QLayout*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), (pyArg)))) {
        overloadId = 0; // addChildLayout(QLayout*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_addChildLayout_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLayout *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addChildLayout(QLayout*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            addLayoutOwnership(cppSelf, cppArg0);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            // ========================================================================

            // End of code injection

            cppSelf->addChildLayout(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_addChildLayout_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_addChildWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.addChildWidget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::addChildWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // addChildWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_addChildWidget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addChildWidget(QWidget*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            addLayoutOwnership(cppSelf, cppArg0);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            // ========================================================================

            // End of code injection

            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->addChildWidget(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_addChildWidget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_addItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.addItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::addItem(QLayoutItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), (pyArg)))) {
        overloadId = 0; // addItem(QLayoutItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_addItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLayoutItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addItem(QLayoutItem*)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.addItem()' not implemented.");
                return {};
            }
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            addLayoutOwnership(cppSelf, cppArg0);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            // ========================================================================

            // End of code injection

            cppSelf->addItem(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_addItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_addWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.addWidget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::addWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // addWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_addWidget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // addWidget(QWidget*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            addLayoutOwnership(cppSelf, cppArg0);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            // ========================================================================

            // End of code injection

            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->addWidget(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_addWidget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_adoptLayout(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.adoptLayout";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::adoptLayout(QLayout*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), (pyArg)))) {
        overloadId = 0; // adoptLayout(QLayout*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_adoptLayout_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLayout *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // adoptLayout(QLayout*)
            bool cppResult = cppSelf->adoptLayout(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLayoutFunc_adoptLayout_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_alignmentRect(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.alignmentRect";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::alignmentRect(QRect)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
        overloadId = 0; // alignmentRect(QRect)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_alignmentRect_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // alignmentRect(QRect)const
            QRect cppResult = const_cast<const ::QLayout *>(cppSelf)->alignmentRect(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLayoutFunc_alignmentRect_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_childEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.childEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QObject::childEvent(QChildEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // childEvent(QChildEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_childEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QChildEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // childEvent(QChildEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QLayout::childEvent(cppArg0)
                : cppSelf->childEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_childEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_closestAcceptableSize(PyObject *self, PyObject *args)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.closestAcceptableSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "closestAcceptableSize", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QLayout::closestAcceptableSize(const QWidget*,QSize)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // closestAcceptableSize(const QWidget*,QSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_closestAcceptableSize_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSize cppArg1_local;
        ::QSize *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // closestAcceptableSize(const QWidget*,QSize)
            QSize cppResult = ::QLayout::closestAcceptableSize(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLayoutFunc_closestAcceptableSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_contentsMargins(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.contentsMargins";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contentsMargins()const
            QMargins cppResult = const_cast<const ::QLayout *>(cppSelf)->contentsMargins();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_contentsRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.contentsRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contentsRect()const
            QRect cppResult = const_cast<const ::QLayout *>(cppSelf)->contentsRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_controlTypes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.controlTypes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // controlTypes()const
            QFlags<QSizePolicy::ControlType> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QLayout *>(cppSelf)->::QLayout::controlTypes()
                : const_cast<const ::QLayout *>(cppSelf)->controlTypes();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_count(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.count";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // count()const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.count()' not implemented.");
                return {};
            }
            int cppResult = const_cast<const ::QLayout *>(cppSelf)->count();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_expandingDirections(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.expandingDirections";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // expandingDirections()const
            QFlags<Qt::Orientation> cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QLayout *>(cppSelf)->::QLayout::expandingDirections()
                : const_cast<const ::QLayout *>(cppSelf)->expandingDirections();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ORIENTATION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_geometry(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.geometry";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // geometry()const
            QRect cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QLayout *>(cppSelf)->::QLayout::geometry()
                : const_cast<const ::QLayout *>(cppSelf)->geometry();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_getContentsMargins(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.getContentsMargins";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getContentsMargins(int*,int*,int*,int*)const
            // Begin code injection
            // TEMPLATE - fix_number*,number*,number*,number* - START
            int a, b, c, d;
            cppSelf->::QLayout::getContentsMargins(&a, &b, &c, &d);
            // TEMPLATE - tuple_abcd_same_type - START
            pyResult = PyTuple_New(4);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &a));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &b));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &c));
            PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &d));
            // TEMPLATE - tuple_abcd_same_type - END
            // TEMPLATE - fix_number*,number*,number*,number* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_indexOf(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.indexOf";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::indexOf(QWidget*)const
    // 1: QLayout::indexOf(QLayoutItem*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), (pyArg)))) {
        overloadId = 1; // indexOf(QLayoutItem*)const
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // indexOf(QWidget*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_indexOf_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // indexOf(QWidget * arg__1) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // indexOf(QWidget*)const
                int cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? const_cast<const ::QLayout *>(cppSelf)->::QLayout::indexOf(cppArg0)
                    : const_cast<const ::QLayout *>(cppSelf)->indexOf(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
        case 1: // indexOf(QLayoutItem * arg__1) const
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QLayoutItem *cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // indexOf(QLayoutItem*)const
                int cppResult = const_cast<const ::QLayout *>(cppSelf)->indexOf(cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLayoutFunc_indexOf_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_invalidate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.invalidate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // invalidate()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QLayout::invalidate()
                : cppSelf->invalidate();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QLayoutFunc_isEmpty(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.isEmpty";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEmpty()const
            bool cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QLayout *>(cppSelf)->::QLayout::isEmpty()
                : const_cast<const ::QLayout *>(cppSelf)->isEmpty();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_isEnabled(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.isEnabled";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isEnabled()const
            bool cppResult = const_cast<const ::QLayout *>(cppSelf)->isEnabled();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_itemAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.itemAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::itemAt(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // itemAt(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_itemAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // itemAt(int)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.itemAt()' not implemented.");
                return {};
            }
            QLayoutItem * cppResult = const_cast<const ::QLayout *>(cppSelf)->itemAt(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), cppResult);
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-0)]
            addLayoutOwnership(cppSelf, cppResult);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-0)]
            // ========================================================================

            // End of code injection


            // Ownership transferences.
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLayoutFunc_itemAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_layout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.layout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // layout()
            QLayout * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QLayout::layout()
                : cppSelf->layout();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_margin(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.margin";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // margin()const
            int cppResult = const_cast<const ::QLayout *>(cppSelf)->margin();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_maximumSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.maximumSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumSize()const
            QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QLayout *>(cppSelf)->::QLayout::maximumSize()
                : const_cast<const ::QLayout *>(cppSelf)->maximumSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_menuBar(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.menuBar";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // menuBar()const
            QWidget * cppResult = const_cast<const ::QLayout *>(cppSelf)->menuBar();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_minimumSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.minimumSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumSize()const
            QSize cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QLayout *>(cppSelf)->::QLayout::minimumSize()
                : const_cast<const ::QLayout *>(cppSelf)->minimumSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_parentWidget(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.parentWidget";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parentWidget()const
            QWidget * cppResult = const_cast<const ::QLayout *>(cppSelf)->parentWidget();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);

            // Ownership transferences.
            Shiboken::Object::setParent(pyResult, self);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_removeItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.removeItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::removeItem(QLayoutItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), (pyArg)))) {
        overloadId = 0; // removeItem(QLayoutItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_removeItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QLayoutItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeItem(QLayoutItem*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (removeownership-1)]
            removeLayoutOwnership(cppSelf, cppArg0);
            // END of custom code block [file: ../glue/qtwidgets.cpp (removeownership-1)]
            // ========================================================================

            // End of code injection

            cppSelf->removeItem(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_removeItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_removeWidget(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.removeWidget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::removeWidget(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // removeWidget(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_removeWidget_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // removeWidget(QWidget*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (removeownership-1)]
            removeLayoutOwnership(cppSelf, cppArg0);
            // END of custom code block [file: ../glue/qtwidgets.cpp (removeownership-1)]
            // ========================================================================

            // End of code injection

            cppSelf->removeWidget(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_removeWidget_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_replaceWidget(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.replaceWidget";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QLayoutFunc_replaceWidget_TypeError;
    } else if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QLayoutFunc_replaceWidget_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:replaceWidget", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QLayout::replaceWidget(QWidget*,QWidget*,QFlags<Qt::FindChildOption>)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // replaceWidget(QWidget*,QWidget*,QFlags<Qt::FindChildOption>)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX])->converter, (pyArgs[2])))) {
            overloadId = 0; // replaceWidget(QWidget*,QWidget*,QFlags<Qt::FindChildOption>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_replaceWidget_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[2]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QLayoutFunc_replaceWidget_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_FINDCHILDOPTION_IDX])->converter, (pyArgs[2]))))
                        goto Sbk_QLayoutFunc_replaceWidget_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QLayoutFunc_replaceWidget_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QFlags<Qt::FindChildOption> cppArg2 = Qt::FindChildrenRecursively;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // replaceWidget(QWidget*,QWidget*,QFlags<Qt::FindChildOption>)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-2)]
            addLayoutOwnership(cppSelf, cppArg1);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-2)]
            // ========================================================================

            // End of code injection

            QLayoutItem * cppResult = cppSelf->replaceWidget(cppArg0, cppArg1, cppArg2);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLayoutFunc_replaceWidget_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_setAlignment(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.setAlignment";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setAlignment", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QLayoutItem::setAlignment(QFlags<Qt::AlignmentFlag>)
    // 1: QLayout::setAlignment(QLayout*,QFlags<Qt::AlignmentFlag>)
    // 2: QLayout::setAlignment(QWidget*,QFlags<Qt::AlignmentFlag>)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[1])))) {
        overloadId = 2; // setAlignment(QWidget*,QFlags<Qt::AlignmentFlag>)
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[1])))) {
        overloadId = 1; // setAlignment(QLayout*,QFlags<Qt::AlignmentFlag>)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_ALIGNMENTFLAG_IDX])->converter, (pyArgs[0])))) {
        overloadId = 0; // setAlignment(QFlags<Qt::AlignmentFlag>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_setAlignment_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setAlignment(QFlags<Qt::AlignmentFlag> arg__1)
        {
            ::QFlags<Qt::AlignmentFlag> cppArg0 = QFlags<Qt::AlignmentFlag>(0);
            pythonToCpp[0](pyArgs[0], &cppArg0);
            SBK_UNUSED(cppArg0)

            if (!PyErr_Occurred()) {
                // setAlignment(QFlags<Qt::AlignmentFlag>)
                // Begin code injection
                // ========================================================================
                // START of custom code block [file: ../glue/qtwidgets.cpp (qlayout-setalignment)]
                cppSelf->setAlignment(cppArg0);
                // END of custom code block [file: ../glue/qtwidgets.cpp (qlayout-setalignment)]
                // ========================================================================

                // End of code injection

                pyResult = Py_None;
                Py_INCREF(Py_None);
            }
            break;
        }
        case 1: // setAlignment(QLayout * l, QFlags<Qt::AlignmentFlag> alignment)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QLayout *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<Qt::AlignmentFlag> cppArg1 = QFlags<Qt::AlignmentFlag>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setAlignment(QLayout*,QFlags<Qt::AlignmentFlag>)
                bool cppResult = cppSelf->setAlignment(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
        case 2: // setAlignment(QWidget * w, QFlags<Qt::AlignmentFlag> alignment)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<Qt::AlignmentFlag> cppArg1 = QFlags<Qt::AlignmentFlag>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setAlignment(QWidget*,QFlags<Qt::AlignmentFlag>)
                bool cppResult = cppSelf->setAlignment(cppArg0, cppArg1);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLayoutFunc_setAlignment_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_setContentsMargins(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.setContentsMargins";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs == 2 || numArgs == 3)
        goto Sbk_QLayoutFunc_setContentsMargins_TypeError;

    if (!PyArg_UnpackTuple(args, "setContentsMargins", 1, 4, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: QLayout::setContentsMargins(QMargins)
    // 1: QLayout::setContentsMargins(int,int,int,int)
    if (numArgs == 4
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[2])))
        && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[3])))) {
        overloadId = 1; // setContentsMargins(int,int,int,int)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setContentsMargins(QMargins)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_setContentsMargins_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setContentsMargins(const QMargins & margins)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QMargins cppArg0_local;
            ::QMargins *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMARGINS_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setContentsMargins(QMargins)
                cppSelf->setContentsMargins(*cppArg0);
            }
            break;
        }
        case 1: // setContentsMargins(int left, int top, int right, int bottom)
        {
            int cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            int cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);
            int cppArg2;
            pythonToCpp[2](pyArgs[2], &cppArg2);
            int cppArg3;
            pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // setContentsMargins(int,int,int,int)
                cppSelf->setContentsMargins(cppArg0, cppArg1, cppArg2, cppArg3);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_setContentsMargins_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_setEnabled(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.setEnabled";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::setEnabled(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setEnabled(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_setEnabled_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setEnabled(bool)
            cppSelf->setEnabled(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_setEnabled_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_setGeometry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.setGeometry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayoutItem::setGeometry(QRect)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), (pyArg)))) {
        overloadId = 0; // setGeometry(QRect)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_setGeometry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRect cppArg0_local;
        ::QRect *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setGeometry(QRect)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QLayout::setGeometry(*cppArg0)
                : cppSelf->setGeometry(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_setGeometry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_setMargin(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.setMargin";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::setMargin(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMargin(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_setMargin_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMargin(int)
            cppSelf->setMargin(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_setMargin_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_setMenuBar(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.setMenuBar";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::setMenuBar(QWidget*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArg)))) {
        overloadId = 0; // setMenuBar(QWidget*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_setMenuBar_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWidget *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMenuBar(QWidget*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            addLayoutOwnership(cppSelf, cppArg0);
            // END of custom code block [file: ../glue/qtwidgets.cpp (addownership-1)]
            // ========================================================================

            // End of code injection

            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            cppSelf->setMenuBar(cppArg0);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_setMenuBar_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_setSizeConstraint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.setSizeConstraint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::setSizeConstraint(QLayout::SizeConstraint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setSizeConstraint(QLayout::SizeConstraint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_setSizeConstraint_TypeError;

    // Call function/method
    {
        ::QLayout::SizeConstraint cppArg0{QLayout::SetDefaultConstraint};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSizeConstraint(QLayout::SizeConstraint)
            cppSelf->setSizeConstraint(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_setSizeConstraint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_setSpacing(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.setSpacing";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::setSpacing(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSpacing(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_setSpacing_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSpacing(int)
            cppSelf->setSpacing(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_setSpacing_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_sizeConstraint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.sizeConstraint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sizeConstraint()const
            QLayout::SizeConstraint cppResult = const_cast<const ::QLayout *>(cppSelf)->sizeConstraint();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_spacing(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.spacing";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // spacing()const
            int cppResult = const_cast<const ::QLayout *>(cppSelf)->spacing();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_takeAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.takeAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::takeAt(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // takeAt(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_takeAt_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // takeAt(int)
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QLayout.takeAt()' not implemented.");
                return {};
            }
            QLayoutItem * cppResult = cppSelf->takeAt(cppArg0);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]), cppResult);
            Shiboken::Object::setParent(Py_None, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLayoutFunc_takeAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_totalHeightForWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.totalHeightForWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::totalHeightForWidth(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // totalHeightForWidth(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_totalHeightForWidth_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // totalHeightForWidth(int)const
            int cppResult = const_cast<const ::QLayout *>(cppSelf)->totalHeightForWidth(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QLayoutFunc_totalHeightForWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QLayoutFunc_totalMaximumSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.totalMaximumSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // totalMaximumSize()const
            QSize cppResult = const_cast<const ::QLayout *>(cppSelf)->totalMaximumSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_totalMinimumSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.totalMinimumSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // totalMinimumSize()const
            QSize cppResult = const_cast<const ::QLayout *>(cppSelf)->totalMinimumSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_totalSizeHint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.totalSizeHint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // totalSizeHint()const
            QSize cppResult = const_cast<const ::QLayout *>(cppSelf)->totalSizeHint();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QLayoutFunc_update(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.update";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // update()
            cppSelf->update();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QLayoutFunc_widgetEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QLayout.widgetEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QLayout::widgetEvent(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // widgetEvent(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QLayoutFunc_widgetEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // widgetEvent(QEvent*)
            cppSelf->widgetEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QLayoutFunc_widgetEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QLayout_PropertyStrings[] = {
    "contentsMargins::",
    "margin::",
    "sizeConstraint::",
    "spacing::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QLayout_methods[] = {
    {"activate", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_activate), METH_NOARGS},
    {"addChildLayout", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_addChildLayout), METH_O},
    {"addChildWidget", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_addChildWidget), METH_O},
    {"addItem", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_addItem), METH_O},
    {"addWidget", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_addWidget), METH_O},
    {"adoptLayout", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_adoptLayout), METH_O},
    {"alignmentRect", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_alignmentRect), METH_O},
    {"childEvent", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_childEvent), METH_O},
    {"closestAcceptableSize", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_closestAcceptableSize), METH_VARARGS|METH_STATIC},
    {"contentsMargins", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_contentsMargins), METH_NOARGS},
    {"contentsRect", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_contentsRect), METH_NOARGS},
    {"controlTypes", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_controlTypes), METH_NOARGS},
    {"count", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_count), METH_NOARGS},
    {"expandingDirections", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_expandingDirections), METH_NOARGS},
    {"geometry", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_geometry), METH_NOARGS},
    {"getContentsMargins", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_getContentsMargins), METH_NOARGS},
    {"indexOf", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_indexOf), METH_O},
    {"invalidate", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_invalidate), METH_NOARGS},
    {"isEmpty", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_isEmpty), METH_NOARGS},
    {"isEnabled", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_isEnabled), METH_NOARGS},
    {"itemAt", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_itemAt), METH_O},
    {"layout", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_layout), METH_NOARGS},
    {"margin", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_margin), METH_NOARGS},
    {"maximumSize", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_maximumSize), METH_NOARGS},
    {"menuBar", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_menuBar), METH_NOARGS},
    {"minimumSize", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_minimumSize), METH_NOARGS},
    {"parentWidget", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_parentWidget), METH_NOARGS},
    {"removeItem", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_removeItem), METH_O},
    {"removeWidget", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_removeWidget), METH_O},
    {"replaceWidget", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_replaceWidget), METH_VARARGS|METH_KEYWORDS},
    {"setAlignment", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_setAlignment), METH_VARARGS},
    {"setContentsMargins", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_setContentsMargins), METH_VARARGS},
    {"setEnabled", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_setEnabled), METH_O},
    {"setGeometry", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_setGeometry), METH_O},
    {"setMargin", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_setMargin), METH_O},
    {"setMenuBar", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_setMenuBar), METH_O},
    {"setSizeConstraint", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_setSizeConstraint), METH_O},
    {"setSpacing", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_setSpacing), METH_O},
    {"sizeConstraint", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_sizeConstraint), METH_NOARGS},
    {"spacing", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_spacing), METH_NOARGS},
    {"takeAt", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_takeAt), METH_O},
    {"totalHeightForWidth", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_totalHeightForWidth), METH_O},
    {"totalMaximumSize", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_totalMaximumSize), METH_NOARGS},
    {"totalMinimumSize", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_totalMinimumSize), METH_NOARGS},
    {"totalSizeHint", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_totalSizeHint), METH_NOARGS},
    {"update", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_update), METH_NOARGS},
    {"widgetEvent", reinterpret_cast<PyCFunction>(Sbk_QLayoutFunc_widgetEvent), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QLayout_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QLayout *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QLayoutWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QLayout_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QLayout_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
static int mi_offsets[] = { -1, -1, -1, -1, -1 };
int *
Sbk_QLayout_mi_init(const void *cptr)
{
    if (mi_offsets[0] == -1) {
        std::set<int> offsets;
        const auto *class_ptr = reinterpret_cast<const QLayout *>(cptr);
        const auto base = reinterpret_cast<uintptr_t>(class_ptr);
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(class_ptr)) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QObject *>(static_cast<const QLayout *>(static_cast<const void *>(class_ptr)))) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QLayoutItem *>(class_ptr)) - base));
        offsets.insert(int(reinterpret_cast<uintptr_t>(static_cast<const QLayoutItem *>(static_cast<const QLayout *>(static_cast<const void *>(class_ptr)))) - base));

        offsets.erase(0);

        std::copy(offsets.cbegin(), offsets.cend(), mi_offsets);
    }
    return mi_offsets;
}
static void * Sbk_QLayoutSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QLayout *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]))
        return static_cast< ::QLayoutItem *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QLayout_Type = nullptr;
static SbkObjectType *Sbk_QLayout_TypeF(void)
{
    return _Sbk_QLayout_Type;
}

static PyType_Slot Sbk_QLayout_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QLayout_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QLayout_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QLayout_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QLayout_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QLayout_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QLayout_spec = {
    "2:PySide2.QtWidgets.QLayout",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QLayout_slots
};

} //extern "C"

static void *Sbk_QLayout_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QLayout *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QLayoutItem >()))
        return dynamic_cast< ::QLayout *>(reinterpret_cast< ::QLayoutItem *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QLayout_SizeConstraint_PythonToCpp_QLayout_SizeConstraint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QLayout::SizeConstraint *>(cppOut) =
        static_cast<::QLayout::SizeConstraint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QLayout_SizeConstraint_PythonToCpp_QLayout_SizeConstraint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX]))
        return QLayout_SizeConstraint_PythonToCpp_QLayout_SizeConstraint;
    return {};
}
static PyObject *QLayout_SizeConstraint_CppToPython_QLayout_SizeConstraint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QLayout::SizeConstraint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QLayout_PythonToCpp_QLayout_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QLayout_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QLayout_PythonToCpp_QLayout_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QLayout_TypeF())))
        return QLayout_PythonToCpp_QLayout_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QLayout_PTR_CppToPython_QLayout(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QLayout *>(const_cast<void *>(cppIn)), Sbk_QLayout_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QLayout_SignatureStrings[] = {
    "1:PySide2.QtWidgets.QLayout(self)",
    "0:PySide2.QtWidgets.QLayout(self,parent:PySide2.QtWidgets.QWidget)",
    "PySide2.QtWidgets.QLayout.activate(self)->bool",
    "PySide2.QtWidgets.QLayout.addChildLayout(self,l:PySide2.QtWidgets.QLayout)",
    "PySide2.QtWidgets.QLayout.addChildWidget(self,w:PySide2.QtWidgets.QWidget)",
    "PySide2.QtWidgets.QLayout.addItem(self,arg__1:PySide2.QtWidgets.QLayoutItem)",
    "PySide2.QtWidgets.QLayout.addWidget(self,w:PySide2.QtWidgets.QWidget)",
    "PySide2.QtWidgets.QLayout.adoptLayout(self,layout:PySide2.QtWidgets.QLayout)->bool",
    "PySide2.QtWidgets.QLayout.alignmentRect(self,arg__1:PySide2.QtCore.QRect)->PySide2.QtCore.QRect",
    "PySide2.QtWidgets.QLayout.childEvent(self,e:PySide2.QtCore.QChildEvent)",
    "PySide2.QtWidgets.QLayout.closestAcceptableSize(w:PySide2.QtWidgets.QWidget,s:PySide2.QtCore.QSize)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QLayout.contentsMargins(self)->PySide2.QtCore.QMargins",
    "PySide2.QtWidgets.QLayout.contentsRect(self)->PySide2.QtCore.QRect",
    "PySide2.QtWidgets.QLayout.controlTypes(self)->PySide2.QtWidgets.QSizePolicy.ControlTypes",
    "PySide2.QtWidgets.QLayout.count(self)->int",
    "PySide2.QtWidgets.QLayout.expandingDirections(self)->PySide2.QtCore.Qt.Orientations",
    "PySide2.QtWidgets.QLayout.geometry(self)->PySide2.QtCore.QRect",
    "PySide2.QtWidgets.QLayout.getContentsMargins(self,left:int*,top:int*,right:int*,bottom:int*)",
    "1:PySide2.QtWidgets.QLayout.indexOf(self,arg__1:PySide2.QtWidgets.QWidget)->int",
    "0:PySide2.QtWidgets.QLayout.indexOf(self,arg__1:PySide2.QtWidgets.QLayoutItem)->int",
    "PySide2.QtWidgets.QLayout.invalidate(self)",
    "PySide2.QtWidgets.QLayout.isEmpty(self)->bool",
    "PySide2.QtWidgets.QLayout.isEnabled(self)->bool",
    "PySide2.QtWidgets.QLayout.itemAt(self,index:int)->PySide2.QtWidgets.QLayoutItem",
    "PySide2.QtWidgets.QLayout.layout(self)->PySide2.QtWidgets.QLayout",
    "PySide2.QtWidgets.QLayout.margin(self)->int",
    "PySide2.QtWidgets.QLayout.maximumSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QLayout.menuBar(self)->PySide2.QtWidgets.QWidget",
    "PySide2.QtWidgets.QLayout.minimumSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QLayout.parentWidget(self)->PySide2.QtWidgets.QWidget",
    "PySide2.QtWidgets.QLayout.removeItem(self,arg__1:PySide2.QtWidgets.QLayoutItem)",
    "PySide2.QtWidgets.QLayout.removeWidget(self,w:PySide2.QtWidgets.QWidget)",
    "PySide2.QtWidgets.QLayout.replaceWidget(self,from:PySide2.QtWidgets.QWidget,to:PySide2.QtWidgets.QWidget,options:PySide2.QtCore.Qt.FindChildOptions=Qt.FindChildrenRecursively)->PySide2.QtWidgets.QLayoutItem",
    "2:PySide2.QtWidgets.QLayout.setAlignment(self,arg__1:PySide2.QtCore.Qt.Alignment)",
    "1:PySide2.QtWidgets.QLayout.setAlignment(self,l:PySide2.QtWidgets.QLayout,alignment:PySide2.QtCore.Qt.Alignment)->bool",
    "0:PySide2.QtWidgets.QLayout.setAlignment(self,w:PySide2.QtWidgets.QWidget,alignment:PySide2.QtCore.Qt.Alignment)->bool",
    "1:PySide2.QtWidgets.QLayout.setContentsMargins(self,margins:PySide2.QtCore.QMargins)",
    "0:PySide2.QtWidgets.QLayout.setContentsMargins(self,left:int,top:int,right:int,bottom:int)",
    "PySide2.QtWidgets.QLayout.setEnabled(self,arg__1:bool)",
    "PySide2.QtWidgets.QLayout.setGeometry(self,arg__1:PySide2.QtCore.QRect)",
    "PySide2.QtWidgets.QLayout.setMargin(self,arg__1:int)",
    "PySide2.QtWidgets.QLayout.setMenuBar(self,w:PySide2.QtWidgets.QWidget)",
    "PySide2.QtWidgets.QLayout.setSizeConstraint(self,arg__1:PySide2.QtWidgets.QLayout.SizeConstraint)",
    "PySide2.QtWidgets.QLayout.setSpacing(self,arg__1:int)",
    "PySide2.QtWidgets.QLayout.sizeConstraint(self)->PySide2.QtWidgets.QLayout.SizeConstraint",
    "PySide2.QtWidgets.QLayout.spacing(self)->int",
    "PySide2.QtWidgets.QLayout.takeAt(self,index:int)->PySide2.QtWidgets.QLayoutItem",
    "PySide2.QtWidgets.QLayout.totalHeightForWidth(self,w:int)->int",
    "PySide2.QtWidgets.QLayout.totalMaximumSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QLayout.totalMinimumSize(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QLayout.totalSizeHint(self)->PySide2.QtCore.QSize",
    "PySide2.QtWidgets.QLayout.update(self)",
    "PySide2.QtWidgets.QLayout.widgetEvent(self,arg__1:PySide2.QtCore.QEvent)",
    nullptr}; // Sentinel

void init_QLayout(PyObject *module)
{
    PyObject *Sbk_QLayout_Type_bases = PyTuple_Pack(2,
        reinterpret_cast<PyObject *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        reinterpret_cast<PyObject *>(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUTITEM_IDX]));

    _Sbk_QLayout_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QLayout",
        "QLayout*",
        &Sbk_QLayout_spec,
        &Shiboken::callCppDestructor< ::QLayout >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        Sbk_QLayout_Type_bases,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QLayout_Type);
    InitSignatureStrings(pyType, QLayout_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QLayout_Type), Sbk_QLayout_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QLayout_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QLayout_TypeF(),
        QLayout_PythonToCpp_QLayout_PTR,
        is_QLayout_PythonToCpp_QLayout_PTR_Convertible,
        QLayout_PTR_CppToPython_QLayout);

    Shiboken::Conversions::registerConverterName(converter, "QLayout");
    Shiboken::Conversions::registerConverterName(converter, "QLayout*");
    Shiboken::Conversions::registerConverterName(converter, "QLayout&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QLayout).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QLayoutWrapper).name());



    MultipleInheritanceInitFunction func = Sbk_QLayout_mi_init;
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QLayout_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QLayout_TypeF(), &Sbk_QLayoutSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QLayout_TypeF(), &Sbk_QLayout_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'SizeConstraint'.
    SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QLayout_TypeF(),
        "SizeConstraint",
        "2:PySide2.QtWidgets.QLayout.SizeConstraint",
        "QLayout::SizeConstraint");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX],
        Sbk_QLayout_TypeF(), "SetDefaultConstraint", (long) QLayout::SizeConstraint::SetDefaultConstraint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX],
        Sbk_QLayout_TypeF(), "SetNoConstraint", (long) QLayout::SizeConstraint::SetNoConstraint))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX],
        Sbk_QLayout_TypeF(), "SetMinimumSize", (long) QLayout::SizeConstraint::SetMinimumSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX],
        Sbk_QLayout_TypeF(), "SetFixedSize", (long) QLayout::SizeConstraint::SetFixedSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX],
        Sbk_QLayout_TypeF(), "SetMaximumSize", (long) QLayout::SizeConstraint::SetMaximumSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX],
        Sbk_QLayout_TypeF(), "SetMinAndMaxSize", (long) QLayout::SizeConstraint::SetMinAndMaxSize))
        return;
    // Register converter for enum 'QLayout::SizeConstraint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX],
            QLayout_SizeConstraint_CppToPython_QLayout_SizeConstraint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QLayout_SizeConstraint_PythonToCpp_QLayout_SizeConstraint,
            is_QLayout_SizeConstraint_PythonToCpp_QLayout_SizeConstraint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QLAYOUT_SIZECONSTRAINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QLayout::SizeConstraint");
        Shiboken::Conversions::registerConverterName(converter, "SizeConstraint");
    }
    // End of 'SizeConstraint' enum.

    PySide::Signal::registerSignals(Sbk_QLayout_TypeF(), &::QLayout::staticMetaObject);

    qRegisterMetaType< ::QLayout::SizeConstraint >("QLayout::SizeConstraint");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QLayout_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QLayout_TypeF(), &::QLayout::staticMetaObject, sizeof(QLayoutWrapper));
}

