/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qitemeditorfactory_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QItemEditorFactoryWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QItemEditorFactoryWrapper::QItemEditorFactoryWrapper() : QItemEditorFactory()
{
    resetPyMethodCache();
    // ... middle
}

::QWidget * QItemEditorFactoryWrapper::createEditor(int userType, ::QWidget * parent) const
{
    if (m_PyMethodCache[0])
        return this->::QItemEditorFactory::createEditor(userType, parent);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "createEditor";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QItemEditorFactory::createEditor(userType, parent);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(iN)",
    userType,
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), parent)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QItemEditorFactory.createEditor", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QWidget >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QWidget *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QByteArray QItemEditorFactoryWrapper::valuePropertyName(int userType) const
{
    if (m_PyMethodCache[1])
        return this->::QItemEditorFactory::valuePropertyName(userType);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "valuePropertyName";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QItemEditorFactory::valuePropertyName(userType);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    userType
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QItemEditorFactory.valuePropertyName", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QByteArray >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QByteArray cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

QItemEditorFactoryWrapper::~QItemEditorFactoryWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QItemEditorFactory_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QItemEditorFactory >()))
        return -1;

    ::QItemEditorFactoryWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QItemEditorFactory.__init__";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // QItemEditorFactory()
            cptr = new ::QItemEditorFactoryWrapper();
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QItemEditorFactory >(), cptr)) {
        delete cptr;
        return -1;
    }
    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;
}

static PyObject *Sbk_QItemEditorFactoryFunc_createEditor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemEditorFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QITEMEDITORFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QItemEditorFactory.createEditor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "createEditor", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QItemEditorFactory::createEditor(int,QWidget*)const
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[1])))) {
        overloadId = 0; // createEditor(int,QWidget*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemEditorFactoryFunc_createEditor_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QWidget *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // createEditor(int,QWidget*)const
            QWidget * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QItemEditorFactory *>(cppSelf)->::QItemEditorFactory::createEditor(cppArg0, cppArg1)
                : const_cast<const ::QItemEditorFactory *>(cppSelf)->createEditor(cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemEditorFactoryFunc_createEditor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemEditorFactoryFunc_defaultFactory(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QItemEditorFactory.defaultFactory";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultFactory()
            const QItemEditorFactory * cppResult = ::QItemEditorFactory::defaultFactory();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QITEMEDITORFACTORY_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QItemEditorFactoryFunc_registerEditor(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemEditorFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QITEMEDITORFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QItemEditorFactory.registerEditor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "registerEditor", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QItemEditorFactory::registerEditor(int,QItemEditorCreatorBase*)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QITEMEDITORCREATORBASE_IDX]), (pyArgs[1])))) {
        overloadId = 0; // registerEditor(int,QItemEditorCreatorBase*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemEditorFactoryFunc_registerEditor_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QItemEditorCreatorBase *cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // registerEditor(int,QItemEditorCreatorBase*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qitemeditorfactory-registereditor)]
            Shiboken::Object::releaseOwnership(pyArgs[2-1]);
            // END of custom code block [file: ../glue/qtwidgets.cpp (qitemeditorfactory-registereditor)]
            // ========================================================================

            // End of code injection

            cppSelf->registerEditor(cppArg0, cppArg1);
            Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "registerEditor(int,QItemEditorCreatorBase*)2", pyArgs[1]);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemEditorFactoryFunc_registerEditor_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemEditorFactoryFunc_setDefaultFactory(PyObject *self, PyObject *pyArg)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QItemEditorFactory.setDefaultFactory";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: static QItemEditorFactory::setDefaultFactory(QItemEditorFactory*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QITEMEDITORFACTORY_IDX]), (pyArg)))) {
        overloadId = 0; // setDefaultFactory(QItemEditorFactory*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemEditorFactoryFunc_setDefaultFactory_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QItemEditorFactory *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultFactory(QItemEditorFactory*)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qitemeditorfactory-setdefaultfactory)]
            //this function is static we need keep ref to default value, to be able to call python virtual functions
            static PyObject *_defaultValue = nullptr;
            QItemEditorFactory::setDefaultFactory(cppArg0);
            Py_INCREF(pyArg);
            if (_defaultValue)
                Py_DECREF(_defaultValue);

            _defaultValue = pyArg;
            // END of custom code block [file: ../glue/qtwidgets.cpp (qitemeditorfactory-setdefaultfactory)]
            // ========================================================================

            // End of code injection


            // Ownership transferences.
            Shiboken::Object::releaseOwnership(pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QItemEditorFactoryFunc_setDefaultFactory_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QItemEditorFactoryFunc_valuePropertyName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QItemEditorFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QITEMEDITORFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QItemEditorFactory.valuePropertyName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QItemEditorFactory::valuePropertyName(int)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // valuePropertyName(int)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QItemEditorFactoryFunc_valuePropertyName_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // valuePropertyName(int)const
            QByteArray cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? const_cast<const ::QItemEditorFactory *>(cppSelf)->::QItemEditorFactory::valuePropertyName(cppArg0)
                : const_cast<const ::QItemEditorFactory *>(cppSelf)->valuePropertyName(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QItemEditorFactoryFunc_valuePropertyName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QItemEditorFactory_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QItemEditorFactory_methods[] = {
    {"createEditor", reinterpret_cast<PyCFunction>(Sbk_QItemEditorFactoryFunc_createEditor), METH_VARARGS},
    {"defaultFactory", reinterpret_cast<PyCFunction>(Sbk_QItemEditorFactoryFunc_defaultFactory), METH_NOARGS|METH_STATIC},
    {"registerEditor", reinterpret_cast<PyCFunction>(Sbk_QItemEditorFactoryFunc_registerEditor), METH_VARARGS},
    {"setDefaultFactory", reinterpret_cast<PyCFunction>(Sbk_QItemEditorFactoryFunc_setDefaultFactory), METH_O|METH_STATIC},
    {"valuePropertyName", reinterpret_cast<PyCFunction>(Sbk_QItemEditorFactoryFunc_valuePropertyName), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QItemEditorFactory_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QItemEditorFactory *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QITEMEDITORFACTORY_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QItemEditorFactoryWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QItemEditorFactory_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QItemEditorFactory_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QItemEditorFactory_Type = nullptr;
static SbkObjectType *Sbk_QItemEditorFactory_TypeF(void)
{
    return _Sbk_QItemEditorFactory_Type;
}

static PyType_Slot Sbk_QItemEditorFactory_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QItemEditorFactory_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QItemEditorFactory_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QItemEditorFactory_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QItemEditorFactory_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QItemEditorFactory_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QItemEditorFactory_spec = {
    "2:PySide2.QtWidgets.QItemEditorFactory",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QItemEditorFactory_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QItemEditorFactory_PythonToCpp_QItemEditorFactory_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QItemEditorFactory_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QItemEditorFactory_PythonToCpp_QItemEditorFactory_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QItemEditorFactory_TypeF())))
        return QItemEditorFactory_PythonToCpp_QItemEditorFactory_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QItemEditorFactory_PTR_CppToPython_QItemEditorFactory(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QItemEditorFactory *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QItemEditorFactory_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QItemEditorFactory_SignatureStrings[] = {
    "PySide2.QtWidgets.QItemEditorFactory(self)",
    "PySide2.QtWidgets.QItemEditorFactory.createEditor(self,userType:int,parent:PySide2.QtWidgets.QWidget)->PySide2.QtWidgets.QWidget",
    "PySide2.QtWidgets.QItemEditorFactory.defaultFactory()->PySide2.QtWidgets.QItemEditorFactory",
    "PySide2.QtWidgets.QItemEditorFactory.registerEditor(self,userType:int,creator:PySide2.QtWidgets.QItemEditorCreatorBase)",
    "PySide2.QtWidgets.QItemEditorFactory.setDefaultFactory(factory:PySide2.QtWidgets.QItemEditorFactory)",
    "PySide2.QtWidgets.QItemEditorFactory.valuePropertyName(self,userType:int)->PySide2.QtCore.QByteArray",
    nullptr}; // Sentinel

void init_QItemEditorFactory(PyObject *module)
{
    _Sbk_QItemEditorFactory_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QItemEditorFactory",
        "QItemEditorFactory*",
        &Sbk_QItemEditorFactory_spec,
        &Shiboken::callCppDestructor< ::QItemEditorFactory >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QItemEditorFactory_Type);
    InitSignatureStrings(pyType, QItemEditorFactory_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QItemEditorFactory_Type), Sbk_QItemEditorFactory_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QITEMEDITORFACTORY_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QItemEditorFactory_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QItemEditorFactory_TypeF(),
        QItemEditorFactory_PythonToCpp_QItemEditorFactory_PTR,
        is_QItemEditorFactory_PythonToCpp_QItemEditorFactory_PTR_Convertible,
        QItemEditorFactory_PTR_CppToPython_QItemEditorFactory);

    Shiboken::Conversions::registerConverterName(converter, "QItemEditorFactory");
    Shiboken::Conversions::registerConverterName(converter, "QItemEditorFactory*");
    Shiboken::Conversions::registerConverterName(converter, "QItemEditorFactory&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QItemEditorFactory).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QItemEditorFactoryWrapper).name());


}
