/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qgraphicslayoutitem_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGraphicsLayoutItemWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGraphicsLayoutItemWrapper::QGraphicsLayoutItemWrapper(::QGraphicsLayoutItem * parent, bool isLayout) : QGraphicsLayoutItem(parent, isLayout)
{
    resetPyMethodCache();
    // ... middle
}

void QGraphicsLayoutItemWrapper::getContentsMargins(qreal * left, qreal * top, qreal * right, qreal * bottom) const
{
    if (m_PyMethodCache[0]) {
        return this->::QGraphicsLayoutItem::getContentsMargins(left, top, right, bottom);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "getContentsMargins";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QGraphicsLayoutItem::getContentsMargins(left, top, right, bottom);
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }

    // Begin code injection
    // TEMPLATE - fix_native_return_number*,number*,number*,number* - START
    PyObject* _obj = pyResult.object();
    if (!PySequence_Check(_obj)
        || PySequence_Fast_GET_SIZE(_obj) != 4
        || !SbkNumber_Check(PySequence_Fast_GET_ITEM(_obj, 0))
        || !SbkNumber_Check(PySequence_Fast_GET_ITEM(_obj, 1))
        || !SbkNumber_Check(PySequence_Fast_GET_ITEM(_obj, 2))
        || !SbkNumber_Check(PySequence_Fast_GET_ITEM(_obj, 3))) {
        PyErr_SetString(PyExc_TypeError, "Sequence of 4 numbers expected");
    } else {
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), PySequence_Fast_GET_ITEM(_obj, 0), (left));
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), PySequence_Fast_GET_ITEM(_obj, 1), (top));
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), PySequence_Fast_GET_ITEM(_obj, 2), (right));
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), PySequence_Fast_GET_ITEM(_obj, 3), (bottom));
    }
    // TEMPLATE - fix_native_return_number*,number*,number*,number* - END

    // End of code injection

}

void QGraphicsLayoutItemWrapper::setGeometry(const ::QRectF & rect)
{
    if (m_PyMethodCache[1]) {
        return this->::QGraphicsLayoutItem::setGeometry(rect);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setGeometry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QGraphicsLayoutItem::setGeometry(rect);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &rect)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QSizeF QGraphicsLayoutItemWrapper::sizeHint(::Qt::SizeHint which, const ::QSizeF & constraint) const
{
    if (m_PyMethodCache[2]) {
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGraphicsLayoutItem.sizeHint()' not implemented.");
        return {};
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGraphicsLayoutItem.sizeHint()' not implemented.");
        return {};
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX])->converter, &which),
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &constraint)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsLayoutItem.sizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSizeF >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSizeF cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QGraphicsLayoutItemWrapper::updateGeometry()
{
    if (m_PyMethodCache[3]) {
        return this->::QGraphicsLayoutItem::updateGeometry();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "updateGeometry";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QGraphicsLayoutItem::updateGeometry();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

QGraphicsLayoutItemWrapper::~QGraphicsLayoutItemWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGraphicsLayoutItem_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
    SbkObjectType *type = reinterpret_cast<SbkObjectType *>(self->ob_type);
    SbkObjectType *myType = reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX]);
    if (type == myType) {
        PyErr_SetString(PyExc_NotImplementedError,
            "'QGraphicsLayoutItem' represents a C++ abstract class and cannot be instantiated");
        return -1;
    }

PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGraphicsLayoutItem >()))
        return -1;

    ::QGraphicsLayoutItemWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsLayoutItem_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:QGraphicsLayoutItem", &(pyArgs[0]), &(pyArgs[1])))
        return -1;


    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::QGraphicsLayoutItem(QGraphicsLayoutItem*,bool)
    if (numArgs == 0) {
        overloadId = 0; // QGraphicsLayoutItem(QGraphicsLayoutItem*,bool)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // QGraphicsLayoutItem(QGraphicsLayoutItem*,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // QGraphicsLayoutItem(QGraphicsLayoutItem*,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItem_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsLayoutItem_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX]), (pyArgs[0]))))
                        goto Sbk_QGraphicsLayoutItem_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_isLayout = Shiboken::String::createStaticString("isLayout");
            if (PyDict_Contains(kwds, key_isLayout)) {
                value = PyDict_GetItem(kwds, key_isLayout);
                if (value && pyArgs[1]) {
                    errInfo = key_isLayout;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsLayoutItem_Init_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QGraphicsLayoutItem_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_isLayout);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsLayoutItem_Init_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QGraphicsLayoutItem *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = false;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // QGraphicsLayoutItem(QGraphicsLayoutItem*,bool)
            cptr = new ::QGraphicsLayoutItemWrapper(cppArg0, cppArg1);
            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGraphicsLayoutItem >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGraphicsLayoutItem_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QGraphicsLayoutItem_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_contentsRect(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.contentsRect";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // contentsRect()const
            QRectF cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->contentsRect();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_effectiveSizeHint(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.effectiveSizeHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsLayoutItemFunc_effectiveSizeHint_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsLayoutItemFunc_effectiveSizeHint_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:effectiveSizeHint", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::effectiveSizeHint(Qt::SizeHint,QSizeF)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // effectiveSizeHint(Qt::SizeHint,QSizeF)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[1])))) {
            overloadId = 0; // effectiveSizeHint(Qt::SizeHint,QSizeF)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_effectiveSizeHint_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_constraint = Shiboken::String::createStaticString("constraint");
            if (PyDict_Contains(kwds, key_constraint)) {
                value = PyDict_GetItem(kwds, key_constraint);
                if (value && pyArgs[1]) {
                    errInfo = key_constraint;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsLayoutItemFunc_effectiveSizeHint_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[1]))))
                        goto Sbk_QGraphicsLayoutItemFunc_effectiveSizeHint_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_constraint);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsLayoutItemFunc_effectiveSizeHint_TypeError;
            }
        }
        ::Qt::SizeHint cppArg0{Qt::MinimumSize};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSizeF cppArg1_local = QSizeF();
        ::QSizeF *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // effectiveSizeHint(Qt::SizeHint,QSizeF)const
            QSizeF cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->effectiveSizeHint(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsLayoutItemFunc_effectiveSizeHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_geometry(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.geometry";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // geometry()const
            QRectF cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->geometry();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_getContentsMargins(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.getContentsMargins";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // getContentsMargins(qreal*,qreal*,qreal*,qreal*)const
            // Begin code injection
            // TEMPLATE - fix_number*,number*,number*,number* - START
            qreal a, b, c, d;
            cppSelf->::QGraphicsLayoutItem::getContentsMargins(&a, &b, &c, &d);
            // TEMPLATE - tuple_abcd_same_type - START
            pyResult = PyTuple_New(4);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &a));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &b));
            PyTuple_SET_ITEM(pyResult, 2, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &c));
            PyTuple_SET_ITEM(pyResult, 3, Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &d));
            // TEMPLATE - tuple_abcd_same_type - END
            // TEMPLATE - fix_number*,number*,number*,number* - END

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_graphicsItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.graphicsItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // graphicsItem()const
            QGraphicsItem * cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->graphicsItem();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_isLayout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.isLayout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isLayout()const
            bool cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->isLayout();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_maximumHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.maximumHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumHeight()const
            qreal cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->maximumHeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_maximumSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.maximumSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumSize()const
            QSizeF cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->maximumSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_maximumWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.maximumWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maximumWidth()const
            qreal cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->maximumWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_minimumHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.minimumHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumHeight()const
            qreal cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->minimumHeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_minimumSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.minimumSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumSize()const
            QSizeF cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->minimumSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_minimumWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.minimumWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // minimumWidth()const
            qreal cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->minimumWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_ownedByLayout(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.ownedByLayout";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // ownedByLayout()const
            bool cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->ownedByLayout();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_parentLayoutItem(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.parentLayoutItem";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // parentLayoutItem()const
            QGraphicsLayoutItem * cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->parentLayoutItem();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_preferredHeight(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.preferredHeight";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // preferredHeight()const
            qreal cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->preferredHeight();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_preferredSize(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.preferredSize";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // preferredSize()const
            QSizeF cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->preferredSize();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_preferredWidth(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.preferredWidth";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // preferredWidth()const
            qreal cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->preferredWidth();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setGeometry(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setGeometry";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setGeometry(QRectF)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), (pyArg)))) {
        overloadId = 0; // setGeometry(QRectF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setGeometry_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QRectF cppArg0_local;
        ::QRectF *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QRECTF_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setGeometry(QRectF)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsLayoutItem::setGeometry(*cppArg0)
                : cppSelf->setGeometry(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setGeometry_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setGraphicsItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setGraphicsItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setGraphicsItem(QGraphicsItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), (pyArg)))) {
        overloadId = 0; // setGraphicsItem(QGraphicsItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setGraphicsItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setGraphicsItem(QGraphicsItem*)
            cppSelf->setGraphicsItem(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setGraphicsItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setMaximumHeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setMaximumHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setMaximumHeight(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setMaximumHeight(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setMaximumHeight_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaximumHeight(qreal)
            cppSelf->setMaximumHeight(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setMaximumHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setMaximumSize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setMaximumSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setMaximumSize", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setMaximumSize(QSizeF)
    // 1: QGraphicsLayoutItem::setMaximumSize(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 1; // setMaximumSize(qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setMaximumSize(QSizeF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setMaximumSize_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setMaximumSize(const QSizeF & size)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSizeF cppArg0_local;
            ::QSizeF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setMaximumSize(QSizeF)
                cppSelf->setMaximumSize(*cppArg0);
            }
            break;
        }
        case 1: // setMaximumSize(qreal w, qreal h)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setMaximumSize(qreal,qreal)
                cppSelf->setMaximumSize(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setMaximumSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setMaximumWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setMaximumWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setMaximumWidth(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setMaximumWidth(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setMaximumWidth_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaximumWidth(qreal)
            cppSelf->setMaximumWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setMaximumWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setMinimumHeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setMinimumHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setMinimumHeight(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setMinimumHeight(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setMinimumHeight_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinimumHeight(qreal)
            cppSelf->setMinimumHeight(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setMinimumHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setMinimumSize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setMinimumSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setMinimumSize", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setMinimumSize(QSizeF)
    // 1: QGraphicsLayoutItem::setMinimumSize(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 1; // setMinimumSize(qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setMinimumSize(QSizeF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setMinimumSize_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setMinimumSize(const QSizeF & size)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSizeF cppArg0_local;
            ::QSizeF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setMinimumSize(QSizeF)
                cppSelf->setMinimumSize(*cppArg0);
            }
            break;
        }
        case 1: // setMinimumSize(qreal w, qreal h)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setMinimumSize(qreal,qreal)
                cppSelf->setMinimumSize(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setMinimumSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setMinimumWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setMinimumWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setMinimumWidth(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setMinimumWidth(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setMinimumWidth_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMinimumWidth(qreal)
            cppSelf->setMinimumWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setMinimumWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setOwnedByLayout(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setOwnedByLayout";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setOwnedByLayout(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setOwnedByLayout(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setOwnedByLayout_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOwnedByLayout(bool)
            cppSelf->setOwnedByLayout(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setOwnedByLayout_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setParentLayoutItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setParentLayoutItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setParentLayoutItem(QGraphicsLayoutItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX]), (pyArg)))) {
        overloadId = 0; // setParentLayoutItem(QGraphicsLayoutItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setParentLayoutItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsLayoutItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setParentLayoutItem(QGraphicsLayoutItem*)
            cppSelf->setParentLayoutItem(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setParentLayoutItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setPreferredHeight(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setPreferredHeight";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setPreferredHeight(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setPreferredHeight(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setPreferredHeight_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPreferredHeight(qreal)
            cppSelf->setPreferredHeight(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setPreferredHeight_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setPreferredSize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setPreferredSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setPreferredSize", 1, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setPreferredSize(QSizeF)
    // 1: QGraphicsLayoutItem::setPreferredSize(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 1; // setPreferredSize(qreal,qreal)
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[0])))) {
        overloadId = 0; // setPreferredSize(QSizeF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setPreferredSize_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setPreferredSize(const QSizeF & size)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSizeF cppArg0_local;
            ::QSizeF *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setPreferredSize(QSizeF)
                cppSelf->setPreferredSize(*cppArg0);
            }
            break;
        }
        case 1: // setPreferredSize(qreal w, qreal h)
        {
            qreal cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            qreal cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // setPreferredSize(qreal,qreal)
                cppSelf->setPreferredSize(cppArg0, cppArg1);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setPreferredSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setPreferredWidth(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setPreferredWidth";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setPreferredWidth(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setPreferredWidth(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setPreferredWidth_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setPreferredWidth(qreal)
            cppSelf->setPreferredWidth(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setPreferredWidth_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_setSizePolicy(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.setSizePolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs > 3) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsLayoutItemFunc_setSizePolicy_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsLayoutItemFunc_setSizePolicy_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:setSizePolicy", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::setSizePolicy(QSizePolicy::Policy,QSizePolicy::Policy,QSizePolicy::ControlType)
    // 1: QGraphicsLayoutItem::setSizePolicy(QSizePolicy)
    if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX]), (pyArgs[0])))) {
        overloadId = 1; // setSizePolicy(QSizePolicy)
    } else if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_POLICY_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // setSizePolicy(QSizePolicy::Policy,QSizePolicy::Policy,QSizePolicy::ControlType)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, (pyArgs[2])))) {
            overloadId = 0; // setSizePolicy(QSizePolicy::Policy,QSizePolicy::Policy,QSizePolicy::ControlType)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_setSizePolicy_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setSizePolicy(QSizePolicy::Policy hPolicy, QSizePolicy::Policy vPolicy, QSizePolicy::ControlType controlType)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_controlType = Shiboken::String::createStaticString("controlType");
                if (PyDict_Contains(kwds, key_controlType)) {
                    value = PyDict_GetItem(kwds, key_controlType);
                    if (value && pyArgs[2]) {
                        errInfo = key_controlType;
                        Py_INCREF(errInfo);
                        goto Sbk_QGraphicsLayoutItemFunc_setSizePolicy_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_CONTROLTYPE_IDX])->converter, (pyArgs[2]))))
                            goto Sbk_QGraphicsLayoutItemFunc_setSizePolicy_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_controlType);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    goto Sbk_QGraphicsLayoutItemFunc_setSizePolicy_TypeError;
                }
            }
            ::QSizePolicy::Policy cppArg0{QSizePolicy::Fixed};
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QSizePolicy::Policy cppArg1{QSizePolicy::Fixed};
            pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QSizePolicy::ControlType cppArg2 = QSizePolicy::DefaultType;
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

            if (!PyErr_Occurred()) {
                // setSizePolicy(QSizePolicy::Policy,QSizePolicy::Policy,QSizePolicy::ControlType)
                cppSelf->setSizePolicy(cppArg0, cppArg1, cppArg2);
            }
            break;
        }
        case 1: // setSizePolicy(const QSizePolicy & policy)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QGraphicsLayoutItemFunc_setSizePolicy_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QSizePolicy cppArg0_local;
            ::QSizePolicy *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // setSizePolicy(QSizePolicy)
                cppSelf->setSizePolicy(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsLayoutItemFunc_setSizePolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_sizeHint(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.sizeHint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsLayoutItemFunc_sizeHint_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QGraphicsLayoutItemFunc_sizeHint_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:sizeHint", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsLayoutItem::sizeHint(Qt::SizeHint,QSizeF)const
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_SIZEHINT_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // sizeHint(Qt::SizeHint,QSizeF)const
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[1])))) {
            overloadId = 0; // sizeHint(Qt::SizeHint,QSizeF)const
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsLayoutItemFunc_sizeHint_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_constraint = Shiboken::String::createStaticString("constraint");
            if (PyDict_Contains(kwds, key_constraint)) {
                value = PyDict_GetItem(kwds, key_constraint);
                if (value && pyArgs[1]) {
                    errInfo = key_constraint;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsLayoutItemFunc_sizeHint_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), (pyArgs[1]))))
                        goto Sbk_QGraphicsLayoutItemFunc_sizeHint_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_constraint);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QGraphicsLayoutItemFunc_sizeHint_TypeError;
            }
        }
        ::Qt::SizeHint cppArg0{Qt::MinimumSize};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QSizeF cppArg1_local = QSizeF();
        ::QSizeF *cppArg1 = &cppArg1_local;
        if (pythonToCpp[1]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);
        }

        if (!PyErr_Occurred()) {
            // sizeHint(Qt::SizeHint,QSizeF)const
            if (Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))) {
                PyErr_SetString(PyExc_NotImplementedError, "pure virtual method 'QGraphicsLayoutItem.sizeHint()' not implemented.");
                return {};
            }
            QSizeF cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->sizeHint(cppArg0, *cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZEF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsLayoutItemFunc_sizeHint_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_sizePolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.sizePolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sizePolicy()const
            QSizePolicy cppResult = const_cast<const ::QGraphicsLayoutItem *>(cppSelf)->sizePolicy();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QSIZEPOLICY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsLayoutItemFunc_updateGeometry(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsLayoutItem.updateGeometry";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // updateGeometry()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsLayoutItem::updateGeometry()
                : cppSelf->updateGeometry();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}


static const char *Sbk_QGraphicsLayoutItem_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGraphicsLayoutItem_methods[] = {
    {"contentsRect", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_contentsRect), METH_NOARGS},
    {"effectiveSizeHint", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_effectiveSizeHint), METH_VARARGS|METH_KEYWORDS},
    {"geometry", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_geometry), METH_NOARGS},
    {"getContentsMargins", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_getContentsMargins), METH_NOARGS},
    {"graphicsItem", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_graphicsItem), METH_NOARGS},
    {"isLayout", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_isLayout), METH_NOARGS},
    {"maximumHeight", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_maximumHeight), METH_NOARGS},
    {"maximumSize", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_maximumSize), METH_NOARGS},
    {"maximumWidth", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_maximumWidth), METH_NOARGS},
    {"minimumHeight", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_minimumHeight), METH_NOARGS},
    {"minimumSize", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_minimumSize), METH_NOARGS},
    {"minimumWidth", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_minimumWidth), METH_NOARGS},
    {"ownedByLayout", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_ownedByLayout), METH_NOARGS},
    {"parentLayoutItem", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_parentLayoutItem), METH_NOARGS},
    {"preferredHeight", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_preferredHeight), METH_NOARGS},
    {"preferredSize", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_preferredSize), METH_NOARGS},
    {"preferredWidth", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_preferredWidth), METH_NOARGS},
    {"setGeometry", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setGeometry), METH_O},
    {"setGraphicsItem", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setGraphicsItem), METH_O},
    {"setMaximumHeight", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setMaximumHeight), METH_O},
    {"setMaximumSize", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setMaximumSize), METH_VARARGS},
    {"setMaximumWidth", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setMaximumWidth), METH_O},
    {"setMinimumHeight", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setMinimumHeight), METH_O},
    {"setMinimumSize", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setMinimumSize), METH_VARARGS},
    {"setMinimumWidth", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setMinimumWidth), METH_O},
    {"setOwnedByLayout", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setOwnedByLayout), METH_O},
    {"setParentLayoutItem", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setParentLayoutItem), METH_O},
    {"setPreferredHeight", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setPreferredHeight), METH_O},
    {"setPreferredSize", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setPreferredSize), METH_VARARGS},
    {"setPreferredWidth", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setPreferredWidth), METH_O},
    {"setSizePolicy", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_setSizePolicy), METH_VARARGS|METH_KEYWORDS},
    {"sizeHint", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_sizeHint), METH_VARARGS|METH_KEYWORDS},
    {"sizePolicy", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_sizePolicy), METH_NOARGS},
    {"updateGeometry", reinterpret_cast<PyCFunction>(Sbk_QGraphicsLayoutItemFunc_updateGeometry), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGraphicsLayoutItem_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGraphicsLayoutItem *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGraphicsLayoutItemWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGraphicsLayoutItem_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGraphicsLayoutItem_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGraphicsLayoutItem_Type = nullptr;
static SbkObjectType *Sbk_QGraphicsLayoutItem_TypeF(void)
{
    return _Sbk_QGraphicsLayoutItem_Type;
}

static PyType_Slot Sbk_QGraphicsLayoutItem_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGraphicsLayoutItem_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGraphicsLayoutItem_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGraphicsLayoutItem_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGraphicsLayoutItem_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGraphicsLayoutItem_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGraphicsLayoutItem_spec = {
    "2:PySide2.QtWidgets.QGraphicsLayoutItem",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGraphicsLayoutItem_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGraphicsLayoutItem_PythonToCpp_QGraphicsLayoutItem_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGraphicsLayoutItem_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGraphicsLayoutItem_PythonToCpp_QGraphicsLayoutItem_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGraphicsLayoutItem_TypeF())))
        return QGraphicsLayoutItem_PythonToCpp_QGraphicsLayoutItem_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGraphicsLayoutItem_PTR_CppToPython_QGraphicsLayoutItem(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QGraphicsLayoutItem *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QGraphicsLayoutItem_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGraphicsLayoutItem_SignatureStrings[] = {
    "PySide2.QtWidgets.QGraphicsLayoutItem(self,parent:PySide2.QtWidgets.QGraphicsLayoutItem=nullptr,isLayout:bool=false)",
    "PySide2.QtWidgets.QGraphicsLayoutItem.contentsRect(self)->PySide2.QtCore.QRectF",
    "PySide2.QtWidgets.QGraphicsLayoutItem.effectiveSizeHint(self,which:PySide2.QtCore.Qt.SizeHint,constraint:PySide2.QtCore.QSizeF=QSizeF())->PySide2.QtCore.QSizeF",
    "PySide2.QtWidgets.QGraphicsLayoutItem.geometry(self)->PySide2.QtCore.QRectF",
    "PySide2.QtWidgets.QGraphicsLayoutItem.getContentsMargins(self,left:qreal*,top:qreal*,right:qreal*,bottom:qreal*)",
    "PySide2.QtWidgets.QGraphicsLayoutItem.graphicsItem(self)->PySide2.QtWidgets.QGraphicsItem",
    "PySide2.QtWidgets.QGraphicsLayoutItem.isLayout(self)->bool",
    "PySide2.QtWidgets.QGraphicsLayoutItem.maximumHeight(self)->qreal",
    "PySide2.QtWidgets.QGraphicsLayoutItem.maximumSize(self)->PySide2.QtCore.QSizeF",
    "PySide2.QtWidgets.QGraphicsLayoutItem.maximumWidth(self)->qreal",
    "PySide2.QtWidgets.QGraphicsLayoutItem.minimumHeight(self)->qreal",
    "PySide2.QtWidgets.QGraphicsLayoutItem.minimumSize(self)->PySide2.QtCore.QSizeF",
    "PySide2.QtWidgets.QGraphicsLayoutItem.minimumWidth(self)->qreal",
    "PySide2.QtWidgets.QGraphicsLayoutItem.ownedByLayout(self)->bool",
    "PySide2.QtWidgets.QGraphicsLayoutItem.parentLayoutItem(self)->PySide2.QtWidgets.QGraphicsLayoutItem",
    "PySide2.QtWidgets.QGraphicsLayoutItem.preferredHeight(self)->qreal",
    "PySide2.QtWidgets.QGraphicsLayoutItem.preferredSize(self)->PySide2.QtCore.QSizeF",
    "PySide2.QtWidgets.QGraphicsLayoutItem.preferredWidth(self)->qreal",
    "PySide2.QtWidgets.QGraphicsLayoutItem.setGeometry(self,rect:PySide2.QtCore.QRectF)",
    "PySide2.QtWidgets.QGraphicsLayoutItem.setGraphicsItem(self,item:PySide2.QtWidgets.QGraphicsItem)",
    "PySide2.QtWidgets.QGraphicsLayoutItem.setMaximumHeight(self,height:qreal)",
    "1:PySide2.QtWidgets.QGraphicsLayoutItem.setMaximumSize(self,size:PySide2.QtCore.QSizeF)",
    "0:PySide2.QtWidgets.QGraphicsLayoutItem.setMaximumSize(self,w:qreal,h:qreal)",
    "PySide2.QtWidgets.QGraphicsLayoutItem.setMaximumWidth(self,width:qreal)",
    "PySide2.QtWidgets.QGraphicsLayoutItem.setMinimumHeight(self,height:qreal)",
    "1:PySide2.QtWidgets.QGraphicsLayoutItem.setMinimumSize(self,size:PySide2.QtCore.QSizeF)",
    "0:PySide2.QtWidgets.QGraphicsLayoutItem.setMinimumSize(self,w:qreal,h:qreal)",
    "PySide2.QtWidgets.QGraphicsLayoutItem.setMinimumWidth(self,width:qreal)",
    "PySide2.QtWidgets.QGraphicsLayoutItem.setOwnedByLayout(self,ownedByLayout:bool)",
    "PySide2.QtWidgets.QGraphicsLayoutItem.setParentLayoutItem(self,parent:PySide2.QtWidgets.QGraphicsLayoutItem)",
    "PySide2.QtWidgets.QGraphicsLayoutItem.setPreferredHeight(self,height:qreal)",
    "1:PySide2.QtWidgets.QGraphicsLayoutItem.setPreferredSize(self,size:PySide2.QtCore.QSizeF)",
    "0:PySide2.QtWidgets.QGraphicsLayoutItem.setPreferredSize(self,w:qreal,h:qreal)",
    "PySide2.QtWidgets.QGraphicsLayoutItem.setPreferredWidth(self,width:qreal)",
    "1:PySide2.QtWidgets.QGraphicsLayoutItem.setSizePolicy(self,hPolicy:PySide2.QtWidgets.QSizePolicy.Policy,vPolicy:PySide2.QtWidgets.QSizePolicy.Policy,controlType:PySide2.QtWidgets.QSizePolicy.ControlType=QSizePolicy.DefaultType)",
    "0:PySide2.QtWidgets.QGraphicsLayoutItem.setSizePolicy(self,policy:PySide2.QtWidgets.QSizePolicy)",
    "PySide2.QtWidgets.QGraphicsLayoutItem.sizeHint(self,which:PySide2.QtCore.Qt.SizeHint,constraint:PySide2.QtCore.QSizeF=QSizeF())->PySide2.QtCore.QSizeF",
    "PySide2.QtWidgets.QGraphicsLayoutItem.sizePolicy(self)->PySide2.QtWidgets.QSizePolicy",
    "PySide2.QtWidgets.QGraphicsLayoutItem.updateGeometry(self)",
    nullptr}; // Sentinel

void init_QGraphicsLayoutItem(PyObject *module)
{
    _Sbk_QGraphicsLayoutItem_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGraphicsLayoutItem",
        "QGraphicsLayoutItem*",
        &Sbk_QGraphicsLayoutItem_spec,
        &Shiboken::callCppDestructor< ::QGraphicsLayoutItem >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGraphicsLayoutItem_Type);
    InitSignatureStrings(pyType, QGraphicsLayoutItem_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGraphicsLayoutItem_Type), Sbk_QGraphicsLayoutItem_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSLAYOUTITEM_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGraphicsLayoutItem_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGraphicsLayoutItem_TypeF(),
        QGraphicsLayoutItem_PythonToCpp_QGraphicsLayoutItem_PTR,
        is_QGraphicsLayoutItem_PythonToCpp_QGraphicsLayoutItem_PTR_Convertible,
        QGraphicsLayoutItem_PTR_CppToPython_QGraphicsLayoutItem);

    Shiboken::Conversions::registerConverterName(converter, "QGraphicsLayoutItem");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsLayoutItem*");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsLayoutItem&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGraphicsLayoutItem).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGraphicsLayoutItemWrapper).name());


}
