/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qgraphicsitemanimation_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QGraphicsItemAnimationWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QGraphicsItemAnimationWrapper::QGraphicsItemAnimationWrapper(::QObject * parent) : QGraphicsItemAnimation(parent)
{
    resetPyMethodCache();
    // ... middle
}

void QGraphicsItemAnimationWrapper::afterAnimationStep(qreal step)
{
    if (m_PyMethodCache[0]) {
        return this->::QGraphicsItemAnimation::afterAnimationStep(step);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "afterAnimationStep";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QGraphicsItemAnimation::afterAnimationStep(step);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(d)",
    step
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGraphicsItemAnimationWrapper::beforeAnimationStep(qreal step)
{
    if (m_PyMethodCache[1]) {
        return this->::QGraphicsItemAnimation::beforeAnimationStep(step);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "beforeAnimationStep";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QGraphicsItemAnimation::beforeAnimationStep(step);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(d)",
    step
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGraphicsItemAnimationWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsItemAnimationWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QGraphicsItemAnimationWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[4]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QGraphicsItemAnimationWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QGraphicsItemAnimationWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[6])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsItemAnimation.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QGraphicsItemAnimationWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[7])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QGraphicsItemAnimation.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

void QGraphicsItemAnimationWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QGraphicsItemAnimationWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QGraphicsItemAnimation::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QGraphicsItemAnimationWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QGraphicsItemAnimation::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QGraphicsItemAnimationWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QGraphicsItemAnimationWrapper *>(this));
        return QGraphicsItemAnimation::qt_metacast(_clname);
}

QGraphicsItemAnimationWrapper::~QGraphicsItemAnimationWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QGraphicsItemAnimation_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QGraphicsItemAnimation >()))
        return -1;

    ::QGraphicsItemAnimationWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|O:QGraphicsItemAnimation", &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::QGraphicsItemAnimation(QObject*)
    if (numArgs == 0) {
        overloadId = 0; // QGraphicsItemAnimation(QObject*)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))) {
        overloadId = 0; // QGraphicsItemAnimation(QObject*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimation_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QGraphicsItemAnimation_Init_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0]))))
                        goto Sbk_QGraphicsItemAnimation_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return -1;
        ::QObject *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);

        if (!PyErr_Occurred()) {
            // QGraphicsItemAnimation(QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QGraphicsItemAnimationWrapper(cppArg0);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QGraphicsItemAnimationWrapper(cppArg0);
            }

            Shiboken::Object::setParent(pyArgs[0], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QGraphicsItemAnimation >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QGraphicsItemAnimation_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QGraphicsItemAnimation_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QGraphicsItemAnimation_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_afterAnimationStep(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.afterAnimationStep";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::afterAnimationStep(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // afterAnimationStep(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_afterAnimationStep_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // afterAnimationStep(qreal)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsItemAnimation::afterAnimationStep(cppArg0)
                : cppSelf->afterAnimationStep(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsItemAnimationFunc_afterAnimationStep_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_beforeAnimationStep(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.beforeAnimationStep";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::beforeAnimationStep(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // beforeAnimationStep(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_beforeAnimationStep_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // beforeAnimationStep(qreal)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QGraphicsItemAnimation::beforeAnimationStep(cppArg0)
                : cppSelf->beforeAnimationStep(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsItemAnimationFunc_beforeAnimationStep_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_clear(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.clear";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // clear()
            cppSelf->clear();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_horizontalScaleAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.horizontalScaleAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::horizontalScaleAt(qreal)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // horizontalScaleAt(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_horizontalScaleAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // horizontalScaleAt(qreal)const
            qreal cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->horizontalScaleAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsItemAnimationFunc_horizontalScaleAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_horizontalShearAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.horizontalShearAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::horizontalShearAt(qreal)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // horizontalShearAt(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_horizontalShearAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // horizontalShearAt(qreal)const
            qreal cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->horizontalShearAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsItemAnimationFunc_horizontalShearAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_item(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.item";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // item()const
            QGraphicsItem * cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->item();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_matrixAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.matrixAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::matrixAt(qreal)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // matrixAt(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_matrixAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // matrixAt(qreal)const
            QMatrix cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->matrixAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMATRIX_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsItemAnimationFunc_matrixAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_posAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.posAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::posAt(qreal)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // posAt(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_posAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // posAt(qreal)const
            QPointF cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->posAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsItemAnimationFunc_posAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_posList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.posList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // posList()const
            QList<QPair< qreal,QPointF > > cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->posList();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPAIR_QREAL_QPOINTF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_reset(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.reset";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // reset()
            cppSelf->reset();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_rotationAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.rotationAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::rotationAt(qreal)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // rotationAt(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_rotationAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // rotationAt(qreal)const
            qreal cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->rotationAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsItemAnimationFunc_rotationAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_rotationList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.rotationList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // rotationList()const
            QList<QPair< qreal,qreal > > cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->rotationList();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPAIR_QREAL_QREAL_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_scaleList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.scaleList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // scaleList()const
            QList<QPair< qreal,QPointF > > cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->scaleList();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPAIR_QREAL_QPOINTF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_setItem(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.setItem";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::setItem(QGraphicsItem*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEM_IDX]), (pyArg)))) {
        overloadId = 0; // setItem(QGraphicsItem*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_setItem_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QGraphicsItem *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setItem(QGraphicsItem*)
            cppSelf->setItem(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsItemAnimationFunc_setItem_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_setPosAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.setPosAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setPosAt", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::setPosAt(qreal,QPointF)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), (pyArgs[1])))) {
        overloadId = 0; // setPosAt(qreal,QPointF)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_setPosAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        if (!Shiboken::Object::isValid(pyArgs[1]))
            return {};
        ::QPointF cppArg1_local;
        ::QPointF *cppArg1 = &cppArg1_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINTF_IDX]), pythonToCpp[1]))
            pythonToCpp[1](pyArgs[1], &cppArg1_local);
        else
            pythonToCpp[1](pyArgs[1], &cppArg1);


        if (!PyErr_Occurred()) {
            // setPosAt(qreal,QPointF)
            cppSelf->setPosAt(cppArg0, *cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsItemAnimationFunc_setPosAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_setRotationAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.setRotationAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setRotationAt", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::setRotationAt(qreal,qreal)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))) {
        overloadId = 0; // setRotationAt(qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_setRotationAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setRotationAt(qreal,qreal)
            cppSelf->setRotationAt(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsItemAnimationFunc_setRotationAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_setScaleAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.setScaleAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setScaleAt", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::setScaleAt(qreal,qreal,qreal)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        overloadId = 0; // setScaleAt(qreal,qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_setScaleAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setScaleAt(qreal,qreal,qreal)
            cppSelf->setScaleAt(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsItemAnimationFunc_setScaleAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_setShearAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.setShearAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setShearAt", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::setShearAt(qreal,qreal,qreal)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        overloadId = 0; // setShearAt(qreal,qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_setShearAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setShearAt(qreal,qreal,qreal)
            cppSelf->setShearAt(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsItemAnimationFunc_setShearAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_setStep(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.setStep";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::setStep(qreal)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // setStep(qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_setStep_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setStep(qreal)
            cppSelf->setStep(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsItemAnimationFunc_setStep_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_setTimeLine(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.setTimeLine";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::setTimeLine(QTimeLine*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX]), (pyArg)))) {
        overloadId = 0; // setTimeLine(QTimeLine*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_setTimeLine_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTimeLine *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setTimeLine(QTimeLine*)
            cppSelf->setTimeLine(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsItemAnimationFunc_setTimeLine_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_setTranslationAt(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.setTranslationAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setTranslationAt", 3, 3, &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return {};


    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::setTranslationAt(qreal,qreal,qreal)
    if (numArgs == 3
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[1])))
        && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArgs[2])))) {
        overloadId = 0; // setTranslationAt(qreal,qreal,qreal)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_setTranslationAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        qreal cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);
        qreal cppArg2;
        pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // setTranslationAt(qreal,qreal,qreal)
            cppSelf->setTranslationAt(cppArg0, cppArg1, cppArg2);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QGraphicsItemAnimationFunc_setTranslationAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_shearList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.shearList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // shearList()const
            QList<QPair< qreal,QPointF > > cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->shearList();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPAIR_QREAL_QPOINTF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_timeLine(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.timeLine";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // timeLine()const
            QTimeLine * cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->timeLine();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMELINE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_transformAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.transformAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::transformAt(qreal)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // transformAt(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_transformAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // transformAt(qreal)const
            QTransform cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->transformAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTRANSFORM_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsItemAnimationFunc_transformAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_translationList(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.translationList";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // translationList()const
            QList<QPair< qreal,QPointF > > cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->translationList();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QPAIR_QREAL_QPOINTF_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_verticalScaleAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.verticalScaleAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::verticalScaleAt(qreal)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // verticalScaleAt(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_verticalScaleAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // verticalScaleAt(qreal)const
            qreal cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->verticalScaleAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsItemAnimationFunc_verticalScaleAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_verticalShearAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.verticalShearAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::verticalShearAt(qreal)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // verticalShearAt(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_verticalShearAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // verticalShearAt(qreal)const
            qreal cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->verticalShearAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsItemAnimationFunc_verticalShearAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_xTranslationAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.xTranslationAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::xTranslationAt(qreal)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // xTranslationAt(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_xTranslationAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // xTranslationAt(qreal)const
            qreal cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->xTranslationAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsItemAnimationFunc_xTranslationAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QGraphicsItemAnimationFunc_yTranslationAt(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QGraphicsItemAnimation.yTranslationAt";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QGraphicsItemAnimation::yTranslationAt(qreal)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), (pyArg)))) {
        overloadId = 0; // yTranslationAt(qreal)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QGraphicsItemAnimationFunc_yTranslationAt_TypeError;

    // Call function/method
    {
        qreal cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // yTranslationAt(qreal)const
            qreal cppResult = const_cast<const ::QGraphicsItemAnimation *>(cppSelf)->yTranslationAt(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<qreal>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QGraphicsItemAnimationFunc_yTranslationAt_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}


static const char *Sbk_QGraphicsItemAnimation_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QGraphicsItemAnimation_methods[] = {
    {"afterAnimationStep", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_afterAnimationStep), METH_O},
    {"beforeAnimationStep", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_beforeAnimationStep), METH_O},
    {"clear", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_clear), METH_NOARGS},
    {"horizontalScaleAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_horizontalScaleAt), METH_O},
    {"horizontalShearAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_horizontalShearAt), METH_O},
    {"item", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_item), METH_NOARGS},
    {"matrixAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_matrixAt), METH_O},
    {"posAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_posAt), METH_O},
    {"posList", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_posList), METH_NOARGS},
    {"reset", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_reset), METH_NOARGS},
    {"rotationAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_rotationAt), METH_O},
    {"rotationList", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_rotationList), METH_NOARGS},
    {"scaleList", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_scaleList), METH_NOARGS},
    {"setItem", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_setItem), METH_O},
    {"setPosAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_setPosAt), METH_VARARGS},
    {"setRotationAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_setRotationAt), METH_VARARGS},
    {"setScaleAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_setScaleAt), METH_VARARGS},
    {"setShearAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_setShearAt), METH_VARARGS},
    {"setStep", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_setStep), METH_O},
    {"setTimeLine", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_setTimeLine), METH_O},
    {"setTranslationAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_setTranslationAt), METH_VARARGS},
    {"shearList", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_shearList), METH_NOARGS},
    {"timeLine", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_timeLine), METH_NOARGS},
    {"transformAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_transformAt), METH_O},
    {"translationList", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_translationList), METH_NOARGS},
    {"verticalScaleAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_verticalScaleAt), METH_O},
    {"verticalShearAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_verticalShearAt), METH_O},
    {"xTranslationAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_xTranslationAt), METH_O},
    {"yTranslationAt", reinterpret_cast<PyCFunction>(Sbk_QGraphicsItemAnimationFunc_yTranslationAt), METH_O},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QGraphicsItemAnimation_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QGraphicsItemAnimation *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QGraphicsItemAnimationWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QGraphicsItemAnimation_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QGraphicsItemAnimation_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QGraphicsItemAnimation_Type = nullptr;
static SbkObjectType *Sbk_QGraphicsItemAnimation_TypeF(void)
{
    return _Sbk_QGraphicsItemAnimation_Type;
}

static PyType_Slot Sbk_QGraphicsItemAnimation_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QGraphicsItemAnimation_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QGraphicsItemAnimation_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QGraphicsItemAnimation_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QGraphicsItemAnimation_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QGraphicsItemAnimation_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QGraphicsItemAnimation_spec = {
    "2:PySide2.QtWidgets.QGraphicsItemAnimation",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QGraphicsItemAnimation_slots
};

} //extern "C"

static void *Sbk_QGraphicsItemAnimation_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QGraphicsItemAnimation *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QGraphicsItemAnimation_PythonToCpp_QGraphicsItemAnimation_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QGraphicsItemAnimation_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QGraphicsItemAnimation_PythonToCpp_QGraphicsItemAnimation_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QGraphicsItemAnimation_TypeF())))
        return QGraphicsItemAnimation_PythonToCpp_QGraphicsItemAnimation_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QGraphicsItemAnimation_PTR_CppToPython_QGraphicsItemAnimation(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QGraphicsItemAnimation *>(const_cast<void *>(cppIn)), Sbk_QGraphicsItemAnimation_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QGraphicsItemAnimation_SignatureStrings[] = {
    "PySide2.QtWidgets.QGraphicsItemAnimation(self,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtWidgets.QGraphicsItemAnimation.afterAnimationStep(self,step:qreal)",
    "PySide2.QtWidgets.QGraphicsItemAnimation.beforeAnimationStep(self,step:qreal)",
    "PySide2.QtWidgets.QGraphicsItemAnimation.clear(self)",
    "PySide2.QtWidgets.QGraphicsItemAnimation.horizontalScaleAt(self,step:qreal)->qreal",
    "PySide2.QtWidgets.QGraphicsItemAnimation.horizontalShearAt(self,step:qreal)->qreal",
    "PySide2.QtWidgets.QGraphicsItemAnimation.item(self)->PySide2.QtWidgets.QGraphicsItem",
    "PySide2.QtWidgets.QGraphicsItemAnimation.matrixAt(self,step:qreal)->PySide2.QtGui.QMatrix",
    "PySide2.QtWidgets.QGraphicsItemAnimation.posAt(self,step:qreal)->PySide2.QtCore.QPointF",
    "PySide2.QtWidgets.QGraphicsItemAnimation.posList(self)->QList[QPair[qreal, PySide2.QtCore.QPointF]]",
    "PySide2.QtWidgets.QGraphicsItemAnimation.reset(self)",
    "PySide2.QtWidgets.QGraphicsItemAnimation.rotationAt(self,step:qreal)->qreal",
    "PySide2.QtWidgets.QGraphicsItemAnimation.rotationList(self)->QList[QPair[qreal, qreal]]",
    "PySide2.QtWidgets.QGraphicsItemAnimation.scaleList(self)->QList[QPair[qreal, PySide2.QtCore.QPointF]]",
    "PySide2.QtWidgets.QGraphicsItemAnimation.setItem(self,item:PySide2.QtWidgets.QGraphicsItem)",
    "PySide2.QtWidgets.QGraphicsItemAnimation.setPosAt(self,step:qreal,pos:PySide2.QtCore.QPointF)",
    "PySide2.QtWidgets.QGraphicsItemAnimation.setRotationAt(self,step:qreal,angle:qreal)",
    "PySide2.QtWidgets.QGraphicsItemAnimation.setScaleAt(self,step:qreal,sx:qreal,sy:qreal)",
    "PySide2.QtWidgets.QGraphicsItemAnimation.setShearAt(self,step:qreal,sh:qreal,sv:qreal)",
    "PySide2.QtWidgets.QGraphicsItemAnimation.setStep(self,x:qreal)",
    "PySide2.QtWidgets.QGraphicsItemAnimation.setTimeLine(self,timeLine:PySide2.QtCore.QTimeLine)",
    "PySide2.QtWidgets.QGraphicsItemAnimation.setTranslationAt(self,step:qreal,dx:qreal,dy:qreal)",
    "PySide2.QtWidgets.QGraphicsItemAnimation.shearList(self)->QList[QPair[qreal, PySide2.QtCore.QPointF]]",
    "PySide2.QtWidgets.QGraphicsItemAnimation.timeLine(self)->PySide2.QtCore.QTimeLine",
    "PySide2.QtWidgets.QGraphicsItemAnimation.transformAt(self,step:qreal)->PySide2.QtGui.QTransform",
    "PySide2.QtWidgets.QGraphicsItemAnimation.translationList(self)->QList[QPair[qreal, PySide2.QtCore.QPointF]]",
    "PySide2.QtWidgets.QGraphicsItemAnimation.verticalScaleAt(self,step:qreal)->qreal",
    "PySide2.QtWidgets.QGraphicsItemAnimation.verticalShearAt(self,step:qreal)->qreal",
    "PySide2.QtWidgets.QGraphicsItemAnimation.xTranslationAt(self,step:qreal)->qreal",
    "PySide2.QtWidgets.QGraphicsItemAnimation.yTranslationAt(self,step:qreal)->qreal",
    nullptr}; // Sentinel

void init_QGraphicsItemAnimation(PyObject *module)
{
    _Sbk_QGraphicsItemAnimation_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QGraphicsItemAnimation",
        "QGraphicsItemAnimation*",
        &Sbk_QGraphicsItemAnimation_spec,
        &Shiboken::callCppDestructor< ::QGraphicsItemAnimation >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QGraphicsItemAnimation_Type);
    InitSignatureStrings(pyType, QGraphicsItemAnimation_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QGraphicsItemAnimation_Type), Sbk_QGraphicsItemAnimation_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QGRAPHICSITEMANIMATION_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QGraphicsItemAnimation_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QGraphicsItemAnimation_TypeF(),
        QGraphicsItemAnimation_PythonToCpp_QGraphicsItemAnimation_PTR,
        is_QGraphicsItemAnimation_PythonToCpp_QGraphicsItemAnimation_PTR_Convertible,
        QGraphicsItemAnimation_PTR_CppToPython_QGraphicsItemAnimation);

    Shiboken::Conversions::registerConverterName(converter, "QGraphicsItemAnimation");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsItemAnimation*");
    Shiboken::Conversions::registerConverterName(converter, "QGraphicsItemAnimation&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGraphicsItemAnimation).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QGraphicsItemAnimationWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QGraphicsItemAnimation_TypeF(), &Sbk_QGraphicsItemAnimation_typeDiscovery);

    PySide::Signal::registerSignals(Sbk_QGraphicsItemAnimation_TypeF(), &::QGraphicsItemAnimation::staticMetaObject);
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QGraphicsItemAnimation_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QGraphicsItemAnimation_TypeF(), &::QGraphicsItemAnimation::staticMetaObject, sizeof(QGraphicsItemAnimationWrapper));
}
