/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QGRAPHICSELLIPSEITEMWRAPPER_H
#define SBK_QGRAPHICSELLIPSEITEMWRAPPER_H

#define protected public

#include <QtWidgets/qgraphicsitem.h>


// Extra includes
#include <QtWidgets/qgraphicsitem.h>
#include <qrect.h>
#include <QtGui/qpainterpath.h>
#include <qpoint.h>
#include <QtGui/qpainter.h>
#include <QtWidgets/qstyleoption.h>
#include <QtWidgets/qwidget.h>
#include <QtGui/qevent.h>
#include <QtWidgets/qgraphicssceneevent.h>
#include <qcoreevent.h>
#include <QtGui/qbrush.h>
#include <QtGui/qpen.h>
class QGraphicsEllipseItemWrapper : public QGraphicsEllipseItem
{
public:
    QGraphicsEllipseItemWrapper(::QGraphicsItem * parent = nullptr);
    QGraphicsEllipseItemWrapper(const ::QRectF & rect, ::QGraphicsItem * parent = nullptr);
    QGraphicsEllipseItemWrapper(qreal x, qreal y, qreal w, qreal h, ::QGraphicsItem * parent = nullptr);
    void advance(int phase) override;
    ::QRectF boundingRect() const override;
    bool collidesWithItem(const ::QGraphicsItem * other, ::Qt::ItemSelectionMode mode = Qt::IntersectsItemShape) const override;
    bool collidesWithPath(const ::QPainterPath & path, ::Qt::ItemSelectionMode mode = Qt::IntersectsItemShape) const override;
    bool contains(const ::QPointF & point) const override;
    void contextMenuEvent(::QGraphicsSceneContextMenuEvent * event) override;
    void dragEnterEvent(::QGraphicsSceneDragDropEvent * event) override;
    void dragLeaveEvent(::QGraphicsSceneDragDropEvent * event) override;
    void dragMoveEvent(::QGraphicsSceneDragDropEvent * event) override;
    void dropEvent(::QGraphicsSceneDragDropEvent * event) override;
    ::QVariant extension(const ::QVariant & variant) const override;
    void focusInEvent(::QFocusEvent * event) override;
    void focusOutEvent(::QFocusEvent * event) override;
    void hoverEnterEvent(::QGraphicsSceneHoverEvent * event) override;
    void hoverLeaveEvent(::QGraphicsSceneHoverEvent * event) override;
    void hoverMoveEvent(::QGraphicsSceneHoverEvent * event) override;
    void inputMethodEvent(::QInputMethodEvent * event) override;
    ::QVariant inputMethodQuery(::Qt::InputMethodQuery query) const override;
    bool isObscuredBy(const ::QGraphicsItem * item) const override;
    ::QVariant itemChange(::QGraphicsItem::GraphicsItemChange change, const ::QVariant & value) override;
    void keyPressEvent(::QKeyEvent * event) override;
    void keyReleaseEvent(::QKeyEvent * event) override;
    void mouseDoubleClickEvent(::QGraphicsSceneMouseEvent * event) override;
    void mouseMoveEvent(::QGraphicsSceneMouseEvent * event) override;
    void mousePressEvent(::QGraphicsSceneMouseEvent * event) override;
    void mouseReleaseEvent(::QGraphicsSceneMouseEvent * event) override;
    ::QPainterPath opaqueArea() const override;
    void paint(::QPainter * painter, const ::QStyleOptionGraphicsItem * option, ::QWidget * widget = nullptr) override;
    bool sceneEvent(::QEvent * event) override;
    bool sceneEventFilter(::QGraphicsItem * watched, ::QEvent * event) override;
    ::QPainterPath shape() const override;
    int type() const override;
    void wheelEvent(::QGraphicsSceneWheelEvent * event) override;
    ~QGraphicsEllipseItemWrapper();
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[33];
};

#endif // SBK_QGRAPHICSELLIPSEITEMWRAPPER_H

