/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QFORMLAYOUTWRAPPER_H
#define SBK_QFORMLAYOUTWRAPPER_H

#define protected public

#include <QtWidgets/qformlayout.h>


// Extra includes
#include <qobject.h>
#include <QtWidgets/qwidget.h>
#include <QtWidgets/qlayout.h>
#include <QtWidgets/qlayoutitem.h>
#include <qrect.h>
#include <qsize.h>
#include <qcoreevent.h>
#include <qobjectdefs.h>
#include <qmetaobject.h>
#include <qmargins.h>
namespace PySide { class DynamicQMetaObject; }

class QFormLayoutWrapper : public QFormLayout
{
public:
    QFormLayoutWrapper(::QWidget * parent = nullptr);
    void addItem(::QLayoutItem * item) override;
    void childEvent(::QChildEvent * e) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QFlags<QSizePolicy::ControlType> controlTypes() const override;
    int count() const override;
    void customEvent(::QEvent * event) override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    ::QFlags<Qt::Orientation> expandingDirections() const override;
    ::QRect geometry() const override;
    bool hasHeightForWidth() const override;
    int heightForWidth(int width) const override;
    int indexOf(::QWidget * arg__1) const override;
    void invalidate() override;
    bool isEmpty() const override;
    ::QLayoutItem * itemAt(int index) const override;
    ::QLayout * layout() override;
    ::QSize maximumSize() const override;
    const ::QMetaObject * metaObject() const override;
    int minimumHeightForWidth(int arg__1) const override;
    ::QSize minimumSize() const override;
    void setGeometry(const ::QRect & rect) override;
    ::QSize sizeHint() const override;
    ::QSpacerItem * spacerItem() override;
    ::QLayoutItem * takeAt(int index) override;
    void timerEvent(::QTimerEvent * event) override;
    ::QWidget * widget() override;
    ~QFormLayoutWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    // Inherited overloads, because the using keyword sux
    inline int indexOf(::QLayoutItem * arg__1) const { return QFormLayout::indexOf(arg__1); }
    inline ::QLayoutItem * itemAt(int row, ::QFormLayout::ItemRole role) const { return QFormLayout::itemAt(row, QFormLayout::ItemRole(role)); }
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[28];
};

#endif // SBK_QFORMLAYOUTWRAPPER_H

