/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <algorithm>
#include <set>
#include <iterator>

// module include
#include "pyside2_qtwidgets_python.h"

// main header
#include "qfiledialog_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QFileDialogWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QFileDialogWrapper::QFileDialogWrapper(::QWidget * parent, ::QFlags<Qt::WindowType> f) : QFileDialog(parent, f)
{
    resetPyMethodCache();
    // ... middle
}

QFileDialogWrapper::QFileDialogWrapper(::QWidget * parent, const ::QString & caption, const ::QString & directory, const ::QString & filter) : QFileDialog(parent, caption, directory, filter)
{
    resetPyMethodCache();
    // ... middle
}

void QFileDialogWrapper::accept()
{
    if (m_PyMethodCache[0]) {
        return this->::QFileDialog::accept();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "accept";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QFileDialog::accept();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QFileDialogWrapper::actionEvent(::QActionEvent * event)
{
    if (m_PyMethodCache[1]) {
        return this->::QWidget::actionEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "actionEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QWidget::actionEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QACTIONEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::changeEvent(::QEvent * e)
{
    if (m_PyMethodCache[2]) {
        return this->::QFileDialog::changeEvent(e);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "changeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QFileDialog::changeEvent(e);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), e)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::closeEvent(::QCloseEvent * arg__1)
{
    if (m_PyMethodCache[4]) {
        return this->::QDialog::closeEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "closeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QDialog::closeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCLOSEEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[5]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QFileDialogWrapper::contextMenuEvent(::QContextMenuEvent * arg__1)
{
    if (m_PyMethodCache[6]) {
        return this->::QDialog::contextMenuEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "contextMenuEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[6] = true;
        return this->::QDialog::contextMenuEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QCONTEXTMENUEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[7]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

int QFileDialogWrapper::devType() const
{
    if (m_PyMethodCache[8])
        return this->::QWidget::devType();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "devType";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QWidget::devType();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.devType", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileDialogWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[9]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[9] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QFileDialogWrapper::done(int result)
{
    if (m_PyMethodCache[10]) {
        return this->::QFileDialog::done(result);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "done";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[10] = true;
        return this->::QFileDialog::done(result);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    result
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QFileDialogWrapper::dragEnterEvent(::QDragEnterEvent * event)
{
    if (m_PyMethodCache[11]) {
        return this->::QWidget::dragEnterEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragEnterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[11] = true;
        return this->::QWidget::dragEnterEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGENTEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::dragLeaveEvent(::QDragLeaveEvent * event)
{
    if (m_PyMethodCache[12]) {
        return this->::QWidget::dragLeaveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragLeaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[12] = true;
        return this->::QWidget::dragLeaveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGLEAVEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::dragMoveEvent(::QDragMoveEvent * event)
{
    if (m_PyMethodCache[13]) {
        return this->::QWidget::dragMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dragMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[13] = true;
        return this->::QWidget::dragMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDRAGMOVEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::dropEvent(::QDropEvent * event)
{
    if (m_PyMethodCache[14]) {
        return this->::QWidget::dropEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "dropEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[14] = true;
        return this->::QWidget::dropEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QDROPEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::enterEvent(::QEvent * event)
{
    if (m_PyMethodCache[15]) {
        return this->::QWidget::enterEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "enterEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[15] = true;
        return this->::QWidget::enterEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QFileDialogWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[16])
        return this->::QWidget::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[16] = true;
        return this->::QWidget::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QFileDialogWrapper::eventFilter(::QObject * arg__1, ::QEvent * arg__2)
{
    if (m_PyMethodCache[17])
        return this->::QDialog::eventFilter(arg__1, arg__2);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[17] = true;
        return this->::QDialog::eventFilter(arg__1, arg__2);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), arg__1),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), arg__2)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

int QFileDialogWrapper::exec()
{
    if (m_PyMethodCache[18])
        return this->::QDialog::exec();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "exec_";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[18] = true;
        return this->::QDialog::exec();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.exec_", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileDialogWrapper::focusInEvent(::QFocusEvent * event)
{
    if (m_PyMethodCache[19]) {
        return this->::QWidget::focusInEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusInEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[19] = true;
        return this->::QWidget::focusInEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QFileDialogWrapper::focusNextPrevChild(bool next)
{
    if (m_PyMethodCache[20])
        return this->::QWidget::focusNextPrevChild(next);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusNextPrevChild";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[20] = true;
        return this->::QWidget::focusNextPrevChild(next);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &next)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.focusNextPrevChild", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileDialogWrapper::focusOutEvent(::QFocusEvent * event)
{
    if (m_PyMethodCache[21]) {
        return this->::QWidget::focusOutEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "focusOutEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[21] = true;
        return this->::QWidget::focusOutEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QFOCUSEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QFileDialogWrapper::hasHeightForWidth() const
{
    if (m_PyMethodCache[22])
        return this->::QWidget::hasHeightForWidth();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hasHeightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[22] = true;
        return this->::QWidget::hasHeightForWidth();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.hasHeightForWidth", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

int QFileDialogWrapper::heightForWidth(int arg__1) const
{
    if (m_PyMethodCache[23])
        return this->::QWidget::heightForWidth(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "heightForWidth";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[23] = true;
        return this->::QWidget::heightForWidth(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(i)",
    arg__1
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.heightForWidth", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileDialogWrapper::hideEvent(::QHideEvent * event)
{
    if (m_PyMethodCache[24]) {
        return this->::QWidget::hideEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "hideEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[24] = true;
        return this->::QWidget::hideEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QHIDEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::initPainter(::QPainter * painter) const
{
    if (m_PyMethodCache[25]) {
        return this->::QWidget::initPainter(painter);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "initPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[25] = true;
        return this->::QWidget::initPainter(painter);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), painter)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QFileDialogWrapper::inputMethodEvent(::QInputMethodEvent * event)
{
    if (m_PyMethodCache[26]) {
        return this->::QWidget::inputMethodEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[26] = true;
        return this->::QWidget::inputMethodEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QINPUTMETHODEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QVariant QFileDialogWrapper::inputMethodQuery(::Qt::InputMethodQuery arg__1) const
{
    if (m_PyMethodCache[27])
        return this->::QWidget::inputMethodQuery(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return ::QVariant();
    static PyObject *nameCache[2] = {};
    static const char *funcName = "inputMethodQuery";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[27] = true;
        return this->::QWidget::inputMethodQuery(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QT_INPUTMETHODQUERY_IDX])->converter, &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return ::QVariant();
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QVARIANT_IDX], pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.inputMethodQuery", "QVariant", Py_TYPE(pyResult)->tp_name);
        return ::QVariant();
    }
    ::QVariant cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileDialogWrapper::keyPressEvent(::QKeyEvent * arg__1)
{
    if (m_PyMethodCache[28]) {
        return this->::QDialog::keyPressEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyPressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[28] = true;
        return this->::QDialog::keyPressEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::keyReleaseEvent(::QKeyEvent * event)
{
    if (m_PyMethodCache[29]) {
        return this->::QWidget::keyReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "keyReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[29] = true;
        return this->::QWidget::keyReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QKEYEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::leaveEvent(::QEvent * event)
{
    if (m_PyMethodCache[30]) {
        return this->::QWidget::leaveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "leaveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[30] = true;
        return this->::QWidget::leaveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

int QFileDialogWrapper::metric(::QPaintDevice::PaintDeviceMetric arg__1) const
{
    if (m_PyMethodCache[32])
        return this->::QWidget::metric(arg__1);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return 0;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "metric";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[32] = true;
        return this->::QWidget::metric(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_PAINTDEVICEMETRIC_IDX])->converter, &arg__1)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return 0;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.metric", "int", Py_TYPE(pyResult)->tp_name);
        return 0;
    }
    int cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

::QSize QFileDialogWrapper::minimumSizeHint() const
{
    if (m_PyMethodCache[33])
        return this->::QDialog::minimumSizeHint();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "minimumSizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[33] = true;
        return this->::QDialog::minimumSizeHint();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.minimumSizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileDialogWrapper::mouseDoubleClickEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[34]) {
        return this->::QWidget::mouseDoubleClickEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseDoubleClickEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[34] = true;
        return this->::QWidget::mouseDoubleClickEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::mouseMoveEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[35]) {
        return this->::QWidget::mouseMoveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseMoveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[35] = true;
        return this->::QWidget::mouseMoveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::mousePressEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[36]) {
        return this->::QWidget::mousePressEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mousePressEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[36] = true;
        return this->::QWidget::mousePressEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::mouseReleaseEvent(::QMouseEvent * event)
{
    if (m_PyMethodCache[37]) {
        return this->::QWidget::mouseReleaseEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "mouseReleaseEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[37] = true;
        return this->::QWidget::mouseReleaseEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOUSEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::moveEvent(::QMoveEvent * event)
{
    if (m_PyMethodCache[38]) {
        return this->::QWidget::moveEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "moveEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[38] = true;
        return this->::QWidget::moveEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QMOVEEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

bool QFileDialogWrapper::nativeEvent(const ::QByteArray & eventType, void * message, long * result)
{
    if (m_PyMethodCache[39]) {
        return this->::QWidget::nativeEvent(eventType, message, result);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "nativeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[39] = true;
        return this->::QWidget::nativeEvent(eventType, message, result);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &eventType),
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<void *>(), message)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Begin code injection
    // TEMPLATE - return_native_eventfilter_conversion - START
    bool cppResult = false;
    if (PySequence_Check(pyResult) && (PySequence_Size(pyResult) == 2)) {
        Shiboken::AutoDecRef pyItem(PySequence_GetItem(pyResult, 0));
        Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyItem, &(cppResult));
        if (result) {
            Shiboken::AutoDecRef pyResultItem(PySequence_GetItem(pyResult, 1));
            Shiboken::Conversions::pythonToCppCopy(Shiboken::Conversions::PrimitiveTypeConverter<long>(), pyResultItem, (result));
        }
    }
    // TEMPLATE - return_native_eventfilter_conversion - END

    // End of code injection


    return cppResult;
}

::QPaintEngine * QFileDialogWrapper::paintEngine() const
{
    if (m_PyMethodCache[40])
        return this->::QWidget::paintEngine();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEngine";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[40] = true;
        return this->::QWidget::paintEngine();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTENGINE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.paintEngine", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintEngine >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintEngine *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileDialogWrapper::paintEvent(::QPaintEvent * event)
{
    if (m_PyMethodCache[41]) {
        return this->::QWidget::paintEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "paintEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[41] = true;
        return this->::QWidget::paintEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QPaintDevice * QFileDialogWrapper::redirected(::QPoint * offset) const
{
    if (m_PyMethodCache[42])
        return this->::QWidget::redirected(offset);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "redirected";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[42] = true;
        return this->::QWidget::redirected(offset);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QPOINT_IDX]), offset)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.redirected", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPaintDevice >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPaintDevice *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileDialogWrapper::reject()
{
    if (m_PyMethodCache[43]) {
        return this->::QDialog::reject();
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "reject";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[43] = true;
        return this->::QDialog::reject();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QFileDialogWrapper::resizeEvent(::QResizeEvent * arg__1)
{
    if (m_PyMethodCache[44]) {
        return this->::QDialog::resizeEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "resizeEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[44] = true;
        return this->::QDialog::resizeEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QRESIZEEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::setVisible(bool visible)
{
    if (m_PyMethodCache[45]) {
        return this->::QFileDialog::setVisible(visible);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "setVisible";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[45] = true;
        return this->::QFileDialog::setVisible(visible);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &visible)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

::QPainter * QFileDialogWrapper::sharedPainter() const
{
    if (m_PyMethodCache[46])
        return this->::QWidget::sharedPainter();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sharedPainter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[46] = true;
        return this->::QWidget::sharedPainter();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTER_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.sharedPainter", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QPainter >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QPainter *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileDialogWrapper::showEvent(::QShowEvent * arg__1)
{
    if (m_PyMethodCache[47]) {
        return this->::QDialog::showEvent(arg__1);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "showEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[47] = true;
        return this->::QDialog::showEvent(arg__1);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QSHOWEVENT_IDX]), arg__1)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

::QSize QFileDialogWrapper::sizeHint() const
{
    if (m_PyMethodCache[48])
        return this->::QDialog::sizeHint();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return {};
    static PyObject *nameCache[2] = {};
    static const char *funcName = "sizeHint";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[48] = true;
        return this->::QDialog::sizeHint();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return {};
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppValueConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QSIZE_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QFileDialog.sizeHint", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QSize >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return {};
    }
    ::QSize cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QFileDialogWrapper::tabletEvent(::QTabletEvent * event)
{
    if (m_PyMethodCache[49]) {
        return this->::QWidget::tabletEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "tabletEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[49] = true;
        return this->::QWidget::tabletEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QTABLETEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[50]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[50] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QFileDialogWrapper::wheelEvent(::QWheelEvent * event)
{
    if (m_PyMethodCache[51]) {
        return this->::QWidget::wheelEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "wheelEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[51] = true;
        return this->::QWidget::wheelEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QWHEELEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QFileDialogWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QFileDialog::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QFileDialogWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QFileDialog::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QFileDialogWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QFileDialogWrapper *>(this));
        return QFileDialog::qt_metacast(_clname);
}

QFileDialogWrapper::~QFileDialogWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QFileDialog_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QFileDialog >()))
        return -1;

    ::QFileDialogWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths


    if (!PyArg_ParseTuple(args, "|OOOO:QFileDialog", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return -1;


    // Overloaded function decisor
    // 0: QFileDialog::QFileDialog(QWidget*,QFlags<Qt::WindowType>)
    // 1: QFileDialog::QFileDialog(QWidget*,QString,QString,QString)
    if (numArgs == 0) {
        overloadId = 1; // QFileDialog(QWidget*,QString,QString,QString)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 1; // QFileDialog(QWidget*,QString,QString,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 1; // QFileDialog(QWidget*,QString,QString,QString)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 1; // QFileDialog(QWidget*,QString,QString,QString)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    overloadId = 1; // QFileDialog(QWidget*,QString,QString,QString)
                }
            }
        } else if (numArgs == 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QT_WINDOWTYPE_IDX])->converter, (pyArgs[1])))) {
            overloadId = 0; // QFileDialog(QWidget*,QFlags<Qt::WindowType>)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialog_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QFileDialog(QWidget * parent, QFlags<Qt::WindowType> f)
        {
            if (kwds) {
                errInfo = kwds;
                Py_INCREF(errInfo);
                goto Sbk_QFileDialog_Init_TypeError;
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QFlags<Qt::WindowType> cppArg1 = QFlags<Qt::WindowType>(0);
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // QFileDialog(QWidget*,QFlags<Qt::WindowType>)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QFileDialogWrapper(cppArg0, cppArg1);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QFileDialogWrapper(cppArg0, cppArg1);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
        case 1: // QFileDialog(QWidget * parent, const QString & caption, const QString & directory, const QString & filter)
        {
            if (kwds) {
                PyObject *value{};
                Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
                static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
                if (PyDict_Contains(kwds, key_parent)) {
                    value = PyDict_GetItem(kwds, key_parent);
                    if (value && pyArgs[0]) {
                        errInfo = key_parent;
                        Py_INCREF(errInfo);
                        goto Sbk_QFileDialog_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[0] = value;
                        if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0]))))
                            goto Sbk_QFileDialog_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_parent);
                }
                static PyObject *const key_caption = Shiboken::String::createStaticString("caption");
                if (PyDict_Contains(kwds, key_caption)) {
                    value = PyDict_GetItem(kwds, key_caption);
                    if (value && pyArgs[1]) {
                        errInfo = key_caption;
                        Py_INCREF(errInfo);
                        goto Sbk_QFileDialog_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[1] = value;
                        if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                            goto Sbk_QFileDialog_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_caption);
                }
                static PyObject *const key_directory = Shiboken::String::createStaticString("directory");
                if (PyDict_Contains(kwds, key_directory)) {
                    value = PyDict_GetItem(kwds, key_directory);
                    if (value && pyArgs[2]) {
                        errInfo = key_directory;
                        Py_INCREF(errInfo);
                        goto Sbk_QFileDialog_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[2] = value;
                        if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                            goto Sbk_QFileDialog_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_directory);
                }
                static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
                if (PyDict_Contains(kwds, key_filter)) {
                    value = PyDict_GetItem(kwds, key_filter);
                    if (value && pyArgs[3]) {
                        errInfo = key_filter;
                        Py_INCREF(errInfo);
                        goto Sbk_QFileDialog_Init_TypeError;
                    }
                    if (value) {
                        pyArgs[3] = value;
                        if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                            goto Sbk_QFileDialog_Init_TypeError;
                    }
                    PyDict_DelItem(kwds_dup, key_filter);
                }
                if (PyDict_Size(kwds_dup) > 0) {
                    errInfo = kwds_dup.release();
                    // fall through to handle extra keyword signals and properties
                }
            }
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWidget *cppArg0 = nullptr;
            if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
            ::QString cppArg1 = QString();
            if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
            ::QString cppArg2 = QString();
            if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
            ::QString cppArg3 = QString();
            if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

            if (!PyErr_Occurred()) {
                // QFileDialog(QWidget*,QString,QString,QString)
                void *addr = PySide::nextQObjectMemoryAddr();
                if (addr) {
                    cptr = new (addr) ::QFileDialogWrapper(cppArg0, cppArg1, cppArg2, cppArg3);
                    PySide::setNextQObjectMemoryAddr(0);
                } else {
                    cptr = new ::QFileDialogWrapper(cppArg0, cppArg1, cppArg2, cppArg3);
                }

                Shiboken::Object::setParent(pyArgs[0], self);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QFileDialog >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QFileDialog_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QFileDialog_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QFileDialog_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QFileDialogFunc_accept(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.accept";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // accept()
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QFileDialog::accept()
                : cppSelf->accept();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QFileDialogFunc_acceptMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.acceptMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // acceptMode()const
            QFileDialog::AcceptMode cppResult = const_cast<const ::QFileDialog *>(cppSelf)->acceptMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_ACCEPTMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_changeEvent(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.changeEvent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::changeEvent(QEvent*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), (pyArg)))) {
        overloadId = 0; // changeEvent(QEvent*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_changeEvent_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QEvent *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // changeEvent(QEvent*)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QFileDialog::changeEvent(cppArg0)
                : cppSelf->changeEvent(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_changeEvent_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_confirmOverwrite(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.confirmOverwrite";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // confirmOverwrite()const
            bool cppResult = const_cast<const ::QFileDialog *>(cppSelf)->confirmOverwrite();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_defaultSuffix(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.defaultSuffix";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultSuffix()const
            QString cppResult = const_cast<const ::QFileDialog *>(cppSelf)->defaultSuffix();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_directory(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.directory";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // directory()const
            QDir cppResult = const_cast<const ::QFileDialog *>(cppSelf)->directory();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_directoryUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.directoryUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // directoryUrl()const
            QUrl cppResult = const_cast<const ::QFileDialog *>(cppSelf)->directoryUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_done(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.done";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QDialog::done(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // done(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_done_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // done(int)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QFileDialog::done(cppArg0)
                : cppSelf->done(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_done_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_fileMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.fileMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // fileMode()const
            QFileDialog::FileMode cppResult = const_cast<const ::QFileDialog *>(cppSelf)->fileMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_FILEMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_filter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.filter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // filter()const
            QFlags<QDir::Filter> cppResult = const_cast<const ::QFileDialog *>(cppSelf)->filter();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_getExistingDirectory(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.getExistingDirectory";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 4) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFileDialogFunc_getExistingDirectory_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOO:getExistingDirectory", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3])))
        return {};


    // Overloaded function decisor
    // 0: static QFileDialog::getExistingDirectory(QWidget*,QString,QString,QFlags<QFileDialog::Option>)
    if (numArgs == 0) {
        overloadId = 0; // getExistingDirectory(QWidget*,QString,QString,QFlags<QFileDialog::Option>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getExistingDirectory(QWidget*,QString,QString,QFlags<QFileDialog::Option>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getExistingDirectory(QWidget*,QString,QString,QFlags<QFileDialog::Option>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getExistingDirectory(QWidget*,QString,QString,QFlags<QFileDialog::Option>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[3])))) {
                    overloadId = 0; // getExistingDirectory(QWidget*,QString,QString,QFlags<QFileDialog::Option>)
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_getExistingDirectory_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getExistingDirectory_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0]))))
                        goto Sbk_QFileDialogFunc_getExistingDirectory_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_caption = Shiboken::String::createStaticString("caption");
            if (PyDict_Contains(kwds, key_caption)) {
                value = PyDict_GetItem(kwds, key_caption);
                if (value && pyArgs[1]) {
                    errInfo = key_caption;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getExistingDirectory_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFileDialogFunc_getExistingDirectory_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caption);
            }
            static PyObject *const key_dir = Shiboken::String::createStaticString("dir");
            if (PyDict_Contains(kwds, key_dir)) {
                value = PyDict_GetItem(kwds, key_dir);
                if (value && pyArgs[2]) {
                    errInfo = key_dir;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getExistingDirectory_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                        goto Sbk_QFileDialogFunc_getExistingDirectory_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_dir);
            }
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[3]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getExistingDirectory_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[3]))))
                        goto Sbk_QFileDialogFunc_getExistingDirectory_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFileDialogFunc_getExistingDirectory_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QFlags<QFileDialog::Option> cppArg3 = QFileDialog::ShowDirsOnly;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);

        if (!PyErr_Occurred()) {
            // getExistingDirectory(QWidget*,QString,QString,QFlags<QFileDialog::Option>)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            QString cppResult = ::QFileDialog::getExistingDirectory(cppArg0, cppArg1, cppArg2, cppArg3);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDialogFunc_getExistingDirectory_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_getExistingDirectoryUrl(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.getExistingDirectoryUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 5) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOO:getExistingDirectoryUrl", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4])))
        return {};


    // Overloaded function decisor
    // 0: static QFileDialog::getExistingDirectoryUrl(QWidget*,QString,QUrl,QFlags<QFileDialog::Option>,QStringList)
    if (numArgs == 0) {
        overloadId = 0; // getExistingDirectoryUrl(QWidget*,QString,QUrl,QFlags<QFileDialog::Option>,QStringList)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getExistingDirectoryUrl(QWidget*,QString,QUrl,QFlags<QFileDialog::Option>,QStringList)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getExistingDirectoryUrl(QWidget*,QString,QUrl,QFlags<QFileDialog::Option>,QStringList)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getExistingDirectoryUrl(QWidget*,QString,QUrl,QFlags<QFileDialog::Option>,QStringList)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getExistingDirectoryUrl(QWidget*,QString,QUrl,QFlags<QFileDialog::Option>,QStringList)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[4])))) {
                        overloadId = 0; // getExistingDirectoryUrl(QWidget*,QString,QUrl,QFlags<QFileDialog::Option>,QStringList)
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0]))))
                        goto Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_caption = Shiboken::String::createStaticString("caption");
            if (PyDict_Contains(kwds, key_caption)) {
                value = PyDict_GetItem(kwds, key_caption);
                if (value && pyArgs[1]) {
                    errInfo = key_caption;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caption);
            }
            static PyObject *const key_dir = Shiboken::String::createStaticString("dir");
            if (PyDict_Contains(kwds, key_dir)) {
                value = PyDict_GetItem(kwds, key_dir);
                if (value && pyArgs[2]) {
                    errInfo = key_dir;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[2]))))
                        goto Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_dir);
            }
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[3]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[3]))))
                        goto Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            static PyObject *const key_supportedSchemes = Shiboken::String::createStaticString("supportedSchemes");
            if (PyDict_Contains(kwds, key_supportedSchemes)) {
                value = PyDict_GetItem(kwds, key_supportedSchemes);
                if (value && pyArgs[4]) {
                    errInfo = key_supportedSchemes;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[4]))))
                        goto Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_supportedSchemes);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QUrl cppArg2_local = QUrl();
        ::QUrl *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);
        }
        ::QFlags<QFileDialog::Option> cppArg3 = QFileDialog::ShowDirsOnly;
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QStringList cppArg4 = QStringList();
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);

        if (!PyErr_Occurred()) {
            // getExistingDirectoryUrl(QWidget*,QString,QUrl,QFlags<QFileDialog::Option>,QStringList)
            PyThreadState *_save = PyEval_SaveThread(); // Py_BEGIN_ALLOW_THREADS
            QUrl cppResult = ::QFileDialog::getExistingDirectoryUrl(cppArg0, cppArg1, *cppArg2, cppArg3, cppArg4);
            PyEval_RestoreThread(_save); // Py_END_ALLOW_THREADS
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDialogFunc_getExistingDirectoryUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_getOpenFileName(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.getOpenFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:getOpenFileName", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: static QFileDialog::getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
    if (numArgs == 0) {
        overloadId = 0; // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[5])))) {
                            overloadId = 0; // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0]))))
                        goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_caption = Shiboken::String::createStaticString("caption");
            if (PyDict_Contains(kwds, key_caption)) {
                value = PyDict_GetItem(kwds, key_caption);
                if (value && pyArgs[1]) {
                    errInfo = key_caption;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caption);
            }
            static PyObject *const key_dir = Shiboken::String::createStaticString("dir");
            if (PyDict_Contains(kwds, key_dir)) {
                value = PyDict_GetItem(kwds, key_dir);
                if (value && pyArgs[2]) {
                    errInfo = key_dir;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                        goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_dir);
            }
            static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
            if (PyDict_Contains(kwds, key_filter)) {
                value = PyDict_GetItem(kwds, key_filter);
                if (value && pyArgs[3]) {
                    errInfo = key_filter;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                        goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_filter);
            }
            static PyObject *const key_selectedFilter = Shiboken::String::createStaticString("selectedFilter");
            if (PyDict_Contains(kwds, key_selectedFilter)) {
                value = PyDict_GetItem(kwds, key_selectedFilter);
                if (value && pyArgs[4]) {
                    errInfo = key_selectedFilter;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4]))))
                        goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_selectedFilter);
            }
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[5]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
                }
                if (value) {
                    pyArgs[5] = value;
                    if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[5]))))
                        goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFileDialogFunc_getOpenFileName_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QFlags<QFileDialog::Option> cppArg5 = QFileDialog::Options();
        if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // getOpenFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qfiledialog-return)]
            ::QString retval_ = QFileDialog::getOpenFileName(cppArg0, cppArg1, cppArg2, cppArg3, &cppArg4, cppArg5);
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppArg4));
            // END of custom code block [file: ../glue/qtwidgets.cpp (qfiledialog-return)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDialogFunc_getOpenFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_getOpenFileNames(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.getOpenFileNames";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:getOpenFileNames", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: static QFileDialog::getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
    if (numArgs == 0) {
        overloadId = 0; // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[5])))) {
                            overloadId = 0; // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0]))))
                        goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_caption = Shiboken::String::createStaticString("caption");
            if (PyDict_Contains(kwds, key_caption)) {
                value = PyDict_GetItem(kwds, key_caption);
                if (value && pyArgs[1]) {
                    errInfo = key_caption;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caption);
            }
            static PyObject *const key_dir = Shiboken::String::createStaticString("dir");
            if (PyDict_Contains(kwds, key_dir)) {
                value = PyDict_GetItem(kwds, key_dir);
                if (value && pyArgs[2]) {
                    errInfo = key_dir;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                        goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_dir);
            }
            static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
            if (PyDict_Contains(kwds, key_filter)) {
                value = PyDict_GetItem(kwds, key_filter);
                if (value && pyArgs[3]) {
                    errInfo = key_filter;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                        goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_filter);
            }
            static PyObject *const key_selectedFilter = Shiboken::String::createStaticString("selectedFilter");
            if (PyDict_Contains(kwds, key_selectedFilter)) {
                value = PyDict_GetItem(kwds, key_selectedFilter);
                if (value && pyArgs[4]) {
                    errInfo = key_selectedFilter;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4]))))
                        goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_selectedFilter);
            }
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[5]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
                }
                if (value) {
                    pyArgs[5] = value;
                    if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[5]))))
                        goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFileDialogFunc_getOpenFileNames_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QFlags<QFileDialog::Option> cppArg5 = QFileDialog::Options();
        if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // getOpenFileNames(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qfiledialog-return)]
            ::QStringList retval_ = QFileDialog::getOpenFileNames(cppArg0, cppArg1, cppArg2, cppArg3, &cppArg4, cppArg5);
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppArg4));
            // END of custom code block [file: ../glue/qtwidgets.cpp (qfiledialog-return)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDialogFunc_getOpenFileNames_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_getOpenFileUrl(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.getOpenFileUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOO:getOpenFileUrl", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: static QFileDialog::getOpenFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
    if (numArgs == 0) {
        overloadId = 0; // getOpenFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getOpenFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getOpenFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getOpenFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getOpenFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // getOpenFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 0; // getOpenFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[6])))) {
                                overloadId = 0; // getOpenFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_caption = Shiboken::String::createStaticString("caption");
            if (PyDict_Contains(kwds, key_caption)) {
                value = PyDict_GetItem(kwds, key_caption);
                if (value && pyArgs[1]) {
                    errInfo = key_caption;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caption);
            }
            static PyObject *const key_dir = Shiboken::String::createStaticString("dir");
            if (PyDict_Contains(kwds, key_dir)) {
                value = PyDict_GetItem(kwds, key_dir);
                if (value && pyArgs[2]) {
                    errInfo = key_dir;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[2]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_dir);
            }
            static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
            if (PyDict_Contains(kwds, key_filter)) {
                value = PyDict_GetItem(kwds, key_filter);
                if (value && pyArgs[3]) {
                    errInfo = key_filter;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_filter);
            }
            static PyObject *const key_selectedFilter = Shiboken::String::createStaticString("selectedFilter");
            if (PyDict_Contains(kwds, key_selectedFilter)) {
                value = PyDict_GetItem(kwds, key_selectedFilter);
                if (value && pyArgs[4]) {
                    errInfo = key_selectedFilter;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_selectedFilter);
            }
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[5]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[5] = value;
                    if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[5]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            static PyObject *const key_supportedSchemes = Shiboken::String::createStaticString("supportedSchemes");
            if (PyDict_Contains(kwds, key_supportedSchemes)) {
                value = PyDict_GetItem(kwds, key_supportedSchemes);
                if (value && pyArgs[6]) {
                    errInfo = key_supportedSchemes;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[6] = value;
                    if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[6]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_supportedSchemes);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFileDialogFunc_getOpenFileUrl_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QUrl cppArg2_local = QUrl();
        ::QUrl *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);
        }
        ::QString cppArg3 = QString();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QFlags<QFileDialog::Option> cppArg5 = QFileDialog::Options();
        if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // getOpenFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qfiledialog-return)]
            ::QUrl retval_ = QFileDialog::getOpenFileUrl(cppArg0, cppArg1, *cppArg2, cppArg3, &cppArg4, cppArg5);
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppArg4));
            // END of custom code block [file: ../glue/qtwidgets.cpp (qfiledialog-return)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDialogFunc_getOpenFileUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_getOpenFileUrls(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.getOpenFileUrls";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOO:getOpenFileUrls", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: static QFileDialog::getOpenFileUrls(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
    if (numArgs == 0) {
        overloadId = 0; // getOpenFileUrls(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getOpenFileUrls(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getOpenFileUrls(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getOpenFileUrls(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getOpenFileUrls(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // getOpenFileUrls(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 0; // getOpenFileUrls(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[6])))) {
                                overloadId = 0; // getOpenFileUrls(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_caption = Shiboken::String::createStaticString("caption");
            if (PyDict_Contains(kwds, key_caption)) {
                value = PyDict_GetItem(kwds, key_caption);
                if (value && pyArgs[1]) {
                    errInfo = key_caption;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caption);
            }
            static PyObject *const key_dir = Shiboken::String::createStaticString("dir");
            if (PyDict_Contains(kwds, key_dir)) {
                value = PyDict_GetItem(kwds, key_dir);
                if (value && pyArgs[2]) {
                    errInfo = key_dir;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[2]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_dir);
            }
            static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
            if (PyDict_Contains(kwds, key_filter)) {
                value = PyDict_GetItem(kwds, key_filter);
                if (value && pyArgs[3]) {
                    errInfo = key_filter;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_filter);
            }
            static PyObject *const key_selectedFilter = Shiboken::String::createStaticString("selectedFilter");
            if (PyDict_Contains(kwds, key_selectedFilter)) {
                value = PyDict_GetItem(kwds, key_selectedFilter);
                if (value && pyArgs[4]) {
                    errInfo = key_selectedFilter;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_selectedFilter);
            }
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[5]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                if (value) {
                    pyArgs[5] = value;
                    if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[5]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            static PyObject *const key_supportedSchemes = Shiboken::String::createStaticString("supportedSchemes");
            if (PyDict_Contains(kwds, key_supportedSchemes)) {
                value = PyDict_GetItem(kwds, key_supportedSchemes);
                if (value && pyArgs[6]) {
                    errInfo = key_supportedSchemes;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                if (value) {
                    pyArgs[6] = value;
                    if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[6]))))
                        goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_supportedSchemes);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFileDialogFunc_getOpenFileUrls_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QUrl cppArg2_local = QUrl();
        ::QUrl *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);
        }
        ::QString cppArg3 = QString();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QFlags<QFileDialog::Option> cppArg5 = QFileDialog::Options();
        if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // getOpenFileUrls(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qfiledialog-return)]
            ::QList<QUrl > retval_ = QFileDialog::getOpenFileUrls(cppArg0, cppArg1, *cppArg2, cppArg3, &cppArg4, cppArg5);
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QURL_IDX], &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppArg4));
            // END of custom code block [file: ../glue/qtwidgets.cpp (qfiledialog-return)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDialogFunc_getOpenFileUrls_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_getSaveFileName(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.getSaveFileName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 6) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOO:getSaveFileName", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5])))
        return {};


    // Overloaded function decisor
    // 0: static QFileDialog::getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
    if (numArgs == 0) {
        overloadId = 0; // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[5])))) {
                            overloadId = 0; // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0]))))
                        goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_caption = Shiboken::String::createStaticString("caption");
            if (PyDict_Contains(kwds, key_caption)) {
                value = PyDict_GetItem(kwds, key_caption);
                if (value && pyArgs[1]) {
                    errInfo = key_caption;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caption);
            }
            static PyObject *const key_dir = Shiboken::String::createStaticString("dir");
            if (PyDict_Contains(kwds, key_dir)) {
                value = PyDict_GetItem(kwds, key_dir);
                if (value && pyArgs[2]) {
                    errInfo = key_dir;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[2]))))
                        goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_dir);
            }
            static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
            if (PyDict_Contains(kwds, key_filter)) {
                value = PyDict_GetItem(kwds, key_filter);
                if (value && pyArgs[3]) {
                    errInfo = key_filter;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                        goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_filter);
            }
            static PyObject *const key_selectedFilter = Shiboken::String::createStaticString("selectedFilter");
            if (PyDict_Contains(kwds, key_selectedFilter)) {
                value = PyDict_GetItem(kwds, key_selectedFilter);
                if (value && pyArgs[4]) {
                    errInfo = key_selectedFilter;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4]))))
                        goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_selectedFilter);
            }
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[5]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
                }
                if (value) {
                    pyArgs[5] = value;
                    if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[5]))))
                        goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFileDialogFunc_getSaveFileName_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        ::QString cppArg2 = QString();
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);
        ::QString cppArg3 = QString();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QFlags<QFileDialog::Option> cppArg5 = QFileDialog::Options();
        if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // getSaveFileName(QWidget*,QString,QString,QString,QString*,QFlags<QFileDialog::Option>)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qfiledialog-return)]
            ::QString retval_ = QFileDialog::getSaveFileName(cppArg0, cppArg1, cppArg2, cppArg3, &cppArg4, cppArg5);
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppArg4));
            // END of custom code block [file: ../glue/qtwidgets.cpp (qfiledialog-return)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDialogFunc_getSaveFileName_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_getSaveFileUrl(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.getSaveFileUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr, nullptr, nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0, 0, 0, 0, 0};

    // invalid argument lengths
    if (numArgs > 7) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOOOOOO:getSaveFileUrl", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2]), &(pyArgs[3]), &(pyArgs[4]), &(pyArgs[5]), &(pyArgs[6])))
        return {};


    // Overloaded function decisor
    // 0: static QFileDialog::getSaveFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
    if (numArgs == 0) {
        overloadId = 0; // getSaveFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // getSaveFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            if (numArgs == 2) {
                overloadId = 0; // getSaveFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
            } else if (numArgs >= 3
                && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[2])))) {
                if (numArgs == 3) {
                    overloadId = 0; // getSaveFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                } else if (numArgs >= 4
                    && (pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3])))) {
                    if (numArgs == 4) {
                        overloadId = 0; // getSaveFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                    } else if (numArgs >= 5
                        && (pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4])))) {
                        if (numArgs == 5) {
                            overloadId = 0; // getSaveFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                        } else if (numArgs >= 6
                            && (pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[5])))) {
                            if (numArgs == 6) {
                                overloadId = 0; // getSaveFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                            } else if (numArgs >= 7
                                && (pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[6])))) {
                                overloadId = 0; // getSaveFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
                            }
                        }
                    }
                }
            }
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[0]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]), (pyArgs[0]))))
                        goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            static PyObject *const key_caption = Shiboken::String::createStaticString("caption");
            if (PyDict_Contains(kwds, key_caption)) {
                value = PyDict_GetItem(kwds, key_caption);
                if (value && pyArgs[1]) {
                    errInfo = key_caption;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_caption);
            }
            static PyObject *const key_dir = Shiboken::String::createStaticString("dir");
            if (PyDict_Contains(kwds, key_dir)) {
                value = PyDict_GetItem(kwds, key_dir);
                if (value && pyArgs[2]) {
                    errInfo = key_dir;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArgs[2]))))
                        goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_dir);
            }
            static PyObject *const key_filter = Shiboken::String::createStaticString("filter");
            if (PyDict_Contains(kwds, key_filter)) {
                value = PyDict_GetItem(kwds, key_filter);
                if (value && pyArgs[3]) {
                    errInfo = key_filter;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[3] = value;
                    if (!(pythonToCpp[3] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[3]))))
                        goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_filter);
            }
            static PyObject *const key_selectedFilter = Shiboken::String::createStaticString("selectedFilter");
            if (PyDict_Contains(kwds, key_selectedFilter)) {
                value = PyDict_GetItem(kwds, key_selectedFilter);
                if (value && pyArgs[4]) {
                    errInfo = key_selectedFilter;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[4] = value;
                    if (!(pythonToCpp[4] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[4]))))
                        goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_selectedFilter);
            }
            static PyObject *const key_options = Shiboken::String::createStaticString("options");
            if (PyDict_Contains(kwds, key_options)) {
                value = PyDict_GetItem(kwds, key_options);
                if (value && pyArgs[5]) {
                    errInfo = key_options;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[5] = value;
                    if (!(pythonToCpp[5] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[5]))))
                        goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_options);
            }
            static PyObject *const key_supportedSchemes = Shiboken::String::createStaticString("supportedSchemes");
            if (PyDict_Contains(kwds, key_supportedSchemes)) {
                value = PyDict_GetItem(kwds, key_supportedSchemes);
                if (value && pyArgs[6]) {
                    errInfo = key_supportedSchemes;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                if (value) {
                    pyArgs[6] = value;
                    if (!(pythonToCpp[6] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArgs[6]))))
                        goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_supportedSchemes);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFileDialogFunc_getSaveFileUrl_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QWidget *cppArg0 = nullptr;
        if (pythonToCpp[0]) pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return {};
        ::QUrl cppArg2_local = QUrl();
        ::QUrl *cppArg2 = &cppArg2_local;
        if (pythonToCpp[2]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp[2]))
            pythonToCpp[2](pyArgs[2], &cppArg2_local);
        else
            pythonToCpp[2](pyArgs[2], &cppArg2);
        }
        ::QString cppArg3 = QString();
        if (pythonToCpp[3]) pythonToCpp[3](pyArgs[3], &cppArg3);
        ::QString cppArg4 = QString();
        if (pythonToCpp[4]) pythonToCpp[4](pyArgs[4], &cppArg4);
        ::QFlags<QFileDialog::Option> cppArg5 = QFileDialog::Options();
        if (pythonToCpp[5]) pythonToCpp[5](pyArgs[5], &cppArg5);

        if (!PyErr_Occurred()) {
            // getSaveFileUrl(QWidget*,QString,QUrl,QString,QString*,QFlags<QFileDialog::Option>,QStringList)
            // Begin code injection
            // ========================================================================
            // START of custom code block [file: ../glue/qtwidgets.cpp (qfiledialog-return)]
            ::QUrl retval_ = QFileDialog::getSaveFileUrl(cppArg0, cppArg1, *cppArg2, cppArg3, &cppArg4, cppArg5);
            pyResult = PyTuple_New(2);
            PyTuple_SET_ITEM(pyResult, 0, Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &retval_));
            PyTuple_SET_ITEM(pyResult, 1, Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppArg4));
            // END of custom code block [file: ../glue/qtwidgets.cpp (qfiledialog-return)]
            // ========================================================================

            // End of code injection

        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDialogFunc_getSaveFileUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_history(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.history";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // history()const
            QStringList cppResult = const_cast<const ::QFileDialog *>(cppSelf)->history();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_iconProvider(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.iconProvider";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // iconProvider()const
            QFileIconProvider * cppResult = const_cast<const ::QFileDialog *>(cppSelf)->iconProvider();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_isNameFilterDetailsVisible(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.isNameFilterDetailsVisible";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNameFilterDetailsVisible()const
            bool cppResult = const_cast<const ::QFileDialog *>(cppSelf)->isNameFilterDetailsVisible();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_isReadOnly(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.isReadOnly";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isReadOnly()const
            bool cppResult = const_cast<const ::QFileDialog *>(cppSelf)->isReadOnly();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_itemDelegate(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.itemDelegate";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // itemDelegate()const
            QAbstractItemDelegate * cppResult = const_cast<const ::QFileDialog *>(cppSelf)->itemDelegate();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMDELEGATE_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_labelText(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.labelText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::labelText(QFileDialog::DialogLabel)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX])->converter, (pyArg)))) {
        overloadId = 0; // labelText(QFileDialog::DialogLabel)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_labelText_TypeError;

    // Call function/method
    {
        ::QFileDialog::DialogLabel cppArg0{QFileDialog::LookIn};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // labelText(QFileDialog::DialogLabel)const
            QString cppResult = const_cast<const ::QFileDialog *>(cppSelf)->labelText(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDialogFunc_labelText_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_mimeTypeFilters(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.mimeTypeFilters";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // mimeTypeFilters()const
            QStringList cppResult = const_cast<const ::QFileDialog *>(cppSelf)->mimeTypeFilters();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_nameFilters(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.nameFilters";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nameFilters()const
            QStringList cppResult = const_cast<const ::QFileDialog *>(cppSelf)->nameFilters();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_open(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.open";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs == 1)
        goto Sbk_QFileDialogFunc_open_TypeError;

    if (!PyArg_UnpackTuple(args, "open", 0, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFileDialog::open(QObject*,const char*)
    // 1: QDialog::open()
    if (numArgs == 0) {
        overloadId = 1; // open()
    } else if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[0])))
        && Shiboken::String::check(pyArgs[1]) && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<const char *>(), (pyArgs[1])))) {
        overloadId = 0; // open(QObject*,const char*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_open_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // open(QObject * receiver, const char * member)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return {};
            ::QObject *cppArg0;
            pythonToCpp[0](pyArgs[0], &cppArg0);
            const char* cppArg1;
            pythonToCpp[1](pyArgs[1], &cppArg1);

            if (!PyErr_Occurred()) {
                // open(QObject*,const char*)
                cppSelf->open(cppArg0, cppArg1);
            }
            break;
        }
        case 1: // open()
        {

            if (!PyErr_Occurred()) {
                // open()
                Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                    ? reinterpret_cast<QDialog *>(cppSelf)->::QDialog::open()
                    : reinterpret_cast<QDialog *>(cppSelf)->open();
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_open_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_options(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.options";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // options()const
            QFlags<QFileDialog::Option> cppResult = const_cast<const ::QFileDialog *>(cppSelf)->options();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_proxyModel(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.proxyModel";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // proxyModel()const
            QAbstractProxyModel * cppResult = const_cast<const ::QFileDialog *>(cppSelf)->proxyModel();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_resolveSymlinks(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.resolveSymlinks";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resolveSymlinks()const
            bool cppResult = const_cast<const ::QFileDialog *>(cppSelf)->resolveSymlinks();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_restoreState(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.restoreState";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::restoreState(QByteArray)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArg)))) {
        overloadId = 0; // restoreState(QByteArray)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_restoreState_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // restoreState(QByteArray)
            bool cppResult = cppSelf->restoreState(*cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDialogFunc_restoreState_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_saveFileContent(PyObject *self, PyObject *args, PyObject *kwds)
{
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.saveFileContent";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFileDialogFunc_saveFileContent_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFileDialogFunc_saveFileContent_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:saveFileContent", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: static QFileDialog::saveFileContent(QByteArray,QString)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // saveFileContent(QByteArray,QString)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
            overloadId = 0; // saveFileContent(QByteArray,QString)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_saveFileContent_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_fileNameHint = Shiboken::String::createStaticString("fileNameHint");
            if (PyDict_Contains(kwds, key_fileNameHint)) {
                value = PyDict_GetItem(kwds, key_fileNameHint);
                if (value && pyArgs[1]) {
                    errInfo = key_fileNameHint;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_saveFileContent_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1]))))
                        goto Sbk_QFileDialogFunc_saveFileContent_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_fileNameHint);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFileDialogFunc_saveFileContent_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QByteArray cppArg0_local;
        ::QByteArray *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);

        ::QString cppArg1 = QString();
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // saveFileContent(QByteArray,QString)
            ::QFileDialog::saveFileContent(*cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_saveFileContent_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_saveState(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.saveState";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // saveState()const
            QByteArray cppResult = const_cast<const ::QFileDialog *>(cppSelf)->saveState();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QBYTEARRAY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_selectFile(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.selectFile";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::selectFile(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // selectFile(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_selectFile_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // selectFile(QString)
            cppSelf->selectFile(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_selectFile_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_selectMimeTypeFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.selectMimeTypeFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::selectMimeTypeFilter(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // selectMimeTypeFilter(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_selectMimeTypeFilter_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // selectMimeTypeFilter(QString)
            cppSelf->selectMimeTypeFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_selectMimeTypeFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_selectNameFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.selectNameFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::selectNameFilter(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // selectNameFilter(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_selectNameFilter_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // selectNameFilter(QString)
            cppSelf->selectNameFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_selectNameFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_selectUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.selectUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::selectUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // selectUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_selectUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // selectUrl(QUrl)
            cppSelf->selectUrl(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_selectUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_selectedFiles(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.selectedFiles";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedFiles()const
            QStringList cppResult = const_cast<const ::QFileDialog *>(cppSelf)->selectedFiles();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_selectedMimeTypeFilter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.selectedMimeTypeFilter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedMimeTypeFilter()const
            QString cppResult = const_cast<const ::QFileDialog *>(cppSelf)->selectedMimeTypeFilter();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_selectedNameFilter(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.selectedNameFilter";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedNameFilter()const
            QString cppResult = const_cast<const ::QFileDialog *>(cppSelf)->selectedNameFilter();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_selectedUrls(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.selectedUrls";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // selectedUrls()const
            QList<QUrl > cppResult = const_cast<const ::QFileDialog *>(cppSelf)->selectedUrls();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QURL_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_setAcceptMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setAcceptMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setAcceptMode(QFileDialog::AcceptMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_ACCEPTMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setAcceptMode(QFileDialog::AcceptMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setAcceptMode_TypeError;

    // Call function/method
    {
        ::QFileDialog::AcceptMode cppArg0{QFileDialog::AcceptOpen};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setAcceptMode(QFileDialog::AcceptMode)
            cppSelf->setAcceptMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setAcceptMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setConfirmOverwrite(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setConfirmOverwrite";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setConfirmOverwrite(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setConfirmOverwrite(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setConfirmOverwrite_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setConfirmOverwrite(bool)
            cppSelf->setConfirmOverwrite(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setConfirmOverwrite_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setDefaultSuffix(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setDefaultSuffix";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setDefaultSuffix(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDefaultSuffix(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setDefaultSuffix_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultSuffix(QString)
            cppSelf->setDefaultSuffix(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setDefaultSuffix_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setDirectory(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setDirectory";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setDirectory(QDir)
    // 1: QFileDialog::setDirectory(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 1; // setDirectory(QString)
    } else if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), (pyArg)))) {
        overloadId = 0; // setDirectory(QDir)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setDirectory_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // setDirectory(const QDir & directory)
        {
            if (!Shiboken::Object::isValid(pyArg))
                return {};
            ::QDir cppArg0_local;
            ::QDir *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QDIR_IDX]), pythonToCpp))
                pythonToCpp(pyArg, &cppArg0_local);
            else
                pythonToCpp(pyArg, &cppArg0);


            if (!PyErr_Occurred()) {
                // setDirectory(QDir)
                cppSelf->setDirectory(*cppArg0);
            }
            break;
        }
        case 1: // setDirectory(const QString & directory)
        {
            ::QString cppArg0;
            pythonToCpp(pyArg, &cppArg0);

            if (!PyErr_Occurred()) {
                // setDirectory(QString)
                cppSelf->setDirectory(cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setDirectory_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setDirectoryUrl(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setDirectoryUrl";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setDirectoryUrl(QUrl)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), (pyArg)))) {
        overloadId = 0; // setDirectoryUrl(QUrl)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setDirectoryUrl_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QUrl cppArg0_local;
        ::QUrl *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setDirectoryUrl(QUrl)
            cppSelf->setDirectoryUrl(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setDirectoryUrl_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setFileMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setFileMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setFileMode(QFileDialog::FileMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_FILEMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFileMode(QFileDialog::FileMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setFileMode_TypeError;

    // Call function/method
    {
        ::QFileDialog::FileMode cppArg0{QFileDialog::AnyFile};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFileMode(QFileDialog::FileMode)
            cppSelf->setFileMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setFileMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setFilter(QFlags<QDir::Filter>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtCoreTypes[SBK_QFLAGS_QDIR_FILTER_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setFilter(QFlags<QDir::Filter>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setFilter_TypeError;

    // Call function/method
    {
        ::QFlags<QDir::Filter> cppArg0 = QFlags<QDir::Filter>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setFilter(QFlags<QDir::Filter>)
            cppSelf->setFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setHistory(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setHistory";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setHistory(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setHistory(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setHistory_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHistory(QStringList)
            cppSelf->setHistory(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setHistory_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setIconProvider(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setIconProvider";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setIconProvider(QFileIconProvider*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QFILEICONPROVIDER_IDX]), (pyArg)))) {
        overloadId = 0; // setIconProvider(QFileIconProvider*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setIconProvider_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QFileIconProvider *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setIconProvider(QFileIconProvider*)
            cppSelf->setIconProvider(cppArg0);
            Shiboken::Object::setParent(self, pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setIconProvider_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setItemDelegate(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setItemDelegate";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setItemDelegate(QAbstractItemDelegate*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QABSTRACTITEMDELEGATE_IDX]), (pyArg)))) {
        overloadId = 0; // setItemDelegate(QAbstractItemDelegate*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setItemDelegate_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractItemDelegate *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setItemDelegate(QAbstractItemDelegate*)
            cppSelf->setItemDelegate(cppArg0);
            Shiboken::Object::keepReference(reinterpret_cast<SbkObject *>(self), "setItemDelegate(QAbstractItemDelegate*)1", pyArg);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setItemDelegate_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setLabelText(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setLabelText";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setLabelText", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFileDialog::setLabelText(QFileDialog::DialogLabel,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // setLabelText(QFileDialog::DialogLabel,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setLabelText_TypeError;

    // Call function/method
    {
        ::QFileDialog::DialogLabel cppArg0{QFileDialog::LookIn};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setLabelText(QFileDialog::DialogLabel,QString)
            cppSelf->setLabelText(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setLabelText_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setMimeTypeFilters(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setMimeTypeFilters";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setMimeTypeFilters(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setMimeTypeFilters(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setMimeTypeFilters_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMimeTypeFilters(QStringList)
            cppSelf->setMimeTypeFilters(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setMimeTypeFilters_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setNameFilter(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setNameFilter";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setNameFilter(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setNameFilter(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setNameFilter_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNameFilter(QString)
            cppSelf->setNameFilter(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setNameFilter_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setNameFilterDetailsVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setNameFilterDetailsVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setNameFilterDetailsVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setNameFilterDetailsVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setNameFilterDetailsVisible_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNameFilterDetailsVisible(bool)
            cppSelf->setNameFilterDetailsVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setNameFilterDetailsVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setNameFilters(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setNameFilters";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setNameFilters(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setNameFilters(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setNameFilters_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNameFilters(QStringList)
            cppSelf->setNameFilters(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setNameFilters_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setOption(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QFileDialogFunc_setOption_TypeError;
    } else if (numArgs < 1) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QFileDialogFunc_setOption_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:setOption", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QFileDialog::setOption(QFileDialog::Option,bool)
    if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX])->converter, (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // setOption(QFileDialog::Option,bool)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
            overloadId = 0; // setOption(QFileDialog::Option,bool)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setOption_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_on = Shiboken::String::createStaticString("on");
            if (PyDict_Contains(kwds, key_on)) {
                value = PyDict_GetItem(kwds, key_on);
                if (value && pyArgs[1]) {
                    errInfo = key_on;
                    Py_INCREF(errInfo);
                    goto Sbk_QFileDialogFunc_setOption_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1]))))
                        goto Sbk_QFileDialogFunc_setOption_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_on);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QFileDialogFunc_setOption_TypeError;
            }
        }
        ::QFileDialog::Option cppArg0 = static_cast< ::QFileDialog::Option>(0);
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1 = true;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setOption(QFileDialog::Option,bool)
            cppSelf->setOption(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setOptions(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setOptions";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setOptions(QFlags<QFileDialog::Option>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setOptions(QFlags<QFileDialog::Option>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setOptions_TypeError;

    // Call function/method
    {
        ::QFlags<QFileDialog::Option> cppArg0 = QFlags<QFileDialog::Option>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setOptions(QFlags<QFileDialog::Option>)
            cppSelf->setOptions(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setOptions_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setProxyModel(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setProxyModel";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setProxyModel(QAbstractProxyModel*)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QABSTRACTPROXYMODEL_IDX]), (pyArg)))) {
        overloadId = 0; // setProxyModel(QAbstractProxyModel*)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setProxyModel_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QAbstractProxyModel *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setProxyModel(QAbstractProxyModel*)
            cppSelf->setProxyModel(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setProxyModel_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setReadOnly(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setReadOnly";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setReadOnly(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setReadOnly(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setReadOnly_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setReadOnly(bool)
            cppSelf->setReadOnly(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setReadOnly_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setResolveSymlinks(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setResolveSymlinks";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setResolveSymlinks(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setResolveSymlinks(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setResolveSymlinks_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setResolveSymlinks(bool)
            cppSelf->setResolveSymlinks(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setResolveSymlinks_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setSidebarUrls(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setSidebarUrls";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setSidebarUrls(QList<QUrl>)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QURL_IDX], (pyArg)))) {
        overloadId = 0; // setSidebarUrls(QList<QUrl>)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setSidebarUrls_TypeError;

    // Call function/method
    {
        ::QList<QUrl > cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSidebarUrls(QList<QUrl>)
            cppSelf->setSidebarUrls(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setSidebarUrls_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setSupportedSchemes(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setSupportedSchemes";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setSupportedSchemes(QStringList)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], (pyArg)))) {
        overloadId = 0; // setSupportedSchemes(QStringList)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setSupportedSchemes_TypeError;

    // Call function/method
    {
        ::QStringList cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSupportedSchemes(QStringList)
            cppSelf->setSupportedSchemes(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setSupportedSchemes_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setViewMode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setViewMode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::setViewMode(QFileDialog::ViewMode)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_VIEWMODE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setViewMode(QFileDialog::ViewMode)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setViewMode_TypeError;

    // Call function/method
    {
        ::QFileDialog::ViewMode cppArg0{QFileDialog::Detail};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setViewMode(QFileDialog::ViewMode)
            cppSelf->setViewMode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setViewMode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_setVisible(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.setVisible";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWidget::setVisible(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setVisible(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_setVisible_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setVisible(bool)
            Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QFileDialog::setVisible(cppArg0)
                : cppSelf->setVisible(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QFileDialogFunc_setVisible_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_sidebarUrls(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.sidebarUrls";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sidebarUrls()const
            QList<QUrl > cppResult = const_cast<const ::QFileDialog *>(cppSelf)->sidebarUrls();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWidgetsTypeConverters[SBK_QTWIDGETS_QLIST_QURL_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_supportedSchemes(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.supportedSchemes";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedSchemes()const
            QStringList cppResult = const_cast<const ::QFileDialog *>(cppSelf)->supportedSchemes();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRINGLIST_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QFileDialogFunc_testOption(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.testOption";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QFileDialog::testOption(QFileDialog::Option)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX])->converter, (pyArg)))) {
        overloadId = 0; // testOption(QFileDialog::Option)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QFileDialogFunc_testOption_TypeError;

    // Call function/method
    {
        ::QFileDialog::Option cppArg0 = static_cast< ::QFileDialog::Option>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // testOption(QFileDialog::Option)const
            bool cppResult = const_cast<const ::QFileDialog *>(cppSelf)->testOption(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QFileDialogFunc_testOption_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QFileDialogFunc_viewMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWidgets.QFileDialog.viewMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // viewMode()const
            QFileDialog::ViewMode cppResult = const_cast<const ::QFileDialog *>(cppSelf)->viewMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_VIEWMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QFileDialog_PropertyStrings[] = {
    "acceptMode::",
    "confirmOverwrite::",
    "defaultSuffix::",
    "fileMode::",
    "nameFilterDetailsVisible:isNameFilterDetailsVisible:",
    "options::",
    "readOnly:isReadOnly:",
    "resolveSymlinks::",
    "supportedSchemes::",
    "viewMode::",
    nullptr // Sentinel
};

static PyMethodDef Sbk_QFileDialog_methods[] = {
    {"accept", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_accept), METH_NOARGS},
    {"acceptMode", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_acceptMode), METH_NOARGS},
    {"changeEvent", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_changeEvent), METH_O},
    {"confirmOverwrite", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_confirmOverwrite), METH_NOARGS},
    {"defaultSuffix", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_defaultSuffix), METH_NOARGS},
    {"directory", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_directory), METH_NOARGS},
    {"directoryUrl", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_directoryUrl), METH_NOARGS},
    {"done", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_done), METH_O},
    {"fileMode", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_fileMode), METH_NOARGS},
    {"filter", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_filter), METH_NOARGS},
    {"getExistingDirectory", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_getExistingDirectory), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"getExistingDirectoryUrl", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_getExistingDirectoryUrl), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"getOpenFileName", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_getOpenFileName), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"getOpenFileNames", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_getOpenFileNames), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"getOpenFileUrl", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_getOpenFileUrl), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"getOpenFileUrls", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_getOpenFileUrls), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"getSaveFileName", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_getSaveFileName), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"getSaveFileUrl", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_getSaveFileUrl), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"history", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_history), METH_NOARGS},
    {"iconProvider", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_iconProvider), METH_NOARGS},
    {"isNameFilterDetailsVisible", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_isNameFilterDetailsVisible), METH_NOARGS},
    {"isReadOnly", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_isReadOnly), METH_NOARGS},
    {"itemDelegate", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_itemDelegate), METH_NOARGS},
    {"labelText", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_labelText), METH_O},
    {"mimeTypeFilters", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_mimeTypeFilters), METH_NOARGS},
    {"nameFilters", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_nameFilters), METH_NOARGS},
    {"open", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_open), METH_VARARGS},
    {"options", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_options), METH_NOARGS},
    {"proxyModel", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_proxyModel), METH_NOARGS},
    {"resolveSymlinks", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_resolveSymlinks), METH_NOARGS},
    {"restoreState", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_restoreState), METH_O},
    {"saveFileContent", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_saveFileContent), METH_VARARGS|METH_KEYWORDS|METH_STATIC},
    {"saveState", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_saveState), METH_NOARGS},
    {"selectFile", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_selectFile), METH_O},
    {"selectMimeTypeFilter", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_selectMimeTypeFilter), METH_O},
    {"selectNameFilter", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_selectNameFilter), METH_O},
    {"selectUrl", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_selectUrl), METH_O},
    {"selectedFiles", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_selectedFiles), METH_NOARGS},
    {"selectedMimeTypeFilter", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_selectedMimeTypeFilter), METH_NOARGS},
    {"selectedNameFilter", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_selectedNameFilter), METH_NOARGS},
    {"selectedUrls", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_selectedUrls), METH_NOARGS},
    {"setAcceptMode", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setAcceptMode), METH_O},
    {"setConfirmOverwrite", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setConfirmOverwrite), METH_O},
    {"setDefaultSuffix", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setDefaultSuffix), METH_O},
    {"setDirectory", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setDirectory), METH_O},
    {"setDirectoryUrl", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setDirectoryUrl), METH_O},
    {"setFileMode", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setFileMode), METH_O},
    {"setFilter", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setFilter), METH_O},
    {"setHistory", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setHistory), METH_O},
    {"setIconProvider", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setIconProvider), METH_O},
    {"setItemDelegate", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setItemDelegate), METH_O},
    {"setLabelText", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setLabelText), METH_VARARGS},
    {"setMimeTypeFilters", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setMimeTypeFilters), METH_O},
    {"setNameFilter", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setNameFilter), METH_O},
    {"setNameFilterDetailsVisible", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setNameFilterDetailsVisible), METH_O},
    {"setNameFilters", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setNameFilters), METH_O},
    {"setOption", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setOption), METH_VARARGS|METH_KEYWORDS},
    {"setOptions", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setOptions), METH_O},
    {"setProxyModel", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setProxyModel), METH_O},
    {"setReadOnly", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setReadOnly), METH_O},
    {"setResolveSymlinks", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setResolveSymlinks), METH_O},
    {"setSidebarUrls", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setSidebarUrls), METH_O},
    {"setSupportedSchemes", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setSupportedSchemes), METH_O},
    {"setViewMode", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setViewMode), METH_O},
    {"setVisible", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_setVisible), METH_O},
    {"sidebarUrls", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_sidebarUrls), METH_NOARGS},
    {"supportedSchemes", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_supportedSchemes), METH_NOARGS},
    {"testOption", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_testOption), METH_O},
    {"viewMode", reinterpret_cast<PyCFunction>(Sbk_QFileDialogFunc_viewMode), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QFileDialog_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QFileDialog *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QFileDialogWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QFileDialog_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QFileDialog_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
static void * Sbk_QFileDialogSpecialCastFunction(void *obj, SbkObjectType *desiredType)
{
    auto me = reinterpret_cast< ::QFileDialog *>(obj);
    if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QDIALOG_IDX]))
        return static_cast< ::QDialog *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]))
        return static_cast< ::QWidget *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]))
        return static_cast< ::QObject *>(me);
    else if (desiredType == reinterpret_cast<SbkObjectType *>(SbkPySide2_QtGuiTypes[SBK_QPAINTDEVICE_IDX]))
        return static_cast< ::QPaintDevice *>(me);
    return me;
}


// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QFileDialog_Type = nullptr;
static SbkObjectType *Sbk_QFileDialog_TypeF(void)
{
    return _Sbk_QFileDialog_Type;
}

static PyType_Slot Sbk_QFileDialog_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QFileDialog_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QFileDialog_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QFileDialog_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QFileDialog_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QFileDialog_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QFileDialog_spec = {
    "2:PySide2.QtWidgets.QFileDialog",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QFileDialog_slots
};

} //extern "C"

static void *Sbk_QFileDialog_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QFileDialog *>(reinterpret_cast< ::QObject *>(cptr));
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QPaintDevice >()))
        return dynamic_cast< ::QFileDialog *>(reinterpret_cast< ::QPaintDevice *>(cptr));
    return {};
}

PyObject *SbkPySide2_QtWidgets_QFileDialog_Option___and__(PyObject *self, PyObject *pyArg)
{
    ::QFileDialog::Options cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QFileDialog::Options>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QFileDialog::Options>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QFileDialog::Options>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QFileDialog::Options>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf & cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QFileDialog_Option___or__(PyObject *self, PyObject *pyArg)
{
    ::QFileDialog::Options cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QFileDialog::Options>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QFileDialog::Options>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QFileDialog::Options>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QFileDialog::Options>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf | cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QFileDialog_Option___xor__(PyObject *self, PyObject *pyArg)
{
    ::QFileDialog::Options cppResult, cppSelf, cppArg;
#ifdef IS_PY3K
    cppSelf = static_cast<::QFileDialog::Options>(int(PyLong_AsLong(self)));
    cppArg = static_cast<QFileDialog::Options>(int(PyLong_AsLong(pyArg)));
    if (PyErr_Occurred())
    return nullptr;
#else
    cppSelf = static_cast<::QFileDialog::Options>(int(PyInt_AsLong(self)));
    cppArg = static_cast<QFileDialog::Options>(int(PyInt_AsLong(pyArg)));
#endif

    if (PyErr_Occurred())
        return nullptr;
    cppResult = cppSelf ^ cppArg;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, &cppResult);
}

PyObject *SbkPySide2_QtWidgets_QFileDialog_Option___invert__(PyObject *self, PyObject *pyArg)
{
    ::QFileDialog::Options cppSelf;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, self, &cppSelf);
    ::QFileDialog::Options cppResult = ~cppSelf;
    return Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, &cppResult);
}

static PyObject *SbkPySide2_QtWidgets_QFileDialog_Option_long(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, self, &val);
    return Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &val);
}
static int SbkPySide2_QtWidgets_QFileDialog_Option__nonzero(PyObject *self)
{
    int val;
    Shiboken::Conversions::pythonToCppCopy(*PepType_SGTP(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX])->converter, self, &val);
    return val != 0;
}

static PyType_Slot SbkPySide2_QtWidgets_QFileDialog_Option_number_slots[] = {
#ifdef IS_PY3K
    {Py_nb_bool,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileDialog_Option__nonzero)},
#else
    {Py_nb_nonzero, reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileDialog_Option__nonzero)},
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileDialog_Option_long)},
#endif
    {Py_nb_invert,  reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileDialog_Option___invert__)},
    {Py_nb_and,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileDialog_Option___and__)},
    {Py_nb_xor,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileDialog_Option___xor__)},
    {Py_nb_or,      reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileDialog_Option___or__)},
    {Py_nb_int,     reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileDialog_Option_long)},
    {Py_nb_index,   reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileDialog_Option_long)},
#ifndef IS_PY3K
    {Py_nb_long,    reinterpret_cast<void *>(SbkPySide2_QtWidgets_QFileDialog_Option_long)},
#endif
    {0, nullptr} // sentinel
};



// Type conversion functions.

// Python to C++ enum conversion.
static void QFileDialog_ViewMode_PythonToCpp_QFileDialog_ViewMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileDialog::ViewMode *>(cppOut) =
        static_cast<::QFileDialog::ViewMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFileDialog_ViewMode_PythonToCpp_QFileDialog_ViewMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_VIEWMODE_IDX]))
        return QFileDialog_ViewMode_PythonToCpp_QFileDialog_ViewMode;
    return {};
}
static PyObject *QFileDialog_ViewMode_CppToPython_QFileDialog_ViewMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFileDialog::ViewMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_VIEWMODE_IDX], castCppIn);

}

static void QFileDialog_FileMode_PythonToCpp_QFileDialog_FileMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileDialog::FileMode *>(cppOut) =
        static_cast<::QFileDialog::FileMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFileDialog_FileMode_PythonToCpp_QFileDialog_FileMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_FILEMODE_IDX]))
        return QFileDialog_FileMode_PythonToCpp_QFileDialog_FileMode;
    return {};
}
static PyObject *QFileDialog_FileMode_CppToPython_QFileDialog_FileMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFileDialog::FileMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_FILEMODE_IDX], castCppIn);

}

static void QFileDialog_AcceptMode_PythonToCpp_QFileDialog_AcceptMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileDialog::AcceptMode *>(cppOut) =
        static_cast<::QFileDialog::AcceptMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFileDialog_AcceptMode_PythonToCpp_QFileDialog_AcceptMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_ACCEPTMODE_IDX]))
        return QFileDialog_AcceptMode_PythonToCpp_QFileDialog_AcceptMode;
    return {};
}
static PyObject *QFileDialog_AcceptMode_CppToPython_QFileDialog_AcceptMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFileDialog::AcceptMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_ACCEPTMODE_IDX], castCppIn);

}

static void QFileDialog_DialogLabel_PythonToCpp_QFileDialog_DialogLabel(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileDialog::DialogLabel *>(cppOut) =
        static_cast<::QFileDialog::DialogLabel>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFileDialog_DialogLabel_PythonToCpp_QFileDialog_DialogLabel_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX]))
        return QFileDialog_DialogLabel_PythonToCpp_QFileDialog_DialogLabel;
    return {};
}
static PyObject *QFileDialog_DialogLabel_CppToPython_QFileDialog_DialogLabel(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFileDialog::DialogLabel *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX], castCppIn);

}

static void QFileDialog_Option_PythonToCpp_QFileDialog_Option(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFileDialog::Option *>(cppOut) =
        static_cast<::QFileDialog::Option>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QFileDialog_Option_PythonToCpp_QFileDialog_Option_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX]))
        return QFileDialog_Option_PythonToCpp_QFileDialog_Option;
    return {};
}
static PyObject *QFileDialog_Option_CppToPython_QFileDialog_Option(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFileDialog::Option *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX], castCppIn);

}

static void QFlags_QFileDialog_Option__PythonToCpp_QFlags_QFileDialog_Option_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QFileDialog::Option> *>(cppOut) =
        ::QFlags<QFileDialog::Option>(QFlag(int(PySide::QFlags::getValue(reinterpret_cast<PySideQFlagsObject *>(pyIn)))));

}
static PythonToCppFunc is_QFlags_QFileDialog_Option__PythonToCpp_QFlags_QFileDialog_Option__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX]))
        return QFlags_QFileDialog_Option__PythonToCpp_QFlags_QFileDialog_Option_;
    return {};
}
static PyObject *QFlags_QFileDialog_Option__CppToPython_QFlags_QFileDialog_Option_(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QFlags<QFileDialog::Option> *>(cppIn));
    return reinterpret_cast<PyObject *>(PySide::QFlags::newObject(castCppIn, SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX]));

}

static void QFileDialog_Option_PythonToCpp_QFlags_QFileDialog_Option_(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QFlags<QFileDialog::Option> *>(cppOut) =
        ::QFlags<QFileDialog::Option>(QFlag(int(Shiboken::Enum::getValue(pyIn))));

}
static PythonToCppFunc is_QFileDialog_Option_PythonToCpp_QFlags_QFileDialog_Option__Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX]))
        return QFileDialog_Option_PythonToCpp_QFlags_QFileDialog_Option_;
    return {};
}
static void number_PythonToCpp_QFlags_QFileDialog_Option_(PyObject *pyIn, void *cppOut) {
    Shiboken::AutoDecRef pyLong(PyNumber_Long(pyIn));
    *reinterpret_cast<::QFlags<QFileDialog::Option> *>(cppOut) =
        ::QFlags<QFileDialog::Option>(QFlag(int(PyLong_AsLong(pyLong.object()))));

}
static PythonToCppFunc is_number_PythonToCpp_QFlags_QFileDialog_Option__Convertible(PyObject *pyIn) {
    if (PyNumber_Check(pyIn) && PyObject_TypeCheck(pyIn, SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX]))
        return number_PythonToCpp_QFlags_QFileDialog_Option_;
    return {};
}
// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QFileDialog_PythonToCpp_QFileDialog_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QFileDialog_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QFileDialog_PythonToCpp_QFileDialog_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QFileDialog_TypeF())))
        return QFileDialog_PythonToCpp_QFileDialog_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QFileDialog_PTR_CppToPython_QFileDialog(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QFileDialog *>(const_cast<void *>(cppIn)), Sbk_QFileDialog_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QFileDialog_SignatureStrings[] = {
    "1:PySide2.QtWidgets.QFileDialog(self,parent:PySide2.QtWidgets.QWidget,f:PySide2.QtCore.Qt.WindowFlags)",
    "0:PySide2.QtWidgets.QFileDialog(self,parent:PySide2.QtWidgets.QWidget=nullptr,caption:QString=QString(),directory:QString=QString(),filter:QString=QString())",
    "PySide2.QtWidgets.QFileDialog.accept(self)",
    "PySide2.QtWidgets.QFileDialog.acceptMode(self)->PySide2.QtWidgets.QFileDialog.AcceptMode",
    "PySide2.QtWidgets.QFileDialog.changeEvent(self,e:PySide2.QtCore.QEvent)",
    "PySide2.QtWidgets.QFileDialog.confirmOverwrite(self)->bool",
    "PySide2.QtWidgets.QFileDialog.defaultSuffix(self)->QString",
    "PySide2.QtWidgets.QFileDialog.directory(self)->PySide2.QtCore.QDir",
    "PySide2.QtWidgets.QFileDialog.directoryUrl(self)->PySide2.QtCore.QUrl",
    "PySide2.QtWidgets.QFileDialog.done(self,result:int)",
    "PySide2.QtWidgets.QFileDialog.fileMode(self)->PySide2.QtWidgets.QFileDialog.FileMode",
    "PySide2.QtWidgets.QFileDialog.filter(self)->PySide2.QtCore.QDir.Filters",
    "PySide2.QtWidgets.QFileDialog.getExistingDirectory(parent:PySide2.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:QString=QString(),options:PySide2.QtWidgets.QFileDialog.Options=QFileDialog.ShowDirsOnly)->QString",
    "PySide2.QtWidgets.QFileDialog.getExistingDirectoryUrl(parent:PySide2.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:PySide2.QtCore.QUrl=QUrl(),options:PySide2.QtWidgets.QFileDialog.Options=QFileDialog.ShowDirsOnly,supportedSchemes:QStringList=QStringList())->PySide2.QtCore.QUrl",
    "PySide2.QtWidgets.QFileDialog.getOpenFileName(parent:PySide2.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:QString=QString(),filter:QString=QString(),selectedFilter:QString*=QString(),options:PySide2.QtWidgets.QFileDialog.Options=QFileDialog.Options())->QString",
    "PySide2.QtWidgets.QFileDialog.getOpenFileNames(parent:PySide2.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:QString=QString(),filter:QString=QString(),selectedFilter:QString*=QString(),options:PySide2.QtWidgets.QFileDialog.Options=QFileDialog.Options())->QStringList",
    "PySide2.QtWidgets.QFileDialog.getOpenFileUrl(parent:PySide2.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:PySide2.QtCore.QUrl=QUrl(),filter:QString=QString(),selectedFilter:QString*=QString(),options:PySide2.QtWidgets.QFileDialog.Options=QFileDialog.Options(),supportedSchemes:QStringList=QStringList())->PySide2.QtCore.QUrl",
    "PySide2.QtWidgets.QFileDialog.getOpenFileUrls(parent:PySide2.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:PySide2.QtCore.QUrl=QUrl(),filter:QString=QString(),selectedFilter:QString*=QString(),options:PySide2.QtWidgets.QFileDialog.Options=QFileDialog.Options(),supportedSchemes:QStringList=QStringList())->QList[PySide2.QtCore.QUrl]",
    "PySide2.QtWidgets.QFileDialog.getSaveFileName(parent:PySide2.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:QString=QString(),filter:QString=QString(),selectedFilter:QString*=QString(),options:PySide2.QtWidgets.QFileDialog.Options=QFileDialog.Options())->QString",
    "PySide2.QtWidgets.QFileDialog.getSaveFileUrl(parent:PySide2.QtWidgets.QWidget=nullptr,caption:QString=QString(),dir:PySide2.QtCore.QUrl=QUrl(),filter:QString=QString(),selectedFilter:QString*=QString(),options:PySide2.QtWidgets.QFileDialog.Options=QFileDialog.Options(),supportedSchemes:QStringList=QStringList())->PySide2.QtCore.QUrl",
    "PySide2.QtWidgets.QFileDialog.history(self)->QStringList",
    "PySide2.QtWidgets.QFileDialog.iconProvider(self)->PySide2.QtWidgets.QFileIconProvider",
    "PySide2.QtWidgets.QFileDialog.isNameFilterDetailsVisible(self)->bool",
    "PySide2.QtWidgets.QFileDialog.isReadOnly(self)->bool",
    "PySide2.QtWidgets.QFileDialog.itemDelegate(self)->PySide2.QtWidgets.QAbstractItemDelegate",
    "PySide2.QtWidgets.QFileDialog.labelText(self,label:PySide2.QtWidgets.QFileDialog.DialogLabel)->QString",
    "PySide2.QtWidgets.QFileDialog.mimeTypeFilters(self)->QStringList",
    "PySide2.QtWidgets.QFileDialog.nameFilters(self)->QStringList",
    "1:PySide2.QtWidgets.QFileDialog.open(self,receiver:PySide2.QtCore.QObject,member:char*)",
    "0:PySide2.QtWidgets.QFileDialog.open(self)",
    "PySide2.QtWidgets.QFileDialog.options(self)->PySide2.QtWidgets.QFileDialog.Options",
    "PySide2.QtWidgets.QFileDialog.proxyModel(self)->PySide2.QtCore.QAbstractProxyModel",
    "PySide2.QtWidgets.QFileDialog.resolveSymlinks(self)->bool",
    "PySide2.QtWidgets.QFileDialog.restoreState(self,state:PySide2.QtCore.QByteArray)->bool",
    "PySide2.QtWidgets.QFileDialog.saveFileContent(fileContent:PySide2.QtCore.QByteArray,fileNameHint:QString=QString())",
    "PySide2.QtWidgets.QFileDialog.saveState(self)->PySide2.QtCore.QByteArray",
    "PySide2.QtWidgets.QFileDialog.selectFile(self,filename:QString)",
    "PySide2.QtWidgets.QFileDialog.selectMimeTypeFilter(self,filter:QString)",
    "PySide2.QtWidgets.QFileDialog.selectNameFilter(self,filter:QString)",
    "PySide2.QtWidgets.QFileDialog.selectUrl(self,url:PySide2.QtCore.QUrl)",
    "PySide2.QtWidgets.QFileDialog.selectedFiles(self)->QStringList",
    "PySide2.QtWidgets.QFileDialog.selectedMimeTypeFilter(self)->QString",
    "PySide2.QtWidgets.QFileDialog.selectedNameFilter(self)->QString",
    "PySide2.QtWidgets.QFileDialog.selectedUrls(self)->QList[PySide2.QtCore.QUrl]",
    "PySide2.QtWidgets.QFileDialog.setAcceptMode(self,mode:PySide2.QtWidgets.QFileDialog.AcceptMode)",
    "PySide2.QtWidgets.QFileDialog.setConfirmOverwrite(self,enabled:bool)",
    "PySide2.QtWidgets.QFileDialog.setDefaultSuffix(self,suffix:QString)",
    "1:PySide2.QtWidgets.QFileDialog.setDirectory(self,directory:PySide2.QtCore.QDir)",
    "0:PySide2.QtWidgets.QFileDialog.setDirectory(self,directory:QString)",
    "PySide2.QtWidgets.QFileDialog.setDirectoryUrl(self,directory:PySide2.QtCore.QUrl)",
    "PySide2.QtWidgets.QFileDialog.setFileMode(self,mode:PySide2.QtWidgets.QFileDialog.FileMode)",
    "PySide2.QtWidgets.QFileDialog.setFilter(self,filters:PySide2.QtCore.QDir.Filters)",
    "PySide2.QtWidgets.QFileDialog.setHistory(self,paths:QStringList)",
    "PySide2.QtWidgets.QFileDialog.setIconProvider(self,provider:PySide2.QtWidgets.QFileIconProvider)",
    "PySide2.QtWidgets.QFileDialog.setItemDelegate(self,delegate:PySide2.QtWidgets.QAbstractItemDelegate)",
    "PySide2.QtWidgets.QFileDialog.setLabelText(self,label:PySide2.QtWidgets.QFileDialog.DialogLabel,text:QString)",
    "PySide2.QtWidgets.QFileDialog.setMimeTypeFilters(self,filters:QStringList)",
    "PySide2.QtWidgets.QFileDialog.setNameFilter(self,filter:QString)",
    "PySide2.QtWidgets.QFileDialog.setNameFilterDetailsVisible(self,enabled:bool)",
    "PySide2.QtWidgets.QFileDialog.setNameFilters(self,filters:QStringList)",
    "PySide2.QtWidgets.QFileDialog.setOption(self,option:PySide2.QtWidgets.QFileDialog.Option,on:bool=true)",
    "PySide2.QtWidgets.QFileDialog.setOptions(self,options:PySide2.QtWidgets.QFileDialog.Options)",
    "PySide2.QtWidgets.QFileDialog.setProxyModel(self,model:PySide2.QtCore.QAbstractProxyModel)",
    "PySide2.QtWidgets.QFileDialog.setReadOnly(self,enabled:bool)",
    "PySide2.QtWidgets.QFileDialog.setResolveSymlinks(self,enabled:bool)",
    "PySide2.QtWidgets.QFileDialog.setSidebarUrls(self,urls:QList[PySide2.QtCore.QUrl])",
    "PySide2.QtWidgets.QFileDialog.setSupportedSchemes(self,schemes:QStringList)",
    "PySide2.QtWidgets.QFileDialog.setViewMode(self,mode:PySide2.QtWidgets.QFileDialog.ViewMode)",
    "PySide2.QtWidgets.QFileDialog.setVisible(self,visible:bool)",
    "PySide2.QtWidgets.QFileDialog.sidebarUrls(self)->QList[PySide2.QtCore.QUrl]",
    "PySide2.QtWidgets.QFileDialog.supportedSchemes(self)->QStringList",
    "PySide2.QtWidgets.QFileDialog.testOption(self,option:PySide2.QtWidgets.QFileDialog.Option)->bool",
    "PySide2.QtWidgets.QFileDialog.viewMode(self)->PySide2.QtWidgets.QFileDialog.ViewMode",
    nullptr}; // Sentinel

void init_QFileDialog(PyObject *module)
{
    _Sbk_QFileDialog_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QFileDialog",
        "QFileDialog*",
        &Sbk_QFileDialog_spec,
        &Shiboken::callCppDestructor< ::QFileDialog >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QDIALOG_IDX]),
        0,
        Shiboken::ObjectType::WrapperFlags::DeleteInMainThread    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QFileDialog_Type);
    InitSignatureStrings(pyType, QFileDialog_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QFileDialog_Type), Sbk_QFileDialog_PropertyStrings);
    SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QFileDialog_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QFileDialog_TypeF(),
        QFileDialog_PythonToCpp_QFileDialog_PTR,
        is_QFileDialog_PythonToCpp_QFileDialog_PTR_Convertible,
        QFileDialog_PTR_CppToPython_QFileDialog);

    Shiboken::Conversions::registerConverterName(converter, "QFileDialog");
    Shiboken::Conversions::registerConverterName(converter, "QFileDialog*");
    Shiboken::Conversions::registerConverterName(converter, "QFileDialog&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFileDialog).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QFileDialogWrapper).name());


    MultipleInheritanceInitFunction func = Shiboken::ObjectType::getMultipleInheritanceFunction(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWidgetsTypes[SBK_QWIDGET_IDX]));
    Shiboken::ObjectType::setMultipleInheritanceFunction(Sbk_QFileDialog_TypeF(), func);
    Shiboken::ObjectType::setCastFunction(Sbk_QFileDialog_TypeF(), &Sbk_QFileDialogSpecialCastFunction);
    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QFileDialog_TypeF(), &Sbk_QFileDialog_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'ViewMode'.
    SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_VIEWMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFileDialog_TypeF(),
        "ViewMode",
        "2:PySide2.QtWidgets.QFileDialog.ViewMode",
        "QFileDialog::ViewMode");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_VIEWMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_VIEWMODE_IDX],
        Sbk_QFileDialog_TypeF(), "Detail", (long) QFileDialog::ViewMode::Detail))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_VIEWMODE_IDX],
        Sbk_QFileDialog_TypeF(), "List", (long) QFileDialog::ViewMode::List))
        return;
    // Register converter for enum 'QFileDialog::ViewMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_VIEWMODE_IDX],
            QFileDialog_ViewMode_CppToPython_QFileDialog_ViewMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileDialog_ViewMode_PythonToCpp_QFileDialog_ViewMode,
            is_QFileDialog_ViewMode_PythonToCpp_QFileDialog_ViewMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_VIEWMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileDialog::ViewMode");
        Shiboken::Conversions::registerConverterName(converter, "ViewMode");
    }
    // End of 'ViewMode' enum.

    // Initialization of enum 'FileMode'.
    SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_FILEMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFileDialog_TypeF(),
        "FileMode",
        "2:PySide2.QtWidgets.QFileDialog.FileMode",
        "QFileDialog::FileMode");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_FILEMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_FILEMODE_IDX],
        Sbk_QFileDialog_TypeF(), "AnyFile", (long) QFileDialog::FileMode::AnyFile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_FILEMODE_IDX],
        Sbk_QFileDialog_TypeF(), "ExistingFile", (long) QFileDialog::FileMode::ExistingFile))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_FILEMODE_IDX],
        Sbk_QFileDialog_TypeF(), "Directory", (long) QFileDialog::FileMode::Directory))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_FILEMODE_IDX],
        Sbk_QFileDialog_TypeF(), "ExistingFiles", (long) QFileDialog::FileMode::ExistingFiles))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_FILEMODE_IDX],
        Sbk_QFileDialog_TypeF(), "DirectoryOnly", (long) QFileDialog::FileMode::DirectoryOnly))
        return;
    // Register converter for enum 'QFileDialog::FileMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_FILEMODE_IDX],
            QFileDialog_FileMode_CppToPython_QFileDialog_FileMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileDialog_FileMode_PythonToCpp_QFileDialog_FileMode,
            is_QFileDialog_FileMode_PythonToCpp_QFileDialog_FileMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_FILEMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileDialog::FileMode");
        Shiboken::Conversions::registerConverterName(converter, "FileMode");
    }
    // End of 'FileMode' enum.

    // Initialization of enum 'AcceptMode'.
    SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_ACCEPTMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFileDialog_TypeF(),
        "AcceptMode",
        "2:PySide2.QtWidgets.QFileDialog.AcceptMode",
        "QFileDialog::AcceptMode");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_ACCEPTMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_ACCEPTMODE_IDX],
        Sbk_QFileDialog_TypeF(), "AcceptOpen", (long) QFileDialog::AcceptMode::AcceptOpen))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_ACCEPTMODE_IDX],
        Sbk_QFileDialog_TypeF(), "AcceptSave", (long) QFileDialog::AcceptMode::AcceptSave))
        return;
    // Register converter for enum 'QFileDialog::AcceptMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_ACCEPTMODE_IDX],
            QFileDialog_AcceptMode_CppToPython_QFileDialog_AcceptMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileDialog_AcceptMode_PythonToCpp_QFileDialog_AcceptMode,
            is_QFileDialog_AcceptMode_PythonToCpp_QFileDialog_AcceptMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_ACCEPTMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileDialog::AcceptMode");
        Shiboken::Conversions::registerConverterName(converter, "AcceptMode");
    }
    // End of 'AcceptMode' enum.

    // Initialization of enum 'DialogLabel'.
    SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFileDialog_TypeF(),
        "DialogLabel",
        "2:PySide2.QtWidgets.QFileDialog.DialogLabel",
        "QFileDialog::DialogLabel");
    if (!SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX],
        Sbk_QFileDialog_TypeF(), "LookIn", (long) QFileDialog::DialogLabel::LookIn))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX],
        Sbk_QFileDialog_TypeF(), "FileName", (long) QFileDialog::DialogLabel::FileName))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX],
        Sbk_QFileDialog_TypeF(), "FileType", (long) QFileDialog::DialogLabel::FileType))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX],
        Sbk_QFileDialog_TypeF(), "Accept", (long) QFileDialog::DialogLabel::Accept))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX],
        Sbk_QFileDialog_TypeF(), "Reject", (long) QFileDialog::DialogLabel::Reject))
        return;
    // Register converter for enum 'QFileDialog::DialogLabel'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX],
            QFileDialog_DialogLabel_CppToPython_QFileDialog_DialogLabel);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileDialog_DialogLabel_PythonToCpp_QFileDialog_DialogLabel,
            is_QFileDialog_DialogLabel_PythonToCpp_QFileDialog_DialogLabel_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_DIALOGLABEL_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileDialog::DialogLabel");
        Shiboken::Conversions::registerConverterName(converter, "DialogLabel");
    }
    // End of 'DialogLabel' enum.

    // Initialization of enum 'Option'.
    SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX] = PySide::QFlags::create("2:PySide2.QtWidgets.QFileDialog.Options", SbkPySide2_QtWidgets_QFileDialog_Option_number_slots);
    SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QFileDialog_TypeF(),
        "Option",
        "2:PySide2.QtWidgets.QFileDialog.Option",
        "QFileDialog::Option",
        SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX]);
    if (!SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX],
        Sbk_QFileDialog_TypeF(), "ShowDirsOnly", (long) QFileDialog::Option::ShowDirsOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX],
        Sbk_QFileDialog_TypeF(), "DontResolveSymlinks", (long) QFileDialog::Option::DontResolveSymlinks))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX],
        Sbk_QFileDialog_TypeF(), "DontConfirmOverwrite", (long) QFileDialog::Option::DontConfirmOverwrite))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX],
        Sbk_QFileDialog_TypeF(), "DontUseSheet", (long) QFileDialog::Option::DontUseSheet))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX],
        Sbk_QFileDialog_TypeF(), "DontUseNativeDialog", (long) QFileDialog::Option::DontUseNativeDialog))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX],
        Sbk_QFileDialog_TypeF(), "ReadOnly", (long) QFileDialog::Option::ReadOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX],
        Sbk_QFileDialog_TypeF(), "HideNameFilterDetails", (long) QFileDialog::Option::HideNameFilterDetails))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX],
        Sbk_QFileDialog_TypeF(), "DontUseCustomDirectoryIcons", (long) QFileDialog::Option::DontUseCustomDirectoryIcons))
        return;
    // Register converter for enum 'QFileDialog::Option'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX],
            QFileDialog_Option_CppToPython_QFileDialog_Option);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileDialog_Option_PythonToCpp_QFileDialog_Option,
            is_QFileDialog_Option_PythonToCpp_QFileDialog_Option_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFILEDIALOG_OPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileDialog::Option");
        Shiboken::Conversions::registerConverterName(converter, "Option");
    }
    // Register converter for flag 'QFlags<QFileDialog::Option>'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX],
            QFlags_QFileDialog_Option__CppToPython_QFlags_QFileDialog_Option_);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFileDialog_Option_PythonToCpp_QFlags_QFileDialog_Option_,
            is_QFileDialog_Option_PythonToCpp_QFlags_QFileDialog_Option__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QFlags_QFileDialog_Option__PythonToCpp_QFlags_QFileDialog_Option_,
            is_QFlags_QFileDialog_Option__PythonToCpp_QFlags_QFileDialog_Option__Convertible);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            number_PythonToCpp_QFlags_QFileDialog_Option_,
            is_number_PythonToCpp_QFlags_QFileDialog_Option__Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWidgetsTypes[SBK_QFLAGS_QFILEDIALOG_OPTION_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QFileDialog::Options");
        Shiboken::Conversions::registerConverterName(converter, "Options");
    }
    // End of 'Option' enum/flags.

    PySide::Signal::registerSignals(Sbk_QFileDialog_TypeF(), &::QFileDialog::staticMetaObject);
    qRegisterMetaType< ::QFileDialog::ViewMode >("QFileDialog::ViewMode");
    qRegisterMetaType< ::QFileDialog::FileMode >("QFileDialog::FileMode");
    qRegisterMetaType< ::QFileDialog::AcceptMode >("QFileDialog::AcceptMode");
    qRegisterMetaType< ::QFileDialog::DialogLabel >("QFileDialog::DialogLabel");
    qRegisterMetaType< ::QFileDialog::Option >("QFileDialog::Option");
    qRegisterMetaType< ::QFileDialog::Options >("QFileDialog::Options");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QFileDialog_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QFileDialog_TypeF(), &::QFileDialog::staticMetaObject, sizeof(QFileDialogWrapper));
}
