/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/
#ifndef SBK_QABSTRACTITEMDELEGATEWRAPPER_H
#define SBK_QABSTRACTITEMDELEGATEWRAPPER_H

#define protected public

#include <QtWidgets/qabstractitemdelegate.h>


// Extra includes
#include <qobject.h>
#include <QtGui/qpainter.h>
#include <QtWidgets/qstyleoption.h>
#include <qabstractitemmodel.h>
#include <qsize.h>
#include <QtWidgets/qwidget.h>
#include <qcoreevent.h>
#include <QtGui/qfontmetrics.h>
#include <QtGui/qevent.h>
#include <QtWidgets/qabstractitemview.h>
#include <QVector>
#include <qthread.h>
#include <qobjectdefs.h>
#include <qmetaobject.h>
#include <QList>
#include <qbytearray.h>
namespace PySide { class DynamicQMetaObject; }

class QAbstractItemDelegateWrapper : public QAbstractItemDelegate
{
public:
    QAbstractItemDelegateWrapper(::QObject * parent = nullptr);
    void childEvent(::QChildEvent * event) override;
    void connectNotify(const ::QMetaMethod & signal) override;
    ::QWidget * createEditor(::QWidget * parent, const ::QStyleOptionViewItem & option, const ::QModelIndex & index) const override;
    void customEvent(::QEvent * event) override;
    void destroyEditor(::QWidget * editor, const ::QModelIndex & index) const override;
    void disconnectNotify(const ::QMetaMethod & signal) override;
    bool editorEvent(::QEvent * event, ::QAbstractItemModel * model, const ::QStyleOptionViewItem & option, const ::QModelIndex & index) override;
    bool event(::QEvent * event) override;
    bool eventFilter(::QObject * watched, ::QEvent * event) override;
    bool helpEvent(::QHelpEvent * event, ::QAbstractItemView * view, const ::QStyleOptionViewItem & option, const ::QModelIndex & index) override;
    const ::QMetaObject * metaObject() const override;
    void paint(::QPainter * painter, const ::QStyleOptionViewItem & option, const ::QModelIndex & index) const override;
    ::QVector<int > paintingRoles() const override;
    void setEditorData(::QWidget * editor, const ::QModelIndex & index) const override;
    void setModelData(::QWidget * editor, ::QAbstractItemModel * model, const ::QModelIndex & index) const override;
    ::QSize sizeHint(const ::QStyleOptionViewItem & option, const ::QModelIndex & index) const override;
    void timerEvent(::QTimerEvent * event) override;
    void updateEditorGeometry(::QWidget * editor, const ::QStyleOptionViewItem & option, const ::QModelIndex & index) const override;
    ~QAbstractItemDelegateWrapper();
public:
    int qt_metacall(QMetaObject::Call call, int id, void **args) override;
    void *qt_metacast(const char *_clname) override;
    static void pysideInitQtMetaTypes();
    void resetPyMethodCache();
private:
    mutable bool m_PyMethodCache[18];
};

#endif // SBK_QABSTRACTITEMDELEGATEWRAPPER_H

