/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <signalmanager.h>
#include <pysidemetafunction.h>
#include <iterator>

// module include
#include "pyside2_qtwebsockets_python.h"

// main header
#include "qwebsocketserver_wrapper.h"

// inner classes

#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}

// Native ---------------------------------------------------------

void QWebSocketServerWrapper::resetPyMethodCache()
{
    std::fill_n(m_PyMethodCache, sizeof(m_PyMethodCache) / sizeof(m_PyMethodCache[0]), false);
}

QWebSocketServerWrapper::QWebSocketServerWrapper(const ::QString & serverName, ::QWebSocketServer::SslMode secureMode, ::QObject * parent) : QWebSocketServer(serverName, secureMode, parent)
{
    resetPyMethodCache();
    // ... middle
}

void QWebSocketServerWrapper::childEvent(::QChildEvent * event)
{
    if (m_PyMethodCache[0]) {
        return this->::QObject::childEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "childEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[0] = true;
        return this->::QObject::childEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QCHILDEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QWebSocketServerWrapper::connectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[1]) {
        return this->::QObject::connectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "connectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[1] = true;
        return this->::QObject::connectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

void QWebSocketServerWrapper::customEvent(::QEvent * event)
{
    if (m_PyMethodCache[2]) {
        return this->::QObject::customEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "customEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[2] = true;
        return this->::QObject::customEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

void QWebSocketServerWrapper::disconnectNotify(const ::QMetaMethod & signal)
{
    if (m_PyMethodCache[3]) {
        return this->::QObject::disconnectNotify(signal);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "disconnectNotify";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[3] = true;
        return this->::QObject::disconnectNotify(signal);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QMETAMETHOD_IDX]), &signal)
    ));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
}

bool QWebSocketServerWrapper::event(::QEvent * event)
{
    if (m_PyMethodCache[4])
        return this->::QObject::event(event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "event";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[4] = true;
        return this->::QObject::event(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebSocketServer.event", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
    return cppResult;
}

bool QWebSocketServerWrapper::eventFilter(::QObject * watched, ::QEvent * event)
{
    if (m_PyMethodCache[5])
        return this->::QObject::eventFilter(watched, event);
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return false;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "eventFilter";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[5] = true;
        return this->::QObject::eventFilter(watched, event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(NN)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), watched),
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QEVENT_IDX]), event)
    ));
    bool invalidateArg2 = PyTuple_GET_ITEM(pyArgs, 1)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return false;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebSocketServer.eventFilter", "bool", Py_TYPE(pyResult)->tp_name);
        return false;
    }
    bool cppResult;
    pythonToCpp(pyResult, &cppResult);
    if (invalidateArg2)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 1));
    return cppResult;
}

::QWebSocket * QWebSocketServerWrapper::nextPendingConnection()
{
    if (m_PyMethodCache[7])
        return this->::QWebSocketServer::nextPendingConnection();
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return nullptr;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "nextPendingConnection";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[7] = true;
        return this->::QWebSocketServer::nextPendingConnection();
    }

    Shiboken::AutoDecRef pyArgs(PyTuple_New(0));

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return nullptr;
    }
    // Check return type
    PythonToCppFunc pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX]), pyResult);
    if (!pythonToCpp) {
        Shiboken::warning(PyExc_RuntimeWarning, 2, "Invalid return value in function %s, expected %s, got %s.", "QWebSocketServer.nextPendingConnection", reinterpret_cast<PyTypeObject *>(Shiboken::SbkType< QWebSocket >())->tp_name, Py_TYPE(pyResult)->tp_name);
        return nullptr;
    }
    ::QWebSocket *cppResult;
    pythonToCpp(pyResult, &cppResult);
    return cppResult;
}

void QWebSocketServerWrapper::timerEvent(::QTimerEvent * event)
{
    if (m_PyMethodCache[8]) {
        return this->::QObject::timerEvent(event);
    }
    Shiboken::GilState gil;
    if (PyErr_Occurred())
        return;
    static PyObject *nameCache[2] = {};
    static const char *funcName = "timerEvent";
    Shiboken::AutoDecRef pyOverride(Shiboken::BindingManager::instance().getOverride(this, nameCache, funcName));
    if (pyOverride.isNull()) {
        gil.release();
        m_PyMethodCache[8] = true;
        return this->::QObject::timerEvent(event);
    }

    Shiboken::AutoDecRef pyArgs(Py_BuildValue("(N)",
    Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QTIMEREVENT_IDX]), event)
    ));
    bool invalidateArg1 = PyTuple_GET_ITEM(pyArgs, 0)->ob_refcnt == 1;

    Shiboken::AutoDecRef pyResult(PyObject_Call(pyOverride, pyArgs, nullptr));
    // An error happened in python code!
    if (pyResult.isNull()) {
        PyErr_Print();
        return;
    }
    if (invalidateArg1)
        Shiboken::Object::invalidate(PyTuple_GET_ITEM(pyArgs, 0));
}

const QMetaObject *QWebSocketServerWrapper::metaObject() const
{
    if (QObject::d_ptr->metaObject)
        return QObject::d_ptr->dynamicMetaObject();
    SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
    if (pySelf == nullptr)
        return QWebSocketServer::metaObject();
    return PySide::SignalManager::retrieveMetaObject(reinterpret_cast<PyObject *>(pySelf));
}

int QWebSocketServerWrapper::qt_metacall(QMetaObject::Call call, int id, void **args)
{
    int result = QWebSocketServer::qt_metacall(call, id, args);
    return result < 0 ? result : PySide::SignalManager::qt_metacall(this, call, id, args);
}

void *QWebSocketServerWrapper::qt_metacast(const char *_clname)
{
        if (!_clname) return {};
        SbkObject *pySelf = Shiboken::BindingManager::instance().retrieveWrapper(this);
        if (pySelf && PySide::inherits(Py_TYPE(pySelf), _clname))
                return static_cast<void *>(const_cast< QWebSocketServerWrapper *>(this));
        return QWebSocketServer::qt_metacast(_clname);
}

QWebSocketServerWrapper::~QWebSocketServerWrapper()
{
    SbkObject *wrapper = Shiboken::BindingManager::instance().retrieveWrapper(this);
    Shiboken::Object::destroy(wrapper, this);
}

// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QWebSocketServer_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    const QMetaObject *metaObject;
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QWebSocketServer >()))
        return -1;

    ::QWebSocketServerWrapper *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0, 0};

    // invalid argument lengths
    if (numArgs < 2) {
        static PyObject *const too_few = Shiboken::String::createStaticString("<");
        errInfo = too_few;
        Py_INCREF(errInfo);
        goto Sbk_QWebSocketServer_Init_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OOO:QWebSocketServer", &(pyArgs[0]), &(pyArgs[1]), &(pyArgs[2])))
        return -1;


    // Overloaded function decisor
    // 0: QWebSocketServer::QWebSocketServer(QString,QWebSocketServer::SslMode,QObject*)
    if (numArgs >= 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_SSLMODE_IDX])->converter, (pyArgs[1])))) {
        if (numArgs == 2) {
            overloadId = 0; // QWebSocketServer(QString,QWebSocketServer::SslMode,QObject*)
        } else if (numArgs >= 3
            && (pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2])))) {
            overloadId = 0; // QWebSocketServer(QString,QWebSocketServer::SslMode,QObject*)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketServer_Init_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_parent = Shiboken::String::createStaticString("parent");
            if (PyDict_Contains(kwds, key_parent)) {
                value = PyDict_GetItem(kwds, key_parent);
                if (value && pyArgs[2]) {
                    errInfo = key_parent;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebSocketServer_Init_TypeError;
                }
                if (value) {
                    pyArgs[2] = value;
                    if (!(pythonToCpp[2] = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]), (pyArgs[2]))))
                        goto Sbk_QWebSocketServer_Init_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_parent);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                // fall through to handle extra keyword signals and properties
            }
        }
        ::QString cppArg0;
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QWebSocketServer::SslMode cppArg1{QWebSocketServer::SecureMode};
        pythonToCpp[1](pyArgs[1], &cppArg1);
        if (!Shiboken::Object::isValid(pyArgs[2]))
            return -1;
        ::QObject *cppArg2 = nullptr;
        if (pythonToCpp[2]) pythonToCpp[2](pyArgs[2], &cppArg2);

        if (!PyErr_Occurred()) {
            // QWebSocketServer(QString,QWebSocketServer::SslMode,QObject*)
            void *addr = PySide::nextQObjectMemoryAddr();
            if (addr) {
                cptr = new (addr) ::QWebSocketServerWrapper(cppArg0, cppArg1, cppArg2);
                PySide::setNextQObjectMemoryAddr(0);
            } else {
                cptr = new ::QWebSocketServerWrapper(cppArg0, cppArg1, cppArg2);
            }

            Shiboken::Object::setParent(pyArgs[2], self);
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QWebSocketServer >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QWebSocketServer_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    Shiboken::Object::setHasCppWrapper(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);

    // QObject setup
    PySide::Signal::updateSourceObject(self);
    metaObject = cptr->metaObject(); // <- init python qt properties
    if (errInfo && PyDict_Check(errInfo)) {
        if (!PySide::fillQtProperties(self, metaObject, errInfo))
            goto Sbk_QWebSocketServer_Init_TypeError;
        Py_DECREF(errInfo);
    };


    return 1;

    Sbk_QWebSocketServer_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QWebSocketServerFunc_close(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.close";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // close()
            cppSelf->close();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebSocketServerFunc_error(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.error";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // error()const
            QWebSocketProtocol::CloseCode cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->error();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETPROTOCOL_CLOSECODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_errorString(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.errorString";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // errorString()const
            QString cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->errorString();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_handleConnection(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.handleConnection";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocketServer::handleConnection(QTcpSocket*)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppPointerConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QTCPSOCKET_IDX]), (pyArg)))) {
        overloadId = 0; // handleConnection(QTcpSocket*)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketServerFunc_handleConnection_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QTcpSocket *cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // handleConnection(QTcpSocket*)const
            const_cast<const ::QWebSocketServer *>(cppSelf)->handleConnection(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketServerFunc_handleConnection_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketServerFunc_handshakeTimeoutMS(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.handshakeTimeoutMS";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // handshakeTimeoutMS()const
            int cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->handshakeTimeoutMS();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_hasPendingConnections(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.hasPendingConnections";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // hasPendingConnections()const
            bool cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->hasPendingConnections();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_isListening(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.isListening";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isListening()const
            bool cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->isListening();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_listen(PyObject *self, PyObject *args, PyObject *kwds)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.listen";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths
    if (numArgs > 2) {
        static PyObject *const too_many = Shiboken::String::createStaticString(">");
        errInfo = too_many;
        Py_INCREF(errInfo);
        goto Sbk_QWebSocketServerFunc_listen_TypeError;
    }

    if (!PyArg_ParseTuple(args, "|OO:listen", &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebSocketServer::listen(QHostAddress,quint16)
    if (numArgs == 0) {
        overloadId = 0; // listen(QHostAddress,quint16)
    } else if (numArgs >= 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArgs[0])))) {
        if (numArgs == 1) {
            overloadId = 0; // listen(QHostAddress,quint16)
        } else if (numArgs >= 2
            && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1])))) {
            overloadId = 0; // listen(QHostAddress,quint16)
        }
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketServerFunc_listen_TypeError;

    // Call function/method
    {
        if (kwds) {
            PyObject *value{};
            Shiboken::AutoDecRef kwds_dup(PyDict_Copy(kwds));
            static PyObject *const key_address = Shiboken::String::createStaticString("address");
            if (PyDict_Contains(kwds, key_address)) {
                value = PyDict_GetItem(kwds, key_address);
                if (value && pyArgs[0]) {
                    errInfo = key_address;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebSocketServerFunc_listen_TypeError;
                }
                if (value) {
                    pyArgs[0] = value;
                    if (!(pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), (pyArgs[0]))))
                        goto Sbk_QWebSocketServerFunc_listen_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_address);
            }
            static PyObject *const key_port = Shiboken::String::createStaticString("port");
            if (PyDict_Contains(kwds, key_port)) {
                value = PyDict_GetItem(kwds, key_port);
                if (value && pyArgs[1]) {
                    errInfo = key_port;
                    Py_INCREF(errInfo);
                    goto Sbk_QWebSocketServerFunc_listen_TypeError;
                }
                if (value) {
                    pyArgs[1] = value;
                    if (!(pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), (pyArgs[1]))))
                        goto Sbk_QWebSocketServerFunc_listen_TypeError;
                }
                PyDict_DelItem(kwds_dup, key_port);
            }
            if (PyDict_Size(kwds_dup) > 0) {
                errInfo = kwds_dup.release();
                goto Sbk_QWebSocketServerFunc_listen_TypeError;
            }
        }
        if (!Shiboken::Object::isValid(pyArgs[0]))
            return {};
        ::QHostAddress cppArg0_local = QHostAddress::Any;
        ::QHostAddress *cppArg0 = &cppArg0_local;
        if (pythonToCpp[0]) {
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), pythonToCpp[0]))
            pythonToCpp[0](pyArgs[0], &cppArg0_local);
        else
            pythonToCpp[0](pyArgs[0], &cppArg0);
        }
        quint16 cppArg1 = 0;
        if (pythonToCpp[1]) pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // listen(QHostAddress,quint16)
            bool cppResult = cppSelf->listen(*cppArg0, cppArg1);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebSocketServerFunc_listen_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketServerFunc_maxPendingConnections(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.maxPendingConnections";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // maxPendingConnections()const
            int cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->maxPendingConnections();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_nativeDescriptor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.nativeDescriptor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nativeDescriptor()const
            qintptr cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->nativeDescriptor();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QINTPTR_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_nextPendingConnection(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.nextPendingConnection";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // nextPendingConnection()
            QWebSocket * cppResult = Shiboken::Object::hasCppWrapper(reinterpret_cast<SbkObject *>(self))
                ? cppSelf->::QWebSocketServer::nextPendingConnection()
                : cppSelf->nextPendingConnection();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKET_IDX]), cppResult);
            Shiboken::Object::setParent(self, pyResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_pauseAccepting(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.pauseAccepting";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // pauseAccepting()
            cppSelf->pauseAccepting();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebSocketServerFunc_proxy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.proxy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // proxy()const
            QNetworkProxy cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->proxy();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_resumeAccepting(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.resumeAccepting";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resumeAccepting()
            cppSelf->resumeAccepting();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebSocketServerFunc_secureMode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.secureMode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // secureMode()const
            QWebSocketServer::SslMode cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->secureMode();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_SSLMODE_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_serverAddress(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.serverAddress";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // serverAddress()const
            QHostAddress cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->serverAddress();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QHOSTADDRESS_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_serverName(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.serverName";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // serverName()const
            QString cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->serverName();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_serverPort(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.serverPort";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // serverPort()const
            quint16 cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->serverPort();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint16>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_serverUrl(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.serverUrl";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // serverUrl()const
            QUrl cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->serverUrl();
            pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QURL_IDX]), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_setHandshakeTimeout(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.setHandshakeTimeout";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocketServer::setHandshakeTimeout(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setHandshakeTimeout(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketServerFunc_setHandshakeTimeout_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setHandshakeTimeout(int)
            cppSelf->setHandshakeTimeout(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketServerFunc_setHandshakeTimeout_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketServerFunc_setMaxPendingConnections(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.setMaxPendingConnections";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocketServer::setMaxPendingConnections(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setMaxPendingConnections(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketServerFunc_setMaxPendingConnections_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setMaxPendingConnections(int)
            cppSelf->setMaxPendingConnections(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketServerFunc_setMaxPendingConnections_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketServerFunc_setNativeDescriptor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.setNativeDescriptor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocketServer::setNativeDescriptor(qintptr)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QINTPTR_IDX], (pyArg)))) {
        overloadId = 0; // setNativeDescriptor(qintptr)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketServerFunc_setNativeDescriptor_TypeError;

    // Call function/method
    {
        ::qintptr cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setNativeDescriptor(qintptr)
            bool cppResult = cppSelf->setNativeDescriptor(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebSocketServerFunc_setNativeDescriptor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketServerFunc_setProxy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.setProxy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocketServer::setProxy(QNetworkProxy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), (pyArg)))) {
        overloadId = 0; // setProxy(QNetworkProxy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketServerFunc_setProxy_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QNetworkProxy cppArg0_local;
        ::QNetworkProxy *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtNetworkTypes[SBK_QNETWORKPROXY_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // setProxy(QNetworkProxy)
            cppSelf->setProxy(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketServerFunc_setProxy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketServerFunc_setServerName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.setServerName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocketServer::setServerName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setServerName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketServerFunc_setServerName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setServerName(QString)
            cppSelf->setServerName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebSocketServerFunc_setServerName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketServerFunc_setSocketDescriptor(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.setSocketDescriptor";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebSocketServer::setSocketDescriptor(int)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArg)))) {
        overloadId = 0; // setSocketDescriptor(int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebSocketServerFunc_setSocketDescriptor_TypeError;

    // Call function/method
    {
        int cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSocketDescriptor(int)
            bool cppResult = cppSelf->setSocketDescriptor(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebSocketServerFunc_setSocketDescriptor_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebSocketServerFunc_socketDescriptor(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.socketDescriptor";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // socketDescriptor()const
            int cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->socketDescriptor();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebSocketServerFunc_supportedVersions(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebSockets.QWebSocketServer.supportedVersions";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // supportedVersions()const
            QList<QWebSocketProtocol::Version > cppResult = const_cast<const ::QWebSocketServer *>(cppSelf)->supportedVersions();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtWebSocketsTypeConverters[SBK_QTWEBSOCKETS_QLIST_QWEBSOCKETPROTOCOL_VERSION_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QWebSocketServer_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebSocketServer_methods[] = {
    {"close", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_close), METH_NOARGS},
    {"error", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_error), METH_NOARGS},
    {"errorString", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_errorString), METH_NOARGS},
    {"handleConnection", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_handleConnection), METH_O},
    {"handshakeTimeoutMS", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_handshakeTimeoutMS), METH_NOARGS},
    {"hasPendingConnections", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_hasPendingConnections), METH_NOARGS},
    {"isListening", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_isListening), METH_NOARGS},
    {"listen", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_listen), METH_VARARGS|METH_KEYWORDS},
    {"maxPendingConnections", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_maxPendingConnections), METH_NOARGS},
    {"nativeDescriptor", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_nativeDescriptor), METH_NOARGS},
    {"nextPendingConnection", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_nextPendingConnection), METH_NOARGS},
    {"pauseAccepting", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_pauseAccepting), METH_NOARGS},
    {"proxy", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_proxy), METH_NOARGS},
    {"resumeAccepting", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_resumeAccepting), METH_NOARGS},
    {"secureMode", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_secureMode), METH_NOARGS},
    {"serverAddress", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_serverAddress), METH_NOARGS},
    {"serverName", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_serverName), METH_NOARGS},
    {"serverPort", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_serverPort), METH_NOARGS},
    {"serverUrl", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_serverUrl), METH_NOARGS},
    {"setHandshakeTimeout", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_setHandshakeTimeout), METH_O},
    {"setMaxPendingConnections", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_setMaxPendingConnections), METH_O},
    {"setNativeDescriptor", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_setNativeDescriptor), METH_O},
    {"setProxy", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_setProxy), METH_O},
    {"setServerName", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_setServerName), METH_O},
    {"setSocketDescriptor", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_setSocketDescriptor), METH_O},
    {"socketDescriptor", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_socketDescriptor), METH_NOARGS},
    {"supportedVersions", reinterpret_cast<PyCFunction>(Sbk_QWebSocketServerFunc_supportedVersions), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

static int Sbk_QWebSocketServer_setattro(PyObject *self, PyObject *name, PyObject *value)
{
    PySide::Feature::Select(self);
    if (value && PyCallable_Check(value)) {
        auto plain_inst = reinterpret_cast< ::QWebSocketServer *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX], reinterpret_cast<SbkObject *>(self)));
        auto inst = dynamic_cast<QWebSocketServerWrapper *>(plain_inst);
        if (inst)
            inst->resetPyMethodCache();
    }
    Shiboken::AutoDecRef pp(reinterpret_cast<PyObject *>(PySide::Property::getObject(self, name)));
    if (!pp.isNull())
        return PySide::Property::setValue(reinterpret_cast<PySideProperty *>(pp.object()), self, value);
    return PyObject_GenericSetAttr(self, name, value);
}

} // extern "C"

static int Sbk_QWebSocketServer_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebSocketServer_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebSocketServer_Type = nullptr;
static SbkObjectType *Sbk_QWebSocketServer_TypeF(void)
{
    return _Sbk_QWebSocketServer_Type;
}

static PyType_Slot Sbk_QWebSocketServer_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    reinterpret_cast<void *>(Sbk_QWebSocketServer_setattro)},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebSocketServer_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebSocketServer_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebSocketServer_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QWebSocketServer_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebSocketServer_spec = {
    "2:PySide2.QtWebSockets.QWebSocketServer",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebSocketServer_slots
};

} //extern "C"

static void *Sbk_QWebSocketServer_typeDiscovery(void *cptr, SbkObjectType *instanceType)
{
    if (instanceType == reinterpret_cast<SbkObjectType *>(Shiboken::SbkType< ::QObject >()))
        return dynamic_cast< ::QWebSocketServer *>(reinterpret_cast< ::QObject *>(cptr));
    return {};
}


// Type conversion functions.

// Python to C++ enum conversion.
static void QWebSocketServer_SslMode_PythonToCpp_QWebSocketServer_SslMode(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebSocketServer::SslMode *>(cppOut) =
        static_cast<::QWebSocketServer::SslMode>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebSocketServer_SslMode_PythonToCpp_QWebSocketServer_SslMode_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_SSLMODE_IDX]))
        return QWebSocketServer_SslMode_PythonToCpp_QWebSocketServer_SslMode;
    return {};
}
static PyObject *QWebSocketServer_SslMode_CppToPython_QWebSocketServer_SslMode(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebSocketServer::SslMode *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_SSLMODE_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebSocketServer_PythonToCpp_QWebSocketServer_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebSocketServer_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebSocketServer_PythonToCpp_QWebSocketServer_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebSocketServer_TypeF())))
        return QWebSocketServer_PythonToCpp_QWebSocketServer_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebSocketServer_PTR_CppToPython_QWebSocketServer(const void *cppIn) {
    return PySide::getWrapperForQObject(reinterpret_cast<::QWebSocketServer *>(const_cast<void *>(cppIn)), Sbk_QWebSocketServer_TypeF());

}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebSocketServer_SignatureStrings[] = {
    "PySide2.QtWebSockets.QWebSocketServer(self,serverName:QString,secureMode:PySide2.QtWebSockets.QWebSocketServer.SslMode,parent:PySide2.QtCore.QObject=nullptr)",
    "PySide2.QtWebSockets.QWebSocketServer.close(self)",
    "PySide2.QtWebSockets.QWebSocketServer.error(self)->PySide2.QtWebSockets.QWebSocketProtocol.CloseCode",
    "PySide2.QtWebSockets.QWebSocketServer.errorString(self)->QString",
    "PySide2.QtWebSockets.QWebSocketServer.handleConnection(self,socket:PySide2.QtNetwork.QTcpSocket)",
    "PySide2.QtWebSockets.QWebSocketServer.handshakeTimeoutMS(self)->int",
    "PySide2.QtWebSockets.QWebSocketServer.hasPendingConnections(self)->bool",
    "PySide2.QtWebSockets.QWebSocketServer.isListening(self)->bool",
    "PySide2.QtWebSockets.QWebSocketServer.listen(self,address:PySide2.QtNetwork.QHostAddress=QHostAddress.Any,port:quint16=0)->bool",
    "PySide2.QtWebSockets.QWebSocketServer.maxPendingConnections(self)->int",
    "PySide2.QtWebSockets.QWebSocketServer.nativeDescriptor(self)->qintptr",
    "PySide2.QtWebSockets.QWebSocketServer.nextPendingConnection(self)->PySide2.QtWebSockets.QWebSocket",
    "PySide2.QtWebSockets.QWebSocketServer.pauseAccepting(self)",
    "PySide2.QtWebSockets.QWebSocketServer.proxy(self)->PySide2.QtNetwork.QNetworkProxy",
    "PySide2.QtWebSockets.QWebSocketServer.resumeAccepting(self)",
    "PySide2.QtWebSockets.QWebSocketServer.secureMode(self)->PySide2.QtWebSockets.QWebSocketServer.SslMode",
    "PySide2.QtWebSockets.QWebSocketServer.serverAddress(self)->PySide2.QtNetwork.QHostAddress",
    "PySide2.QtWebSockets.QWebSocketServer.serverName(self)->QString",
    "PySide2.QtWebSockets.QWebSocketServer.serverPort(self)->quint16",
    "PySide2.QtWebSockets.QWebSocketServer.serverUrl(self)->PySide2.QtCore.QUrl",
    "PySide2.QtWebSockets.QWebSocketServer.setHandshakeTimeout(self,msec:int)",
    "PySide2.QtWebSockets.QWebSocketServer.setMaxPendingConnections(self,numConnections:int)",
    "PySide2.QtWebSockets.QWebSocketServer.setNativeDescriptor(self,descriptor:qintptr)->bool",
    "PySide2.QtWebSockets.QWebSocketServer.setProxy(self,networkProxy:PySide2.QtNetwork.QNetworkProxy)",
    "PySide2.QtWebSockets.QWebSocketServer.setServerName(self,serverName:QString)",
    "PySide2.QtWebSockets.QWebSocketServer.setSocketDescriptor(self,socketDescriptor:int)->bool",
    "PySide2.QtWebSockets.QWebSocketServer.socketDescriptor(self)->int",
    "PySide2.QtWebSockets.QWebSocketServer.supportedVersions(self)->QList[PySide2.QtWebSockets.QWebSocketProtocol.Version]",
    nullptr}; // Sentinel

void init_QWebSocketServer(PyObject *module)
{
    _Sbk_QWebSocketServer_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebSocketServer",
        "QWebSocketServer*",
        &Sbk_QWebSocketServer_spec,
        &Shiboken::callCppDestructor< ::QWebSocketServer >,
        reinterpret_cast<SbkObjectType *>(SbkPySide2_QtCoreTypes[SBK_QOBJECT_IDX]),
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebSocketServer_Type);
    InitSignatureStrings(pyType, QWebSocketServer_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebSocketServer_Type), Sbk_QWebSocketServer_PropertyStrings);
    SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebSocketServer_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebSocketServer_TypeF(),
        QWebSocketServer_PythonToCpp_QWebSocketServer_PTR,
        is_QWebSocketServer_PythonToCpp_QWebSocketServer_PTR_Convertible,
        QWebSocketServer_PTR_CppToPython_QWebSocketServer);

    Shiboken::Conversions::registerConverterName(converter, "QWebSocketServer");
    Shiboken::Conversions::registerConverterName(converter, "QWebSocketServer*");
    Shiboken::Conversions::registerConverterName(converter, "QWebSocketServer&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebSocketServer).name());
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebSocketServerWrapper).name());


    Shiboken::ObjectType::setTypeDiscoveryFunctionV2(Sbk_QWebSocketServer_TypeF(), &Sbk_QWebSocketServer_typeDiscovery);

    // Initialization of enums.

    // Initialization of enum 'SslMode'.
    SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_SSLMODE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebSocketServer_TypeF(),
        "SslMode",
        "2:PySide2.QtWebSockets.QWebSocketServer.SslMode",
        "QWebSocketServer::SslMode");
    if (!SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_SSLMODE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_SSLMODE_IDX],
        Sbk_QWebSocketServer_TypeF(), "SecureMode", (long) QWebSocketServer::SslMode::SecureMode))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_SSLMODE_IDX],
        Sbk_QWebSocketServer_TypeF(), "NonSecureMode", (long) QWebSocketServer::SslMode::NonSecureMode))
        return;
    // Register converter for enum 'QWebSocketServer::SslMode'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_SSLMODE_IDX],
            QWebSocketServer_SslMode_CppToPython_QWebSocketServer_SslMode);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebSocketServer_SslMode_PythonToCpp_QWebSocketServer_SslMode,
            is_QWebSocketServer_SslMode_PythonToCpp_QWebSocketServer_SslMode_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebSocketsTypes[SBK_QWEBSOCKETSERVER_SSLMODE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebSocketServer::SslMode");
        Shiboken::Conversions::registerConverterName(converter, "SslMode");
    }
    // End of 'SslMode' enum.

    PySide::Signal::registerSignals(Sbk_QWebSocketServer_TypeF(), &::QWebSocketServer::staticMetaObject);
    qRegisterMetaType< ::QWebSocketServer::SslMode >("QWebSocketServer::SslMode");
    Shiboken::ObjectType::setSubTypeInitHook(Sbk_QWebSocketServer_TypeF(), &PySide::initQObjectSubType);
    PySide::initDynamicMetaObject(Sbk_QWebSocketServer_TypeF(), &::QWebSocketServer::staticMetaObject, sizeof(QWebSocketServerWrapper));
}
