/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwebenginewidgets_python.h"

// main header
#include "qwebenginesettings_wrapper.h"

// inner classes

// Extra includes
#include <QtWebEngineWidgets/qwebenginesettings.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static PyObject *Sbk_QWebEngineSettingsFunc_defaultSettings(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.defaultSettings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultSettings()
            QWebEngineSettings * cppResult = ::QWebEngineSettings::defaultSettings();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineSettingsFunc_defaultTextEncoding(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.defaultTextEncoding";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // defaultTextEncoding()const
            QString cppResult = const_cast<const ::QWebEngineSettings *>(cppSelf)->defaultTextEncoding();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineSettingsFunc_fontFamily(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.fontFamily";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineSettings::fontFamily(QWebEngineSettings::FontFamily)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // fontFamily(QWebEngineSettings::FontFamily)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineSettingsFunc_fontFamily_TypeError;

    // Call function/method
    {
        ::QWebEngineSettings::FontFamily cppArg0{QWebEngineSettings::StandardFont};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fontFamily(QWebEngineSettings::FontFamily)const
            QString cppResult = const_cast<const ::QWebEngineSettings *>(cppSelf)->fontFamily(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineSettingsFunc_fontFamily_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineSettingsFunc_fontSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.fontSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineSettings::fontSize(QWebEngineSettings::FontSize)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTSIZE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // fontSize(QWebEngineSettings::FontSize)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineSettingsFunc_fontSize_TypeError;

    // Call function/method
    {
        ::QWebEngineSettings::FontSize cppArg0{QWebEngineSettings::MinimumFontSize};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // fontSize(QWebEngineSettings::FontSize)const
            int cppResult = const_cast<const ::QWebEngineSettings *>(cppSelf)->fontSize(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<int>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineSettingsFunc_fontSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineSettingsFunc_globalSettings(PyObject *self)
{
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.globalSettings";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // globalSettings()
            QWebEngineSettings * cppResult = ::QWebEngineSettings::globalSettings();
            pyResult = Shiboken::Conversions::pointerToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX]), cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineSettingsFunc_resetAttribute(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.resetAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineSettings::resetAttribute(QWebEngineSettings::WebAttribute)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // resetAttribute(QWebEngineSettings::WebAttribute)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineSettingsFunc_resetAttribute_TypeError;

    // Call function/method
    {
        ::QWebEngineSettings::WebAttribute cppArg0{QWebEngineSettings::AutoLoadImages};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resetAttribute(QWebEngineSettings::WebAttribute)
            cppSelf->resetAttribute(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineSettingsFunc_resetAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineSettingsFunc_resetFontFamily(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.resetFontFamily";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineSettings::resetFontFamily(QWebEngineSettings::FontFamily)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // resetFontFamily(QWebEngineSettings::FontFamily)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineSettingsFunc_resetFontFamily_TypeError;

    // Call function/method
    {
        ::QWebEngineSettings::FontFamily cppArg0{QWebEngineSettings::StandardFont};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resetFontFamily(QWebEngineSettings::FontFamily)
            cppSelf->resetFontFamily(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineSettingsFunc_resetFontFamily_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineSettingsFunc_resetFontSize(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.resetFontSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineSettings::resetFontSize(QWebEngineSettings::FontSize)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTSIZE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // resetFontSize(QWebEngineSettings::FontSize)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineSettingsFunc_resetFontSize_TypeError;

    // Call function/method
    {
        ::QWebEngineSettings::FontSize cppArg0{QWebEngineSettings::MinimumFontSize};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // resetFontSize(QWebEngineSettings::FontSize)
            cppSelf->resetFontSize(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineSettingsFunc_resetFontSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineSettingsFunc_resetUnknownUrlSchemePolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.resetUnknownUrlSchemePolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // resetUnknownUrlSchemePolicy()
            cppSelf->resetUnknownUrlSchemePolicy();
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;
}

static PyObject *Sbk_QWebEngineSettingsFunc_setAttribute(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.setAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setAttribute", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEngineSettings::setAttribute(QWebEngineSettings::WebAttribute,bool)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArgs[1])))) {
        overloadId = 0; // setAttribute(QWebEngineSettings::WebAttribute,bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineSettingsFunc_setAttribute_TypeError;

    // Call function/method
    {
        ::QWebEngineSettings::WebAttribute cppArg0{QWebEngineSettings::AutoLoadImages};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        bool cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setAttribute(QWebEngineSettings::WebAttribute,bool)
            cppSelf->setAttribute(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineSettingsFunc_setAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineSettingsFunc_setDefaultTextEncoding(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.setDefaultTextEncoding";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineSettings::setDefaultTextEncoding(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setDefaultTextEncoding(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineSettingsFunc_setDefaultTextEncoding_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setDefaultTextEncoding(QString)
            cppSelf->setDefaultTextEncoding(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineSettingsFunc_setDefaultTextEncoding_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineSettingsFunc_setFontFamily(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.setFontFamily";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFontFamily", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEngineSettings::setFontFamily(QWebEngineSettings::FontFamily,QString)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArgs[1])))) {
        overloadId = 0; // setFontFamily(QWebEngineSettings::FontFamily,QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineSettingsFunc_setFontFamily_TypeError;

    // Call function/method
    {
        ::QWebEngineSettings::FontFamily cppArg0{QWebEngineSettings::StandardFont};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        ::QString cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setFontFamily(QWebEngineSettings::FontFamily,QString)
            cppSelf->setFontFamily(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineSettingsFunc_setFontFamily_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineSettingsFunc_setFontSize(PyObject *self, PyObject *args)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.setFontSize";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr, nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0, 0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "setFontSize", 2, 2, &(pyArgs[0]), &(pyArgs[1])))
        return {};


    // Overloaded function decisor
    // 0: QWebEngineSettings::setFontSize(QWebEngineSettings::FontSize,int)
    if (numArgs == 2
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTSIZE_IDX])->converter, (pyArgs[0])))
        && (pythonToCpp[1] = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<int>(), (pyArgs[1])))) {
        overloadId = 0; // setFontSize(QWebEngineSettings::FontSize,int)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineSettingsFunc_setFontSize_TypeError;

    // Call function/method
    {
        ::QWebEngineSettings::FontSize cppArg0{QWebEngineSettings::MinimumFontSize};
        pythonToCpp[0](pyArgs[0], &cppArg0);
        int cppArg1;
        pythonToCpp[1](pyArgs[1], &cppArg1);

        if (!PyErr_Occurred()) {
            // setFontSize(QWebEngineSettings::FontSize,int)
            cppSelf->setFontSize(cppArg0, cppArg1);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineSettingsFunc_setFontSize_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineSettingsFunc_setUnknownUrlSchemePolicy(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.setUnknownUrlSchemePolicy";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineSettings::setUnknownUrlSchemePolicy(QWebEngineSettings::UnknownUrlSchemePolicy)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_UNKNOWNURLSCHEMEPOLICY_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setUnknownUrlSchemePolicy(QWebEngineSettings::UnknownUrlSchemePolicy)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineSettingsFunc_setUnknownUrlSchemePolicy_TypeError;

    // Call function/method
    {
        ::QWebEngineSettings::UnknownUrlSchemePolicy cppArg0 = static_cast< ::QWebEngineSettings::UnknownUrlSchemePolicy>(0);
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setUnknownUrlSchemePolicy(QWebEngineSettings::UnknownUrlSchemePolicy)
            cppSelf->setUnknownUrlSchemePolicy(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineSettingsFunc_setUnknownUrlSchemePolicy_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineSettingsFunc_testAttribute(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.testAttribute";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineSettings::testAttribute(QWebEngineSettings::WebAttribute)const
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX])->converter, (pyArg)))) {
        overloadId = 0; // testAttribute(QWebEngineSettings::WebAttribute)const
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineSettingsFunc_testAttribute_TypeError;

    // Call function/method
    {
        ::QWebEngineSettings::WebAttribute cppArg0{QWebEngineSettings::AutoLoadImages};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // testAttribute(QWebEngineSettings::WebAttribute)const
            bool cppResult = const_cast<const ::QWebEngineSettings *>(cppSelf)->testAttribute(cppArg0);
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;

    Sbk_QWebEngineSettingsFunc_testAttribute_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineSettingsFunc_unknownUrlSchemePolicy(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineSettings *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineSettings.unknownUrlSchemePolicy";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // unknownUrlSchemePolicy()const
            QWebEngineSettings::UnknownUrlSchemePolicy cppResult = const_cast<const ::QWebEngineSettings *>(cppSelf)->unknownUrlSchemePolicy();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_UNKNOWNURLSCHEMEPOLICY_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QWebEngineSettings_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebEngineSettings_methods[] = {
    {"defaultSettings", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_defaultSettings), METH_NOARGS|METH_STATIC},
    {"defaultTextEncoding", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_defaultTextEncoding), METH_NOARGS},
    {"fontFamily", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_fontFamily), METH_O},
    {"fontSize", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_fontSize), METH_O},
    {"globalSettings", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_globalSettings), METH_NOARGS|METH_STATIC},
    {"resetAttribute", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_resetAttribute), METH_O},
    {"resetFontFamily", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_resetFontFamily), METH_O},
    {"resetFontSize", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_resetFontSize), METH_O},
    {"resetUnknownUrlSchemePolicy", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_resetUnknownUrlSchemePolicy), METH_NOARGS},
    {"setAttribute", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_setAttribute), METH_VARARGS},
    {"setDefaultTextEncoding", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_setDefaultTextEncoding), METH_O},
    {"setFontFamily", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_setFontFamily), METH_VARARGS},
    {"setFontSize", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_setFontSize), METH_VARARGS},
    {"setUnknownUrlSchemePolicy", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_setUnknownUrlSchemePolicy), METH_O},
    {"testAttribute", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_testAttribute), METH_O},
    {"unknownUrlSchemePolicy", reinterpret_cast<PyCFunction>(Sbk_QWebEngineSettingsFunc_unknownUrlSchemePolicy), METH_NOARGS},

    {nullptr, nullptr} // Sentinel
};

} // extern "C"

static int Sbk_QWebEngineSettings_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebEngineSettings_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebEngineSettings_Type = nullptr;
static SbkObjectType *Sbk_QWebEngineSettings_TypeF(void)
{
    return _Sbk_QWebEngineSettings_Type;
}

static PyType_Slot Sbk_QWebEngineSettings_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(SbkDeallocWrapperWithPrivateDtor)},
    {Py_tp_repr,        nullptr},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebEngineSettings_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebEngineSettings_clear)},
    {Py_tp_richcompare, nullptr},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebEngineSettings_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        nullptr},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    {0, nullptr}
};
static PyType_Spec Sbk_QWebEngineSettings_spec = {
    "2:PySide2.QtWebEngineWidgets.QWebEngineSettings",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebEngineSettings_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QWebEngineSettings_FontFamily_PythonToCpp_QWebEngineSettings_FontFamily(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineSettings::FontFamily *>(cppOut) =
        static_cast<::QWebEngineSettings::FontFamily>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineSettings_FontFamily_PythonToCpp_QWebEngineSettings_FontFamily_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX]))
        return QWebEngineSettings_FontFamily_PythonToCpp_QWebEngineSettings_FontFamily;
    return {};
}
static PyObject *QWebEngineSettings_FontFamily_CppToPython_QWebEngineSettings_FontFamily(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineSettings::FontFamily *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX], castCppIn);

}

static void QWebEngineSettings_WebAttribute_PythonToCpp_QWebEngineSettings_WebAttribute(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineSettings::WebAttribute *>(cppOut) =
        static_cast<::QWebEngineSettings::WebAttribute>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineSettings_WebAttribute_PythonToCpp_QWebEngineSettings_WebAttribute_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX]))
        return QWebEngineSettings_WebAttribute_PythonToCpp_QWebEngineSettings_WebAttribute;
    return {};
}
static PyObject *QWebEngineSettings_WebAttribute_CppToPython_QWebEngineSettings_WebAttribute(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineSettings::WebAttribute *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX], castCppIn);

}

static void QWebEngineSettings_FontSize_PythonToCpp_QWebEngineSettings_FontSize(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineSettings::FontSize *>(cppOut) =
        static_cast<::QWebEngineSettings::FontSize>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineSettings_FontSize_PythonToCpp_QWebEngineSettings_FontSize_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTSIZE_IDX]))
        return QWebEngineSettings_FontSize_PythonToCpp_QWebEngineSettings_FontSize;
    return {};
}
static PyObject *QWebEngineSettings_FontSize_CppToPython_QWebEngineSettings_FontSize(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineSettings::FontSize *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTSIZE_IDX], castCppIn);

}

static void QWebEngineSettings_UnknownUrlSchemePolicy_PythonToCpp_QWebEngineSettings_UnknownUrlSchemePolicy(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineSettings::UnknownUrlSchemePolicy *>(cppOut) =
        static_cast<::QWebEngineSettings::UnknownUrlSchemePolicy>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineSettings_UnknownUrlSchemePolicy_PythonToCpp_QWebEngineSettings_UnknownUrlSchemePolicy_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_UNKNOWNURLSCHEMEPOLICY_IDX]))
        return QWebEngineSettings_UnknownUrlSchemePolicy_PythonToCpp_QWebEngineSettings_UnknownUrlSchemePolicy;
    return {};
}
static PyObject *QWebEngineSettings_UnknownUrlSchemePolicy_CppToPython_QWebEngineSettings_UnknownUrlSchemePolicy(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineSettings::UnknownUrlSchemePolicy *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_UNKNOWNURLSCHEMEPOLICY_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebEngineSettings_PythonToCpp_QWebEngineSettings_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebEngineSettings_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebEngineSettings_PythonToCpp_QWebEngineSettings_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineSettings_TypeF())))
        return QWebEngineSettings_PythonToCpp_QWebEngineSettings_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebEngineSettings_PTR_CppToPython_QWebEngineSettings(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QWebEngineSettings *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QWebEngineSettings_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebEngineSettings_SignatureStrings[] = {
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.defaultSettings()->PySide2.QtWebEngineWidgets.QWebEngineSettings",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.defaultTextEncoding(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.fontFamily(self,which:PySide2.QtWebEngineWidgets.QWebEngineSettings.FontFamily)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.fontSize(self,type:PySide2.QtWebEngineWidgets.QWebEngineSettings.FontSize)->int",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.globalSettings()->PySide2.QtWebEngineWidgets.QWebEngineSettings",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.resetAttribute(self,attr:PySide2.QtWebEngineWidgets.QWebEngineSettings.WebAttribute)",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.resetFontFamily(self,which:PySide2.QtWebEngineWidgets.QWebEngineSettings.FontFamily)",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.resetFontSize(self,type:PySide2.QtWebEngineWidgets.QWebEngineSettings.FontSize)",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.resetUnknownUrlSchemePolicy(self)",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.setAttribute(self,attr:PySide2.QtWebEngineWidgets.QWebEngineSettings.WebAttribute,on:bool)",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.setDefaultTextEncoding(self,encoding:QString)",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.setFontFamily(self,which:PySide2.QtWebEngineWidgets.QWebEngineSettings.FontFamily,family:QString)",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.setFontSize(self,type:PySide2.QtWebEngineWidgets.QWebEngineSettings.FontSize,size:int)",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.setUnknownUrlSchemePolicy(self,policy:PySide2.QtWebEngineWidgets.QWebEngineSettings.UnknownUrlSchemePolicy)",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.testAttribute(self,attr:PySide2.QtWebEngineWidgets.QWebEngineSettings.WebAttribute)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineSettings.unknownUrlSchemePolicy(self)->PySide2.QtWebEngineWidgets.QWebEngineSettings.UnknownUrlSchemePolicy",
    nullptr}; // Sentinel

void init_QWebEngineSettings(PyObject *module)
{
    _Sbk_QWebEngineSettings_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebEngineSettings",
        "QWebEngineSettings*",
        &Sbk_QWebEngineSettings_spec,
        0,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineSettings_Type);
    InitSignatureStrings(pyType, QWebEngineSettings_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineSettings_Type), Sbk_QWebEngineSettings_PropertyStrings);
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineSettings_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebEngineSettings_TypeF(),
        QWebEngineSettings_PythonToCpp_QWebEngineSettings_PTR,
        is_QWebEngineSettings_PythonToCpp_QWebEngineSettings_PTR_Convertible,
        QWebEngineSettings_PTR_CppToPython_QWebEngineSettings);

    Shiboken::Conversions::registerConverterName(converter, "QWebEngineSettings");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineSettings*");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineSettings&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEngineSettings).name());


    // Initialization of enums.

    // Initialization of enum 'FontFamily'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineSettings_TypeF(),
        "FontFamily",
        "2:PySide2.QtWebEngineWidgets.QWebEngineSettings.FontFamily",
        "QWebEngineSettings::FontFamily");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX],
        Sbk_QWebEngineSettings_TypeF(), "StandardFont", (long) QWebEngineSettings::FontFamily::StandardFont))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX],
        Sbk_QWebEngineSettings_TypeF(), "FixedFont", (long) QWebEngineSettings::FontFamily::FixedFont))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX],
        Sbk_QWebEngineSettings_TypeF(), "SerifFont", (long) QWebEngineSettings::FontFamily::SerifFont))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX],
        Sbk_QWebEngineSettings_TypeF(), "SansSerifFont", (long) QWebEngineSettings::FontFamily::SansSerifFont))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX],
        Sbk_QWebEngineSettings_TypeF(), "CursiveFont", (long) QWebEngineSettings::FontFamily::CursiveFont))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX],
        Sbk_QWebEngineSettings_TypeF(), "FantasyFont", (long) QWebEngineSettings::FontFamily::FantasyFont))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX],
        Sbk_QWebEngineSettings_TypeF(), "PictographFont", (long) QWebEngineSettings::FontFamily::PictographFont))
        return;
    // Register converter for enum 'QWebEngineSettings::FontFamily'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX],
            QWebEngineSettings_FontFamily_CppToPython_QWebEngineSettings_FontFamily);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineSettings_FontFamily_PythonToCpp_QWebEngineSettings_FontFamily,
            is_QWebEngineSettings_FontFamily_PythonToCpp_QWebEngineSettings_FontFamily_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTFAMILY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineSettings::FontFamily");
        Shiboken::Conversions::registerConverterName(converter, "FontFamily");
    }
    // End of 'FontFamily' enum.

    // Initialization of enum 'WebAttribute'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineSettings_TypeF(),
        "WebAttribute",
        "2:PySide2.QtWebEngineWidgets.QWebEngineSettings.WebAttribute",
        "QWebEngineSettings::WebAttribute");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "AutoLoadImages", (long) QWebEngineSettings::WebAttribute::AutoLoadImages))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "JavascriptEnabled", (long) QWebEngineSettings::WebAttribute::JavascriptEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "JavascriptCanOpenWindows", (long) QWebEngineSettings::WebAttribute::JavascriptCanOpenWindows))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "JavascriptCanAccessClipboard", (long) QWebEngineSettings::WebAttribute::JavascriptCanAccessClipboard))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "LinksIncludedInFocusChain", (long) QWebEngineSettings::WebAttribute::LinksIncludedInFocusChain))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "LocalStorageEnabled", (long) QWebEngineSettings::WebAttribute::LocalStorageEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "LocalContentCanAccessRemoteUrls", (long) QWebEngineSettings::WebAttribute::LocalContentCanAccessRemoteUrls))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "XSSAuditingEnabled", (long) QWebEngineSettings::WebAttribute::XSSAuditingEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "SpatialNavigationEnabled", (long) QWebEngineSettings::WebAttribute::SpatialNavigationEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "LocalContentCanAccessFileUrls", (long) QWebEngineSettings::WebAttribute::LocalContentCanAccessFileUrls))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "HyperlinkAuditingEnabled", (long) QWebEngineSettings::WebAttribute::HyperlinkAuditingEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "ScrollAnimatorEnabled", (long) QWebEngineSettings::WebAttribute::ScrollAnimatorEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "ErrorPageEnabled", (long) QWebEngineSettings::WebAttribute::ErrorPageEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "PluginsEnabled", (long) QWebEngineSettings::WebAttribute::PluginsEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "FullScreenSupportEnabled", (long) QWebEngineSettings::WebAttribute::FullScreenSupportEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "ScreenCaptureEnabled", (long) QWebEngineSettings::WebAttribute::ScreenCaptureEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "WebGLEnabled", (long) QWebEngineSettings::WebAttribute::WebGLEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "Accelerated2dCanvasEnabled", (long) QWebEngineSettings::WebAttribute::Accelerated2dCanvasEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "AutoLoadIconsForPage", (long) QWebEngineSettings::WebAttribute::AutoLoadIconsForPage))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "TouchIconsEnabled", (long) QWebEngineSettings::WebAttribute::TouchIconsEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "FocusOnNavigationEnabled", (long) QWebEngineSettings::WebAttribute::FocusOnNavigationEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "PrintElementBackgrounds", (long) QWebEngineSettings::WebAttribute::PrintElementBackgrounds))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "AllowRunningInsecureContent", (long) QWebEngineSettings::WebAttribute::AllowRunningInsecureContent))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "AllowGeolocationOnInsecureOrigins", (long) QWebEngineSettings::WebAttribute::AllowGeolocationOnInsecureOrigins))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "AllowWindowActivationFromJavaScript", (long) QWebEngineSettings::WebAttribute::AllowWindowActivationFromJavaScript))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "ShowScrollBars", (long) QWebEngineSettings::WebAttribute::ShowScrollBars))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "PlaybackRequiresUserGesture", (long) QWebEngineSettings::WebAttribute::PlaybackRequiresUserGesture))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "WebRTCPublicInterfacesOnly", (long) QWebEngineSettings::WebAttribute::WebRTCPublicInterfacesOnly))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "JavascriptCanPaste", (long) QWebEngineSettings::WebAttribute::JavascriptCanPaste))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "DnsPrefetchEnabled", (long) QWebEngineSettings::WebAttribute::DnsPrefetchEnabled))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "PdfViewerEnabled", (long) QWebEngineSettings::WebAttribute::PdfViewerEnabled))
        return;
    // Register converter for enum 'QWebEngineSettings::WebAttribute'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX],
            QWebEngineSettings_WebAttribute_CppToPython_QWebEngineSettings_WebAttribute);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineSettings_WebAttribute_PythonToCpp_QWebEngineSettings_WebAttribute,
            is_QWebEngineSettings_WebAttribute_PythonToCpp_QWebEngineSettings_WebAttribute_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_WEBATTRIBUTE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineSettings::WebAttribute");
        Shiboken::Conversions::registerConverterName(converter, "WebAttribute");
    }
    // End of 'WebAttribute' enum.

    // Initialization of enum 'FontSize'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTSIZE_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineSettings_TypeF(),
        "FontSize",
        "2:PySide2.QtWebEngineWidgets.QWebEngineSettings.FontSize",
        "QWebEngineSettings::FontSize");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTSIZE_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTSIZE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "MinimumFontSize", (long) QWebEngineSettings::FontSize::MinimumFontSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTSIZE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "MinimumLogicalFontSize", (long) QWebEngineSettings::FontSize::MinimumLogicalFontSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTSIZE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "DefaultFontSize", (long) QWebEngineSettings::FontSize::DefaultFontSize))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTSIZE_IDX],
        Sbk_QWebEngineSettings_TypeF(), "DefaultFixedFontSize", (long) QWebEngineSettings::FontSize::DefaultFixedFontSize))
        return;
    // Register converter for enum 'QWebEngineSettings::FontSize'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTSIZE_IDX],
            QWebEngineSettings_FontSize_CppToPython_QWebEngineSettings_FontSize);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineSettings_FontSize_PythonToCpp_QWebEngineSettings_FontSize,
            is_QWebEngineSettings_FontSize_PythonToCpp_QWebEngineSettings_FontSize_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_FONTSIZE_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineSettings::FontSize");
        Shiboken::Conversions::registerConverterName(converter, "FontSize");
    }
    // End of 'FontSize' enum.

    // Initialization of enum 'UnknownUrlSchemePolicy'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_UNKNOWNURLSCHEMEPOLICY_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineSettings_TypeF(),
        "UnknownUrlSchemePolicy",
        "2:PySide2.QtWebEngineWidgets.QWebEngineSettings.UnknownUrlSchemePolicy",
        "QWebEngineSettings::UnknownUrlSchemePolicy");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_UNKNOWNURLSCHEMEPOLICY_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_UNKNOWNURLSCHEMEPOLICY_IDX],
        Sbk_QWebEngineSettings_TypeF(), "DisallowUnknownUrlSchemes", (long) QWebEngineSettings::UnknownUrlSchemePolicy::DisallowUnknownUrlSchemes))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_UNKNOWNURLSCHEMEPOLICY_IDX],
        Sbk_QWebEngineSettings_TypeF(), "AllowUnknownUrlSchemesFromUserInteraction", (long) QWebEngineSettings::UnknownUrlSchemePolicy::AllowUnknownUrlSchemesFromUserInteraction))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_UNKNOWNURLSCHEMEPOLICY_IDX],
        Sbk_QWebEngineSettings_TypeF(), "AllowAllUnknownUrlSchemes", (long) QWebEngineSettings::UnknownUrlSchemePolicy::AllowAllUnknownUrlSchemes))
        return;
    // Register converter for enum 'QWebEngineSettings::UnknownUrlSchemePolicy'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_UNKNOWNURLSCHEMEPOLICY_IDX],
            QWebEngineSettings_UnknownUrlSchemePolicy_CppToPython_QWebEngineSettings_UnknownUrlSchemePolicy);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineSettings_UnknownUrlSchemePolicy_PythonToCpp_QWebEngineSettings_UnknownUrlSchemePolicy,
            is_QWebEngineSettings_UnknownUrlSchemePolicy_PythonToCpp_QWebEngineSettings_UnknownUrlSchemePolicy_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESETTINGS_UNKNOWNURLSCHEMEPOLICY_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineSettings::UnknownUrlSchemePolicy");
        Shiboken::Conversions::registerConverterName(converter, "UnknownUrlSchemePolicy");
    }
    // End of 'UnknownUrlSchemePolicy' enum.

    qRegisterMetaType< ::QWebEngineSettings::FontFamily >("QWebEngineSettings::FontFamily");
    qRegisterMetaType< ::QWebEngineSettings::WebAttribute >("QWebEngineSettings::WebAttribute");
    qRegisterMetaType< ::QWebEngineSettings::FontSize >("QWebEngineSettings::FontSize");
    qRegisterMetaType< ::QWebEngineSettings::UnknownUrlSchemePolicy >("QWebEngineSettings::UnknownUrlSchemePolicy");
}
