/****************************************************************************
**
** Copyright (C) 2016 The Qt Company Ltd.
** Contact: https://www.qt.io/licensing/
**
** This file is part of Qt for Python.
**
** $QT_BEGIN_LICENSE:LGPL$
** Commercial License Usage
** Licensees holding valid commercial Qt licenses may use this file in
** accordance with the commercial license agreement provided with the
** Software or, alternatively, in accordance with the terms contained in
** a written agreement between you and The Qt Company. For licensing terms
** and conditions see https://www.qt.io/terms-conditions. For further
** information use the contact form at https://www.qt.io/contact-us.
**
** GNU Lesser General Public License Usage
** Alternatively, this file may be used under the terms of the GNU Lesser
** General Public License version 3 as published by the Free Software
** Foundation and appearing in the file LICENSE.LGPL3 included in the
** packaging of this file. Please review the following information to
** ensure the GNU Lesser General Public License version 3 requirements
** will be met: https://www.gnu.org/licenses/lgpl-3.0.html.
**
** GNU General Public License Usage
** Alternatively, this file may be used under the terms of the GNU
** General Public License version 2.0 or (at your option) the GNU General
** Public license version 3 or any later version approved by the KDE Free
** Qt Foundation. The licenses are as published by the Free Software
** Foundation and appearing in the file LICENSE.GPL2 and LICENSE.GPL3
** included in the packaging of this file. Please review the following
** information to ensure the GNU General Public License requirements will
** be met: https://www.gnu.org/licenses/gpl-2.0.html and
** https://www.gnu.org/licenses/gpl-3.0.html.
**
** $QT_END_LICENSE$
**
****************************************************************************/

//workaround to access protected functions
#define protected public

// default includes
#include <shiboken.h>
#ifndef QT_NO_VERSION_TAGGING
#  define QT_NO_VERSION_TAGGING
#endif
#include <QDebug>
#include <pysidesignal.h>
#include <pysideproperty.h>
#include <pyside.h>
#include <pysideqenum.h>
#include <feature_select.h>
QT_WARNING_DISABLE_DEPRECATED

#include <typeinfo>
#include <iterator>

// module include
#include "pyside2_qtwebenginewidgets_python.h"

// main header
#include "qwebenginescript_wrapper.h"

// inner classes

// Extra includes
#include <QtWebEngineWidgets/qwebenginescript.h>


#include <cctype>
#include <cstring>



template <class T>
static const char *typeNameOf(const T &t)
{
    const char *typeName =  typeid(t).name();
    auto size = std::strlen(typeName);
#if defined(Q_CC_MSVC) // MSVC: "class QPaintDevice * __ptr64"
    if (auto lastStar = strchr(typeName, '*')) {
        // MSVC: "class QPaintDevice * __ptr64"
        while (*--lastStar == ' ') {
        }
        size = lastStar - typeName + 1;
    }
#else // g++, Clang: "QPaintDevice *" -> "P12QPaintDevice"
    if (size > 2 && typeName[0] == 'P' && std::isdigit(typeName[1])) {
        ++typeName;
        --size;
    }
#endif
    char *result = new char[size + 1];
    result[size] = '\0';
    memcpy(result, typeName, size);
    return result;
}


// Target ---------------------------------------------------------

extern "C" {
static int
Sbk_QWebEngineScript_Init(PyObject *self, PyObject *args, PyObject *kwds)
{
    SbkObject *sbkSelf = reinterpret_cast<SbkObject *>(self);
PySide::Feature::Select(self);
    if (Shiboken::Object::isUserType(self) && !Shiboken::ObjectType::canCallConstructor(self->ob_type, Shiboken::SbkType< ::QWebEngineScript >()))
        return -1;

    ::QWebEngineScript *cptr{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScript.__init__";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp[] = { nullptr };
    SBK_UNUSED(pythonToCpp)
    const Py_ssize_t numArgs = PyTuple_GET_SIZE(args);
    SBK_UNUSED(numArgs)
    PyObject *pyArgs[] = {0};

    // invalid argument lengths


    if (!PyArg_UnpackTuple(args, "QWebEngineScript", 0, 1, &(pyArgs[0])))
        return -1;


    // Overloaded function decisor
    // 0: QWebEngineScript::QWebEngineScript()
    // 1: QWebEngineScript::QWebEngineScript(QWebEngineScript)
    if (numArgs == 0) {
        overloadId = 0; // QWebEngineScript()
    } else if (numArgs == 1
        && (pythonToCpp[0] = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), (pyArgs[0])))) {
        overloadId = 1; // QWebEngineScript(QWebEngineScript)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineScript_Init_TypeError;

    // Call function/method
    switch (overloadId) {
        case 0: // QWebEngineScript()
        {

            if (!PyErr_Occurred()) {
                // QWebEngineScript()
                cptr = new ::QWebEngineScript();
            }
            break;
        }
        case 1: // QWebEngineScript(const QWebEngineScript & other)
        {
            if (!Shiboken::Object::isValid(pyArgs[0]))
                return -1;
            ::QWebEngineScript cppArg0_local;
            ::QWebEngineScript *cppArg0 = &cppArg0_local;
            if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), pythonToCpp[0]))
                pythonToCpp[0](pyArgs[0], &cppArg0_local);
            else
                pythonToCpp[0](pyArgs[0], &cppArg0);


            if (!PyErr_Occurred()) {
                // QWebEngineScript(QWebEngineScript)
                cptr = new ::QWebEngineScript(*cppArg0);
            }
            break;
        }
    }

    if (PyErr_Occurred() || !Shiboken::Object::setCppPointer(sbkSelf, Shiboken::SbkType< ::QWebEngineScript >(), cptr)) {
        delete cptr;
        Py_XDECREF(errInfo);
        return -1;
    }
    if (!cptr) goto Sbk_QWebEngineScript_Init_TypeError;

    Shiboken::Object::setValidCpp(sbkSelf, true);
    if (Shiboken::BindingManager::instance().hasWrapper(cptr)) {
        Shiboken::BindingManager::instance().releaseWrapper(Shiboken::BindingManager::instance().retrieveWrapper(cptr));
    }
    Shiboken::BindingManager::instance().registerWrapper(sbkSelf, cptr);


    return 1;

    Sbk_QWebEngineScript_Init_TypeError:
        Shiboken::setErrorAboutWrongArguments(args, fullName, errInfo);
        Py_XDECREF(errInfo);
        return -1;
}

static PyObject *Sbk_QWebEngineScriptFunc_injectionPoint(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScript.injectionPoint";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // injectionPoint()const
            QWebEngineScript::InjectionPoint cppResult = const_cast<const ::QWebEngineScript *>(cppSelf)->injectionPoint();
            pyResult = Shiboken::Conversions::copyToPython(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_INJECTIONPOINT_IDX])->converter, &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineScriptFunc_isNull(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScript.isNull";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // isNull()const
            bool cppResult = const_cast<const ::QWebEngineScript *>(cppSelf)->isNull();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineScriptFunc_name(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScript.name";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // name()const
            QString cppResult = const_cast<const ::QWebEngineScript *>(cppSelf)->name();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineScriptFunc_runsOnSubFrames(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScript.runsOnSubFrames";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // runsOnSubFrames()const
            bool cppResult = const_cast<const ::QWebEngineScript *>(cppSelf)->runsOnSubFrames();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineScriptFunc_setInjectionPoint(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScript.setInjectionPoint";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineScript::setInjectionPoint(QWebEngineScript::InjectionPoint)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(*PepType_SGTP(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_INJECTIONPOINT_IDX])->converter, (pyArg)))) {
        overloadId = 0; // setInjectionPoint(QWebEngineScript::InjectionPoint)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineScriptFunc_setInjectionPoint_TypeError;

    // Call function/method
    {
        ::QWebEngineScript::InjectionPoint cppArg0{QWebEngineScript::Deferred};
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setInjectionPoint(QWebEngineScript::InjectionPoint)
            cppSelf->setInjectionPoint(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineScriptFunc_setInjectionPoint_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineScriptFunc_setName(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScript.setName";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineScript::setName(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setName(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineScriptFunc_setName_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setName(QString)
            cppSelf->setName(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineScriptFunc_setName_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineScriptFunc_setRunsOnSubFrames(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScript.setRunsOnSubFrames";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineScript::setRunsOnSubFrames(bool)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), (pyArg)))) {
        overloadId = 0; // setRunsOnSubFrames(bool)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineScriptFunc_setRunsOnSubFrames_TypeError;

    // Call function/method
    {
        bool cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setRunsOnSubFrames(bool)
            cppSelf->setRunsOnSubFrames(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineScriptFunc_setRunsOnSubFrames_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineScriptFunc_setSourceCode(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScript.setSourceCode";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineScript::setSourceCode(QString)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], (pyArg)))) {
        overloadId = 0; // setSourceCode(QString)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineScriptFunc_setSourceCode_TypeError;

    // Call function/method
    {
        ::QString cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setSourceCode(QString)
            cppSelf->setSourceCode(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineScriptFunc_setSourceCode_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineScriptFunc_setWorldId(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScript.setWorldId";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineScript::setWorldId(quint32)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppConvertible(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), (pyArg)))) {
        overloadId = 0; // setWorldId(quint32)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineScriptFunc_setWorldId_TypeError;

    // Call function/method
    {
        quint32 cppArg0;
        pythonToCpp(pyArg, &cppArg0);

        if (!PyErr_Occurred()) {
            // setWorldId(quint32)
            cppSelf->setWorldId(cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineScriptFunc_setWorldId_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineScriptFunc_sourceCode(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScript.sourceCode";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // sourceCode()const
            QString cppResult = const_cast<const ::QWebEngineScript *>(cppSelf)->sourceCode();
            pyResult = Shiboken::Conversions::copyToPython(SbkPySide2_QtCoreTypeConverters[SBK_QSTRING_IDX], &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineScriptFunc_swap(PyObject *self, PyObject *pyArg)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScript.swap";
    SBK_UNUSED(fullName)
    int overloadId = -1;
    PythonToCppFunc pythonToCpp{};
    SBK_UNUSED(pythonToCpp)

    // Overloaded function decisor
    // 0: QWebEngineScript::swap(QWebEngineScript&)
    if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), (pyArg)))) {
        overloadId = 0; // swap(QWebEngineScript&)
    }

    // Function signature not found.
    if (overloadId == -1) goto Sbk_QWebEngineScriptFunc_swap_TypeError;

    // Call function/method
    {
        if (!Shiboken::Object::isValid(pyArg))
            return {};
        ::QWebEngineScript cppArg0_local;
        ::QWebEngineScript *cppArg0 = &cppArg0_local;
        if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), pythonToCpp))
            pythonToCpp(pyArg, &cppArg0_local);
        else
            pythonToCpp(pyArg, &cppArg0);


        if (!PyErr_Occurred()) {
            // swap(QWebEngineScript&)
            cppSelf->swap(*cppArg0);
        }
    }

    if (PyErr_Occurred()) {
        return {};
    }
    Py_RETURN_NONE;

    Sbk_QWebEngineScriptFunc_swap_TypeError:
        Shiboken::setErrorAboutWrongArguments(pyArg, fullName, errInfo);
        Py_XDECREF(errInfo);
        return {};
}

static PyObject *Sbk_QWebEngineScriptFunc_worldId(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PyObject *errInfo{};
    SBK_UNUSED(errInfo)
    static const char *fullName = "PySide2.QtWebEngineWidgets.QWebEngineScript.worldId";
    SBK_UNUSED(fullName)

    // Call function/method
    {

        if (!PyErr_Occurred()) {
            // worldId()const
            quint32 cppResult = const_cast<const ::QWebEngineScript *>(cppSelf)->worldId();
            pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<quint32>(), &cppResult);
        }
    }

    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}

static PyObject *Sbk_QWebEngineScript___copy__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    PyObject *pyResult = Shiboken::Conversions::copyToPython(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), &cppSelf);
    if (PyErr_Occurred() || !pyResult) {
        Py_XDECREF(pyResult);
        return {};
    }
    return pyResult;
}


static const char *Sbk_QWebEngineScript_PropertyStrings[] = {
    nullptr // Sentinel
};

static PyMethodDef Sbk_QWebEngineScript_methods[] = {
    {"injectionPoint", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptFunc_injectionPoint), METH_NOARGS},
    {"isNull", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptFunc_isNull), METH_NOARGS},
    {"name", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptFunc_name), METH_NOARGS},
    {"runsOnSubFrames", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptFunc_runsOnSubFrames), METH_NOARGS},
    {"setInjectionPoint", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptFunc_setInjectionPoint), METH_O},
    {"setName", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptFunc_setName), METH_O},
    {"setRunsOnSubFrames", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptFunc_setRunsOnSubFrames), METH_O},
    {"setSourceCode", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptFunc_setSourceCode), METH_O},
    {"setWorldId", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptFunc_setWorldId), METH_O},
    {"sourceCode", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptFunc_sourceCode), METH_NOARGS},
    {"swap", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptFunc_swap), METH_O},
    {"worldId", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScriptFunc_worldId), METH_NOARGS},

    {"__copy__", reinterpret_cast<PyCFunction>(Sbk_QWebEngineScript___copy__), METH_NOARGS},
    {nullptr, nullptr} // Sentinel
};

static int Sbk_QWebEngineScript___nb_bool(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return -1;
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    return !cppSelf->isNull();
}

// Rich comparison
static PyObject * Sbk_QWebEngineScript_richcompare(PyObject *self, PyObject *pyArg, int op)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto &cppSelf = *reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    PyObject *pyResult{};
    PythonToCppFunc pythonToCpp;
    SBK_UNUSED(pythonToCpp)

    switch (op) {
        case Py_NE:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), (pyArg)))) {
                // operator!=(const QWebEngineScript & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QWebEngineScript cppArg0_local;
                ::QWebEngineScript *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf !=(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_True;
                Py_INCREF(pyResult);
            }

            break;
        case Py_EQ:
            if ((pythonToCpp = Shiboken::Conversions::isPythonToCppReferenceConvertible(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), (pyArg)))) {
                // operator==(const QWebEngineScript & other) const
                if (!Shiboken::Object::isValid(pyArg))
                    return {};
                ::QWebEngineScript cppArg0_local;
                ::QWebEngineScript *cppArg0 = &cppArg0_local;
                if (Shiboken::Conversions::isImplicitConversion(reinterpret_cast<SbkObjectType *>(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]), pythonToCpp))
                    pythonToCpp(pyArg, &cppArg0_local);
                else
                    pythonToCpp(pyArg, &cppArg0);

                bool cppResult = cppSelf ==(*cppArg0);
                pyResult = Shiboken::Conversions::copyToPython(Shiboken::Conversions::PrimitiveTypeConverter<bool>(), &cppResult);
            } else {
                pyResult = Py_False;
                Py_INCREF(pyResult);
            }

            break;
        default:
            // PYSIDE-74: By default, we redirect to object's tp_richcompare (which is `==`, `!=`).
            return FallbackRichCompare(self, pyArg, op);
            goto Sbk_QWebEngineScript_RichComparison_TypeError;
    }

    if (pyResult && !PyErr_Occurred())
        return pyResult;
    Sbk_QWebEngineScript_RichComparison_TypeError:
    PyErr_SetString(PyExc_NotImplementedError, "operator not implemented.");
    return {};

}

} // extern "C"

static int Sbk_QWebEngineScript_traverse(PyObject *self, visitproc visit, void *arg)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_traverse(self, visit, arg);
}
static int Sbk_QWebEngineScript_clear(PyObject *self)
{
    return reinterpret_cast<PyTypeObject *>(SbkObject_TypeF())->tp_clear(self);
}
extern "C"
{
static PyObject *Sbk_QWebEngineScript__repr__(PyObject *self)
{
    if (!Shiboken::Object::isValid(self))
        return {};
    auto cppSelf = reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(self)));
    SBK_UNUSED(cppSelf)
    QBuffer buffer;
    buffer.open(QBuffer::ReadWrite);
    QDebug dbg(&buffer);
    dbg << *cppSelf;
    buffer.close();
    QByteArray str = buffer.data();
    int idx = str.indexOf('(');
    if (idx >= 0)
        str.replace(0, idx, Py_TYPE(self)->tp_name);
    str = str.trimmed();
    PyObject *mod = PyDict_GetItem(Py_TYPE(self)->tp_dict, Shiboken::PyMagicName::module());
    if (mod && !strchr(str, '.'))
        return Shiboken::String::fromFormat("<%s.%s at %p>", Shiboken::String::toCString(mod), str.constData(), self);
    else
        return Shiboken::String::fromFormat("<%s at %p>", str.constData(), self);
}
} // extern C

// Class Definition -----------------------------------------------
extern "C" {
static SbkObjectType *_Sbk_QWebEngineScript_Type = nullptr;
static SbkObjectType *Sbk_QWebEngineScript_TypeF(void)
{
    return _Sbk_QWebEngineScript_Type;
}

static PyType_Slot Sbk_QWebEngineScript_slots[] = {
    {Py_tp_base,        nullptr}, // inserted by introduceWrapperType
    {Py_tp_dealloc,     reinterpret_cast<void *>(&SbkDeallocWrapper)},
    {Py_tp_repr,        reinterpret_cast<void *>(Sbk_QWebEngineScript__repr__)},
    {Py_tp_hash,        nullptr},
    {Py_tp_call,        nullptr},
    {Py_tp_str,         nullptr},
    {Py_tp_getattro,    nullptr},
    {Py_tp_setattro,    nullptr},
    {Py_tp_traverse,    reinterpret_cast<void *>(Sbk_QWebEngineScript_traverse)},
    {Py_tp_clear,       reinterpret_cast<void *>(Sbk_QWebEngineScript_clear)},
    {Py_tp_richcompare, reinterpret_cast<void *>(Sbk_QWebEngineScript_richcompare)},
    {Py_tp_iter,        nullptr},
    {Py_tp_iternext,    nullptr},
    {Py_tp_methods,     reinterpret_cast<void *>(Sbk_QWebEngineScript_methods)},
    {Py_tp_getset,      nullptr},
    {Py_tp_init,        reinterpret_cast<void *>(Sbk_QWebEngineScript_Init)},
    {Py_tp_new,         reinterpret_cast<void *>(SbkObjectTpNew)},
    // type supports number protocol
#ifdef IS_PY3K
    {Py_nb_bool, (void *)Sbk_QWebEngineScript___nb_bool},
#else
    {Py_nb_nonzero, (void *)Sbk_QWebEngineScript___nb_bool},
#endif
    {0, nullptr}
};
static PyType_Spec Sbk_QWebEngineScript_spec = {
    "2:PySide2.QtWebEngineWidgets.QWebEngineScript",
    sizeof(SbkObject),
    0,
    Py_TPFLAGS_DEFAULT|Py_TPFLAGS_BASETYPE|Py_TPFLAGS_CHECKTYPES|Py_TPFLAGS_HAVE_GC,
    Sbk_QWebEngineScript_slots
};

} //extern "C"


// Type conversion functions.

// Python to C++ enum conversion.
static void QWebEngineScript_InjectionPoint_PythonToCpp_QWebEngineScript_InjectionPoint(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineScript::InjectionPoint *>(cppOut) =
        static_cast<::QWebEngineScript::InjectionPoint>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineScript_InjectionPoint_PythonToCpp_QWebEngineScript_InjectionPoint_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_INJECTIONPOINT_IDX]))
        return QWebEngineScript_InjectionPoint_PythonToCpp_QWebEngineScript_InjectionPoint;
    return {};
}
static PyObject *QWebEngineScript_InjectionPoint_CppToPython_QWebEngineScript_InjectionPoint(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineScript::InjectionPoint *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_INJECTIONPOINT_IDX], castCppIn);

}

static void QWebEngineScript_ScriptWorldId_PythonToCpp_QWebEngineScript_ScriptWorldId(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineScript::ScriptWorldId *>(cppOut) =
        static_cast<::QWebEngineScript::ScriptWorldId>(Shiboken::Enum::getValue(pyIn));

}
static PythonToCppFunc is_QWebEngineScript_ScriptWorldId_PythonToCpp_QWebEngineScript_ScriptWorldId_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_SCRIPTWORLDID_IDX]))
        return QWebEngineScript_ScriptWorldId_PythonToCpp_QWebEngineScript_ScriptWorldId;
    return {};
}
static PyObject *QWebEngineScript_ScriptWorldId_CppToPython_QWebEngineScript_ScriptWorldId(const void *cppIn) {
    const int castCppIn = int(*reinterpret_cast<const ::QWebEngineScript::ScriptWorldId *>(cppIn));
    return Shiboken::Enum::newItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_SCRIPTWORLDID_IDX], castCppIn);

}

// Python to C++ pointer conversion - returns the C++ object of the Python wrapper (keeps object identity).
static void QWebEngineScript_PythonToCpp_QWebEngineScript_PTR(PyObject *pyIn, void *cppOut) {
    Shiboken::Conversions::pythonToCppPointer(Sbk_QWebEngineScript_TypeF(), pyIn, cppOut);
}
static PythonToCppFunc is_QWebEngineScript_PythonToCpp_QWebEngineScript_PTR_Convertible(PyObject *pyIn) {
    if (pyIn == Py_None)
        return Shiboken::Conversions::nonePythonToCppNullPtr;
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineScript_TypeF())))
        return QWebEngineScript_PythonToCpp_QWebEngineScript_PTR;
    return {};
}

// C++ to Python pointer conversion - tries to find the Python wrapper for the C++ object (keeps object identity).
static PyObject *QWebEngineScript_PTR_CppToPython_QWebEngineScript(const void *cppIn) {
    auto pyOut = reinterpret_cast<PyObject *>(Shiboken::BindingManager::instance().retrieveWrapper(cppIn));
    if (pyOut) {
        Py_INCREF(pyOut);
        return pyOut;
    }
    bool changedTypeName = false;
    auto tCppIn = reinterpret_cast<const ::QWebEngineScript *>(cppIn);
    const char *typeName = typeid(*tCppIn).name();
    auto sbkType = Shiboken::ObjectType::typeForTypeName(typeName);
    if (sbkType && Shiboken::ObjectType::hasSpecialCastFunction(sbkType)) {
        typeName = typeNameOf(tCppIn);
        changedTypeName = true;
    }
    PyObject *result = Shiboken::Object::newObject(Sbk_QWebEngineScript_TypeF(), const_cast<void *>(cppIn), false, /* exactType */ changedTypeName, typeName);
    if (changedTypeName)
        delete [] typeName;
    return result;
}

// C++ to Python copy conversion.
static PyObject *QWebEngineScript_COPY_CppToPython_QWebEngineScript(const void *cppIn) {
    return Shiboken::Object::newObject(Sbk_QWebEngineScript_TypeF(), new ::QWebEngineScript(*reinterpret_cast<const ::QWebEngineScript *>(cppIn)), true, true);
}

// Python to C++ copy conversion.
static void QWebEngineScript_PythonToCpp_QWebEngineScript_COPY(PyObject *pyIn, void *cppOut) {
    *reinterpret_cast<::QWebEngineScript *>(cppOut) = *reinterpret_cast< ::QWebEngineScript *>(Shiboken::Conversions::cppPointer(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX], reinterpret_cast<SbkObject *>(pyIn)));
}
static PythonToCppFunc is_QWebEngineScript_PythonToCpp_QWebEngineScript_COPY_Convertible(PyObject *pyIn) {
    if (PyObject_TypeCheck(pyIn, reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineScript_TypeF())))
        return QWebEngineScript_PythonToCpp_QWebEngineScript_COPY;
    return {};
}

// The signatures string for the functions.
// Multiple signatures have their index "n:" in front.
static const char *QWebEngineScript_SignatureStrings[] = {
    "1:PySide2.QtWebEngineWidgets.QWebEngineScript(self)",
    "0:PySide2.QtWebEngineWidgets.QWebEngineScript(self,other:PySide2.QtWebEngineWidgets.QWebEngineScript)",
    "PySide2.QtWebEngineWidgets.QWebEngineScript.injectionPoint(self)->PySide2.QtWebEngineWidgets.QWebEngineScript.InjectionPoint",
    "PySide2.QtWebEngineWidgets.QWebEngineScript.isNull(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineScript.name(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineScript.runsOnSubFrames(self)->bool",
    "PySide2.QtWebEngineWidgets.QWebEngineScript.setInjectionPoint(self,arg__1:PySide2.QtWebEngineWidgets.QWebEngineScript.InjectionPoint)",
    "PySide2.QtWebEngineWidgets.QWebEngineScript.setName(self,arg__1:QString)",
    "PySide2.QtWebEngineWidgets.QWebEngineScript.setRunsOnSubFrames(self,on:bool)",
    "PySide2.QtWebEngineWidgets.QWebEngineScript.setSourceCode(self,arg__1:QString)",
    "PySide2.QtWebEngineWidgets.QWebEngineScript.setWorldId(self,arg__1:quint32)",
    "PySide2.QtWebEngineWidgets.QWebEngineScript.sourceCode(self)->QString",
    "PySide2.QtWebEngineWidgets.QWebEngineScript.swap(self,other:PySide2.QtWebEngineWidgets.QWebEngineScript)",
    "PySide2.QtWebEngineWidgets.QWebEngineScript.worldId(self)->quint32",
    "PySide2.QtWebEngineWidgets.QWebEngineScript.__copy__()",
    nullptr}; // Sentinel

void init_QWebEngineScript(PyObject *module)
{
    _Sbk_QWebEngineScript_Type = Shiboken::ObjectType::introduceWrapperType(
        module,
        "QWebEngineScript",
        "QWebEngineScript",
        &Sbk_QWebEngineScript_spec,
        &Shiboken::callCppDestructor< ::QWebEngineScript >,
        0,
        0,
        0    );
    
    auto pyType = reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineScript_Type);
    InitSignatureStrings(pyType, QWebEngineScript_SignatureStrings);
    SbkObjectType_SetPropertyStrings(reinterpret_cast<PyTypeObject *>(_Sbk_QWebEngineScript_Type), Sbk_QWebEngineScript_PropertyStrings);
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_IDX]
        = reinterpret_cast<PyTypeObject *>(Sbk_QWebEngineScript_TypeF());

    // Register Converter
    SbkConverter *converter = Shiboken::Conversions::createConverter(Sbk_QWebEngineScript_TypeF(),
        QWebEngineScript_PythonToCpp_QWebEngineScript_PTR,
        is_QWebEngineScript_PythonToCpp_QWebEngineScript_PTR_Convertible,
        QWebEngineScript_PTR_CppToPython_QWebEngineScript,
        QWebEngineScript_COPY_CppToPython_QWebEngineScript);

    Shiboken::Conversions::registerConverterName(converter, "QWebEngineScript");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineScript*");
    Shiboken::Conversions::registerConverterName(converter, "QWebEngineScript&");
    Shiboken::Conversions::registerConverterName(converter, typeid(::QWebEngineScript).name());

    // Add Python to C++ copy (value, not pointer neither reference) conversion to type converter.
    Shiboken::Conversions::addPythonToCppValueConversion(converter,
        QWebEngineScript_PythonToCpp_QWebEngineScript_COPY,
        is_QWebEngineScript_PythonToCpp_QWebEngineScript_COPY_Convertible);

    // Initialization of enums.

    // Initialization of enum 'InjectionPoint'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_INJECTIONPOINT_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineScript_TypeF(),
        "InjectionPoint",
        "2:PySide2.QtWebEngineWidgets.QWebEngineScript.InjectionPoint",
        "QWebEngineScript::InjectionPoint");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_INJECTIONPOINT_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_INJECTIONPOINT_IDX],
        Sbk_QWebEngineScript_TypeF(), "Deferred", (long) QWebEngineScript::InjectionPoint::Deferred))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_INJECTIONPOINT_IDX],
        Sbk_QWebEngineScript_TypeF(), "DocumentReady", (long) QWebEngineScript::InjectionPoint::DocumentReady))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_INJECTIONPOINT_IDX],
        Sbk_QWebEngineScript_TypeF(), "DocumentCreation", (long) QWebEngineScript::InjectionPoint::DocumentCreation))
        return;
    // Register converter for enum 'QWebEngineScript::InjectionPoint'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_INJECTIONPOINT_IDX],
            QWebEngineScript_InjectionPoint_CppToPython_QWebEngineScript_InjectionPoint);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineScript_InjectionPoint_PythonToCpp_QWebEngineScript_InjectionPoint,
            is_QWebEngineScript_InjectionPoint_PythonToCpp_QWebEngineScript_InjectionPoint_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_INJECTIONPOINT_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineScript::InjectionPoint");
        Shiboken::Conversions::registerConverterName(converter, "InjectionPoint");
    }
    // End of 'InjectionPoint' enum.

    // Initialization of enum 'ScriptWorldId'.
    SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_SCRIPTWORLDID_IDX] = Shiboken::Enum::createScopedEnum(Sbk_QWebEngineScript_TypeF(),
        "ScriptWorldId",
        "2:PySide2.QtWebEngineWidgets.QWebEngineScript.ScriptWorldId",
        "QWebEngineScript::ScriptWorldId");
    if (!SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_SCRIPTWORLDID_IDX])
        return;

    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_SCRIPTWORLDID_IDX],
        Sbk_QWebEngineScript_TypeF(), "MainWorld", (long) QWebEngineScript::ScriptWorldId::MainWorld))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_SCRIPTWORLDID_IDX],
        Sbk_QWebEngineScript_TypeF(), "ApplicationWorld", (long) QWebEngineScript::ScriptWorldId::ApplicationWorld))
        return;
    if (!Shiboken::Enum::createScopedEnumItem(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_SCRIPTWORLDID_IDX],
        Sbk_QWebEngineScript_TypeF(), "UserWorld", (long) QWebEngineScript::ScriptWorldId::UserWorld))
        return;
    // Register converter for enum 'QWebEngineScript::ScriptWorldId'.
    {
        SbkConverter *converter = Shiboken::Conversions::createConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_SCRIPTWORLDID_IDX],
            QWebEngineScript_ScriptWorldId_CppToPython_QWebEngineScript_ScriptWorldId);
        Shiboken::Conversions::addPythonToCppValueConversion(converter,
            QWebEngineScript_ScriptWorldId_PythonToCpp_QWebEngineScript_ScriptWorldId,
            is_QWebEngineScript_ScriptWorldId_PythonToCpp_QWebEngineScript_ScriptWorldId_Convertible);
        Shiboken::Enum::setTypeConverter(SbkPySide2_QtWebEngineWidgetsTypes[SBK_QWEBENGINESCRIPT_SCRIPTWORLDID_IDX], converter);
        Shiboken::Conversions::registerConverterName(converter, "QWebEngineScript::ScriptWorldId");
        Shiboken::Conversions::registerConverterName(converter, "ScriptWorldId");
    }
    // End of 'ScriptWorldId' enum.

    qRegisterMetaType< ::QWebEngineScript >("QWebEngineScript");
    qRegisterMetaType< ::QWebEngineScript::InjectionPoint >("QWebEngineScript::InjectionPoint");
    qRegisterMetaType< ::QWebEngineScript::ScriptWorldId >("QWebEngineScript::ScriptWorldId");
}
